/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.canvas;

import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.canvas.CommonUtil;
import com.spss.uitools.ui_builder.definition.CheckBoxDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class CheckBoxObject
extends CanvasObject {
    private static ImageIcon sItemImage = null;

    public CheckBoxObject(CheckBoxDefinition checkBoxDefinition) {
        super((PanelElementDefinition)checkBoxDefinition);
        try {
            if (sItemImage == null) {
                sItemImage = new ImageIcon(BuilderResUtil.getImageResource("check_box_image.png"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isChecked() {
        return this.getDef().getChecked();
    }

    public void setChecked(boolean bl) {
        this.getDef().setChecked(bl);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getObjectWidth(), 26);
    }

    private CheckBoxDefinition getDef() {
        return (CheckBoxDefinition)this.getCtrlDef();
    }

    @Override
    void render(Graphics2D graphics2D) {
        Insets insets = this.getBorder().getBorderInsets(this);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        int n = (rectangle.height - sItemImage.getIconHeight()) / 2;
        sItemImage.paintIcon(this, graphics2D, insets.left, n);
        if (string != null && string.length() > 0) {
            this.renderTitle(graphics2D, insets.left + 20, insets.top);
        }
    }

    private void renderTitle(Graphics2D graphics2D, int n, int n2) {
        Font font = this.getFont();
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        String string = this.getControlTitle();
        Rectangle rectangle = this.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y);
        Insets insets = this.getBorder().getBorderInsets(this);
        rectangle.x += n;
        rectangle.y += n2;
        rectangle.width -= n + insets.left + insets.right;
        rectangle.height -= n2 * 2;
        CommonUtil.drawIconAndText((Graphics)graphics2D, (JComponent)this, (Rectangle)rectangle, null, (String)string, (int)2);
    }
}

