/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.canvas;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.canvas.CanvasLayout;
import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.canvas.CheckBoxGroupObject;
import com.spss.shared.custom_gui.ui_builder.canvas.CheckBoxObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ColorPickerCtrlObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ComboBoxObject;
import com.spss.shared.custom_gui.ui_builder.canvas.DatasetSelectorObject;
import com.spss.shared.custom_gui.ui_builder.canvas.DraggableTabbedPane;
import com.spss.shared.custom_gui.ui_builder.canvas.EditCtrlObject;
import com.spss.shared.custom_gui.ui_builder.canvas.FieldChooserObject;
import com.spss.shared.custom_gui.ui_builder.canvas.FileSystemBrowserObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ISelectionListener;
import com.spss.shared.custom_gui.ui_builder.canvas.ItemGroupObject;
import com.spss.shared.custom_gui.ui_builder.canvas.ListBoxObject;
import com.spss.shared.custom_gui.ui_builder.canvas.RadioGroupObject;
import com.spss.shared.custom_gui.ui_builder.canvas.SpinnerCtrlObject;
import com.spss.shared.custom_gui.ui_builder.canvas.SrcListObject;
import com.spss.shared.custom_gui.ui_builder.canvas.StaticCtrlObject;
import com.spss.shared.custom_gui.ui_builder.canvas.StaticImageObject;
import com.spss.shared.custom_gui.ui_builder.canvas.SubDlgButtonObject;
import com.spss.shared.custom_gui.ui_builder.canvas.TableCtrlObject;
import com.spss.shared.custom_gui.ui_builder.canvas.TargetListObject;
import com.spss.shared.custom_gui.ui_builder.canvas.TextAreaCtrlObject;
import com.spss.shared.custom_gui.ui_builder.props_ui.IdentifierTable;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.shared.custom_gui.ui_builder.tools.ToolItem;
import com.spss.shared.custom_gui.ui_builder.tools.ToolType;
import com.spss.uitools.controls.drag_drop.ComponentDragAdapter;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.CheckBoxDefinition;
import com.spss.uitools.ui_builder.definition.CheckBoxGroupDefinition;
import com.spss.uitools.ui_builder.definition.ColorPickerDefinition;
import com.spss.uitools.ui_builder.definition.ComboBoxDefinition;
import com.spss.uitools.ui_builder.definition.ControlDefinition;
import com.spss.uitools.ui_builder.definition.DatasetSelectorDefinition;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.EditCtrlDefinition;
import com.spss.uitools.ui_builder.definition.FieldChooserDefinition;
import com.spss.uitools.ui_builder.definition.FileSystemBrowserDefinition;
import com.spss.uitools.ui_builder.definition.ItemGroupDefinition;
import com.spss.uitools.ui_builder.definition.ListBoxDefinition;
import com.spss.uitools.ui_builder.definition.ListDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.RadioGroupDefinition;
import com.spss.uitools.ui_builder.definition.RadioItemDefinition;
import com.spss.uitools.ui_builder.definition.SpinnerDefinition;
import com.spss.uitools.ui_builder.definition.SrcListDefinition;
import com.spss.uitools.ui_builder.definition.StaticCtrlDefinition;
import com.spss.uitools.ui_builder.definition.StaticImageDefinition;
import com.spss.uitools.ui_builder.definition.SubDlgButtonDefinition;
import com.spss.uitools.ui_builder.definition.TableDefinition;
import com.spss.uitools.ui_builder.definition.TargetListDefinition;
import com.spss.uitools.ui_builder.definition.TextAreaDefinition;
import com.spss.uitools.util.TraceSettings;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class BuilderCanvas
extends JPanel
implements IDropListener,
FocusListener {
    private int mGridSize = 20;
    private BuilderFrame mFrame;
    private DialogDefinition mDialog;
    private PanelDefinition mTab;
    private CanvasDragAdapter mDragAdapter;
    private KeyHandler mKeyHandler;
    private Vector<ISelectionListener> mSelectionListeners;
    private boolean mSnapToGrid;
    private boolean mLayoutOn;
    private boolean mBuildingSpec;
    private Border mFocusedBorder = BorderFactory.createLineBorder(CanvasObject.getSelectedBorderColor());
    private Border mUnfocusedBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private CanvasType mCanvasType;
    private IdentifierTable mIDTable;
    private ControlDefinition.QuoteHandlingType mQuoteHandlingType;

    public BuilderCanvas(BuilderFrame builderFrame, DialogDefinition dialogDefinition, int n, CanvasType canvasType) {
        super(true);
        this.mFrame = builderFrame;
        this.mCanvasType = canvasType;
        this.mSnapToGrid = true;
        this.mLayoutOn = true;
        this.mBuildingSpec = false;
        this.mDialog = dialogDefinition;
        this.mIDTable = null;
        this.mDialog = dialogDefinition != null ? dialogDefinition : new DialogDefinition(BuilderUtil.getInstance().getAppType());
        ControlDefinition.QuoteHandlingType quoteHandlingType = this.mQuoteHandlingType = this.mDialog.getAppType() == AppType.STATS ? ControlDefinition.QuoteHandlingType.Python : ControlDefinition.QuoteHandlingType.R;
        if (this.mFrame.IsCompatibleMode() || !this.mFrame.isTabbedDlg() || this.mDialog.isSubDialog()) {
            this.checkCurrentPanel();
            this.mDialog.setTabbed(false);
            this.mDialog.setIsCompatMode(this.mFrame.IsCompatibleMode());
        } else {
            this.mDialog.setTabbed(true);
            this.mDialog.setIsCompatMode(false);
            if (n == -1 && this.mCanvasType == CanvasType.Normal) {
                this.mTab = new PanelDefinition();
                if (this.mFrame.getTabbedPane().getTabCount() >= 1) {
                    this.mTab.setTitle(BuilderResUtil.getString("IDS_TAB_NAME"));
                } else if (this.mDialog.getAppType() == AppType.MODELER) {
                    this.mTab.setTitle(BuilderResUtil.getString("IDS_DFLT_TAB_NAME"));
                } else {
                    this.mTab.setTitle(BuilderResUtil.getString("IDS_TAB_NAME"));
                }
                this.mDialog.addPanel(this.mTab, -1);
            } else if (this.mDialog != null && n < this.mDialog.getPanelCount() && n != -1) {
                this.mDialog.setCurrentPanel(n);
                this.mTab = this.mDialog.getCurrentPanel();
                if (this.mTab.getTitle().length() == 0) {
                    this.mTab.setTitle(BuilderResUtil.getString("IDS_TAB_NAME"));
                }
            }
        }
        this.init();
        this.buildControlsFromSpec();
        this.fireSelectionChange(null);
    }

    BuilderFrame getBuilderFrame() {
        return this.mFrame;
    }

    private void checkCurrentPanel() {
        if (this.mDialog.getCurrentPanel() == null) {
            PanelDefinition panelDefinition = new PanelDefinition();
            this.mDialog.addPanel(panelDefinition, -1);
            this.mDialog.setCurrentPanel(this.mDialog.getPanelCount() - 1);
        }
    }

    public BuilderCanvas(BuilderFrame builderFrame, DialogDefinition dialogDefinition, CanvasType canvasType) {
        this(builderFrame, dialogDefinition, -1, canvasType);
    }

    public void attachIDTable(IdentifierTable identifierTable) {
        this.mIDTable = identifierTable;
    }

    public void addSelectionListener(ISelectionListener iSelectionListener) {
        if (!this.mSelectionListeners.contains(iSelectionListener)) {
            this.mSelectionListeners.add(iSelectionListener);
        }
    }

    public void removeSelectionListener(ISelectionListener iSelectionListener) {
        if (this.mSelectionListeners.contains(iSelectionListener)) {
            this.mSelectionListeners.remove(iSelectionListener);
        }
    }

    public DialogDefinition getDialogDefinition() {
        return this.mDialog;
    }

    public PanelDefinition getTabPanelDefinition() {
        return this.mTab;
    }

    public void setDialogDefinition(DialogDefinition dialogDefinition) {
        this.mDialog = dialogDefinition;
        this.buildControlsFromSpec();
        this.fireSelectionChange(null);
    }

    public boolean isLayoutOn() {
        return this.mLayoutOn;
    }

    public void setLayoutOn(boolean bl) {
        this.mLayoutOn = bl;
    }

    public int getGridSpacing() {
        return this.mGridSize;
    }

    public void setGridSpacing(int n) {
        this.mGridSize = n;
    }

    public boolean isSnapToGrid() {
        return this.mSnapToGrid;
    }

    public void setSnapToGrid(boolean bl) {
        this.mSnapToGrid = bl;
        if (this.mSnapToGrid) {
            this.snapComponents();
        }
    }

    public CanvasType getCanvasType() {
        return this.mCanvasType;
    }

    public void fireSelectionChange(CanvasObject canvasObject) {
        for (ISelectionListener iSelectionListener : this.mSelectionListeners) {
            iSelectionListener.selectionChanged(canvasObject);
        }
        this.repaint();
    }

    public PanelElementDefinition findCanvasObject(String string) {
        PanelElementDefinition panelElementDefinition = null;
        if (this.mTab != null) {
            if (this.mTab.getControlId().equals(string)) {
                return this.mTab;
            }
            panelElementDefinition = this.findElementDefinition(this.mTab, string);
        } else {
            panelElementDefinition = this.findCanvasObjectPanel(string);
        }
        return panelElementDefinition;
    }

    public PanelElementDefinition findCanvasObjectPanel(String string) {
        PanelDefinition panelDefinition;
        PanelElementDefinition panelElementDefinition = null;
        if (this.mDialog.getDialogId().equals(string)) {
            return this.mDialog.getCurrentPanel();
        }
        DialogDefinition dialogDefinition = this.mDialog;
        if (this.mDialog.getParentDefinition() != null) {
            dialogDefinition = this.mDialog.getParentDefinition();
        }
        Iterator iterator = dialogDefinition.getPanels().iterator();
        while (iterator.hasNext() && (panelElementDefinition = this.findElementDefinition(panelDefinition = (PanelDefinition)iterator.next(), string)) == null) {
        }
        return panelElementDefinition;
    }

    public void reconcileControlId(CanvasObject canvasObject) {
        String string = canvasObject.getControlId();
        String string2 = UIToolResUtil.getString((String)"IDS_DEF_ID_PREFIX");
        int n = 1;
        PanelElementDefinition panelElementDefinition = this.findCanvasObject(string);
        while (panelElementDefinition != null && panelElementDefinition != canvasObject.getCtrlDef()) {
            string = string2 + n++;
            panelElementDefinition = this.findCanvasObject(string);
        }
        if (!string.equals(canvasObject.getControlId())) {
            canvasObject.setControlId(string);
        }
    }

    public void reconcileControlIdPanel(CanvasObject canvasObject) {
        String string = canvasObject.getControlId();
        String string2 = UIToolResUtil.getString((String)"IDS_DEF_ID_PREFIX");
        int n = 1;
        PanelElementDefinition panelElementDefinition = this.findCanvasObjectPanel(string);
        while (panelElementDefinition != null && panelElementDefinition != canvasObject.getCtrlDef()) {
            string = string2 + n++;
            panelElementDefinition = this.findCanvasObject(string);
        }
        if (!string.equals(canvasObject.getControlId())) {
            canvasObject.setControlId(string);
        }
    }

    protected void buildObject(JComponent jComponent, CanvasObject canvasObject, Point point) {
        Dimension dimension = canvasObject.getPreferredSize();
        Point point2 = new Point(CanvasLayout.getColumnTolerance(), 10);
        canvasObject.setBounds(point.x * point2.x, point.y * point2.y, dimension.width, dimension.height);
        boolean bl = true;
        if (jComponent instanceof ItemGroupObject) {
            ItemGroupObject itemGroupObject = (ItemGroupObject)jComponent;
            int n = itemGroupObject.getComponentCount();
            itemGroupObject.addItemInternal(canvasObject, n);
            boolean bl2 = itemGroupObject instanceof CheckBoxGroupObject;
            if (!bl2 || n > 0) {
                this.addObjectListeners(canvasObject);
            } else {
                canvasObject.setFocusable(false);
                bl = false;
            }
        } else if (jComponent instanceof RadioGroupObject) {
            RadioGroupObject radioGroupObject = (RadioGroupObject)jComponent;
            RadioItemDefinition radioItemDefinition = radioGroupObject.findRadioItemParent(canvasObject);
            radioGroupObject.buildRadioSubItem(canvasObject, radioItemDefinition);
            this.addObjectListeners(canvasObject);
        } else {
            jComponent.add(canvasObject);
            this.addObjectListeners(canvasObject);
        }
        if (bl) {
            this.mFrame.addNewCanvasObject(canvasObject);
        }
        if (this.mBuildingSpec && canvasObject instanceof SubDlgButtonObject) {
            this.handleSubdlgFromSpec((SubDlgButtonObject)canvasObject);
        }
    }

    private void handleSubdlgFromSpec(SubDlgButtonObject subDlgButtonObject) {
        SubDlgButtonDefinition subDlgButtonDefinition = (SubDlgButtonDefinition)subDlgButtonObject.getCtrlDef();
        PanelDefinition panelDefinition = subDlgButtonDefinition.getDialogDefinition().getCurrentPanel();
        for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
            CanvasObject canvasObject = this.getCanvasObject(panelDefinition.getPanelElement(i).getControlId());
            if (canvasObject != null) continue;
            canvasObject = this.createTempObject(panelDefinition.getPanelElement(i));
            this.mFrame.addNewCanvasObject(canvasObject);
        }
    }

    private CanvasObject createTempObject(PanelElementDefinition panelElementDefinition) {
        CanvasObject canvasObject = null;
        if (panelElementDefinition instanceof FieldChooserDefinition) {
            canvasObject = new FieldChooserObject((FieldChooserDefinition)panelElementDefinition);
            canvasObject.setCanvasType(ToolType.FIELD_CHOOSER_CONTROL.toString());
        } else if (panelElementDefinition instanceof CheckBoxDefinition) {
            canvasObject = new CheckBoxObject((CheckBoxDefinition)panelElementDefinition);
            canvasObject.setCanvasType(ToolType.CHECKBOX_CONTROL.toString());
        } else if (panelElementDefinition instanceof ComboBoxDefinition) {
            canvasObject = new ComboBoxObject((ComboBoxDefinition)panelElementDefinition);
            canvasObject.setCanvasType(ToolType.COMBO_BOX_CONTROL.toString());
        } else if (panelElementDefinition instanceof ListBoxDefinition) {
            canvasObject = new ListBoxObject((ListBoxDefinition)panelElementDefinition);
            canvasObject.setCanvasType(ToolType.LISTBOX_CONTROL.toString());
        } else if (panelElementDefinition instanceof DatasetSelectorDefinition) {
            canvasObject = new DatasetSelectorObject((DatasetSelectorDefinition)panelElementDefinition);
            canvasObject.setCanvasType(ToolType.DATASET_SELECTOR.toString());
        } else if (panelElementDefinition instanceof EditCtrlDefinition) {
            canvasObject = new EditCtrlObject((EditCtrlDefinition)panelElementDefinition);
            canvasObject.setCanvasType(ToolType.EDIT_TEXT_CONTROL.toString());
        } else if (panelElementDefinition instanceof SpinnerDefinition) {
            canvasObject = new SpinnerCtrlObject((SpinnerDefinition)panelElementDefinition);
            canvasObject.setCanvasType(ToolType.SPINNER_CONTROL.toString());
        } else if (panelElementDefinition instanceof RadioGroupDefinition) {
            RadioGroupDefinition radioGroupDefinition = (RadioGroupDefinition)panelElementDefinition;
            canvasObject = new RadioGroupObject(radioGroupDefinition);
            canvasObject.setCanvasType(ToolType.RADIO_GROUP.toString());
            for (int i = 0; i < radioGroupDefinition.radioItemCount(); ++i) {
                RadioItemDefinition radioItemDefinition = radioGroupDefinition.getRadioItem(i);
                for (int j = 0; j < radioItemDefinition.getElementCount(); ++j) {
                    CanvasObject canvasObject2 = this.createTempObject(radioItemDefinition.getPanelElement(j));
                    this.mFrame.addNewCanvasObject(canvasObject2);
                }
            }
        } else if (panelElementDefinition instanceof StaticCtrlDefinition) {
            canvasObject = new StaticCtrlObject((StaticCtrlDefinition)panelElementDefinition);
            canvasObject.setCanvasType(ToolType.STATIC_TEXT_CONTROL.toString());
        } else if (panelElementDefinition instanceof CheckBoxGroupDefinition) {
            CheckBoxGroupDefinition checkBoxGroupDefinition = (CheckBoxGroupDefinition)panelElementDefinition;
            canvasObject = new CheckBoxGroupObject(checkBoxGroupDefinition);
            canvasObject.setCanvasType(ToolType.CHECKBOX_GROUP_CONTROL.toString());
            for (int i = 0; i < checkBoxGroupDefinition.getElementCount(); ++i) {
                CanvasObject canvasObject3 = this.createTempObject(checkBoxGroupDefinition.getPanelElement(i));
                if (i <= 0) continue;
                this.mFrame.addNewCanvasObject(canvasObject3);
            }
        } else if (panelElementDefinition instanceof ItemGroupDefinition) {
            ItemGroupDefinition itemGroupDefinition = (ItemGroupDefinition)panelElementDefinition;
            canvasObject = new ItemGroupObject(itemGroupDefinition);
            canvasObject.setCanvasType(ToolType.ITEM_GROUP_CONTROL.toString());
            for (int i = 0; i < itemGroupDefinition.getElementCount(); ++i) {
                CanvasObject canvasObject4 = this.createTempObject(itemGroupDefinition.getPanelElement(i));
                this.mFrame.addNewCanvasObject(canvasObject4);
            }
        } else if (panelElementDefinition instanceof ColorPickerDefinition) {
            canvasObject = new ColorPickerCtrlObject((ColorPickerDefinition)panelElementDefinition);
            canvasObject.setCanvasType(ToolType.COLOR_PICKER_CONTROL.toString());
        } else if (panelElementDefinition instanceof TableDefinition) {
            canvasObject = new TableCtrlObject((TableDefinition)panelElementDefinition);
            canvasObject.setCanvasType(ToolType.TABLE_CONTROL.toString());
        } else if (panelElementDefinition instanceof FileSystemBrowserDefinition) {
            canvasObject = new FileSystemBrowserObject((FileSystemBrowserDefinition)panelElementDefinition);
            canvasObject.setCanvasType(ToolType.FILE_SYSTEM_BROWSER.toString());
        }
        return canvasObject;
    }

    protected void addObject(CanvasObject canvasObject, Point point) {
        Dimension dimension = canvasObject.getPreferredSize();
        canvasObject.setBounds(point.x, point.y, dimension.width, dimension.height);
        this.addObjectListeners(canvasObject);
        if (!this.mBuildingSpec) {
            this.mFrame.setModified(true);
        }
        this.add(canvasObject);
    }

    public boolean removeObject(CanvasObject canvasObject) {
        boolean bl = false;
        if (!(canvasObject instanceof TextAreaCtrlObject)) {
            this.removeObjectListeners(canvasObject);
        }
        if (this.hasObject(canvasObject)) {
            if (canvasObject instanceof DatasetSelectorObject && canvasObject.getCtrlDef().getControlId().equals(this.mDialog.getDatasetSeletorId())) {
                this.mDialog.setDatasetSeletorId("");
            }
            this.remove(canvasObject);
            if (this.mTab != null) {
                this.mTab.removePanelElement(canvasObject.getCtrlDef());
            } else {
                PanelDefinition panelDefinition = this.mDialog.getCurrentPanel();
                panelDefinition.removePanelElement(canvasObject.getCtrlDef());
            }
            bl = true;
        } else if (canvasObject.getParent() instanceof ItemGroupObject) {
            ItemGroupObject itemGroupObject = (ItemGroupObject)canvasObject.getParent();
            itemGroupObject.removeItem(canvasObject);
            bl = true;
        } else if (canvasObject.getParent() != null && canvasObject.getParent().getParent() instanceof RadioGroupObject) {
            RadioGroupObject radioGroupObject = (RadioGroupObject)canvasObject.getParent().getParent();
            radioGroupObject.removeSubElement(canvasObject);
            bl = true;
        }
        this.mFrame.setModified(true);
        if (this.getCanvasType() == CanvasType.Normal && this.getComponentCount() == 0) {
            this.createTextAreaObject();
        }
        this.validate();
        this.repaint();
        this.fireSelectionChange(this.getSelectedObject());
        return bl;
    }

    protected boolean hasObject(CanvasObject canvasObject) {
        for (Component component : this.getComponents()) {
            if (component != canvasObject) continue;
            return true;
        }
        return false;
    }

    public CanvasObject getCanvasObject(String string) {
        CanvasObject canvasObject = null;
        for (Component component : this.getComponents()) {
            if (!(component instanceof CanvasObject) || !((CanvasObject)component).getControlId().equals(string)) continue;
            canvasObject = (CanvasObject)component;
        }
        return canvasObject;
    }

    protected void addObjectListeners(CanvasObject canvasObject) {
        canvasObject.addMouseListener((MouseListener)((Object)this.mDragAdapter));
        canvasObject.addMouseMotionListener((MouseMotionListener)((Object)this.mDragAdapter));
        canvasObject.addKeyListener(this.mKeyHandler);
    }

    protected void removeObjectListeners(CanvasObject canvasObject) {
        canvasObject.removeMouseListener((MouseListener)((Object)this.mDragAdapter));
        canvasObject.removeMouseMotionListener((MouseMotionListener)((Object)this.mDragAdapter));
        canvasObject.removeKeyListener(this.mKeyHandler);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.renderGridLines(graphics);
    }

    private void renderGridLines(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(new Color(221, 221, 221));
        Rectangle rectangle = this.getBounds();
        for (n = 0; n < rectangle.width; ++n) {
            graphics2D.drawLine(n * this.mGridSize, 0, n * this.mGridSize, rectangle.height);
        }
        for (n = 0; n < rectangle.height; ++n) {
            graphics2D.drawLine(0, n * this.mGridSize, rectangle.width, n * this.mGridSize);
        }
    }

    private void buildControlsFromSpec() {
        this.mBuildingSpec = true;
        try {
            this.removeAll();
            if (this.mDialog.IsCompatMode() || !this.mDialog.IsTabbedDlg()) {
                PanelDefinition panelDefinition = this.mDialog.getCurrentPanel();
                this.buildPanel(this, (PanelElementDefinition)panelDefinition);
            } else {
                this.buildPanel(this, (PanelElementDefinition)this.mTab);
            }
            this.validate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        this.mBuildingSpec = false;
    }

    private void buildPanel(JComponent jComponent, PanelElementDefinition panelElementDefinition) {
        int n;
        if (panelElementDefinition instanceof PanelDefinition) {
            n = ((PanelDefinition)panelElementDefinition).getElementCount();
        } else if (panelElementDefinition instanceof RadioItemDefinition) {
            n = ((RadioItemDefinition)panelElementDefinition).getElementCount();
        } else {
            assert (false);
            return;
        }
        for (int i = 0; i < n; ++i) {
            CanvasObject canvasObject;
            PanelElementDefinition panelElementDefinition2 = panelElementDefinition instanceof PanelDefinition ? ((PanelDefinition)panelElementDefinition).getPanelElement(i) : ((RadioItemDefinition)panelElementDefinition).getPanelElement(i);
            if (panelElementDefinition2 instanceof SrcListDefinition) {
                canvasObject = new SrcListObject((SrcListDefinition)panelElementDefinition2);
                canvasObject.setCanvasType(ToolType.SOURCE_VAR_LIST.toString());
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof FieldChooserDefinition) {
                canvasObject = new FieldChooserObject((FieldChooserDefinition)panelElementDefinition2);
                canvasObject.setCanvasType(ToolType.FIELD_CHOOSER_CONTROL.toString());
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof TargetListDefinition) {
                canvasObject = new TargetListObject((TargetListDefinition)panelElementDefinition2);
                canvasObject.setCanvasType(ToolType.TARGET_VAR_LIST.toString());
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof CheckBoxDefinition) {
                canvasObject = new CheckBoxObject((CheckBoxDefinition)panelElementDefinition2);
                canvasObject.setCanvasType(ToolType.CHECKBOX_CONTROL.toString());
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof ComboBoxDefinition) {
                canvasObject = new ComboBoxObject((ComboBoxDefinition)panelElementDefinition2);
                canvasObject.setCanvasType(ToolType.COMBO_BOX_CONTROL.toString());
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof ListBoxDefinition) {
                canvasObject = new ListBoxObject((ListBoxDefinition)panelElementDefinition2);
                canvasObject.setCanvasType(ToolType.LISTBOX_CONTROL.toString());
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof DatasetSelectorDefinition) {
                canvasObject = new DatasetSelectorObject((DatasetSelectorDefinition)panelElementDefinition2);
                canvasObject.setCanvasType(ToolType.DATASET_SELECTOR.toString());
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof EditCtrlDefinition) {
                canvasObject = new EditCtrlObject((EditCtrlDefinition)panelElementDefinition2);
                EditCtrlDefinition.ParseType parseType = ((EditCtrlDefinition)panelElementDefinition2).getParseType();
                if (parseType == EditCtrlDefinition.ParseType.number || parseType == EditCtrlDefinition.ParseType.integer) {
                    canvasObject.setCanvasType(ToolType.NUMBER_EDIT_CONTROL.toString());
                } else {
                    canvasObject.setCanvasType(ToolType.EDIT_TEXT_CONTROL.toString());
                }
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof SpinnerDefinition) {
                canvasObject = new SpinnerCtrlObject((SpinnerDefinition)panelElementDefinition2);
                canvasObject.setCanvasType(ToolType.SPINNER_CONTROL.toString());
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof RadioGroupDefinition) {
                this.buildRadioGroup(jComponent, (RadioGroupDefinition)panelElementDefinition2);
                continue;
            }
            if (panelElementDefinition2 instanceof StaticCtrlDefinition) {
                canvasObject = new StaticCtrlObject((StaticCtrlDefinition)panelElementDefinition2);
                canvasObject.setCanvasType(ToolType.STATIC_TEXT_CONTROL.toString());
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof SubDlgButtonDefinition) {
                canvasObject = new SubDlgButtonObject((SubDlgButtonDefinition)panelElementDefinition2);
                canvasObject.setCanvasType(ToolType.SUB_DIALOG_BUTTON.toString());
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof CheckBoxGroupDefinition) {
                this.buildCheckBoxPanel(jComponent, (CheckBoxGroupDefinition)panelElementDefinition2, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof ItemGroupDefinition) {
                this.buildItemGroupPanel(jComponent, (ItemGroupDefinition)panelElementDefinition2, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof PanelDefinition) {
                this.buildPanel(null, panelElementDefinition2);
                continue;
            }
            if (panelElementDefinition2 instanceof ColorPickerDefinition) {
                canvasObject = new ColorPickerCtrlObject((ColorPickerDefinition)panelElementDefinition2);
                canvasObject.setCanvasType(ToolType.COLOR_PICKER_CONTROL.toString());
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof TableDefinition) {
                canvasObject = new TableCtrlObject((TableDefinition)panelElementDefinition2);
                canvasObject.setCanvasType(ToolType.TABLE_CONTROL.toString());
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            if (panelElementDefinition2 instanceof FileSystemBrowserDefinition) {
                canvasObject = new FileSystemBrowserObject((FileSystemBrowserDefinition)panelElementDefinition2);
                canvasObject.setCanvasType(ToolType.FILE_SYSTEM_BROWSER.toString());
                this.buildObject(jComponent, canvasObject, panelElementDefinition2.getPosition());
                continue;
            }
            this.mBuildingSpec = false;
            assert (false);
        }
    }

    private void buildRadioGroup(JComponent jComponent, RadioGroupDefinition radioGroupDefinition) {
        RadioGroupObject radioGroupObject = new RadioGroupObject(radioGroupDefinition);
        radioGroupObject.setCanvasType(ToolType.RADIO_GROUP.toString());
        this.mFrame.addNewCanvasObject(radioGroupObject);
        this.buildObject(jComponent, radioGroupObject, radioGroupDefinition.getPosition());
        for (int i = 0; i < radioGroupDefinition.radioItemCount(); ++i) {
            RadioItemDefinition radioItemDefinition = radioGroupDefinition.getRadioItem(i);
            if (jComponent instanceof ItemGroupObject && radioItemDefinition.getHasSubGroup()) {
                radioItemDefinition.setHasSubGroup(false);
            }
            this.buildPanel(radioGroupObject, (PanelElementDefinition)radioItemDefinition);
        }
    }

    private void buildItemGroupPanel(JComponent jComponent, ItemGroupDefinition itemGroupDefinition, Point point) {
        ItemGroupObject itemGroupObject = new ItemGroupObject(itemGroupDefinition);
        itemGroupObject.setCanvasType(ToolType.ITEM_GROUP_CONTROL.toString());
        Dimension dimension = itemGroupObject.getPreferredSize();
        Point point2 = new Point(CanvasLayout.getColumnTolerance(), 10);
        itemGroupObject.setBounds(point.x * point2.x, point.y * point2.y, dimension.width, dimension.height);
        this.addObjectListeners(itemGroupObject);
        jComponent.add(itemGroupObject);
        this.mFrame.addNewCanvasObject(itemGroupObject);
        this.buildPanel(itemGroupObject, (PanelElementDefinition)itemGroupDefinition);
    }

    private void buildCheckBoxPanel(JComponent jComponent, CheckBoxGroupDefinition checkBoxGroupDefinition, Point point) {
        CheckBoxGroupObject checkBoxGroupObject = new CheckBoxGroupObject(checkBoxGroupDefinition);
        checkBoxGroupObject.setCanvasType(ToolType.CHECKBOX_GROUP_CONTROL.toString());
        Dimension dimension = checkBoxGroupObject.getPreferredSize();
        Point point2 = new Point(CanvasLayout.getColumnTolerance(), 10);
        checkBoxGroupObject.setBounds(point.x * point2.x, point.y * point2.y, dimension.width, dimension.height);
        this.addObjectListeners(checkBoxGroupObject);
        jComponent.add(checkBoxGroupObject);
        this.mFrame.addNewCanvasObject(checkBoxGroupObject);
        this.buildPanel(checkBoxGroupObject, (PanelElementDefinition)checkBoxGroupDefinition);
    }

    private void init() {
        this.setBackground(new Color(238, 238, 238));
        this.setLayout(new CanvasLayout());
        this.mSelectionListeners = new Vector();
        this.mDragAdapter = new CanvasDragAdapter(this.mFrame.getDragPane());
        this.mKeyHandler = new KeyHandler();
        this.setFocusable(true);
        this.setBorder(this.mUnfocusedBorder);
        this.addFocusListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                BuilderCanvas.this.requestFocus();
                BuilderCanvas.this.fireSelectionChange(null);
            }
        });
        InputMap inputMap = this.getInputMap(1);
        KeyStroke keyStroke = BuilderResUtil.getShortcut("IDK_TOOLS");
        inputMap.put(keyStroke, "FocusPalette");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuilderCanvas.this.mFrame.focusToolPalette();
            }
        };
        this.getActionMap().put("FocusPalette", abstractAction);
        keyStroke = BuilderResUtil.getShortcut("IDK_PROPS");
        inputMap.put(keyStroke, "FocusProps");
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuilderCanvas.this.mFrame.focusPropertiesPanel();
            }
        };
        this.getActionMap().put("FocusProps", abstractAction2);
    }

    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        Object object = dragDropAdapter.getTransferData();
        if (object instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)object;
            if (toolItem.getToolType() == ToolType.SOURCE_VAR_LIST && this.mDialog.hasSourceList()) {
                return false;
            }
            if (this.getCanvasType() == CanvasType.HeaderFooter && (toolItem.getToolType() == ToolType.SOURCE_VAR_LIST || toolItem.getToolType() == ToolType.TARGET_VAR_LIST || toolItem.getToolType() == ToolType.SUB_DIALOG_BUTTON)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(Point point) {
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this);
        Rectangle rectangle = this.getVisibleRect();
        return rectangle.contains(point2);
    }

    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        if (this.contains(point)) {
            Point point2 = (Point)point.clone();
            Object object = dragDropAdapter.getTransferData();
            SwingUtilities.convertPointFromScreen(point2, this);
            boolean bl = this.canDropAtPoint(object, point2);
            if (!bl || !this.canDrop(dragDropAdapter)) {
                Cursor cursor;
                try {
                    cursor = Cursor.getSystemCustomCursor("CopyNoDrop32x32");
                }
                catch (AWTException aWTException) {
                    aWTException.printStackTrace();
                    cursor = Cursor.getPredefinedCursor(3);
                }
                return cursor;
            }
            return Cursor.getPredefinedCursor(12);
        }
        return null;
    }

    public void itemDropped(DropEvent dropEvent) {
        if (this.getCanvasType() == CanvasType.HeaderFooter) {
            return;
        }
        Point point = dropEvent.getDropLocation();
        Object object = dropEvent.getTransferData();
        if (object == null) {
            return;
        }
        boolean bl = this.contains(point);
        if (bl) {
            SwingUtilities.convertPointFromScreen(point, this);
            if (this.subDrop(object, point)) {
                this.mFrame.setModified(true);
            } else if (object instanceof ToolItem) {
                this.createNewObject(((ToolItem)object).getToolType(), point);
                this.mFrame.setModified(true);
            } else if (object instanceof CanvasObject) {
                CanvasObject canvasObject = (CanvasObject)object;
                Point point2 = this.mFrame.getDragPane().getImageHotSpot();
                point.translate(-point2.x, -point2.y);
                point = this.snapToGrid(point);
                point.x = Math.max(point.x, 0);
                point.y = Math.max(point.y, 0);
                if (canvasObject.getParent() instanceof ItemGroupObject || canvasObject.getParent().getParent() instanceof RadioGroupObject) {
                    this.removeObject(canvasObject);
                    this.addObject(canvasObject, point);
                    PanelDefinition panelDefinition = this.mDialog.getCurrentPanel();
                    panelDefinition.addPanelElement(canvasObject.getCtrlDef());
                    this.setSelected(canvasObject);
                } else {
                    Dimension dimension = canvasObject.getPreferredSize();
                    canvasObject.setBounds(point.x, point.y, dimension.width, dimension.height);
                }
                this.mFrame.setModified(true);
            } else {
                TraceSettings.trace1((String)"Unknown item dropped on Builder Canvas", (int)15);
                return;
            }
            this.validate();
        } else if (object instanceof CanvasObject) {
            boolean bl2 = this.removeObject((CanvasObject)object);
            this.itemRemoved((CanvasObject)object);
            if (bl2) {
                this.mFrame.removeCanvasObject((CanvasObject)object);
                if (object instanceof ItemGroupObject || object instanceof RadioGroupObject || object instanceof SubDlgButtonObject) {
                    this.removeChildObjects((CanvasObject)object);
                }
            }
        }
    }

    private void removeChildObjects(CanvasObject canvasObject) {
        block6: {
            block7: {
                block5: {
                    if (!(canvasObject instanceof ItemGroupObject)) break block5;
                    ItemGroupObject itemGroupObject = (ItemGroupObject)canvasObject;
                    for (int i = 0; i < itemGroupObject.getComponentCount(); ++i) {
                        if (!(itemGroupObject.getComponent(i) instanceof CanvasObject)) continue;
                        this.mFrame.removeCanvasObject((CanvasObject)itemGroupObject.getComponent(i));
                    }
                    break block6;
                }
                if (!(canvasObject instanceof RadioGroupObject)) break block7;
                RadioGroupObject radioGroupObject = (RadioGroupObject)canvasObject;
                for (Component component : radioGroupObject.getComponents()) {
                    if (!(component instanceof RadioGroupObject.RgoPanel)) continue;
                    RadioGroupObject.RgoPanel rgoPanel = (RadioGroupObject.RgoPanel)component;
                    for (int i = 0; i < rgoPanel.getComponentCount(); ++i) {
                        Component component2 = rgoPanel.getComponent(i);
                        if (!(component2 instanceof CanvasObject)) continue;
                        this.mFrame.removeCanvasObject((CanvasObject)component2);
                    }
                }
                break block6;
            }
            if (!(canvasObject instanceof SubDlgButtonObject)) break block6;
            SubDlgButtonDefinition subDlgButtonDefinition = (SubDlgButtonDefinition)canvasObject.getCtrlDef();
            PanelDefinition panelDefinition = subDlgButtonDefinition.getDialogDefinition().getCurrentPanel();
            for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
                this.mFrame.removeCanvasObject(panelElementDefinition.getControlId());
                if (!(panelElementDefinition instanceof PanelDefinition)) continue;
                for (int j = 0; j < ((PanelDefinition)panelElementDefinition).getElementCount(); ++j) {
                    this.mFrame.removeCanvasObject(((PanelDefinition)panelElementDefinition).getPanelElement(j).getControlId());
                }
            }
        }
    }

    public CanvasObject getSelectedObject() {
        for (Component component : this.getComponents()) {
            JComponent jComponent;
            if (!(component instanceof CanvasObject)) continue;
            CanvasObject canvasObject = (CanvasObject)component;
            if (canvasObject.isSelected()) {
                return canvasObject;
            }
            if (canvasObject instanceof ItemGroupObject) {
                jComponent = (ItemGroupObject)canvasObject;
                for (Component component2 : jComponent.getComponents()) {
                    if (!(component2 instanceof CanvasObject) || !(canvasObject = (CanvasObject)component2).isSelected()) continue;
                    return canvasObject;
                }
                continue;
            }
            if (!(canvasObject instanceof RadioGroupObject)) continue;
            RadioGroupObject radioGroupObject = (RadioGroupObject)canvasObject;
            for (Component component3 : radioGroupObject.getComponents()) {
                if (!(component3 instanceof RadioGroupObject.RgoPanel) || (jComponent = (RadioGroupObject.RgoPanel)component3).getComponentCount() <= 1 || !(canvasObject = (CanvasObject)jComponent.getComponent(1)).isSelected()) continue;
                return canvasObject;
            }
        }
        return null;
    }

    public Component getFirstComponent() {
        PanelDefinition panelDefinition;
        int n;
        CanvasObject canvasObject = this.getSelectedObject();
        if (canvasObject == null && (n = (panelDefinition = this.mDialog.getCurrentPanel()).getElementCount()) > 0) {
            return this.getCanvasObject(panelDefinition.getPanelElement(0).getControlId());
        }
        return canvasObject;
    }

    private CanvasObject getNextObject(CanvasObject canvasObject, boolean bl) {
        int n;
        PanelDefinition panelDefinition = this.mDialog.getCurrentPanel();
        int n2 = 0;
        n2 = bl ? 1 : -1;
        int n3 = panelDefinition.getElementCount();
        for (n = 0; n < n3 && canvasObject != this.getCanvasObject(panelDefinition.getPanelElement(n).getControlId()); ++n) {
        }
        if ((n += n2) < n3 && n >= 0) {
            return this.getCanvasObject(panelDefinition.getPanelElement(n).getControlId());
        }
        return this.getCanvasObject(panelDefinition.getPanelElement(0).getControlId());
    }

    public void createNewObject(ToolType toolType, Point point) {
        Component[] componentArray;
        CanvasObject canvasObject = this.createCanvasObject(toolType, true);
        if (canvasObject != null && toolType != ToolType.DIALOG_TAB_CONTROL) {
            canvasObject.setCanvasType(toolType.toString());
            point = this.snapToGrid(point);
            this.addObject(canvasObject, point);
            this.mFrame.addNewCanvasObject(canvasObject);
            this.setSelected(canvasObject);
            this.fireSelectionChange(canvasObject);
        }
        if (canvasObject != null && this.getComponentCount() > 0 && (componentArray = this.getComponents())[0] instanceof TextAreaCtrlObject) {
            canvasObject.setSelected(true);
            this.removeObject((TextAreaCtrlObject)componentArray[0]);
        }
    }

    public void createTextAreaObject() {
        if (this.mDialog.isSubDialog()) {
            return;
        }
        CanvasObject canvasObject = this.createCanvasObject(ToolType.TEXT_AREA, true);
        if (canvasObject != null) {
            Point point = new Point(60, 80);
            Dimension dimension = canvasObject.getPreferredSize();
            canvasObject.setBounds(point.x, point.y, dimension.width, dimension.height);
            this.add(canvasObject);
            this.validate();
            this.repaint();
        }
    }

    public void deselectItems(CanvasObject canvasObject) {
        Component[] componentArray;
        for (Component component : componentArray = this.getComponents()) {
            if (!(component instanceof CanvasObject)) continue;
            CanvasObject canvasObject2 = (CanvasObject)component;
            if (canvasObject2 != canvasObject) {
                canvasObject2.setSelected(false);
            }
            if (canvasObject2 instanceof ItemGroupObject) {
                this.deselectItemGroupItems((ItemGroupObject)canvasObject2, canvasObject);
                continue;
            }
            if (!(canvasObject2 instanceof RadioGroupObject)) continue;
            this.deselectRadioGroupItems((RadioGroupObject)canvasObject2, canvasObject);
        }
    }

    private boolean isSameObject(CanvasObject canvasObject, CanvasObject canvasObject2) {
        boolean bl = false;
        if (canvasObject == canvasObject2) {
            bl = true;
        } else if (canvasObject.getControlId().equals(canvasObject2.getControlId())) {
            bl = true;
        }
        return bl;
    }

    private void itemRemoved(CanvasObject canvasObject) {
        if (canvasObject instanceof TargetListObject || canvasObject instanceof FieldChooserObject) {
            String string;
            PanelElementDefinition panelElementDefinition;
            if (this.mTab == null) {
                this.mTab = this.mDialog.getCurrentPanel();
            }
            if ((panelElementDefinition = this.getLinkedControl((PanelElementDefinition)this.mTab, string = canvasObject.getControlId())) instanceof ListDefinition) {
                CanvasObject canvasObject2;
                ListDefinition listDefinition = (ListDefinition)panelElementDefinition;
                listDefinition.setTargetListId(null);
                listDefinition.setDynamicSourceType(false);
                String string2 = BuilderResUtil.getString("IDS_DELETE_LINKED");
                int n = BuilderAlertPane.showConfirmDialog(this, string2, BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION);
                if (n == 1 && (canvasObject2 = this.locateCanvasObject(listDefinition)) != null) {
                    this.setSelected(canvasObject2);
                    this.fireSelectionChange(canvasObject2);
                    this.mFrame.launchControlEditor(canvasObject2.getCtrlDef());
                }
            }
        }
    }

    private CanvasObject locateCanvasObject(ListDefinition listDefinition) {
        for (Component component : this.getComponents()) {
            JComponent jComponent;
            if (!(component instanceof CanvasObject)) continue;
            CanvasObject canvasObject = (CanvasObject)component;
            if (canvasObject.getCtrlDef() == listDefinition) {
                return canvasObject;
            }
            if (canvasObject instanceof ItemGroupObject) {
                jComponent = (ItemGroupObject)canvasObject;
                for (Component component2 : jComponent.getComponents()) {
                    if (!(component2 instanceof CanvasObject) || (canvasObject = (CanvasObject)component2).getCtrlDef() != listDefinition) continue;
                    return canvasObject;
                }
                continue;
            }
            if (!(canvasObject instanceof RadioGroupObject)) continue;
            RadioGroupObject radioGroupObject = (RadioGroupObject)canvasObject;
            for (Component component3 : radioGroupObject.getComponents()) {
                if (!(component3 instanceof RadioGroupObject.RgoPanel) || (jComponent = (RadioGroupObject.RgoPanel)component3).getComponentCount() <= 1 || (canvasObject = (CanvasObject)jComponent.getComponent(1)).getCtrlDef() != listDefinition) continue;
                return canvasObject;
            }
        }
        return null;
    }

    private PanelElementDefinition getLinkedControl(PanelElementDefinition panelElementDefinition, String string) {
        ListDefinition listDefinition;
        if (panelElementDefinition instanceof PanelDefinition) {
            PanelDefinition panelDefinition = (PanelDefinition)panelElementDefinition;
            for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                PanelElementDefinition panelElementDefinition2 = panelDefinition.getPanelElement(i);
                PanelElementDefinition panelElementDefinition3 = this.getLinkedControl(panelElementDefinition2, string);
                if (panelElementDefinition3 == null) continue;
                return panelElementDefinition3;
            }
        } else if (panelElementDefinition instanceof ListDefinition && string.equals((listDefinition = (ListDefinition)panelElementDefinition).getTargetListId())) {
            return panelElementDefinition;
        }
        return null;
    }

    private void deselectItemGroupItems(ItemGroupObject itemGroupObject, CanvasObject canvasObject) {
        int n;
        int n2 = itemGroupObject.getComponentCount();
        for (int i = n = itemGroupObject instanceof CheckBoxGroupObject ? 1 : 0; i < n2; ++i) {
            Component component = itemGroupObject.getComponent(i);
            if (!(component instanceof CanvasObject) || component == canvasObject) continue;
            CanvasObject canvasObject2 = (CanvasObject)component;
            canvasObject2.setSelected(false);
        }
    }

    private void deselectRadioGroupItems(RadioGroupObject radioGroupObject, CanvasObject canvasObject) {
        int n = radioGroupObject.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component;
            RadioGroupObject.RgoPanel rgoPanel;
            Component component2 = radioGroupObject.getComponent(i);
            if (!(component2 instanceof RadioGroupObject.RgoPanel) || (rgoPanel = (RadioGroupObject.RgoPanel)component2).getComponentCount() <= 1 || !((component = ((RadioGroupObject.RgoPanel)component2).getComponent(1)) instanceof CanvasObject) || component == canvasObject) continue;
            CanvasObject canvasObject2 = (CanvasObject)component;
            canvasObject2.setSelected(false);
        }
    }

    private boolean subDrop(Object object, Point point) {
        Object object2;
        CanvasObject canvasObject = this.hitTest(point);
        boolean bl = canvasObject instanceof RadioGroupObject;
        if (!(canvasObject instanceof ItemGroupObject) && !bl) {
            return false;
        }
        int n = -1;
        Point point2 = null;
        RadioGroupObject radioGroupObject = null;
        if (bl && ((n = (radioGroupObject = (RadioGroupObject)canvasObject).pointToRadioIndex(point2 = SwingUtilities.convertPoint(this, point, radioGroupObject))) < 0 || !radioGroupObject.getRadioItem(n).getHasSubGroup())) {
            return false;
        }
        boolean bl2 = false;
        Object object3 = null;
        if (object instanceof ToolItem) {
            object2 = ((ToolItem)object).getToolType();
            if (this.canDropWithinPanel(canvasObject, (ToolType)((Object)object2))) {
                object3 = this.createCanvasObject((ToolType)((Object)object2), false);
                ((CanvasObject)object3).setCanvasType(object2.toString());
                this.mFrame.addNewCanvasObject((CanvasObject)object3);
            }
        } else if (object instanceof CanvasObject && this.canDropWithinPanel(canvasObject, (CanvasObject)object)) {
            object2 = (CanvasObject)object;
            this.removeObject((CanvasObject)object2);
            this.mFrame.removeCanvasObject((CanvasObject)object2);
            object3 = object2;
        }
        if (object3 != null) {
            point = this.snapToGrid(point);
            if (canvasObject instanceof ItemGroupObject) {
                object2 = (ItemGroupObject)canvasObject;
                Point point3 = SwingUtilities.convertPoint(this, point, (Component)object2);
                n = ((ItemGroupObject)object2).pointToItemIndex(point3);
                ((ItemGroupObject)object2).insertItem((CanvasObject)object3, n);
                this.mFrame.addNewCanvasObject((CanvasObject)object3);
            } else {
                this.mFrame.insertRadioButtonSubElement(radioGroupObject, (CanvasObject)object3, n, point2);
            }
            this.addObjectListeners((CanvasObject)object3);
            this.setSelected((CanvasObject)object3);
            bl2 = true;
        }
        return bl2;
    }

    private boolean canDropWithinPanel(CanvasObject canvasObject, CanvasObject canvasObject2) {
        return (!(canvasObject instanceof RadioGroupObject) || !(canvasObject2 instanceof RadioGroupObject)) && !(canvasObject2 instanceof SrcListObject) && !(canvasObject2 instanceof TargetListObject) && !(canvasObject2 instanceof ItemGroupObject) && !(canvasObject2 instanceof SubDlgButtonObject);
    }

    private boolean canDropWithinPanel(CanvasObject canvasObject, ToolType toolType) {
        return (!(canvasObject instanceof RadioGroupObject) || toolType != ToolType.RADIO_GROUP) && toolType != ToolType.SOURCE_VAR_LIST && toolType != ToolType.TARGET_VAR_LIST && toolType != ToolType.SUB_DIALOG_BUTTON && toolType != ToolType.ITEM_GROUP_CONTROL && toolType != ToolType.CHECKBOX_GROUP_CONTROL;
    }

    private boolean canDropAtPoint(Object object, Point point) {
        boolean bl = true;
        CanvasObject canvasObject = this.hitTest(point);
        if (canvasObject instanceof ItemGroupObject || canvasObject instanceof RadioGroupObject) {
            if (object instanceof ToolItem) {
                ToolItem toolItem = (ToolItem)object;
                bl = this.canDropWithinPanel(canvasObject, toolItem.getToolType());
            } else if (object instanceof CanvasObject) {
                bl = this.canDropWithinPanel(canvasObject, (CanvasObject)object);
            }
        }
        return bl;
    }

    private CanvasObject hitTest(Point point) {
        for (Component component : this.getComponents()) {
            if (!(component instanceof CanvasObject) || !component.getBounds().contains(point)) continue;
            return (CanvasObject)component;
        }
        return null;
    }

    private CanvasObject createCanvasObject(ToolType toolType, boolean bl) {
        CanvasObject canvasObject;
        if (toolType == ToolType.SOURCE_VAR_LIST) {
            canvasObject = this.createSourceList();
        } else if (toolType == ToolType.TARGET_VAR_LIST) {
            canvasObject = this.createTargetList();
        } else if (toolType == ToolType.FIELD_CHOOSER_CONTROL) {
            canvasObject = this.createFieldChooserCtrl();
        } else if (toolType == ToolType.CHECKBOX_CONTROL) {
            canvasObject = this.createCheckBox();
        } else if (toolType == ToolType.CHECKBOX_GROUP_CONTROL) {
            canvasObject = this.createCheckBoxGroup();
        } else if (toolType == ToolType.ITEM_GROUP_CONTROL) {
            canvasObject = this.createItemGroup();
        } else if (toolType == ToolType.COMBO_BOX_CONTROL) {
            canvasObject = this.createComboBox();
        } else if (toolType == ToolType.LISTBOX_CONTROL) {
            canvasObject = this.createListBox();
        } else if (toolType == ToolType.DIALOG_TAB_CONTROL) {
            canvasObject = this.createDialogTab();
        } else if (toolType == ToolType.EDIT_TEXT_CONTROL) {
            canvasObject = this.createEditCtrl(EditCtrlDefinition.ParseType.string);
        } else if (toolType == ToolType.NUMBER_EDIT_CONTROL) {
            canvasObject = this.createEditCtrl(EditCtrlDefinition.ParseType.number);
        } else if (toolType == ToolType.SPINNER_CONTROL) {
            canvasObject = this.createSpinnerCtrl(EditCtrlDefinition.ParseType.date);
        } else if (toolType == ToolType.PASSWORD_CONTROL) {
            canvasObject = this.createPasswordCtrl();
        } else if (toolType == ToolType.TABLE_CONTROL) {
            canvasObject = this.createTableCtrl();
        } else if (toolType == ToolType.COLOR_PICKER_CONTROL) {
            canvasObject = this.createColorPickerCtrl();
        } else if (toolType == ToolType.RADIO_GROUP) {
            canvasObject = this.createRadioGroup();
        } else if (toolType == ToolType.STATIC_TEXT_CONTROL) {
            canvasObject = this.createStaticText();
        } else if (toolType == ToolType.STATIC_IMAGE) {
            canvasObject = this.createStaticImage();
        } else if (toolType == ToolType.SUB_DIALOG_BUTTON) {
            canvasObject = this.createSubDlgButton();
        } else if (toolType == ToolType.FILE_SYSTEM_BROWSER) {
            canvasObject = this.createFileSystemBrowser();
        } else if (toolType == ToolType.DATASET_SELECTOR) {
            canvasObject = this.createDatasetSelector();
        } else if (toolType == ToolType.TEXT_AREA) {
            canvasObject = this.createTextAreaText();
        } else {
            assert (false);
            return null;
        }
        if (canvasObject == null) {
            return null;
        }
        if (bl && toolType != ToolType.DIALOG_TAB_CONTROL) {
            if (this.mTab != null) {
                this.mTab.addPanelElement(canvasObject.getCtrlDef());
                this.reconcileControlId(canvasObject);
            } else {
                PanelDefinition panelDefinition = this.mDialog.getCurrentPanel();
                panelDefinition.addPanelElement(canvasObject.getCtrlDef());
                this.reconcileControlIdPanel(canvasObject);
            }
        }
        return canvasObject;
    }

    private PanelElementDefinition findElementDefinition(PanelDefinition panelDefinition, String string) {
        if (panelDefinition.getControlId().equals(string)) {
            return panelDefinition;
        }
        for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
            PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
            if (panelElementDefinition.getControlId().equals(string)) {
                return panelElementDefinition;
            }
            if (!(panelElementDefinition instanceof PanelDefinition ? (panelElementDefinition = this.findElementDefinition((PanelDefinition)panelElementDefinition, string)) != null : (panelElementDefinition instanceof SubDlgButtonDefinition ? (panelElementDefinition = this.findElementDefinition(((SubDlgButtonDefinition)panelElementDefinition).getDialogDefinition().getCurrentPanel(), string)) != null : panelElementDefinition instanceof RadioGroupDefinition && (panelElementDefinition = ((RadioGroupDefinition)panelElementDefinition).findElementDefinition(string)) != null))) continue;
            return panelElementDefinition;
        }
        return null;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.deselectItems(null);
        this.setBorder(this.mFocusedBorder);
        this.fireSelectionChange(null);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setBorder(this.mUnfocusedBorder);
    }

    private void snapComponents() {
        Component[] componentArray;
        for (Component component : componentArray = this.getComponents()) {
            if (!(component instanceof CanvasObject)) continue;
            component.setLocation(this.snapToGrid(component.getLocation()));
        }
        if (componentArray.length > 0) {
            this.mFrame.setModified(true);
        }
    }

    private void setSelected(CanvasObject canvasObject) {
        canvasObject.requestFocus();
        canvasObject.setSelected(true);
    }

    private SrcListObject createSourceList() {
        if (this.mDialog.hasSourceList() || this.getCanvasType() == CanvasType.HeaderFooter) {
            return null;
        }
        SrcListDefinition srcListDefinition = new SrcListDefinition();
        srcListDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_SRC_TITLE"));
        return new SrcListObject(srcListDefinition);
    }

    private FieldChooserObject createFieldChooserCtrl() {
        FieldChooserDefinition fieldChooserDefinition = new FieldChooserDefinition();
        fieldChooserDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_FIELD_TITLE"));
        return new FieldChooserObject(fieldChooserDefinition);
    }

    private TargetListObject createTargetList() {
        if (this.getCanvasType() == CanvasType.HeaderFooter) {
            return null;
        }
        TargetListDefinition targetListDefinition = new TargetListDefinition();
        targetListDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_TGT_TITLE"));
        return new TargetListObject(targetListDefinition);
    }

    private CheckBoxObject createCheckBox() {
        CheckBoxDefinition checkBoxDefinition = new CheckBoxDefinition();
        checkBoxDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_CHKBOX_TITLE"));
        return new CheckBoxObject(checkBoxDefinition);
    }

    private CanvasObject createCheckBoxGroup() {
        CheckBoxGroupDefinition checkBoxGroupDefinition = new CheckBoxGroupDefinition();
        checkBoxGroupDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_CHECKBOX_GROUP_TITLE"));
        CheckBoxGroupObject checkBoxGroupObject = new CheckBoxGroupObject(checkBoxGroupDefinition);
        CheckBoxDefinition checkBoxDefinition = new CheckBoxDefinition();
        checkBoxDefinition.setCheckedSyntax(DialogDefinition.getSelfValue());
        checkBoxDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_CHKBOX_TITLE"));
        CheckBoxObject checkBoxObject = new CheckBoxObject(checkBoxDefinition);
        checkBoxObject.setFocusable(false);
        checkBoxGroupDefinition.addPanelElement((PanelElementDefinition)checkBoxDefinition);
        checkBoxGroupObject.addItemInternal(checkBoxObject, 0);
        return checkBoxGroupObject;
    }

    private CanvasObject createItemGroup() {
        ItemGroupDefinition itemGroupDefinition = new ItemGroupDefinition();
        itemGroupDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_GROUP_TITLE"));
        return new ItemGroupObject(itemGroupDefinition);
    }

    private EditCtrlObject createEditCtrl(EditCtrlDefinition.ParseType parseType) {
        EditCtrlDefinition editCtrlDefinition = new EditCtrlDefinition(parseType, this.mQuoteHandlingType);
        editCtrlDefinition.setTitle("");
        return new EditCtrlObject(editCtrlDefinition);
    }

    private EditCtrlObject createPasswordCtrl() {
        EditCtrlDefinition editCtrlDefinition = new EditCtrlDefinition(EditCtrlDefinition.ParseType.string, this.mQuoteHandlingType);
        editCtrlDefinition.setTitle("");
        editCtrlDefinition.setIsPasswordField(true);
        return new EditCtrlObject(editCtrlDefinition);
    }

    private SpinnerCtrlObject createSpinnerCtrl(EditCtrlDefinition.ParseType parseType) {
        SpinnerDefinition spinnerDefinition = new SpinnerDefinition(parseType);
        spinnerDefinition.setIsLabelAbove(true);
        spinnerDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_SPINNER_TITLE"));
        return new SpinnerCtrlObject(spinnerDefinition);
    }

    private TableCtrlObject createTableCtrl() {
        TableDefinition tableDefinition = new TableDefinition(this.mQuoteHandlingType);
        tableDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_TABLE_TITLE"));
        return new TableCtrlObject(tableDefinition);
    }

    private StaticCtrlObject createStaticText() {
        StaticCtrlDefinition staticCtrlDefinition = new StaticCtrlDefinition();
        staticCtrlDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_STATIC_TITLE"));
        return new StaticCtrlObject(staticCtrlDefinition);
    }

    private TextAreaCtrlObject createTextAreaText() {
        TextAreaDefinition textAreaDefinition = new TextAreaDefinition(!this.mFrame.IsCompatibleMode());
        textAreaDefinition.setTitle("");
        return new TextAreaCtrlObject(textAreaDefinition, this.mCanvasType);
    }

    private StaticImageObject createStaticImage() {
        StaticImageDefinition staticImageDefinition = new StaticImageDefinition();
        staticImageDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_STATIC_IMAGE_TITLE"));
        return new StaticImageObject(staticImageDefinition);
    }

    private CanvasObject createComboBox() {
        ComboBoxDefinition comboBoxDefinition = new ComboBoxDefinition(this.mQuoteHandlingType);
        comboBoxDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_COMBO_TITLE"));
        Vector vector = comboBoxDefinition.getListItems();
        String string = comboBoxDefinition.getControlId() + "_" + comboBoxDefinition.getNextSuffix();
        vector.add(new ListDefinition.ListItem(BuilderResUtil.getString("IDS_DEF_COMBO_ITEM"), "", string, true));
        return new ComboBoxObject(comboBoxDefinition);
    }

    private CanvasObject createListBox() {
        ListBoxDefinition listBoxDefinition = new ListBoxDefinition(this.mQuoteHandlingType);
        listBoxDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_LISTBOX_TITLE"));
        Vector vector = listBoxDefinition.getListItems();
        String string = listBoxDefinition.getControlId() + "_" + listBoxDefinition.getNextSuffix();
        vector.add(new ListDefinition.ListItem(BuilderResUtil.getString("IDS_DEF_LISTBOX_ITEM"), "", string, true));
        return new ListBoxObject(listBoxDefinition);
    }

    private CanvasObject createDatasetSelector() {
        DatasetSelectorDefinition datasetSelectorDefinition = new DatasetSelectorDefinition();
        datasetSelectorDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_DATASET_SELECTOR_TITLE"));
        return new DatasetSelectorObject(datasetSelectorDefinition);
    }

    private CanvasObject createRadioGroup() {
        RadioGroupDefinition radioGroupDefinition = new RadioGroupDefinition();
        radioGroupDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_RADIO_GROUP_TITLE"));
        radioGroupDefinition.addRadioItem(BuilderResUtil.getString("IDS_RADIO1"), BuilderResUtil.getString("IDS_RADIO1_TIP"), null, -1);
        radioGroupDefinition.getRadioItem(0).setControlId(radioGroupDefinition.getControlId() + "_" + radioGroupDefinition.getNextSuffix());
        radioGroupDefinition.getRadioItem(0).setIsDefault(true);
        radioGroupDefinition.addRadioItem(BuilderResUtil.getString("IDS_RADIO2"), BuilderResUtil.getString("IDS_RADIO2_TIP"), null, -1);
        radioGroupDefinition.getRadioItem(1).setControlId(radioGroupDefinition.getControlId() + "_" + radioGroupDefinition.getNextSuffix());
        return new RadioGroupObject(radioGroupDefinition);
    }

    private SubDlgButtonObject createSubDlgButton() {
        if (this.getCanvasType() == CanvasType.HeaderFooter) {
            return null;
        }
        SubDlgButtonDefinition subDlgButtonDefinition = new SubDlgButtonDefinition(this.mDialog);
        subDlgButtonDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_BUTTON_TITLE"));
        return new SubDlgButtonObject(subDlgButtonDefinition);
    }

    private ColorPickerCtrlObject createColorPickerCtrl() {
        ColorPickerDefinition colorPickerDefinition = new ColorPickerDefinition(Color.GREEN);
        colorPickerDefinition.setIsLabelAbove(true);
        colorPickerDefinition.setTitle("");
        return new ColorPickerCtrlObject(colorPickerDefinition);
    }

    private CanvasObject createFileSystemBrowser() {
        FileSystemBrowserDefinition fileSystemBrowserDefinition = new FileSystemBrowserDefinition();
        fileSystemBrowserDefinition.setTitle(BuilderResUtil.getString("IDS_DEF_FSB_TITLE"));
        LinkedList linkedList = fileSystemBrowserDefinition.getFilterList();
        linkedList.add(new FileSystemBrowserDefinition.FilterItem(BuilderResUtil.getString("IDS_ALL_FILE_TYPES"), "*.*", FileSystemBrowserDefinition.FilterType.AllFiles));
        return new FileSystemBrowserObject(fileSystemBrowserDefinition);
    }

    private CanvasObject createDialogTab() {
        DraggableTabbedPane draggableTabbedPane = this.mFrame.getTabbedPane();
        if (draggableTabbedPane == null) {
            return this.mFrame.recreateTabbedCanvas();
        }
        int n = draggableTabbedPane.getTabCount();
        return BuilderUtil.getInstance().createDialogTab(this.mFrame, n);
    }

    private Point snapToGrid(Point point) {
        if (!this.isSnapToGrid()) {
            return point;
        }
        Point point2 = new Point(point);
        int n = this.mGridSize / 2;
        point2.x = (point2.x + n) / this.mGridSize * this.mGridSize;
        point2.y = (point2.y + n) / this.mGridSize * this.mGridSize;
        return point2;
    }

    private void doCanvasContextMenu(MouseEvent mouseEvent, CanvasObject canvasObject) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new TableInsertIdAction(canvasObject.getControlId()));
        jPopupMenu.show(canvasObject, mouseEvent.getX(), mouseEvent.getY());
    }

    class TableInsertIdAction
    extends AbstractAction {
        private String mId;

        TableInsertIdAction(String string) {
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                this.putValue("Name", BuilderResUtil.getString("Add_to_syntax_template"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("Add_to_script_template"));
            }
            this.mId = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuilderCanvas.this.mFrame.insertControlSyntax(this.mId);
        }
    }

    class KeyHandler
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                CanvasObject canvasObject = BuilderCanvas.this.getSelectedObject();
                if (canvasObject != null) {
                    BuilderCanvas.this.removeObject(canvasObject);
                    BuilderCanvas.this.itemRemoved(canvasObject);
                    BuilderCanvas.this.mFrame.removeCanvasObject(canvasObject);
                }
            } else if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 39) {
                CanvasObject canvasObject = (CanvasObject)keyEvent.getComponent();
                CanvasObject canvasObject2 = BuilderCanvas.this.getNextObject(canvasObject, true);
                BuilderCanvas.this.setSelected(canvasObject2);
                BuilderCanvas.this.fireSelectionChange(canvasObject2);
            } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 37) {
                CanvasObject canvasObject = (CanvasObject)keyEvent.getComponent();
                CanvasObject canvasObject3 = BuilderCanvas.this.getNextObject(canvasObject, false);
                BuilderCanvas.this.setSelected(canvasObject3);
                BuilderCanvas.this.fireSelectionChange(canvasObject3);
            }
        }
    }

    class CanvasDragAdapter
    extends ComponentDragAdapter {
        public CanvasDragAdapter(DragPane dragPane) {
            super(dragPane, "CanvasDragAdapter");
        }

        protected void acquireTransferData() {
            this.mTransferData = BuilderCanvas.this.getSelectedObject();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            super.mousePressed(mouseEvent);
            Object object = mouseEvent.getSource();
            if (object instanceof CanvasObject) {
                CanvasObject canvasObject = (CanvasObject)object;
                BuilderCanvas.this.setSelected(canvasObject);
                if (canvasObject instanceof SrcListObject || canvasObject instanceof StaticCtrlObject || canvasObject instanceof StaticImageObject || canvasObject instanceof SubDlgButtonObject) {
                    mouseEvent.consume();
                    BuilderCanvas.this.fireSelectionChange(canvasObject);
                    return;
                }
                if (mouseEvent.isPopupTrigger()) {
                    BuilderCanvas.this.doCanvasContextMenu(mouseEvent, (CanvasObject)object);
                }
                mouseEvent.consume();
                BuilderCanvas.this.fireSelectionChange(canvasObject);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            Object object = mouseEvent.getSource();
            if (object instanceof CanvasObject) {
                mouseEvent.consume();
                CanvasObject canvasObject = (CanvasObject)object;
                if (canvasObject instanceof SrcListObject || canvasObject instanceof StaticCtrlObject || canvasObject instanceof StaticImageObject || canvasObject instanceof SubDlgButtonObject) {
                    return;
                }
                if (mouseEvent.isPopupTrigger()) {
                    BuilderCanvas.this.doCanvasContextMenu(mouseEvent, (CanvasObject)object);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            if (mouseEvent.getClickCount() > 1 && mouseEvent.getSource() instanceof CanvasObject) {
                CanvasObject canvasObject = (CanvasObject)mouseEvent.getSource();
                BuilderCanvas.this.mFrame.launchControlEditor(canvasObject.getCtrlDef());
            }
        }

        protected void startDrag(MouseEvent mouseEvent) {
            this.mDragPane.setImageHotSpot(mouseEvent.getPoint());
            if (this.mTransferData == null) {
                this.acquireTransferData();
            }
            super.startDrag(mouseEvent);
        }
    }

    public static enum CanvasType {
        HeaderFooter,
        Normal;

    }
}

