/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.fopen;

import java.io.File;
import java.net.URI;

public class SpssFile
extends File {
    public static final String extensionSeparator = ".";
    public static final char extensionSeparatorChar = '.';

    public SpssFile(File file, String string) {
        super(file, string);
    }

    public SpssFile(String string, String string2) {
        super(string, string2);
    }

    public SpssFile(String string) {
        super(string);
    }

    public SpssFile(URI uRI) {
        super(uRI);
    }

    public static boolean recursiveDelete(File file) {
        if (file.exists()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isDirectory()) {
                    SpssFile.recursiveDelete(file2);
                    continue;
                }
                file2.delete();
            }
        }
        return file.delete();
    }

    public boolean recursiveDelete() {
        return SpssFile.recursiveDelete(this);
    }

    public static boolean deleteDirectory(File file, String string) {
        boolean bl = true;
        bl = file.isDirectory();
        if (bl) {
            File file2 = new File(string);
            File file3 = file;
            File file4 = new File(string + File.separator + file3.getName());
            if (file4.exists()) {
                bl = SpssFile.recursiveDelete(file4);
            }
            if (bl) {
                if (!file2.exists()) {
                    bl = file2.mkdirs();
                }
                if (bl && (bl = SpssFile.renameDirectory(file3, file4))) {
                    SpssFile.recursiveDelete(file4);
                }
            }
        }
        return bl;
    }

    public static boolean renameDirectory(File file, File file2) {
        return SpssFile.renameDirectory(file.getAbsolutePath(), file2.getAbsolutePath());
    }

    public static boolean renameDirectory(String string, String string2) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        File file2 = new File(string2);
        return file.renameTo(file2);
    }

    public String getBasename() {
        String string = this.getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public String getExtension() {
        String string = "";
        String string2 = this.getName();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string = string2.substring(n + 1);
        }
        return string;
    }

    public boolean hasExtension() {
        return this.getName().contains(extensionSeparator);
    }

    public boolean hasExtension(Extension extension) {
        boolean bl = false;
        String string = "";
        String string2 = this.getName();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string = string2.substring(n + 1);
        }
        switch (extension) {
            case EMPTY: {
                bl = string.length() == 0;
                break;
            }
            case BITMAP: 
            case ENHANCED_METAFILE: 
            case ENCAPSULATED_POSTSCRIPT: 
            case EXCEL: 
            case EXCELX: 
            case EXCELM: {
                bl = string.equalsIgnoreCase(extension.getValue());
                break;
            }
            case HYPERTEXT_MARKUP_LANGUAGE: {
                bl = string.equalsIgnoreCase(extension.getValue()) || string.equalsIgnoreCase("html");
                break;
            }
            case JOINT_PHOTOGRAPHIC_EXPERTS_GROUP: {
                bl = string.equalsIgnoreCase(extension.getValue()) || string.equalsIgnoreCase("jpeg");
                break;
            }
            case PORTABLE_DOCUMENT_FORMAT: 
            case PORTABLE_NETWORK_GRAPHICS: 
            case POWER_POINT: 
            case SPSS_WINWRAP_SCRIPT: 
            case SPSS_DATASOURCE: 
            case SPSS_LEGACY_PRODUCTION_JOB: 
            case SPSS_LEGACY_VIEWER: 
            case SPSS_PRODUCTION_JOB: 
            case SPSS_SYNTAX: 
            case SPSS_VIEWER: {
                bl = string.equalsIgnoreCase(extension.getValue());
                break;
            }
            case TAGGED_IMAGE_FILE_FORMAT: {
                bl = string.equalsIgnoreCase(extension.getValue()) || string.equalsIgnoreCase("tiff");
                break;
            }
            case TEXT: 
            case WORD_RTF: {
                bl = string.equalsIgnoreCase(extension.getValue());
                break;
            }
        }
        return bl;
    }

    public static enum Extension {
        EMPTY(""),
        BITMAP("bmp"),
        ENHANCED_METAFILE("emf"),
        ENCAPSULATED_POSTSCRIPT("eps"),
        EXCEL("xls"),
        EXCELX("xlsx"),
        EXCELM("xlsm"),
        HYPERTEXT_MARKUP_LANGUAGE("htm"),
        JOINT_PHOTOGRAPHIC_EXPERTS_GROUP("jpg"),
        PORTABLE_DOCUMENT_FORMAT("pdf"),
        PORTABLE_NETWORK_GRAPHICS("png"),
        POWER_POINT("ppt"),
        SPSS_WINWRAP_SCRIPT("wwd"),
        SPSS_DATASOURCE("sav"),
        SPSS_LEGACY_PRODUCTION_JOB("spp"),
        SPSS_LEGACY_VIEWER("spo"),
        SPSS_PRODUCTION_JOB("spj"),
        SPSS_SYNTAX("sps"),
        SPSS_VIEWER("spv"),
        TAGGED_IMAGE_FILE_FORMAT("tif"),
        TEXT("txt"),
        WORD_RTF("doc");

        private final String value;

        private Extension(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }
    }
}

