/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.fopen;

import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.FileTextField;
import com.spss.shared.custom_gui.ui_builder.app.fopen.ChooserUIFactory;
import com.spss.shared.custom_gui.ui_builder.app.fopen.FileDialogKeyAdapter;
import com.spss.shared.custom_gui.ui_builder.app.fopen.FilenameTextFieldPrompter;
import com.spss.shared.custom_gui.ui_builder.app.fopen.IFileBrowseCallback;
import com.spss.shared.custom_gui.ui_builder.app.fopen.LocalFileSysUtil;
import com.spss.shared.custom_gui.ui_builder.app.fopen.RefFileFilter;
import com.spss.shared.custom_gui.ui_builder.app.fopen.RefWindowsFileChooserUI;
import com.spss.shared.custom_gui.ui_builder.app.fopen.RemoteFileView;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.DlgKeyPressListener;
import com.spss.uitools.dialogs.IDlgKeyPressListener;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.util.EncodingValidator;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.charset.CoderResult;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;
import sun.swing.plaf.synth.SynthFileChooserUIImpl;

public class RemoteFileChooser
extends JFileChooser {
    private static final byte WRITE_PERMISSION = 0;
    private static final byte NO_WRITE_PERMISSION = 1;
    private static final byte INVALID_RESOURCE = 2;
    protected static final String SHOW_HIDDEN_PROP = "awt.file.showHiddenFiles";
    protected ChooserType mChooserType = ChooserType.OpenFile;
    protected PropertyChangeListener mShowFilesListener = null;
    protected boolean mUseFileHiding = true;
    protected String mDefaultExt = null;
    protected Vector<RefFileFilter> mFilters = new Vector(5);
    protected boolean mUseAcceptAllFileFilter = true;
    protected ChooserOption mChooserOption = ChooserOption.Generic;
    protected boolean mLockEnabled = false;
    protected boolean mPasteSelected = false;
    protected boolean mUseServerFileSystem = false;
    protected transient FileView mUIFileView = null;
    protected boolean mUseSaveAsFileChooserUI = false;
    protected boolean mShowLastSelectedFile = false;
    protected boolean mUseQuaqua = false;
    public RefFileFilter mDefaultFileFilter;
    protected Component mParentComponent;
    protected WeakReference<Component> mDialogReference;
    protected String mEncodingSelection = "";
    protected boolean mIsMinStringWidths = false;
    protected boolean mReaderLock = false;
    protected boolean mIsEncryptFileWithPassword = false;
    protected String mEncryptFilePassword = null;
    protected boolean mOverwriteAlert = true;
    protected JCheckBox mWriteCheckBox;
    protected JCheckBox mSaveValueLabelsCheckBox;
    protected JCheckBox mSaveValueLabelsToFileCheckBox;
    private FilenameTextFieldPrompter mFilenamePrompter = null;
    private boolean mAllowPesButton = true;
    private boolean mShowDownloadInfoMsg = false;
    private static IFileBrowseCallback sFileBrowseCallback = null;
    private static final char Bidi_LRM = '\u200e';
    RemoteFileDialog mDialog;
    MyAWTKeyEventListener mMyAWTKeyEventListener = new MyAWTKeyEventListener();

    public RemoteFileChooser(ChooserType chooserType, ChooserOption chooserOption, String string, boolean bl) {
        this(chooserType, chooserOption, string, bl, false);
    }

    public RemoteFileChooser(ChooserType chooserType, ChooserOption chooserOption, String string, boolean bl, boolean bl2) {
        this(chooserType, chooserOption, string, bl, bl2, false);
    }

    public RemoteFileChooser(ChooserType chooserType, ChooserOption chooserOption, String string, boolean bl, boolean bl2, boolean bl3) {
        this(chooserType, chooserOption, string, bl, bl2, bl3, true);
    }

    public RemoteFileChooser(ChooserType chooserType, ChooserOption chooserOption, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(chooserType, chooserOption, string, bl, bl2, bl3, bl4, false);
    }

    public RemoteFileChooser(ChooserType chooserType, ChooserOption chooserOption, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super((String)null);
        Object object;
        this.mChooserType = chooserType;
        this.mChooserOption = chooserOption;
        this.mUseSaveAsFileChooserUI = bl2;
        this.mShowLastSelectedFile = bl3;
        this.mUseQuaqua = ChooserUIFactory.isUseQuaqua();
        this.mAllowPesButton = bl4;
        this.mShowDownloadInfoMsg = bl5;
        this.mUseServerFileSystem = false;
        this.mDefaultExt = "";
        if (this.mChooserType == ChooserType.OpenFolder) {
            this.setFileSelectionMode(1);
            this.setAcceptAllFileFilterUsed(false);
            object = new RefFileFilter(BuilderResUtil.getString("IDS_FILE_FOLDER_FILTER"), "");
            this.setFileFilter((FileFilter)object);
        } else {
            this.setFileSelectionMode(0);
        }
        this.setTitle();
        this.setup(null);
        object = string;
        if (this.mUseServerFileSystem) {
            // empty if block
        }
        if (object == null || ((String)object).length() == 0) {
            this.setCurrentDirectory(null);
        } else {
            this.setCurrentDirectory(this.getFileSystemView().createFileObject((String)object));
        }
        FileDialogKeyAdapter fileDialogKeyAdapter = new FileDialogKeyAdapter(this);
        fileDialogKeyAdapter.addDlgKeyPressListener((IDlgKeyPressListener)new DlgKeyPressListener());
        if (null == System.getenv("spss.no.file.dialog.prompter") && !this.mUseServerFileSystem) {
            this.scan(this);
            if (this.mFilenamePrompter != null) {
                this.addPropertyChangeListener(this.mFilenamePrompter.getDirectoryChangedListener());
                this.mFilenamePrompter.setRemoteFileSystemView(this.mUseServerFileSystem);
            }
        }
    }

    public int showSaveDialog(Component component, String string, String string2) throws HeadlessException {
        this.setDialogType(1);
        return this.showDialog(component, null, string, string2);
    }

    public int showSaveDialog(Component component, String string) throws HeadlessException {
        this.setDialogType(1);
        return this.showDialog(component, null, string);
    }

    public boolean isSaveDataAsFileChooser() {
        return this.mUseSaveAsFileChooserUI;
    }

    public ChooserType getChooserType() {
        return this.mChooserType;
    }

    public ChooserOption getChooserOption() {
        return this.mChooserOption;
    }

    public void setChooserOption(ChooserOption chooserOption) {
        this.mChooserOption = chooserOption;
        this.updateUI();
    }

    public String getDefaultExt() {
        return this.mDefaultExt;
    }

    public void setDefaultExt(String string) {
        this.mDefaultExt = string;
    }

    public boolean isPasteSelected() {
        return this.mPasteSelected;
    }

    public void setPasteSelected(boolean bl) {
        this.mPasteSelected = bl;
    }

    public boolean isLockSelected() {
        return this.mLockEnabled;
    }

    public void setLockSelected(boolean bl) {
        this.mLockEnabled = bl;
    }

    public boolean isServerFileSystem() {
        return this.mUseServerFileSystem;
    }

    public void setUseServerFileSystem(boolean bl) {
        this.mUseServerFileSystem = bl;
    }

    public boolean getAllowPesButton() {
        return this.mAllowPesButton;
    }

    public boolean ShowDownloadInfoMsg() {
        return this.mShowDownloadInfoMsg;
    }

    public void doHelp() {
        BuilderUtil.getInstance().showHelp("spss/base/idh_fopen_help_button");
    }

    @Override
    public void rescanCurrentDirectory() {
        FileSystemView fileSystemView = this.getFileSystemView();
        this.getUI().rescanCurrentDirectory(this);
    }

    @Override
    public int showDialog(Component component, String string) throws HeadlessException {
        return this.showDialog(component, string, null, null);
    }

    public int showDialog(Component component, String string, String string2, String string3) throws HeadlessException {
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mMyAWTKeyEventListener, 8L);
        if (string2 != null || !this.mShowLastSelectedFile) {
            this.setFileNameTextField(string2);
        }
        if (string3 == null || string3.length() != 0) {
            // empty if block
        }
        if (this.mDefaultFileFilter != null) {
            this.setFileFilter(this.mDefaultFileFilter);
        }
        int n = super.showDialog(component, string);
        return n;
    }

    public int showDialog(Component component, String string, String string2) throws HeadlessException {
        return this.showDialog(component, string, string2, null);
    }

    @Override
    public void updateUI() {
        this.installStrings();
        if (this.mUseServerFileSystem) {
            if (this.isAcceptAllFileFilterUsed()) {
                this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            }
            this.setUI(null);
            this.mUIFileView = this.getUI().getFileView(this);
            if (this.isAcceptAllFileFilterUsed()) {
                this.addChoosableFileFilter(this.getAcceptAllFileFilter());
            }
        } else {
            super.updateUI();
        }
    }

    @Override
    public String getName(File file) {
        String string = super.getName(file);
        return string;
    }

    @Override
    public String getDescription(File file) {
        String string = super.getDescription(file);
        return string;
    }

    @Override
    public String getTypeDescription(File file) {
        String string = super.getTypeDescription(file);
        return string;
    }

    @Override
    public Icon getIcon(File file) {
        Icon icon = null;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            if (this.getFileView() != null) {
                icon = this.getFileView().getIcon(file);
            }
            if (icon == null && this.mUIFileView != null) {
                icon = this.mUIFileView.getIcon(file);
            }
            if (icon instanceof ImageIcon && icon.getIconHeight() > 26) {
                icon = this.resizeImage((ImageIcon)icon, 16, 16);
            }
        } else {
            icon = super.getIcon(file);
        }
        return icon;
    }

    @Override
    public boolean isTraversable(File file) {
        Boolean bl = super.isTraversable(file);
        return bl != null && bl != false;
    }

    @Override
    public void setSelectedFile(File file) {
        if (file != null) {
            String string = file.getAbsolutePath();
            if (string != null && string.length() > 0 && string.indexOf(8206) != -1) {
                string = FileTextField.removeLRM(string);
            }
            if (this.mChooserType == ChooserType.OpenFolder && string.indexOf(":\\", 4) > -1) {
                int n = string.indexOf(":\\", 4);
                int n2 = string.lastIndexOf(File.separator, n - 1);
                file = new File(string.substring(n2 + 1));
            }
            if (FileTextField.isPathBidiProcessingNeeded(file.getAbsolutePath())) {
                String string2 = FileTextField.insertLRM(file.getAbsolutePath());
                file = new File(string2);
            }
        }
        super.setSelectedFile(file);
    }

    @Override
    public void approveSelection() {
        String string = null;
        if (this.getChooserType().equals((Object)ChooserType.SaveFile) || this.getChooserType().equals((Object)ChooserType.OpenCreateFile)) {
            boolean bl;
            File file = this.getSelectedFile();
            boolean bl2 = bl = !file.exists();
            if (bl) {
                boolean bl3;
                Object object;
                ChooserOption chooserOption = this.getChooserOption();
                String string2 = "";
                if (chooserOption.equals((Object)ChooserOption.Data)) {
                    object = this.getFileFilter();
                    string2 = object instanceof RefFileFilter ? "." + ((RefFileFilter)object).getExtension() : ".sav";
                } else if (chooserOption.equals((Object)ChooserOption.Syntax)) {
                    string2 = ".sps";
                } else if (chooserOption.equals((Object)ChooserOption.Output)) {
                    object = this.getFileFilter();
                    string2 = object instanceof RefFileFilter ? "." + ((RefFileFilter)object).getExtension() : ".spv";
                } else {
                    object = this.getFileFilter();
                    if (object instanceof RefFileFilter && ((RefFileFilter)object).getExtension().length() > 0) {
                        string2 = "." + ((RefFileFilter)object).getExtension();
                    }
                }
                string = file.getName();
                object = "\"";
                boolean bl4 = bl3 = string.startsWith((String)object) && string.endsWith((String)object);
                if (bl3) {
                    String string3 = string.substring(1, string.length() - 1);
                    string = RemoteFileChooser.getDirectoryName(file, this.isServerFileSystem());
                    string = string + "\\" + string3;
                    this.setSelectedFile(new File(string));
                } else if (string2.length() > 0 && !this.hasDesiredExtension(string, string2)) {
                    string = file.getAbsolutePath();
                    string = string + string2;
                    this.setSelectedFile(new File(string));
                }
            }
        }
        if (this.canProceed(this.getDialogComponent())) {
            super.approveSelection();
        }
    }

    private boolean hasDesiredExtension(String string, String string2) {
        String string3 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string3 = string.substring(n).trim();
            string3 = string3.toLowerCase(BuilderUtil.getInstance().getAppLocale());
        }
        return string3.equals(string2);
    }

    private void displayCannotSaveInFolderAlert(Component component) {
        if (component instanceof Window) {
            BuilderAlertPane.showWarningMessageDialog((Window)component, BuilderResUtil.getString("ERR_CANNOT_SAVE_IN_SPECIFIED_FOLDER"), BuilderUtil.getInstance().getAppVersionString());
        } else if (component instanceof JComponent) {
            BuilderAlertPane.showWarningMessageDialog((JComponent)component, BuilderResUtil.getString("ERR_CANNOT_SAVE_IN_SPECIFIED_FOLDER"), BuilderUtil.getInstance().getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, BuilderResUtil.getString("ERR_CANNOT_SAVE_IN_SPECIFIED_FOLDER"), BuilderUtil.getInstance().getAppVersionString(), 2);
        }
    }

    @Override
    public void setFileSystemView(FileSystemView fileSystemView) {
        super.setFileSystemView(fileSystemView);
    }

    @Override
    public FileFilter[] getChoosableFileFilters() {
        if (this.mUseServerFileSystem) {
            int n = this.mFilters != null ? this.mFilters.size() : 0;
            Object[] objectArray = new RefFileFilter[n];
            if (this.mFilters != null) {
                this.mFilters.copyInto(objectArray);
            }
            return objectArray;
        }
        return super.getChoosableFileFilters();
    }

    @Override
    public void addChoosableFileFilter(FileFilter fileFilter) {
        if (this.mUseServerFileSystem && fileFilter instanceof RefFileFilter) {
            RefFileFilter refFileFilter = (RefFileFilter)fileFilter;
            if (!this.mFilters.contains(refFileFilter)) {
                FileFilter[] fileFilterArray = this.getChoosableFileFilters();
                this.mFilters.addElement(refFileFilter);
                this.firePropertyChange("ChoosableFileFilterChangedProperty", fileFilterArray, this.getChoosableFileFilters());
            }
            this.setFileFilter(fileFilter);
        } else {
            super.addChoosableFileFilter(fileFilter);
        }
    }

    @Override
    public boolean removeChoosableFileFilter(FileFilter fileFilter) {
        if (this.mUseServerFileSystem) {
            if (!(fileFilter instanceof RefFileFilter)) {
                assert (false);
                return false;
            }
            if (this.hasFilter((RefFileFilter)fileFilter)) {
                if (this.getFileFilter() == fileFilter) {
                    this.setFileFilter(null);
                }
                FileFilter[] fileFilterArray = this.getChoosableFileFilters();
                this.mFilters.removeElementAt(this.getFilterIndex((RefFileFilter)fileFilter));
                this.firePropertyChange("ChoosableFileFilterChangedProperty", fileFilterArray, this.getChoosableFileFilters());
                return true;
            }
            return false;
        }
        return super.removeChoosableFileFilter(fileFilter);
    }

    @Override
    public void resetChoosableFileFilters() {
        if (this.mUseServerFileSystem) {
            RefFileFilter[] refFileFilterArray = (RefFileFilter[])this.getChoosableFileFilters();
            this.setFileFilter(null);
            this.mFilters.removeAllElements();
            if (this.isAcceptAllFileFilterUsed()) {
                this.addChoosableFileFilter(this.getAcceptAllFileFilter());
            }
            this.firePropertyChange("ChoosableFileFilterChangedProperty", refFileFilterArray, this.getChoosableFileFilters());
        } else {
            super.resetChoosableFileFilters();
        }
    }

    @Override
    public FileFilter getAcceptAllFileFilter() {
        if (this.mUseServerFileSystem) {
            String string = BuilderResUtil.getString("IDS_FILE_CHOOSER_ACCEPT_ALL_FILE_FILTER_TEXT");
            return new RefFileFilter(string, "");
        }
        return super.getAcceptAllFileFilter();
    }

    @Override
    public boolean isAcceptAllFileFilterUsed() {
        if (this.mUseServerFileSystem) {
            return this.mUseAcceptAllFileFilter;
        }
        return super.isAcceptAllFileFilterUsed();
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean bl) {
        if (this.mUseServerFileSystem) {
            boolean bl2 = this.mUseAcceptAllFileFilter;
            this.mUseAcceptAllFileFilter = bl;
            if (!bl) {
                this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            } else {
                this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
                this.addChoosableFileFilter(this.getAcceptAllFileFilter());
            }
            this.firePropertyChange("acceptAllFileFilterUsedChanged", bl2, this.mUseAcceptAllFileFilter);
        } else {
            super.setAcceptAllFileFilterUsed(bl);
        }
    }

    @Override
    public File getCurrentDirectory() {
        return super.getCurrentDirectory();
    }

    @Override
    public void setCurrentDirectory(File file) {
        if (this.mFilters == null) {
            return;
        }
        super.setCurrentDirectory(file);
        if (file != null && !this.mUseQuaqua && !this.mUseServerFileSystem) {
            ((RefWindowsFileChooserUI)((Object)this.getUI())).enableNewFolderButton(this.canWriteFile(file.getAbsolutePath()) == 0);
        }
    }

    @Override
    public boolean isFileHidingEnabled() {
        if (this.mUseServerFileSystem) {
            return this.mUseFileHiding;
        }
        return super.isFileHidingEnabled();
    }

    @Override
    public void setFileHidingEnabled(boolean bl) {
        super.setFileHidingEnabled(bl);
    }

    @Override
    public FileSystemView getFileSystemView() {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        this.setFileSystemView(fileSystemView);
        return fileSystemView;
    }

    public void setFileFilter(FileFilter fileFilter, boolean bl) {
        this.setFileFilter(fileFilter);
        if (bl && fileFilter instanceof RefFileFilter) {
            this.mDefaultFileFilter = (RefFileFilter)fileFilter;
        }
    }

    @Override
    public void setFileFilter(FileFilter fileFilter) {
        String string;
        if (fileFilter == null) {
            super.setFileFilter(fileFilter);
            return;
        }
        if (fileFilter instanceof RefFileFilter) {
            super.setFileFilter(fileFilter);
            return;
        }
        for (FileFilter object2 : this.getChoosableFileFilters()) {
            if (!fileFilter.getDescription().equals(object2.getDescription())) continue;
            super.setFileFilter(fileFilter);
            return;
        }
        int n = fileFilter.getDescription().lastIndexOf(File.separator);
        if (n > -1) {
            string = fileFilter.getDescription().substring(n + 1, fileFilter.getDescription().length());
            this.setCurrentDirectory(new File(fileFilter.getDescription().substring(0, n + 1)));
        } else {
            string = fileFilter.getDescription();
        }
        final String string2 = string;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RemoteFileChooser.this.setSelectedFile(new File(string2));
            }
        });
        int n2 = fileFilter.getDescription().lastIndexOf("*.*");
        if (n2 > -1) {
            super.setFileFilter(fileFilter);
            return;
        }
        FilenameTextFieldPrompter.PatternFileFilter patternFileFilter = new FilenameTextFieldPrompter.PatternFileFilter(string);
        this.addChoosableFileFilter(patternFileFilter);
        super.setFileFilter(patternFileFilter);
    }

    public Component getParentComponent() {
        return this.mParentComponent;
    }

    public Component getDialogComponent() {
        Component component = (Component)this.mDialogReference.get();
        if (component != null) {
            return component;
        }
        return this.mParentComponent;
    }

    public void setSaveCheckBoxes(JCheckBox jCheckBox, JCheckBox jCheckBox2, JCheckBox jCheckBox3) {
        this.mWriteCheckBox = jCheckBox;
        this.mSaveValueLabelsCheckBox = jCheckBox2;
        this.mSaveValueLabelsToFileCheckBox = jCheckBox3;
    }

    public JCheckBox getWriteCheckBox() {
        return this.mWriteCheckBox;
    }

    public JCheckBox getSaveValueLabelsCheckBox() {
        return this.mSaveValueLabelsCheckBox;
    }

    public JCheckBox getSaveValueLabelsToFileCheckBox() {
        return this.mSaveValueLabelsToFileCheckBox;
    }

    public boolean getIsMinimizeStringWidths() {
        return this.mUseQuaqua ? this.mIsMinStringWidths : this.getRefWindowsFileChooserUI().getIsMinimizeStringWidths();
    }

    public void setIsMinimizeStringWidths(boolean bl) {
        if (this.mUseQuaqua) {
            this.mIsMinStringWidths = bl;
        } else {
            this.getRefWindowsFileChooserUI().setIsMinimizeStringWidths(bl);
        }
    }

    public boolean readerLock() {
        return this.mUseQuaqua ? this.mReaderLock : this.getRefWindowsFileChooserUI().readerLock();
    }

    public void readerLock(boolean bl) {
        if (this.mUseQuaqua) {
            this.mReaderLock = bl;
        } else {
            this.getRefWindowsFileChooserUI().readerLock(bl);
        }
    }

    public boolean isEncodingSelectionEnabled() {
        boolean bl = false;
        RefWindowsFileChooserUI refWindowsFileChooserUI = (RefWindowsFileChooserUI)((Object)this.getUI());
        if (refWindowsFileChooserUI != null) {
            bl = refWindowsFileChooserUI.isEncodingEnabled();
        }
        return bl;
    }

    public String getEncodingSelection() {
        String string;
        if (this.mUseQuaqua) {
            string = this.mEncodingSelection;
        } else {
            RefWindowsFileChooserUI refWindowsFileChooserUI = (RefWindowsFileChooserUI)((Object)this.getUI());
            string = refWindowsFileChooserUI.getSelectedEncoding();
        }
        return string;
    }

    public void setEncodingSelection(String string) {
        if (this.mUseQuaqua) {
            this.mEncodingSelection = string;
        } else {
            RefWindowsFileChooserUI refWindowsFileChooserUI = (RefWindowsFileChooserUI)((Object)this.getUI());
            refWindowsFileChooserUI.setSelectedEncoding(string);
        }
    }

    public static void setFilebrowseCallback(IFileBrowseCallback iFileBrowseCallback) {
        sFileBrowseCallback = iFileBrowseCallback;
    }

    public static IFileBrowseCallback getFileBrowseCallback() {
        return sFileBrowseCallback;
    }

    protected void installStrings() {
        this.putClientProperty("FileChooser.useShellFolder", !this.mUseServerFileSystem);
        UIManager.getDefaults().put("FileChooser.lookInLabelText", BuilderResUtil.getString("IDS_FILE_CHOOSER_LOOK_IN_LABEL_TEXT"));
        UIManager.getDefaults().put("FileChooser.fileNameLabelText", BuilderResUtil.getString("IDS_FILE_CHOOSER_FILE_NAME_LABEL_TEXT"));
        UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", BuilderResUtil.getString("IDS_FILE_CHOOSER_FILES_OF_TYPE_LABEL_TEXT"));
        UIManager.getDefaults().put("FileChooser.saveInLabelText", BuilderResUtil.getString("IDS_FILE_CHOOSER_SAVE_IN_LABEL_TEXT"));
        UIManager.getDefaults().put("FileChooser.acceptAllFileFilterText", BuilderResUtil.getString("IDS_FILE_CHOOSER_ACCEPT_ALL_FILE_FILTER_TEXT"));
        UIManager.getDefaults().put("FileChooser.readOnly", (Object)this.mUseServerFileSystem);
        if (BuilderResUtil.getString("IDS_FILE_CHOOSER_OPEN_BUTTON_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.openButtonText", BuilderResUtil.getString("IDS_FILE_CHOOSER_OPEN_BUTTON_TEXT"));
        }
        if (BuilderResUtil.getString("IDS_FILE_CHOOSER_CANCEL_BUTTON_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.cancelButtonText", BuilderResUtil.getString("IDS_FILE_CHOOSER_CANCEL_BUTTON_TEXT"));
        }
        if (BuilderResUtil.getString("IDS_FILE_CHOOSER_UP_FOLDER_TOOLTIP_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.upFolderToolTipText", BuilderResUtil.getString("IDS_FILE_CHOOSER_UP_FOLDER_TOOLTIP_TEXT"));
        }
        if (BuilderResUtil.getString("IDS_FILE_CHOOSER_DETAILS_VIEW_TOOLTIP_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.detailsViewButtonToolTipText", BuilderResUtil.getString("IDS_FILE_CHOOSER_DETAILS_VIEW_TOOLTIP_TEXT"));
        }
        if (BuilderResUtil.getString("IDS_FILE_CHOOSER_SAVE_BUTTON_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.saveButtonText", BuilderResUtil.getString("IDS_FILE_CHOOSER_SAVE_BUTTON_TEXT"));
        }
        if (BuilderResUtil.getString("IDS_FILE_CHOOSER_NEW_FOLDER_TOOLTIP_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.newFolderToolTipText", BuilderResUtil.getString("IDS_FILE_CHOOSER_NEW_FOLDER_TOOLTIP_TEXT"));
        }
        if (BuilderResUtil.getString("IDS_FILE_CHOOSER_LIST_VIEW_TOOLTIP_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.listViewButtonToolTipTextlist", BuilderResUtil.getString("IDS_FILE_CHOOSER_LIST_VIEW_TOOLTIP_TEXT"));
        }
        if (this.hasResource("IDK_FILE_CHOOSER_OPEN_BUTTON_KEY")) {
            UIManager.getDefaults().put("FileChooser.openButtonMnemonic", BuilderResUtil.getAccessKey("IDK_FILE_CHOOSER_OPEN_BUTTON"));
        }
        UIManager.getDefaults().put("FileChooser.cancelButtonMnemonic", BuilderResUtil.getAccessKey("IDK_FILE_CHOOSER_CANCEL_BUTTON"));
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            UIManager.getDefaults().put("FileChooser.lookInLabelMnemonic", (Object)35);
            UIManager.getDefaults().put("FileChooser.fileNameLabelMnemonic", (Object)35);
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelMnemonic", (Object)35);
            UIManager.getDefaults().put("FileChooser.saveButtonMnemonic", (Object)35);
            UIManager.getDefaults().put("FileChooser.openButtonMnemonic", (Object)35);
            UIManager.getDefaults().put("FileChooser.newFolderTitleText", UIManager.getString("FileChooser.win32.newFolder"));
        }
        if (this.getChooserType().equals((Object)ChooserType.SaveFile)) {
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", BuilderResUtil.getString("IDS_FILE_CHOOSER_SAVE_FILES_OF_TYPE_LABEL_TEXT"));
        }
        if (this.mChooserType == ChooserType.OpenFolder) {
            UIManager.getDefaults().put("FileChooser.fileNameLabelText", BuilderResUtil.getString("IDS_FILE_CHOOSER_FOLDER_LABEL_TEXT"));
        }
    }

    private boolean hasResource(String string) {
        ResourceBundle resourceBundle = BuilderResUtil.getBundle(null, null);
        if (resourceBundle != null) {
            try {
                return resourceBundle.getObject(string) != null;
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    @Override
    protected void setUI(ComponentUI componentUI) {
        if (this.mUseQuaqua) {
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                FileChooserUI fileChooserUI = ChooserUIFactory.getMacChooserUI(this, this.mChooserType == ChooserType.SaveFile);
                super.setUI(fileChooserUI);
            } else {
                SynthFileChooserUIImpl synthFileChooserUIImpl = new SynthFileChooserUIImpl(this);
                super.setUI(synthFileChooserUIImpl);
                this.setFileView(new FileView(){

                    @Override
                    public String getDescription(File file) {
                        return file.getName();
                    }

                    @Override
                    public Icon getIcon(File file) {
                        return UIManager.getIcon(file.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
                    }

                    @Override
                    public String getName(File file) {
                        return file.getName();
                    }

                    @Override
                    public String getTypeDescription(File file) {
                        return file.getName();
                    }

                    @Override
                    public Boolean isTraversable(File file) {
                        return file.isDirectory();
                    }
                });
            }
        } else {
            FileChooserUI fileChooserUI = ChooserUIFactory.getChooserUI(this);
            super.setUI(fileChooserUI);
        }
    }

    protected boolean hasFilter(RefFileFilter refFileFilter) {
        return this.mUseServerFileSystem && this.getFilterIndex(refFileFilter) > -1;
    }

    protected int getFilterIndex(RefFileFilter refFileFilter) {
        for (int i = 0; i < this.mFilters.size(); ++i) {
            RefFileFilter refFileFilter2 = this.mFilters.get(i);
            if (!refFileFilter2.getDescription().equals(refFileFilter.getDescription()) || !refFileFilter2.getExtension().equals(refFileFilter.getExtension())) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void setup(FileSystemView fileSystemView) {
        if (this.mFilters == null) {
            return;
        }
        if (this.mUseServerFileSystem || OSInfo.getOSType() == OSInfo.OSType.MAC) {
            assert (fileSystemView == null);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Object object = toolkit.getDesktopProperty(SHOW_HIDDEN_PROP);
            if (object instanceof Boolean) {
                this.mUseFileHiding = (Boolean)object == false;
                this.mShowFilesListener = new WeakPCL(this);
                toolkit.addPropertyChangeListener(SHOW_HIDDEN_PROP, this.mShowFilesListener);
            }
            RemoteFileView remoteFileView = new RemoteFileView();
            this.setFileView(remoteFileView);
            this.setFileSystemView(fileSystemView);
            this.updateUI();
        } else {
            super.setup(fileSystemView);
        }
    }

    protected String getFilterString() {
        RefFileFilter refFileFilter;
        String string = "";
        FileFilter fileFilter = this.getFileFilter();
        RefFileFilter refFileFilter2 = refFileFilter = fileFilter instanceof RefFileFilter ? (RefFileFilter)fileFilter : null;
        if (refFileFilter != null) {
            string = "*." + refFileFilter.getExtension();
        }
        return string;
    }

    @Override
    protected JDialog createDialog(Component component) throws HeadlessException {
        boolean bl;
        Container container;
        RemoteFileDialog remoteFileDialog;
        String string = this.getUI().getDialogTitle(this);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.mParentComponent = component;
        if (component instanceof JDialog) {
            remoteFileDialog = new RemoteFileDialog((JDialog)component, string);
        } else {
            container = JOptionPane.getFrameForComponent(component);
            remoteFileDialog = new RemoteFileDialog((Frame)container, string);
        }
        this.mDialogReference = new WeakReference<RemoteFileDialog>(remoteFileDialog);
        remoteFileDialog.setComponentOrientation(this.getComponentOrientation());
        container = remoteFileDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (bl = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            remoteFileDialog.getRootPane().setWindowDecorationStyle(6);
        }
        remoteFileDialog.pack();
        remoteFileDialog.setLocationRelativeTo(component);
        JButton jButton = this.getApproveButton();
        if (jButton != null) {
            remoteFileDialog.getRootPane().setDefaultButton(jButton);
        }
        this.mDialog = remoteFileDialog;
        return remoteFileDialog;
    }

    protected void setFocusOnFileNameTextField() {
        this.getRefWindowsFileChooserUI().getFileNameTextField().requestFocusInWindow();
        this.getRefWindowsFileChooserUI().getFileNameTextField().selectAll();
    }

    public void setFileNameTextField(String string) {
        String string2 = string = string != null ? string : "";
        if (FileTextField.isPathBidiProcessingNeeded(string)) {
            string = FileTextField.insertLRM(string);
        }
        if (this.mUseQuaqua && this.getDialogType() == 1) {
            this.mFilenamePrompter.getPrompterTextField().setText(string);
        } else if (this.getUI() instanceof RefWindowsFileChooserUI) {
            this.getRefWindowsFileChooserUI().getFileNameTextField().setText(string);
        }
    }

    public String getSelectedFilePath() {
        File file = this.getSelectedFile();
        String string = null;
        if (file != null) {
            if (this.mChooserType == ChooserType.OpenFolder && (string = file.getPath()).indexOf(":\\", 4) > -1) {
                return string;
            }
            string = file.getAbsolutePath();
        }
        return string;
    }

    public String getSelectedFileName() {
        String string = null;
        File file = this.getSelectedFile();
        if (file != null) {
            string = file.getName();
        }
        return string;
    }

    @Override
    public File getSelectedFile() {
        CharSequence charSequence;
        File file = super.getSelectedFile();
        if (file != null && file.getPath() != null && file.getPath().length() > 0 && file.getPath().indexOf(8206) != -1) {
            charSequence = FileTextField.removeLRM(file.getPath());
            file = new File((String)charSequence);
        }
        if (this.getChooserType().equals((Object)ChooserType.OpenFile) && file != null && file.getName().length() > 1 && ((StringBuffer)(charSequence = new StringBuffer(file.getName()))).charAt(0) == '\"' && ((StringBuffer)charSequence).charAt(((StringBuffer)charSequence).length() - 1) == '\"') {
            charSequence = ((StringBuffer)charSequence).deleteCharAt(0).deleteCharAt(((StringBuffer)charSequence).length() - 1);
            StringBuffer stringBuffer = new StringBuffer(file.getParent());
            file = stringBuffer == null || stringBuffer.length() < 1 ? new File(((StringBuffer)charSequence).toString()) : new File(stringBuffer.toString() + File.separatorChar + ((StringBuffer)charSequence).toString());
        }
        if (!this.isServerFileSystem() && OSInfo.getOSType() == OSInfo.OSType.WIN && this.getChooserType() == ChooserType.SaveFile && file != null) {
            file = LocalFileSysUtil.getLocalFileSysUtil().getPhysicalLocationFromWin7LibraryPath(file);
        }
        return file;
    }

    @Override
    public void setFileSelectionMode(int n) {
        super.setFileSelectionMode(n);
    }

    public boolean canProceed(Component component) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string = this.getSelectedFilePath();
        bl2 = this.getSelectedFile().exists();
        File file = this.getSelectedFile().getParentFile();
        boolean bl7 = bl3 = file != null && !file.canWrite();
        if (OSInfo.getOSType() == OSInfo.OSType.WIN && (this.getChooserType() == ChooserType.SaveFile || this.getChooserType() == ChooserType.OpenCreateFile)) {
            try {
                byte by = this.canWriteFile(this.getCurrentDirectory().getCanonicalPath());
                if (by == 0) {
                    bl3 = false;
                } else {
                    bl3 = true;
                    if (this.getCurrentDirectory().getCanonicalPath().startsWith("\\\\") && by == 1) {
                        this.displaySecurityPrivilegesAlert(component);
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                if (LocalFileSysUtil.getLocalFileSysUtil().isPathAWindows7LibraryPath(this.getCurrentDirectory())) {
                    if (LocalFileSysUtil.getLocalFileSysUtil().isPathWindows7RootLibraryPath(this.getCurrentDirectory())) {
                        bl3 = true;
                        bl5 = true;
                    } else if (LocalFileSysUtil.getLocalFileSysUtil().isWindows7LibraryEmpty(this.getCurrentDirectory())) {
                        bl3 = true;
                        bl6 = true;
                    } else {
                        bl3 = false;
                    }
                }
                bl3 = true;
            }
        }
        if (bl4 && this.getChooserType() != ChooserType.OpenFolder) {
            return false;
        }
        if (!bl) {
            this.displayProcessorLostCommunicationAlert(component);
        }
        if (this.mChooserType == ChooserType.SaveFile) {
            if (bl3) {
                if (bl5) {
                    this.displayWin7LibraryRootAlert(component);
                } else if (bl6) {
                    this.displayWin7LibraryEmptyAlert(component);
                } else {
                    this.displayDirectoryReadOnlyAlert(component);
                }
                bl = false;
            } else if (bl2) {
                if (bl && this.mOverwriteAlert && !(bl = this.displayConfirmFileExistsAlert(string, component))) {
                    this.setFocusOnFileNameTextField();
                    this.getRefWindowsFileChooserUI().setErrorOccurred(true);
                }
            } else if (bl && !this.checkEncoding(string, component)) {
                return false;
            }
        } else if (this.mChooserType == ChooserType.OpenFile || this.mChooserType == ChooserType.OpenCreateFile || this.mChooserType == ChooserType.OpenFolder) {
            if (this.mChooserType == ChooserType.OpenCreateFile) {
                if (bl3) {
                    this.displayDirectoryReadOnlyAlert(component);
                    bl = false;
                } else {
                    try {
                        this.getSelectedFile().createNewFile();
                        bl2 = true;
                        bl = true;
                    }
                    catch (IOException iOException) {
                        this.displayCannotCreateFileAlert(string, component);
                        bl = false;
                    }
                }
            }
            if (bl && !bl2) {
                if (this.mChooserType == ChooserType.OpenFolder) {
                    this.displayFolderDoesNotExistAlert(string, component);
                } else {
                    this.displayFileDoesNotExistAlert(string, component);
                }
                bl = false;
            } else if (!this.checkEncoding(string, component)) {
                return false;
            }
        }
        return bl;
    }

    private void displaySecurityPrivilegesAlert(Component component) {
        if (component instanceof Window) {
            BuilderAlertPane.showWarningMessageDialog((Window)component, this.getSelectedFile().getName() + "\n" + BuilderResUtil.getString("ERR_SECURITY_PRIVILEGES_OVER_NETWORK"), BuilderUtil.getInstance().getAppVersionString());
        } else if (component instanceof JComponent) {
            BuilderAlertPane.showWarningMessageDialog((JComponent)component, this.getSelectedFile().getName() + "\n" + BuilderResUtil.getString("ERR_SECURITY_PRIVILEGES_OVER_NETWORK"), BuilderUtil.getInstance().getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, this.getSelectedFile().getName() + "\n" + BuilderResUtil.getString("ERR_SECURITY_PRIVILEGES_OVER_NETWORK"), BuilderUtil.getInstance().getAppVersionString(), 2);
        }
    }

    private void displayProcessorLostCommunicationAlert(Component component) {
        String string = BuilderResUtil.getString("ERR_processorLostCommunication");
        if (component instanceof Window) {
            BuilderAlertPane.showWarningMessageDialog((Window)component, string, BuilderUtil.getInstance().getAppVersionString());
        } else if (component instanceof JComponent) {
            BuilderAlertPane.showWarningMessageDialog((JComponent)component, string, BuilderUtil.getInstance().getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string, BuilderUtil.getInstance().getAppVersionString(), 0);
        }
    }

    private boolean displayConfirmFileExistsAlert(String string, Component component) {
        int n;
        int n2;
        String string2 = string + "\n";
        string2 = string2 + BuilderResUtil.getString("ERR_FILE_EXIST_WARNING_MESSAGE");
        boolean bl = component instanceof Window ? (n2 = BuilderAlertPane.showConfirmDialog((Window)component, string2, BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.IconType.eWarning, BuilderAlertPane.OptionType.YES_NO_OPTION)) == 1 : (component instanceof JComponent ? (n = BuilderAlertPane.showConfirmDialog((JComponent)component, string2, BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.IconType.eWarning, BuilderAlertPane.OptionType.YES_NO_OPTION)) == 1 : JOptionPane.showConfirmDialog(this, string2, BuilderUtil.getInstance().getAppVersionString(), 0, 2, new ImageIcon(BuilderResUtil.getImageResource("warning_core.png"))) == 0);
        return bl;
    }

    private void displayCannotCreateFileAlert(String string, Component component) {
        String string2 = string + "\n" + BuilderResUtil.getString("ERR_FILE_CANNOT_CREATE_WARNING_MESSAGE");
        if (component instanceof Window) {
            BuilderAlertPane.showWarningMessageDialog((Window)component, string2, BuilderUtil.getInstance().getAppVersionString());
        } else if (component instanceof JComponent) {
            BuilderAlertPane.showWarningMessageDialog((JComponent)component, string2, BuilderUtil.getInstance().getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string2, BuilderUtil.getInstance().getAppVersionString(), 0);
        }
    }

    public static boolean displayConfirmFileInUseAlert(String string, Component component) {
        JFrame jFrame;
        int n;
        int n2;
        int n3;
        String string2 = BuilderResUtil.getString("IDS_FILE_IN_USE_STRING");
        String string3 = string.substring(string.lastIndexOf(File.separatorChar) + 1);
        String string4 = MessageFormat.format(BuilderResUtil.getString("ERR_FILE_IN_USE_WARNING_MESSAGE"), string3);
        boolean bl = component instanceof Window ? (n3 = BuilderAlertPane.showConfirmDialog((Window)component, string4, string2, BuilderAlertPane.IconType.eQuestion, BuilderAlertPane.OptionType.YES_NO_OPTION)) == 1 : (component instanceof JComponent ? (n2 = BuilderAlertPane.showConfirmDialog((JComponent)component, string4, string2, BuilderAlertPane.IconType.eQuestion, BuilderAlertPane.OptionType.YES_NO_OPTION)) == 1 : (n = BuilderAlertPane.showConfirmDialog(jFrame = new JFrame(), string4, string2, BuilderAlertPane.IconType.eQuestion, BuilderAlertPane.OptionType.YES_NO_OPTION)) == 1);
        return bl;
    }

    private void displayFileDoesNotExistAlert(String string, Component component) {
        String string2 = string + "\n" + BuilderResUtil.getString("ERR_FILE_DOESNT_EXIST_WARNING_MESSAGE");
        if (component instanceof Window) {
            BuilderAlertPane.showWarningMessageDialog((Window)component, string2, BuilderUtil.getInstance().getAppVersionString());
        } else if (component instanceof JComponent) {
            BuilderAlertPane.showWarningMessageDialog((JComponent)component, string2, BuilderUtil.getInstance().getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string2, BuilderUtil.getInstance().getAppVersionString(), 0, new ImageIcon(BuilderResUtil.getImageResource("warning_core.png")));
        }
    }

    private void displayFolderDoesNotExistAlert(String string, Component component) {
        String string2 = string + "\n" + BuilderResUtil.getString("ERR_FOLDER_DOESNT_EXIST_WARNING_MESSAGE");
        if (component instanceof Window) {
            BuilderAlertPane.showWarningMessageDialog((Window)component, string2, BuilderUtil.getInstance().getAppVersionString());
        } else if (component instanceof JComponent) {
            BuilderAlertPane.showWarningMessageDialog((JComponent)component, string2, BuilderUtil.getInstance().getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string2, BuilderUtil.getInstance().getAppVersionString(), 0, new ImageIcon(BuilderResUtil.getImageResource("warning_core.png")));
        }
    }

    private void displayDirectoryReadOnlyAlert(Component component) {
        String string = this.getSelectedFile().getParent() + "\n" + BuilderResUtil.getString("ERR_DIR_READ_ONLY_ERROR_MESSAGE");
        if (component instanceof Window) {
            BuilderAlertPane.showErrorMessageDialog((Window)component, string, BuilderUtil.getInstance().getAppVersionString());
        } else if (component instanceof JComponent) {
            BuilderAlertPane.showErrorMessageDialog((JComponent)component, string, BuilderUtil.getInstance().getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string, BuilderUtil.getInstance().getAppVersionString(), 0);
        }
    }

    private void displayWin7LibraryRootAlert(Component component) {
        LocalFileSysUtil.getLocalFileSysUtil();
        String string = BuilderResUtil.getString("ERR_WIN7_LIBRARY_ROOT_ERROR_MESSAGE");
        if (component instanceof Window) {
            BuilderAlertPane.showErrorMessageDialog((Window)component, string, BuilderUtil.getInstance().getAppVersionString());
        } else if (component instanceof JComponent) {
            BuilderAlertPane.showErrorMessageDialog((JComponent)component, string, BuilderUtil.getInstance().getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string, BuilderUtil.getInstance().getAppVersionString(), 0);
        }
    }

    private void displayWin7LibraryEmptyAlert(Component component) {
        String string = BuilderResUtil.getString("ERR_WIN7_LIBRARY_EMPTY_ERROR_MESSAGE");
        if (component instanceof Window) {
            BuilderAlertPane.showErrorMessageDialog((Window)component, string, BuilderUtil.getInstance().getAppVersionString());
        } else if (component instanceof JComponent) {
            BuilderAlertPane.showErrorMessageDialog((JComponent)component, string, BuilderUtil.getInstance().getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string, BuilderUtil.getInstance().getAppVersionString(), 0);
        }
    }

    private boolean checkEncoding(String string, Component component) {
        EncodingValidator encodingValidator = new EncodingValidator(BuilderUtil.getInstance().getCurrentCharset());
        boolean bl = encodingValidator.validateString(string);
        if (!bl) {
            boolean bl2 = encodingValidator.getResult().equals(CoderResult.OVERFLOW);
            String string2 = bl2 ? "ERR_STRING_OVERFLOW_MSG" : "ERR_STRING_UNMAPPABLE_MSG";
            String string3 = UIToolResUtil.getString((String)string2);
            if (component instanceof Window) {
                BuilderAlertPane.showErrorMessageDialog((Window)component, string3, BuilderUtil.getInstance().getAppVersionString());
            } else {
                BuilderAlertPane.showErrorMessageDialog((JComponent)component, string3, BuilderUtil.getInstance().getAppVersionString());
            }
            JTextField jTextField = null;
            if (this.getUI() instanceof RefWindowsFileChooserUI) {
                jTextField = this.getRefWindowsFileChooserUI().getFileNameTextField();
            }
            if (jTextField != null) {
                jTextField.selectAll();
                jTextField.requestFocus();
            }
            return false;
        }
        return true;
    }

    private void setTitle() {
        if (this.mChooserType == ChooserType.OpenFile) {
            if (this.mChooserOption == ChooserOption.Data) {
                if (this.mUseServerFileSystem) {
                    this.setDialogTitle(BuilderResUtil.getString("IDS_FILE_CHOOSER_OPEN_DATA_REMOTE_TITLE"));
                } else {
                    this.setDialogTitle(BuilderResUtil.getString("IDS_FILE_CHOOSER_OPEN_DATA_LOCAL_TITLE"));
                }
            } else if (this.mChooserOption == ChooserOption.Syntax) {
                this.setDialogTitle(BuilderResUtil.getString("IDS_FILE_CHOOSER_OPEN_SYNTAX_TITLE"));
            } else if (this.mChooserOption == ChooserOption.Output) {
                this.setDialogTitle(BuilderResUtil.getString("IDS_FILE_CHOOSER_OPEN_OUTPUT_TITLE"));
            } else if (this.mChooserOption == ChooserOption.Script) {
                this.setDialogTitle(BuilderResUtil.getString("IDS_FILE_CHOOSER_OPEN_SCRIPT_TITLE"));
            }
        } else if (this.mChooserType == ChooserType.SaveFile) {
            if (this.mChooserOption == ChooserOption.Data) {
                if (this.mUseServerFileSystem) {
                    this.setDialogTitle(BuilderResUtil.getString("IDS_FILE_CHOOSER_SAVE_DATA_REMOTE_TITLE"));
                } else {
                    this.setDialogTitle(BuilderResUtil.getString("IDS_FILE_CHOOSER_SAVE_DATA_LOCAL_TITLE"));
                }
            } else if (this.mChooserOption == ChooserOption.Syntax) {
                this.setDialogTitle(BuilderResUtil.getString("IDS_FILE_CHOOSER_SAVE_SYNTAX_TITLE"));
            } else if (this.mChooserOption == ChooserOption.Output) {
                this.setDialogTitle(BuilderResUtil.getString("IDS_FILE_CHOOSER_SAVE_OUTPUT_TITLE"));
            } else if (this.mChooserOption == ChooserOption.Script) {
                this.setDialogTitle(BuilderResUtil.getString("IDS_FILE_CHOOSER_SAVE_SCRIPT_TITLE"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte canWriteFile(String string) {
        byte by = 0;
        File file = null;
        try {
            file = new File(string + "\\spss_dummy");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.flush();
            fileOutputStream.close();
            file.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            by = 1;
        }
        catch (IOException iOException) {
            by = 2;
        }
        finally {
            if (file != null && file.exists() && !file.delete()) {
                file.deleteOnExit();
            }
        }
        return by;
    }

    private RefWindowsFileChooserUI getRefWindowsFileChooserUI() {
        return (RefWindowsFileChooserUI)((Object)this.getUI());
    }

    public void setOverwriteAlert(boolean bl) {
        this.mOverwriteAlert = bl;
    }

    public static String getDirectoryName(File file, boolean bl) {
        String string = file.getAbsolutePath();
        if (bl) {
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return RemoteFileChooser.getDirectoryName(string);
    }

    public static String getDirectoryName(String string) {
        int n = Math.max(string.lastIndexOf(File.separatorChar), string.lastIndexOf(47));
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private void scan(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof JTextField) {
                JTextField jTextField = (JTextField)component;
                this.mFilenamePrompter = new FilenameTextFieldPrompter(jTextField, true);
                this.mFilenamePrompter.setAssociatedFileChooser(this);
                this.mFilenamePrompter.setCurrentDirectory(this.getCurrentDirectory());
            }
            if (!(component instanceof Container)) continue;
            this.scan((Container)component);
        }
    }

    private JButton getApproveButton() {
        Component[] componentArray;
        FileChooserUI fileChooserUI = this.getUI();
        if (fileChooserUI instanceof RefWindowsFileChooserUI) {
            return ((RefWindowsFileChooserUI)((Object)fileChooserUI)).getApproveButton(this);
        }
        String string = this.getUI().getApproveButtonText(this);
        for (Component component : componentArray = this.getComponents()) {
            JButton jButton = this.searchByText(component, string);
            if (jButton == null) continue;
            return jButton;
        }
        return null;
    }

    private JButton searchByText(Component component, String string) {
        if (component instanceof JButton) {
            JButton jButton = (JButton)component;
            String string2 = jButton.getText();
            if (string.equals(string2)) {
                return jButton;
            }
            return null;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                JButton jButton = this.searchByText(container.getComponent(i), string);
                if (jButton == null) continue;
                return jButton;
            }
        }
        return null;
    }

    private ImageIcon resizeImage(ImageIcon imageIcon, int n, int n2) {
        Image image = imageIcon.getImage();
        Image image2 = image.getScaledInstance(n, n2, 4);
        return new ImageIcon(image2);
    }

    public static RemoteFileChooser showClientSelectFolderDialog(Component component, String string, String string2, boolean bl) {
        RemoteFileChooser remoteFileChooser = bl ? new RemoteFileChooser(ChooserType.OpenFolder, ChooserOption.Generic, string2, false) : new SaveFolderChooser(ChooserType.OpenFolder, ChooserOption.Generic, string2, false);
        return RemoteFileChooser.chooseDirectoryFolder(component, string, remoteFileChooser);
    }

    public static RemoteFileChooser showServerSelectFolderDialog(Component component, String string, String string2, boolean bl) {
        RemoteFileChooser remoteFileChooser = bl ? new RemoteFileChooser(ChooserType.OpenFolder, ChooserOption.Generic, string2, true) : new SaveFolderChooser(ChooserType.OpenFolder, ChooserOption.Generic, string2, true);
        return RemoteFileChooser.chooseDirectoryFolder(component, string, remoteFileChooser);
    }

    private static RemoteFileChooser chooseDirectoryFolder(Component component, String string, RemoteFileChooser remoteFileChooser) {
        int n = -1;
        remoteFileChooser.setDialogTitle(string);
        ResourceBundle resourceBundle = BuilderResUtil.getBundle(null, null);
        if (resourceBundle != null) {
            try {
                if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                    remoteFileChooser.setApproveButtonMnemonic(BuilderResUtil.getAccessKey(resourceBundle, "IDK_FILE_FOLDER"));
                }
                n = remoteFileChooser.showDialog(component, BuilderResUtil.getString("IDS_FILE_FOLDER_TEXT"));
                if (remoteFileChooser instanceof SaveFolderChooser) {
                    ((SaveFolderChooser)remoteFileChooser).resetStrings();
                }
            }
            catch (MissingResourceException missingResourceException) {
                missingResourceException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n == 0 ? remoteFileChooser : null;
    }

    private class ResizeConstrainer
    extends ComponentAdapter {
        private Component mComponent = null;
        private Dimension mSizeConstraints = null;

        public ResizeConstrainer(Component component, Dimension dimension) {
            this.mComponent = component;
            this.mSizeConstraints = (Dimension)dimension.clone();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (this.mSizeConstraints != null) {
                boolean bl = false;
                Dimension dimension = this.mComponent.getSize();
                if (dimension.width < this.mSizeConstraints.width) {
                    dimension.width = this.mSizeConstraints.width;
                    bl = true;
                }
                if (dimension.height < this.mSizeConstraints.height) {
                    dimension.height = this.mSizeConstraints.height;
                    bl = true;
                }
                if (bl) {
                    this.mComponent.setSize(dimension);
                }
            }
        }

        public Dimension getSizeConstraints() {
            return (Dimension)this.mSizeConstraints.clone();
        }

        public void setSizeConstraints(Dimension dimension) {
            this.mSizeConstraints = (Dimension)dimension.clone();
        }
    }

    private class MyAWTKeyEventListener
    implements AWTEventListener {
        private MyAWTKeyEventListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            if (object instanceof Component && aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == 27) {
                RemoteFileChooser.this.mDialog.dispose();
                Toolkit.getDefaultToolkit().removeAWTEventListener(RemoteFileChooser.this.mMyAWTKeyEventListener);
            }
        }
    }

    private class RemoteFileDialog
    extends JDialog {
        private ResizeConstrainer mResizeConstrainer;

        public RemoteFileDialog(JDialog jDialog, String string) {
            super(jDialog, string, true);
            this.mResizeConstrainer = null;
        }

        public RemoteFileDialog(Frame frame, String string) {
            super(frame, string, true);
            this.mResizeConstrainer = null;
        }

        @Override
        public void pack() {
            this.removeComponentListener(this.mResizeConstrainer);
            super.pack();
            Dimension dimension = this.getSizeConstraints();
            Dimension dimension2 = this.getSize();
            dimension2.width = dimension2.width > dimension.width ? dimension2.width : dimension.width;
            dimension2.height = dimension2.height > dimension.height ? dimension2.height : dimension.height;
            this.setSizeConstraints(dimension2);
            this.addComponentListener(this.mResizeConstrainer);
        }

        public Dimension getSizeConstraints() {
            if (this.mResizeConstrainer == null) {
                this.mResizeConstrainer = new ResizeConstrainer(this, new Dimension(0, 0));
            }
            return this.mResizeConstrainer.getSizeConstraints();
        }

        public void setSizeConstraints(Dimension dimension) {
            if (this.mResizeConstrainer == null) {
                this.mResizeConstrainer = new ResizeConstrainer(this, dimension);
            } else {
                this.mResizeConstrainer.setSizeConstraints(dimension);
            }
        }
    }

    private static class WeakPCL
    implements PropertyChangeListener {
        WeakReference<RemoteFileChooser> jfcRef;

        public WeakPCL(RemoteFileChooser remoteFileChooser) {
            this.jfcRef = new WeakReference<RemoteFileChooser>(remoteFileChooser);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            assert (propertyChangeEvent.getPropertyName().equals(RemoteFileChooser.SHOW_HIDDEN_PROP));
            RemoteFileChooser remoteFileChooser = (RemoteFileChooser)this.jfcRef.get();
            if (remoteFileChooser == null) {
                Toolkit.getDefaultToolkit().removePropertyChangeListener(RemoteFileChooser.SHOW_HIDDEN_PROP, this);
            } else {
                boolean bl = remoteFileChooser.isFileHidingEnabled();
                remoteFileChooser.mUseFileHiding = (Boolean)propertyChangeEvent.getNewValue() == false;
                remoteFileChooser.firePropertyChange("FileHidingChanged", bl, remoteFileChooser.mUseFileHiding);
            }
        }
    }

    private static class SaveFolderChooser
    extends RemoteFileChooser {
        public SaveFolderChooser(ChooserType chooserType, ChooserOption chooserOption, String string, boolean bl) {
            super(chooserType, chooserOption, string, bl);
        }

        @Override
        protected void installStrings() {
            super.installStrings();
            UIManager.getDefaults().put("FileChooser.lookInLabelText", BuilderResUtil.getString("IDS_FILE_CHOOSER_SAVE_IN_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", BuilderResUtil.getString("IDS_FILE_CHOOSER_SAVE_FILES_OF_TYPE_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.fileNameLabelText", BuilderResUtil.getString("IDS_FILE_CHOOSER_OPEN_FOLDER_LABEL_TEXT"));
        }

        public void resetStrings() {
            UIManager.getDefaults().put("FileChooser.lookInLabelText", BuilderResUtil.getString("IDS_FILE_CHOOSER_LOOK_IN_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", BuilderResUtil.getString("IDS_FILE_CHOOSER_FILES_OF_TYPE_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.fileNameLabelText", BuilderResUtil.getString("IDS_FILE_CHOOSER_FOLDER_LABEL_TEXT"));
        }
    }

    public static enum ChooserOption {
        Generic,
        Data,
        DataWithEncryption,
        Syntax,
        Output,
        Script,
        ExportDimensions,
        GenericWithPaste,
        GenericWithoutPES;

    }

    public static enum ChooserType {
        OpenFile,
        SaveFile,
        OpenFolder,
        OpenCreateFile;

    }
}

