/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.fopen;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.FileTextField;
import com.spss.shared.custom_gui.ui_builder.app.fopen.LocalFileSysUtil;
import com.spss.shared.custom_gui.ui_builder.app.fopen.RefFileFilter;
import com.spss.shared.custom_gui.ui_builder.app.fopen.RemoteFileChooser;
import com.spss.shared.custom_gui.ui_builder.app.fopen.SpssFile;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.controls.FixedLengthDocument;
import com.spss.uitools.util.CharacterUtil;
import com.sun.java.swing.plaf.windows.WindowsFileChooserUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.text.Document;
import sun.awt.shell.ShellFolder;

public class RefWindowsFileChooserUI
extends WindowsFileChooserUI
implements ActionListener {
    private static final int COMPONENT_GROUP_GAP = 11;
    private static final int GROUP_BOX_INNER_MARGIN = 5;
    JButton mPasteButton;
    JButton mHelpButton;
    JTextField mFileNameTextField;
    boolean mPasteEnabled = false;
    private JButton mApproveButton1;
    private JButton mPESButton;
    private JLabel mKeepVarsLabel;
    private int mTotalVariables;
    private JCheckBox mWriteCheckBox;
    private JCheckBox mSaveValueLabels;
    private JCheckBox mSaveValueLabelsToFile;
    private JCheckBox mEncryptPasswordCheckBox;
    private String mEncryptFilePassword = null;
    private JComboBox mFileTypeComboBox;
    private boolean mErrorOccurred;
    private boolean mIsSaveDataAsFileChooser;
    private JLabel mEncodingLabel;
    private JComboBox mEncodingComboBox;
    private String mSelectedEncoding;
    private JCheckBox mMinStringWidthsCheckbox;
    private JCheckBox mReaderLockCheckbox;
    private JButton mNewFolderButton;
    private String mEnteredTrimmedText;
    private static final int RTL_BTD = 1;
    private static final int LTR_BTD = 2;
    private static final char Bidi_LRM = '\u200e';

    public RefWindowsFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
        this.mIsSaveDataAsFileChooser = ((RemoteFileChooser)jFileChooser).isSaveDataAsFileChooser();
        this.initVars();
    }

    public Action getApproveSelectionAction() {
        String string;
        RemoteFileChooser remoteFileChooser = (RemoteFileChooser)this.getFileChooser();
        if (this.mFileNameTextField != null && this.mFileNameTextField.getName() != null && FileTextField.isPathBidiProcessingNeeded(this.mFileNameTextField.getName())) {
            this.mFileNameTextField.setText(FileTextField.removeLRM(this.mFileNameTextField.getName()));
        }
        if ((string = this.getFileName()) != null && string.length() > 0) {
            boolean bl;
            if (this.isGlobPattern(string, remoteFileChooser.getDialogType())) {
                String string2 = String.format(BuilderResUtil.getString("ERR_FILE_SAVE_INVALID"), string);
                JFrame jFrame = null;
                if (remoteFileChooser.getParentComponent() instanceof JFrame) {
                    jFrame = (JFrame)remoteFileChooser.getParentComponent();
                }
                BuilderAlertPane.showInformationMessageDialog(jFrame, string2, BuilderUtil.getInstance().getAppVersionString());
                this.getFileNameTextField().selectAll();
                return null;
            }
            boolean bl2 = bl = string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'");
            if (bl && string.indexOf(File.separator) > -1) {
                int n = string.lastIndexOf(File.separator);
                string = string.substring(1, n + 1) + "\"" + string.substring(n + 1);
            }
            String string3 = LocalFileSysUtil.getLocalFileSysUtil().ExpandEnvVars(string);
            this.setFileName(string3);
        }
        return super.getApproveSelectionAction();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mFileTypeComboBox)) {
            RemoteFileChooser remoteFileChooser = (RemoteFileChooser)this.getFileChooser();
            if (remoteFileChooser.getChooserType() == RemoteFileChooser.ChooserType.OpenFile) {
                remoteFileChooser.setSelectedFile(null);
                this.updateEncodingComboUI(RemoteFileChooser.ChooserType.OpenFile);
            } else if (remoteFileChooser.getChooserType() == RemoteFileChooser.ChooserType.SaveFile) {
                if (this.mEncodingComboBox != null) {
                    this.updateEncodingComboUI(RemoteFileChooser.ChooserType.SaveFile);
                }
                this.mEncryptPasswordCheckBox.setEnabled(false);
                if (this.mFileTypeComboBox.getSelectedItem() instanceof RefFileFilter) {
                    String string = ((RefFileFilter)this.mFileTypeComboBox.getSelectedItem()).getDescription();
                    this.changeFileExtension(((RefFileFilter)this.mFileTypeComboBox.getSelectedItem()).getExtension());
                }
            }
        }
    }

    public String GetEnteredText() {
        return this.mEnteredTrimmedText;
    }

    private void updateEncodingComboUI(RemoteFileChooser.ChooserType chooserType) {
        if (this.mFileTypeComboBox.getSelectedItem() instanceof RefFileFilter || this.mFileTypeComboBox.getSelectedItem() instanceof BasicFileChooserUI.AcceptAllFileFilter) {
            String string = this.mFileTypeComboBox.getSelectedItem() instanceof RefFileFilter ? ((RefFileFilter)this.mFileTypeComboBox.getSelectedItem()).getDescription() : ((BasicFileChooserUI.AcceptAllFileFilter)this.mFileTypeComboBox.getSelectedItem()).getDescription();
            if (chooserType == RemoteFileChooser.ChooserType.OpenFile) {
                RemoteFileChooser remoteFileChooser = (RemoteFileChooser)this.getFileChooser();
                if (remoteFileChooser.getChooserOption() == RemoteFileChooser.ChooserOption.Syntax || string.equals(BuilderResUtil.getString("IDS_TEXT_FILES_FILTER"))) {
                    boolean bl = true;
                    if (this.mEncodingComboBox.getSelectedIndex() == -1) {
                        bl = false;
                    }
                    this.mEncodingLabel.setEnabled(bl);
                    this.mEncodingComboBox.setEnabled(bl);
                } else {
                    this.mEncodingComboBox.setSelectedIndex(-1);
                    this.mEncodingLabel.setEnabled(false);
                    this.mEncodingComboBox.setEnabled(false);
                }
            } else if (chooserType == RemoteFileChooser.ChooserType.SaveFile) {
                if (string.equals(BuilderResUtil.getString("IDS_SAVE_TAB_DELIMITED_FILE_FILTER")) || string.equals(BuilderResUtil.getString("IDS_SAVE_COMMA_DELIMITED_FILE_FILTER")) || string.equals(BuilderResUtil.getString("IDS_SAVE_FIXED_ASCII_FILE_FILTER")) || string.equals(BuilderResUtil.getString("IDS_SAVE_SAS_V9_WIN_FILE_FILTER")) || string.equals(BuilderResUtil.getString("IDS_SAVE_SAS_V9_UNIX_FILE_FILTER"))) {
                    if (this.mEncodingComboBox.getSelectedIndex() == -1) {
                        this.mEncodingComboBox.setSelectedIndex(0);
                    }
                    this.setSelectedEncoding(this.mSelectedEncoding);
                    this.mEncodingLabel.setEnabled(true);
                    this.mEncodingComboBox.setEnabled(true);
                } else {
                    this.mEncodingComboBox.setSelectedIndex(-1);
                    this.mEncodingLabel.setEnabled(false);
                    this.mEncodingComboBox.setEnabled(false);
                }
            }
        }
    }

    public String getFileName() {
        String string = super.getFileName();
        if (string != null && string.length() > 0 && string.indexOf(8206) != -1) {
            string = FileTextField.removeLRM(string);
        }
        return string;
    }

    public void setFileName(String string) {
        if (string != null && string.length() > 0 && string.indexOf(File.pathSeparator) == -1 && FileTextField.isPathBidiProcessingNeeded(string)) {
            string = FileTextField.insertLRM(string);
        }
        super.setFileName(string);
    }

    public JCheckBox getWriteCheckBox() {
        return this.mWriteCheckBox;
    }

    public JCheckBox getSaveValueLabelsCheckBox() {
        return this.mSaveValueLabels;
    }

    public JCheckBox getSaveValueLabelsToFileCheckBox() {
        return this.mSaveValueLabelsToFile;
    }

    public boolean getIsMinimizeStringWidths() {
        return this.mMinStringWidthsCheckbox != null && this.mMinStringWidthsCheckbox.isSelected();
    }

    public void setIsMinimizeStringWidths(boolean bl) {
        if (this.mMinStringWidthsCheckbox != null) {
            this.mMinStringWidthsCheckbox.setSelected(bl);
        }
    }

    public boolean readerLock() {
        return this.mReaderLockCheckbox != null && this.mReaderLockCheckbox.isSelected();
    }

    public void readerLock(boolean bl) {
        if (this.mReaderLockCheckbox != null) {
            this.mReaderLockCheckbox.setSelected(bl);
        }
    }

    public boolean isEncodingEnabled() {
        return this.mEncodingComboBox.isEnabled();
    }

    public boolean isEncryptFileWithPasswordSelected() {
        return this.mEncryptPasswordCheckBox != null && this.mEncryptPasswordCheckBox.isSelected();
    }

    public String getEncryptFilePassword() {
        return this.mEncryptFilePassword;
    }

    public void setEncryptFilePassword(String string) {
        this.mEncryptFilePassword = string;
    }

    public void selectEncryptFileWithPassword(boolean bl) {
        if (this.mEncryptPasswordCheckBox != null) {
            this.mEncryptPasswordCheckBox.setSelected(bl);
        }
    }

    public String getSelectedEncoding() {
        if (this.mSelectedEncoding == null || this.mSelectedEncoding.length() == 0) {
            RemoteFileChooser remoteFileChooser = (RemoteFileChooser)this.getFileChooser();
            String string = this.getEncoding(remoteFileChooser);
            this.mSelectedEncoding = string == null || string.length() == 0 ? BuilderUtil.getInstance().getCurrentCharset().name() : string;
        }
        return this.mSelectedEncoding;
    }

    public void setEncodingControlsEnabled(boolean bl) {
        if (this.mEncodingComboBox != null) {
            this.mEncodingComboBox.setEnabled(bl);
        }
        if (this.mEncodingLabel != null) {
            this.mEncodingLabel.setEnabled(bl);
        }
    }

    public void setSelectedEncoding(String string) {
        this.mSelectedEncoding = string;
        RemoteFileChooser remoteFileChooser = (RemoteFileChooser)this.getFileChooser();
        if (this.hasEncodingCombo(remoteFileChooser) && this.mEncodingComboBox != null) {
            this.mEncodingComboBox.setEnabled(false);
            this.mEncodingLabel.setEnabled(false);
            int n = -1;
            if (string != null && string.length() > 0) {
                n = string.contains("UTF-8") ? 0 : 1;
            }
            this.mEncodingComboBox.setSelectedIndex(n);
            if (n > -1) {
                this.mEncodingComboBox.setEnabled(true);
                this.mEncodingLabel.setEnabled(true);
            }
        }
    }

    public int getMaxAllowedVars() {
        String string = ((RefFileFilter)this.mFileTypeComboBox.getSelectedItem()).getDescription();
        if (string.equals(BuilderResUtil.getString("IDS_SAVE_XLS_2_FILE_FILTER")) || string.equals(BuilderResUtil.getString("IDS_SAVE_WK_3_FILE_FILTER")) || string.equals(BuilderResUtil.getString("IDS_SAVE_WK_1_FILE_FILTER")) || string.equals(BuilderResUtil.getString("IDS_SAVE_WK_S_FILE_FILTER")) || string.equals(BuilderResUtil.getString("IDS_SAVE_SYLK_FILE_FILTER")) || string.equals(BuilderResUtil.getString("IDS_SAVE_XLS_97_FILE_FILTER")) || string.equals(BuilderResUtil.getString("IDS_SAVE_ODF_CALC_FILTER"))) {
            return 256;
        }
        if (string.equals(BuilderResUtil.getString("IDS_SAVE_XLS_X_FILE_FILTER"))) {
            return 16000;
        }
        if (string.equals(BuilderResUtil.getString("IDS_SAVE_DBASE_4_FILE_FILTER"))) {
            return 255;
        }
        if (string.equals(BuilderResUtil.getString("IDS_SAVE_DBASE_3_FILE_FILTER"))) {
            return 128;
        }
        if (string.equals(BuilderResUtil.getString("IDS_SAVE_DBASE_2_FILE_FILTER"))) {
            return 32;
        }
        if (string.equals(BuilderResUtil.getString("IDS_SAVE_SPSS_PC_FILE_FILTER"))) {
            return 500;
        }
        return this.mTotalVariables;
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener(jFileChooser);
        return new ExtendedPropertyChangeListener(propertyChangeListener);
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        JPanel jPanel = super.createList(jFileChooser);
        BasicDirectoryModel basicDirectoryModel = this.getModel();
        basicDirectoryModel.addListDataListener(new ExtendedListDataListener());
        return jPanel;
    }

    protected void addControlButtons() {
        JPanel jPanel;
        Serializable serializable;
        boolean bl;
        super.addControlButtons();
        this.customizeTopButtons();
        RemoteFileChooser remoteFileChooser = (RemoteFileChooser)this.getFileChooser();
        this.mPasteEnabled = bl = BuilderUtil.getInstance().allowSyntax() && (remoteFileChooser.getChooserOption() == RemoteFileChooser.ChooserOption.Data || remoteFileChooser.getChooserOption() == RemoteFileChooser.ChooserOption.Output || remoteFileChooser.getChooserOption() == RemoteFileChooser.ChooserOption.GenericWithPaste);
        boolean bl2 = false;
        boolean bl3 = this.mIsSaveDataAsFileChooser && (remoteFileChooser.getChooserOption() == RemoteFileChooser.ChooserOption.Data || remoteFileChooser.getChooserOption() == RemoteFileChooser.ChooserOption.ExportDimensions);
        JPanel jPanel2 = this.getButtonPanel();
        JPanel jPanel3 = this.getBottomPanel();
        this.mApproveButton1 = (JButton)jPanel2.getComponent(1);
        this.mApproveButton1.removeActionListener(this.getApproveSelectionAction());
        ApproveOpenSelectionAction approveOpenSelectionAction = new ApproveOpenSelectionAction();
        this.mApproveButton1.addActionListener(approveOpenSelectionAction);
        if (remoteFileChooser.getChooserType() == RemoteFileChooser.ChooserType.SaveFile) {
            remoteFileChooser.setDialogType(1);
            this.mApproveButton1.setText(this.getApproveButtonText(remoteFileChooser));
        }
        CancelAction cancelAction = new CancelAction();
        if (jPanel2.getComponent(3) instanceof JButton) {
            serializable = (JButton)jPanel2.getComponent(3);
            ((AbstractButton)serializable).addActionListener(cancelAction);
        }
        serializable = new ApprovePasteSelectionAction();
        this.mPasteButton = new JButton((String)((AbstractAction)serializable).getValue("Name")){

            @Override
            public Dimension getMaximumSize() {
                return RefWindowsFileChooserUI.this.getButtonSize();
            }
        };
        this.mHelpButton = new JButton(BuilderResUtil.getString("IDS_FILE_CHOOSER_HELP_BUTTON")){

            @Override
            public Dimension getMaximumSize() {
                return RefWindowsFileChooserUI.this.getButtonSize();
            }
        };
        VariablesAction variablesAction = new VariablesAction();
        JButton jButton = new JButton((String)variablesAction.getValue("Name")){

            @Override
            public Dimension getMaximumSize() {
                return RefWindowsFileChooserUI.this.getButtonSize();
            }
        };
        int n = 0;
        int n2 = 1;
        jPanel2.remove(this.mApproveButton1);
        if (bl3) {
            jButton.setMargin(this.mApproveButton1.getMargin());
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                jButton.setMnemonic(BuilderResUtil.getAccessKey("IDK_SAVE_FILE_VARIABLES_BUTTON"));
            }
            jButton.addActionListener(variablesAction);
            jPanel2.add((Component)jButton, n2++);
            jPanel2.add(Box.createRigidArea(new Dimension(1, 4)), n2++);
            n += 27;
        }
        jPanel2.add((Component)this.mApproveButton1, n2++);
        this.mApproveButton1.setPreferredSize(this.getButtonSize());
        if (bl) {
            this.mPasteButton.setMargin(this.mApproveButton1.getMargin());
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.mPasteButton.setMnemonic(BuilderResUtil.getAccessKey("IDK_FILE_CHOOSER_PASTE_BUTTON"));
            }
            this.mPasteButton.addActionListener((ActionListener)((Object)serializable));
            jPanel2.add(Box.createRigidArea(new Dimension(1, 4)), n2++);
            jPanel2.add((Component)this.mPasteButton, n2);
            n += 27;
        }
        if (bl2) {
            this.mHelpButton.setMargin(this.mApproveButton1.getMargin());
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.mHelpButton.setMnemonic(BuilderResUtil.getAccessKey("IDK_FILE_CHOOSER_HELP_BUTTON"));
            }
            this.mHelpButton.addActionListener(new HelpSelectedAction());
            jPanel2.add(Box.createRigidArea(new Dimension(1, 4)));
            jPanel2.add(this.mHelpButton);
            n += 27;
        }
        this.mApproveButton1.setPreferredSize(this.getButtonSize());
        Component component = jPanel3.getComponent(2);
        if (component instanceof JPanel) {
            jPanel = (JPanel)component;
            jPanel.add(Box.createRigidArea(new Dimension(1, n)));
            JTextField jTextField = (JTextField)jPanel.getComponent(1);
            jTextField.addActionListener(approveOpenSelectionAction);
        }
        if ((component = jPanel3.getComponent(0)) instanceof JPanel) {
            jPanel = (JPanel)component;
            jPanel.add(Box.createRigidArea(new Dimension(1, n)));
        }
        if (this.mIsSaveDataAsFileChooser) {
            this.customiseUILayout(this.getBottomPanel(), bl3, bl2);
            this.mFileTypeComboBox.addActionListener(this);
        } else {
            this.customiseBottomPanel(this.getBottomPanel(), bl2, remoteFileChooser.ShowDownloadInfoMsg());
        }
    }

    protected Dimension getButtonSize() {
        JPanel jPanel = this.getButtonPanel();
        JButton jButton = (JButton)jPanel.getComponent(1);
        int n = jButton.getPreferredSize().width;
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            if (!(jPanel.getComponent(i) instanceof JButton)) continue;
            JButton jButton2 = (JButton)jPanel.getComponent(i);
            if (jButton2.getPreferredSize().width <= n) continue;
            n = jButton2.getPreferredSize().width;
            jButton = jButton2;
        }
        return jButton.getPreferredSize();
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return super.getApproveButton(jFileChooser);
    }

    void setErrorOccurred(boolean bl) {
        this.mErrorOccurred = bl;
    }

    JTextField getFileNameTextField() {
        return this.mFileNameTextField;
    }

    public void setFocusOnEncryptPasswordCheckBox() {
        this.mEncodingComboBox.requestFocusInWindow();
    }

    void enableNewFolderButton(boolean bl) {
        if (this.mNewFolderButton != null) {
            this.mNewFolderButton.setEnabled(bl);
        }
    }

    private void customiseBottomPanel(JPanel jPanel, boolean bl, boolean bl2) {
        JComponent jComponent;
        Container container = this.getBottomPanel().getParent();
        int n = 0;
        RemoteFileChooser remoteFileChooser = (RemoteFileChooser)this.getFileChooser();
        if (!remoteFileChooser.isServerFileSystem() && OSInfo.getOSType() == OSInfo.OSType.WIN) {
            n = 1;
        }
        JComponent jComponent2 = (JComponent)this.getFileChooser().getComponent(n);
        for (Component component : jComponent2.getComponents()) {
            if (!(component instanceof JButton)) continue;
            ((JButton)component).setFocusPainted(true);
            jComponent = (JButton)component;
            if (!((AbstractButton)jComponent).getIcon().equals(UIManager.getIcon("FileChooser.newFolderIcon"))) continue;
            this.mNewFolderButton = jComponent;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        Insets insets = new Insets(11, 0, 0, 0);
        if (container instanceof JPanel) {
            String[] n4;
            Component component;
            ((JPanel)container).remove(jPanel);
            component = new JPanel(new GridBagLayout());
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            jComponent = (JPanel)jPanel.getComponent(0);
            boolean bl3 = this.hasEncodingCombo(remoteFileChooser);
            boolean bl4 = !this.mIsSaveDataAsFileChooser && remoteFileChooser.getChooserOption() == RemoteFileChooser.ChooserOption.Data;
            boolean bl5 = remoteFileChooser.getChooserType() == RemoteFileChooser.ChooserType.SaveFile && remoteFileChooser.getChooserOption() == RemoteFileChooser.ChooserOption.Output;
            boolean bl6 = remoteFileChooser.getChooserType() == RemoteFileChooser.ChooserType.SaveFile && (remoteFileChooser.getChooserOption() == RemoteFileChooser.ChooserOption.Output || remoteFileChooser.getChooserOption() == RemoteFileChooser.ChooserOption.DataWithEncryption);
            this.addUsingGBL((Container)component, (JComponent)jComponent.getComponent(1), gridBagConstraints, 0, 0, 1, 1, n2, insets);
            this.addUsingGBL((Container)component, (JComponent)jComponent.getComponent(2), gridBagConstraints, 0, 1, 1, 1, n2, insets);
            gridBagConstraints.weightx = 1.0;
            JPanel jPanel2 = (JPanel)jPanel.getComponent(2);
            insets.set(11, 11, 0, 0);
            this.mFileNameTextField = (JTextField)jPanel2.getComponent(1);
            this.mFileNameTextField.setDocument((Document)new FixedLengthDocument(255));
            if (BuilderUtil.getInstance().getBTD() == 1) {
                this.mFileNameTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                this.mFileNameTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
            this.mFileNameTextField.addActionListener(this);
            this.mFileTypeComboBox = (JComboBox)jPanel2.getComponent(3);
            this.addUsingGBL((Container)component, this.mFileNameTextField, gridBagConstraints, 1, 0, 1, 1, n2, insets);
            this.addUsingGBL((Container)component, this.mFileTypeComboBox, gridBagConstraints, 1, 1, 1, 1, n2, insets);
            if (bl3) {
                this.mFileTypeComboBox.addActionListener(this);
            }
            int n3 = 2;
            if (bl4 && !bl3) {
                this.mMinStringWidthsCheckbox = new JCheckBox(BuilderResUtil.getString("IDS_MIN_STRING_WIDTHS"));
                this.addUsingGBL((Container)component, this.mMinStringWidthsCheckbox, gridBagConstraints, 0, n3++, 2, 1, n2, insets);
            } else if (bl3 && !bl4) {
                insets.set(11, 0, 0, 0);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                this.mEncodingLabel = new JLabel(BuilderResUtil.getString("IDS_FILE_CHOOSER_ENCODING_LABEL"));
                if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                    this.mEncodingLabel.setDisplayedMnemonic(BuilderResUtil.getAccessKey("IDK_FILE_CHOOSER_ENCODING_LABEL"));
                }
                this.addUsingGBL((Container)component, this.mEncodingLabel, gridBagConstraints, 0, n3, 1, 1, n2, insets);
                insets.set(11, 11, 0, 0);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                n4 = new String[]{BuilderResUtil.getString("IDS_UNICODE_UTF8"), BuilderResUtil.getString("IDS_LOCAL_ENCODING")};
                this.mEncodingComboBox = new JComboBox<String>(n4);
                this.mEncodingComboBox.setEditable(false);
                this.addUsingGBL((Container)component, this.mEncodingComboBox, gridBagConstraints, 1, n3++, 1, 1, n2, insets);
                this.mEncodingLabel.setLabelFor(this.mEncodingComboBox);
            } else if (bl3 && bl4) {
                insets.set(11, 0, 0, 0);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                this.mEncodingLabel = new JLabel(BuilderResUtil.getString("IDS_FILE_CHOOSER_ENCODING_LABEL"));
                if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                    this.mEncodingLabel.setDisplayedMnemonic(BuilderResUtil.getAccessKey("IDK_FILE_CHOOSER_ENCODING_LABEL"));
                }
                this.addUsingGBL((Container)component, this.mEncodingLabel, gridBagConstraints, 0, n3, 1, 1, n2, insets);
                insets.set(11, 11, 0, 0);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                n4 = new String[]{BuilderResUtil.getString("IDS_UNICODE_UTF8"), BuilderResUtil.getString("IDS_LOCAL_ENCODING")};
                this.mEncodingComboBox = new JComboBox<String>(n4);
                this.mEncodingComboBox.setEditable(false);
                this.addUsingGBL((Container)component, this.mEncodingComboBox, gridBagConstraints, 1, n3++, 1, 1, n2, insets);
                this.mEncodingLabel.setLabelFor(this.mEncodingComboBox);
                this.mMinStringWidthsCheckbox = new JCheckBox(BuilderResUtil.getString("IDS_MIN_STRING_WIDTHS"));
                this.addUsingGBL((Container)component, this.mMinStringWidthsCheckbox, gridBagConstraints, 0, n3++, 2, 1, n2, insets);
            } else if (bl5) {
                this.mReaderLockCheckbox = new JCheckBox(BuilderResUtil.getString("IDS_FILE_CHOOSER_SMARTREADER_LOCK"));
                if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                    this.mReaderLockCheckbox.setMnemonic(BuilderResUtil.getAccessKey("IDK_FILE_CHOOSER_SMARTREADER_LOCK"));
                }
                this.addUsingGBL((Container)component, this.mReaderLockCheckbox, gridBagConstraints, 1, n3++, 1, 1, n2, insets);
            }
            if (bl6) {
                this.addUsingGBL((Container)component, this.mEncryptPasswordCheckBox, gridBagConstraints, 1, n3++, 1, 1, n2, insets);
                this.mEncryptPasswordCheckBox.setEnabled(true);
            }
            insets.set(5, 22, 0, 0);
            gridBagConstraints.weightx = 0.0;
            if (!bl) {
                gridBagConstraints.weighty = 1.0;
            }
            gridBagConstraints.fill = 0;
            int n5 = 4;
            n5 = bl3 || bl4 || bl5 ? n5 + 1 : n5;
            this.addUsingGBL((Container)component, this.getButtonPanel(), gridBagConstraints, 2, 0, 1, n5, n2, insets);
            if (bl) {
                gridBagConstraints.weighty = 0.0;
                insets.set(10, 0, 0, 0);
                gridBagConstraints.fill = 2;
                this.addUsingGBL((Container)component, new JSeparator(), gridBagConstraints, 0, n3++, 2, 1, n2, insets);
                insets.set(5, 0, 0, 0);
                String string = "";
                String string2 = "";
                this.mPESButton = new JButton(BuilderResUtil.getString("IDS_FILE_CHOOSER_RETRIEVE_FILE_FROM_PES"));
                if (remoteFileChooser.getChooserType() == RemoteFileChooser.ChooserType.OpenFile) {
                    string = "IDS_FILE_CHOOSER_RETRIEVE_FILE_FROM_PES";
                    string2 = "IDK_FILE_CHOOSER_RETRIEVE_FILE_FROM_PES";
                    this.mPESButton.addActionListener(new PesRetrieveAction());
                } else if (remoteFileChooser.getChooserType() == RemoteFileChooser.ChooserType.SaveFile) {
                    string = "IDS_FILE_CHOOSER_STORE_FILE_TO_PES";
                    string2 = "IDK_FILE_CHOOSER_STORE_FILE_TO_PES";
                    this.mPESButton.addActionListener(new PesStoreAction());
                }
                this.mPESButton.setText(BuilderResUtil.getString(string));
                if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                    this.mPESButton.setMnemonic(BuilderResUtil.getAccessKey(string2));
                }
                gridBagConstraints.fill = 0;
                n2 = 19;
                gridBagConstraints.weighty = 1.0;
                this.addUsingGBL((Container)component, this.mPESButton, gridBagConstraints, 0, n3++, 2, 1, n2, insets);
                if (bl2) {
                    gridBagConstraints.fill = 2;
                    n2 = 23;
                    gridBagConstraints.weighty = 1.0;
                    JTextArea jTextArea = new JTextArea(BuilderResUtil.getString("IDS_FILE_CHOOSER_DOWNLOAD_OVER_INTERNET"));
                    jTextArea.setEditable(false);
                    jTextArea.setOpaque(false);
                    jTextArea.setFocusable(false);
                    jTextArea.setWrapStyleWord(true);
                    jTextArea.setLineWrap(true);
                    this.addUsingGBL((Container)component, jTextArea, gridBagConstraints, 0, n3, 2, 1, n2, insets);
                }
            }
            ((JPanel)container).add(component, "South");
        }
    }

    protected boolean hasEncodingCombo(RemoteFileChooser remoteFileChooser) {
        return remoteFileChooser.getChooserOption() == RemoteFileChooser.ChooserOption.Syntax || remoteFileChooser.getChooserOption() == RemoteFileChooser.ChooserOption.Data;
    }

    private void addUsingGBL(Container container, JComponent jComponent, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, Insets insets) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.insets = insets == null ? new Insets(0, 0, 0, 0) : insets;
        container.add((Component)jComponent, gridBagConstraints);
    }

    private void setKeepLabelText(int n) {
        String string = MessageFormat.format(BuilderResUtil.getString("IDS_SAVE_FILE_KEEPING_LABEL"), n, this.mTotalVariables);
        this.mKeepVarsLabel.setText(string);
    }

    private void initVars() {
        this.mPESButton = new JButton(BuilderResUtil.getString("IDS_FILE_CHOOSER_STORE_FILE_TO_PES"));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mPESButton.setMnemonic(BuilderResUtil.getAccessKey("IDS_FILE_CHOOSER_STORE_FILE_TO_PES"));
        }
    }

    private void updateKeptVarsCount() {
    }

    private void customiseUILayout(JPanel jPanel, boolean bl, boolean bl2) {
        Container container = this.getBottomPanel().getParent();
        int n = 0;
        RemoteFileChooser remoteFileChooser = (RemoteFileChooser)this.getFileChooser();
        boolean bl3 = remoteFileChooser.isServerFileSystem();
        if (!bl3 && OSInfo.getOSType() == OSInfo.OSType.WIN) {
            n = 1;
        }
        JComponent jComponent = (JComponent)this.getFileChooser().getComponent(n);
        for (Component n3 : jComponent.getComponents()) {
            if (!(n3 instanceof JButton)) continue;
            ((JButton)n3).setFocusPainted(true);
            JButton n4 = (JButton)n3;
            if (!n4.getIcon().equals(UIManager.getIcon("FileChooser.newFolderIcon"))) continue;
            this.mNewFolderButton = n4;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        int n3 = 0;
        if (container instanceof JPanel) {
            boolean bl4 = this.hasEncodingCombo(remoteFileChooser);
            ((JPanel)container).remove(jPanel);
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            JPanel jPanel3 = (JPanel)jPanel.getComponent(0);
            insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
            if (bl) {
                this.addUsingGBL(jPanel2, this.mKeepVarsLabel, gridBagConstraints, 1, n3++, 1, 1, n2, insets);
            }
            insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.addUsingGBL(jPanel2, (JComponent)jPanel3.getComponent(1), gridBagConstraints, 0, n3, 1, 1, n2, insets);
            JPanel jPanel4 = (JPanel)jPanel.getComponent(2);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
            this.mFileNameTextField = (JTextField)jPanel4.getComponent(1);
            this.mFileNameTextField.setDocument((Document)new FixedLengthDocument(255));
            this.addUsingGBL(jPanel2, this.mFileNameTextField, gridBagConstraints, 1, n3++, 1, 1, n2, insets);
            insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.addUsingGBL(jPanel2, (JComponent)jPanel3.getComponent(2), gridBagConstraints, 0, n3, 1, 1, n2, insets);
            insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            this.mFileTypeComboBox = (JComboBox)jPanel4.getComponent(2);
            this.addUsingGBL(jPanel2, this.mFileTypeComboBox, gridBagConstraints, 1, n3++, 1, 1, n2, insets);
            if (bl4) {
                insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                this.mEncodingLabel = new JLabel(BuilderResUtil.getString("IDS_FILE_CHOOSER_ENCODING_LABEL"));
                if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                    this.mEncodingLabel.setDisplayedMnemonic(BuilderResUtil.getAccessKey("IDK_FILE_CHOOSER_ENCODING_LABEL"));
                }
                this.addUsingGBL(jPanel2, this.mEncodingLabel, gridBagConstraints, 0, n3, 1, 1, n2, insets);
                insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                String[] stringArray = new String[]{BuilderResUtil.getString("IDS_UNICODE_UTF8"), BuilderResUtil.getString("IDS_LOCAL_ENCODING")};
                this.mEncodingComboBox = new JComboBox<String>(stringArray);
                this.mEncodingComboBox.setEditable(false);
                this.addUsingGBL(jPanel2, this.mEncodingComboBox, gridBagConstraints, 1, n3++, 1, 1, n2, insets);
                this.mEncodingLabel.setLabelFor(this.mEncodingComboBox);
            }
            insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getComponentGroupGap() * 2, 0, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.addUsingGBL(jPanel2, this.getButtonPanel(), gridBagConstraints, 2, 0, 1, n3 + 1, n2, insets);
            if (!bl2) {
                gridBagConstraints.weighty = 1.0;
            }
            if (bl) {
                insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
                this.addUsingGBL(jPanel2, this.getCheckBoxPanel(), gridBagConstraints, 1, n3++, 1, 1, n2, insets);
            }
            int n4 = n3;
            if (bl2) {
                gridBagConstraints.weighty = 0.0;
                insets.set(DialogUtil.getGroupBoxInnerMargin() * 2, 0, 0, 0);
                gridBagConstraints.fill = 2;
                this.addUsingGBL(jPanel2, new JSeparator(), gridBagConstraints, 0, n4++, 2, 1, n2, insets);
                insets.set(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
                gridBagConstraints.fill = 0;
                n2 = 19;
                gridBagConstraints.weighty = 1.0;
                this.addUsingGBL(jPanel2, this.mPESButton, gridBagConstraints, 0, n4, 2, 1, n2, insets);
                this.mPESButton.addActionListener(new PesStoreAction());
            }
            ((JPanel)container).add((Component)jPanel2, "South");
        }
    }

    private JPanel getCheckBoxPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        this.addUsingGBL(jPanel, this.mWriteCheckBox, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.addUsingGBL(jPanel, this.mSaveValueLabels, gridBagConstraints, 0, 1, 1, 1, n, null);
        this.addUsingGBL(jPanel, this.mSaveValueLabelsToFile, gridBagConstraints, 0, 2, 1, 1, n, null);
        RemoteFileChooser remoteFileChooser = (RemoteFileChooser)this.getFileChooser();
        if (remoteFileChooser.getChooserOption() != RemoteFileChooser.ChooserOption.ExportDimensions) {
            this.addUsingGBL(jPanel, this.mEncryptPasswordCheckBox, gridBagConstraints, 0, 3, 1, 1, n, null);
        }
        return jPanel;
    }

    protected void doFileFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof RefFileFilter) {
            Object object;
            if (this.mMinStringWidthsCheckbox != null) {
                object = (RefFileFilter)propertyChangeEvent.getNewValue();
                if (((RefFileFilter)object).getExtension().toUpperCase().equals("SAV") || ((RefFileFilter)object).getExtension().toUpperCase().equals("ZSAV") || propertyChangeEvent.getNewValue() instanceof BasicFileChooserUI.AcceptAllFileFilter) {
                    this.mMinStringWidthsCheckbox.setVisible(true);
                } else {
                    this.mMinStringWidthsCheckbox.setVisible(false);
                }
            }
            if (((RemoteFileChooser)(object = (RemoteFileChooser)this.getFileChooser())).getChooserType() == RemoteFileChooser.ChooserType.SaveFile) {
                this.updateEncodingComboUI(RemoteFileChooser.ChooserType.SaveFile);
            }
        } else if (propertyChangeEvent.getNewValue() instanceof BasicFileChooserUI.AcceptAllFileFilter && this.mMinStringWidthsCheckbox != null) {
            this.mMinStringWidthsCheckbox.setVisible(true);
        }
    }

    protected void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            try {
                FileInputStream fileInputStream;
                String string = file.getAbsolutePath().toLowerCase();
                if (this.mMinStringWidthsCheckbox != null) {
                    if (string.toUpperCase().endsWith(".SAV") || string.toUpperCase().endsWith(".ZSAV")) {
                        this.mMinStringWidthsCheckbox.setVisible(true);
                    } else {
                        this.mMinStringWidthsCheckbox.setVisible(false);
                    }
                }
                try {
                    fileInputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return;
                }
                String string2 = CharacterUtil.getEncoding((InputStream)fileInputStream);
                fileInputStream.close();
                boolean bl = false;
                if (string2 == null) {
                    this.mEncodingComboBox.setSelectedIndex(1);
                    bl = true;
                } else if (string2.equals("UTF-8")) {
                    this.mEncodingComboBox.setSelectedIndex(0);
                } else if (string2.equals("UTF-16BE")) {
                    this.mEncodingComboBox.setSelectedIndex(-1);
                } else if (string2.equals("UTF-16LE")) {
                    this.mEncodingComboBox.setSelectedIndex(-1);
                }
                RemoteFileChooser remoteFileChooser = (RemoteFileChooser)this.getFileChooser();
                if (remoteFileChooser.getChooserType() == RemoteFileChooser.ChooserType.OpenFile) {
                    this.updateEncodingComboUI(RemoteFileChooser.ChooserType.OpenFile);
                } else {
                    this.mEncodingLabel.setEnabled(bl);
                    this.mEncodingComboBox.setEnabled(bl);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private String getEncoding(RemoteFileChooser remoteFileChooser) {
        String string = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(remoteFileChooser.getSelectedFile());
            string = CharacterUtil.getEncoding((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    private void changeFileExtension(String string) {
        SpssFile spssFile = new SpssFile(this.getFileName());
        String string2 = spssFile.getBasename();
        if (string2.length() != 0) {
            this.setFileName(string2 + "." + string);
        }
    }

    private void setCursor(JComponent jComponent, int n) {
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        if (window != null) {
            Cursor cursor = Cursor.getPredefinedCursor(n);
            window.setCursor(cursor);
        }
    }

    private boolean isGlobPattern(String string, int n) {
        int n2;
        boolean bl = false;
        String string2 = "\"";
        boolean bl2 = string.startsWith(string2) && string.endsWith(string2);
        int n3 = n2 = bl2 ? 2 : 1;
        if (string.indexOf(60) >= 0 || string.indexOf(62) >= 0 || string.indexOf(124) >= 0) {
            bl = true;
        } else if (n == 1 && (string.indexOf(63) >= 0 || string.indexOf(42) >= 0)) {
            bl = true;
        } else if (n == 2 && string.indexOf("://") > -1) {
            bl = false;
        } else if (File.separatorChar == '/' && string.indexOf("spsscr:") < 0 && (string.indexOf(92) >= 0 || string.indexOf(58) >= 0)) {
            bl = true;
        } else if (File.separatorChar == '\\' && string.indexOf("spsscr:") < 0 && (string.indexOf(58) == 0 || !bl2 && string.indexOf(58, n2 + 1) > n2 || !bl2 && string.indexOf(34) >= 0 || string.indexOf(47) >= 0)) {
            bl = true;
        }
        return bl;
    }

    private void customizeTopButtons() {
        Component component = this.getFileChooser().getComponent(0);
        if (component instanceof JToolBar) {
            JToolBar jToolBar = (JToolBar)component;
            ArrayList<Component> arrayList = new ArrayList<Component>();
            JComboBox jComboBox = null;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < jToolBar.getComponentCount(); ++i) {
                Object object;
                Object object2;
                Component component2 = jToolBar.getComponent(i);
                if (component2 instanceof Box.Filler) {
                    object2 = (Rectangle)component2.getBounds().clone();
                    ((Rectangle)object2).width += 10;
                    component2.setBounds((Rectangle)object2);
                }
                if (component2 instanceof JButton) {
                    ((JButton)component2).setFocusPainted(true);
                    if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                        object2 = null;
                        if (n == 0) {
                            object2 = BuilderResUtil.getImageResource("folderUp.png");
                            ++n;
                        } else if (n == 1) {
                            object2 = BuilderResUtil.getImageResource("folderNew.png");
                        }
                        object = new ImageIcon((URL)object2);
                        ((JButton)component2).setIcon((Icon)object);
                        ((JButton)component2).putClientProperty("JButton.buttonType", "textured");
                    }
                } else if (component2 instanceof JToggleButton) {
                    ((JToggleButton)component2).setFocusPainted(true);
                    if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                        object2 = "";
                        if (n2 == 0) {
                            object2 = "NSImage://NSIconViewTemplate";
                            ++n2;
                        } else if (n2 == 1) {
                            object2 = "NSImage://NSListViewTemplate";
                        }
                        object = Toolkit.getDefaultToolkit().getImage((String)object2);
                        ImageIcon imageIcon = new ImageIcon((Image)object);
                        ((JToggleButton)component2).setIcon(imageIcon);
                    }
                } else if (component2 instanceof JComboBox) {
                    jComboBox = this.createOwnDirectoryCombo((JComboBox)component2);
                }
                if (component2 instanceof JComboBox) {
                    arrayList.add(jComboBox);
                    continue;
                }
                arrayList.add(component2);
            }
            jToolBar.removeAll();
            for (Component component2 : arrayList) {
                jToolBar.add(component2);
            }
        }
    }

    private JComboBox createOwnDirectoryCombo(JComboBox jComboBox) {
        JComboBox jComboBox2 = new JComboBox(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width += 20;
                return dimension;
            }
        };
        jComboBox2.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        Component component = this.getFileChooser().getComponent(0);
        ((JLabel)((JToolBar)component).getComponent(0)).setLabelFor(jComboBox2);
        jComboBox2.setModel(jComboBox.getModel());
        jComboBox2.addActionListener((ActionListener)((Object)new DirectoryComboBoxActionEx()));
        jComboBox2.setRenderer(jComboBox.getRenderer());
        jComboBox2.setAlignmentX(0.0f);
        jComboBox2.setAlignmentY(0.5f);
        jComboBox2.setMaximumRowCount(8);
        return jComboBox2;
    }

    protected WindowsFileChooserUI.DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new PatchedDirectoryComboBoxModel();
    }

    private final class PatchedDirectoryComboBoxModel
    extends WindowsFileChooserUI.DirectoryComboBoxModel {
        private PatchedDirectoryComboBoxModel() {
            super((WindowsFileChooserUI)RefWindowsFileChooserUI.this);
        }

        public int getSize() {
            return this.getElementsWithoutShortcuts().size();
        }

        public Object getElementAt(int n) {
            return this.getElementsWithoutShortcuts().get(n);
        }

        private ArrayList<Object> getElementsWithoutShortcuts() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < super.getSize(); ++i) {
                Object object = super.getElementAt(i);
                if (object instanceof ShellFolder) {
                    if (((ShellFolder)object).isLink()) continue;
                    arrayList.add(object);
                    continue;
                }
                arrayList.add(object);
            }
            return arrayList;
        }
    }

    protected class DirectoryComboBoxActionEx
    extends WindowsFileChooserUI.DirectoryComboBoxAction {
        protected DirectoryComboBoxActionEx() {
            super((WindowsFileChooserUI)RefWindowsFileChooserUI.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
        }
    }

    protected class ExtendedPropertyChangeListener
    implements PropertyChangeListener {
        private PropertyChangeListener mParentListener;

        public ExtendedPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.mParentListener = propertyChangeListener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.mParentListener.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            RemoteFileChooser remoteFileChooser = (RemoteFileChooser)RefWindowsFileChooserUI.this.getFileChooser();
            if (string.equals("fileFilterChanged") && (remoteFileChooser.getChooserType() == RemoteFileChooser.ChooserType.OpenFile || remoteFileChooser.getChooserType() == RemoteFileChooser.ChooserType.SaveFile) && remoteFileChooser.getChooserOption() == RemoteFileChooser.ChooserOption.Data) {
                RefWindowsFileChooserUI.this.doFileFilterChanged(propertyChangeEvent);
            }
            if (string.equals("SelectedFileChangedProperty") && remoteFileChooser.getChooserType() == RemoteFileChooser.ChooserType.OpenFile && RefWindowsFileChooserUI.this.hasEncodingCombo(remoteFileChooser)) {
                RefWindowsFileChooserUI.this.doSelectedFileChanged(propertyChangeEvent);
            }
            if (string.equals("directoryChanged")) {
                RefWindowsFileChooserUI.this.setCursor(remoteFileChooser, 3);
            }
        }
    }

    protected class ExtendedListDataListener
    implements ListDataListener {
        RemoteFileChooser mChooser;

        protected ExtendedListDataListener() {
            this.mChooser = (RemoteFileChooser)RefWindowsFileChooserUI.this.getFileChooser();
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            RefWindowsFileChooserUI.this.setCursor(this.mChooser, 0);
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            RefWindowsFileChooserUI.this.setCursor(this.mChooser, 0);
        }
    }

    protected class VariablesAction
    extends AbstractAction {
        protected VariablesAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_SAVE_FILE_VARIABLES_BUTTON"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    protected class PesStoreAction
    extends AbstractAction {
        protected PesStoreAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Component component = ((RemoteFileChooser)RefWindowsFileChooserUI.this.getFileChooser()).getParentComponent();
            if (component instanceof BuilderFrame) {
                BuilderFrame builderFrame = (BuilderFrame)component;
                try {
                    builderFrame.saveDialogToPES(RefWindowsFileChooserUI.this.getFileChooser());
                    RefWindowsFileChooserUI.this.getFileChooser().cancelSelection();
                }
                catch (Exception exception) {
                    RefWindowsFileChooserUI.this.getFileChooser().cancelSelection();
                    BuilderAlertPane.showErrorMessageDialog(builderFrame, exception.getMessage(), BuilderUtil.getInstance().getAppVersionString());
                }
            }
        }
    }

    protected class PesRetrieveAction
    extends AbstractAction {
        protected PesRetrieveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Component component = ((RemoteFileChooser)RefWindowsFileChooserUI.this.getFileChooser()).getParentComponent();
            if (component instanceof BuilderFrame) {
                BuilderFrame builderFrame = (BuilderFrame)component;
                try {
                    RefWindowsFileChooserUI.this.getFileChooser().cancelSelection();
                }
                catch (Exception exception) {
                    RefWindowsFileChooserUI.this.getFileChooser().cancelSelection();
                    BuilderAlertPane.showErrorMessageDialog(builderFrame, exception.getMessage(), BuilderUtil.getInstance().getAppVersionString());
                }
            }
        }
    }

    protected class HelpSelectedAction
    extends AbstractAction {
        protected HelpSelectedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFileChooser remoteFileChooser = (RemoteFileChooser)RefWindowsFileChooserUI.this.getFileChooser();
            remoteFileChooser.doHelp();
        }
    }

    protected class CancelAction
    extends BasicFileChooserUI.CancelSelectionAction {
        protected CancelAction() {
            super((BasicFileChooserUI)((Object)RefWindowsFileChooserUI.this));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
        }
    }

    protected class ApproveOpenSelectionAction
    extends BasicFileChooserUI.ApproveSelectionAction {
        protected ApproveOpenSelectionAction() {
            super((BasicFileChooserUI)((Object)RefWindowsFileChooserUI.this));
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            block32: {
                File file;
                block30: {
                    RemoteFileChooser remoteFileChooser;
                    block31: {
                        boolean bl2;
                        Object object;
                        int n;
                        int n2;
                        boolean bl3;
                        remoteFileChooser = (RemoteFileChooser)RefWindowsFileChooserUI.this.getFileChooser();
                        boolean bl4 = bl = RefWindowsFileChooserUI.this.mFileNameTextField != null && RefWindowsFileChooserUI.this.mFileNameTextField.getText() != null && FileTextField.isPathBidiProcessingNeeded(RefWindowsFileChooserUI.this.mFileNameTextField.getText());
                        if (bl) {
                            RefWindowsFileChooserUI.this.mFileNameTextField.setText(FileTextField.removeLRM(RefWindowsFileChooserUI.this.mFileNameTextField.getText()));
                        }
                        File file2 = file = !RefWindowsFileChooserUI.this.isDirectorySelected() ? remoteFileChooser.getSelectedFile() : RefWindowsFileChooserUI.this.getDirectory();
                        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                            file = null;
                        }
                        String string = RefWindowsFileChooserUI.this.getFileName();
                        int n3 = string.length();
                        if (string.compareTo(".") == 0) {
                            string = "";
                        }
                        if (string.length() > 0) {
                            bl3 = false;
                            for (n2 = 0; n2 < n3 && string.charAt(n2) == ' '; ++n2) {
                            }
                            for (n = string.length() - 1; n >= 0 && string.charAt(n) == ' '; --n) {
                            }
                            RefWindowsFileChooserUI.this.mEnteredTrimmedText = string.substring(n2, n + 1);
                            object = " '\"";
                            for (n2 = 0; n2 < n3 && ((String)object).indexOf(string.charAt(n2)) != -1; ++n2) {
                                bl3 = true;
                            }
                            for (n = string.length() - 1; n >= 0 && ((String)object).indexOf(string.charAt(n)) != -1; --n) {
                                bl3 = true;
                            }
                            if (bl3) {
                                string = n >= n2 ? string.substring(n2, n + 1) : "";
                            }
                        }
                        if (n3 != string.length()) {
                            RefWindowsFileChooserUI.this.setFileName(string);
                        }
                        if (!(string.length() != 0 || file != null && file.isDirectory())) {
                            RefWindowsFileChooserUI.this.setDirectorySelected(true);
                            JButton jButton = RefWindowsFileChooserUI.this.getApproveButton(remoteFileChooser);
                            jButton.setText(RefWindowsFileChooserUI.this.getApproveButtonText(remoteFileChooser));
                            if (remoteFileChooser.getChooserType() == RemoteFileChooser.ChooserType.SaveFile) {
                                jButton.setMnemonic(BuilderResUtil.getAccessKey("IDK_FILE_CHOOSER_SAVE_BUTTON"));
                            }
                            if (bl) {
                                RefWindowsFileChooserUI.this.mFileNameTextField.setText(FileTextField.insertLRM(RefWindowsFileChooserUI.this.mFileNameTextField.getText()));
                            }
                            return;
                        }
                        n2 = 0;
                        if (RefWindowsFileChooserUI.this.isGlobPattern(string, remoteFileChooser.getDialogType())) {
                            String string2 = String.format(BuilderResUtil.getString("ERR_FILE_SAVE_INVALID"), string);
                            JFrame jFrame = null;
                            if (remoteFileChooser.getParentComponent() instanceof JFrame) {
                                jFrame = (JFrame)remoteFileChooser.getParentComponent();
                            }
                            BuilderAlertPane.showInformationMessageDialog(jFrame, string2, BuilderUtil.getInstance().getAppVersionString());
                            if (bl) {
                                RefWindowsFileChooserUI.this.mFileNameTextField.setText(FileTextField.insertLRM(RefWindowsFileChooserUI.this.mFileNameTextField.getText()));
                            }
                            RefWindowsFileChooserUI.this.getFileNameTextField().selectAll();
                            return;
                        }
                        boolean bl5 = bl3 = string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'");
                        if (bl3 && string.indexOf(File.separator) > -1) {
                            n = string.lastIndexOf(File.separator);
                            string = string.substring(1, n + 1) + "\"" + string.substring(n + 1);
                        }
                        String string3 = LocalFileSysUtil.getLocalFileSysUtil().ExpandEnvVars(string);
                        RefWindowsFileChooserUI.this.setFileName(string3);
                        object = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                        boolean bl6 = bl2 = object != null && object.getClass().getName().contains("FilePane");
                        if ((remoteFileChooser.getChooserType() != RemoteFileChooser.ChooserType.OpenFolder || bl2) && file != null && file.isDirectory()) {
                            RefWindowsFileChooserUI.this.setDirectory(file);
                            RefWindowsFileChooserUI.this.setDirectorySelected(true);
                            RefWindowsFileChooserUI.this.getApproveButton(remoteFileChooser).setText(RefWindowsFileChooserUI.this.getApproveButtonText(remoteFileChooser));
                        }
                        super.actionPerformed(actionEvent);
                        if (n2 != 0) {
                            if (bl) {
                                RefWindowsFileChooserUI.this.mFileNameTextField.setText(FileTextField.insertLRM(RefWindowsFileChooserUI.this.mFileNameTextField.getText()));
                            }
                            return;
                        }
                        file = remoteFileChooser.getSelectedFile();
                        if (!RefWindowsFileChooserUI.this.hasEncodingCombo(remoteFileChooser) || file == null) break block30;
                        RefWindowsFileChooserUI.this.mSelectedEncoding = BuilderUtil.getInstance().getCurrentCharset().name();
                        int n4 = RefWindowsFileChooserUI.this.mEncodingComboBox.getSelectedIndex();
                        if (!RefWindowsFileChooserUI.this.mEncodingComboBox.isEnabled()) break block31;
                        if (n4 == 0) {
                            RefWindowsFileChooserUI.this.mSelectedEncoding = "UTF-8";
                            break block32;
                        } else if (n4 == 1) {
                            RefWindowsFileChooserUI.this.mSelectedEncoding = "US-ASCII";
                        }
                        break block32;
                    }
                    if (remoteFileChooser.getChooserType() == RemoteFileChooser.ChooserType.OpenFile && !remoteFileChooser.isServerFileSystem()) {
                        String string = RefWindowsFileChooserUI.this.getEncoding(remoteFileChooser);
                        if (string != null) {
                            RefWindowsFileChooserUI.this.mSelectedEncoding = string;
                        }
                        break block32;
                    } else if (remoteFileChooser.getChooserType() != RemoteFileChooser.ChooserType.SaveFile) {
                        // empty if block
                    }
                    break block32;
                }
                if (file == null) {
                    RefWindowsFileChooserUI.this.mSelectedEncoding = null;
                }
            }
            if (RefWindowsFileChooserUI.this.mErrorOccurred) {
                RefWindowsFileChooserUI.this.mErrorOccurred = false;
            }
            if (bl) {
                RefWindowsFileChooserUI.this.mFileNameTextField.setText(FileTextField.insertLRM(RefWindowsFileChooserUI.this.mFileNameTextField.getText()));
            }
        }
    }

    protected class ApprovePasteSelectionAction
    extends ApproveOpenSelectionAction {
        protected ApprovePasteSelectionAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_FILE_CHOOSER_PASTE_BUTTON"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFileChooser remoteFileChooser = (RemoteFileChooser)RefWindowsFileChooserUI.this.getFileChooser();
            remoteFileChooser.setPasteSelected(true);
            super.actionPerformed(actionEvent);
        }
    }
}

