/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.fopen;

import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LocalFileSysUtil {
    private static LocalFileSysUtil sUtil = null;
    private String mLeadPattern = null;
    private String mTrailPattern = null;

    public static LocalFileSysUtil getLocalFileSysUtil() {
        if (sUtil == null) {
            sUtil = new LocalFileSysUtil();
        }
        return sUtil;
    }

    private LocalFileSysUtil() {
        if (File.separatorChar == '\\') {
            this.mLeadPattern = "%";
            this.mTrailPattern = "%";
        } else {
            this.mLeadPattern = "$";
            this.mTrailPattern = "";
        }
    }

    public String ExpandFileSpec(String string, String string2) {
        string2 = this.ExpandEnvVars(string);
        File file = new File(string2);
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = string;
        }
        return string2;
    }

    public String ExpandEnvVars(String string) {
        String string2 = string;
        Map<String, String> map = System.getenv();
        Set<Map.Entry<String, String>> set = map.entrySet();
        if (File.separatorChar == '\\') {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while ((n = stringBuffer.indexOf(this.mLeadPattern, n)) >= 0) {
                int n2 = 0;
                n2 = stringBuffer.indexOf(this.mTrailPattern, n + 1);
                if (n2 <= 0) break;
                String string3 = System.getenv(stringBuffer.substring(n + 1, n2));
                if (string3 != null) {
                    stringBuffer.replace(n, n2 + 1, string3);
                    continue;
                }
                ++n;
            }
            string2 = stringBuffer.toString();
        } else {
            Iterator<Map.Entry<String, String>> iterator = set.iterator();
            while (string2.contains(this.mLeadPattern) && iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String string4 = this.mLeadPattern + entry.getKey() + this.mTrailPattern;
                string2 = string2.replace(string4, entry.getValue());
            }
        }
        return string2;
    }

    public boolean isPathAWindows7LibraryPath(File file) {
        boolean bl = false;
        if (OSInfo.getOSType() == OSInfo.OSType.WIN && file.getPath().startsWith("::{")) {
            bl = true;
        }
        return bl;
    }

    public boolean isPathWindows7RootLibraryPath(File file) {
        boolean bl = false;
        if (OSInfo.getOSType() == OSInfo.OSType.WIN && this.isPathAWindows7LibraryPath(file) && file.getPath().endsWith("}")) {
            bl = true;
        }
        return bl;
    }

    public boolean isWindows7LibraryEmpty(File file) {
        File file2;
        String string;
        boolean bl = false;
        if (OSInfo.getOSType() == OSInfo.OSType.WIN && (string = LocalFileSysUtil.getWin7LibraryDefaultSaveLocation(file2 = LocalFileSysUtil.getWin7LibraryXlmFile(file))) == null) {
            bl = true;
        }
        return bl;
    }

    public File getPhysicalLocationFromWin7LibraryPath(File file) {
        File file2 = new File(file.getPath());
        if (OSInfo.getOSType() == OSInfo.OSType.WIN && this.isPathAWindows7LibraryPath(file)) {
            File file3 = LocalFileSysUtil.getWin7LibraryXlmFile(file);
            if (file3 != null) {
                String string = LocalFileSysUtil.getWin7LibraryDefaultSaveLocation(file3);
                if (string != null) {
                    if (string.startsWith("knownfolder:{")) {
                        string = this.lookupGUID(string.substring("knownfolder:{".length(), string.length() - 1));
                    }
                    file2 = new File(string + File.separator + file.getName());
                }
            } else {
                file2 = new File(LocalFileSysUtil.buildWin7LibraryRootPath());
            }
        }
        return file2;
    }

    private static File getWin7LibraryXlmFile(File file) {
        File file2;
        block5: {
            file2 = null;
            if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                try {
                    String string = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    if (!file.getPath().startsWith("::{")) break block5;
                    String string = LocalFileSysUtil.buildWin7LibraryRootPath();
                    File file3 = file.getParentFile();
                    if (file.getPath().endsWith("library-ms")) {
                        String string2 = string + "\\" + file.getName();
                        file2 = new File(string2);
                    }
                    if (file3.getPath().endsWith("library-ms")) {
                        String string3 = string + "\\" + file3.getName();
                        file2 = new File(string3);
                    }
                    file2 = null;
                }
            }
        }
        return file2;
    }

    public static String buildWin7LibraryRootPath() {
        String string = System.getenv("APPDATA");
        if (string != null & string.length() > 0) {
            string = string + "\\Microsoft\\Windows\\Libraries";
        }
        return string;
    }

    private static String getWin7LibraryDefaultSaveLocation(File file) {
        String string = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("searchConnectorDescription");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                String string2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (string2 = LocalFileSysUtil.getTagValue("isDefaultSaveLocation", element = (Element)node)) == null || !string2.equals("true")) continue;
                NodeList nodeList2 = element.getElementsByTagName("simpleLocation");
                Node node2 = nodeList2.item(0);
                Element element2 = (Element)node2;
                string = LocalFileSysUtil.getTagValue("url", element2);
                break;
            }
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    private static String getTagValue(String string, Element element) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            nodeList = element.getElementsByTagName(string).item(0).getChildNodes();
            Node node = nodeList.item(0);
            return node.getNodeValue();
        }
        return null;
    }

    private String lookupGUID(String string) {
        if (string.equals("FDD39AD0-238F-46AF-ADB4-6C85480369C7")) {
            JFileChooser jFileChooser = new JFileChooser();
            FileSystemView fileSystemView = jFileChooser.getFileSystemView();
            string = fileSystemView.getDefaultDirectory().getPath();
        }
        return string;
    }
}

