/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.UIComponents;

import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.EncodingValidator;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class StringTextField
extends ContextEnabledTextField
implements FocusListener {
    private EncodingValidator mEncodingValidator;
    private boolean mValidateOnFocusLost = true;
    private boolean mTestOnly = false;
    private String mLastTestValue = "";

    public StringTextField() {
        this("", 0);
    }

    public StringTextField(String string) {
        this(string, 0);
    }

    public StringTextField(int n) {
        this("", n);
    }

    public StringTextField(String string, int n) {
        super(string, n);
        this.addFocusListener(this);
        this.mEncodingValidator = new EncodingValidator(BuilderUtil.getInstance().getCurrentCharset());
    }

    public int getMaxBytes() {
        return this.mEncodingValidator.getMaxBytes();
    }

    public void setMaxBytes(int n) {
        this.mEncodingValidator.setMaxBytes(n > -2 ? n : -1);
    }

    public void setEncoding(Charset charset) {
        if (charset != null && !this.mEncodingValidator.getEncoding().equals(charset)) {
            this.mEncodingValidator.setEncoding(charset);
        }
    }

    public Charset getEncoding() {
        return this.mEncodingValidator.getEncoding();
    }

    public boolean getValidateOnFocusLost() {
        return this.mValidateOnFocusLost;
    }

    public void setValidateOnFocusLost(boolean bl) {
        if (this.mValidateOnFocusLost != bl) {
            this.mValidateOnFocusLost = bl;
            if (this.mValidateOnFocusLost) {
                this.addFocusListener(this);
            } else {
                this.removeFocusListener(this);
            }
        }
    }

    public boolean validateContents() {
        boolean bl;
        this.select(0, 0);
        String string = this.getText();
        if (string == null || string.length() == 0) {
            return true;
        }
        try {
            bl = this.mEncodingValidator.validateString(string);
            if (!(bl || this.mTestOnly || string.equals(this.mLastTestValue))) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean bl = StringTextField.this.mEncodingValidator.getResult().equals(CoderResult.OVERFLOW);
                        String string = bl ? "ERR_STRING_OVERFLOW_MSG" : "ERR_STRING_UNMAPPABLE_MSG";
                        String string2 = UIToolResUtil.getString((String)string);
                        BuilderAlertPane.showPlainMessageDialog((JComponent)((Object)StringTextField.this), string2, BuilderUtil.getInstance().getAppVersionString());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                StringTextField.this.selectAll();
                                StringTextField.this.requestFocus();
                                StringTextField.this.mLastTestValue = "";
                            }
                        });
                    }
                });
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        this.mLastTestValue = string;
        return bl;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!this.mValidateOnFocusLost || this.isPopupisVisible()) {
            return;
        }
        Component component = focusEvent.getOppositeComponent();
        if (component == null || component instanceof JButton && ((JButton)component).getText().equals(BuilderResUtil.getString("IDS_CANCEL"))) {
            return;
        }
        this.validateContents();
    }

    void setTestOnly(boolean bl) {
        this.mTestOnly = bl;
    }

    CoderResult getResult() {
        return this.mEncodingValidator.getResult();
    }
}

