/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.UIComponents;

import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.LineInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.PrintGraphics;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.print.PrinterGraphics;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.print.ProxyPrintGraphics;

public class SpssMultiLineToggleButtonUtil {
    private static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, true, false);
    static final int DEFAULT_MAX_WIDTH = 220;

    public static void renderFocusRectangle(Graphics graphics, JToggleButton jToggleButton, int n) {
        LookAndFeel lookAndFeel;
        Dimension dimension = jToggleButton.getPreferredSize();
        Insets insets = jToggleButton.getMargin();
        int n2 = n + jToggleButton.getIconTextGap();
        dimension.height -= insets.top + insets.bottom;
        graphics.setColor(UIManager.getColor("ToggleButton.focus"));
        boolean bl = true;
        LookAndFeel lookAndFeel2 = lookAndFeel = !bl ? BuilderUtil.getInstance().getLookAndFeel() : null;
        if (!bl && lookAndFeel.getClass().getName().equals(UIManager.getSystemLookAndFeelClassName())) {
            dimension.width -= n2;
            BasicGraphicsUtils.drawDashedRect(graphics, n2, insets.top, dimension.width, dimension.height);
        } else if (lookAndFeel != null && lookAndFeel.getClass().getSimpleName().contains("Cobalt")) {
            dimension.width -= n2 - insets.left;
            BasicGraphicsUtils.drawDashedRect(graphics, n2 - insets.left - 1, insets.top, dimension.width, dimension.height);
        } else {
            dimension.width -= n2 - insets.left;
            graphics.drawRect(n2 - insets.left - 1, insets.top, dimension.width, dimension.height);
        }
    }

    public static void renderMultiLineText(Graphics graphics, JToggleButton jToggleButton, Vector<LineInfo> vector, int n, String string) {
        Color color = graphics.getColor();
        if (UIManager.getLookAndFeel().getName().contains("Windows")) {
            graphics.setColor(SystemColor.controlText);
        }
        boolean bl = string != null && OSInfo.getOSType() != OSInfo.OSType.MAC;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = n + jToggleButton.getIconTextGap() + jToggleButton.getMargin().left;
        int n3 = jToggleButton.getMargin().top + fontMetrics.getMaxAscent();
        for (LineInfo lineInfo : vector) {
            String string2 = lineInfo.getLineData();
            if (bl) {
                int n4 = string2.toUpperCase().indexOf(string.toUpperCase());
                if (n4 > -1) {
                    SpssMultiLineToggleButtonUtil.drawStringUnderlineCharAt(jToggleButton, graphics, string2, n4, n2, n3);
                    bl = false;
                } else {
                    SpssMultiLineToggleButtonUtil.drawString(jToggleButton, graphics, string2, n2, n3);
                }
            } else {
                SpssMultiLineToggleButtonUtil.drawString(jToggleButton, graphics, string2, n2, n3);
            }
            n3 += lineInfo.getLineSize().height;
        }
        graphics.setColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void layoutControlText(Graphics graphics, JToggleButton jToggleButton, Vector<LineInfo> vector, int n) {
        jToggleButton.setText("");
        vector.clear();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = (String)jToggleButton.getAction().getValue("Name");
        int n2 = n > 0 ? n : 65535;
        try {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\n")) {
                String string3;
                int n3;
                int n4 = fontMetrics.stringWidth(string2);
                while ((n3 = fontMetrics.stringWidth(string3 = SpssMultiLineToggleButtonUtil.clipStringIfNecessary(fontMetrics, string2, n2))) < n4) {
                    String string4;
                    int n5 = string3.lastIndexOf(" ");
                    if (n5 == -1) {
                        n5 = string2.lastIndexOf(" ");
                    }
                    if (n5 > -1) {
                        string4 = string2.substring(0, n5);
                        string2 = string2.substring(n5 + 1);
                    } else {
                        int n6 = string3.length() - 3;
                        string4 = string3.substring(0, n6);
                        string2 = string2.substring(n6);
                    }
                    n4 = fontMetrics.stringWidth(string2);
                    vector.add(new LineInfo(string4, new Dimension(fontMetrics.stringWidth(string4), fontMetrics.getHeight())));
                }
                vector.add(new LineInfo(string2, new Dimension(n4, fontMetrics.getHeight())));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            graphics.dispose();
        }
    }

    public static void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n, int n2, int n3) {
        SpssMultiLineToggleButtonUtil.drawString(jComponent, graphics, string, n2, n3);
        if (n >= 0 && n < string.length()) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = n2 + fontMetrics.stringWidth(string.substring(0, n));
            int n5 = fontMetrics.charWidth(string.charAt(n));
            int n6 = 1;
            graphics.fillRect(n4, n3 + 1, n5, n6);
        }
    }

    public static void drawString(JComponent jComponent, Graphics graphics, String string, int n, int n2) {
        Graphics2D graphics2D;
        if (string == null || string.length() <= 0) {
            return;
        }
        if (SpssMultiLineToggleButtonUtil.isPrinting(graphics) && (graphics2D = SpssMultiLineToggleButtonUtil.getGraphics2D(graphics)) != null) {
            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), DEFAULT_FRC);
            Color color = graphics2D.getColor();
            textLayout.draw(graphics2D, n, n2);
            graphics2D.setColor(color);
            return;
        }
        SpssMultiLineToggleButtonUtil.addRenderingHints(graphics);
        graphics.drawString(string, n, n2);
    }

    private static void addRenderingHints(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Map map = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            graphics2D.addRenderingHints(map);
        }
    }

    private static Graphics2D getGraphics2D(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            return (Graphics2D)graphics;
        }
        if (graphics instanceof ProxyPrintGraphics) {
            return (Graphics2D)((ProxyPrintGraphics)graphics).getGraphics();
        }
        return null;
    }

    public static String clipStringIfNecessary(FontMetrics fontMetrics, String string, int n) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n2 = fontMetrics.stringWidth(string);
        if (n2 > n) {
            return SpssMultiLineToggleButtonUtil.clipString(fontMetrics, string, n);
        }
        return string;
    }

    public static String clipString(FontMetrics fontMetrics, String string, int n) {
        int n2;
        String string2 = "...";
        int n3 = fontMetrics.stringWidth(string2);
        int n4 = string.length();
        for (n2 = 0; n2 < n4 && (n3 += fontMetrics.charWidth(string.charAt(n2))) <= n; ++n2) {
        }
        string = string.substring(0, n2) + string2;
        return string;
    }

    private static boolean isPrinting(Graphics graphics) {
        return graphics instanceof PrinterGraphics || graphics instanceof PrintGraphics;
    }
}

