/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.UIComponents;

import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.LineInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SpssMultiLineToggleButtonUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SpssMultiLineLabel
extends JLabel {
    private int mMaxWidth;
    private Vector<LineInfo> mLines = new Vector();
    private String mText;
    private String mMnemonic = null;

    public SpssMultiLineLabel(String string, Integer n, int n2) {
        this.mText = string;
        this.mMaxWidth = n2;
        if (OSInfo.getOSType() != OSInfo.OSType.MAC && n != null) {
            this.mMnemonic = "" + (char)n.intValue();
            this.setDisplayedMnemonic(n);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                this.doLayout();
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                this.doLayout();
            }

            void doLayout() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpssMultiLineLabel.this.layoutControlText();
                    }
                });
            }
        });
    }

    @Override
    public void setText(String string) {
        this.mText = string;
    }

    public String getLabelText() {
        return this.mText;
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public void setMaxWidth(int n) {
        this.mMaxWidth = n;
    }

    @Override
    public void setEnabled(boolean bl) {
        Color color = bl ? UIManager.getColor("textText") : UIManager.getColor("textInactiveText");
        this.setForeground(color);
        super.setEnabled(bl);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mLines.size() == 0) {
            this.layoutControlText();
        }
        int n = 0;
        Dimension dimension = new Dimension();
        for (LineInfo lineInfo : this.mLines) {
            dimension.width = n = Math.max(n, lineInfo.getLineSize().width);
            dimension.height += lineInfo.getLineSize().height;
        }
        return dimension;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        boolean bl = this.mMnemonic != null && OSInfo.getOSType() != OSInfo.OSType.MAC;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = 0;
        int n2 = fontMetrics.getMaxAscent();
        for (LineInfo lineInfo : this.mLines) {
            String string = lineInfo.getLineData();
            if (bl) {
                int n3 = string.toUpperCase().indexOf(this.mMnemonic.toUpperCase());
                if (n3 > -1) {
                    SpssMultiLineToggleButtonUtil.drawStringUnderlineCharAt(this, graphics, string, n3, n, n2);
                    bl = false;
                } else {
                    SpssMultiLineToggleButtonUtil.drawString(this, graphics, string, n, n2);
                }
            } else {
                SpssMultiLineToggleButtonUtil.drawString(this, graphics, string, n, n2);
            }
            n2 += lineInfo.getLineSize().height;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutControlText() {
        this.mLines.clear();
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = this.mText;
        int n = this.mMaxWidth > 0 ? this.mMaxWidth : 65535;
        try {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\n")) {
                int n2 = fontMetrics.stringWidth(string2);
                while (true) {
                    String string3 = null;
                    String string4 = SpssMultiLineToggleButtonUtil.clipStringIfNecessary(fontMetrics, string2, n);
                    int n3 = fontMetrics.stringWidth(string4);
                    if (n3 >= n2) break;
                    int n4 = string4.lastIndexOf(" ");
                    if (n4 == -1) {
                        n4 = string2.lastIndexOf(" ");
                    }
                    if (n4 > -1) {
                        string3 = string2.substring(0, n4);
                        string2 = string2.substring(n4 + 1);
                    } else {
                        boolean bl = false;
                        n4 = string2.lastIndexOf(" ");
                        if (n4 == -1 && (n4 = string2.lastIndexOf("-")) != -1 && n4 + 1 < string2.length()) {
                            bl = true;
                            ++n4;
                        }
                        n4 = n4 == -1 ? string2.length() - 1 : n4;
                        string3 = string2.substring(0, n4);
                        string2 = string2.substring(bl ? n4 : n4 + 1);
                    }
                    n2 = fontMetrics.stringWidth(string2);
                    this.mLines.add(new LineInfo(string3, new Dimension(fontMetrics.stringWidth(string3), fontMetrics.getHeight())));
                }
                this.mLines.add(new LineInfo(string2, new Dimension(n2, fontMetrics.getHeight())));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            graphics.dispose();
        }
    }
}

