/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.UIComponents;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class SpssButtonGroup
extends ButtonGroup {
    private ButtonGroupKeylistener mArrowKeyListener = new ButtonGroupKeylistener();
    private boolean mWantToggleBehaveAsRadioGroup = false;

    @Override
    public void add(AbstractButton abstractButton) {
        if (abstractButton == null) {
            return;
        }
        if (abstractButton instanceof JToggleButton) {
            if (abstractButton instanceof JRadioButton || this.mWantToggleBehaveAsRadioGroup) {
                super.add(abstractButton);
            } else {
                this.buttons.add(abstractButton);
            }
        } else if (abstractButton instanceof JButton) {
            this.buttons.add(abstractButton);
        }
        abstractButton.addKeyListener(this.mArrowKeyListener);
    }

    @Override
    public void remove(AbstractButton abstractButton) {
        if (abstractButton == null) {
            return;
        }
        if (abstractButton instanceof JToggleButton) {
            if (abstractButton instanceof JRadioButton || this.mWantToggleBehaveAsRadioGroup) {
                super.remove(abstractButton);
            } else {
                this.buttons.remove(abstractButton);
            }
        } else if (abstractButton instanceof JButton) {
            this.buttons.remove(abstractButton);
        }
        abstractButton.removeKeyListener(this.mArrowKeyListener);
    }

    public void setToggleBehaveAsRadioGroup(boolean bl) {
        this.mWantToggleBehaveAsRadioGroup = bl;
    }

    public boolean getToggleBehaveAsRadioGroup() {
        return this.mWantToggleBehaveAsRadioGroup;
    }

    class ButtonGroupKeylistener
    extends KeyAdapter {
        ButtonGroupKeylistener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            AbstractButton abstractButton = (AbstractButton)keyEvent.getComponent();
            if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 39) {
                AbstractButton abstractButton2;
                int n = SpssButtonGroup.this.buttons.indexOf(abstractButton) + 1;
                do {
                    if (n != SpssButtonGroup.this.buttons.size()) continue;
                    n = 0;
                } while (!(abstractButton2 = (AbstractButton)SpssButtonGroup.this.buttons.elementAt(n++)).isEnabled());
                this.focusButton(abstractButton2);
            } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 37) {
                AbstractButton abstractButton3;
                int n = SpssButtonGroup.this.buttons.indexOf(abstractButton) - 1;
                do {
                    if (n != -1) continue;
                    n += SpssButtonGroup.this.buttons.size();
                } while (!(abstractButton3 = (AbstractButton)SpssButtonGroup.this.buttons.elementAt(n--)).isEnabled());
                this.focusButton(abstractButton3);
            }
        }

        private void focusButton(AbstractButton abstractButton) {
            JRootPane jRootPane;
            abstractButton.requestFocusInWindow();
            if (abstractButton instanceof JRadioButton) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            } else if (abstractButton instanceof JButton && (jRootPane = SwingUtilities.getRootPane(abstractButton)) != null) {
                jRootPane.setDefaultButton((JButton)abstractButton);
            }
        }
    }
}

