/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.UIComponents;

import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.ComponentsArrowButton;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SerializableList;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.controls.ISpssArrowButtonMarker;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class SpssArrowButton
extends JButton
implements FocusListener,
ListSelectionListener,
ActionListener,
ISpssArrowButtonMarker {
    protected static ImageIcon[] sEnabledImages = new ImageIcon[2];
    protected static ImageIcon[] sDisabledImages = new ImageIcon[2];
    protected static ImageIcon[] sRolloverImages = new ImageIcon[2];
    protected static ImageIcon[] sPressedImages = new ImageIcon[2];
    protected static final String sActionCmd = "arrowPressed";
    protected ButtonOrientation mArrowOrientation = ButtonOrientation.right;
    protected SrcDestHolder[] mRegisteredContainers = new SrcDestHolder[2];
    protected boolean mUseSmallIcons = false;

    public SpssArrowButton() {
        this.mUseSmallIcons = false;
        this.init(this.mArrowOrientation);
    }

    public SpssArrowButton(boolean bl) {
        this.mUseSmallIcons = bl;
        this.init(this.mArrowOrientation);
    }

    public SpssArrowButton(ButtonOrientation buttonOrientation) {
        this.mUseSmallIcons = false;
        this.init(buttonOrientation);
    }

    public SpssArrowButton(boolean bl, ButtonOrientation buttonOrientation) {
        this.mUseSmallIcons = bl;
        this.init(buttonOrientation);
    }

    protected void init(ButtonOrientation buttonOrientation) {
        this.loadButtonImages();
        this.setActionCommand(sActionCmd);
        this.setPreferredSize(DialogUtil.getArrowButtonSize());
        this.addActionListener(this);
        this.setArrowOrientation(buttonOrientation);
        this.setDefaultCapable(true);
    }

    public ButtonOrientation getArrowOrientation() {
        return this.mArrowOrientation;
    }

    public void setArrowOrientation(ButtonOrientation buttonOrientation) {
        this.mArrowOrientation = buttonOrientation;
        this.setIcon(sEnabledImages[this.mArrowOrientation.ordinal()]);
        this.setDisabledIcon(sDisabledImages[this.mArrowOrientation.ordinal()]);
        this.setRolloverIcon(sRolloverImages[this.mArrowOrientation.ordinal()]);
        this.setRolloverSelectedIcon(sRolloverImages[this.mArrowOrientation.ordinal()]);
        this.setPressedIcon(sPressedImages[this.mArrowOrientation.ordinal()]);
        this.setSelectedIcon(sPressedImages[this.mArrowOrientation.ordinal()]);
        this.updateEnable(this.getSourceVarHolder());
        this.setAccessibleContextName();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        boolean bl;
        SrcDestHolder srcDestHolder;
        if (!focusEvent.isTemporary() && (srcDestHolder = this.getHolder(focusEvent.getComponent())) != null && !this.getArrowOrientation().equals((Object)srcDestHolder.mArrowOrient) && (bl = true)) {
            this.setArrowOrientation(srcDestHolder.mArrowOrient);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object instanceof Component || object instanceof DefaultListSelectionModel) {
            SrcDestHolder srcDestHolder = object instanceof Component ? this.getHolder((Component)object) : this.getSourceVarHolder();
            if (srcDestHolder != null && srcDestHolder.mArrowOrient == this.getArrowOrientation()) {
                this.updateEnable(srcDestHolder);
            }
            if (srcDestHolder != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpssArrowButton.this.setAccessibleContextName();
                    }
                });
            }
        }
    }

    public void setAccessibleContextName(String string) {
        this.accessibleContext.setAccessibleName(string);
    }

    protected void setAccessibleContextName() {
        this.accessibleContext = this.getAccessibleContext();
        SrcDestHolder srcDestHolder = null;
        SrcDestHolder srcDestHolder2 = null;
        if (this instanceof ComponentsArrowButton) {
            srcDestHolder = this.getTargetVarHolder();
            srcDestHolder2 = this.getSourceVarHolder();
        }
        if (srcDestHolder2 != null && srcDestHolder != null) {
            Object object;
            if (srcDestHolder2.getComponent() instanceof SerializableList && srcDestHolder.getComponent() instanceof SerializableList) {
                Object object2;
                if (srcDestHolder2.mArrowOrient == ButtonOrientation.right) {
                    Object object3 = ((JComponent)srcDestHolder.getComponent()).getClientProperty("labeledBy");
                    if (object3 instanceof JLabel) {
                        String string = MessageFormat.format(BuilderResUtil.getString("TXT_ADD_MESSAGE"), ((JLabel)object3).getText());
                        this.accessibleContext.setAccessibleName(string);
                    }
                } else if (srcDestHolder2.mArrowOrient == ButtonOrientation.left && (object2 = ((JComponent)srcDestHolder2.getComponent()).getClientProperty("labeledBy")) instanceof JLabel) {
                    String string = MessageFormat.format(BuilderResUtil.getString("TXT_REMOVE_MESSAGE"), ((JLabel)object2).getText());
                    this.accessibleContext.setAccessibleName(string);
                }
            } else if (this instanceof ComponentsArrowButton && srcDestHolder2.mArrowOrient == ButtonOrientation.right) {
                Object object4 = ((JComponent)srcDestHolder.getComponent()).getClientProperty("labeledBy");
                if (object4 instanceof JLabel) {
                    String string = MessageFormat.format(BuilderResUtil.getString("TXT_ADD_MESSAGE"), ((JLabel)object4).getText());
                    this.accessibleContext.setAccessibleName(string);
                }
            } else if (this instanceof ComponentsArrowButton && srcDestHolder2.mArrowOrient == ButtonOrientation.left && (object = ((JComponent)srcDestHolder2.getComponent()).getClientProperty("labeledBy")) instanceof JLabel) {
                String string = MessageFormat.format(BuilderResUtil.getString("TXT_REMOVE_MESSAGE"), ((JLabel)object).getText());
                this.accessibleContext.setAccessibleName(string);
            }
        }
    }

    protected void loadButtonImages() {
        Image image;
        ImageIcon imageIcon;
        URL uRL;
        if (sEnabledImages[0] == null) {
            uRL = BuilderResUtil.getImageResource("left_arrow.png");
            SpssArrowButton.sEnabledImages[0] = new ImageIcon(uRL);
            uRL = BuilderResUtil.getImageResource("right_arrow.png");
            SpssArrowButton.sEnabledImages[1] = new ImageIcon(uRL);
        }
        if (sDisabledImages[0] == null) {
            uRL = BuilderResUtil.getImageResource("left_arrow_disabled.png");
            SpssArrowButton.sDisabledImages[0] = new ImageIcon(uRL);
            uRL = BuilderResUtil.getImageResource("right_arrow_disabled.png");
            SpssArrowButton.sDisabledImages[1] = new ImageIcon(uRL);
        }
        if (sRolloverImages[0] == null) {
            for (int i = 0; i < 2; ++i) {
                imageIcon = sEnabledImages[i];
                image = imageIcon.getImage().getScaledInstance(imageIcon.getIconHeight() + 1, imageIcon.getIconHeight() + 1, 4);
                SpssArrowButton.sRolloverImages[i] = new ImageIcon(image);
            }
        }
        if (sPressedImages[0] == null) {
            for (int i = 0; i < 2; ++i) {
                imageIcon = sEnabledImages[i];
                image = imageIcon.getImage().getScaledInstance(imageIcon.getIconHeight() - 1, imageIcon.getIconHeight() - 1, 4);
                SpssArrowButton.sPressedImages[i] = new ImageIcon(image);
            }
        }
    }

    protected SrcDestHolder getHolder(Component component) {
        for (SrcDestHolder srcDestHolder : this.mRegisteredContainers) {
            if (srcDestHolder == null || srcDestHolder.getComponent() != component) continue;
            return srcDestHolder;
        }
        return null;
    }

    protected SrcDestHolder getSourceVarHolder() {
        for (SrcDestHolder srcDestHolder : this.mRegisteredContainers) {
            if (srcDestHolder == null || srcDestHolder.mArrowOrient != this.mArrowOrientation) continue;
            return srcDestHolder;
        }
        return null;
    }

    protected SrcDestHolder getTargetVarHolder() {
        for (SrcDestHolder srcDestHolder : this.mRegisteredContainers) {
            if (srcDestHolder == null || srcDestHolder.mArrowOrient == this.mArrowOrientation) continue;
            return srcDestHolder;
        }
        return null;
    }

    protected void updateTipText() {
        String string = !this.isEnabled() ? null : (this.mArrowOrientation == ButtonOrientation.left ? BuilderResUtil.getString("IDS_ARROW_LEFT_DESC") : BuilderResUtil.getString("IDS_ARROW_RIGHT_DESC"));
        this.setToolTipText(string);
    }

    protected abstract void updateEnable(SrcDestHolder var1);

    protected abstract class SrcDestHolder {
        public ButtonOrientation mArrowOrient;

        protected SrcDestHolder(ButtonOrientation buttonOrientation) {
            this.mArrowOrient = buttonOrientation;
        }

        protected abstract Component getComponent();
    }

    public static enum ButtonOrientation {
        left,
        right;

    }
}

