/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.UIComponents;

import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.LicenseOption;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import java.awt.Component;
import java.io.Serializable;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class SpssAction
extends AbstractAction
implements Cloneable {
    protected String mActionId = null;

    public SpssAction(String string) {
        this.mActionId = string;
    }

    public String getActionId() {
        return this.mActionId;
    }

    public LicenseOption getLicenseOption() {
        return BuilderUtil.getInstance().getLicenseOption();
    }

    public JFrame getFrame(Component component) {
        JFrame jFrame = null;
        while (component != null && !(component instanceof JFrame)) {
            Component component2 = component;
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            component = component2.getParent();
        }
        if (component != null) {
            jFrame = (JFrame)component;
        }
        return jFrame;
    }

    public JFrame getJFrame(Component component) {
        while (component != null && !(component instanceof JFrame)) {
            Component component2 = component;
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            component = component2.getParent();
        }
        return (JFrame)component;
    }

    public JMenuItem getMenuItem() {
        return new JMenuItem(this);
    }

    public boolean getMenuItemCheckStatus(JFrame jFrame) {
        return false;
    }

    public boolean getMenuItemEnableStatus(JFrame jFrame) {
        return true;
    }

    public void updateMenuText(JMenuItem jMenuItem) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SpssAction spssAction = (SpssAction)super.clone();
        spssAction.changeSupport = null;
        return spssAction;
    }

    protected void configureAction(boolean bl) {
        try {
            Serializable serializable;
            Object object;
            if (bl && (object = BuilderResUtil.getImageURL(this.mActionId)) != null) {
                this.putValue("SmallIcon", new ImageIcon((URL)object));
            }
            if ((object = BuilderResUtil.getString(this.mActionId)) != null) {
                this.putValue("Name", object);
            }
            if (OSInfo.getOSType() != OSInfo.OSType.MAC && (serializable = BuilderResUtil.getAccessKey(this.mActionId)) != null) {
                this.putValue("MnemonicKey", serializable);
            }
            if ((serializable = BuilderResUtil.getShortcut(this.mActionId)) != null) {
                this.putValue("AcceleratorKey", serializable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void enableToolTip() {
        String string = BuilderResUtil.getTooltip(this.mActionId);
        if (string != null) {
            this.putValue("ShortDescription", string);
        }
    }

    public boolean showMenu() {
        return true;
    }

    public boolean careMeasurementLevel() {
        return false;
    }

    public boolean careDVP() {
        return false;
    }
}

