/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.UIComponents;

import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BaseDataList;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.FocusHighlighter;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.IDoubleClickListener;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.ListKeyListener;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListModel;

public class SerializableList
extends BaseDataList {
    private String mActionKey;
    private boolean mIsSerializable;
    protected FocusHighlighter mFocusHighlighter = new FocusHighlighter(this);
    private int mMaxLimitOfList = -1;
    private ListKeyListener mListKeyListener;
    private Vector<IDoubleClickListener> mDoubleClickListener = new Vector();
    private boolean mDoubleClickEnabled = true;

    public SerializableList(String string) {
        super((ListModel)new DefaultListModel());
        this.updateUI();
        this.mActionKey = string;
        this.mIsSerializable = true;
        this.mListKeyListener = new ListKeyListener(this);
        this.addKeyListener(this.mListKeyListener);
        this.addMouseListener(new DoubleClickHandler());
    }

    @Override
    public void setEnabled(boolean bl) {
        JViewport jViewport;
        Container container;
        super.setEnabled(bl);
        this.setOpaque(bl);
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = (jViewport = (JViewport)container2).getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            jScrollPane.getVerticalScrollBar().setEnabled(bl);
            jScrollPane.getHorizontalScrollBar().setEnabled(bl);
            jScrollPane.setWheelScrollingEnabled(bl);
        }
    }

    @Override
    public void setSelectedIndex(int n) {
        super.setSelectedIndex(n);
        this.ensureIndexIsVisible(n);
    }

    @Override
    public void updateUI() {
        this.removeFocusListener(this.mFocusHighlighter);
        this.removeKeyListener(this.mListKeyListener);
        super.updateUI();
        this.addKeyListener(this.mListKeyListener);
        FocusHighlighter.sTargetBorder = null;
        this.addFocusListener(this.mFocusHighlighter);
    }

    public String getActionKey() {
        return this.mIsSerializable ? this.mActionKey : "";
    }

    public void setActionKey(String string) {
        this.mActionKey = string;
    }

    public FocusHighlighter getFocusHighlighter() {
        return this.mFocusHighlighter;
    }

    public boolean isSerializable() {
        return this.mIsSerializable;
    }

    public void setSerializable(boolean bl) {
        this.mIsSerializable = bl;
    }

    public int getMaxLimitOfList() {
        return this.mMaxLimitOfList;
    }

    public void setMaxLimitOfList(int n) {
        this.mMaxLimitOfList = n;
    }

    public void addDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        if (iDoubleClickListener == null || this.mDoubleClickListener.contains(iDoubleClickListener)) {
            return;
        }
        this.mDoubleClickListener.add(iDoubleClickListener);
    }

    public void removeDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        if (iDoubleClickListener == null || !this.mDoubleClickListener.contains(iDoubleClickListener)) {
            return;
        }
        this.mDoubleClickListener.remove(iDoubleClickListener);
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.mDoubleClickEnabled = bl;
    }

    class DoubleClickHandler
    extends MouseAdapter {
        DoubleClickHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SerializableList.this.isEnabled()) {
                SerializableList.this.grabFocus();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SerializableList.this.isEnabled()) {
                SerializableList.this.grabFocus();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SerializableList.this.mDoubleClickEnabled && SerializableList.this.isEnabled() && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && SerializableList.this.mDoubleClickListener.size() == 1) {
                ((IDoubleClickListener)SerializableList.this.mDoubleClickListener.get(0)).doDoubleClickAction();
            }
        }
    }
}

