/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.UIComponents;

import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.ui_builder.definition.AddOnType;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class MissingAddOnsDlg
extends BaseDialog {
    private boolean mWasContinuePressed = false;

    public static boolean checkForMissingAddOns(JFrame jFrame, DialogDefinition dialogDefinition) {
        Vector<String> vector = MissingAddOnsDlg.checkForMissing(dialogDefinition);
        if (vector.size() == 0) {
            return true;
        }
        MissingAddOnsDlg missingAddOnsDlg = new MissingAddOnsDlg(jFrame, vector);
        missingAddOnsDlg.setVisible(true);
        return missingAddOnsDlg.wasContinuePressed();
    }

    public static boolean checkForMissingAddOns(JDialog jDialog, DialogDefinition dialogDefinition) {
        Vector<String> vector = MissingAddOnsDlg.checkForMissing(dialogDefinition);
        if (vector.size() == 0) {
            return true;
        }
        MissingAddOnsDlg missingAddOnsDlg = new MissingAddOnsDlg(jDialog, vector);
        missingAddOnsDlg.setVisible(true);
        return missingAddOnsDlg.wasContinuePressed();
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_missing_plugin");
    }

    private void initialize(Vector<String> vector) {
        this.setTitle(this.getResString("IDS_MISSING_ADD_ONS_TITLE"));
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.top += 10;
        int n = 23;
        JLabel jLabel = new JLabel(this.getResString("IDS_MISSING_ADD_ONS_MSG1"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String object2 : vector) {
            defaultListModel.addElement(object2);
        }
        JList jList = new JList(defaultListModel);
        jList.setVisibleRowCount(4);
        gridBagConstraints.fill = 2;
        insets.top -= 4;
        DialogUtil.addUsingGBL(jPanel, new JScrollPane(jList), gridBagConstraints, 0, 1, 1, 1, n, insets);
        JLabel jLabel2 = new JLabel(this.getResString("IDS_MISSING_ADD_ONS_MSG2"));
        gridBagConstraints.weighty = 1.0;
        insets.bottom = 10;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        JButton jButton = new JButton(new ContinueAction());
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private static Vector<String> checkForMissing(DialogDefinition dialogDefinition) {
        Vector<String> vector = new Vector<String>();
        Set set = dialogDefinition.getRequiredAddOns();
        AddOnType[] addOnTypeArray = BuilderUtil.getInstance().getAddOnType();
        for (AddOnType addOnType : set) {
            boolean bl = false;
            for (AddOnType addOnType2 : addOnTypeArray) {
                if (addOnType != addOnType2) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            vector.add(addOnType.name());
        }
        return vector;
    }

    public boolean wasContinuePressed() {
        return this.mWasContinuePressed;
    }

    private MissingAddOnsDlg(JDialog jDialog, Vector<String> vector) {
        super(jDialog, "", true, BuilderResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), BuilderUtil.getInstance().getAppLocale()), BuilderResBundle.getImageFolder());
        this.initialize(vector);
        this.pack();
        this.setLocationRelativeTo(jDialog);
    }

    private MissingAddOnsDlg(JFrame jFrame, Vector<String> vector) {
        super(jFrame, "", true, BuilderResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), BuilderUtil.getInstance().getAppLocale()), BuilderResBundle.getImageFolder());
        this.initialize(vector);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MissingAddOnsDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MissingAddOnsDlg.this.dispose();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MissingAddOnsDlg.this.mWasContinuePressed = true;
            MissingAddOnsDlg.this.dispose();
        }
    }
}

