/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.UIComponents;

import com.spss.shared.custom_gui.ui_builder.app.UIComponents.IMatrixListener;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.MatrixImagesGroupEx;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class MatrixImageEx
extends JLabel {
    private Icon mImageLabelIcon;
    private MatrixImagesGroupEx mILGroup;
    private Vector<IMatrixListener> mListeners = new Vector();
    private static final Border SELECT_BORDER = BorderFactory.createLineBorder(Color.LIGHT_GRAY, 4);

    public MatrixImageEx(URL uRL) {
        this.mImageLabelIcon = new ImageIcon(uRL);
        this.setIcon(this.mImageLabelIcon);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessibleContext accessibleContext = MatrixImageEx.this.getAccessibleContext();
                if (accessibleContext != null) {
                    String string = accessibleContext.getAccessibleDescription();
                    if (string != null && !string.equals("")) {
                        accessibleContext.setAccessibleName(string);
                    } else {
                        String string2;
                        Object object = MatrixImageEx.this.getClientProperty("labeledBy");
                        if (object instanceof JLabel && (string2 = ((JLabel)object).getText()) != null && !string2.equals("")) {
                            accessibleContext.setAccessibleName(string2);
                        }
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MatrixImageEx matrixImageEx = MatrixImageEx.this.getImagesGroup().getSelectedMatrixImage();
                if (!matrixImageEx.equals(MatrixImageEx.this)) {
                    matrixImageEx.requestFocusInWindow();
                }
                MatrixImageEx.this.setSelected(true);
                MatrixImageEx.this.requestFocusInWindow();
                if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() > 1) {
                    MatrixImageEx.this.fireMatrixEvent(IMatrixListener.EventType.doubleClick, MatrixImageEx.this.getImagesGroup().getMatrixImageIndex(MatrixImageEx.this));
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                MatrixImageEx.this.resetBorder();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                MatrixImageEx.this.resetBorder();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MatrixImageEx.this.resetBorder();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                MatrixImageEx.this.resetBorder();
            }
        });
    }

    public void setSelected(boolean bl) {
        if (bl != this.isSelected()) {
            this.getImagesGroup().setSelected(this, bl);
            if (bl) {
                this.fireMatrixEvent(IMatrixListener.EventType.selectionChange, this.getImagesGroup().getMatrixImageIndex(this));
            }
        }
    }

    public boolean isSelected() {
        return this.getImagesGroup().isSelected(this);
    }

    public void setImageLabelGroup(MatrixImagesGroupEx matrixImagesGroupEx) {
        if (matrixImagesGroupEx == null) {
            return;
        }
        this.mILGroup = matrixImagesGroupEx;
        this.mILGroup.addMatrixImageItem(this);
    }

    public MatrixImagesGroupEx getImagesGroup() {
        if (this.mILGroup == null) {
            this.mILGroup = new MatrixImagesGroupEx();
        }
        return this.mILGroup;
    }

    public void addMatrixListener(IMatrixListener iMatrixListener) {
        if (!this.mListeners.contains(iMatrixListener)) {
            this.mListeners.add(iMatrixListener);
        }
    }

    public void removeMatrixListener(IMatrixListener iMatrixListener) {
        this.mListeners.remove(iMatrixListener);
    }

    public void setDefaultSelectedImage(boolean bl) {
        if (bl) {
            this.getImagesGroup().setSelected(this, bl);
            Border border = BorderFactory.createBevelBorder(0);
            Border border2 = BorderFactory.createLineBorder(Color.BLACK, 2);
            this.setBorder(BorderFactory.createCompoundBorder(border, border2));
        } else {
            Border border = BorderFactory.createBevelBorder(0);
            this.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createLineBorder(Color.WHITE, 2)));
        }
    }

    public void fireMatrixEvent(IMatrixListener.EventType eventType, int n) {
        for (IMatrixListener iMatrixListener : this.mListeners) {
            iMatrixListener.matrixImageEvent(eventType, n);
        }
    }

    public void resetBorder() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, this.getParent());
        if (this.getBounds().contains(point)) {
            this.setBorder(SELECT_BORDER);
        } else if (this.isSelected()) {
            Border border = BorderFactory.createBevelBorder(0);
            Border border2 = BorderFactory.createLineBorder(Color.BLACK, 2);
            this.setBorder(BorderFactory.createCompoundBorder(border, border2));
        } else {
            Border border = BorderFactory.createBevelBorder(0);
            this.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createLineBorder(Color.WHITE, 2)));
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.hasFocus()) {
            Insets insets = this.getBorder().getBorderInsets(this);
            Rectangle rectangle = this.getBounds();
            Rectangle rectangle2 = new Rectangle(insets.left + 1, insets.top + 1, rectangle.width - insets.left - insets.right - 2, rectangle.height - insets.top - insets.bottom - 2);
        }
    }
}

