/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.UIComponents;

import com.spss.shared.custom_gui.ui_builder.app.UIComponents.FixedLengthDocument;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.StringTextField;
import com.spss.uitools.controls.IFileTextFieldAccessor;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.TextAttribute;
import java.text.Bidi;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class FileTextField
extends StringTextField
implements IFileTextFieldAccessor {
    private KeyListener processKeyEvent = new KeyListener(){

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            String string = FileTextField.this.fileTextField.getText_unalteredContent();
            int n = FileTextField.this.fileTextField.getCaretPosition();
            if (string != null && keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 37 && keyEvent.getKeyCode() != 39) {
                String string2 = null;
                if (Character.toString(keyEvent.getKeyChar()).equals(System.getProperty("file.separator"))) {
                    if (string.length() > 2 && Character.toString(string.charAt(n - 1)).equals(System.getProperty("file.separator"))) {
                        string2 = n == 1 ? '\u200e' + string.substring(0) : string.substring(0, n - 1) + '\u200e' + string.substring(n - 1);
                        FileTextField.this.fileTextField.setText(string2);
                        FileTextField.this.fileTextField.setCaretPosition(n + 1);
                    }
                } else if ((keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) && n > 0 && Character.toString(string.charAt(n - 1)).equals(Character.valueOf('\u200e'))) {
                    string2 = n + 1 < string.length() ? string.substring(0, n) + string.substring(n + 1) : string.substring(0, n);
                    FileTextField.this.fileTextField.setText(string2);
                    FileTextField.this.fileTextField.setCaretPosition(n - 1);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }
    };
    private Action processFileTextFieldPasteEvent = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                String string = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                if (!FileTextField.isPathBidiProcessingNeeded(string)) {
                    FileTextField.this.fileTextField.replaceSelection(string);
                } else {
                    FileTextField.doReplaceSelection((JTextField)((Object)FileTextField.this.fileTextField), FileTextField.insertLRM(string));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };
    private String mFileName = "";
    private boolean mFocusableNonEditInfoField = false;
    private FileTextField fileTextField;
    private static final char Bidi_LRM = '\u200e';

    public FileTextField() {
        this(false);
    }

    public FileTextField(boolean bl) {
        this.setDocument(new FixedLengthDocument(255));
        this.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
        this.fileTextField = this;
        this.registerKeyListener();
        this.registerPasteAction();
        if (bl) {
            this.makeFocusableNonEditInfoField();
        }
    }

    private void registerKeyListener() {
        this.fileTextField.addKeyListener(this.processKeyEvent);
    }

    private void registerPasteAction() {
        this.fileTextField.registerKeyboardAction(this.processFileTextFieldPasteEvent, KeyStroke.getKeyStroke(86, 2), 0);
    }

    public String getSelectedText() {
        String string = super.getSelectedText();
        String string2 = null;
        if (string != null) {
            string2 = FileTextField.removeLRM(string);
        }
        return string2;
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.setFocusable(bl);
        this.setOpaque(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setOpaque(this.isEditable());
    }

    public String getText() {
        if (this.isEditable()) {
            if (super.getText() != null && super.getText().length() > 0 && super.getText().indexOf(8206) != -1) {
                return FileTextField.removeLRM(super.getText());
            }
            return super.getText();
        }
        if (this.mFileName != null && this.mFileName.length() > 0 && this.mFileName.indexOf(8206) != -1) {
            return FileTextField.removeLRM(this.mFileName);
        }
        return this.mFileName;
    }

    public String getText_unalteredContent() {
        if (this.isEditable()) {
            return super.getText();
        }
        return this.mFileName;
    }

    public void updateText() {
        this.setText(this.getText());
    }

    private void makeFocusableNonEditInfoField() {
        this.mFocusableNonEditInfoField = true;
        this.setEditable(false);
        this.setFocusable(true);
    }

    public void setText(String string) {
        this.mFileName = string != null && string.length() > 0 ? (string.indexOf(8206) == -1 ? FileTextField.insertLRM(string) : string) : string;
        if (!this.mFocusableNonEditInfoField) {
            this.setFocusable(this.isEditable());
        }
        if (this.getBorder() != null && (this.isEditable() || !this.getBorder().getClass().getSimpleName().equals("EmptyBorder"))) {
            if (string != null && string.length() > 0) {
                if (string.indexOf(8206) == -1) {
                    super.setText(FileTextField.insertLRM(string));
                } else {
                    super.setText(string);
                }
            } else {
                super.setText(string);
            }
            this.setCaretPosition(0);
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(string);
        String string2 = System.getProperty("file.separator");
        int n2 = string.lastIndexOf(string2);
        if (n2 == -1 || n <= this.getWidth()) {
            if (string != null && string.length() > 0) {
                if (string.indexOf(8206) == -1) {
                    super.setText(FileTextField.insertLRM(string));
                } else {
                    super.setText(string);
                }
            } else {
                super.setText(string);
            }
            this.setCaretPosition(0);
            return;
        }
        String string3 = string.substring(n2);
        n = fontMetrics.stringWidth("..." + string3);
        if (n >= this.getWidth()) {
            String string4 = "..." + string3;
            n = fontMetrics.stringWidth(string4);
            int n3 = 1;
            while (n > this.getWidth()) {
                string4 = string4.substring(0, string3.length() - n3);
                n = fontMetrics.stringWidth(string4);
                ++n3;
            }
            super.setText(string4);
            this.setCaretPosition(0);
            return;
        }
        String string5 = string.substring(0, n2);
        String string6 = string5 + "..." + string3;
        n = fontMetrics.stringWidth(string6);
        while (n > this.getWidth() && string5.length() > 0) {
            string5 = string5.substring(0, string5.length() - 1);
            string6 = string5 + "..." + string3;
            n = fontMetrics.stringWidth(string6);
        }
        super.setText(string6);
        this.setCaretPosition(0);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        if (this.mFocusableNonEditInfoField) {
            this.setSelectionStart(this.getText().length());
            this.setSelectionEnd(this.getText().length());
            this.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        if (this.mFocusableNonEditInfoField) {
            this.repaint();
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.hasFocus() && !this.isEditable()) {
            this.paintFocus(graphics);
        }
    }

    public void paintFocus(Graphics graphics) {
        Color color = UIManager.getColor("ToggleButton.focus");
        graphics.setColor(color);
        Rectangle rectangle = graphics.getClipBounds();
        rectangle.grow(-3, -3);
        BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static boolean isPathBidiProcessingNeeded(String string) {
        boolean bl = false;
        int n = -1;
        if (string != null && string.length() > 0 && string.indexOf(System.getProperty("file.separator")) != -1) {
            int n2;
            ArrayList<String> arrayList = new ArrayList<String>();
            n = string.indexOf(System.getProperty("file.separator"));
            while (n != -1) {
                if (n == 0 && string.length() > 1 && Character.toString(string.charAt(1)).equals(System.getProperty("file.separator"))) {
                    if (string.length() <= 2) break;
                    n = string.indexOf(System.getProperty("file.separator"), 2);
                    if (n == -1) continue;
                    arrayList.add(string.substring(2, n));
                    if (n + 1 < string.length() - 1) {
                        n = string.indexOf(System.getProperty("file.separator"), n + 1);
                        continue;
                    }
                    n = -1;
                    continue;
                }
                if (n + 1 < string.length()) {
                    n2 = string.indexOf(System.getProperty("file.separator"), n + 1);
                    if (n2 != -1) {
                        arrayList.add(string.substring(n + 1, n2));
                        if (n2 + 1 < string.length()) {
                            n = n2;
                            continue;
                        }
                        arrayList.add(string.substring(n + 1));
                        n = -1;
                        continue;
                    }
                    arrayList.add(string.substring(n + 1));
                    n = -1;
                    continue;
                }
                n = -1;
            }
            if (arrayList.size() > 0) {
                for (n2 = 0; n2 < arrayList.size() && n2 + 1 <= arrayList.size() - 1; ++n2) {
                    if (!new Bidi(Character.toString(((String)arrayList.get(n2)).charAt(0)), 1).isRightToLeft() || !new Bidi(Character.toString(((String)arrayList.get(n2 + 1)).charAt(0)), 1).isRightToLeft()) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    public static String insertLRM(String string) {
        String string2 = new String();
        int n = 0;
        if (string == null || string.length() == 0 || string.indexOf(8206) != -1) {
            return string;
        }
        int n2 = 0;
        while (n2 < string.length() && (n2 = string.indexOf(System.getProperty("file.separator"), n)) != -1) {
            if (n2 == 0) {
                if (string.length() > 1 && Character.toString(string.charAt(1)).equals(System.getProperty("file.separator"))) {
                    ++n2;
                    continue;
                }
                string2 = '\u200e' + System.getProperty("file.separator");
            } else {
                if (n2 + 1 < string.length() - 1 && Character.toString(string.charAt(n2 + 1)).equals(System.getProperty("file.separator"))) {
                    ++n2;
                    continue;
                }
                if (string.charAt(n2 - 1) != '\u200e') {
                    string2 = string2 + string.substring(n, n2) + '\u200e' + System.getProperty("file.separator");
                }
            }
            n = ++n2;
        }
        if (n < string.length()) {
            string2 = string2 + string.substring(n);
        }
        return string2;
    }

    public static String removeLRM(String string) {
        String string2 = new String();
        int n = 0;
        if (string.indexOf(8206) == -1) {
            return string;
        }
        int n2 = 0;
        while (n2 < string.length() && (n2 = string.indexOf(8206, n)) != -1) {
            string2 = n2 == 0 ? System.getProperty("file.separator") : string2 + string.substring(n, n2) + System.getProperty("file.separator");
            n = n2 += 2;
        }
        if (n < string.length()) {
            string2 = string2 + string.substring(n);
        }
        return string2;
    }

    public static void doReplaceSelection(JTextField jTextField, String string) {
        if (jTextField == null || string == null || string.length() == 0) {
            return;
        }
        String string2 = jTextField.getText();
        String string3 = jTextField.getSelectedText();
        if (string3 != null) {
            int n = jTextField.getSelectionStart();
            int n2 = jTextField.getSelectionEnd();
            if (n == 0 && n2 == string2.length() - 1) {
                jTextField.replaceSelection(string);
            } else {
                if (n > 0 && n2 == string2.length() - 1) {
                    string = FileTextField.concatPathElems(string2.substring(0, n), string);
                } else if (n == 0 && n2 < string2.length() - 2) {
                    string = FileTextField.concatPathElems(string, string2.substring(n2 + 1));
                } else if (n > 0 && n2 < string2.length() - 2) {
                    String string4 = FileTextField.concatPathElems(string2.substring(0, n), string);
                    string = string4 = FileTextField.concatPathElems(string4, string2.substring(n2));
                }
                jTextField.selectAll();
                jTextField.replaceSelection(string);
            }
        } else {
            if (jTextField.getText() != null && jTextField.getText().length() != 0) {
                int n = jTextField.getCaretPosition();
                if (n == 0) {
                    string = FileTextField.concatPathElems(string, string2);
                } else if (n == string2.length()) {
                    string = FileTextField.concatPathElems(string2, string);
                } else {
                    String string5 = FileTextField.concatPathElems(string2.substring(0, n), string);
                    string = string5 = FileTextField.concatPathElems(string5, string2.substring(n));
                }
                jTextField.selectAll();
            }
            jTextField.replaceSelection(string);
        }
    }

    public static String concatPathElems(String string, String string2) {
        String string3 = null;
        if (string == null && string2 != null) {
            return string2;
        }
        if (string2 == null && string != null) {
            return string;
        }
        if (string == null && string2 == null) {
            return null;
        }
        if (string.length() == 0) {
            if (string2.length() == 0) {
                return null;
            }
            string3 = Character.toString(string2.charAt(0)).equals(System.getProperty("file.separator")) ? '\u200e' + string2 : string2;
        } else if (string2.length() == 0) {
            if (string.length() == 0) {
                return null;
            }
            string3 = string.charAt(string.length() - 1) == '\u200e' ? string.substring(0, string.length() - 1) : string;
        } else {
            string3 = string.charAt(string.length() - 1) == '\u200e' ? string.substring(0, string.length() - 1) : string;
            string3 = Character.toString(string2.charAt(0)).equals(System.getProperty("file.separator")) ? string3 + '\u200e' + string2 : string3 + string2;
        }
        return string3;
    }
}

