/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.UIComponents;

import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.IButtonEditListener;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.StringTextField;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class ButtonEditCtrl
extends JComponent
implements TableCellEditor,
Serializable {
    protected StringTextField mTextField;
    protected JLabel mLabelField;
    protected JButton mButton = new JButton(new ButtonEditAction());
    protected EventListenerList mListenerList = new EventListenerList();
    protected int mColumn = -1;
    protected long mCurrentRow = -1L;
    protected transient ChangeEvent mChangeEvent = null;
    private Vector<IButtonEditListener> mButtonListeners = new Vector();

    public ButtonEditCtrl(int n) {
        this(null, n, false);
    }

    public ButtonEditCtrl(int n, boolean bl) {
        this(null, n, bl);
    }

    public ButtonEditCtrl(JButton jButton, int n, boolean bl) {
        this.setLayout(new FlowLayout(3, 0, 0));
        this.mColumn = n;
        if (jButton != null) {
            this.mButton = jButton;
        }
        this.mButton.setVerticalAlignment(3);
        this.mButton.setFocusPainted(false);
        if (bl) {
            this.mLabelField = new JLabel();
            this.add(this.mLabelField);
        } else {
            this.mTextField = new StringTextField();
            this.add((Component)((Object)this.mTextField));
        }
        this.setReadOnlyEdit(true);
        this.add(this.mButton);
        this.addKeyListener(new ButtonEditKeyAdapter());
    }

    public int getColumn() {
        return this.mColumn;
    }

    public void setReadOnlyEdit(boolean bl) {
        if (this.mTextField != null) {
            this.mTextField.setEditable(!bl);
            this.mTextField.setFocusable(!bl);
        } else if (this.mLabelField != null) {
            this.mLabelField.setFocusable(!bl);
        }
        if (this.mTextField == null && !bl) {
            System.out.println("Control was setup as staticFormatable, therefore it cannot be editable");
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.mTextField != null) {
            this.mTextField.setFont(font);
        } else if (this.mLabelField != null) {
            this.mLabelField.setFont(font);
        }
        this.mButton.setFont(font);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        int n5 = this.getPrefferedButtonWidth(n3, n4);
        if (this.mTextField != null) {
            this.mTextField.setPreferredSize(new Dimension(n3 - n5, n4));
        } else if (this.mLabelField != null) {
            this.mLabelField.setPreferredSize(new Dimension(n3 - n5, n4));
        }
        this.mButton.setPreferredSize(new Dimension(n5, n4));
    }

    protected int getPrefferedButtonWidth(int n, int n2) {
        return n2;
    }

    public StringTextField getTextField() {
        return this.mTextField;
    }

    public JLabel getLabelField() {
        return this.mLabelField;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (this.mTextField != null) {
            this.mCurrentRow = n;
            if (bl) {
                this.mTextField.setForeground(jTable.getSelectionForeground());
                this.mTextField.setBackground(jTable.getSelectionBackground());
            } else {
                this.mTextField.setForeground(jTable.getForeground());
                this.mTextField.setBackground(jTable.getBackground());
            }
            String string = this.getTextForValue(object);
            this.mTextField.setText(string);
        } else {
            this.mCurrentRow = n;
            String string = this.getTextForValue(object);
            this.mLabelField.setText(string);
        }
        return this;
    }

    protected String getTextForValue(Object object) {
        return object == null ? "" : object.toString();
    }

    @Override
    public Object getCellEditorValue() {
        return this.mTextField != null ? this.mTextField.getText() : this.mLabelField.getText();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.mListenerList.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.mListenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return (CellEditorListener[])this.mListenerList.getListeners(CellEditorListener.class);
    }

    public void addButtonListener(IButtonEditListener iButtonEditListener) {
        if (!this.mButtonListeners.contains(iButtonEditListener)) {
            this.mButtonListeners.add(iButtonEditListener);
        }
    }

    public void removeButtonListener(IButtonEditListener iButtonEditListener) {
        this.mButtonListeners.remove(iButtonEditListener);
    }

    @Override
    public void doLayout() {
        super.doLayout();
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.mListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.mChangeEvent == null) {
                this.mChangeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingStopped(this.mChangeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.mListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.mChangeEvent == null) {
                this.mChangeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.mChangeEvent);
        }
    }

    public void setTestOnly(boolean bl) {
        if (this.mTextField != null) {
            this.mTextField.setTestOnly(bl);
        }
    }

    private void fireButtonPressed() {
        for (IButtonEditListener iButtonEditListener : this.mButtonListeners) {
            iButtonEditListener.buttonPressed(this.mCurrentRow, this.mColumn);
        }
    }

    class ButtonEditAction
    extends AbstractAction {
        ButtonEditAction() {
            try {
                Integer n;
                String string = "IDS_BUTTON_EDIT_ACTION";
                String string2 = BuilderResUtil.getString(string);
                if (string2 != null) {
                    this.putValue("Name", string2);
                }
                if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = BuilderResUtil.getAccessKey(string = string.replaceFirst("IDS_", "IDK_"))) != null) {
                    this.putValue("MnemonicKey", n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ButtonEditCtrl.this.fireButtonPressed();
        }
    }

    class ButtonEditKeyAdapter
    extends KeyAdapter {
        ButtonEditKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32) {
                ButtonEditCtrl.this.fireButtonPressed();
            }
        }
    }
}

