/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.app.UIComponents;

import com.spss.uitools.controls.ListFindManager;
import com.spss.uitools.controls.ListToolTip;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JToolTip;
import javax.swing.ListModel;
import javax.swing.text.Position;

public class BaseDataList
extends JList {
    protected ListToolTip mToolTip;
    ListFindManager mFindManager = new ListFindManager();
    private CharsetEncoder mEncoder = Charset.forName("US-ASCII").newEncoder();
    private ListFindManager.Callback mCallback = null;

    public BaseDataList(ListModel listModel) {
        super(listModel);
        this.init();
    }

    public BaseDataList(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public BaseDataList(Vector<?> vector) {
        super(vector);
        this.init();
    }

    public BaseDataList() {
        this.init();
    }

    private void init() {
        this.turnOnCustomTooltips();
    }

    public void turnOffCustomTooltips() {
        this.mToolTip = null;
    }

    public void turnOnCustomTooltips() {
        this.mToolTip = new ListToolTip((JList)this);
        this.mToolTip.setComponent((JComponent)this);
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Point point = null;
        if (this.mToolTip != null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            point = new Point(dimension.width, dimension.height);
            if (this.mToolTip.getListIndex() >= 0) {
                point = mouseEvent.getPoint();
                int n = this.locationToIndex(point);
                point = (point = this.getPointForRow(n)) != null ? new Point(0, point.y) : new Point(0, 0);
            }
        } else {
            point = super.getToolTipLocation(mouseEvent);
        }
        return point;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.mToolTip == null) {
            return "";
        }
        if (!((BaseDataList)mouseEvent.getSource()).isEnabled()) {
            this.mToolTip.initTooltip(-1);
            return "";
        }
        if (this.mToolTip != null) {
            Point point = mouseEvent.getPoint();
            int n = this.locationToIndex(point);
            Rectangle rectangle = this.getCellBounds(n, n);
            n = n >= 0 && rectangle.contains(point) ? n : -1;
            this.mToolTip.initTooltip(n);
        }
        return "";
    }

    private Point getPointForRow(int n) {
        Rectangle rectangle = this.getCellBounds(n, n);
        return rectangle != null ? new Point(rectangle.x, rectangle.y) : null;
    }

    @Override
    public JToolTip createToolTip() {
        return this.mToolTip != null ? this.mToolTip : super.createToolTip();
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        int n = this.getSelectedIndex();
        if (!keyEvent.isConsumed() && keyEvent.isControlDown() && keyEvent.getKeyCode() == 67) {
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed() && n == this.getSelectedIndex()) {
            if (this.mCallback == null) {
                this.mCallback = new ListFindManager.Callback(){

                    public boolean isValidChar(KeyEvent keyEvent) {
                        return BaseDataList.this.testValidChar(keyEvent);
                    }

                    public String getRowText(int n) {
                        return BaseDataList.this.mFindManager.getCellTextFromRenderer((JList)BaseDataList.this, n);
                    }
                };
            }
            this.mFindManager.processKeyEvent((JList)this, this.mCallback, keyEvent);
        }
    }

    @Override
    public int getNextMatch(String string, int n, Position.Bias bias) {
        return -1;
    }

    protected boolean testValidChar(KeyEvent keyEvent) {
        boolean bl;
        if (!this.isReservedInvalidCharacter(keyEvent)) {
            try {
                this.mEncoder.reset();
                ByteBuffer byteBuffer = ByteBuffer.allocate(256);
                CharBuffer charBuffer = CharBuffer.wrap(new char[]{keyEvent.getKeyChar()});
                CoderResult coderResult = this.mEncoder.encode(charBuffer, byteBuffer, true);
                bl = coderResult.equals(CoderResult.UNDERFLOW);
                this.mEncoder.flush(byteBuffer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isReservedInvalidCharacter(KeyEvent keyEvent) {
        boolean bl = keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 35 || keyEvent.getKeyCode() == 33 || keyEvent.getKeyCode() == 34;
        return bl;
    }
}

