/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.Util;

public class OSInfo {
    private static OSType sOSType = null;

    public static OSType getOSType() {
        if (sOSType == null) {
            String string = System.getProperty("os.name", "Windows").toLowerCase();
            if (string.startsWith("win")) {
                sOSType = OSType.WIN;
            } else if (string.startsWith("mac os x")) {
                sOSType = OSType.MAC;
            } else if (string.startsWith("linux")) {
                sOSType = OSType.LINUX;
            } else if (string.startsWith("aix")) {
                sOSType = OSType.AIX;
            } else if (string.startsWith("hp-ux")) {
                sOSType = OSType.HPUX;
            } else if (string.startsWith("sunos")) {
                sOSType = OSType.SOLARIS;
            } else {
                sOSType = OSType.UNKNOWN;
                assert (false);
            }
        }
        return sOSType;
    }

    public static boolean isMacOSXLeopardOrLater() {
        boolean bl = false;
        if (OSInfo.getOSType() == OSType.MAC) {
            int n;
            String string = System.getProperty("os.version", "");
            int n2 = string.lastIndexOf(".");
            if (n2 != (n = string.indexOf("."))) {
                string = string.substring(0, n2);
            }
            if (Double.valueOf(string) >= 10.5) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isMacOSXLionOrLater() {
        boolean bl = false;
        if (OSInfo.getOSType() == OSType.MAC) {
            int n;
            String string = System.getProperty("os.version", "");
            int n2 = string.lastIndexOf(".");
            if (n2 != (n = string.indexOf("."))) {
                string = string.substring(0, n2);
            }
            if (Double.valueOf(string) >= 10.7) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isWindowsVista() {
        String string = System.getProperty("os.name", "Windows").toLowerCase();
        return string.startsWith("win") && string.indexOf("vista") > 0;
    }

    public static boolean isWindows7() {
        String string = System.getProperty("os.name", "Windows").toLowerCase();
        return string.equals("windows 7");
    }

    public static boolean isWindowsXP() {
        String string = System.getProperty("os.name", "Windows").toLowerCase();
        return string.startsWith("win") && string.indexOf("xp") > 0;
    }

    public static boolean isX64() {
        String string = System.getProperty("os.arch", "x86").toLowerCase();
        return OSInfo.getOSType() == OSType.WIN && !string.equals("x86");
    }

    public static boolean is64Bit() {
        return System.getProperty("sun.arch.data.model", "32").equals("64");
    }

    public static enum OSType {
        UNKNOWN,
        WIN,
        MAC,
        LINUX,
        AIX,
        HPUX,
        SOLARIS;

    }
}

