/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.Util;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.OpenDeployedDlg;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.CustomDlgInstaller;
import com.spss.shared.custom_gui.ui_builder.Util.ExtensionBundleHelper;
import com.spss.shared.custom_gui.ui_builder.Util.ExtensionBundleManifestHelper;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.ui_builder.definition.AppType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class ExtensionBundleRemover {
    private String mErrorMsg;
    private String mSuccessMsg;
    private boolean mNeedRemoveCDB;
    private ArrayList<String> mPathsNeedToBeDeleted;
    private ArrayList<String> mCDBInstalledFolderPath;
    private ArrayList<String> mExtBundleInstalledFilesAndFolders;
    private ExtensionBundleManifestHelper mManifestHelper;
    private File mSpeFile;
    private ArrayList<String> mExtPaths;
    private String mCDBPaths;
    private Set<String> mCommandSpecSet = new HashSet<String>();
    private Set<String> mDialogSpecSet = new HashSet<String>();
    private Set<String> mCodeSpecSet = new HashSet<String>();
    private Set<String> mCommandPath = new HashSet<String>();

    private void init() {
        this.mNeedRemoveCDB = false;
        this.mPathsNeedToBeDeleted = new ArrayList();
        this.mCDBInstalledFolderPath = new ArrayList();
        this.mExtBundleInstalledFilesAndFolders = new ArrayList();
        this.mCommandPath = new HashSet<String>();
        this.mCDBPaths = "";
        this.mExtPaths = new ArrayList();
        this.mManifestHelper = null;
        this.mCommandSpecSet = new HashSet<String>();
        this.mDialogSpecSet = new HashSet<String>();
        this.mSpeFile = null;
        this.mErrorMsg = "";
        this.mSuccessMsg = "";
    }

    private boolean deleteExtFolders() {
        for (String string : this.mExtBundleInstalledFilesAndFolders) {
            boolean bl;
            File file = new File(string);
            if (!(file.isDirectory() ? !(bl = BuilderUtil.getInstance().deleteFolder(file)) : !(bl = BuilderUtil.getInstance().deleteFile(file)))) continue;
            return false;
        }
        return true;
    }

    private boolean canBeDeleted(ArrayList<String> arrayList) {
        for (String string : arrayList) {
            File file = new File(string);
            String string2 = file.getParent() + File.separator;
            File file2 = new File(string2);
            if (file2.canWrite()) continue;
            return false;
        }
        return true;
    }

    private void loadPathsNeedToBeDeleted(String string) {
        this.mCDBPaths = BuilderUtil.getInstance().getExtensionPath().getAbsolutePath();
        this.mExtPaths = BuilderUtil.getInstance().getExtensionBundlePath();
        this.mPathsNeedToBeDeleted.clear();
        this.loadExtBundleInstalledFilesAndFolderPath(string);
        for (String string2 : this.mExtBundleInstalledFilesAndFolders) {
            this.mPathsNeedToBeDeleted.add(string2);
        }
        if (this.mNeedRemoveCDB) {
            this.loadCDBInstalledFolderPath();
            for (String string2 : this.mCDBInstalledFolderPath) {
                this.mPathsNeedToBeDeleted.add(string2);
            }
        }
    }

    private File unJarSpdToTempDir() throws IOException {
        String string = BuilderUtil.getInstance().getTempDir().getAbsolutePath();
        String string2 = string.endsWith(File.separator) ? string : string + File.separator;
        File file = new File(string2 = string2 + Calendar.getInstance().getTimeInMillis());
        if (!file.mkdir()) {
            return null;
        }
        ZipInputStream zipInputStream = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        JarEntry jarEntry = null;
        try {
            fileInputStream = new FileInputStream(this.mSpeFile);
            zipInputStream = new JarInputStream(fileInputStream);
            jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (jarEntry != null) {
            for (String string3 : this.mDialogSpecSet) {
                if (!jarEntry.getName().equals(string3)) continue;
                ByteBuffer byteBuffer = ExtensionBundleHelper.readEntry((JarInputStream)zipInputStream);
                String string4 = string2 + File.separator + string3;
                File file2 = new File(string4);
                fileOutputStream = new FileOutputStream(file2.getAbsolutePath());
                try {
                    fileOutputStream.write(byteBuffer.array());
                }
                catch (IOException iOException) {
                    fileOutputStream.close();
                }
                break;
            }
            zipInputStream.closeEntry();
            jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry();
        }
        zipInputStream.close();
        return file;
    }

    private void loadCDBInstalledFolderPath() {
        Object object;
        File file;
        Vector<String> vector = new Vector<String>();
        try {
            file = this.unJarSpdToTempDir();
        }
        catch (IOException iOException) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (File object22 : fileArray) {
            if (!object22.getName().endsWith(".spd")) continue;
            try {
                object = CustomDlgInstaller.readPackageFile(object22, true);
                vector.add(object.getDialogId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fileArray.length != 0) {
            this.mCDBPaths = BuilderUtil.getInstance().getExtensionPath().getParent();
        }
        File file2 = new File(this.mCDBPaths);
        File[] fileArray2 = file2.listFiles();
        for (String string : vector) {
            for (File file3 : fileArray2) {
                if (!file3.isDirectory() || !file3.getName().toString().equals(string)) continue;
                this.mCDBInstalledFolderPath.add(file3.getAbsolutePath());
            }
        }
        Set<String> set = this.mManifestHelper.getDialogSpecsSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!((String)object).endsWith(".cfe")) continue;
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                this.mCDBInstalledFolderPath.add(BuilderUtil.getInstance().getExtensionPath() + File.separator + (String)object);
                continue;
            }
            if (BuilderUtil.getInstance().getAppType() != AppType.MODELER) continue;
            this.mCDBInstalledFolderPath.add(BuilderUtil.getInstance().getExtensionPath() + File.separator + this.mManifestHelper.getBundleName() + File.separator + (String)object);
        }
    }

    private void loadExtBundleInstalledFilesAndFolderPath(String string) {
        for (String string2 : this.mExtPaths) {
            File[] object;
            Iterator<String> iterator = new File(string2);
            for (File file : object = ((File)((Object)iterator)).listFiles()) {
                if (!file.isDirectory() || !file.getName().toString().equals(string)) continue;
                this.mExtBundleInstalledFilesAndFolders.add(file.getAbsolutePath());
                File[] fileArray = file.listFiles(new OpenDeployedDlg.EXT_PACKAGE_FilenameFiler());
                if (fileArray == null || fileArray.length <= 0) break;
                try {
                    this.mSpeFile = this.getSpeFile(string, fileArray);
                    if (this.mSpeFile == null) break;
                    this.mManifestHelper = new ExtensionBundleManifestHelper(this.mSpeFile);
                    this.mCommandSpecSet = this.mManifestHelper.getCommandSpecsSet();
                    this.mCodeSpecSet = this.mManifestHelper.getCodeFilesSet();
                    this.mDialogSpecSet = this.mManifestHelper.getDialogSpecsSet();
                    if (!this.mDialogSpecSet.isEmpty()) {
                        this.mNeedRemoveCDB = true;
                        break;
                    }
                    this.mNeedRemoveCDB = false;
                }
                catch (ZipException zipException) {
                }
                catch (IOException iOException) {}
                break;
            }
            if (this.mExtBundleInstalledFilesAndFolders.isEmpty()) continue;
            break;
        }
        if (!this.mExtBundleInstalledFilesAndFolders.isEmpty()) {
            String string2;
            File file = new File(this.mExtBundleInstalledFilesAndFolders.get(0));
            string2 = file.getParent().toString() + File.separator;
            for (String string3 : this.mCommandSpecSet) {
                this.mCommandPath.add(string2 + string3);
                this.mExtBundleInstalledFilesAndFolders.add(string2 + string3);
            }
            for (String string4 : this.mCodeSpecSet) {
                String string5 = string2 + string4;
                this.mExtBundleInstalledFilesAndFolders.add(string5);
            }
        }
    }

    private File getSpeFile(String string, File[] fileArray) {
        for (File file : fileArray) {
            String string2 = file.getName().substring(0, file.getName().indexOf("."));
            if (!string2.equals(string)) continue;
            return file;
        }
        return null;
    }

    public boolean doRemove(String string) {
        this.init();
        this.loadPathsNeedToBeDeleted(string);
        if (!this.canBeDeleted(this.mPathsNeedToBeDeleted)) {
            return false;
        }
        if (this.mNeedRemoveCDB && !this.unDeployCDB()) {
            this.setErrorMsg("Could not remove extension " + string);
            return false;
        }
        for (String string2 : this.mCommandPath) {
        }
        if (!this.deleteExtFolders()) {
            this.setErrorMsg("Could not remove extension " + string);
            return false;
        }
        this.setSuccessMsg(MessageFormat.format(BuilderResUtil.getString("IDS_REMOVE_EXTENSION_SUCCESS_MSG"), string));
        return true;
    }

    private boolean unDeployCDB() {
        for (String string : this.mCDBInstalledFolderPath) {
            try {
                if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                    if (BuilderUtil.getInstance().removeDeployed(string)) continue;
                    return false;
                }
                if (BuilderUtil.getInstance().getAppType() != AppType.MODELER) continue;
                String string2 = BuilderFrame.getExtensionId(new File(string));
                BuilderUtil.getInstance().unloadExtension(string2);
                File file = new File(string);
                if (file.delete()) continue;
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    public static Vector<String> getCustomDialogBuilderPaths() {
        Vector<String> vector = new Vector<String>();
        vector.addAll(Arrays.asList(BuilderUtil.getInstance().getSecondaryExtensionFolders()));
        vector.add(BuilderUtil.getInstance().getAppdataCustomDialogDirectoryForAllUsers());
        if (System.getProperty("os.name", "Windows").toLowerCase().startsWith("win")) {
            vector.add(BuilderUtil.getInstance().getAppdataCustomDialogDirectory());
            vector.add(BuilderUtil.getInstance().getUIExtensionsFolderPath());
        } else {
            vector.add(BuilderUtil.getInstance().getUIExtensionsFolderPath());
            vector.add(BuilderUtil.getInstance().getAppdataCustomDialogDirectory());
        }
        return (Vector)vector.clone();
    }

    public String getErrorMsg() {
        return this.mErrorMsg;
    }

    public String getSuccessMsg() {
        return this.mSuccessMsg;
    }

    private void setErrorMsg(String string) {
        this.mErrorMsg = string;
    }

    private void setSuccessMsg(String string) {
        this.mSuccessMsg = string;
    }
}

