/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.Util;

import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.ui_builder.definition.AppType;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ExtensionBundleMessageDlg
extends BaseDialog {
    private String mHelpID;
    private String mTopMsg;
    private String mBottomMsg;
    private Vector<String> mListItems;
    private boolean mShowOkButton = true;
    private boolean continuePressed = false;
    private boolean initialized = false;
    private JTextArea mTopInfoTextArea;
    private JTextArea mBottomInfoTextArea;
    private JList mList;
    private JScrollPane mListScrollPane;
    private OkAction mOkAction = new OkAction();
    private JButton mOkButton = new JButton(this.mOkAction);
    private ContinueAction mContinueAction = new ContinueAction();
    private JButton mContinueButton = new JButton(this.mContinueAction);
    private JButton mCancelButton = new JButton((Action)this.createCancelAction());
    private JButton mHelpButton = new JButton((Action)this.createHelpAction());
    private static final int TEXT_COLUMNS = 30;
    private static final String TEXT_PATTERN = "MMMMMMMMMMMMMMMMMMMMMMMMMMMMM";

    public ExtensionBundleMessageDlg(JFrame jFrame, String string, String string2, String string3, Vector<String> vector, boolean bl, String string4) {
        super(jFrame, string, true, BuilderResBundle.getBundle((String)BuilderResBundle.getDefaultResourceBundleName(), (Locale)BuilderUtil.getInstance().getAppLocale()), BuilderResBundle.getImageFolder());
        this.mTopMsg = string2 == null ? "" : string2;
        this.mBottomMsg = string3 == null ? "" : string3;
        this.mListItems = vector;
        this.mShowOkButton = bl;
        this.mHelpID = string4;
        this.mOkAction = new OkAction();
        this.mOkButton = new JButton(this.mOkAction);
        this.mContinueAction = new ContinueAction();
        this.mContinueButton = new JButton(this.mContinueAction);
        this.mCancelButton = new JButton((Action)this.createCancelAction());
        this.mHelpButton = new JButton((Action)this.createHelpAction());
        this.initialized = true;
        this.init();
        this.setLocationRelativeTo(jFrame);
    }

    protected void init() {
        if (!this.initialized) {
            return;
        }
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setUpUI(jPanel);
        this.pack();
        this.setTabPolicy();
    }

    private void initVars() {
        this.mTopInfoTextArea = new JTextArea(this.mTopMsg);
        this.mTopInfoTextArea.setColumns(30);
        this.mBottomInfoTextArea = new JTextArea(this.mBottomMsg);
        this.mBottomInfoTextArea.setColumns(30);
        this.mList = new JList(new DefaultListModel());
        this.mList.setPrototypeCellValue(TEXT_PATTERN);
        Border border = BorderFactory.createLineBorder(Color.BLACK);
        this.mList.setBorder(border);
        this.mListScrollPane = new JScrollPane(this.mList);
        this.mListScrollPane.getVerticalScrollBar().setEnabled(true);
        if (this.mListItems != null) {
            DefaultListModel defaultListModel = (DefaultListModel)this.mList.getModel();
            for (String string : this.mListItems) {
                defaultListModel.addElement(string);
            }
        }
    }

    private void setUpUI(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        int n = DialogUtil.getGroupBoxInnerMargin();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTopInfoTextArea, gridBagConstraints, 0, 0, 1, 1, n2, new Insets(n, n, n, n));
        if (this.mListItems != null) {
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            DialogUtil.addUsingGBL(jPanel, this.mList, gridBagConstraints, 0, 1, 1, 1, n2, new Insets(0, n, n, n));
        }
        if (!this.mBottomMsg.equals("")) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mBottomInfoTextArea, gridBagConstraints, 0, 2, 1, 1, n2, new Insets(0, n, n, n));
        }
    }

    public void dispose() {
        super.dispose();
    }

    private void setTabPolicy() {
        Vector<JButton> vector = new Vector<JButton>();
        if (this.mShowOkButton) {
            vector.add(this.mOkButton);
            vector.add(this.mHelpButton);
        } else {
            vector.add(this.mContinueButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpButton);
        }
    }

    public boolean wasContinuePressed() {
        return this.continuePressed;
    }

    public String getDialogHelpID() {
        return this.mHelpID;
    }

    public void doHelp() {
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
        } else {
            BuilderUtil.getInstance().showHelp("spss/base/" + this.getDialogHelpID());
        }
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mHelpButton.putClientProperty("JButton.buttonType", "help");
        if (OSInfo.getOSType() == OSInfo.OSType.MAC && OSInfo.isMacOSXLeopardOrLater()) {
            this.mHelpButton.setText("");
        }
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                if (this.mShowOkButton) {
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.weightx = 0.0;
                    DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                } else {
                    DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.weightx = 0.0;
                    DialogUtil.addUsingGBL(jPanel, this.mContinueButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
                }
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                if (this.mShowOkButton) {
                    jPanel.add(this.mOkButton);
                } else {
                    jPanel.add(this.mContinueButton);
                    jPanel.add(this.mCancelButton);
                }
                jPanel.add(this.mHelpButton);
            }
        }
        if (this.mShowOkButton) {
            this.getRootPane().setDefaultButton(this.mOkButton);
        } else {
            this.getRootPane().setDefaultButton(this.mContinueButton);
        }
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExtensionBundleMessageDlg.this.continuePressed = true;
            ExtensionBundleMessageDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExtensionBundleMessageDlg.this.dispose();
        }
    }
}

