/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.Util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ExtensionBundleManifestHelper {
    private File mExtensionZipFile;
    Attributes mAttributes;
    ResourceBundle mResBundle;
    private boolean bPythonPluginInstalled = false;
    private boolean bRPluginInstalled = false;
    private static final String UNDER_SCORE = "_";
    private static final String EMPTY_STRING = "";
    private Set<String> mDialogSpecsSet = new HashSet<String>();
    private Set<String> mCommandSpecsSet = new HashSet<String>();
    private Set<String> mCodeFilesSet = new HashSet<String>();
    private Set<String> mMiscFilesSet = new HashSet<String>();
    private Set<String> mRLocationSet = new HashSet<String>();
    private Set<String> mPythonModulesSet = new HashSet<String>();
    private String mMaximumProductVersion;
    private String mPythonVersion;
    private Set<String> mPlatformSet = new HashSet<String>();
    private Set<String> mRequiredExtensionBundleSet = new HashSet<String>();
    public static final String NAME_KEY = "Name";
    public static final String DIALOG_SPECS_KEY = "Dialog-Specs";
    public static final String COMMAND_SPECS_KEY = "Command-Specs";
    public static final String CODE_FILES_KEY = "Code-Files";
    public static final String MISC_FILES_KEY = "Misc-Files";
    public static final String SUMMARY_KEY = "Summary";
    public static final String DESCRIPTION_KEY = "Description";
    public static final String AUTHOR_KEY = "Author";
    public static final String VERSION_KEY = "Version";
    public static final String PRODUCT_VERSION_KEY = "Product-Version";
    public static final String DATE_KEY = "Date";
    public static final String LINKS_KEY = "Links";
    public static final String CATEGORIES_KEY = "Categories";
    public static final String PLUGINS_KEY = "Plugins";
    public static final String R_PACKAGES_KEY = "R-Packages";
    public static final String PYTHON_MODULES_KEY = "Python-Modules";
    public static final String TRANSLATION_CATALOGUES_KEY = "Translation-Catalogues";
    public static final String MAXIMUM_PRODUCT_VERSION_KEY = "Product-Version-Maximum ";
    public static final String REQUIRED_EXTENSIONS_KEY = "Extension-Bundles  ";
    public static final String PYTHON_VERSION_KEY = "Python-Version ";
    public static final String PLATFORMS_KEY = "Platforms ";

    public ExtensionBundleManifestHelper() throws IOException {
        this(null);
    }

    public ExtensionBundleManifestHelper(File file) throws IOException {
        if (file != null) {
            this.mExtensionZipFile = file;
            this.init();
            try {
                JarFile jarFile = new JarFile(this.mExtensionZipFile);
                Manifest manifest = jarFile.getManifest();
                this.mAttributes = manifest.getMainAttributes();
                this.initPluginsInstalledState();
                this.fillDialogSpecsSet();
                this.fillCommandSpecsSet();
                this.fillCodeFilesSet();
                this.fillMiscFilesSet();
                this.fillRLocactionSet();
                this.fillPythonModulesSet();
                this.fillPlatformSet();
                this.fillRequiredExtensionBundleSet();
                jarFile.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw iOException;
            }
        }
    }

    private void init() {
        this.bPythonPluginInstalled = false;
        this.bRPluginInstalled = false;
        this.mDialogSpecsSet.clear();
        this.mCommandSpecsSet.clear();
        this.mCodeFilesSet.clear();
        this.mMiscFilesSet.clear();
        this.mRLocationSet.clear();
        this.mPythonModulesSet.clear();
        this.mPlatformSet.clear();
        this.mRequiredExtensionBundleSet.clear();
    }

    public void initPluginsInstalledState() {
        String string = this.getPlugins();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("Python")) {
                    this.bPythonPluginInstalled = true;
                    continue;
                }
                if (!string2.equals("R")) continue;
                this.bRPluginInstalled = true;
            }
        }
    }

    public boolean fillDialogSpecsSet() {
        return this.fillSet(this.mDialogSpecsSet, DIALOG_SPECS_KEY);
    }

    public boolean fillCommandSpecsSet() {
        return this.fillSet(this.mCommandSpecsSet, COMMAND_SPECS_KEY);
    }

    public boolean fillCodeFilesSet() {
        return this.fillSet(this.mCodeFilesSet, CODE_FILES_KEY);
    }

    public boolean fillMiscFilesSet() {
        return this.fillSet(this.mMiscFilesSet, MISC_FILES_KEY);
    }

    public boolean fillRLocactionSet() {
        return this.fillSet(this.mRLocationSet, R_PACKAGES_KEY);
    }

    public boolean fillPythonModulesSet() {
        return this.fillSet(this.mPythonModulesSet, PYTHON_MODULES_KEY);
    }

    public boolean fillPlatformSet() {
        return this.fillSet(this.mPlatformSet, PLATFORMS_KEY);
    }

    public boolean fillRequiredExtensionBundleSet() {
        return this.fillSet(this.mRequiredExtensionBundleSet, REQUIRED_EXTENSIONS_KEY);
    }

    private boolean fillSet(Set<String> set, String string) {
        String string2;
        boolean bl = false;
        try {
            string2 = this.mAttributes.getValue(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return bl;
        }
        if (string2 != null && !string2.equals(EMPTY_STRING)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                set.add(string3);
            }
            bl = true;
        }
        return bl;
    }

    public Attributes getAttributes() {
        return this.mAttributes;
    }

    public String getBundleName() {
        return this.mAttributes.getValue(NAME_KEY);
    }

    public String getSummary() {
        String string = this.getTranslatedInfoFromProperties(SUMMARY_KEY);
        if (string == null) {
            string = this.mAttributes.getValue(SUMMARY_KEY);
        }
        return string;
    }

    public String getDescription() {
        String string = this.getTranslatedInfoFromProperties(DESCRIPTION_KEY);
        if (string == null) {
            string = this.mAttributes.getValue(DESCRIPTION_KEY);
        }
        return string;
    }

    public String getAuthor() {
        return this.mAttributes.getValue(AUTHOR_KEY);
    }

    public String getVersion() {
        return this.mAttributes.getValue(VERSION_KEY);
    }

    public String getProductVersion() {
        return this.mAttributes.getValue(PRODUCT_VERSION_KEY);
    }

    public String getTargetFilePath() {
        return this.mExtensionZipFile.getAbsolutePath();
    }

    public String getDate() {
        return this.mAttributes.getValue(DATE_KEY);
    }

    public String getLinks() {
        return this.mAttributes.getValue(LINKS_KEY);
    }

    public String getCategories() {
        return this.mAttributes.getValue(CATEGORIES_KEY);
    }

    public String getPlugins() {
        return this.mAttributes.getValue(PLUGINS_KEY);
    }

    public String getTranslationCataloguesPath() {
        return this.mAttributes.getValue(TRANSLATION_CATALOGUES_KEY);
    }

    public boolean isPythonPluginInstalled() {
        return this.bPythonPluginInstalled;
    }

    public boolean isRPluginInstalled() {
        return this.bRPluginInstalled;
    }

    public Set<String> getDialogSpecsSet() {
        return this.mDialogSpecsSet;
    }

    public Set<String> getCommandSpecsSet() {
        return this.mCommandSpecsSet;
    }

    public Set<String> getCodeFilesSet() {
        return this.mCodeFilesSet;
    }

    public Set<String> getMiscFilesSet() {
        return this.mMiscFilesSet;
    }

    public Set<String> getRLocationSet() {
        return this.mRLocationSet;
    }

    public Set<String> getPythonModulesSet() {
        return this.mPythonModulesSet;
    }

    public String getEnglishSummary() {
        return this.mAttributes.getValue(SUMMARY_KEY);
    }

    public String getEnglishDescription() {
        return this.mAttributes.getValue(DESCRIPTION_KEY);
    }

    public String getMaximumProductVersion() {
        String string = EMPTY_STRING;
        try {
            string = this.mAttributes.getValue(MAXIMUM_PRODUCT_VERSION_KEY);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return string;
    }

    public String getPythonVersion() {
        String string = EMPTY_STRING;
        try {
            string = this.mAttributes.getValue(PYTHON_VERSION_KEY);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return string;
    }

    public Set<String> getPlatformSet() {
        return this.mPlatformSet;
    }

    public Set<String> getRequiredExtensionBundleSet() {
        return this.mRequiredExtensionBundleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTranslatedInfoFromProperties(String string) {
        String string2 = null;
        String string3 = Locale.getDefault().toString();
        String string4 = this.getBundleName().replace(' ', '_');
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.mExtensionZipFile));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string5 = zipEntry.getName();
                if (string5.contains(string3) && string5.contains(string4) && string5.contains(".properties")) {
                    PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(zipInputStream);
                    string2 = propertyResourceBundle.getString(string);
                    propertyResourceBundle.clearCache();
                    break;
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (IOException iOException) {
            string2 = null;
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string2;
    }
}

