/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.Util;

import com.pasw.framework.common.PaswException;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.CustomDlgInstaller;
import com.spss.shared.custom_gui.ui_builder.Util.ExtensionBundleHelper;
import com.spss.shared.custom_gui.ui_builder.Util.ExtensionBundleManifestHelper;
import com.spss.shared.custom_gui.ui_builder.Util.ExtensionBundleMessageDlg;
import com.spss.shared.custom_gui.ui_builder.extension.SPEManifestHelper;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.ui_builder.SpecificationBuilder;
import com.spss.uitools.ui_builder.SpecificationWriter;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.CommandLocation;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.util.IniHandler;
import com.spss.uitools.util.PASWFileUtil;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ExtensionBundleInstaller {
    static final String EXTENSION_BUNDLE_BAD_VERSION_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_BAD_VERSION_MSG";
    static final String EXTENSION_BUNDLE_BAD_VERSION_MSG_2 = "IDS_INSTALL_EXTENSION_BUNDLE_BAD_VERSION_MSG_2";
    static final String EXTENSION_BUNDLE_BAD_VERSION_MSG_3 = "IDS_INSTALL_EXTENSION_BUNDLE_BAD_VERSION_MSG_3";
    static final String EXTENSION_BUNDLE_R_PLUGIN_MISSING_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_R_PLUGIN_MISSING_MSG";
    static final String EXTENSION_BUNDLE_BUNDLE_ALREADY_INSTALLED_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_BUNDLE_ALREADY_INSTALLED_MSG";
    static final String EXTENSION_BUNDLE_SUCCESS_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_SUCCESS_MSG";
    static final String EXTENSION_BUNDLE_OUT_OF_DISK_SPACE_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_OUT_OF_DISK_SPACE_MSG";
    static final String EXTENSION_BUNDLE_MSG1_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG1_TEXT";
    static final String EXTENSION_BUNDLE_MSG2_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG2_TEXT";
    static final String EXTENSION_BUNDLE_MSG3_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG3_TEXT";
    static final String EXTENSION_BUNDLE_MSG4_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG4_TEXT";
    static final String EXTENSION_BUNDLE_MSG5_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG5_TEXT";
    static final String EXTENSION_BUNDLE_MSG6_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG6_TEXT";
    static final String EXTENSION_BUNDLE_MSG7_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_MSG7_TEXT";
    static final String EXTENSION_BUNDLE_TITLE1_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_TITLE1_TEXT";
    static final String EXTENSION_BUNDLE_TITLE2_MSG = "IDS_INSTALL_EXTENSION_BUNDLE_TITLE2_TEXT";
    static final String EXTENSION_BUNDLE_R_PROGRAMMABILITY = "IDS_INSTALL_EXTENSION_BUNDLE_R_PROGRAMMABILITY";
    static final String EXTENSION_BUNDLE_PYTHON_PROGRAMMABILITY = "IDS_INSTALL_EXTENSION_BUNDLE_PYTHON_PROGRAMMABILITY";
    static final String EXTENSION_BUNDLE_SUCCESSFULL_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_SUCCESSFULL_MSG";
    static final String EXTENSION_BUNDLE_SUCCESSFULL1_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_SUCCESSFULL1_MSG";
    static final String EXTENSION_BUNDLE_VERSION_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_VERSION_MSG";
    static final String EXTENSION_BUNDLE_VERSION_MSG_2 = "IDS_CMDLINE_EXTENSION_BUNDLE_VERSION_MSG_2";
    static final String EXTENSION_BUNDLE_VERSION_MSG_3 = "IDS_CMDLINE_EXTENSION_BUNDLE_VERSION_MSG_3";
    static final String EXTENSION_BUNDLE_R_PLUGIN_REQUIRED_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_R_PLUGIN_REQUIRED_MSG";
    static final String EXTENSION_BUNDLE_NO_PERMISSIONS_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_NO_PERMISSIONS_MSG";
    static final String EXTENSION_BUNDLE_EARLIER_VERSION_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_EARLIER_VERSION_MSG";
    static final String EXTENSION_BUNDLE_ERR_READING_PACKAGE_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_ERR_READING_PACKAGE_MSG";
    static final String EXTENSION_BUNDLE_ERR_OUT_OF_DISK_SPACE_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_OUT_OF_DISK_SPACE_MSG";
    static final String EXTENSION_BUNDLE_NOT_FOUND1_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_NOT_FOUND1_MSG";
    static final String EXTENSION_BUNDLE_NOT_FOUND2_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_NOT_FOUND2_MSG";
    static final String EXTENSION_BUNDLE_NOT_FOUND3_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_NOT_FOUND3_MSG";
    static final String EXTENSION_BUNDLE_NOT_FOUND4_MSG = "IDS_CMDLINE_EXTENSION_BUNDLE_NOT_FOUND4_MSG";
    static final String PYTHON_JAR_FILE_NAME = "pythoncfg.jar";
    JFrame mFrame;
    private File mSpeFile;
    private File mSpeRepositoryFile;
    private File mRPath;
    private File mPythonPath;
    private File mNameDirectory;
    private String mBundleName;
    private boolean bRInstalled = false;
    private boolean bPythonInstalled = false;
    private boolean bInstallCustomDialogs = true;
    private boolean bDownloadRPackages = true;
    private SPEManifestHelper mManifestHelper;
    private Set<String> mCommandFilesPath;
    private boolean bCommandFiles = false;
    private boolean bUseExVerPath = false;
    static final String DW_TERMS_OF_USE_FOLDER = "dWTermsOfUse";
    static final String DW_TERMS_OF_USE_FILE = "dWTermsOfUse.html";
    static final String DW_TERMS_OF_USE_ENTRY = "dWTermsOfUse/dWTermsOfUse.html";
    static final String TEMPLATE_SUFFIX = ".viztemplate";
    static final String LICENSE_FILE = "LICENSE";
    private String mInstalledDlgMenuString;
    private String mSuccessMsg;
    private String mErrorMsg;
    private boolean mShowMsgDlgs;
    private boolean mBothHaveSpdAndCfe;
    private String mInstalledExtensionFilesPath;
    private String mInstalledCDBFilesPath;
    private static final String m_externalRPref = "/com/ibm/SPSS/externalr/";

    public ExtensionBundleInstaller(JFrame jFrame) {
        this(jFrame, true, true, true);
    }

    public ExtensionBundleInstaller(JFrame jFrame, boolean bl, boolean bl2, boolean bl3) {
        this.init();
        this.mFrame = jFrame;
        this.bInstallCustomDialogs = bl;
        this.bDownloadRPackages = bl2;
        this.mShowMsgDlgs = bl3;
        this.mBothHaveSpdAndCfe = false;
    }

    private void init() {
        this.mSpeFile = null;
        this.mSpeRepositoryFile = null;
        this.mRPath = null;
        this.mPythonPath = null;
        this.mNameDirectory = null;
        this.mBundleName = null;
        this.bRInstalled = false;
        this.bPythonInstalled = false;
        this.mCommandFilesPath = new HashSet<String>();
        this.bCommandFiles = false;
        this.mInstalledCDBFilesPath = "";
        this.mInstalledExtensionFilesPath = "";
    }

    public String getInstalledExtensionFilesPath() {
        return this.mInstalledExtensionFilesPath;
    }

    public String getInstalledCDBFilesPath() {
        return this.mInstalledCDBFilesPath;
    }

    private void setInstalledExtensionFilesPath(String string) {
        this.mInstalledExtensionFilesPath = string;
    }

    private void setInstalledCDBFilesPath(String string) {
        this.mInstalledCDBFilesPath = string;
    }

    public String getSuccessMsg() {
        return this.mSuccessMsg;
    }

    public String getErrorMsg() {
        return this.mErrorMsg;
    }

    public void setSuccessMsg(String string) {
        this.mSuccessMsg = "\n" + string;
    }

    public void setErrprMsg(String string) {
        this.mErrorMsg = string;
    }

    public boolean doInstall(File file) {
        this.init();
        boolean bl = false;
        this.mSpeFile = file;
        bl = this.processSpeFile();
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS && bl) {
            for (String string : this.mCommandFilesPath) {
                BuilderUtil.getInstance().executeSyntax("EXTENSION /SPECIFICATION COMMAND='" + string + "'.");
            }
        }
        return bl;
    }

    private boolean processSpeFile() {
        this.mInstalledDlgMenuString = "";
        if (this.readManifest() && this.checkForCorrectVersion() && this.checkForRPackages() && this.checkIfPlugInsAreRequired() && this.createNameDirectoryUnderExtensionsDirectory() && this.writeCodeFilesToDirectory() && this.writeCommandFilesToDirectories() && this.writeSpeFileToNameDirectory() && this.writerLicenseFileToNameDirectory() && this.writeMiscFilesToDirectory()) {
            if (this.unzipSpdFileToDirectory()) {
                if (this.unzipTranslationCataloguesDirectory() && this.downloadRPackagesIfNeededFromInternet() && this.installVizTemplate()) {
                    String string = BuilderResUtil.getString(EXTENSION_BUNDLE_SUCCESSFULL_MSG);
                    string = MessageFormat.format(string, this.mBundleName);
                    if (this.mFrame == null) {
                        System.out.println(string);
                    }
                    if (this.mInstalledDlgMenuString.length() > 0) {
                        String string2 = MessageFormat.format(BuilderResUtil.getString("IDS_INSTALL_CUSTOM_DIALOG_FOR_EXTENSION_SUCCESSFULLY"), this.mManifestHelper.getBundleName(), this.mInstalledDlgMenuString);
                        string = string + "\n";
                        string = string + string2;
                    }
                    if (this.mFrame != null && this.mShowMsgDlgs) {
                        JOptionPane.showConfirmDialog(this.mFrame, string, BuilderUtil.getInstance().getAppNameString(), -1, 1);
                    }
                    if (this.mBothHaveSpdAndCfe) {
                        string = string + "\n";
                        string = string + BuilderResUtil.getString("IDS_INSTALL_EXTENSION_BUNDLE_SPD_NOT_INSTALLED_MSG");
                    }
                    this.setSuccessMsg(string);
                    return true;
                }
            } else {
                BuilderUtil.getInstance().deleteFolder(this.mNameDirectory);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writerLicenseFileToNameDirectory() {
        boolean bl = true;
        ZipInputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.mSpeFile));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string = zipEntry.getName();
                if (string.equals(LICENSE_FILE)) {
                    int n;
                    String string2 = this.mNameDirectory + File.separator + LICENSE_FILE;
                    fileOutputStream = new FileOutputStream(string2);
                    byte[] byArray = new byte[1024];
                    while ((n = zipInputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception exception) {
            boolean bl2 = bl = false;
            return bl2;
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private boolean checkForInstalledExtensionVersion(String string) {
        int[] nArray = new int[]{0, 0, 0};
        StringTokenizer stringTokenizer = new StringTokenizer(this.mManifestHelper.getVersion(), ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        int[] nArray2 = new int[]{0, 0, 0};
        stringTokenizer = new StringTokenizer(string, ".");
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray2[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        for (n = 0; n < 3; ++n) {
            if (nArray[n] == nArray2[n]) continue;
            return nArray[n] > nArray2[n];
        }
        return true;
    }

    private boolean checkForCorrectVersion() {
        Object object;
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        StringTokenizer stringTokenizer = new StringTokenizer(BuilderUtil.getInstance().getAppVersionString(), ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(this.mManifestHelper.getProductVersion(), ".");
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray2[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        boolean bl = this.checkMajorMinorPatchVersionsWithMinor(nArray, nArray2);
        if (bl) {
            object = new int[]{0, 0, 0, 0};
            String string = this.mManifestHelper.getMaxStatsVersion();
            if (string != null && string.length() > 0) {
                stringTokenizer = new StringTokenizer(this.mManifestHelper.getMaxStatsVersion(), ".");
                n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    object[n++] = Integer.parseInt(stringTokenizer.nextToken());
                }
                bl = this.checkMajorMinorPatchVersionsWithMax(nArray, (int[])object);
            }
        }
        if (!bl) {
            if (this.mFrame != null) {
                object = BuilderUtil.getInstance().getAppType() == AppType.MODELER ? MessageFormat.format(BuilderResUtil.getString("IDS_INSTALL_EXTENSION_BUNDLE_BAD_VERSION_MODELER_MSG"), this.mManifestHelper.getProductVersion()) : (this.mManifestHelper.getMaxStatsVersion() == null || this.mManifestHelper.getMaxStatsVersion() == "" ? MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_BAD_VERSION_MSG), this.mManifestHelper.getProductVersion()) : (!this.mManifestHelper.getMaxStatsVersion().equals(this.mManifestHelper.getProductVersion()) ? MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_BAD_VERSION_MSG_2), this.mManifestHelper.getProductVersion(), this.mManifestHelper.getMaxStatsVersion()) : MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_BAD_VERSION_MSG_3), this.mManifestHelper.getProductVersion())));
                JOptionPane.showConfirmDialog(this.mFrame, object, BuilderUtil.getInstance().getAppNameString(), -1, 1);
            } else if (this.mManifestHelper.getMaxStatsVersion() == null || this.mManifestHelper.getMaxStatsVersion() == "") {
                System.out.println(MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_VERSION_MSG), this.mBundleName, this.mManifestHelper.getProductVersion()));
            } else if (!this.mManifestHelper.getMaxStatsVersion().equals(this.mManifestHelper.getProductVersion())) {
                System.out.println(MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_VERSION_MSG_2), this.mBundleName, this.mManifestHelper.getProductVersion(), this.mManifestHelper.getMaxStatsVersion()));
            } else {
                System.out.println(MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_VERSION_MSG_3), this.mBundleName, this.mManifestHelper.getProductVersion()));
            }
        }
        if (bl) {
            object = this.mManifestHelper.getPythonVersion();
            this.bUseExVerPath = object != null && ((String)object).compareTo("3") == 0;
        }
        return bl;
    }

    private boolean checkMajorMinorPatchVersionsWithMinor(int[] nArray, int[] nArray2) {
        boolean bl = true;
        if (nArray[0] < nArray2[0]) {
            bl = false;
        } else if (nArray[0] == nArray2[0]) {
            if (nArray[1] < nArray2[1]) {
                bl = false;
            } else if (nArray[1] == nArray2[1]) {
                if (nArray[2] < nArray2[2]) {
                    bl = false;
                } else if (nArray[2] == nArray2[2] && nArray[3] < nArray2[3]) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean checkMajorMinorPatchVersionsWithMax(int[] nArray, int[] nArray2) {
        boolean bl = true;
        if (nArray[0] > nArray2[0]) {
            bl = false;
        } else if (nArray[0] == nArray2[0]) {
            if (nArray[1] > nArray2[1]) {
                bl = false;
            } else if (nArray[1] == nArray2[1]) {
                if (nArray[2] > nArray2[2]) {
                    bl = false;
                } else if (nArray[2] == nArray2[2] && nArray[3] > nArray2[3]) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean checkForRPackages() {
        boolean bl = true;
        if (this.mManifestHelper.getRLocationSet().size() > 0 && BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            this.setRInstallerPath();
            if (!this.bRInstalled) {
                if (this.mFrame != null) {
                    ExtensionBundleMessageDlg extensionBundleMessageDlg = new ExtensionBundleMessageDlg(this.mFrame, BuilderUtil.getInstance().getAppNameString(), BuilderResUtil.getString(EXTENSION_BUNDLE_R_PLUGIN_MISSING_MSG), "", null, true, "idh_r_plugin_missing");
                    extensionBundleMessageDlg.setVisible(true);
                } else {
                    System.out.println(MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_R_PLUGIN_REQUIRED_MSG), this.mBundleName));
                }
                bl = false;
            }
        }
        return bl;
    }

    private void setRInstallerPath() {
        String string;
        Object object;
        this.mRPath = null;
        String string2 = "";
        IniHandler iniHandler = ExtensionBundleInstaller.getSpssReaderFromSpssHomeDir("spssdxcfg.ini");
        string2 = ExtensionBundleInstaller.getProfileValue(iniHandler, "R", "HOME");
        if (string2.isEmpty()) {
            object = BuilderUtil.getInstance().getAppMajorMinorVersionString();
            string = m_externalRPref + (String)object;
            try {
                if (Preferences.userRoot().nodeExists(string)) {
                    Preferences preferences = Preferences.userRoot().node(string);
                    string2 = preferences.get("r_path", string2);
                }
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }
        if (string2.equals("")) {
            return;
        }
        object = new File(string2);
        try {
            string2 = ((File)object).getCanonicalPath();
            if (!string2.equals("")) {
                if (!string2.endsWith(File.separator + "bin" + File.separator) && !string2.endsWith(File.separator + "bin")) {
                    string2 = string2.endsWith(File.separator) ? string2 + "bin" + File.separator : string2 + File.separator + "bin" + File.separator;
                }
                if (!string2.endsWith(File.separator)) {
                    string2 = string2 + File.separator;
                }
                string = string2 + "R";
                if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                    string = string + ".exe";
                }
                this.mRPath = new File(string);
                if (this.mRPath.exists()) {
                    this.bRInstalled = true;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setPythonInstallerPath() {
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("application.home"));
        String string = stringBuffer.append(File.separator) + PYTHON_JAR_FILE_NAME;
        this.mPythonPath = new File(string);
        if (this.mPythonPath.exists()) {
            this.bPythonInstalled = true;
        }
    }

    public static IniHandler getSpssReaderFromSpssHomeDir(String string) {
        IniHandler iniHandler = null;
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("application.home"));
        stringBuffer.append(File.separatorChar).append(string);
        File file = new File(stringBuffer.toString());
        if (file.exists()) {
            iniHandler = IniHandler.loadIniFile((String)stringBuffer.toString(), (boolean)true, (String)"UTF-8");
        }
        return iniHandler;
    }

    public static String getProfileValue(IniHandler iniHandler, String string, String string2) {
        LinkedList linkedList;
        String string3 = "";
        if (iniHandler != null && (linkedList = iniHandler.getPrivateProfileString(string, string2)) != null && !linkedList.isEmpty()) {
            string3 = (String)linkedList.getFirst();
        }
        return string3;
    }

    private boolean checkIfPlugInsAreRequired() {
        if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
            return true;
        }
        boolean bl = true;
        if (this.mManifestHelper.isRPluginInstalled() || this.mManifestHelper.isPythonPluginInstalled()) {
            if (this.mManifestHelper.isRPluginInstalled() && !this.bRInstalled) {
                this.setRInstallerPath();
            }
            if (this.mManifestHelper.isPythonPluginInstalled()) {
                this.setPythonInstallerPath();
            }
            if ((this.mManifestHelper.isRPluginInstalled() && !this.bRInstalled || this.mManifestHelper.isPythonPluginInstalled() && !this.bPythonInstalled) && this.mFrame != null) {
                Vector<String> vector = new Vector<String>();
                if (this.mManifestHelper.isRPluginInstalled() && !this.bRInstalled) {
                    vector.add(BuilderResUtil.getString(EXTENSION_BUNDLE_R_PROGRAMMABILITY));
                }
                if (this.mManifestHelper.isPythonPluginInstalled() && !this.bPythonInstalled) {
                    vector.add(BuilderResUtil.getString(EXTENSION_BUNDLE_PYTHON_PROGRAMMABILITY));
                }
                ExtensionBundleMessageDlg extensionBundleMessageDlg = new ExtensionBundleMessageDlg(this.mFrame, BuilderResUtil.getString(EXTENSION_BUNDLE_TITLE1_MSG), BuilderResUtil.getString(EXTENSION_BUNDLE_MSG1_MSG), BuilderResUtil.getString(EXTENSION_BUNDLE_MSG2_MSG), vector, false, "idh_missing_plugin");
                extensionBundleMessageDlg.setVisible(true);
                if (!extensionBundleMessageDlg.wasContinuePressed()) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean createNameDirectoryUnderExtensionsDirectory() {
        boolean bl = false;
        String string = this.mBundleName.replaceAll(" ", "_");
        File file = this.createDirectoryUnderExtensionsDirectory(string);
        if (file != null) {
            this.mNameDirectory = file;
            bl = true;
        }
        return bl;
    }

    private boolean unzipTranslationCataloguesDirectory() {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.mSpeFile);
            zipInputStream = new JarInputStream(fileInputStream);
            String string = this.mManifestHelper.getTranslationCataloguesPath();
            bl = ExtensionBundleHelper.unJarTranslationCataloguesToDirectory((JarInputStream)zipInputStream, this.mNameDirectory.getAbsolutePath(), string);
            zipInputStream.close();
            if (!bl) {
                if (this.mFrame != null) {
                    ExtensionBundleMessageDlg extensionBundleMessageDlg = new ExtensionBundleMessageDlg(this.mFrame, BuilderUtil.getInstance().getAppNameString(), BuilderResUtil.getString(EXTENSION_BUNDLE_OUT_OF_DISK_SPACE_MSG), "", null, true, "idh_cust_not_writeable");
                    extensionBundleMessageDlg.setVisible(true);
                } else {
                    System.out.println(MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_ERR_OUT_OF_DISK_SPACE_MSG), this.mBundleName));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            iOException.printStackTrace();
        }
        return bl;
    }

    private File createDirectoryUnderExtensionsDirectory(String string) {
        boolean bl = true;
        File file = null;
        boolean bl2 = false;
        ArrayList<String> arrayList = BuilderUtil.getInstance().getExtensionBundlePath();
        Vector<String> vector = new Vector<String>();
        for (String string2 : arrayList) {
            vector.add(string2);
        }
        for (String string2 : vector) {
            string2 = string2.endsWith(File.separator) ? string2 + string : string2 + File.separator + string;
            file = new File(string2);
            if (file.exists() && file.isDirectory()) {
                bl2 = true;
                ExtensionBundleManifestHelper extensionBundleManifestHelper = null;
                for (File file2 : file.listFiles()) {
                    if (!file2.getName().endsWith(".spe") || !file2.getName().contains(string)) continue;
                    try {
                        extensionBundleManifestHelper = new ExtensionBundleManifestHelper(file2);
                        break;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (this.mFrame == null && extensionBundleManifestHelper != null && !this.checkForInstalledExtensionVersion(extensionBundleManifestHelper.getVersion())) {
                    System.out.println(MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_EARLIER_VERSION_MSG), this.mBundleName, extensionBundleManifestHelper.getVersion(), this.mManifestHelper.getVersion()));
                    return null;
                }
                int n = 0;
                if (this.mFrame != null) {
                    Object[] objectArray = new Object[]{BuilderResUtil.getString("IDS_YES"), BuilderResUtil.getString("IDS_NO")};
                    n = JOptionPane.showOptionDialog(this.mFrame, BuilderResUtil.getString(EXTENSION_BUNDLE_BUNDLE_ALREADY_INSTALLED_MSG), BuilderUtil.getInstance().getAppNameString(), 0, 3, null, objectArray, objectArray[0]);
                }
                if (n == 0) {
                    File file3;
                    String string3 = string2 + "_" + Calendar.getInstance().getTimeInMillis();
                    bl = BuilderUtil.getInstance().deleteFolder(file);
                    if (bl) {
                        bl = file.mkdir();
                    }
                    if (!(file3 = new File(string3)).exists()) break;
                    file3.delete();
                    break;
                }
                return null;
            }
            if (file.exists() || !(bl = file.mkdir()) || !file.exists()) continue;
            break;
        }
        if (bl) {
            this.setInstalledExtensionFilesPath(file.getParentFile().getAbsolutePath());
        }
        if (!bl) {
            if (this.mFrame != null) {
                Object object;
                if (bl2 && OSInfo.getOSType() == OSInfo.OSType.WIN) {
                    object = new ExtensionBundleMessageDlg(this.mFrame, BuilderUtil.getInstance().getAppNameString(), MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_MSG7_MSG), file.getAbsolutePath().toString()), null, null, true, "idh_ext_not_writeable");
                    object.setVisible(true);
                } else {
                    object = new ExtensionBundleMessageDlg(this.mFrame, BuilderUtil.getInstance().getAppNameString(), BuilderResUtil.getString(EXTENSION_BUNDLE_MSG3_MSG), BuilderResUtil.getString(EXTENSION_BUNDLE_MSG6_MSG), vector, true, "dfd_fd");
                    object.setVisible(true);
                }
            } else if (bl2 && OSInfo.getOSType() == OSInfo.OSType.WIN) {
                System.out.println(MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_MSG7_MSG), file.getAbsolutePath().toString()));
            } else {
                System.out.println(MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_NO_PERMISSIONS_MSG), this.mBundleName));
            }
            file = null;
        }
        return file;
    }

    private void deleteExtensionDir() {
    }

    private boolean writeCodeFilesToDirectory() {
        return this.writeFilesToExtensionsDirectory(this.mManifestHelper.getCodeFilesSet());
    }

    private boolean writeCommandFilesToDirectories() {
        this.bCommandFiles = true;
        boolean bl = this.writeFilesToExtensionsDirectory(this.mManifestHelper.getCommandSpecsSet());
        this.bCommandFiles = false;
        return bl;
    }

    private boolean writeMiscFilesToDirectory() {
        return this.writeFilesToDirectory(this.mManifestHelper.getMiscFilesSet(), this.mNameDirectory);
    }

    private boolean writeSpeFileToNameDirectory() {
        boolean bl;
        try {
            File file = PASWFileUtil.createTempFile((String)this.mSpeFile.getName(), (String)BuilderUtil.getInstance().getExtName(), (File)this.mNameDirectory);
            ExtensionBundleInstaller.copyFile(this.mSpeFile, file);
            File file2 = new File(this.mNameDirectory.getAbsolutePath() + File.separator + this.mSpeFile.getName());
            bl = file.renameTo(file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        try {
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (fileChannel2 != null) {
                fileChannel2.close();
            }
        }
    }

    private boolean writeFilesToExtensionsDirectory(Set<String> set) {
        ArrayList<String> arrayList = BuilderUtil.getInstance().getExtensionBundlePath();
        Vector<String> vector = new Vector<String>();
        for (String string : arrayList) {
            vector.add(string);
        }
        boolean bl = this.writeFilesToFirstWritableDirectory(set, vector);
        return bl;
    }

    private boolean writeFilesToDirectory(Set<String> set, File file) {
        Vector<String> vector = new Vector<String>();
        vector.add(file.getAbsolutePath());
        boolean bl = this.writeFilesToFirstWritableDirectory(set, vector);
        return bl;
    }

    private boolean unzipSpdFileToDirectory() {
        boolean bl = true;
        if (this.bInstallCustomDialogs && !this.mManifestHelper.getDialogSpecsSet().isEmpty()) {
            String string = BuilderUtil.getInstance().getTempDir().getAbsolutePath();
            Set<String> set = this.mManifestHelper.getDialogSpecsSet();
            Iterator<String> iterator = set.iterator();
            File file = null;
            Vector<File> vector = new Vector<File>();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                if (string2.endsWith(".spd")) {
                    file = new File(string + File.separator + (String)string2);
                    continue;
                }
                if (!string2.endsWith(".cfe")) continue;
                File file2 = new File(string + File.separator + (String)string2);
                vector.add(file2);
            }
            if (file != null && vector.size() > 0) {
                this.mBothHaveSpdAndCfe = true;
            }
            if (bl = this.writeSpdFileToDirectory(string)) {
                try {
                    if (vector.size() > 0) {
                        bl = this.unZipCFEfile(vector);
                    } else if (file != null) {
                        bl = this.unZipSpdFile(file);
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            if (file != null && file.exists()) {
                file.delete();
            }
            for (File file2 : vector) {
                file2.deleteOnExit();
            }
        }
        return bl;
    }

    private boolean unZipCFEfile(Vector<File> vector) {
        boolean bl = true;
        if (vector.size() == 0) {
            return bl;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
            arrayList.add(BuilderUtil.getInstance().getExtensionPath().getAbsolutePath());
        }
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            arrayList.add(SpecificationBuilder.getAppDataCustomCFEFolderPath((boolean)this.bUseExVerPath));
        }
        if (arrayList.size() > 0) {
            for (String string : arrayList) {
                File file = new File(string);
                if (!file.exists() || !file.isDirectory() || !PASWFileUtil.isWritable((File)file)) continue;
                try {
                    if (vector.size() == 1) {
                        CustomDlgInstaller customDlgInstaller = new CustomDlgInstaller(null, vector.get(0), true);
                        try {
                            BuilderUtil.getInstance().unloadExtension(BuilderFrame.getExtensionId(vector.get(0)));
                        }
                        catch (PaswException paswException) {
                            // empty catch block
                        }
                        DialogDefinition dialogDefinition = CustomDlgInstaller.readPackageFile(vector.get(0), false);
                        if (dialogDefinition != null) {
                            if (BuilderUtil.getInstance().getAppType() == AppType.STATS && !customDlgInstaller.validateSyntaxAndMenuLocation(this.mFrame, dialogDefinition, true)) {
                                return false;
                            }
                            if (!CustomDlgInstaller.deployCFSpecification(false, this.mFrame, dialogDefinition, true, this.bUseExVerPath, this.mBundleName)) break;
                            this.mInstalledDlgMenuString = BuilderUtil.getInstance().getAppType() == AppType.STATS ? dialogDefinition.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)customDlgInstaller).replaceAll("/", ">") : this.mInstalledDlgMenuString + BuilderResUtil.getString("IDS_NODE_PALETTE_" + dialogDefinition.getNodePalette().name()) + " " + BuilderResUtil.getString("IDS_NODE_PALETTE") + ">" + dialogDefinition.getDialogTitle();
                            this.setInstalledCDBFilesPath(BuilderUtil.getInstance().getExtensionPath().getAbsolutePath());
                            break;
                        }
                        return bl;
                    }
                    Vector<DialogDefinition> vector2 = new Vector<DialogDefinition>();
                    boolean bl2 = true;
                    CustomDlgInstaller customDlgInstaller = null;
                    for (int i = 0; i < vector.size() && bl2; ++i) {
                        File file2 = vector.get(i);
                        try {
                            BuilderUtil.getInstance().unloadExtension(BuilderFrame.getExtensionId(file2));
                        }
                        catch (PaswException paswException) {
                            // empty catch block
                        }
                        customDlgInstaller = new CustomDlgInstaller(null, file2, true);
                        DialogDefinition dialogDefinition = CustomDlgInstaller.readPackageFile(file2, false);
                        if (dialogDefinition == null) continue;
                        if (BuilderUtil.getInstance().getAppType() == AppType.STATS && !customDlgInstaller.validateSyntaxAndMenuLocation(this.mFrame, dialogDefinition, true)) {
                            return false;
                        }
                        vector2.add(dialogDefinition);
                    }
                    for (DialogDefinition dialogDefinition : vector2) {
                        CustomDlgInstaller.deployCFSpecification(false, this.mFrame, dialogDefinition, true, this.bUseExVerPath, this.mBundleName);
                        this.mInstalledDlgMenuString = BuilderUtil.getInstance().getAppType() == AppType.STATS ? this.mInstalledDlgMenuString + dialogDefinition.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)customDlgInstaller).replaceAll("/", ">") + "\n" : this.mInstalledDlgMenuString + BuilderResUtil.getString("IDS_NODE_PALETTE_" + dialogDefinition.getNodePalette().name()) + " " + BuilderResUtil.getString("IDS_NODE_PALETTE") + ">" + dialogDefinition.getDialogTitle() + "\n";
                        this.setInstalledCDBFilesPath(BuilderUtil.getInstance().getExtensionPath().getAbsolutePath());
                    }
                    break;
                }
                catch (Exception exception) {
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    private boolean unZipSpdFile(File file) throws Exception {
        String string;
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = BuilderUtil.getInstance().getSecondaryExtensionFolders();
        if (stringArray != null && stringArray.length > 0) {
            vector.addAll(Arrays.asList(stringArray));
        }
        if (System.getProperty("os.name", "Windows").toLowerCase().startsWith("win")) {
            string = BuilderUtil.getInstance().getAppdataCustomDialogDirectoryForAllUsers();
            if (string != null && !string.isEmpty()) {
                vector.add(string);
            }
            if ((string = BuilderUtil.getInstance().getAppdataCustomDialogDirectory()) != null && !string.isEmpty()) {
                vector.add(string);
            }
            if ((string = BuilderUtil.getInstance().getUIExtensionsFolderPath()) != null && !string.isEmpty()) {
                vector.add(string);
            }
        } else {
            string = BuilderUtil.getInstance().getUIExtensionsFolderPath();
            if (string != null && !string.isEmpty()) {
                vector.add(string);
            }
            if ((string = BuilderUtil.getInstance().getAppdataCustomDialogDirectory()) != null && !string.isEmpty()) {
                vector.add(string);
            }
        }
        if (vector.size() > 0) {
            for (String string2 : vector) {
                File file2 = new File(string2);
                if (!file2.exists() || !file2.isDirectory() || !PASWFileUtil.isWritable((File)file2)) continue;
                CustomDlgInstaller customDlgInstaller = new CustomDlgInstaller(null, file, true);
                DialogDefinition dialogDefinition = CustomDlgInstaller.readPackageFile(file, true);
                if (!customDlgInstaller.validateSyntaxAndMenuLocation(this.mFrame, dialogDefinition, false)) {
                    return false;
                }
                bl = customDlgInstaller.deploySpecification(false, this.mFrame, dialogDefinition, this.mFrame != null, this.bUseExVerPath);
                if (bl) {
                    this.mInstalledDlgMenuString = dialogDefinition.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)customDlgInstaller).replaceAll("/", ">");
                }
                this.setInstalledCDBFilesPath(SpecificationWriter.getDeploymentFolder((boolean)this.bUseExVerPath));
                return bl;
            }
        }
        if (this.mFrame != null) {
            Object object = new ExtensionBundleMessageDlg(this.mFrame, BuilderResUtil.getString(EXTENSION_BUNDLE_TITLE2_MSG), BuilderResUtil.getString(EXTENSION_BUNDLE_MSG4_MSG), "", vector, true, "idh_cust_not_writeable");
            object.setVisible(true);
        } else {
            System.out.println(MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_NO_PERMISSIONS_MSG), this.mBundleName));
        }
        return bl;
    }

    private boolean writeSpdFileToDirectory(String string) {
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        boolean bl = this.writeFilesToFirstWritableDirectory(this.mManifestHelper.getDialogSpecsSet(), vector);
        if (!bl) {
            if (this.mFrame != null) {
                ExtensionBundleMessageDlg extensionBundleMessageDlg = new ExtensionBundleMessageDlg(this.mFrame, BuilderResUtil.getString(EXTENSION_BUNDLE_TITLE2_MSG), BuilderResUtil.getString(EXTENSION_BUNDLE_MSG4_MSG), "", vector, true, "idh_cust_not_writeable");
                extensionBundleMessageDlg.setVisible(true);
            } else {
                System.out.println(MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_NO_PERMISSIONS_MSG), this.mBundleName));
            }
        }
        return bl;
    }

    private boolean writeFilesToFirstWritableDirectory(Set<String> set, Vector<String> vector) {
        boolean bl = true;
        boolean bl2 = false;
        for (String string : vector) {
            File file = new File(string);
            if (!file.exists() || !file.isDirectory() || !PASWFileUtil.isWritable((File)file)) continue;
            for (String string2 : set) {
                File file2 = this.readAndWriteBundleFile(this.mSpeFile, file, string2);
                if (file2 == null) {
                    bl = false;
                    break;
                }
                String string3 = file2.getAbsolutePath();
                if (!this.bCommandFiles) continue;
                this.mCommandFilesPath.add(string3);
            }
            bl2 = true;
            break;
        }
        if (!bl2) {
            bl = false;
        }
        return bl;
    }

    private File readAndWriteBundleFile(File file, File file2, String string) {
        File file3 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            JarInputStream jarInputStream = new JarInputStream(fileInputStream);
            file3 = this.readAndWriteFromJar(jarInputStream, file2, string);
            jarInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file3;
    }

    private File readAndWriteFromJar(JarInputStream jarInputStream, File file, String string) throws IOException {
        File file2 = null;
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string2 = jarEntry.getName();
            if (string2.equals(string)) {
                ByteBuffer byteBuffer = this.readEntry(jarInputStream);
                FileOutputStream fileOutputStream = new FileOutputStream(file.getPath() + File.separator + string2);
                fileOutputStream.write(byteBuffer.array());
                fileOutputStream.close();
                jarInputStream.closeEntry();
                file2 = new File(file.getPath() + File.separator + string2);
                break;
            }
            jarInputStream.closeEntry();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return file2;
    }

    private boolean unJarTranslationCataloguesToDirectory(JarInputStream jarInputStream, String string) throws IOException {
        boolean bl = true;
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        boolean bl2 = false;
        while (jarEntry != null) {
            Object object;
            if (jarEntry.isDirectory()) {
                String string2;
                object = jarEntry.getName().substring(0, jarEntry.getName().length() - 1);
                object = this.getOSTypeSlashifiedPath((String)object);
                if (bl2) {
                    bl = this.makeDirectoryFromFullAndRelativePaths(string, (String)object);
                    if (!bl) {
                        break;
                    }
                } else if (!((String)object).equals("META-INF") && (string2 = this.mManifestHelper.getTranslationCataloguesPath()) != null && string2.equals(object)) {
                    bl2 = true;
                    bl = this.makeDirectoryFromFullAndRelativePaths(string, (String)object);
                    if (!bl) {
                        break;
                    }
                }
            } else if (bl2) {
                String string3 = this.getOSTypeSlashifiedPath(jarEntry.getName());
                object = this.readEntry(jarInputStream);
                String string4 = string + File.separator + string3;
                FileOutputStream fileOutputStream = new FileOutputStream(string4);
                try {
                    fileOutputStream.write(((ByteBuffer)object).array());
                }
                catch (IOException iOException) {
                    fileOutputStream.close();
                    bl = false;
                    break;
                }
                fileOutputStream.close();
            }
            jarInputStream.closeEntry();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        jarInputStream.close();
        return bl;
    }

    private boolean makeDirectoryFromFullAndRelativePaths(String string, String string2) {
        String string3 = string + File.separator + string2;
        return new File(string3).mkdir();
    }

    boolean downloadRPackagesIfNeededFromInternet() {
        boolean bl = true;
        if (this.bRInstalled && this.bDownloadRPackages) {
            File file = null;
            File file2 = null;
            try {
                file = this.createTempBatchFile(this.getBatchRString());
                file2 = this.createTempRLogFile();
                Vector<String> vector = new Vector<String>();
                bl = false;
                this.makeRCommandLineList(file, file2, vector);
                if (this.mFrame != null) {
                    this.mFrame.setCursor(Cursor.getPredefinedCursor(3));
                }
                try {
                    ProcessBuilder processBuilder = new ProcessBuilder(vector);
                    Process process = processBuilder.start();
                    if (process.waitFor() == 0) {
                        bl = true;
                    } else {
                        Vector<String> vector2 = new Vector<String>();
                        this.readTempRLogFile(file2, vector2);
                        this.showErrMsgForRPackagesThatDidNotInstall(vector2);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (this.mFrame != null) {
                    this.mFrame.setCursor(null);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (file != null) {
                file.delete();
            }
            if (file2 != null) {
                file2.delete();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean installVizTemplate() {
        boolean bl = true;
        ZipInputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.mSpeFile));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string = zipEntry.getName();
                if (string.endsWith(TEMPLATE_SUFFIX)) {
                    int n;
                    String string2 = this.getVizTemplateDir().getAbsolutePath();
                    String string3 = string2 + File.separator + "templates" + File.separator + string;
                    fileOutputStream = new FileOutputStream(string3);
                    byte[] byArray = new byte[1024];
                    while ((n = zipInputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception exception) {
            boolean bl2 = bl = false;
            return bl2;
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private void showErrMsgForRPackagesThatDidNotInstall(Vector<String> vector) {
        if (this.mFrame == null && !this.bDownloadRPackages) {
            String string = MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_NOT_FOUND1_MSG), this.mBundleName) + vector.toString() + BuilderResUtil.getString(EXTENSION_BUNDLE_NOT_FOUND2_MSG);
            System.out.println(string);
        } else if (this.mFrame != null) {
            ExtensionBundleMessageDlg extensionBundleMessageDlg = new ExtensionBundleMessageDlg(this.mFrame, BuilderUtil.getInstance().getAppNameString(), BuilderResUtil.getString(EXTENSION_BUNDLE_MSG5_MSG), BuilderResUtil.getString(EXTENSION_BUNDLE_MSG6_MSG), vector, true, "idh_r_install_fail");
            extensionBundleMessageDlg.setVisible(true);
        } else {
            String string = MessageFormat.format(BuilderResUtil.getString(EXTENSION_BUNDLE_NOT_FOUND3_MSG), this.mBundleName) + vector.toString() + BuilderResUtil.getString(EXTENSION_BUNDLE_NOT_FOUND4_MSG);
            System.out.println(string);
        }
    }

    private void makeRCommandLineList(File file, File file2, Vector<String> vector) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--vanilla --slave --args");
        for (String string : this.mManifestHelper.getRLocationSet()) {
            stringBuilder.append(' ').append(string);
        }
        stringBuilder.append(" '").append(file2.getAbsolutePath()).append("'");
        vector.add(this.mRPath.getAbsolutePath());
        vector.add("CMD");
        vector.add("BATCH");
        vector.add(stringBuilder.toString());
        vector.add(file.getAbsolutePath());
    }

    private String getBatchRString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String string = BuilderUtil.getInstance().getAppMajorMinorVersionString();
        String string2 = m_externalRPref + string;
        String string3 = "";
        try {
            if (Preferences.userRoot().nodeExists(string2)) {
                object = Preferences.userRoot().node(string2);
                string3 = ((Preferences)object).get("lib_path", string3);
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        if (string3.isEmpty()) {
            bl = true;
        }
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separator;
        }
        File file = this.mFrame == null && !this.bDownloadRPackages ? (bl ? new File(System.getProperty("application.home") + File.separator + "checkpkgs.R") : new File(string3 + "checkpkgs.R")) : (bl ? new File(System.getProperty("application.home") + File.separator + "getpkgs.R") : new File(string3 + "getpkgs.R"));
        try {
            String string4;
            object = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            while ((string4 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string4).append('\n');
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private File createTempBatchFile(String string) throws IOException {
        String string2 = BuilderUtil.getInstance().getTempDir().getAbsolutePath();
        File file = PASWFileUtil.createTempFile((String)"spss", (String)".R", (File)new File(string2));
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file, false);
        fileOutputStream.write(string.getBytes("UTF-8"));
        fileOutputStream.close();
        return file;
    }

    private File createTempRLogFile() throws IOException {
        String string = BuilderUtil.getInstance().getTempDir().getAbsolutePath();
        File file = PASWFileUtil.createTempFile((String)"spssRLog", (String)".txt", (File)new File(string));
        file.deleteOnExit();
        return file;
    }

    private void readTempRLogFile(File file, Vector<String> vector) throws IOException {
        if (file.exists()) {
            String string;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                vector.add(string);
            }
            bufferedReader.close();
        }
    }

    private String getOSTypeSlashifiedPath(String string) {
        string = OSInfo.getOSType() == OSInfo.OSType.WIN ? string.replace('/', File.separatorChar) : string.replace('\\', File.separatorChar);
        return string;
    }

    private boolean readManifest() {
        boolean bl = true;
        try {
            String string;
            this.mManifestHelper = new SPEManifestHelper(this.mSpeFile);
            this.mBundleName = this.mManifestHelper.getBundleName();
            boolean bl2 = bl = this.mBundleName != null && this.mBundleName.length() > 0;
            if (bl) {
                string = this.mManifestHelper.getSummary();
                boolean bl3 = bl = string != null && string.length() > 0;
            }
            if (!bl) {
                string = BuilderResUtil.getString("IDS_INSTALL_EXTENSION_BUNDLE_NO_NAME_SUMMARY_MSG");
                if (this.mFrame != null) {
                    ExtensionBundleMessageDlg extensionBundleMessageDlg = new ExtensionBundleMessageDlg(this.mFrame, BuilderUtil.getInstance().getAppNameString(), null, string, null, true, "idh_r_install_fail");
                    extensionBundleMessageDlg.setVisible(true);
                } else {
                    System.out.println(string);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private ByteBuffer readEntry(JarInputStream jarInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[50000];
        try {
            int n = jarInputStream.read(byArray, 0, 50000);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = jarInputStream.read(byArray, 0, 50000);
            }
        }
        catch (IOException iOException) {
            byteArrayOutputStream.reset();
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    private File getVizTemplateDir() {
        String string = System.getProperty("user.home");
        if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
            return new File(string, "Application Data/SPSSInc/Graphboard");
        }
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            return new File(string, "Library/Application Support/SPSSInc/Graphboard");
        }
        return new File(string, ".Graphboard");
    }
}

