/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.Util;

import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SpssButtonGroup;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.ToggleButtonAction;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.controls.TextCompUndoManager;
import com.spss.uitools.controls.TextCompUndoManagerHolder;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class DialogUtil
extends UIToolDialogUtil {
    private static final Insets BUTTON_INSETS = new Insets(1, 2, 1, 2);
    private static final Insets CONTROL_INSETS = new Insets(1, 2, 1, 2);
    private static final Insets ARROW_BUTTON_INSETS = new Insets(10, 10, 10, 10);
    private static final int GROUP_BOX_INNER_MARGIN = 6;
    private static final int VAR_LIST_MIN_WIDTH = 150;
    private static final int VAR_SRC_LIST_PREF_HEIGHT = 160;
    private static final int MAIN_BUTTON_GAP = 8;
    private static final int COMPONENT_GROUP_GAP = 8;
    private static final Dimension ARROW_BUTTON_SIZE = new Dimension(32, 30);
    private static final int FUNCTION_GROUP_LIST_HEIGHT = 90;
    private static final int FUNCTION_GROUP_LIST_WIDTH = 150;
    private static final Color FOCUS_BORDER_COLOR = new Color(153, 205, 230);
    private static final int LINE_BREAK = 50;
    private static final int SUB_CHECKBOX_GROUP_INDENT = 20;

    public static void addUsingGBL(Container container, JComponent jComponent, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, Insets insets) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.insets = insets == null ? new Insets(0, 0, 0, 0) : insets;
        container.add((Component)jComponent, gridBagConstraints);
    }

    public static void addUsingGBLOnSpssTab(Container container, JComponent jComponent, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, Insets insets) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.insets = insets == null ? new Insets(0, 0, 0, 0) : insets;
        jComponent.setOpaque(false);
        container.add((Component)jComponent, gridBagConstraints);
    }

    public static void normalizeLabelWidths(JPanel jPanel) {
        int n = 0;
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        for (Component component : jPanel.getComponents()) {
            if (!(component instanceof JLabel)) continue;
            JLabel jLabel = (JLabel)component;
            FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
            if (jLabel.getText() == null) continue;
            int n2 = fontMetrics.stringWidth(jLabel.getText());
            n = n > n2 ? n : n2;
            arrayList.add(jLabel);
        }
        for (JLabel jLabel : arrayList) {
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width = n;
            jLabel.setMaximumSize(dimension);
            jLabel.setMinimumSize(dimension);
        }
    }

    public static Image makeColorTransparent(Image image, final Color color) {
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int n, int n2, int n3) {
                if ((n3 | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & n3;
                }
                return n3;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), rGBImageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public static Insets getStandardButtonInsets() {
        return BUTTON_INSETS;
    }

    public static Insets getStandardControlInsets() {
        return CONTROL_INSETS;
    }

    public static Insets getArrowButtonInsets() {
        return ARROW_BUTTON_INSETS;
    }

    public static int getVarListWidth() {
        return 150;
    }

    public static int getVarListHeight() {
        return 160;
    }

    public static int getMainButtonGap() {
        return 8;
    }

    public static Dimension getArrowButtonSize() {
        return ARROW_BUTTON_SIZE;
    }

    public static int getComponentGroupGap() {
        return 8;
    }

    public static int getSubCheckboxGroupIndent() {
        return 20;
    }

    public static int getGroupBoxInnerMargin() {
        return 6;
    }

    public static void applyTopBorder(JPanel jPanel) {
        jPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
    }

    public static void setupVerticalFill(GridBagConstraints gridBagConstraints, double d, double d2) {
        DialogUtil.setupFill(gridBagConstraints, 3, d, d2);
    }

    public static void setupHorizontalFill(GridBagConstraints gridBagConstraints, double d, double d2) {
        DialogUtil.setupFill(gridBagConstraints, 2, d, d2);
    }

    public static void setupBothFill(GridBagConstraints gridBagConstraints, double d, double d2) {
        DialogUtil.setupFill(gridBagConstraints, 1, d, d2);
    }

    private static void setupFill(GridBagConstraints gridBagConstraints, int n, double d, double d2) {
        gridBagConstraints.fill = n;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public static void setupNoSize(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
    }

    public static JLabel createLabel(BaseDialog baseDialog, String string) {
        JLabel jLabel = new JLabel(baseDialog.getResString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            String string2 = string + "_KEY";
            Integer n = baseDialog.getDlgAccessKey(string2 = string2.replace("IDS_", "IDK_"));
            if (n != null) {
                jLabel.setDisplayedMnemonic(n);
            }
        }
        return jLabel;
    }

    public static JLabel createLabel(BaseDialog baseDialog, String string, int n) {
        JLabel jLabel = new JLabel(baseDialog.getResString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            String string2 = string + "_KEY";
            Integer n2 = baseDialog.getDlgAccessKey((string2 = string2.replace("IDS_", "IDK_")) + n);
            if (n2 != null) {
                jLabel.setDisplayedMnemonic(n2);
            }
        }
        return jLabel;
    }

    public static JLabel createLabel(String string) {
        Integer n;
        JLabel jLabel = new JLabel(BuilderResUtil.getString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = BuilderResUtil.getAccessKey(string = string.replace("IDS_", "IDK_"))) != null) {
            jLabel.setDisplayedMnemonic(n);
        }
        return jLabel;
    }

    public static JButton createButton(BaseDialog baseDialog, String string) {
        return DialogUtil.createButton(baseDialog, string, null);
    }

    public static JButton createButton(BaseDialog baseDialog, String string, ActionListener actionListener) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(baseDialog, string);
        JButton jButton = new JButton(toggleButtonAction);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        return jButton;
    }

    public static JRadioButton createRadioButton(BaseDialog baseDialog, String string, ActionListener actionListener) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(baseDialog, string);
        JRadioButton jRadioButton = new JRadioButton(toggleButtonAction);
        jRadioButton.addActionListener(actionListener);
        return jRadioButton;
    }

    public static JCheckBox createCheckBox(BaseDialog baseDialog, String string) {
        return DialogUtil.createCheckBox(baseDialog, string, null);
    }

    public static JCheckBox createCheckBox(BaseDialog baseDialog, String string, ActionListener actionListener) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(baseDialog, string);
        JCheckBox jCheckBox = new JCheckBox(toggleButtonAction);
        if (actionListener != null) {
            jCheckBox.addActionListener(actionListener);
        }
        return jCheckBox;
    }

    public static JFormattedTextField getTextField(JSpinner jSpinner) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        return null;
    }

    public static void leftAlignSpinnerText(JSpinner jSpinner) {
        JFormattedTextField jFormattedTextField = DialogUtil.getTextField(jSpinner);
        if (jFormattedTextField != null) {
            jFormattedTextField.setHorizontalAlignment(2);
        }
    }

    public static Vector<String> getFilesWithExtension(File file, String string) {
        Vector<String> vector = new Vector<String>();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        for (File file2 : fileArray) {
            String string2;
            String string3;
            int n;
            if (!file2.isFile() || (n = (string3 = file2.getName()).lastIndexOf(".")) <= 0 || n >= string3.length() - 1 || !(string2 = string3.substring(n + 1).toLowerCase()).equals(string)) continue;
            vector.add(string3.substring(0, n));
        }
        return vector;
    }

    public static int getIndexOfItem(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static void setSelectedButton(ButtonGroup buttonGroup, int n) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (n2 == n) {
                ((JRadioButton)abstractButton).setSelected(true);
                break;
            }
            ++n2;
        }
    }

    public static void removeMouseInputListeners(JComponent jComponent) {
        MouseListener[] mouseListenerArray = jComponent.getMouseListeners();
        MouseMotionListener[] mouseMotionListenerArray = jComponent.getMouseMotionListeners();
        for (MouseListener eventListener : mouseListenerArray) {
            jComponent.removeMouseListener(eventListener);
        }
        for (EventListener eventListener : mouseMotionListenerArray) {
            jComponent.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
    }

    public static SpssButtonGroup createCmdButtonGroup(JPanel jPanel) {
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        for (Component component : jPanel.getComponents()) {
            if (!(component instanceof JButton)) continue;
            spssButtonGroup.add((AbstractButton)component);
        }
        return spssButtonGroup;
    }

    public static String formatDouble(double d, Locale locale) {
        int n;
        String string = d > 100000.0 ? String.format(locale, "%.6f", d) : String.format(locale, "%.12f", d);
        for (n = string.length(); n > 0 && string.charAt(n - 1) == '0'; --n) {
        }
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        if (n > 0 && string.charAt(n - 1) == decimalFormatSymbols.getDecimalSeparator()) {
            --n;
        }
        string = string.substring(0, n);
        return string;
    }

    public static void enableTitledBorder(JPanel jPanel, boolean bl) {
        Border border = jPanel.getBorder();
        DialogUtil.enableTitledBorder(border, bl);
    }

    public static void enableTitledBorder(Border border, boolean bl) {
        UIManager.getColor("Button.disabled");
        if (border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            if (bl) {
                titledBorder.setTitleColor(UIManager.getColor("TitledBorder.titleColor"));
            } else {
                titledBorder.setTitleColor(UIManager.getColor("Button.disabledText"));
            }
        }
    }

    public static void enableHTMLComponent(JComponent jComponent, boolean bl) {
        Color color = UIManager.getColor("textInactiveText");
        if (bl) {
            color = UIManager.getColor("textText");
        }
        jComponent.setForeground(color);
        jComponent.setEnabled(bl);
    }

    public static void enableAllComponents(JPanel jPanel, boolean bl) {
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            if (jPanel.getComponent(i) instanceof JPanel) {
                DialogUtil.enableTitledBorder((JPanel)jPanel.getComponent(i), bl);
                DialogUtil.enableAllComponents((JPanel)jPanel.getComponent(i), bl);
            } else if (jPanel.getComponent(i) instanceof JTextField) {
                ((JTextField)jPanel.getComponent(i)).setOpaque(bl);
            }
            jPanel.getComponent(i).setEnabled(bl);
        }
    }

    public static String wrapDisplayMessage(String string) {
        return DialogUtil.wrapDisplayMessage(string, 80);
    }

    public static String wrapDisplayMessage(String string, int n) {
        if (string.length() > n) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.insert(n, '\n');
            return stringBuffer.toString();
        }
        return string;
    }

    public static int readCurrentPrinterSettings() {
        return 8;
    }

    public static boolean isNumber(String string) {
        ParsePosition parsePosition;
        string = string.trim();
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(UIToolResUtil.getSPSSLocale());
        Number number = decimalFormat.parse(string, parsePosition = new ParsePosition(0));
        return number != null && parsePosition.getIndex() == string.length();
    }

    public static Double parseDouble(String string) {
        ParsePosition parsePosition;
        string = string.trim();
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(UIToolResUtil.getSPSSLocale());
        Number number = decimalFormat.parse(string, parsePosition = new ParsePosition(0));
        if (number != null && parsePosition.getIndex() == string.length()) {
            return number.doubleValue();
        }
        return null;
    }

    public static int getFunctionGroupListWidth() {
        return 150;
    }

    public static int getFunctionGroupListHeight() {
        return 90;
    }

    public static int getGroupingIndent() {
        return (int)((double)UIManager.getIcon("CheckBox.icon").getIconWidth() * 1.2);
    }

    public static void resetTextCompUndoManager(Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof TextCompUndoManagerHolder) {
                TextCompUndoManager textCompUndoManager = ((TextCompUndoManagerHolder)component).getUndoManger();
                if (textCompUndoManager == null) continue;
                textCompUndoManager.discardAllEdits();
                continue;
            }
            if (!(component instanceof Container)) continue;
            DialogUtil.resetTextCompUndoManager((Container)component);
        }
    }

    public static Color getFocusBorderColor() {
        return UIManager.getColor("border.color.focus") == null ? FOCUS_BORDER_COLOR : UIManager.getColor("border.color.focus");
    }

    public static String applyMultiLines(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.length();
        int n2 = 0;
        int n3 = 50;
        while (n3 < n) {
            char c = stringBuffer.charAt(n3);
            while (c != ' ' && n3 < stringBuffer.length()) {
                c = stringBuffer.charAt(n3);
                ++n3;
            }
            stringBuffer.insert(n3, "<br>");
            n3 = n3 + 50 + ++n2;
        }
        return "<html>" + stringBuffer.toString() + "</html>";
    }

    public static void setupMacHelpButton(JButton jButton) {
        jButton.putClientProperty("JButton.buttonType", "help");
        LookAndFeel lookAndFeel = BuilderUtil.getInstance().getLookAndFeel();
        boolean bl = lookAndFeel.getClass().getName().contains("Aqua");
        if (OSInfo.getOSType() == OSInfo.OSType.MAC && OSInfo.isMacOSXLeopardOrLater() && bl) {
            jButton.setText("");
            jButton.getAccessibleContext().setAccessibleName(BuilderResUtil.getString("IDS_HELP"));
        }
    }

    public static JPanel setupControlOnBorder(JPanel jPanel, JComponent jComponent) {
        Serializable serializable;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        String string = null;
        if (jComponent instanceof JLabel) {
            string = new String(((JLabel)jComponent).getText());
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = null;
        if (jComponent instanceof JLabel) {
            serializable = new StringBuffer("");
            for (int i = 0; i < string.length(); ++i) {
                if (i == string.length() - 1) {
                    ((StringBuffer)serializable).append(" ");
                    continue;
                }
                ((StringBuffer)serializable).append("  ");
            }
            titledBorder = new TitledBorder(((StringBuffer)serializable).toString());
            jComponent.setFont(titledBorder.getTitleFont());
            jComponent.setForeground(titledBorder.getTitleColor());
        } else {
            titledBorder = new TitledBorder(" ");
        }
        jComponent.setOpaque(true);
        jPanel.setBorder(titledBorder);
        serializable = new Insets(5, 8, 0, 0);
        n = 23;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, jComponent, gridBagConstraints, 0, 0, 1, 1, n, (Insets)serializable);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        n = 19;
        ((Insets)serializable).set(5, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, jPanel, gridBagConstraints, 0, 0, 1, 1, n, (Insets)serializable);
        return jPanel2;
    }
}

