/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.Util;

import com.pasw.framework.common.PaswException;
import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.ExtensionBundleMessageDlg;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.MissingAddOnsDlg;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.ui_builder.SpecificationBuilder;
import com.spss.uitools.ui_builder.SpecificationWriter;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.CommandLocation;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.SubDlgButtonDefinition;
import com.spss.uitools.util.PASWFileUtil;
import com.spss.uitools.util.TraceSettings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;

public class CustomDlgInstaller
implements CommandLocation.ResLoader {
    private JFrame mFrame = null;
    private File mCDBFile = null;
    private static File mExtensionFile = null;
    private boolean mShowWarnings = false;
    private static File mTempFolder = null;
    private static File mAppExtFile = null;
    private static final String XML_FILE_EXT = ".xml";
    private static final String EXT_FILE_NAME = "extension.xml";
    private static final String APP_EXT_FILE_NAME = "app-extension.xml";

    public CustomDlgInstaller(JFrame jFrame, File file, boolean bl) {
        this.mCDBFile = file;
        this.mShowWarnings = bl;
        this.mFrame = jFrame;
    }

    public CustomDlgInstaller(JFrame jFrame, File file) {
        this(jFrame, file, true);
    }

    public boolean doInstall() {
        Object object;
        if (this.mCDBFile == null || !this.mCDBFile.exists()) {
            return false;
        }
        Vector<String> vector = new Vector<String>();
        boolean bl = this.mCDBFile.getName().endsWith(BuilderFrame.getBuilderSPDExpension());
        BuilderUtil.getInstance().setCompabibleMode(bl);
        if (bl) {
            vector.add(SpecificationBuilder.getAppDataCustomCFEFolderPath());
        } else {
            vector.addAll(Arrays.asList(BuilderUtil.getInstance().getSecondaryExtensionFolders()));
            object = BuilderUtil.getInstance().getAppdataCustomDialogDirectoryForAllUsers();
            if (object != null) {
                vector.add((String)object);
            }
            if (System.getProperty("os.name", "Windows").toLowerCase().startsWith("win")) {
                vector.add(BuilderUtil.getInstance().getAppdataCustomDialogDirectory());
                vector.add(BuilderUtil.getInstance().getUIExtensionsFolderPath());
            } else {
                vector.add(BuilderUtil.getInstance().getUIExtensionsFolderPath());
                vector.add(BuilderUtil.getInstance().getAppdataCustomDialogDirectory());
            }
        }
        if (vector.size() > 0) {
            for (String string : vector) {
                File file = new File(string);
                if (!file.exists() || !file.isDirectory() || !PASWFileUtil.isWritable((File)file)) continue;
                DialogDefinition dialogDefinition = null;
                try {
                    dialogDefinition = CustomDlgInstaller.readPackageFile(this.mCDBFile, bl);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (dialogDefinition != null) {
                    if (bl) {
                        if (!this.validateSyntaxAndMenuLocation(null, dialogDefinition, false)) {
                            return false;
                        }
                        this.deploySpecification(this.mFrame, dialogDefinition, true);
                        dialogDefinition.setIsCompatMode(true);
                        dialogDefinition.setTabbed(false);
                    }
                    this.cleanupTempFolder();
                    return true;
                }
                this.cleanupTempFolder();
            }
        }
        object = new ExtensionBundleMessageDlg(this.mFrame, BuilderResUtil.getString("IDS_INSTALL_EXTENSION_BUNDLE_TITLE2_TEXT"), BuilderResUtil.getString("IDS_INSTALL_EXTENSION_BUNDLE_MSG4_TEXT"), "", vector, true, "idh_cust_not_writeable");
        object.setVisible(true);
        return false;
    }

    public boolean deploySpecification(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl) {
        return this.deploySpecification(jFrame, dialogDefinition, bl, false);
    }

    public boolean deploySpecification(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl, boolean bl2) {
        return this.deploySpecification(true, jFrame, dialogDefinition, bl, bl2);
    }

    public boolean deploySpecification(boolean bl, JFrame jFrame, DialogDefinition dialogDefinition, boolean bl2, boolean bl3) {
        this.mShowWarnings = bl2;
        if (bl2 && !MissingAddOnsDlg.checkForMissingAddOns(jFrame, dialogDefinition)) {
            return false;
        }
        try {
            String string;
            SpecificationWriter specificationWriter;
            int n;
            String string2 = SpecificationWriter.getDeploymentFolder((boolean)bl3);
            if (string2 == null) {
                if (jFrame != null) {
                    Object[] objectArray = new String[]{BuilderResUtil.getString("IDS_OK"), BuilderResUtil.getString("IDS_HELP")};
                    int n2 = BuilderAlertPane.showOptionDialog(jFrame, BuilderResUtil.getString("IDS_INSTALL_SPEC_ERROR"), BuilderUtil.getInstance().getAppNameString(), BuilderAlertPane.IconType.eWarning, objectArray, (Object)objectArray[0]);
                    if (n2 == 1) {
                        BuilderUtil.getInstance().showHelp("IDH_IDD_UIBUILDER");
                    }
                }
                return false;
            }
            String string3 = string2 + File.separator + dialogDefinition.getDialogId();
            File file = new File(string3);
            if (!file.exists()) {
                if (!file.mkdirs()) {
                    throw new Exception("Error creating deployment directory");
                }
            } else if (bl2 && (n = BuilderAlertPane.showConfirmDialog(jFrame, BuilderResUtil.getString("IDS_OVERWRITE_SPEC_QUERY"), BuilderUtil.getInstance().getAppNameString(), BuilderAlertPane.OptionType.OK_CANCEL_OPTION)) != 0) {
                return false;
            }
            if (!(specificationWriter = new SpecificationWriter(dialogDefinition)).writeClefStream(string = string3 + File.separator + dialogDefinition.getDialogId() + XML_FILE_EXT)) {
                throw new Exception(CustomDlgInstaller.makeErrorText(specificationWriter));
            }
            BuilderUtil.getInstance().updateFrames(dialogDefinition, string);
            if (bl2 && bl) {
                String string4 = dialogDefinition.getCommandLocation().getCommandPath() + ">" + dialogDefinition.getCommandLocation().getCommandTitle();
                this.showDeployedMsg(jFrame, dialogDefinition, string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (bl2) {
                BuilderAlertPane.showErrorMessageDialog(jFrame, BuilderResUtil.getString("IDS_ERROR_SAVING_DLG") + "\n\n" + exception.getMessage(), BuilderUtil.getInstance().getAppNameString());
            }
            return false;
        }
        return true;
    }

    private void showDeployedMsg(JFrame jFrame, DialogDefinition dialogDefinition, String string) {
        String string2 = dialogDefinition.getCommandLocation().getCommandActionId();
        String string3 = dialogDefinition.getCommandLocation().getCommandPath();
        String string4 = Integer.toString(dialogDefinition.getCommandLocation().getMenuItemOffset());
        boolean bl = BuilderUtil.getInstance().hasCommand(string3, string2, string4);
        if (!bl) {
            BuilderAlertPane.showInformationMessageDialog(jFrame, BuilderResUtil.getString("IDS_DIALOG_DEPLOYED"), BuilderUtil.getInstance().getAppNameString());
        } else {
            String string5 = String.format(BuilderResUtil.getString("IDS_DIALOG_INSTALLED"), string);
            BuilderAlertPane.showInformationMessageDialog(jFrame, string5, BuilderUtil.getInstance().getAppNameString());
        }
    }

    private static String makeErrorText(SpecificationWriter specificationWriter) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        Vector vector = specificationWriter.getErrors();
        for (String string : vector) {
            stringBuffer.append(n++).append(". ").append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean deployCFSpecification(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl) {
        return CustomDlgInstaller.deployCFSpecification(true, jFrame, dialogDefinition, bl, false, "");
    }

    public boolean deployCFSpecification(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl, boolean bl2) {
        return CustomDlgInstaller.deployCFSpecification(true, jFrame, dialogDefinition, bl, bl2, "");
    }

    public static boolean deployCFSpecification(boolean bl, JFrame jFrame, DialogDefinition dialogDefinition, boolean bl2, boolean bl3, String string) {
        if (dialogDefinition.getDialogId().contains(" ")) {
            BuilderAlertPane.showWarningMessageDialog(jFrame, BuilderResUtil.getString("IDS_IDS_CANT_HAVE_SPACES"), BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        DialogDefinition dialogDefinition2 = (DialogDefinition)dialogDefinition.clone();
        if (dialogDefinition2 == null) {
            return false;
        }
        if (bl2 && !MissingAddOnsDlg.checkForMissingAddOns(jFrame, dialogDefinition2)) {
            return false;
        }
        String string2 = BuilderUtil.getInstance().getExtensionPath().getAbsolutePath();
        if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
            string2 = string2 + File.separator + string;
        }
        String string3 = string2 + File.separator + dialogDefinition2.getDialogId() + ".cfe";
        File file = new File(string3);
        try {
            SpecificationWriter specificationWriter;
            if (!file.exists() && !file.createNewFile()) {
                throw new Exception("Error creating deployment file");
            }
            String string4 = BuilderUtil.getInstance().hasMenuItem(dialogDefinition2);
            if (string4 != null && string4 != "") {
                int n = BuilderAlertPane.showConfirmDialog(jFrame, BuilderResUtil.getString("IDS_SAME_MENU_ITEM_WARNING"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION);
                if (n != 1) {
                    return false;
                }
                if (!BuilderUtil.getInstance().removeDeployed(string2 + File.separator + string4 + ".cfe")) {
                    return false;
                }
            }
            if (!CustomDlgInstaller.writeCfeFile(string3, specificationWriter = new SpecificationWriter(dialogDefinition2), dialogDefinition2)) {
                throw new Exception(CustomDlgInstaller.makeErrorText(specificationWriter));
            }
            String string5 = BuilderUtil.getInstance().loadExtension(file);
            String string6 = BuilderUtil.getInstance().getUIExtensionsFolderPath() == null ? string2 : (string2.startsWith(BuilderUtil.getInstance().getUIExtensionsFolderPath()) ? "" : string2);
            BuilderUtil.getInstance().addCfeMenuToFrames(dialogDefinition2.getCommandLocation().getCommandActionId(), dialogDefinition2.getCommandLocation().getCommandPath());
            if (bl) {
                String string7 = String.format(BuilderResUtil.getString("IDS_DIALOG_INSTALLED"), string6);
                BuilderAlertPane.showInformationMessageDialog(jFrame, string7, BuilderUtil.getInstance().getAppVersionString());
            }
        }
        catch (PaswException paswException) {
            if (!file.delete()) {
                file.deleteOnExit();
            }
            BuilderAlertPane.showErrorMessageDialog(jFrame, BuilderResUtil.getString("IDS_ERROR_SAVING_DLG") + "\n\n" + paswException.getMessage(), BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        catch (IOException iOException) {
            if (!file.delete()) {
                file.deleteOnExit();
            }
            BuilderAlertPane.showErrorMessageDialog(jFrame, BuilderResUtil.getString("IDS_ERROR_SAVING_DLG") + "\n\n" + iOException.getMessage(), BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BuilderAlertPane.showErrorMessageDialog(jFrame, BuilderResUtil.getString("IDS_ERROR_SAVING_DLG") + "\n\n" + exception.getMessage(), BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        return true;
    }

    private void cleanupTempFolder() {
        if (mTempFolder != null) {
            for (File file : mTempFolder.listFiles()) {
                file.delete();
            }
            mTempFolder.delete();
            mTempFolder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeCfeFile(String string, SpecificationWriter specificationWriter, DialogDefinition dialogDefinition) throws IOException {
        boolean bl = true;
        DeflaterOutputStream deflaterOutputStream = null;
        try {
            String string2;
            String string3;
            if (mTempFolder == null) {
                string3 = BuilderUtil.getInstance().getTempDir().getAbsolutePath();
                mTempFolder = PASWFileUtil.createTempFile((String)"_uibuilder", (String)".tmp", (File)new File(string3));
                mTempFolder.delete();
                if (!mTempFolder.mkdir()) {
                    throw new Exception(String.format(BuilderResUtil.getString("IDS_CANT_MAKE_TEMP_FOLDER"), mTempFolder.getPath()));
                }
                mTempFolder.deleteOnExit();
            }
            string3 = mTempFolder.getPath() + File.separator + "extension" + XML_FILE_EXT;
            new File(string3).deleteOnExit();
            if (!specificationWriter.writeCFStream(string3, true, true)) {
                boolean bl2 = false;
                return bl2;
            }
            string3 = mTempFolder.getPath() + File.separator + "app-extension" + XML_FILE_EXT;
            if (!specificationWriter.writeAppExtensionsStream(string3)) {
                boolean bl3 = false;
                return bl3;
            }
            string3 = mTempFolder.getPath() + File.separator + "module" + XML_FILE_EXT;
            if (!specificationWriter.writeCFModuleStream(string3)) {
                boolean bl4 = false;
                return bl4;
            }
            BuilderUtil.getInstance().writeIconFiles(mTempFolder, dialogDefinition.getScriptType());
            BuilderUtil.getInstance().writePeerJar(mTempFolder, dialogDefinition.getScriptType());
            BuilderUtil.getInstance().writePropertiesFiles(mTempFolder, dialogDefinition.getDialogId(), dialogDefinition.getScriptType());
            FileOutputStream fileOutputStream = new FileOutputStream(string, false);
            deflaterOutputStream = new JarOutputStream(fileOutputStream);
            ((ZipOutputStream)deflaterOutputStream).setMethod(8);
            CustomDlgInstaller.saveToJar((JarOutputStream)deflaterOutputStream, mTempFolder, false);
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS && (string2 = dialogDefinition.getHelpFileName()) != null && string2.length() > 0) {
                String string4 = mTempFolder.getPath() + File.separator + "helps";
                String string5 = SpecificationWriter.getDeploymentFolder((boolean)false) + File.separator + dialogDefinition.getDialogId();
                boolean bl5 = string2.contains(File.separator);
                if (!bl5) {
                    string2 = string4 + File.separator + string2;
                    dialogDefinition.setHelpFileName(string2);
                }
                LinkedList linkedList = dialogDefinition.getPanels();
                for (PanelDefinition panelDefinition : linkedList) {
                    for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                        DialogDefinition dialogDefinition2;
                        PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
                        if (!(panelElementDefinition instanceof SubDlgButtonDefinition) || (string2 = (dialogDefinition2 = ((SubDlgButtonDefinition)panelElementDefinition).getDialogDefinition()).getHelpFileName()) == null || string2.length() <= 0 || (bl5 = string2.contains(File.separator))) continue;
                        string2 = string4 + File.separator + string2;
                        dialogDefinition2.setHelpFileName(string2);
                    }
                }
                if (!specificationWriter.writeHelpFiles(dialogDefinition, string5, true)) {
                    throw new Exception(CustomDlgInstaller.makeErrorText(specificationWriter));
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        finally {
            if (deflaterOutputStream != null) {
                try {
                    deflaterOutputStream.flush();
                    ((ZipOutputStream)deflaterOutputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return bl;
    }

    private static void saveToJar(JarOutputStream jarOutputStream, File file, boolean bl) throws Exception {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            Object object;
            if (file2.isFile()) {
                object = new FileInputStream(file2);
                int n = ((FileInputStream)object).available();
                byte[] byArray = new byte[n];
                int n2 = ((FileInputStream)object).read(byArray);
                ((FileInputStream)object).close();
                if (n2 != n) {
                    throw new Exception("Can't read input bytes");
                }
                CRC32 cRC32 = new CRC32();
                cRC32.update(byArray);
                String string = bl ? file.getName() + "/" + file2.getName() : file2.getName();
                JarEntry jarEntry = new JarEntry(string);
                jarEntry.setCompressedSize(n);
                jarEntry.setCrc(cRC32.getValue());
                jarOutputStream.putNextEntry(jarEntry);
                jarOutputStream.write(byArray);
                jarOutputStream.closeEntry();
                continue;
            }
            object = file2.getName();
            if (!((String)object).endsWith(File.separator)) {
                object = (String)object + "/";
            }
            JarEntry jarEntry = new JarEntry((String)object);
            jarOutputStream.putNextEntry(jarEntry);
            jarOutputStream.closeEntry();
            CustomDlgInstaller.saveToJar(jarOutputStream, file2, true);
        }
    }

    public boolean validateSyntaxAndMenuLocation(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl) {
        boolean bl2 = this.checkForSyntaxTemplate(jFrame, dialogDefinition, bl);
        if (bl2) {
            bl2 = this.checkForMenuLocation(jFrame, dialogDefinition, bl);
        }
        return bl2;
    }

    private boolean checkForMenuLocation(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl) {
        if (this.mShowWarnings && dialogDefinition.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)this).length() == 0) {
            Object[] objectArray = new String[]{BuilderResUtil.getString("IDS_OK")};
            String string = bl ? BuilderResUtil.getString("IDS_NO_MENU_LOC_WARNING_BUNDLE") : BuilderResUtil.getString("IDS_NO_MENU_LOCATION_MSG");
            int n = BuilderAlertPane.showOptionDialog(jFrame, String.format(string, dialogDefinition.getDialogId()), BuilderResUtil.getString("IDS_CANNOT_INSTALL_DIALOG"), BuilderAlertPane.IconType.eWarning, objectArray, (Object)objectArray[0]);
            return false;
        }
        return true;
    }

    private boolean checkForSyntaxTemplate(JFrame jFrame, DialogDefinition dialogDefinition, boolean bl) {
        if (dialogDefinition.getDialogSyntax().length() == 0) {
            Object[] objectArray = new String[]{BuilderResUtil.getString("IDS_OK")};
            String string = bl ? BuilderResUtil.getString("IDS_NO_TEMPLATE_WARNING_BUNDLE") : BuilderResUtil.getString("IDS_NO_TEMPLATE_WARNING_STATS");
            int n = BuilderAlertPane.showOptionDialog(jFrame, String.format(string, dialogDefinition.getDialogId()), BuilderResUtil.getString("IDS_CANNOT_INSTALL_DIALOG"), BuilderAlertPane.IconType.eWarning, objectArray, (Object)objectArray[0]);
            return false;
        }
        return true;
    }

    public static DialogDefinition readPackageFile(File file, boolean bl) throws Exception {
        DialogDefinition dialogDefinition = null;
        try {
            String string = BuilderUtil.getInstance().getTempDir().getAbsolutePath();
            mTempFolder = PASWFileUtil.createTempFile((String)"_uibuilder", (String)".tmp", (File)new File(string));
            mTempFolder.delete();
            if (!mTempFolder.mkdir()) {
                throw new Exception(String.format(BuilderResUtil.getString("IDS_CANT_MAKE_TEMP_FOLDER"), mTempFolder.getPath()));
            }
            mTempFolder.deleteOnExit();
            mExtensionFile = null;
            mAppExtFile = null;
            FileInputStream fileInputStream = new FileInputStream(file);
            JarInputStream jarInputStream = new JarInputStream(fileInputStream);
            mExtensionFile = bl ? CustomDlgInstaller.readFromJar(mTempFolder, mExtensionFile, jarInputStream) : CustomDlgInstaller.readCFFromJar(mTempFolder, mExtensionFile, jarInputStream);
            jarInputStream.close();
            if (mExtensionFile == null || !mExtensionFile.exists()) {
                throw new Exception("CLEF file does not exist");
            }
            dialogDefinition = bl ? CustomDlgInstaller.setCurrentDefinition(mExtensionFile, null, true) : CustomDlgInstaller.setCurrentCFDefinition(mExtensionFile, mAppExtFile, true);
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)("Error reading package file: " + exception.getMessage()), (int)15);
            throw exception;
        }
        finally {
            if (mTempFolder != null && mTempFolder.exists()) {
                mTempFolder.deleteOnExit();
            }
        }
        return dialogDefinition;
    }

    private static File readFromJar(File file, File file2, JarInputStream jarInputStream) throws IOException {
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string = jarEntry.getName();
            ByteBuffer byteBuffer = CustomDlgInstaller.readEntry(jarInputStream);
            File file3 = new File(file.getPath() + File.separator + string);
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            fileOutputStream.write(byteBuffer.array());
            fileOutputStream.close();
            jarInputStream.closeEntry();
            if (XML_FILE_EXT.regionMatches(true, 0, string, string.length() - XML_FILE_EXT.length(), XML_FILE_EXT.length())) {
                file2 = file3;
            }
            file3.deleteOnExit();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return file2;
    }

    private static ByteBuffer readEntry(JarInputStream jarInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        try {
            int n = jarInputStream.read(byArray, 0, 4096);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = jarInputStream.read(byArray, 0, 4096);
            }
        }
        catch (IOException iOException) {
            byteArrayOutputStream.reset();
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    private static File readCFFromJar(File file, File file2, JarInputStream jarInputStream) throws IOException {
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string = jarEntry.getName();
            File file3 = new File(file.getPath() + File.separator + string);
            if (!jarEntry.isDirectory()) {
                ByteBuffer byteBuffer = CustomDlgInstaller.readEntry(jarInputStream);
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                fileOutputStream.write(byteBuffer.array());
                fileOutputStream.close();
                jarInputStream.closeEntry();
                if (EXT_FILE_NAME.regionMatches(true, 0, string, 0, EXT_FILE_NAME.length())) {
                    file2 = file3;
                } else if (APP_EXT_FILE_NAME.regionMatches(true, 0, string, 0, APP_EXT_FILE_NAME.length())) {
                    mAppExtFile = file3;
                }
            } else {
                file3.mkdir();
            }
            file3.deleteOnExit();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return file2;
    }

    private static DialogDefinition setCurrentDefinition(File file, File file2, boolean bl) throws Exception {
        DialogDefinition dialogDefinition = BuilderUtil.getInstance().readClefFileSpec(file, file2, true);
        if (dialogDefinition == null) {
            throw new Exception("Cannot read file specification");
        }
        if (bl) {
            String string;
            String string2;
            String string3;
            File file3 = file.getParentFile();
            String string4 = dialogDefinition.getHelpFileName();
            if (string4 != null && string4.length() > 0) {
                string3 = new File(string4).getName();
                string2 = file3.getCanonicalPath() + File.separator + string3;
                dialogDefinition.setHelpFileName(string2);
            }
            if ((string3 = dialogDefinition.getCustomPropertiesFile()) != null && string3.length() > 0) {
                string2 = new File(string3).getName();
                string = file3.getCanonicalPath() + File.separator + string2;
                dialogDefinition.setCustomPropertiesFile(string);
            }
            LinkedList linkedList = dialogDefinition.getPanels();
            for (PanelDefinition panelDefinition : linkedList) {
                for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                    string = panelDefinition.getPanelElement(i);
                    if (!(string instanceof SubDlgButtonDefinition) || (string4 = (string2 = ((SubDlgButtonDefinition)string).getDialogDefinition()).getHelpFileName()) == null || string4.length() <= 0) continue;
                    String string5 = new File(string4).getName();
                    String string6 = file3.getCanonicalPath() + File.separator + string5;
                    string2.setHelpFileName(string6);
                }
            }
        }
        return dialogDefinition;
    }

    private static DialogDefinition setCurrentCFDefinition(File file, File file2, boolean bl) throws Exception {
        DialogDefinition dialogDefinition = BuilderUtil.getInstance().readClefFileSpec(file, file2, false);
        if (dialogDefinition == null) {
            throw new Exception("Cannot read file specification");
        }
        if (bl) {
            Object object;
            String string;
            String string2;
            String string3;
            File file3 = file.getParentFile();
            String string4 = dialogDefinition.getHelpFileName();
            if (string4 != null && string4.length() > 0) {
                string3 = new File(string4).getName();
                string2 = file3.getCanonicalPath() + File.separator + "helps" + File.separator + string3;
                dialogDefinition.setHelpFileName(string2);
            }
            if ((string3 = dialogDefinition.getCustomPropertiesFile()) != null && string3.length() > 0) {
                string2 = new File(string3).getName();
                string = file3.getCanonicalPath() + File.separator + string2;
                dialogDefinition.setCustomPropertiesFile(string);
            }
            if ((string2 = dialogDefinition.getNodeIconFile()) != null && string2.length() > 0) {
                string = new File(string2).getName();
                object = file3.getCanonicalPath() + File.separator + "images" + File.separator + string;
                dialogDefinition.setNodeIconFile((String)object);
            }
            LinkedList linkedList = dialogDefinition.getPanels();
            for (PanelDefinition panelDefinition : linkedList) {
                for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                    object = panelDefinition.getPanelElement(i);
                    if (!(object instanceof SubDlgButtonDefinition) || (string4 = (string = ((SubDlgButtonDefinition)object).getDialogDefinition()).getHelpFileName()) == null || string4.length() <= 0) continue;
                    String string5 = new File(string4).getName();
                    String string6 = file3.getCanonicalPath() + File.separator + string5;
                    string.setHelpFileName(string6);
                }
            }
        }
        return dialogDefinition;
    }

    public String getString(String string) {
        return BuilderUtil.getInstance().getMenuName(string);
    }

    public static String getString(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }
}

