/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder.Util;

import com.pasw.framework.common.PaswException;
import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.ExtensionBundleInstaller;
import com.spss.shared.custom_gui.ui_builder.Util.ExtensionBundleRemover;
import com.spss.shared.custom_gui.ui_builder.app.CDBAppInfo;
import com.spss.shared.custom_gui.ui_builder.app.LicenseOption;
import com.spss.shared.custom_gui.ui_builder.canvas.BuilderCanvas;
import com.spss.shared.custom_gui.ui_builder.canvas.DraggableTabbedPane;
import com.spss.shared.custom_gui.ui_builder.canvas.TabComponent;
import com.spss.shared.custom_gui.ui_builder.canvas.TabObject;
import com.spss.shared.custom_gui.ui_builder.peers.Copyright;
import com.spss.shared.custom_gui.ui_builder.pyspark.AslFactory;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.ui_builder.SpecificationBuilder;
import com.spss.uitools.ui_builder.definition.AddOnType;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.ScriptType;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.PASWFileUtil;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class BuilderUtil
implements CDBAppInfo {
    private static BuilderUtil util;
    private static CDBAppInfo appinfo;
    private boolean mStandalone = false;
    private static final String[] rPeerNames;
    private static final String[] pyPeerNames;
    private static final String[] rIconFiles;
    private static final String[] pyIconFiles;
    private static final String[] rPropFiles;
    private static final String[] pyPropFiles;
    private static final char[] invalidChars;
    private static final String PROP_FILE_EXT = ".properties";
    private static final String ESCAPE_SEQUENCE = "%%";
    private final String EXT_FILE_NAME = "extension.xml";
    private final String APP_EXT_FILE_NAME = "app-extension.xml";
    private final String sMNEMONIC = ".MNEMONIC";
    private final String sMNEMONIC_SPD = "_mnemonic.VALUE";
    private final String sTOOLTIP = ".TOOLTIP";
    private final String sTOOLTIP_SPD = "_tooltip.LABEL";
    private final String sLABEL = ".LABEL";
    private final String sTITLE = ".TITLE";
    private final String sIMAGE = ".IMAGE";
    private String mResultMsg = "";
    private String mInstalledExtensionFilesPath = "";
    private String mInstalledCDBFilesPath = "";
    private Pattern pattern;

    public static synchronized BuilderUtil getInstance() {
        if (null == util) {
            util = new BuilderUtil();
        }
        return util;
    }

    private BuilderUtil() {
    }

    public void setAppInfo(CDBAppInfo cDBAppInfo) {
        if (null == cDBAppInfo) {
            return;
        }
        appinfo = cDBAppInfo;
    }

    @Override
    public Charset getCurrentCharset() {
        return appinfo.getCurrentCharset();
    }

    @Override
    public String getAppVersionString() {
        return appinfo.getAppVersionString();
    }

    @Override
    public String getAppNameString() {
        return appinfo.getAppNameString();
    }

    @Override
    public String getAppMajorMinorVersionString() {
        return appinfo.getAppMajorMinorVersionString();
    }

    @Override
    public boolean executeSyntax(String string) {
        return appinfo.executeSyntax(string);
    }

    @Override
    public Locale getAppLocale() {
        return appinfo.getAppLocale();
    }

    @Override
    public LookAndFeel getLookAndFeel() {
        return appinfo.getLookAndFeel();
    }

    @Override
    public AppType getAppType() {
        return appinfo.getAppType();
    }

    @Override
    public String getRecentFilesDirectoryPath() {
        return appinfo.getRecentFilesDirectoryPath();
    }

    @Override
    public void setRecentFilesDirectoryPath(String string) {
        appinfo.setRecentFilesDirectoryPath(string);
    }

    public boolean deleteFile(File file) {
        if (!file.exists()) {
            return true;
        }
        return file.delete();
    }

    public boolean deleteFolder(File file) {
        File[] fileArray;
        if (!file.exists()) {
            return true;
        }
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                this.deleteFolder(file2);
                continue;
            }
            this.deleteFile(file2);
        }
        return file.delete();
    }

    public DialogDefinition createDialogDefFromSpecFile(String string, boolean bl) throws Exception {
        File file = null;
        DialogDefinition dialogDefinition = null;
        try {
            file = BuilderUtil.getInstance().createTempFolder();
            file.delete();
            if (!file.mkdir()) {
                throw new Exception("Cannot create temp folder");
            }
            file.deleteOnExit();
            File file2 = null;
            File[] fileArray = new File[1];
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            JarInputStream jarInputStream = new JarInputStream(fileInputStream);
            file2 = this.readCFFromJar(file, jarInputStream, fileArray);
            dialogDefinition = bl ? this.readClefFileSpec(file2, null, true) : this.readClefFileSpec(file2, fileArray[0], false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dialogDefinition;
    }

    private File readCFFromJar(File file, JarInputStream jarInputStream, File[] fileArray) throws IOException {
        File file2 = null;
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string = jarEntry.getName();
            File file3 = new File(file.getPath() + File.separator + string);
            if (!jarEntry.isDirectory()) {
                ByteBuffer byteBuffer = BuilderUtil.readEntry(jarInputStream);
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                fileOutputStream.write(byteBuffer.array());
                fileOutputStream.close();
                jarInputStream.closeEntry();
                if ("extension.xml".regionMatches(true, 0, string, 0, "extension.xml".length())) {
                    file2 = file3;
                } else if ("app-extension.xml".regionMatches(true, 0, string, 0, "app-extension.xml".length())) {
                    fileArray[0] = file3;
                }
            } else {
                file3.mkdir();
            }
            file3.deleteOnExit();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return file2;
    }

    public static ByteBuffer readEntry(JarInputStream jarInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        try {
            int n = jarInputStream.read(byArray, 0, 4096);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = jarInputStream.read(byArray, 0, 4096);
            }
        }
        catch (IOException iOException) {
            byteArrayOutputStream.reset();
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public DialogDefinition readClefFileSpec(File file, File file2, boolean bl) {
        DialogDefinition dialogDefinition = null;
        try {
            Document document;
            Document document2 = this.buildDOM(file);
            if (document2 == null) {
                return null;
            }
            String string = file.getParentFile().getPath();
            SpecificationBuilder specificationBuilder = new SpecificationBuilder(document2, string);
            dialogDefinition = specificationBuilder.getSpecification(bl, BuilderUtil.getInstance().getAppType());
            if (file2 != null && !bl && BuilderUtil.getInstance().getAppType() == AppType.STATS && (document = this.buildDOM(file2)) != null) {
                dialogDefinition = specificationBuilder.setCommandLocation(document);
            }
            specificationBuilder.releaseResouce();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        return dialogDefinition;
    }

    public void readMenuLocation(File file, DialogDefinition dialogDefinition) {
        Document document = this.buildDOM(file);
        if (document == null) {
            return;
        }
    }

    @Override
    public void removeFrame(JFrame jFrame) {
        appinfo.removeFrame(jFrame);
    }

    @Override
    public LicenseOption getLicenseOption() {
        return appinfo.getLicenseOption();
    }

    @Override
    public JFrame[] getAllFrames() {
        return appinfo.getAllFrames();
    }

    @Override
    public AddOnType[] getAddOnType() {
        return appinfo.getAddOnType();
    }

    @Override
    public String getUIExtensionsFolderPath() {
        return appinfo.getUIExtensionsFolderPath();
    }

    @Override
    public String[] getSecondaryExtensionFolders() {
        return appinfo.getSecondaryExtensionFolders();
    }

    @Override
    public String getAppdataCustomDialogDirectoryForAllUsers() {
        return appinfo.getAppdataCustomDialogDirectoryForAllUsers();
    }

    @Override
    public String getAppdataCustomDialogDirectory() {
        return appinfo.getAppdataCustomDialogDirectory();
    }

    @Override
    public boolean allowSyntax() {
        return appinfo.allowSyntax();
    }

    public boolean isStandalone() {
        return this.mStandalone;
    }

    public void setStandalone(boolean bl) {
        this.mStandalone = bl;
    }

    @Override
    public boolean isInCompatibleMode() {
        return appinfo.isInCompatibleMode();
    }

    @Override
    public void setCompabibleMode(boolean bl) {
        appinfo.setCompabibleMode(bl);
    }

    @Override
    public boolean isTabbed() {
        return appinfo.isTabbed();
    }

    @Override
    public void setTabbed(boolean bl) {
        appinfo.setTabbed(bl);
    }

    @Override
    public int getBTD() {
        return appinfo.getBTD();
    }

    @Override
    public boolean isOptimizeRtoL() {
        return appinfo.isOptimizeRtoL();
    }

    @Override
    public ArrayList<String> getSyntaxCommands() {
        return appinfo.getSyntaxCommands();
    }

    @Override
    public ArrayList<Object> getStatsSyntaxCommands() {
        return appinfo.getStatsSyntaxCommands();
    }

    @Override
    public void showHelp(String string) {
        appinfo.showHelp(string);
    }

    @Override
    public File getTempDir() {
        return appinfo.getTempDir();
    }

    @Override
    public File getExtensionPath() {
        return appinfo.getExtensionPath();
    }

    @Override
    public ArrayList<String> getExtensionBundlePath() {
        return appinfo.getExtensionBundlePath();
    }

    @Override
    public String getMenuName(String string) {
        return appinfo.getMenuName(string);
    }

    @Override
    public String loadExtension(File file) throws PaswException, IOException {
        return appinfo.loadExtension(file);
    }

    @Override
    public void addCfeMenuToFrames(String string, String string2) {
        appinfo.addCfeMenuToFrames(string, string2);
    }

    @Override
    public void unloadExtension(String string) throws PaswException {
        appinfo.unloadExtension(string);
    }

    @Override
    public String hasMenuItem(DialogDefinition dialogDefinition) {
        return appinfo.hasMenuItem(dialogDefinition);
    }

    @Override
    public boolean isMenuItemExist(DialogDefinition dialogDefinition) {
        return appinfo.isMenuItemExist(dialogDefinition);
    }

    @Override
    public void updateFrames(DialogDefinition dialogDefinition, String string) {
        appinfo.updateFrames(dialogDefinition, string);
    }

    @Override
    public boolean removeDeployed(String string) throws Exception {
        return appinfo.removeDeployed(string);
    }

    @Override
    public boolean removeDeployedBundle(File file) {
        return appinfo.removeDeployedBundle(file);
    }

    @Override
    public boolean hasCommand(String string, String string2, String string3) {
        return appinfo.hasCommand(string, string2, string3);
    }

    public TabObject createDialogTab(BuilderFrame builderFrame, int n) {
        if (n >= 0) {
            DraggableTabbedPane draggableTabbedPane = builderFrame.getTabbedPane();
            if (n > draggableTabbedPane.getTabCount()) {
                n = draggableTabbedPane.getTabCount();
            }
            BuilderCanvas builderCanvas = new BuilderCanvas(builderFrame, builderFrame.getDialogDefinition(), BuilderCanvas.CanvasType.Normal);
            builderFrame.getDialogDefinition().setCurrentPanel(n);
            builderCanvas.setFont(new Font("SansSerif", 0, 12));
            builderCanvas.addSelectionListener(builderFrame.getmPropsPanel());
            BuilderCanvas builderCanvas2 = new BuilderCanvas(builderFrame, builderFrame.getDialogDefinition(), n, BuilderCanvas.CanvasType.HeaderFooter);
            builderCanvas2.setFont(new Font("SansSerif", 0, 12));
            builderCanvas2.addSelectionListener(builderFrame.getmPropsPanel());
            boolean bl = false;
            if (builderFrame.showHeaderFooter()) {
                bl = true;
            }
            builderCanvas2.setVisible(bl);
            JSplitPane jSplitPane = new JSplitPane(0, builderCanvas2, new JScrollPane(builderCanvas));
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setResizeWeight(0.2);
            if (!bl) {
                jSplitPane.setDividerSize(0);
            }
            BuilderCanvas builderCanvas3 = new BuilderCanvas(builderFrame, builderFrame.getDialogDefinition(), n, BuilderCanvas.CanvasType.HeaderFooter);
            builderCanvas3.setFont(new Font("SansSerif", 0, 12));
            builderCanvas3.addSelectionListener(builderFrame.getmPropsPanel());
            builderCanvas3.setVisible(bl);
            JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, builderCanvas3);
            jSplitPane2.setOneTouchExpandable(true);
            jSplitPane2.setResizeWeight(0.8);
            if (!bl) {
                jSplitPane2.setDividerSize(0);
            }
            draggableTabbedPane.insertTab(builderCanvas.getTabPanelDefinition().getTitle(), null, jSplitPane2, null, n);
            TabObject tabObject = new TabObject(builderCanvas.getTabPanelDefinition(), builderFrame);
            tabObject.addSelectionListener(builderFrame.getmPropsPanel());
            draggableTabbedPane.setTabComponentAt(n, tabObject.getTabComponent());
            builderFrame.getDragPane().removeAllDropListener(BuilderCanvas.class);
            builderFrame.getDragPane().addDropListener((IDropListener)builderCanvas2);
            builderFrame.getDragPane().addDropListener((IDropListener)builderCanvas);
            builderFrame.getDragPane().addDropListener((IDropListener)builderCanvas3);
            draggableTabbedPane.setSelectedIndex(n);
            ((TabComponent)draggableTabbedPane.getTabComponentAt(0)).addButton();
            tabObject.getTabComponent().fireSelectionChange(tabObject);
            return tabObject;
        }
        return null;
    }

    public TabObject openDialogTab(BuilderFrame builderFrame, int n) {
        if (n >= 0) {
            DraggableTabbedPane draggableTabbedPane = builderFrame.getTabbedPane();
            if (n > draggableTabbedPane.getTabCount()) {
                n = draggableTabbedPane.getTabCount();
            }
            BuilderCanvas builderCanvas = new BuilderCanvas(builderFrame, builderFrame.getDialogDefinition(), n, BuilderCanvas.CanvasType.Normal);
            builderCanvas.setFont(new Font("SansSerif", 0, 12));
            builderCanvas.addSelectionListener(builderFrame.getmPropsPanel());
            String string = builderCanvas.getTabPanelDefinition().getTitle();
            draggableTabbedPane.insertTab(string, null, builderCanvas, null, n);
            TabObject tabObject = new TabObject(builderCanvas.getTabPanelDefinition(), builderFrame);
            tabObject.addSelectionListener(builderFrame.getmPropsPanel());
            draggableTabbedPane.setTabComponentAt(n, tabObject.getTabComponent());
            builderFrame.getDragPane().removeAllDropListener(BuilderCanvas.class);
            builderFrame.getDragPane().addDropListener((IDropListener)builderCanvas);
            ((TabComponent)draggableTabbedPane.getTabComponentAt(0)).addButton();
            tabObject.getTabComponent().fireSelectionChange(tabObject);
            return tabObject;
        }
        return null;
    }

    public boolean isCfeFile(File file) {
        boolean bl = false;
        if (!file.exists() || !file.isFile()) {
            return bl;
        }
        String string = file.getPath();
        if (string.endsWith(".cfe") || string.endsWith(".CFE")) {
            bl = true;
        }
        return bl;
    }

    public boolean isClefFolder(File file) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles(new XmlFilter())) {
            if (!SpecificationBuilder.isCLEF((File)file2)) continue;
            return true;
        }
        return false;
    }

    public String getExtensionId(String string) {
        int n = string.indexOf("<ExtensionDetails");
        int n2 = string.indexOf("<Resources");
        String string2 = string.substring(n, n2);
        String string3 = "id=\"";
        String string4 = string2.substring(string2.indexOf(string3) + string3.length());
        string4 = string4.substring(0, string4.indexOf("\""));
        string3 = "providerTag=\"";
        String string5 = string2.substring(string2.indexOf(string3) + string3.length());
        string5 = string5.substring(0, string5.indexOf("\""));
        return string5 + "." + string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document buildDOM(File file) {
        Document document = null;
        FileInputStream fileInputStream = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setIgnoringComments(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            fileInputStream = new FileInputStream(file);
            document = documentBuilder.parse(fileInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return document;
    }

    public File createTempFolder() throws IOException {
        return PASWFileUtil.createTempFile((String)"_uibuilder", (String)".tmp", (File)BuilderUtil.getInstance().getTempDir());
    }

    public void cleanTempFolder(File file, boolean bl) {
        File[] fileArray;
        if (file == null || file.isFile()) {
            return;
        }
        if (file.exists() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (!file2.exists()) continue;
                if (file2.isFile()) {
                    if (!bl) {
                        file2.delete();
                    }
                    file2.deleteOnExit();
                    continue;
                }
                this.cleanTempFolder(file2, bl);
            }
        }
        if (!bl) {
            file.delete();
        }
        file.deleteOnExit();
    }

    public void writePropertiesFiles(File file, String string, Locale locale, ScriptType scriptType) throws IOException {
        if (locale.getLanguage().equals("en")) {
            return;
        }
        this.writePropFileWithLocaleName(file, string, this.getPropNameViaLocale(locale), scriptType);
    }

    public void writePropertiesFiles(File file, String string, ScriptType scriptType) throws IOException {
        String[] stringArray = scriptType == ScriptType.R || scriptType == ScriptType.SYNTAX ? rPropFiles : pyPropFiles;
        for (String string2 : stringArray) {
            this.writePropFileWithLocaleName(file, string, string2, scriptType);
        }
    }

    private void writePropFileWithLocaleName(File file, String string, String string2, ScriptType scriptType) throws IOException {
        File file2 = new File(file.getAbsolutePath() + File.separator + string + PROP_FILE_EXT);
        if (!file2.exists() || !file2.canRead()) {
            throw new IOException(String.format(BuilderResUtil.getString("ERR_FILE_NOT_FOUND_MESSAGE"), file2));
        }
        File file3 = scriptType == ScriptType.R || scriptType == ScriptType.SYNTAX ? new File(file.getAbsolutePath() + File.separator + string + "_" + string2 + PROP_FILE_EXT) : new File(file.getAbsolutePath() + File.separator + string + string2.substring(2) + PROP_FILE_EXT);
        try {
            Object object;
            FileInputStream fileInputStream = new FileInputStream(file2);
            Properties properties = null;
            Properties properties2 = this.getProperties(fileInputStream);
            if (this.getAppType() == AppType.STATS && scriptType == ScriptType.SYNTAX) {
                Object object2;
                object = new File(file.getAbsolutePath() + File.separator + string + "_" + string2 + PROP_FILE_EXT);
                if (((File)object).exists() && (object2 = new FileInputStream((File)object)) != null) {
                    properties = this.getProperties((InputStream)object2);
                }
            } else {
                object = BuilderResUtil.class.getResourceAsStream(string2 + PROP_FILE_EXT);
                if (object != null) {
                    properties = this.getProperties((InputStream)object);
                }
            }
            object = new HashMap();
            for (Object object3 : properties2.keySet()) {
                String string3 = (String)object3;
                String string4 = null;
                if (properties != null && null == (string4 = properties.getProperty(string3))) {
                    String string5 = this.getSPDKey(string3);
                    string4 = properties.getProperty(string5);
                }
                if (string4 == null) {
                    string4 = properties2.getProperty(string3);
                }
                ((HashMap)object).put(string3, string4);
            }
            this.writeResourceFile(file3, (HashMap<String, String>)object, string);
        }
        catch (IOException iOException) {
            throw new IOException(String.format(UIToolResUtil.getString((String)"IDS_CANT_WRITE_LANG_FILE"), file3));
        }
    }

    public boolean validateScript(String string, ArrayList<String> arrayList, ScriptType scriptType) {
        if (string != null && string.length() > 0) {
            int n;
            if (BuilderUtil.getInstance().getAppType() == AppType.MODELER && scriptType == ScriptType.PYTHON) {
                return this.validatePythonScript(string, arrayList);
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            if (stringBuffer.indexOf(ESCAPE_SEQUENCE) < 0) {
                return true;
            }
            int n2 = string.length();
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                int n6 = stringBuffer.indexOf("%", n4);
                if (n6 < 0) break;
                n = stringBuffer.charAt(n6);
                while (n6 >= 0 && n == 37) {
                    ++n5;
                    if (++n6 >= n2) break;
                    n = stringBuffer.charAt(n6);
                }
                n3 += n5;
                if (n5 != 0 && n5 != 2 && n5 != 4) {
                    return false;
                }
                n4 = n6;
            }
            if (n3 > 0 && n3 % 4 != 0) {
                return false;
            }
            n4 = 0;
            while (n4 >= 0 && n4 < n2) {
                if ((n4 = stringBuffer.indexOf(ESCAPE_SEQUENCE, n4)) <= -1) continue;
                n = stringBuffer.indexOf(ESCAPE_SEQUENCE, n4 + 1);
                if (n == -1) {
                    n = stringBuffer.length();
                }
                if (arrayList.indexOf(stringBuffer.subSequence(n4 + 2, n).toString()) < 0) {
                    return false;
                }
                n4 = n + 2;
            }
        }
        return true;
    }

    public static boolean isDebugMode() {
        return System.getProperty("__debug_", "").equals("Yes");
    }

    private boolean validatePythonScript(String string, ArrayList<String> arrayList) {
        if (null == this.pattern) {
            this.pattern = Pattern.compile("%%[a-zA-Z_$][\\w$]*%%");
        }
        Matcher matcher = this.pattern.matcher(string);
        return this.hasControl(matcher, arrayList);
    }

    private boolean hasControl(Matcher matcher, ArrayList<String> arrayList) {
        while (matcher.find()) {
            String string = matcher.group();
            if (arrayList.indexOf(string = string.replaceAll(ESCAPE_SEQUENCE, "")) >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResourceFile(File file, HashMap<String, String> hashMap, String string) throws IOException {
        try (OutputStreamWriter outputStreamWriter = null;){
            FileOutputStream fileOutputStream = new FileOutputStream(file, false);
            fileOutputStream.write(new byte[]{-17, -69, -65});
            String string2 = System.getProperty("os.name", "Windows").toLowerCase();
            String string3 = string2.startsWith("win") ? "\r\n" : "\n";
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            outputStreamWriter.write(String.format("%s%s", string3, string3));
            outputStreamWriter.write(String.format("#/***********************************************************************%s", string3));
            outputStreamWriter.write(String.format("# * Licensed Materials - Property of IBM%s", string3));
            outputStreamWriter.write(String.format("# *%s", string3));
            outputStreamWriter.write(String.format("# * IBM SPSS Products: Statistics Common%s", string3));
            outputStreamWriter.write(String.format("# *%s", string3));
            outputStreamWriter.write(String.format("# * (C) Copyright IBM Corp. 1989, %d%s", Calendar.getInstance(Locale.US).get(1), string3));
            outputStreamWriter.write(String.format("# *%s", string3));
            outputStreamWriter.write(String.format("# * US Government Users Restricted Rights - Use, duplication or disclosure%s", string3));
            outputStreamWriter.write(String.format("# * restricted by GSA ADP Schedule Contract with IBM Corp.%s", string3));
            outputStreamWriter.write(String.format("# ************************************************************************/%s%s", string3, string3));
            outputStreamWriter.write(String.format("# Language properties for %s%s", string, string3));
            outputStreamWriter.write(String.format("# NLS_MESSAGEFORMAT_NONE.%s", string3));
            outputStreamWriter.write(String.format("# NLS_ENCODING=UTF-8.%s%s", string3, string3));
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                outputStreamWriter.write(String.format("%s=%s%s", entry.getKey(), entry.getValue(), string3));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        try {
            String string = CharacterUtil.getEncoding((InputStream)inputStream);
            string = string == null ? "UTF-8" : string;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            this.readProps(inputStreamReader, properties);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return properties;
    }

    private void readProps(InputStreamReader inputStreamReader, Properties properties) {
        try {
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            while (string != null) {
                int n = string.indexOf(61);
                if (!string.startsWith("#") && n > 0) {
                    properties.put(string.substring(0, n).trim(), string.substring(n + 1).trim());
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIconFiles(File file, ScriptType scriptType) throws IOException {
        if (!(file = new File(file.getAbsolutePath() + File.separator + "images")).exists()) {
            file.mkdir();
        }
        String[] stringArray = scriptType == ScriptType.R ? rIconFiles : pyIconFiles;
        for (String string : stringArray) {
            String string2 = file.getAbsolutePath() + File.separator + string;
            File file2 = new File(string2);
            if (file2.exists() && !file2.canWrite() || !PASWFileUtil.isWritable((File)file2.getParentFile())) {
                throw new IOException(String.format(UIToolResUtil.getString((String)"IDS_CANT_WRITE_FILE"), string2));
            }
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                int n;
                inputStream = BuilderResUtil.class.getResourceAsStream("images/" + string);
                fileOutputStream = new FileOutputStream(string2);
                if (inputStream == null) continue;
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
    }

    public void writePeerJar(File file, ScriptType scriptType) throws IOException {
        if (file == null || !file.isDirectory() || !file.exists()) {
            throw new IOException(BuilderResUtil.getString("ERR_PEER_DOESNT_EXIST_WARNING_MESSAGE"));
        }
        String string = file.getAbsolutePath() + File.separator + "cdb_peer.jar";
        File file2 = new File(string);
        if (file2.exists() && !file2.canWrite() || !PASWFileUtil.isWritable((File)file2.getParentFile())) {
            throw new IOException(String.format(UIToolResUtil.getString((String)"IDS_CANT_WRITE_FILE"), string));
        }
        HashMap<String, InputStream> hashMap = this.getPeerStreams(scriptType);
        FileOutputStream fileOutputStream = new FileOutputStream(string, false);
        JarOutputStream jarOutputStream = new JarOutputStream(fileOutputStream);
        jarOutputStream.setMethod(8);
        for (String string2 : hashMap.keySet()) {
            int n;
            InputStream inputStream = hashMap.get(string2);
            if (inputStream == null) continue;
            int n2 = inputStream.available();
            byte[] byArray = new byte[2048];
            CRC32 cRC32 = new CRC32();
            String string3 = "com/spss/shared/custom_gui/ui_builder/peers/" + string2 + ".class";
            JarEntry jarEntry = new JarEntry(string3);
            jarEntry.setCompressedSize(n2);
            jarOutputStream.putNextEntry(jarEntry);
            while ((n = inputStream.read(byArray)) != -1) {
                cRC32.update(byArray);
                jarOutputStream.write(byArray, 0, n);
            }
            jarEntry.setCrc(cRC32.getValue());
            jarOutputStream.closeEntry();
        }
        jarOutputStream.flush();
        jarOutputStream.close();
    }

    private HashMap<String, InputStream> getPeerStreams(ScriptType scriptType) {
        Class clazz;
        String[] stringArray;
        HashMap<String, InputStream> hashMap = new HashMap<String, InputStream>();
        if (scriptType == ScriptType.R) {
            stringArray = rPeerNames;
            clazz = Copyright.class;
        } else {
            stringArray = pyPeerNames;
            clazz = AslFactory.class;
        }
        for (String string : stringArray) {
            hashMap.put(string, clazz.getResourceAsStream(string + ".class"));
        }
        return hashMap;
    }

    private String getSPDKey(String string) {
        int n = string.length();
        if (string.endsWith(".MNEMONIC")) {
            String string2 = string.substring(0, n - ".MNEMONIC".length());
            return string2 + this.sMNEMONIC_SPD;
        }
        if (string.endsWith(this.sTOOLTIP)) {
            String string3 = string.substring(0, n - ".TOOLTIP".length());
            return string3 + this.sTOOLTIP_SPD;
        }
        return string;
    }

    private String getPropNameViaLocale(Locale locale) {
        String string = locale.getLanguage();
        if (string.equals("zh") || string.equals("pt")) {
            string = string + "_" + locale.getCountry();
        }
        return string;
    }

    public boolean installExtensionBundle(JFrame jFrame, boolean bl, boolean bl2, boolean bl3, File file) {
        ExtensionBundleInstaller extensionBundleInstaller = new ExtensionBundleInstaller(jFrame, bl, bl2, bl3);
        if (extensionBundleInstaller.doInstall(file)) {
            BuilderUtil.getInstance().setResultMsg(extensionBundleInstaller.getSuccessMsg());
            BuilderUtil.getInstance().setInstalledExtensionFilesPath(extensionBundleInstaller.getInstalledExtensionFilesPath());
            BuilderUtil.getInstance().setInstalledCDBFilesPath(extensionBundleInstaller.getInstalledCDBFilesPath());
            return true;
        }
        this.setResultMsg(extensionBundleInstaller.getErrorMsg());
        return false;
    }

    public boolean unInstallExtensionBundle(String string) {
        ExtensionBundleRemover extensionBundleRemover = new ExtensionBundleRemover();
        if (extensionBundleRemover.doRemove(string)) {
            BuilderUtil.getInstance().setResultMsg(extensionBundleRemover.getSuccessMsg());
            return true;
        }
        BuilderUtil.getInstance().setResultMsg(extensionBundleRemover.getErrorMsg());
        return false;
    }

    public static boolean isValidTitle(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (char c : invalidChars) {
            if (string.indexOf(c) <= -1) continue;
            return false;
        }
        return true;
    }

    public String getExtName() {
        if (this.getAppType() == AppType.STATS) {
            return ".spe";
        }
        return ".mpe";
    }

    public String getResultMsg() {
        return this.mResultMsg;
    }

    private void setResultMsg(String string) {
        this.mResultMsg = string;
    }

    public String getInstalledExtensionFilesPath() {
        return this.mInstalledExtensionFilesPath;
    }

    private void setInstalledExtensionFilesPath(String string) {
        this.mInstalledExtensionFilesPath = string;
    }

    public String getInstalledCDBFilesPath() {
        return this.mInstalledCDBFilesPath;
    }

    private void setInstalledCDBFilesPath(String string) {
        this.mInstalledCDBFilesPath = string;
    }

    static {
        appinfo = null;
        rPeerNames = new String[]{"ActionHandler$1", "ActionHandler$2", "ActionHandler", "Copyright", "ErrorHelper", "ManagedBasePanel", "ManagedEmptyOutputArea", "ManagedHTMLOutputArea", "ManagedModelOutputPanel", "ManagedScoreSyntaxControl$1", "ManagedScoreSyntaxControl$ButtonsAction", "ManagedScoreSyntaxControl", "ManagedScoreSyntaxPanel", "ManagedTextOutputArea", "ROutputFileChooserControl$1", "ROutputFileChooserControl", "RStatsApplierPeer", "RStatsBuilderPeer", "RStatsExtensionObjPeer", "RStatsImportPeer", "RStatsOutputPeer", "RStatsExportPeer", "RStatsProcessPeer", "RStatsUIPeer", "UIUtilities"};
        pyPeerNames = new String[]{"ActionHandler$1", "ActionHandler$2", "ActionHandler", "AnalyticServerAPIHelper", "AnalyticServerAPIHelper$1", "AnalyticServerAPIHelper$1InteractorListenerImp", "AnalyticServerAPIHelper$2", "AnalyticServerAPIHelper$3", "AnalyticServerAPIHelper$4", "AnalyticServerAPIHelper$5", "ASConnectionHelper", "AslFactory$ModuleType", "AslFactory$OutputType", "AslFactory", "CFDataModel", "CFDataModelParser$ToolMissingValueDescriptor", "CFDataModelParser$ToolModelOutputDescriptor", "CFDataModelParser", "CFDataModelProvider", "CFDateFieldFormat", "CFDecoratedFieldFormat", "CFExtendableAdaptor", "CFField", "CFFieldFormat", "CFFieldFormats", "CFFormattedField", "CFFormattedFieldFormat", "CFNumberFieldFormat", "CFStringFieldFormat", "CFTimeFieldFormat", "CFValidValues", "CFXMLFormatConstants$COMM_FORMAT_ATT", "CFXMLFormatConstants$DATE_FORMAT_ATT", "CFXMLFormatConstants$DECORATED_FORMAT_ATT", "CFXMLFormatConstants$FIELD_FORMATS_ATT", "CFXMLFormatConstants$NUMBER_FORMAT_ATT", "CFXMLFormatConstants$STRING_FORMAT_ATT", "CFXMLFormatConstants$TIME_FORMAT_ATT", "CFXMLFormatConstants", "Copyright", "DatamodelFactory", "ErrorHelper", "ManagedBasePanel", "ManagedEmptyOutputArea", "ManagedModelOutputPanel", "ManagedScoreScriptControl$1", "ManagedScoreScriptControl$ButtonsAction", "ManagedScoreScriptControl", "ManagedScoreScriptPanel", "ManagedTextOutputArea", "PySparkApplierPeer", "PySparkBuilderPeer", "PySparkExportPeer", "PySparkImportPeer", "PySparkOutputPeer", "PySparkPeer$1", "PySparkPeer", "PySparkProcessPeer", "PySparkUIPeer", "UIUtilities"};
        rIconFiles = new String[]{"help_button.gif", "savetoproject.gif", "store.png", "fileMenu.gif", "generateMenu.gif", "preview_table.gif", "save.gif", "delete.gif", "print.gif", "printPreview.gif", "copy.gif", "lg_cdb.gif", "lg_gm_cdb.gif", "sm_cdb.gif", "sm_cdb_node.fw.png", "sm_cdb_source.fw.png", "sm_cdb_output.fw.png", "sm_cdb_process.fw.png", "sm_gm_cdb.gif"};
        pyIconFiles = new String[]{"button_help.gif", "button_preview.gif", "button_save2project.gif", "file.gif", "print.gif", "printPreview.gif", "save.gif", "delete.gif", "store.png", "lg_cdb.gif", "lg_gm_cdb.gif", "sm_cdb.gif", "sm_cdb_source.fw.png", "sm_cdb_output.fw.png", "sm_cdb_process.fw.png", "sm_cdb_node.fw.png", "sm_gm_cdb.gif"};
        rPropFiles = new String[]{"de", "es", "fr", "it", "ja", "ko", "pl", "pt_BR", "ru", "zh_CN", "zh_TW"};
        pyPropFiles = new String[]{"py_de", "py_es", "py_fr", "py_it", "py_ja", "py_ko", "py_pl", "py_pt_BR", "py_ru", "py_zh_CN", "py_zh_TW"};
        invalidChars = new char[]{'\"', ' ', '*', '\\', '/', '?', ':', '>', '<', '|'};
    }

    class XmlFilter
    implements FilenameFilter {
        XmlFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.toUpperCase().endsWith(".XML");
        }
    }
}

