/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.DialogFocusTraversalPolicy;
import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.canvas.CheckBoxGroupObject;
import com.spss.shared.custom_gui.ui_builder.canvas.CheckBoxObject;
import com.spss.shared.custom_gui.ui_builder.props_ui.IdentifierTable;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.shared.syntaxeditor.AUTO_COMPLETE_LEVEL;
import com.spss.shared.syntaxeditor.SyntaxCommand;
import com.spss.shared.syntaxeditor.SyntaxMasterPanel;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class SyntaxDiagramDlg
extends BaseDialog
implements PopupMenuListener,
SyntaxMasterPanel.SyntaxCallback {
    private static final String ESCAPE_SEQUENCE = "%%";
    private static final String REGEXP = "%%[a-zA-Z_$][\\w$]*%%";
    private Pattern pattern;
    SyntaxDiagramDlgCallback mCallback;
    private boolean mModalResult = false;
    SyntaxMasterPanel mSyntaxMasterPanel;
    DocumentListener mSyntaxMasterDocListener;
    SyntaxMasterPanel mScoreMasterPanel;
    DocumentListener mScoreDocListener;
    JTabbedPane mTabbedPane;
    private boolean mIsIdPopupVisible;
    private ArrayList<String> mControlIDs;
    private String mSyntax;
    private String mScoreScipt;
    private JButton mOkButton;
    private JButton mCancelButton;
    private JButton mHelpButton;
    private String mMesgKey;
    private JButton mRestoreButton;
    private JPanel mMesgPanel;
    private JCheckBox mTipCheck;
    private JButton mLeftArrowButton;
    private JButton mRightArrowButton;
    private JPanel mNewFeatureCards;
    private int mActiveWNIndex = -1;
    private BuilderFrame mBuilderFrame;
    private JButton mMoveToNewButton;
    private IdentifierTable mIDTable;
    private JPanel mMainPanel;
    private JTextArea mFooterText;
    private boolean mSytaxPanelChanged;
    private Vector<Object> mComponentVector;

    public SyntaxDiagramDlg(JFrame jFrame, String string, String string2, ArrayList<String> arrayList, ArrayList<SyntaxCommand> arrayList2, SyntaxDiagramDlgCallback syntaxDiagramDlgCallback) {
        this(jFrame, string, string2, arrayList, arrayList2, "", syntaxDiagramDlgCallback);
    }

    public SyntaxDiagramDlg(JFrame jFrame, String string, String string2, ArrayList<String> arrayList, ArrayList<SyntaxCommand> arrayList2, String string3, SyntaxDiagramDlgCallback syntaxDiagramDlgCallback) {
        super(jFrame, string, false, BuilderResUtil.getLabels(), BuilderResBundle.getImageFolder());
        this.mBuilderFrame = (BuilderFrame)jFrame;
        this.mCallback = syntaxDiagramDlgCallback;
        this.mSyntax = string2;
        this.mScoreScipt = "";
        if (string3.length() > 0) {
            this.mSyntax = this.mSyntax.replaceAll("\\\\n", "\n");
        }
        this.mControlIDs = arrayList;
        this.mIsIdPopupVisible = false;
        this.mMesgKey = string3;
        this.mSyntaxMasterPanel = new SyntaxMasterPanel((SyntaxMasterPanel.SyntaxCallback)this, arrayList2, !BuilderUtil.getInstance().isOptimizeRtoL());
        this.mSyntaxMasterPanel.removeSyntaxSplit();
        this.mSyntaxMasterPanel.removeNavigationPane();
        this.mSyntaxMasterPanel.removeErrorPane();
        this.mSyntaxMasterPanel.setDoRunUI(false);
        this.mSyntaxMasterPanel.setDoBookmarkUI(false);
        this.mSyntaxMasterPanel.insertString(0, this.mSyntax);
        this.mSyntaxMasterDocListener = this.addDocListener(this.mSyntaxMasterPanel);
        if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
            this.mScoreMasterPanel = new SyntaxMasterPanel((SyntaxMasterPanel.SyntaxCallback)this, arrayList2, !BuilderUtil.getInstance().isOptimizeRtoL());
            this.mScoreMasterPanel.removeSyntaxSplit();
            this.mScoreMasterPanel.removeNavigationPane();
            this.mScoreMasterPanel.removeErrorPane();
            this.mScoreMasterPanel.setDoRunUI(false);
            this.mScoreMasterPanel.setDoBookmarkUI(false);
            this.mSyntaxMasterPanel.insertString(0, this.mScoreScipt);
            this.mScoreDocListener = this.addDocListener(this.mScoreMasterPanel);
            this.pattern = Pattern.compile(REGEXP);
        } else {
            this.mScoreMasterPanel = null;
        }
        this.addCmdPanel();
        if (this.mMesgKey.length() > 0) {
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.createControls();
        } else {
            this.createControlsNew();
        }
        this.enableControls();
        this.setDefaultCloseOperation(0);
        this.mSytaxPanelChanged = false;
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.addWindowListener();
    }

    private DocumentListener addDocListener(SyntaxMasterPanel syntaxMasterPanel) {
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SyntaxDiagramDlg.this.mBuilderFrame.setModified(true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SyntaxDiagramDlg.this.mBuilderFrame.setModified(true);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        syntaxMasterPanel.getActiveSpssTextPane().getDocument().addDocumentListener(documentListener);
        return documentListener;
    }

    private void addWindowListener() {
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SyntaxDiagramDlg.this.doClose(true);
            }
        };
        this.addWindowListener(windowAdapter);
    }

    private ArrayList<SyntaxCommand> getSyntaxCommands(ArrayList<String> arrayList) {
        ArrayList<SyntaxCommand> arrayList2 = new ArrayList<SyntaxCommand>();
        for (String string : arrayList) {
            SyntaxCommand syntaxCommand = new SyntaxCommand(string);
            arrayList2.add(syntaxCommand);
        }
        return arrayList2;
    }

    public Vector<Object> getTabTravConponent() {
        return this.mComponentVector;
    }

    public void setSyntax(String string) {
        this.mSyntaxMasterPanel.getMainSpssSyntaxTextPane().setText("");
        this.mSyntax = string;
        this.mSyntax = this.replaceNewlinChar(this.mSyntax);
        this.mSyntaxMasterPanel.getActiveSpssTextPane().getDocument().removeDocumentListener(this.mSyntaxMasterDocListener);
        this.mSyntaxMasterPanel.insertString(0, this.mSyntax);
        this.mSyntaxMasterPanel.getActiveSpssTextPane().getDocument().addDocumentListener(this.mSyntaxMasterDocListener);
    }

    public void setScoreScript(String string) {
        if (this.mScoreMasterPanel == null) {
            return;
        }
        this.mScoreMasterPanel.getMainSpssSyntaxTextPane().setText("");
        this.mScoreScipt = string;
        this.mScoreScipt = this.mScoreScipt.replaceAll("\\\\n", "\n");
        this.mScoreMasterPanel.getActiveSpssTextPane().getDocument().removeDocumentListener(this.mScoreDocListener);
        this.mScoreMasterPanel.insertString(0, this.mScoreScipt);
        this.mScoreMasterPanel.getActiveSpssTextPane().getDocument().addDocumentListener(this.mScoreDocListener);
    }

    public void addControlID(CanvasObject canvasObject) {
        if (this.mControlIDs.contains(canvasObject.getControlId())) {
            this.removeControlID(canvasObject);
        }
        if (!this.mControlIDs.contains(canvasObject.getControlId())) {
            if ((canvasObject instanceof CheckBoxObject || canvasObject instanceof CheckBoxGroupObject) && !this.mFooterText.isVisible()) {
                this.mFooterText.setVisible(true);
            }
            this.mControlIDs.add(canvasObject.getControlId());
            this.mIDTable.addCanvasObject(canvasObject);
        }
    }

    public void removeControlID(CanvasObject canvasObject) {
        if (this.mControlIDs.contains(canvasObject.getControlId())) {
            this.mControlIDs.remove(canvasObject.getControlId());
            this.mIDTable.removeCanvasObject(canvasObject);
            if (!this.mIDTable.hasCheckbox() && this.mFooterText.isVisible()) {
                this.mFooterText.setVisible(false);
            }
        }
    }

    public void removeControlID(String string) {
        if (this.mControlIDs.contains(string)) {
            this.mControlIDs.remove(string);
            this.mIDTable.removeCanvasObject(string);
            if (!this.mIDTable.hasCheckbox() && this.mFooterText.isVisible()) {
                this.mFooterText.setVisible(false);
            }
        }
    }

    public void resetID() {
        this.mControlIDs.clear();
        this.mIDTable.removeAllObject();
        this.mFooterText.setVisible(false);
    }

    public boolean commitEdits(boolean bl) {
        boolean bl2;
        boolean bl3 = true;
        if (this.mIDTable.isEditing() && !this.mIDTable.getCellEditor().stopCellEditing()) {
            this.mIDTable.getCellEditor().cancelCellEditing();
        }
        if (!this.validateInput() && bl && (bl2 = this.mCallback.showInvalidSyntaxWarning())) {
            return false;
        }
        this.mCallback.syntaxModifiedNotification();
        return true;
    }

    public LinkedList<CanvasObject> getAllCanvasObjects() {
        return this.mIDTable.getAllCanvasObjects();
    }

    public void setAllCanvasObjects(LinkedList<CanvasObject> linkedList) {
        this.resetID();
        for (CanvasObject canvasObject : linkedList) {
            this.addControlID(canvasObject);
        }
    }

    public void updateCanvasObject(CanvasObject canvasObject, String string, String string2, String string3) {
        this.mIDTable.updateCanvasObject(canvasObject, string, string2, string3);
        if (string != null) {
            this.mControlIDs.clear();
            LinkedList<CanvasObject> linkedList = this.getAllCanvasObjects();
            for (CanvasObject canvasObject2 : linkedList) {
                this.mControlIDs.add(canvasObject2.getControlId());
            }
        }
    }

    public void insertControlSyntax(String string) {
        new InsertIdAction(string).actionPerformed(null);
    }

    public ArrayList getUserAutoCompleteList(AUTO_COMPLETE_LEVEL aUTO_COMPLETE_LEVEL) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (aUTO_COMPLETE_LEVEL != AUTO_COMPLETE_LEVEL.subcommand) {
            String string = DialogDefinition.getEscapeSequence();
            for (String string2 : this.mControlIDs) {
                arrayList.add(string + string2 + string);
            }
        }
        return arrayList;
    }

    public boolean processDrop(DropTargetDropEvent dropTargetDropEvent) {
        return false;
    }

    public Object processNotification(int n, Object object) {
        if (n == 7) {
            return false;
        }
        if (n == 9) {
            if (this.mSytaxPanelChanged) {
                this.mBuilderFrame.setModified(true);
            }
            return this.getUserAutoCompleteList((AUTO_COMPLETE_LEVEL)object);
        }
        if (n == 2) {
            this.mSytaxPanelChanged = true;
            return null;
        }
        return null;
    }

    public boolean getModalResult() {
        return this.mModalResult;
    }

    protected void init() {
        this.mMainPanel = new JPanel(new BorderLayout(), false);
        String string = System.getProperty("os.name", "Windows").toLowerCase();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        if (string.startsWith("mac")) {
            insets.bottom = 14;
        }
        this.mMainPanel.setBorder(new EmptyBorder(insets));
        this.mMainPanel.setOpaque(true);
        this.mViewPanel = new JPanel(new GridBagLayout(), true);
        this.mMainPanel.add((Component)this.mViewPanel, "Center");
    }

    private void addCmdPanel() {
        this.mCmdButtonPanel = this.setupCmdButtonPanel();
        if (this.mCmdButtonPanel != null) {
            UIToolDialogUtil.normalizeButtonWidths((JPanel)this.mCmdButtonPanel);
            boolean bl = UIToolDialogUtil.areCommandButtonsBelow();
            this.mMainPanel.add((Component)this.mCmdButtonPanel, bl ? "South" : "East");
        }
        this.setContentPane(this.mMainPanel);
        DragPane dragPane = new DragPane();
        this.setGlassPane((Component)dragPane);
    }

    private void doClose(boolean bl) {
        boolean bl2;
        if (!this.validateInput() && (bl2 = this.mCallback.showInvalidSyntaxWarning())) {
            return;
        }
        this.mModalResult = true;
        this.mCallback.syntaxModifiedNotification();
        this.mBuilderFrame.setModified(true);
        if (bl) {
            this.dispose();
            if (this.mMesgKey.length() == 0) {
                if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                    this.mBuilderFrame.showSyntaxTemplatePanel(this.getSyntax());
                } else {
                    this.mBuilderFrame.showSyntaxTemplatePanel(this.getSyntax(), this.getScoreScript());
                }
            }
        } else {
            this.mBuilderFrame.hideSyntaxTemplatePanel();
        }
    }

    private void createControls() {
        Object object;
        Serializable serializable;
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = (Insets)DialogUtil.getStandardButtonInsets().clone();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = insets;
        String string = this.getEscapeSequence();
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.top = 10;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        if (this.mBuilderFrame.getDialogDefinition().getAppType() == AppType.STATS) {
            serializable = BuilderResUtil.getImageResource("infodot.png");
            object = new ImageIcon((URL)serializable);
            JLabel jLabel = new JLabel((Icon)object);
            String string2 = BuilderResUtil.getString(this.mMesgKey);
            JTextArea jTextArea = this.createStaticMultiLineLabel(string2);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 4);
            jPanel2.add((Component)jLabel, gridBagConstraints2);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 2;
            jPanel2.add((Component)jTextArea, gridBagConstraints2);
        }
        gridBagConstraints.gridy = this.mBuilderFrame.getDialogDefinition().getAppType() == AppType.STATS ? 2 : 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.top = 6;
        jPanel.add((Component)this.mSyntaxMasterPanel, gridBagConstraints);
        this.mSyntaxMasterPanel.setPreferredSize(new Dimension(500, 150));
        serializable = new Vector();
        ((Vector)serializable).add(this.mSyntaxMasterPanel);
        ((Vector)serializable).add(this.mOkButton);
        ((Vector)serializable).add(this.mCancelButton);
        ((Vector)serializable).add(this.mHelpButton);
        object = new DialogFocusTraversalPolicy((Vector<Object>)serializable, false);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)object);
        this.setupActions();
    }

    private void setupActions() {
        JTextPane jTextPane = this.mSyntaxMasterPanel.getSyntaxTextPane();
        jTextPane.addMouseListener(new ContextMouseListener());
        this.setupActions(jTextPane);
        if (BuilderUtil.getInstance().getAppType() == AppType.MODELER && this.mScoreMasterPanel != null) {
            JTextPane jTextPane2 = this.mScoreMasterPanel.getSyntaxTextPane();
            jTextPane2.addMouseListener(new ContextMouseListener());
            this.setupActions(jTextPane2);
        }
    }

    private void setupActions(JTextPane jTextPane) {
        jTextPane.getInputMap(2).put(KeyStroke.getKeyStroke(115, 2), "close_window");
        jTextPane.getActionMap().put("close_window", new OkAction());
        AbstractAction abstractAction = new CtrlUpDownAction(true);
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(38, 2), "up_a_line");
        jTextPane.getActionMap().put("up_a_line", abstractAction);
        abstractAction = new CtrlUpDownAction(false);
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(40, 2), "down_a_line");
        jTextPane.getActionMap().put("down_a_line", abstractAction);
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(155, 1), "paste-from-clipboard");
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(155, 2), "copy-to-clipboard");
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(127, 1), "cut-to-clipboard");
        abstractAction = new DeletePrevWordAction();
        jTextPane.getInputMap().put(KeyStroke.getKeyStroke(8, 2), "del_prev_word");
        jTextPane.getActionMap().put("del_prev_word", abstractAction);
        String string = UIToolResUtil.getString((String)"IDS_DELETE");
        Action action = jTextPane.getActionMap().get("delete-next");
        Action action2 = action = action != null ? action : jTextPane.getActionMap().get(string);
        if (action != null) {
            action.putValue("Name", string);
            jTextPane.getInputMap().put(KeyStroke.getKeyStroke(127, 0), string);
            jTextPane.getActionMap().put(string, action);
        }
        String string2 = UIToolResUtil.getString((String)"IDS_SELECTALL");
        Action action3 = jTextPane.getActionMap().get("select-all");
        Action action4 = action3 = action3 != null ? action3 : jTextPane.getActionMap().get(string2);
        if (action3 != null) {
            action3.putValue("Name", string2);
            jTextPane.getInputMap().put(KeyStroke.getKeyStroke(65, 2), string2);
            jTextPane.getActionMap().put(string2, action3);
        }
    }

    private JTextArea createStaticMultiLineLabel(String string) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setForeground(UIManager.getColor("Panel.foreground"));
        jTextArea.setBackground(UIManager.getColor("Panel.background"));
        jTextArea.setFocusable(false);
        return jTextArea;
    }

    private void initCardPanel() {
        this.mIDTable = new IdentifierTable(this.mBuilderFrame);
        this.mIDTable.addMouseListener(new ContextMouseListener());
        this.mIDTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CanvasObject canvasObject;
                int n = SyntaxDiagramDlg.this.mIDTable.getSelectedRow();
                if (n != -1 && (canvasObject = SyntaxDiagramDlg.this.getAllCanvasObjects().get(n)) != null) {
                    SyntaxDiagramDlg.this.mBuilderFrame.fireCanvasChange(canvasObject);
                }
            }
        });
        this.mNewFeatureCards = new JPanel(new CardLayout());
        ImageIcon imageIcon = new ImageIcon(BuilderResUtil.getImageResource("arrowleft.png"));
        this.mLeftArrowButton = new JButton(imageIcon);
        this.mLeftArrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SyntaxDiagramDlg.this.arrowButtonClicked(true);
            }
        });
        ImageIcon imageIcon2 = new ImageIcon(BuilderResUtil.getImageResource("arrowright.png"));
        this.mRightArrowButton = new JButton(imageIcon2);
        this.mRightArrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SyntaxDiagramDlg.this.arrowButtonClicked(false);
            }
        });
        this.mLeftArrowButton.getAccessibleContext().setAccessibleName(BuilderResUtil.getString("TXT_LEFT_ARROW_MESSAGE"));
        this.mRightArrowButton.getAccessibleContext().setAccessibleName(BuilderResUtil.getString("TXT_RIGHT_ARROW_MESSAGE"));
        this.mLeftArrowButton.setPreferredSize(new Dimension(18, 18));
        this.mRightArrowButton.setPreferredSize(new Dimension(18, 18));
        this.initWNCards();
        this.mActiveWNIndex = 0;
        this.mMesgPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder("");
        this.mMesgPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mMesgPanel, this.mLeftArrowButton, gridBagConstraints, 0, 0, 1, 1, 17, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMesgPanel, this.mNewFeatureCards, gridBagConstraints, 1, 0, 1, 1, 10, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mMesgPanel, this.mRightArrowButton, gridBagConstraints, 2, 0, 1, 1, 13, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMesgPanel, new JLabel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mMoveToNewButton = new JButton(new MoveToNewAction());
    }

    public JPanel getTemplatePanel() {
        JLabel jLabel = BuilderUtil.getInstance().getAppType() == AppType.STATS ? new JLabel(BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM")) : new JLabel(BuilderResUtil.getString("IDS_SCRIPT_DIAGRAM"));
        JSeparator jSeparator = new JSeparator();
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(6, 4, 1, 2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 22;
        insets.set(4, 4, 4, 6);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMoveToNewButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        Border border = BorderFactory.createEtchedBorder(1);
        jPanel.setBorder(border);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 4, 1, 2);
        DialogUtil.addUsingGBL(jPanel2, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, 2, 1, 2);
        JPanel jPanel3 = this.getViewPanel();
        jLabel.setLabelFor(jPanel3);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.setupPanelTabComp();
        return jPanel2;
    }

    private void initWNCardsTab() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = (Insets)DialogUtil.getStandardButtonInsets().clone();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = insets;
        this.mMesgPanel = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.top = 2;
        String string = BuilderUtil.getInstance().getAppType() == AppType.STATS ? BuilderResUtil.getString("IDS_SYNTAX_DIALOG_TIP_DESC_1") : BuilderResUtil.getString("IDS_SCRIPT_DIALOG_TIP_DESC_1");
        TipInfoPanel tipInfoPanel = new TipInfoPanel(string);
        tipInfoPanel.setPreferredSize(new Dimension(480, 80));
        JScrollPane jScrollPane = new JScrollPane(tipInfoPanel);
        jScrollPane.setPreferredSize(new Dimension(480, 80));
        String string2 = BuilderUtil.getInstance().getAppType() == AppType.STATS ? BuilderResUtil.getString("IDS_SYNTAX_DIALOG_TIP_DESC_2") : BuilderResUtil.getString("IDS_SCRIPT_DIALOG_TIP_DESC_2");
        TipInfoPanel tipInfoPanel2 = new TipInfoPanel(string2);
        tipInfoPanel2.setPreferredSize(new Dimension(480, 80));
        JScrollPane jScrollPane2 = new JScrollPane(tipInfoPanel2);
        jScrollPane2.setPreferredSize(new Dimension(480, 80));
        String string3 = BuilderUtil.getInstance().getAppType() == AppType.STATS ? BuilderResUtil.getString("IDS_SYNTAX_DIALOG_TIP_DESC_3") : BuilderResUtil.getString("IDS_SCRIPT_DIALOG_TIP_DESC_3");
        TipInfoPanel tipInfoPanel3 = new TipInfoPanel(string3);
        tipInfoPanel3.setPreferredSize(new Dimension(480, 80));
        JScrollPane jScrollPane3 = new JScrollPane(tipInfoPanel3);
        jScrollPane3.setPreferredSize(new Dimension(480, 80));
        this.mNewFeatureCards.add((Component)jScrollPane, String.valueOf(0));
        this.mNewFeatureCards.add((Component)jScrollPane2, String.valueOf(1));
        this.mNewFeatureCards.add((Component)jScrollPane3, String.valueOf(2));
        this.mNewFeatureCards.setPreferredSize(new Dimension(480, 80));
        this.mNewFeatureCards.setMinimumSize(new Dimension(480, 70));
    }

    private void initWNCards() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = (Insets)DialogUtil.getStandardButtonInsets().clone();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = insets;
        this.mMesgPanel = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.top = 2;
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        String string = BuilderUtil.getInstance().getAppType() == AppType.STATS ? BuilderResUtil.getString("IDS_SYNTAX_DIALOG_TIP_DESC_1") : BuilderResUtil.getString("IDS_SCRIPT_DIALOG_TIP_DESC_1");
        JTextArea jTextArea = this.createStaticMultiLineLabel(string);
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 2;
        jPanel.add((Component)jTextArea, gridBagConstraints2);
        jPanel.setPreferredSize(new Dimension(480, 80));
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setPreferredSize(new Dimension(480, 80));
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        String string2 = BuilderUtil.getInstance().getAppType() == AppType.STATS ? BuilderResUtil.getString("IDS_SYNTAX_DIALOG_TIP_DESC_2") : BuilderResUtil.getString("IDS_SCRIPT_DIALOG_TIP_DESC_2");
        JTextArea jTextArea2 = this.createStaticMultiLineLabel(string2);
        jPanel2.add((Component)jTextArea2, gridBagConstraints2);
        jPanel2.setPreferredSize(new Dimension(480, 80));
        JScrollPane jScrollPane2 = new JScrollPane(jPanel2);
        jScrollPane2.setPreferredSize(new Dimension(480, 80));
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        String string3 = BuilderUtil.getInstance().getAppType() == AppType.STATS ? BuilderResUtil.getString("IDS_SYNTAX_DIALOG_TIP_DESC_3") : BuilderResUtil.getString("IDS_SCRIPT_DIALOG_TIP_DESC_3");
        JTextArea jTextArea3 = this.createStaticMultiLineLabel(string3);
        jPanel3.add((Component)jTextArea3, gridBagConstraints2);
        jPanel3.setPreferredSize(new Dimension(480, 80));
        JScrollPane jScrollPane3 = new JScrollPane(jPanel3);
        jScrollPane3.setPreferredSize(new Dimension(480, 80));
        this.mNewFeatureCards.add((Component)jScrollPane, String.valueOf(0));
        this.mNewFeatureCards.add((Component)jScrollPane2, String.valueOf(1));
        this.mNewFeatureCards.add((Component)jScrollPane3, String.valueOf(2));
        this.mNewFeatureCards.setPreferredSize(new Dimension(480, 80));
        this.mNewFeatureCards.setMinimumSize(new Dimension(480, 70));
    }

    private void arrowButtonClicked(boolean bl) {
        int n;
        this.mActiveWNIndex = n = this.getWNNextIndex(bl, this.mActiveWNIndex);
        this.showCard(n);
    }

    private int getWNNextIndex(boolean bl, int n) {
        int n2;
        int n3 = this.mNewFeatureCards.getComponentCount();
        int n4 = n2 = bl ? --n : ++n;
        if (n2 > n3 - 1) {
            n2 = 0;
        } else if (n2 < 0) {
            n2 = n3 - 1;
        }
        return n2;
    }

    public void showCard(int n) {
        CardLayout cardLayout = (CardLayout)this.mNewFeatureCards.getLayout();
        cardLayout.show(this.mNewFeatureCards, String.valueOf(n));
        this.mActiveWNIndex = n;
    }

    private void createControlsNew() {
        JSplitPane jSplitPane;
        URL uRL;
        JPanel jPanel = this.getViewPanel();
        this.initCardPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardButtonInsets().clone();
        String string = this.getEscapeSequence();
        this.mTipCheck = new JCheckBox(BuilderResUtil.getString("IDS_SYNTAX_TEMPLATE_TIPS"));
        URL uRL2 = BuilderResUtil.getImageResource("more.png");
        if (uRL2 != null) {
            this.mTipCheck.setIcon(new ImageIcon(uRL2));
        }
        if ((uRL = BuilderResUtil.getImageResource("more_selected.png")) != null) {
            this.mTipCheck.setSelectedIcon(new ImageIcon(uRL));
            this.mTipCheck.setRolloverEnabled(false);
        }
        int n = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTipCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mMesgPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mTipCheck.setSelected(false);
        this.mMesgPanel.setVisible(false);
        this.mLeftArrowButton.setVisible(false);
        this.mRightArrowButton.setVisible(false);
        int n2 = 340;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.mSyntaxMasterPanel.setPreferredSize(new Dimension(480, n2));
        this.mFooterText = this.createStaticMultiLineLabel(BuilderResUtil.getString("IDS_ID_TABLE_FOOTER_TEXT"));
        this.mFooterText.setVisible(false);
        JScrollPane jScrollPane = new JScrollPane(this.mIDTable);
        jScrollPane.setPreferredSize(new Dimension(480, 100));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, 2, 1, 2);
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, 10, 6, 2);
        DialogUtil.addUsingGBL(jPanel2, this.mFooterText, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, 2, 1, 6);
        if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
            this.mTabbedPane = new JTabbedPane();
            this.mTabbedPane.addTab(BuilderResUtil.getString("IDS_SCRIPT_TITLE"), (Component)this.mSyntaxMasterPanel);
            this.mTabbedPane.addTab(BuilderResUtil.getString("IDS_SCORE_TITLE"), (Component)this.mScoreMasterPanel);
            jSplitPane = new JSplitPane(0, this.mTabbedPane, jPanel2);
            if (!this.mBuilderFrame.getDialogDefinition().canScore()) {
                this.mScoreMasterPanel.getSyntaxTextPane().setEnabled(false);
            }
        } else {
            JScrollPane jScrollPane2 = new JScrollPane((Component)this.mSyntaxMasterPanel);
            jScrollPane2.setPreferredSize(new Dimension(480, n2));
            jScrollPane2.setMinimumSize(new Dimension(480, 60));
            jSplitPane = new JSplitPane(0, jScrollPane2, jPanel2);
        }
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setDividerLocation(340);
        jSplitPane.setPreferredSize(new Dimension(480, 460));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, 2, 8, 2);
        DialogUtil.addUsingGBL(jPanel, jSplitPane, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mTipCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (SyntaxDiagramDlg.this.mTipCheck.isSelected()) {
                    SyntaxDiagramDlg.this.mMesgPanel.setVisible(true);
                    SyntaxDiagramDlg.this.mLeftArrowButton.setVisible(true);
                    SyntaxDiagramDlg.this.mRightArrowButton.setVisible(true);
                    SyntaxDiagramDlg.this.setFocusTraversalPolicy(true);
                    SyntaxDiagramDlg.this.setupPanelTabComp();
                } else {
                    SyntaxDiagramDlg.this.mMesgPanel.setVisible(false);
                    SyntaxDiagramDlg.this.mLeftArrowButton.setVisible(false);
                    SyntaxDiagramDlg.this.mRightArrowButton.setVisible(false);
                    SyntaxDiagramDlg.this.setFocusTraversalPolicy(false);
                    SyntaxDiagramDlg.this.setupPanelTabComp();
                }
            }
        });
        this.setupActions();
    }

    private void setFocusTraversalPolicy(boolean bl) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTipCheck);
        if (bl) {
            vector.add(this.mLeftArrowButton);
            vector.add(this.mMesgPanel);
            vector.add(this.mRightArrowButton);
        }
        vector.add(this.mSyntaxMasterPanel.getSyntaxTextPane());
        vector.add(this.mIDTable);
        vector.add(this.mRestoreButton);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false, true);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupPanelTabComp() {
        this.mComponentVector = new Vector();
        this.mComponentVector.add(this.mMoveToNewButton);
        this.mComponentVector.add(this.mTipCheck);
        this.mComponentVector.add(this.mLeftArrowButton);
        this.mComponentVector.add(this.mMesgPanel);
        this.mComponentVector.add(this.mRightArrowButton);
        this.mComponentVector.add(this.mSyntaxMasterPanel.getSyntaxTextPane());
        this.mComponentVector.add(this.mIDTable);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        if (this.mMesgKey.length() > 0) {
            this.mOkButton = new JButton(new OkAction());
            this.mCancelButton = new JButton(new CancelAction());
            this.mHelpButton = new JButton(new HelpAction());
            DialogUtil.setupMacHelpButton(this.mHelpButton);
            if (bl) {
                jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
                int n = insets.left + insets.right;
                if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                    jPanel.setLayout(new GridBagLayout());
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    Insets insets2 = new Insets(0, n, 0, 0);
                    int n2 = 23;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.fill = 2;
                    DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
                    n2 = 24;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 0;
                    DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                    gridBagConstraints.fill = 2;
                    DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
                } else {
                    FlowLayout flowLayout = new FlowLayout(1, n, 0);
                    jPanel.setLayout(flowLayout);
                    jPanel.add(this.mOkButton);
                    jPanel.add(this.mCancelButton);
                    jPanel.add(this.mHelpButton);
                }
            } else {
                jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
                int n = insets.top + insets.bottom;
                BoxLayout boxLayout = new BoxLayout(jPanel, 1);
                jPanel.setLayout(boxLayout);
                jPanel.add(Box.createVerticalStrut(n * 2));
                jPanel.add(this.mOkButton);
                jPanel.add(Box.createVerticalStrut(n));
                jPanel.add(this.mCancelButton);
                jPanel.add(Box.createVerticalStrut(n));
                jPanel.add(this.mHelpButton);
                jPanel.add(Box.createVerticalStrut(n));
            }
            this.getRootPane().setDefaultButton(this.mOkButton);
        } else {
            this.mRestoreButton = new JButton(new RestoreToPanelAction());
            if (bl) {
                jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
                int n = insets.left + insets.right;
                if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                    jPanel.setLayout(new GridBagLayout());
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    Insets insets3 = new Insets(0, n, 0, 0);
                    int n3 = 23;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.fill = 2;
                    DialogUtil.addUsingGBL(jPanel, this.mRestoreButton, gridBagConstraints, 2, 0, 1, 1, n3, insets3);
                } else {
                    FlowLayout flowLayout = new FlowLayout(1, n, 0);
                    jPanel.setLayout(flowLayout);
                    jPanel.add(this.mRestoreButton);
                }
            } else {
                jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
                int n = insets.top + insets.bottom;
                BoxLayout boxLayout = new BoxLayout(jPanel, 1);
                jPanel.setLayout(boxLayout);
                jPanel.add(Box.createVerticalStrut(n * 2));
                jPanel.add(this.mRestoreButton);
            }
            this.getRootPane().setDefaultButton(this.mRestoreButton);
        }
        return jPanel;
    }

    private void enableControls() {
    }

    private boolean validateInput() {
        if (this.mScoreMasterPanel != null) {
            return this.validateScript();
        }
        String string = this.getSyntax();
        Vector vector = new Vector();
        if (string != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (stringBuffer.indexOf(ESCAPE_SEQUENCE) < 0) {
                return true;
            }
            int n = string.length();
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            int n4 = 0;
            n4 = 0;
            int n5 = 0;
            while (n4 >= 0 && n4 < n) {
                String string2;
                if ((n4 = stringBuffer.indexOf(ESCAPE_SEQUENCE, n4)) <= -1) continue;
                n3 = n4 + 2;
                n2 = 0;
                char c = stringBuffer.charAt(n3);
                while (n3 >= 0 && c == '%') {
                    ++n2;
                    if (++n3 >= n) break;
                    c = stringBuffer.charAt(n3);
                }
                int n6 = n2 + 2;
                n5 = stringBuffer.indexOf(ESCAPE_SEQUENCE, n3 + 1);
                if (n5 == -1) {
                    n5 = stringBuffer.length();
                }
                if (this.mControlIDs.indexOf(string2 = stringBuffer.subSequence(n3, n5).toString()) < 0 && this.mBuilderFrame.getCanvas().findCanvasObject(string2) == null) {
                    return false;
                }
                n4 = n5 + 2;
            }
        }
        return true;
    }

    private boolean validateScript() {
        String string = this.getSyntax();
        Matcher matcher = this.pattern.matcher(string);
        if (!this.hasControl(matcher)) {
            return false;
        }
        if (this.mScoreMasterPanel.getSyntaxTextPane().isEnabled()) {
            matcher = this.pattern.matcher(this.getScoreScript());
            return this.hasControl(matcher);
        }
        return true;
    }

    private boolean hasControl(Matcher matcher) {
        while (matcher.find()) {
            String string = matcher.group();
            if (this.mControlIDs.indexOf(string = string.replaceAll(ESCAPE_SEQUENCE, "")) >= 0 || this.mBuilderFrame.getCanvas().findCanvasObject(string) != null) continue;
            return false;
        }
        return true;
    }

    public void doHelp() {
        this.mCallback.showHelp();
    }

    public String getSyntax() {
        String string = this.mSyntaxMasterPanel.getMainSpssSyntaxTextPane().getText();
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
            string = string.substring(0, string.length() - 1);
        }
        string = string.replaceAll("(\\r|\\n|\\r\\n)", "\\\\n");
        return string;
    }

    public String getScoreScript() {
        String string = this.mScoreMasterPanel.getMainSpssSyntaxTextPane().getText();
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
            string = string.substring(0, string.length() - 1);
        }
        string = string.replaceAll("(\\r|\\n|\\r\\n)+", "\\\\n");
        return string;
    }

    protected boolean canDispose() {
        return !this.mIsIdPopupVisible;
    }

    private void showIdPopup() {
        JTextPane jTextPane = this.getSyntaxMasterPanel().getSyntaxTextPane();
        Point point = jTextPane.getCaret().getMagicCaretPosition();
        if (point == null) {
            point = new Point(0, 0);
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (String string : this.mControlIDs) {
            jPopupMenu.add(new InsertIdAction(string));
        }
        jPopupMenu.addPopupMenuListener(this);
        jPopupMenu.show(jTextPane, point.x + 4, point.y);
    }

    private void doTableContextMenu(MouseEvent mouseEvent) {
        if (BuilderUtil.getInstance().getAppType() == AppType.MODELER && this.mTabbedPane != null && this.mTabbedPane.getSelectedIndex() == 1 && !this.mBuilderFrame.getDialogDefinition().canScore()) {
            return;
        }
        int n = this.mIDTable.rowAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n < this.mIDTable.getRowCount()) {
            this.mIDTable.setRowSelectionInterval(n, n);
        } else {
            this.mIDTable.clearSelection();
        }
        int n2 = this.mIDTable.getSelectedRow();
        if (n2 < 0) {
            return;
        }
        this.mBuilderFrame.fireCanvasChange(this.getAllCanvasObjects().get(n2));
        String string = this.mIDTable.getValueAt(n2, 0).toString();
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new TableInsertIdAction(string));
        jPopupMenu.addPopupMenuListener(this);
        jPopupMenu.show(this.mIDTable, mouseEvent.getX(), mouseEvent.getY());
    }

    private void doContextMenu(MouseEvent mouseEvent) {
        JTextPane jTextPane = this.getSyntaxMasterPanel().getSyntaxTextPane();
        jTextPane.requestFocus();
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string = jTextPane.getSelectedText();
        boolean bl = string != null && string.length() > 0;
        DefaultEditorKit.CutAction cutAction = new DefaultEditorKit.CutAction();
        cutAction.putValue("Name", UIToolResUtil.getString((String)"IDS_CUT"));
        cutAction.setEnabled(bl);
        jPopupMenu.add(new JMenuItem(cutAction));
        DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
        copyAction.putValue("Name", UIToolResUtil.getString((String)"IDS_COPY"));
        copyAction.setEnabled(bl);
        jPopupMenu.add(new JMenuItem(copyAction));
        DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
        pasteAction.putValue("Name", UIToolResUtil.getString((String)"IDS_PASTE"));
        pasteAction.setEnabled(this.isFlavorAvailable(DataFlavor.stringFlavor));
        jPopupMenu.add(new JMenuItem(pasteAction));
        Action action = jTextPane.getActionMap().get(UIToolResUtil.getString((String)"IDS_DELETE"));
        jPopupMenu.add(new JMenuItem(action));
        jPopupMenu.add(new JSeparator());
        Action action2 = jTextPane.getActionMap().get(UIToolResUtil.getString((String)"IDS_SELECTALL"));
        jPopupMenu.add(new JMenuItem(action2));
        jPopupMenu.show(jTextPane, mouseEvent.getX(), mouseEvent.getY());
    }

    private SyntaxMasterPanel getSyntaxMasterPanel() {
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            return this.mSyntaxMasterPanel;
        }
        if (this.mTabbedPane != null && this.mTabbedPane.getSelectedIndex() == 1) {
            return this.mScoreMasterPanel;
        }
        return this.mSyntaxMasterPanel;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.mIsIdPopupVisible = false;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.mIsIdPopupVisible = false;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.mIsIdPopupVisible = true;
    }

    public String getEscapeSequence() {
        return ESCAPE_SEQUENCE;
    }

    public boolean isFlavorAvailable(DataFlavor dataFlavor) {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (transferable == null) {
            return false;
        }
        return transferable.isDataFlavorSupported(dataFlavor);
    }

    private String replaceNewlinChar(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        String string2 = "";
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = 0;
        while (n3 >= 0 && n3 < n2 && (n = string.indexOf(34, n3)) >= 0) {
            vector.add(n);
            n3 = n + 1;
        }
        if (vector.size() > 0) {
            Vector<String> vector2 = new Vector<String>();
            int n4 = 0;
            int n5 = (Integer)vector.get(n4);
            if (n5 > 0) {
                vector2.add(string.substring(0, n5));
            }
            int n6 = (Integer)vector.get(vector.size() - 1);
            while (n4 < vector.size() - 1) {
                n5 = (Integer)vector.get(n4);
                if (n5 > n6 + 1) {
                    vector2.add(string.substring(n6 + 1, n5));
                }
                n6 = (Integer)vector.get(++n4);
                ++n4;
                vector2.add(string.substring(n5, n6 + 1));
            }
            if (n6 < n2 - 1) {
                vector2.add(string.substring(n6 + 1));
            }
            Vector<String> vector3 = new Vector<String>();
            for (String string3 : vector2) {
                if (!string3.startsWith("\"")) {
                    String string4 = string3.replaceAll("\\\\n", "\n");
                    vector3.add(string4);
                    continue;
                }
                vector3.add(string3);
            }
            for (String string3 : vector3) {
                string2 = string2 + string3;
            }
        } else {
            string2 = string.replaceAll("\\\\n", "\n");
        }
        return string2;
    }

    public class TipInfoPanel
    extends JPanel {
        private JTextArea mInfoDesc;

        public TipInfoPanel(String string) {
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.initLayout(string);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    TipInfoPanel.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    TipInfoPanel.this.repaint();
                }
            });
        }

        protected void initLayout(String string) {
            this.mInfoDesc = new JTextArea();
            this.mInfoDesc.setOpaque(false);
            this.mInfoDesc.setFont(this.getFont());
            this.mInfoDesc.setLineWrap(true);
            this.mInfoDesc.setWrapStyleWord(true);
            this.mInfoDesc.setText("");
            this.mInfoDesc.setFocusable(false);
            this.setHelpText(string);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 23;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            DialogUtil.addUsingGBL(this, this.mInfoDesc, gridBagConstraints, 0, 0, 1, 1, n, null);
        }

        private void setHelpText(String string) {
            this.mInfoDesc.setText(string);
            this.mInfoDesc.setEnabled(true);
            this.getAccessibleContext().setAccessibleName(this.mInfoDesc.getText());
            this.getAccessibleContext().setAccessibleDescription(this.mInfoDesc.getText());
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.hasFocus()) {
                this.paintFocus(graphics);
            }
        }

        public void paintFocus(Graphics graphics) {
            Color color = UIManager.getColor("ToggleButton.focus");
            graphics.setColor(color);
            Rectangle rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
            BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public static interface SyntaxDiagramDlgCallback {
        public void syntaxModifiedNotification();

        public void showHelp();

        public boolean showInvalidSyntaxWarning();
    }

    class DeletePrevWordAction
    extends AbstractAction {
        DeletePrevWordAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int n;
                JTextPane jTextPane = SyntaxDiagramDlg.this.mSyntaxMasterPanel.getSyntaxTextPane();
                int n2 = SyntaxDiagramDlg.this.mSyntaxMasterPanel.getLineStartDocOffset(SyntaxDiagramDlg.this.mSyntaxMasterPanel.getLineNumberFromPos(n));
                int n3 = n;
                for (n = jTextPane.getCaretPosition(); n > n2 && Character.isWhitespace(jTextPane.getText(n - 1, 1).charAt(0)); --n) {
                }
                while (n > n2 && !Character.isWhitespace(jTextPane.getText(n - 1, 1).charAt(0))) {
                    --n;
                }
                if (n3 != n) {
                    Document document = jTextPane.getDocument();
                    document.remove(n, n3 - n);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    class CtrlUpDownAction
    extends AbstractAction {
        private boolean mIsUp;

        public CtrlUpDownAction(boolean bl) {
            this.mIsUp = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextPane jTextPane = SyntaxDiagramDlg.this.mSyntaxMasterPanel.getSyntaxTextPane();
            int n = jTextPane.getCaretPosition();
            int n2 = SyntaxDiagramDlg.this.mSyntaxMasterPanel.getLineNumberFromPos(n);
            int n3 = this.mIsUp ? (n2 > 0 ? n2 - 1 : n2) : (n2 < SyntaxDiagramDlg.this.mSyntaxMasterPanel.getLineCount() - 1 ? n2 + 1 : n2);
            int n4 = SyntaxDiagramDlg.this.mSyntaxMasterPanel.getLineStartDocOffset(n3);
            jTextPane.setCaretPosition(n4);
        }
    }

    class ContextMouseListener
    extends MouseAdapter {
        ContextMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (mouseEvent.isPopupTrigger()) {
                if (object instanceof JTextComponent) {
                    mouseEvent.consume();
                    SyntaxDiagramDlg.this.doContextMenu(mouseEvent);
                } else if (object instanceof JTable) {
                    mouseEvent.consume();
                    SyntaxDiagramDlg.this.doTableContextMenu(mouseEvent);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof JTable) {
                int n = SyntaxDiagramDlg.this.mIDTable.getSelectedRow();
                if (n < 0) {
                    return;
                }
                CanvasObject canvasObject = SyntaxDiagramDlg.this.getAllCanvasObjects().get(n);
                boolean bl = SyntaxDiagramDlg.this.mBuilderFrame.fireCanvasChange(canvasObject);
            }
            if (mouseEvent.isPopupTrigger()) {
                if (object instanceof JTextComponent) {
                    mouseEvent.consume();
                    SyntaxDiagramDlg.this.doContextMenu(mouseEvent);
                } else if (object instanceof JTable) {
                    mouseEvent.consume();
                    SyntaxDiagramDlg.this.doTableContextMenu(mouseEvent);
                }
            }
        }
    }

    class TableInsertIdAction
    extends AbstractAction {
        private String mId;

        TableInsertIdAction(String string) {
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                this.putValue("Name", BuilderResUtil.getString("Add_to_syntax_template"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("Add_to_script_template"));
            }
            this.mId = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextPane jTextPane = SyntaxDiagramDlg.this.getSyntaxMasterPanel().getSyntaxTextPane();
            int n = jTextPane.getCaretPosition();
            if (n > -1) {
                String string = SyntaxDiagramDlg.this.getEscapeSequence();
                jTextPane.replaceSelection(string + this.mId + string + " ");
            }
        }
    }

    class InsertIdAction
    extends AbstractAction {
        private String mId;

        InsertIdAction(String string) {
            super(string);
            this.mId = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextPane jTextPane = SyntaxDiagramDlg.this.getSyntaxMasterPanel().getSyntaxTextPane();
            int n = jTextPane.getCaretPosition();
            if (n > -1) {
                String string = SyntaxDiagramDlg.this.getEscapeSequence();
                jTextPane.replaceSelection(string + this.mId + string + " ");
            }
        }
    }

    class IdMenuKeyListener
    extends KeyAdapter {
        IdMenuKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32 && !SyntaxDiagramDlg.this.mIsIdPopupVisible) {
                int n = 128;
                if ((keyEvent.getModifiersEx() & n) == n) {
                    keyEvent.consume();
                    SyntaxDiagramDlg.this.showIdPopup();
                }
            } else if (keyEvent.getKeyCode() == 27 && SyntaxDiagramDlg.this.mIsIdPopupVisible) {
                keyEvent.consume();
            }
        }
    }

    class RestoreToPanelAction
    extends AbstractAction {
        RestoreToPanelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_RESTORE_TO_MAIN"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxDiagramDlg.this.doClose(true);
        }
    }

    class MoveToNewAction
    extends AbstractAction {
        MoveToNewAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_MOVE_TO_NEW_WINDOW"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxDiagramDlg.this.doClose(false);
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxDiagramDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxDiagramDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            if (!SyntaxDiagramDlg.this.validateInput() && (bl = SyntaxDiagramDlg.this.mCallback.showInvalidSyntaxWarning())) {
                return;
            }
            SyntaxDiagramDlg.this.mModalResult = true;
            SyntaxDiagramDlg.this.mCallback.syntaxModifiedNotification();
            SyntaxDiagramDlg.this.mBuilderFrame.setModified(true);
            SyntaxDiagramDlg.this.dispose();
        }
    }
}

