/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder;

import com.spss.shared.custom_gui.ui_builder.BuilderFrame;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.Util.DialogUtil;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.SpssMultiLineLabel;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.ui_builder.definition.AppType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class OpenDeployedDlg
extends BaseDialog {
    private static final String SPEPKG_FILE_EXT = ".spe";
    private static final String MPEPKG_FILE_EXT = ".mpe";
    private String mSpecName = "";
    private String mSpecPath = "";
    private String mDeployPath = "";
    private JList mList;
    private SpssMultiLineLabel mWarningLabel;
    private OkAction mOkAction;
    BuilderFrame mOwner;
    HashMap<String, String> mLocalExtensionDetailInfos = null;

    public static String doOpenDeployedDlg(BuilderFrame builderFrame, String string) {
        OpenDeployedDlg openDeployedDlg = new OpenDeployedDlg(builderFrame, string);
        openDeployedDlg.setVisible(true);
        if (openDeployedDlg.getSpecName().length() == 0) {
            return null;
        }
        String string2 = openDeployedDlg.getSPEFilePath(openDeployedDlg.getSpecName());
        if (string2 != null) {
            return string2;
        }
        String string3 = openDeployedDlg.getSpecPath();
        String string4 = string3 == null || string3.length() == 0 ? (BuilderUtil.getInstance().getAppType() == AppType.STATS && builderFrame.IsCompatibleMode() ? BuilderUtil.getInstance().getAppdataCustomDialogDirectoryForAllUsers() + File.separator + openDeployedDlg.getSpecName() : BuilderUtil.getInstance().getExtensionPath() + File.separator + openDeployedDlg.getSpecName() + ".cfe") : string3 + File.separator + openDeployedDlg.getSpecName();
        return string4;
    }

    public static String doRemoveDeployedDlg(BuilderFrame builderFrame, String string) {
        OpenDeployedDlg openDeployedDlg = new OpenDeployedDlg(builderFrame, string);
        openDeployedDlg.setVisible(true);
        if (openDeployedDlg.getSpecName().length() == 0) {
            return null;
        }
        String string2 = openDeployedDlg.getSPEFilePath(openDeployedDlg.getSpecName());
        if (string2 != null) {
            return string2;
        }
        String string3 = BuilderUtil.getInstance().getAppType() == AppType.STATS && builderFrame.IsCompatibleMode() ? openDeployedDlg.getDeployPath() : openDeployedDlg.getSpecPath();
        String string4 = string3 == null || string3.length() == 0 ? (BuilderUtil.getInstance().getAppType() == AppType.STATS && builderFrame.IsCompatibleMode() ? BuilderUtil.getInstance().getUIExtensionsFolderPath() + File.separator + openDeployedDlg.getSpecName() : BuilderUtil.getInstance().getExtensionPath() + File.separator + openDeployedDlg.getSpecName()) : string3 + File.separator + openDeployedDlg.getSpecName();
        return string4;
    }

    OpenDeployedDlg(BuilderFrame builderFrame, String string) {
        super((JFrame)builderFrame, string, true, BuilderResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), Locale.getDefault()), BuilderResBundle.getImageFolder());
        this.mOwner = builderFrame;
        this.initialize();
        this.pack();
        this.setLocationRelativeTo(builderFrame);
        if (this.mList.getModel().getSize() > 0) {
            this.mList.setSelectedIndex(0);
        } else {
            this.mOkAction.setEnabled(false);
        }
    }

    public void doHelp() {
    }

    protected void initialize() {
        JPanel jPanel = this.getViewPanel();
        Dimension dimension = new Dimension(220, 160);
        this.mWarningLabel = new SpssMultiLineLabel("", null, dimension.width);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        String string = BuilderResUtil.getString("IDS_DEPLOYED_DIALOGS");
        Integer n = BuilderResUtil.getAccessKey("IDK_DEPLOYED_DIALOGS");
        if (!this.mOwner.IsCompatibleMode()) {
            string = BuilderResUtil.getString("IDS_DEPLOYED_EXTENSIONS");
            n = BuilderResUtil.getAccessKey("IDK_DEPLOYED_EXTENSIONS");
        }
        JLabel jLabel = new JLabel(string);
        jLabel.setDisplayedMnemonic(n);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Vector<DeployedItem> vector = this.loadData();
        this.mList = new JList<DeployedItem>(vector);
        this.mList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.mList);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        jLabel.setLabelFor(this.mList);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.mWarningLabel, gridBagConstraints);
        jScrollPane.setPreferredSize(dimension);
        this.mList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1 && OpenDeployedDlg.this.mList.getSelectedValue() != null) {
                    new OkAction().actionPerformed(null);
                }
            }
        });
        jScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                OpenDeployedDlg.this.mWarningLabel.setMaxWidth(OpenDeployedDlg.this.mList.getWidth() + 10);
            }
        });
    }

    private Vector<DeployedItem> loadData() {
        Object[] objectArray;
        Vector<Object> vector = new Vector<DeployedItem>();
        if (this.mOwner.IsCompatibleMode()) {
            objectArray = BuilderUtil.getInstance().getSecondaryExtensionFolders();
            for (String string : objectArray) {
                this.addFromPath(vector, new File(string), true);
            }
            String string = BuilderUtil.getInstance().getAppdataCustomDialogDirectoryForAllUsers();
            if (string != null) {
                File file = new File(string);
                this.addFromPath(vector, file, false);
            }
            if (System.getProperty("os.name", "Windows").toLowerCase().startsWith("win")) {
                File file = new File(BuilderUtil.getInstance().getAppdataCustomDialogDirectory());
                if (!file.exists()) {
                    file.mkdirs();
                }
                this.addFromPath(vector, file, false);
                File file2 = new File(BuilderUtil.getInstance().getUIExtensionsFolderPath());
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                this.addFromPath(vector, file2, false);
            } else {
                File file = new File(BuilderUtil.getInstance().getUIExtensionsFolderPath());
                if (!file.exists()) {
                    file.mkdirs();
                }
                this.addFromPath(vector, file, false);
            }
        } else {
            this.loadInstalledExtensionDetailInfos(vector);
        }
        if (this.hasDuplicates(vector)) {
            this.mWarningLabel.setText(BuilderResUtil.getString("IDS_ASTERISK_DESC"));
        }
        objectArray = new DeployedItem[vector.size()];
        vector.toArray(objectArray);
        Arrays.sort(objectArray, new ItemComparator());
        vector = new Vector<Object>(Arrays.asList(objectArray));
        return vector;
    }

    private boolean hasDuplicates(Vector<DeployedItem> vector) {
        for (DeployedItem deployedItem : vector) {
            if (!deployedItem.isDuplicate()) continue;
            return true;
        }
        return false;
    }

    private void addFromPath(Vector<DeployedItem> vector, File file, boolean bl) {
        File[] fileArray;
        String string = bl ? file.getAbsolutePath() : "";
        for (File file2 : fileArray = file.listFiles()) {
            DeployedItem deployedItem = null;
            if (!file2.isDirectory()) {
                if (!BuilderUtil.getInstance().isCfeFile(file2)) continue;
                String string2 = file2.getName();
                string2 = string2.substring(0, string2.lastIndexOf("."));
                deployedItem = new DeployedItem(string2, string, this.hasSpecName(vector, string2), "");
            } else if (BuilderUtil.getInstance().isClefFolder(file2)) {
                deployedItem = new DeployedItem(file2.getName(), string, this.hasSpecName(vector, file2.getName()), file.getAbsolutePath());
            }
            if (deployedItem == null) continue;
            vector.add(deployedItem);
        }
    }

    private boolean hasSpecName(Vector<DeployedItem> vector, String string) {
        for (DeployedItem deployedItem : vector) {
            if (!deployedItem.getSpecName().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOkAction = new OkAction();
        JButton jButton = new JButton(this.mOkAction);
        JButton jButton2 = new JButton(new CancelAction());
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                int n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    private String getSpecName() {
        return this.mSpecName;
    }

    private String getSpecPath() {
        return this.mSpecPath;
    }

    private String getDeployPath() {
        return this.mDeployPath;
    }

    private String getSPEFilePath(String string) {
        if (this.mLocalExtensionDetailInfos != null) {
            return this.mLocalExtensionDetailInfos.get(string);
        }
        return null;
    }

    private void loadInstalledExtensionDetailInfos(Vector<DeployedItem> vector) {
        this.mLocalExtensionDetailInfos = new HashMap();
        ArrayList<String> arrayList = BuilderUtil.getInstance().getExtensionBundlePath();
        if (arrayList == null) {
            return;
        }
        for (String string : arrayList) {
            File file = new File(string);
            File[] fileArray = file.listFiles();
            if (fileArray == null) continue;
            for (File file2 : fileArray) {
                if (!file2.isDirectory()) continue;
                this.addExtensionDetailInfo(file2, vector);
            }
        }
    }

    private void addExtensionDetailInfo(File file, Vector<DeployedItem> vector) {
        File[] fileArray = file.listFiles(new EXT_PACKAGE_FilenameFiler());
        if (fileArray != null && fileArray.length > 0) {
            String string = file.getName();
            for (File file2 : fileArray) {
                String string2 = file2.getName().substring(0, file2.getName().indexOf("."));
                if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                    Object object;
                    boolean bl = string2.equals(string);
                    if (!bl) {
                        object = string2.replaceAll(" ", "_");
                        bl = ((String)object).equals(string);
                    }
                    if (!bl) continue;
                    this.mLocalExtensionDetailInfos.put(string2, file2.getAbsolutePath());
                    object = new DeployedItem(string2, "", false, file.getAbsolutePath());
                    vector.add((DeployedItem)object);
                    break;
                }
                this.mLocalExtensionDetailInfos.put(string, file2.getAbsolutePath());
                DeployedItem deployedItem = new DeployedItem(string, "", false, file.getAbsolutePath());
                vector.add(deployedItem);
                break;
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OpenDeployedDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DeployedItem deployedItem = (DeployedItem)OpenDeployedDlg.this.mList.getSelectedValue();
            OpenDeployedDlg.this.mSpecName = deployedItem.getSpecName();
            OpenDeployedDlg.this.mSpecPath = deployedItem.getSpecPath();
            OpenDeployedDlg.this.mDeployPath = deployedItem.getDeployedPath();
            OpenDeployedDlg.this.dispose();
        }
    }

    class ItemComparator
    implements Comparator<DeployedItem> {
        ItemComparator() {
        }

        @Override
        public int compare(DeployedItem deployedItem, DeployedItem deployedItem2) {
            String string = deployedItem.getSpecName();
            if (deployedItem.getSpecPath() != null && deployedItem.getSpecPath().length() > 0) {
                string = string + " [" + deployedItem.getSpecPath() + "]";
            }
            String string2 = deployedItem2.getSpecName();
            if (deployedItem2.getSpecPath() != null && deployedItem2.getSpecPath().length() > 0) {
                string2 = string2 + " [" + deployedItem2.getSpecPath() + "]";
            }
            return string.compareTo(string2);
        }
    }

    class DeployedItem {
        private String mSpecName;
        private String mSpecPath;
        private boolean mIsDuplicate;
        private String mDeployedPath;

        DeployedItem(String string, String string2, boolean bl, String string3) {
            this.mSpecName = string;
            this.mSpecPath = string2;
            this.mIsDuplicate = bl;
            this.mDeployedPath = string3;
        }

        public boolean isDuplicate() {
            return this.mIsDuplicate;
        }

        public String getSpecName() {
            return this.mSpecName;
        }

        public String getSpecPath() {
            return this.mSpecPath;
        }

        public String getDeployedPath() {
            return this.mDeployedPath;
        }

        public String toString() {
            String string = this.mIsDuplicate ? "* " : "";
            string = string + this.mSpecName;
            if (this.mSpecPath != null && this.mSpecPath.length() > 0) {
                string = string + " [" + this.mSpecPath + "]";
            }
            return string;
        }
    }

    public static class EXT_PACKAGE_FilenameFiler
    implements FilenameFilter {
        @Override
        public boolean accept(File file, String string) {
            return string.endsWith(BuilderUtil.getInstance().getAppType() == AppType.STATS ? OpenDeployedDlg.SPEPKG_FILE_EXT : OpenDeployedDlg.MPEPKG_FILE_EXT);
        }
    }
}

