/*
 * Decompiled with CFR 0.152.
 */
package com.spss.shared.custom_gui.ui_builder;

import com.pasw.framework.common.PaswException;
import com.pasw.ui.common.FeatureUI;
import com.spss.shared.custom_gui.ui_builder.BaseDialogExecutor;
import com.spss.shared.custom_gui.ui_builder.OpenDeployedDlg;
import com.spss.shared.custom_gui.ui_builder.RemoveDeployedQueryDlg;
import com.spss.shared.custom_gui.ui_builder.ScriptDiagramDlg;
import com.spss.shared.custom_gui.ui_builder.SyntaxDiagramDlg;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.CDBAppInfo;
import com.spss.shared.custom_gui.ui_builder.app.PrefsMgr;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertDialog;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.BuilderAlertPane;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.ConvertToEnhancedAlertDlg;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.DialogFocusTraversalPolicy;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.ExtensionSelectDlgAlert;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.MinimizeWindowsAction;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.MissingAddOnsDlg;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.ThinMenuBarBorder;
import com.spss.shared.custom_gui.ui_builder.app.UIComponents.WindowMenuAction;
import com.spss.shared.custom_gui.ui_builder.app.fopen.RemoteFileChooser;
import com.spss.shared.custom_gui.ui_builder.canvas.BuilderCanvas;
import com.spss.shared.custom_gui.ui_builder.canvas.CanvasObject;
import com.spss.shared.custom_gui.ui_builder.canvas.DraggableTabbedPane;
import com.spss.shared.custom_gui.ui_builder.canvas.RadioGroupObject;
import com.spss.shared.custom_gui.ui_builder.canvas.SrcListObject;
import com.spss.shared.custom_gui.ui_builder.canvas.StaticCtrlObject;
import com.spss.shared.custom_gui.ui_builder.canvas.StaticImageObject;
import com.spss.shared.custom_gui.ui_builder.canvas.SubDlgButtonObject;
import com.spss.shared.custom_gui.ui_builder.canvas.TabComponent;
import com.spss.shared.custom_gui.ui_builder.canvas.TabObject;
import com.spss.shared.custom_gui.ui_builder.canvas.TextAreaCtrlObject;
import com.spss.shared.custom_gui.ui_builder.extension.ExtensionPropertyContainer;
import com.spss.shared.custom_gui.ui_builder.extension.ExtensionPropertyDlg;
import com.spss.shared.custom_gui.ui_builder.preview.PreviewDialog;
import com.spss.shared.custom_gui.ui_builder.props_ui.ITabOrderListener;
import com.spss.shared.custom_gui.ui_builder.props_ui.PropertiesPanel;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResBundle;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.shared.custom_gui.ui_builder.tools.ToolItem;
import com.spss.shared.custom_gui.ui_builder.tools.ToolPalette;
import com.spss.shared.custom_gui.ui_builder.tools.ToolType;
import com.spss.shared.syntaxeditor.SyntaxCommand;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.ui_builder.SpecificationBuilder;
import com.spss.uitools.ui_builder.SpecificationWriter;
import com.spss.uitools.ui_builder.definition.AddOnType;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.CommandLocation;
import com.spss.uitools.ui_builder.definition.ControlCondition;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.ui_builder.definition.PanelDefinition;
import com.spss.uitools.ui_builder.definition.PanelElementDefinition;
import com.spss.uitools.ui_builder.definition.RadioGroupDefinition;
import com.spss.uitools.ui_builder.definition.RadioItemDefinition;
import com.spss.uitools.ui_builder.definition.SrcListDefinition;
import com.spss.uitools.ui_builder.definition.StaticCtrlDefinition;
import com.spss.uitools.ui_builder.definition.SubDlgButtonDefinition;
import com.spss.uitools.util.TraceSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class BuilderFrame
extends JFrame
implements MenuListener,
ITabOrderListener {
    private static final String UIPKG_FILE_EXT = ".spd";
    private static final String CFPKG_FILE_EXT = ".cfd";
    private static final String CFPKG_EXTENSION = "cfd";
    private static final String SPDXPKG_FILE_EXT = ".spdx";
    private static final String SPDXPKG_EXTENSION = "spdx";
    private static final String SPEPKG_FILE_EXT = ".spe";
    private static final String MPEPKG_FILE_EXT = ".mpe";
    private static final String XML_FILE_EXT = ".xml";
    private static final String CFE_FILE_EXT = ".cfe";
    private static final String EXT_FILE_NAME = "extension.xml";
    private static final String APP_EXT_FILE_NAME = "app-extension.xml";
    private static final String PROVIDER_NAME = "spss";
    private static int sMainSplitPosition = 350;
    private static int sSubSplitPosition = 300;
    private static int sToolPaletteHight = 620;
    private static Rectangle sLastBounds = null;
    private static String sExtensionVersion = "1.0.0";
    private static String sMinStatsVersion = "24";
    private static String sMinModelerVersion = "18";
    private static int sDefaultMenuOffset = 1000;
    private String mOpenSpecName = "";
    private File mSPDPath = null;
    private File mSPEPath = null;
    private DragPane mDragPane;
    private ToolPalette mToolPalette;
    private JPanel mToolPalettePanel;
    private JScrollPane mToolPalettePane;
    private JSplitPane mLeftSplitPane;
    private JToolBar mToolbar;
    private JPanel mTBPanelNorth;
    private DialogDefinition mDialog;
    private DraggableTabbedPane mTabbedPane;
    private PropertiesPanel mPropsPanel;
    private JButton mToolBarSaveButton;
    private SaveAction mSaveAction;
    private JMenuItem mMenuSaveItem;
    private JMenuItem mConvertToItem;
    private JButton mConvertButton;
    private boolean mIsModified = false;
    private JCheckBoxMenuItem mViewToolboxMenuItem;
    private JCheckBoxMenuItem mViewToolbarMenuItem;
    private JCheckBoxMenuItem mHeaderFooterMenuItem = null;
    private JSplitPane mSplitPane;
    private JScrollPane mCanvasScrollPane;
    private JSplitPane mMainSplitPane;
    private Vector<MRUSpec> mMRUSpecs = new Vector();
    private BaseDialogExecutor mDlgExecutor = null;
    private boolean mIsCompatibleMode;
    private boolean mIsTabbedDlg;
    private boolean mIsConverted = false;
    private File mExtensionFile;
    private File mAppExtFile;
    private BuilderCanvas mCanvas;
    private BuilderCanvas mHeaderCanvas;
    private BuilderCanvas mFooterCanvas;
    private ScriptDiagramDlg mModelerScriptTemplateDlg;
    private SyntaxDiagramDlg mSyntaxTemplateDlg;
    private JPanel mSyntaxTemplatePanel;
    private JScrollPane mSyntaxTemplatePane;
    private SyntaxDiagramAction mSyntaxTemplateAction;
    static int sCounter = 0;
    private JMenu mEditMenu;
    private JMenu mExtensionMenu;
    private JMenu mExtEditMenu;
    private JMenu mExtConvertMenu;
    private boolean mConvertMenuVisible;
    private ExtensionPropertyContainer mExtensionContainer = null;
    private String mDefaultExtName;
    private Vector<String> mEditCFEFiles;
    private Hashtable<String, CommandLocation> mExsitingMenuLoc;
    private static final String[] sPropFiles = new String[]{"_de", "_es", "_fr", "_it", "_ja", "_ko", "_pl", "_pt_BR", "_ru", "_zh_CN", "_zh_TW"};
    private static final String PROP_FILE_EXT = ".properties";
    private static final String HTM_FILE_EXT = ".htm";
    private static final String HTML_FILE_EXT = ".html";
    private Hashtable<String, String> mSpdNameDlgID;

    public BuilderFrame(CDBAppInfo cDBAppInfo) throws HeadlessException {
        this(cDBAppInfo, null);
    }

    public BuilderFrame(CDBAppInfo cDBAppInfo, DialogDefinition dialogDefinition) throws HeadlessException {
        if (cDBAppInfo != null) {
            this.mIsCompatibleMode = cDBAppInfo.isInCompatibleMode();
            this.mIsTabbedDlg = cDBAppInfo.isTabbed();
        } else if (dialogDefinition != null) {
            this.mIsCompatibleMode = dialogDefinition.IsCompatMode();
            this.mIsTabbedDlg = dialogDefinition.IsTabbedDlg();
        } else {
            this.mIsCompatibleMode = BuilderUtil.getInstance().isInCompatibleMode();
            this.mIsTabbedDlg = BuilderUtil.getInstance().isTabbed();
        }
        if (dialogDefinition != null && dialogDefinition.isSubDialog()) {
            this.mIsTabbedDlg = false;
        }
        if (cDBAppInfo != null) {
            BuilderUtil.getInstance().setAppInfo(cDBAppInfo);
        }
        BuilderResUtil.setLocale(BuilderUtil.getInstance().getAppLocale());
        this.updateTitle(dialogDefinition);
        this.setIconImage(new ImageIcon(BuilderResUtil.getImageResource("uibuilder16.png")).getImage());
        if (this.mIsCompatibleMode) {
            this.setup(dialogDefinition, false);
        } else if (this.mIsTabbedDlg) {
            this.setup(dialogDefinition, true);
        } else {
            this.setup(dialogDefinition, false);
        }
        this.setDefaultCloseOperation(0);
        this.pack();
        this.updateToolbarButtons();
        if (dialogDefinition == null) {
            this.setLocationRelativeTo(null);
            if (sLastBounds != null) {
                this.setBounds(sLastBounds);
            }
            this.mToolPalette.reposition(this);
        }
        if (dialogDefinition != null && dialogDefinition.isSubDialog()) {
            this.mToolPalette.enableButton(ToolType.SOURCE_VAR_LIST, false);
            this.mToolPalette.enableButton(ToolType.TARGET_VAR_LIST, false);
            this.mToolPalette.enableButton(ToolType.SUB_DIALOG_BUTTON, false);
            this.mToolPalette.enableButton(ToolType.DIALOG_TAB_CONTROL, false);
        }
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS && this.mIsCompatibleMode) {
            this.enableNewFeatures(false);
        }
        if (dialogDefinition == null) {
            this.setVisible(true);
            this.mToolPalettePanel.setVisible(true);
            this.focusToolPalette();
        }
        if (this.getDialogDefinition() != null && !this.getDialogDefinition().isSubDialog()) {
            this.getDialogDefinition().setBuilderFrame((JFrame)this);
        }
        this.addWindowListener();
        this.setupTraversalPolicy();
    }

    private void setupTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        int n = this.mToolbar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.mToolbar.getComponentAtIndex(i);
            if (!(object instanceof JButton)) continue;
            vector.add(object);
        }
        vector.add(this.mToolPalette);
        vector.add(this.mCanvas);
        vector.add(this.mPropsPanel.getPropTable());
        if (this.mSyntaxTemplateDlg != null && this.mSyntaxTemplateDlg.getTabTravConponent() != null) {
            for (Object object : this.mSyntaxTemplateDlg.getTabTravConponent()) {
                vector.add(object);
            }
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false, true);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void enableNewFeatures(boolean bl) {
        this.mToolPalette.enableButton(ToolType.FIELD_CHOOSER_CONTROL, bl);
        this.mToolPalette.enableButton(ToolType.SPINNER_CONTROL, bl);
        this.mToolPalette.enableButton(ToolType.PASSWORD_CONTROL, bl);
        this.mToolPalette.enableButton(ToolType.COLOR_PICKER_CONTROL, bl);
        this.mToolPalette.enableButton(ToolType.TABLE_CONTROL, bl);
        this.mToolPalette.enableButton(ToolType.DIALOG_TAB_CONTROL, bl);
        this.mToolPalette.enableButton(ToolType.DATASET_SELECTOR, bl);
    }

    private void updateConvertedState() {
        BuilderUtil.getInstance().setCompabibleMode(false);
        BuilderUtil.getInstance().setTabbed(false);
        this.mDialog.setTabbed(false);
        this.mIsCompatibleMode = false;
        this.mDialog.setIsCompatMode(this.mIsCompatibleMode);
        this.getCanvas().fireSelectionChange(null);
        this.enableNewFeatures(true);
        if (this.mConvertToItem != null) {
            this.mConvertToItem.setEnabled(false);
        }
        if (this.mConvertButton != null) {
            this.mConvertButton.setEnabled(false);
        }
        this.updateTitle(this.mDialog);
        this.mExtensionMenu.setVisible(true);
        Component[] componentArray = this.getCanvas().getComponents();
        if (componentArray[0] instanceof TextAreaCtrlObject) {
            this.getCanvas().removeObject((TextAreaCtrlObject)componentArray[0]);
        }
        if (this.getCanvas().getComponentCount() == 0) {
            this.getCanvas().createTextAreaObject();
            this.mMenuSaveItem.setEnabled(false);
            this.mToolBarSaveButton.setEnabled(false);
            this.mIsModified = false;
        } else {
            this.mMenuSaveItem.setEnabled(true);
            this.mToolBarSaveButton.setEnabled(true);
            this.mIsModified = true;
        }
        this.mOpenSpecName = "";
        this.mSPDPath = null;
    }

    public void showEditor(Component component) {
        this.setLocationRelativeTo(component);
        this.mToolPalette.reposition(this);
        this.setVisible(true);
        this.mToolPalettePanel.setVisible(true);
        this.focusToolPalette();
    }

    public ArrayList<SyntaxCommand> getSyntaxCommand() {
        ArrayList<Object> arrayList;
        ArrayList<Object> arrayList2 = arrayList = BuilderUtil.getInstance().getStatsSyntaxCommands();
        return arrayList2;
    }

    public void insertRadioButtonSubElement(RadioGroupObject radioGroupObject, CanvasObject canvasObject, int n, Point point) {
        radioGroupObject.insertSubElement(canvasObject, n, point);
        if (this.mSyntaxTemplateDlg != null) {
            this.mSyntaxTemplateDlg.addControlID(canvasObject);
        }
    }

    public void addNewCanvasObject(CanvasObject canvasObject) {
        if (this.mSyntaxTemplateDlg != null) {
            if (canvasObject instanceof SrcListObject || canvasObject instanceof StaticCtrlObject || canvasObject instanceof StaticImageObject || canvasObject instanceof SubDlgButtonObject) {
                return;
            }
            this.mSyntaxTemplateDlg.addControlID(canvasObject);
            if (this.mSyntaxTemplateAction != null) {
                this.mSyntaxTemplateAction.addControlID(canvasObject);
            }
        } else if (this.getDialogDefinition().isSubDialog() && this.getDialogDefinition().getParentDefinition().getBuilderFrame() != null) {
            ((BuilderFrame)this.getDialogDefinition().getParentDefinition().getBuilderFrame()).addNewCanvasObject(canvasObject);
        }
    }

    private void resetCurrentSyntaxDlg() {
        if (this.mSyntaxTemplateDlg != null) {
            this.mSyntaxTemplateDlg.resetID();
            this.mSyntaxTemplateDlg.setSyntax("");
            if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
                this.mSyntaxTemplateDlg.setScoreScript("");
            }
            if (this.mSyntaxTemplateAction != null) {
                this.mSyntaxTemplateAction.resetID();
            }
        }
    }

    public void removeCanvasObject(CanvasObject canvasObject) {
        if (this.mSyntaxTemplateDlg != null) {
            this.mSyntaxTemplateDlg.removeControlID(canvasObject);
            if (this.mSyntaxTemplateAction != null) {
                this.mSyntaxTemplateAction.removeControlID(canvasObject);
            }
        } else if (this.getDialogDefinition().isSubDialog() && this.getDialogDefinition().getParentDefinition().getBuilderFrame() != null) {
            ((BuilderFrame)this.getDialogDefinition().getParentDefinition().getBuilderFrame()).removeCanvasObject(canvasObject);
        }
    }

    public void removeCanvasObject(String string) {
        if (this.mSyntaxTemplateDlg != null) {
            this.mSyntaxTemplateDlg.removeControlID(string);
            if (this.mSyntaxTemplateAction != null) {
                this.mSyntaxTemplateAction.removeControlID(string);
            }
        } else if (this.getDialogDefinition().isSubDialog() && this.getDialogDefinition().getParentDefinition().getBuilderFrame() != null) {
            ((BuilderFrame)this.getDialogDefinition().getParentDefinition().getBuilderFrame()).removeCanvasObject(string);
        }
    }

    public void removePanelFromTemplate(PanelDefinition panelDefinition) {
        int n = panelDefinition.getElementCount();
        for (int i = 0; i < n; ++i) {
            PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
            if (panelElementDefinition instanceof SubDlgButtonDefinition) {
                this.removePanelFromTemplate(((SubDlgButtonDefinition)panelElementDefinition).getDialogDefinition().getCurrentPanel());
            }
            this.removeCanvasObject(panelElementDefinition.getControlId());
        }
    }

    public void updateCanvasObject(CanvasObject canvasObject, String string, String string2, String string3) {
        if (this.mSyntaxTemplateDlg != null) {
            this.mSyntaxTemplateDlg.updateCanvasObject(canvasObject, string, string2, string3);
        } else if (this.getDialogDefinition().isSubDialog() && this.getDialogDefinition().getParentDefinition().getBuilderFrame() != null) {
            ((BuilderFrame)this.getDialogDefinition().getParentDefinition().getBuilderFrame()).updateCanvasObject(canvasObject, string, string2, string3);
        }
    }

    public void insertControlSyntax(String string) {
        if (this.mSyntaxTemplateDlg != null) {
            if (this.mSyntaxTemplateAction != null) {
                this.mSyntaxTemplateAction.insertControlID(string);
            } else {
                this.mSyntaxTemplateDlg.insertControlSyntax(string);
            }
        } else if (this.getDialogDefinition().isSubDialog() && this.getDialogDefinition().getParentDefinition().getBuilderFrame() != null) {
            ((BuilderFrame)this.getDialogDefinition().getParentDefinition().getBuilderFrame()).insertControlSyntax(string);
        }
    }

    public void setDlgExecutor(BaseDialogExecutor baseDialogExecutor) {
        this.mDlgExecutor = baseDialogExecutor;
    }

    public BaseDialogExecutor getDlgExecutor() {
        return this.mDlgExecutor;
    }

    public static String getBuilderPkgExtension() {
        return CFPKG_EXTENSION;
    }

    public static String getBuilderSPDExpension() {
        return UIPKG_FILE_EXT;
    }

    public void runMenuLocationDlg() {
        if (this.mDlgExecutor != null && BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            this.mDlgExecutor.showDialogMenuLocation(this, this.mDialog.getCommandLocation(), this.getCanvas(), this.mPropsPanel.getSelectedObject());
        }
    }

    public void hideSyntaxTemplatePanel() {
        this.mSyntaxTemplatePanel.setVisible(false);
        this.mSyntaxTemplatePane.setVisible(false);
        this.mMainSplitPane.setPreferredSize(this.mLeftSplitPane.getPreferredSize());
        this.pack();
        this.mMainSplitPane.setDividerLocation(1.0);
        this.editSyntaxTemplate();
    }

    public void showSyntaxTemplatePanel(String string) {
        this.showSyntaxTemplatePanel(string, "");
    }

    public void showSyntaxTemplatePanel(String string, String string2) {
        this.mSyntaxTemplateDlg.setSyntax(string);
        this.mSyntaxTemplateDlg.setScoreScript(string2);
        this.mSyntaxTemplatePanel.setVisible(true);
        this.mSyntaxTemplatePane.setVisible(true);
        this.mMainSplitPane.setPreferredSize(new Dimension(1240, sToolPaletteHight));
        this.pack();
        this.mMainSplitPane.setDividerLocation(700);
        this.mSyntaxTemplateAction = null;
    }

    public void setSyntaxFromSpec(String string) {
        if (this.mSyntaxTemplateDlg != null) {
            this.mSyntaxTemplateDlg.setSyntax(string);
        }
    }

    public void setDialogSyntax() {
        if (this.mSyntaxTemplateDlg == null) {
            return;
        }
        this.getDialogDefinition().setDialogSyntax(this.mSyntaxTemplateDlg.getSyntax());
        if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
            this.getDialogDefinition().setRScoringScript(this.mSyntaxTemplateDlg.getScoreScript());
        }
    }

    public boolean fireCanvasChange(CanvasObject canvasObject) {
        boolean bl = this.getDialogDefinition().getCurrentPanel().containsControl(canvasObject.getCtrlDef().getControlId(), false);
        if (bl) {
            canvasObject.setSelected(true);
            this.getCanvas().fireSelectionChange(canvasObject);
            return true;
        }
        Object object = this.getDialogDefinition().getSubDlgButtonFromCurrentPanel(canvasObject.getControlId());
        if (object != null) {
            CanvasObject canvasObject2 = this.getCanvas().getCanvasObject(object.getControlId());
            this.fireCanvasChange(canvasObject2);
            return true;
        }
        if (this.mIsTabbedDlg) {
            PanelDefinition panelDefinition;
            int n;
            object = this.getDialogDefinition().getPanels();
            for (n = 0; n < ((LinkedList)object).size(); ++n) {
                panelDefinition = (PanelDefinition)((LinkedList)object).get(n);
                if (!panelDefinition.containsControl(canvasObject.getCtrlDef().getControlId())) continue;
                this.selectedTabIndex(n);
                canvasObject.setSelected(true);
                this.getCanvas().fireSelectionChange(canvasObject);
                return true;
            }
            for (n = 0; n < ((LinkedList)object).size(); ++n) {
                panelDefinition = (PanelDefinition)((LinkedList)object).get(n);
                SubDlgButtonDefinition subDlgButtonDefinition = panelDefinition.findSubButtonFromPanel(canvasObject.getControlId());
                if (subDlgButtonDefinition == null) continue;
                this.selectedTabIndex(n);
                CanvasObject canvasObject3 = this.getCanvas().getCanvasObject(subDlgButtonDefinition.getControlId());
                this.fireCanvasChange(canvasObject3);
                return true;
            }
        }
        this.getCanvas().repaint();
        return false;
    }

    public static String getBuilderSPDXExpension() {
        return SPDXPKG_FILE_EXT;
    }

    public static String getSPEExpension() {
        return SPEPKG_FILE_EXT;
    }

    public boolean isModified() {
        return this.mIsModified;
    }

    public boolean canvasIsEmpty() {
        boolean bl = true;
        if (this.mDialog != null && this.mDialog.getCurrentPanel().getElementCount() > 0) {
            bl = false;
        }
        return bl;
    }

    public boolean isConverted() {
        return this.mIsConverted;
    }

    public boolean IsCompatibleMode() {
        return this.mIsCompatibleMode;
    }

    public boolean isTabbedDlg() {
        return this.mIsTabbedDlg;
    }

    public boolean showHeaderFooter() {
        return this.mHeaderFooterMenuItem != null && this.mHeaderFooterMenuItem.isSelected();
    }

    public void setModified(boolean bl) {
        this.mIsModified = bl;
        this.updateToolbarButtons();
        this.updateTitle(this.mDialog);
    }

    public void openSPDFile(File file) throws Exception {
        this.readPackageFile(file, true);
        this.addMRUItem(file.getName(), file.getPath(), false);
        this.setModified(false);
    }

    public void openCFDFile(File file) throws Exception {
        this.resetCurrentSyntaxDlg();
        this.readPackageFile(file, false);
        this.mSPDPath = null;
        this.addMRUItem(file.getName(), file.getPath(), false);
        this.setModified(false);
    }

    private boolean openSPEFile(File file) {
        boolean bl = false;
        try {
            boolean[] blArray = new boolean[1];
            String string = this.processSPEFile(file.getAbsolutePath(), blArray);
            if (string.length() > 0) {
                Component[] componentArray = this.getCanvas().getComponents();
                if (componentArray.length == 1 && componentArray[0] instanceof TextAreaCtrlObject) {
                    this.getCanvas().removeObject((TextAreaCtrlObject)componentArray[0]);
                }
                this.mSPDPath = new File(string);
                String string2 = this.mSPDPath.getName();
                String string3 = this.mSPDPath.getParent();
                if (blArray[0]) {
                    this.mIsCompatibleMode = true;
                }
                this.resetCurrentSyntaxDlg();
                this.readPackageFile(this.mSPDPath, blArray[0]);
                if (blArray[0]) {
                    this.mIsConverted = true;
                    this.updateConvertedState();
                }
                this.mOpenSpecName = string2.substring(0, string2.lastIndexOf("."));
                if (blArray[0]) {
                    this.mSpdNameDlgID = new Hashtable();
                    if (!this.mOpenSpecName.equals(this.mDialog.getDialogId())) {
                        this.mSpdNameDlgID.put(this.mOpenSpecName, this.mDialog.getDialogId());
                        this.mOpenSpecName = this.mDialog.getDialogId();
                    }
                    this.mSPDPath = new File(string3 + File.separator + this.mOpenSpecName + CFE_FILE_EXT);
                    this.mExtensionContainer.addOneCFEfileName(this.mOpenSpecName + CFE_FILE_EXT);
                    this.mExtensionContainer.addCFEfileWithPath(this.mSPDPath.getAbsolutePath());
                    this.mConvertMenuVisible = false;
                    this.setModified(true);
                    this.updateExtensionMenu(this.mOpenSpecName, this.mSPDPath.getAbsolutePath());
                    bl = true;
                } else {
                    bl = true;
                    this.setModified(false);
                }
            } else {
                this.mSPDPath = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processSPEFile(String string, boolean[] blArray) {
        Object object;
        String string2;
        Object object2;
        TreeMap<String, String> treeMap;
        String string3;
        String string4;
        block17: {
            string4 = "";
            string3 = "";
            this.mExtensionContainer = new ExtensionPropertyContainer(string);
            this.mExtensionContainer.setTargetFilePath("");
            Set<String> set = this.mExtensionContainer.getDialogSpecsSet();
            treeMap = new TreeMap<String, String>();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next().toString();
                if (((String)object2).endsWith(CFE_FILE_EXT)) {
                    treeMap.put((String)object2, (String)object2);
                    if (string4.length() != 0) continue;
                    string4 = object2;
                    continue;
                }
                if (!((String)object2).endsWith(UIPKG_FILE_EXT)) continue;
                string3 = object2;
            }
            if (treeMap.size() <= 1) break block17;
            object2 = BuilderResUtil.getString("IDS_EXTENSION_PROPERTY_SELECT_DLG_MESG");
            string2 = BuilderResUtil.getString("IDS_EXTENSION_PROPERTY_SELECT_DLG_TITLE");
            object = BuilderResUtil.getImageResource("infodotNew.png");
            ImageIcon imageIcon = null;
            if (object != null) {
                imageIcon = new ImageIcon((URL)object);
            }
            ExtensionSelectDlgAlert extensionSelectDlgAlert = new ExtensionSelectDlgAlert((JFrame)this, (String)object2, string2, imageIcon, treeMap);
            extensionSelectDlgAlert.setVisible(true);
            if (extensionSelectDlgAlert.getButtonPressedValue() == 0) {
                string4 = extensionSelectDlgAlert.getCfeFilePath();
                break block17;
            }
            String string5 = string4 = "";
            return string5;
        }
        try {
            if (string4.length() > 0) {
                if (!string4.contains(File.separator)) {
                    string4 = this.mExtensionContainer.getTempNameDirectory().getPath() + File.separator + string4;
                }
                blArray[0] = false;
            } else if (string3.length() > 0) {
                object2 = BuilderResUtil.getString("IDS_EXTENSION_PROPERTY_CONVERT_ALERT_DLG_MESG");
                string2 = BuilderResUtil.getString("IDS_EXTENSION_PROPERTY_CONVERT_ALERT_DLG_TITLE");
                object = new SPDConvertToEnhancedAlertDlg(this, (String)object2, string2);
                object.setVisible(true);
                string3 = this.mExtensionContainer.getTempNameDirectory().getPath() + File.separator + string3;
                blArray[0] = true;
                if (((BuilderAlertDialog)((Object)object)).getButtonPressedValue() == 0) {
                    string4 = string3;
                } else if (this.mDialog != null && this.mDialog.getCurrentPanel().getElementCount() > 0) {
                    this.doReset();
                }
            }
            if (treeMap.size() > 0 || string3.length() > 0) {
                object2 = new File(string4);
                this.updateExtensionMenu(((File)object2).getName(), ((File)object2).getAbsolutePath());
            }
        }
        catch (IOException iOException) {}
        return string4;
    }

    private void newPropertyContainer() {
        if (this.mExtensionContainer != null) {
            this.mExtensionContainer = new ExtensionPropertyContainer();
            this.mExtensionContainer.setVersion(sExtensionVersion);
            this.mExtensionContainer.setStatsVersion(this.getMinimunAppVersion());
        }
        if (this.mExtEditMenu != null) {
            this.mExtEditMenu.removeAll();
            this.mExtEditMenu.setVisible(false);
        }
        if (this.mExtConvertMenu != null) {
            this.mExtConvertMenu.removeAll();
            this.mExtConvertMenu.setVisible(false);
            this.mConvertMenuVisible = true;
        }
        if (this.mEditCFEFiles != null) {
            this.mEditCFEFiles.removeAllElements();
        }
        if (this.mExsitingMenuLoc != null) {
            this.mExsitingMenuLoc.clear();
        }
    }

    private String updateCurrentCfe(boolean bl) {
        boolean bl2 = this.saveCurrentToCfe(true);
        String string = this.mOpenSpecName;
        if (string == null || string.length() == 0) {
            return "";
        }
        if (!string.endsWith(CFE_FILE_EXT)) {
            string = string + CFE_FILE_EXT;
        }
        if (bl2 && !this.mExtensionContainer.isDialogExist(string)) {
            this.mExtensionContainer.addCFEfileWithPath(this.mSPDPath.getAbsolutePath());
            this.mExtensionContainer.addOneCFEfileName(string);
            this.mExtensionContainer.setModified(true);
        }
        if (bl) {
            this.updateExtensionMenu(this.mOpenSpecName, this.mSPDPath.getAbsolutePath());
        }
        return string;
    }

    public static boolean isValidHtmFile(String string, String string2) {
        boolean bl = false;
        for (String string3 : sPropFiles) {
            String string4 = string2 + string3 + HTM_FILE_EXT;
            String string5 = string2 + string3 + HTML_FILE_EXT;
            if (!string.equals(string4) && !string.equals(string5)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isValidResFile(String string, String string2) {
        boolean bl = false;
        for (String string3 : sPropFiles) {
            String string4 = string2 + string3 + PROP_FILE_EXT;
            if (!string.equals(string4)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void checkLanguageFile(DialogDefinition dialogDefinition) {
        String string = dialogDefinition.getDialogId() + CFE_FILE_EXT;
        if (this.mExtensionContainer == null) {
            return;
        }
        String string2 = this.mExtensionContainer.getCDBTranfolder(string);
        if (string2 == null || string2.length() == 0) {
            return;
        }
        File[] fileArray = new File(string2).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            ByteBuffer byteBuffer;
            String string3;
            File file = fileArray[i];
            if (!file.isFile() || !file.exists() || !BuilderFrame.isValidResFile(string3 = file.getName(), dialogDefinition.getDialogId()) || (byteBuffer = SpecificationBuilder.loadFile((File)file)) == null) continue;
            dialogDefinition.removeLanguageResource(string3);
            dialogDefinition.addLanguageResource(string3, byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean saveCurrentToCfe(boolean bl) {
        boolean bl2 = true;
        if (this.mExtensionContainer == null) {
            this.mExtensionContainer = new ExtensionPropertyContainer();
            this.mExtensionContainer.setVersion(sExtensionVersion);
            this.mExtensionContainer.setStatsVersion(this.getMinimunAppVersion());
        }
        if (!this.isModified()) {
            return bl2;
        }
        this.mPropsPanel.commitEdits();
        this.checkLanguageFile(this.mDialog);
        DialogDefinition dialogDefinition = (DialogDefinition)this.mDialog.clone();
        String string = this.mExtensionContainer.getTempNameDirectory().getAbsolutePath();
        String string2 = "";
        if (this.mSPDPath == null) {
            if (this.mOpenSpecName == null || this.mOpenSpecName == "") {
                string2 = string + File.separator + dialogDefinition.getDialogId() + CFE_FILE_EXT;
                this.mSPDPath = new File(string2);
                this.mOpenSpecName = dialogDefinition.getDialogId();
            } else {
                string2 = string + File.separator + this.mOpenSpecName + CFE_FILE_EXT;
                this.mSPDPath = new File(string2);
            }
        } else {
            string2 = this.mSPDPath.getAbsolutePath();
            if (!string2.endsWith(CFE_FILE_EXT)) {
                string2 = this.mSPDPath.getAbsolutePath() + CFE_FILE_EXT;
            }
        }
        try {
            if (!this.mSPDPath.exists() && !this.mSPDPath.createNewFile()) {
                throw new Exception("Error creating deployment file");
            }
            SpecificationWriter specificationWriter = new SpecificationWriter(dialogDefinition);
            if (!this.writeCfeFile(string2, specificationWriter)) {
                throw new Exception(this.makeErrorText(specificationWriter));
            }
            if (!bl) return bl2;
        }
        catch (Exception exception) {
            return false;
        }
        return bl2;
    }

    private String getMinimunAppVersion() {
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            return sMinStatsVersion;
        }
        return sMinModelerVersion;
    }

    private void doSaveSPEfile(boolean bl) {
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS && !this.mIsCompatibleMode) {
            boolean bl2;
            Object object;
            String string;
            File file = null;
            boolean bl3 = false;
            boolean bl4 = true;
            if (this.mExtensionContainer == null || this.mExtensionContainer.getName().length() == 0) {
                string = BuilderResUtil.getString("ERR_SAVE_EXTENSION_MISSING_NAME_WARNING");
                object = new String[]{BuilderResUtil.getString("IDS_YES"), BuilderResUtil.getString("IDS_NO")};
                int n = BuilderAlertPane.showOptionDialog(this, string, BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.IconType.eWarning, (Object[])object, (Object)object[1]);
                if (n == 0) {
                    if (!this.showExtensionPropertyDlg()) {
                        return;
                    }
                } else {
                    bl4 = false;
                    if (this.mExtensionContainer == null) {
                        this.mExtensionContainer = new ExtensionPropertyContainer();
                        this.mExtensionContainer.setVersion(sExtensionVersion);
                        this.mExtensionContainer.setStatsVersion(sMinStatsVersion);
                    }
                }
            }
            this.mDefaultExtName = "";
            if (this.mExtensionContainer.getName() != null) {
                this.mDefaultExtName = this.mExtensionContainer.getName();
            }
            if (bl4) {
                string = "";
                if (this.mExtensionContainer.getDialogSpecsSet().size() <= 1) {
                    string = this.mDefaultExtName;
                }
                if (!this.checkForMenuLocationSPEE(this.mDialog, false, null, string)) {
                    return;
                }
            }
            if (bl) {
                string = this.mDlgExecutor.getSaveFilePath(false, null, this.mDialog, this);
                if (string.length() == 0) {
                    return;
                }
                file = new File(string);
                this.mExtensionContainer.setSPEfile(file);
                this.mSPEPath = file;
                bl3 = false;
            }
            if (bl2 = this.saveCurrentToCfe(false)) {
                file = this.mExtensionContainer.getSPEfile();
                if (file == null || !this.mExtensionContainer.isDialogExist(this.mOpenSpecName + CFE_FILE_EXT)) {
                    this.mExtensionContainer.addCFEfileWithPath(this.mSPDPath.getAbsolutePath());
                    object = this.mOpenSpecName;
                    if (!((String)object).endsWith(CFE_FILE_EXT)) {
                        object = (String)object + CFE_FILE_EXT;
                    }
                    this.mExtensionContainer.addOneCFEfileName((String)object);
                }
                this.mExtensionContainer.createExtensionPackage(file, this, bl3);
                this.mExtensionContainer.setModified(false);
                this.setModified(false);
                this.addMRUItem(file.getName(), file.getAbsolutePath(), false);
            }
        }
    }

    private void doSaveMPEfile(boolean bl) {
        File file;
        Object object;
        String string;
        boolean bl2 = false;
        if (this.mExtensionContainer == null || this.mExtensionContainer.getName().length() == 0) {
            string = BuilderResUtil.getString("ERR_SAVE_EXTENSION_MISSING_NAME_WARNING");
            object = new String[]{BuilderResUtil.getString("IDS_YES"), BuilderResUtil.getString("IDS_NO")};
            int n = BuilderAlertPane.showOptionDialog(this, string, BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.IconType.eWarning, (Object[])object, (Object)object[1]);
            if (n == 0) {
                if (!this.showExtensionPropertyDlg()) {
                    return;
                }
            } else if (this.mExtensionContainer == null) {
                this.mExtensionContainer = new ExtensionPropertyContainer();
                this.mExtensionContainer.setVersion(sExtensionVersion);
                this.mExtensionContainer.setStatsVersion(sMinModelerVersion);
                this.mExtensionContainer.setName(this.mDialog.getDialogId());
            }
        }
        this.mDefaultExtName = "";
        if (this.mExtensionContainer.getName() != null) {
            this.mDefaultExtName = this.mExtensionContainer.getName();
        }
        if (bl) {
            string = this.getMPESavePath();
            if (string.length() == 0) {
                return;
            }
            file = new File(string);
            this.mExtensionContainer.setSPEfile(file);
            this.mSPEPath = file;
            bl2 = true;
        }
        this.mSPDPath = null;
        boolean bl3 = this.saveCurrentToCfe(false);
        if (bl3) {
            file = this.mExtensionContainer.getSPEfile();
            if (file == null || !this.mExtensionContainer.isDialogExist(this.mOpenSpecName + CFE_FILE_EXT)) {
                this.mExtensionContainer.addCFEfileWithPath(this.mSPDPath.getAbsolutePath());
                object = this.mOpenSpecName;
                if (!((String)object).endsWith(CFE_FILE_EXT)) {
                    object = (String)object + CFE_FILE_EXT;
                }
                this.mExtensionContainer.addOneCFEfileName((String)object);
            }
            this.mExtensionContainer.createExtensionPackage(file, this, bl2);
            this.mExtensionContainer.setModified(false);
            this.setModified(false);
            this.addMRUItem(file.getName(), file.getAbsolutePath(), false);
        }
    }

    public String getDefaultExtName() {
        return this.mDefaultExtName;
    }

    public void editDialogDefinition(DialogDefinition dialogDefinition) {
        this.mDialog = dialogDefinition;
        this.mPropsPanel.setDlgDef(dialogDefinition);
        if (this.mCanvas != null) {
            this.mCanvas.setDialogDefinition(dialogDefinition);
        } else {
            this.recreatePanelCanvas(this.mDialog.isSubDialog());
        }
        new LayoutAction(true).actionPerformed(null);
        this.updateTitle(dialogDefinition);
        this.setSyntaxFromSpec(this.mDialog.getDialogSyntax());
    }

    public void editCFDialogDefinition(DialogDefinition dialogDefinition) {
        this.mDialog = dialogDefinition;
        boolean bl = this.mDialog.IsTabbedDlg();
        BuilderUtil.getInstance().setTabbed(bl);
        this.mPropsPanel.setDlgDef(dialogDefinition);
        if (bl) {
            if (this.mTabbedPane == null) {
                this.recreateTabbedCanvas();
            }
            int n = this.mTabbedPane.getSelectedIndex();
            this.mTabbedPane.removeAll();
            for (int i = 0; i < dialogDefinition.getPanelCount(); ++i) {
                BuilderUtil.getInstance().openDialogTab(this, i);
                this.mTabbedPane.setSelectedIndex(i);
                new LayoutAction(true).actionPerformed(null);
            }
            if (n != -1 && this.mTabbedPane.getTabComponentAt(n) instanceof TabComponent) {
                this.activateTab((TabComponent)this.mTabbedPane.getTabComponentAt(n), n);
            }
        } else if (this.mCanvas == null) {
            this.recreatePanelCanvas(dialogDefinition.isSubDialog());
            new LayoutAction(true).actionPerformed(null);
        } else {
            this.mCanvas.setDialogDefinition(dialogDefinition);
        }
        this.updateTitle(dialogDefinition);
        this.setSyntaxFromSpec(this.mDialog.getDialogSyntax());
        if (BuilderUtil.getInstance().getAppType() == AppType.MODELER && this.mSyntaxTemplateDlg != null) {
            this.mSyntaxTemplateDlg.setScoreScript(this.mDialog.getRScoringScript());
            this.updateScoreTabStatus();
        }
        this.pack();
    }

    public void activateTab(int n) {
        this.activateTab(null, n);
    }

    public void activateTab(TabComponent tabComponent, int n) {
        this.updateDropListenerByTabIndex(n);
        this.getDialogDefinition().setCurrentPanel(n);
        if (n != -1) {
            tabComponent.fireSelectionChange(tabComponent.getTabObject());
        }
    }

    public void runMenuLocationDialog(DialogDefinition dialogDefinition) {
        this.runMenuLocationDlg();
    }

    public void editSyntaxTemplate() {
        this.mSyntaxTemplateAction = new SyntaxDiagramAction(false);
        this.mSyntaxTemplateAction.actionPerformed(null);
    }

    public DragPane getDragPane() {
        return this.mDragPane;
    }

    public BuilderCanvas getCanvas() {
        if (this.mTabbedPane != null) {
            JSplitPane jSplitPane;
            Component component;
            BuilderCanvas builderCanvas = null;
            Component component2 = this.mTabbedPane.getSelectedComponent();
            if (component2 instanceof BuilderCanvas) {
                builderCanvas = (BuilderCanvas)component2;
            } else if (component2 instanceof JSplitPane && (component = (jSplitPane = (JSplitPane)component2).getLeftComponent()) instanceof JSplitPane) {
                Component component3 = ((JSplitPane)component).getRightComponent();
                if (component3 instanceof BuilderCanvas) {
                    builderCanvas = (BuilderCanvas)component3;
                } else if (component3 instanceof JScrollPane) {
                    builderCanvas = (BuilderCanvas)((JViewport)((JScrollPane)component3).getComponent(0)).getComponent(0);
                }
            }
            if (null == builderCanvas) {
                builderCanvas = (BuilderCanvas)this.mTabbedPane.getComponentAt(0);
            }
            return builderCanvas;
        }
        return this.mCanvas;
    }

    public DialogDefinition getDialogDefinition() {
        if (this.mDialog != null) {
            return this.mDialog;
        }
        return this.mCanvas.getDialogDefinition();
    }

    public DraggableTabbedPane getTabbedPane() {
        return this.mTabbedPane;
    }

    public PropertiesPanel getmPropsPanel() {
        return this.mPropsPanel;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public void focusPropertiesPanel() {
        this.mPropsPanel.focusTable();
    }

    public void focusToolPalette() {
        ToolItem toolItem = this.mToolPalette.getSelectedTool();
        if (toolItem != null) {
            toolItem.requestFocus();
        } else {
            this.mToolPalette.selectTool(this.mToolPalette.getToolItem(ToolType.SOURCE_VAR_LIST));
        }
    }

    public void launchControlEditor(PanelElementDefinition panelElementDefinition) {
        this.mPropsPanel.launchControlEditor(panelElementDefinition);
    }

    public void recreatePanelCanvas(boolean bl) {
        this.mTabbedPane.removeAll();
        this.mDragPane.removeAllDropListener(BuilderCanvas.class);
        this.mDragPane.removeAllDropListener(DraggableTabbedPane.class);
        this.mTabbedPane = null;
        this.mIsTabbedDlg = false;
        this.createPanelCanvas(bl);
    }

    public TabObject recreateTabbedCanvas() {
        this.mDragPane.removeAllDropListener(BuilderCanvas.class);
        if (this.mCanvas != null) {
            this.mCanvas.removeSelectionListener(this.mPropsPanel);
            this.mCanvas.removeAll();
        }
        int n = -1;
        if (this.mDialog.getPanelCount() == 1 && this.mDialog.getCurrentPanel().getElementCount() == 0) {
            PanelDefinition panelDefinition = this.mDialog.getCurrentPanel();
            this.mDialog.removePanel(panelDefinition, false);
        }
        if (this.mDialog.getPanelCount() > 0) {
            n = 0;
        }
        this.mCanvas = null;
        this.mIsTabbedDlg = true;
        BuilderUtil.getInstance().setTabbed(true);
        return this.createTabbedCanvas(false, n);
    }

    public void createPanelCanvas(boolean bl) {
        this.mCanvas = new BuilderCanvas(this, this.mDialog, BuilderCanvas.CanvasType.Normal);
        this.mCanvas.setFont(new Font("SansSerif", 0, 12));
        this.mCanvas.addSelectionListener(this.mPropsPanel);
        this.mDragPane.addDropListener((IDropListener)this.mCanvas);
        JScrollPane jScrollPane = new JScrollPane(this.mCanvas);
        this.mCanvas.setPreferredSize(new Dimension(500, 400));
        this.mCanvas.setMinimumSize(new Dimension(500, 100));
        this.mHeaderCanvas = new BuilderCanvas(this, this.mDialog, BuilderCanvas.CanvasType.HeaderFooter);
        this.mHeaderCanvas.setFont(new Font("SansSerif", 0, 12));
        this.mHeaderCanvas.setPreferredSize(new Dimension(500, 50));
        this.mHeaderCanvas.setMinimumSize(new Dimension(500, 50));
        this.mHeaderCanvas.addSelectionListener(this.mPropsPanel);
        this.mDragPane.addDropListener((IDropListener)this.mHeaderCanvas);
        boolean bl2 = false;
        if (this.mHeaderFooterMenuItem != null) {
            bl2 = this.mHeaderFooterMenuItem.isSelected();
        }
        this.mHeaderCanvas.setVisible(bl2);
        JSplitPane jSplitPane = new JSplitPane(0, this.mHeaderCanvas, this.mCanvas);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.2);
        if (!bl2) {
            jSplitPane.setDividerSize(0);
        }
        this.mFooterCanvas = new BuilderCanvas(this, this.mDialog, BuilderCanvas.CanvasType.HeaderFooter);
        this.mFooterCanvas.setFont(new Font("SansSerif", 0, 12));
        this.mFooterCanvas.setPreferredSize(new Dimension(500, 50));
        this.mFooterCanvas.setMinimumSize(new Dimension(500, 50));
        this.mFooterCanvas.addSelectionListener(this.mPropsPanel);
        this.mDragPane.addDropListener((IDropListener)this.mFooterCanvas);
        this.mFooterCanvas.setVisible(bl2);
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, this.mFooterCanvas);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setResizeWeight(0.8);
        if (!bl2) {
            jSplitPane2.setDividerSize(0);
        }
        if (this.mSplitPane == null) {
            this.mSplitPane = new JSplitPane(0, jSplitPane2, this.mPropsPanel);
        } else {
            this.mSplitPane.setOneTouchExpandable(true);
            this.mSplitPane.setResizeWeight(0.667);
            this.mSplitPane.setDividerLocation(!bl ? sMainSplitPosition : sSubSplitPosition);
            this.mSplitPane.setTopComponent(jSplitPane2);
            this.mSplitPane.setPreferredSize(new Dimension(500, 500));
        }
    }

    private TabObject createTabbedCanvas(boolean bl, int n) {
        this.mTabbedPane = new DraggableTabbedPane(this);
        this.mDragPane.addDropListener((IDropListener)this.mTabbedPane);
        TabObject tabObject = null;
        if (bl) {
            if (this.mDialog.getPanelCount() == 1 && this.mDialog.getCurrentPanel().getElementCount() == 0) {
                PanelDefinition panelDefinition = this.mDialog.getCurrentPanel();
                tabObject = this.initTab(n);
                this.mDialog.removePanel(panelDefinition);
            }
        } else {
            tabObject = this.initTab(n);
        }
        this.mTabbedPane.setMinimumSize(new Dimension(500, 200));
        this.mTabbedPane.setPreferredSize(new Dimension(500, 450));
        if (this.mSplitPane == null) {
            this.mSplitPane = new JSplitPane(0, this.mTabbedPane, this.mPropsPanel);
        } else {
            this.mSplitPane.setTopComponent(this.mTabbedPane);
            this.mSplitPane.setPreferredSize(new Dimension(500, 400));
            this.mSplitPane.setOneTouchExpandable(true);
            this.mSplitPane.setResizeWeight(0.667);
            this.mSplitPane.setDividerLocation(!bl ? sMainSplitPosition : sSubSplitPosition);
        }
        return tabObject;
    }

    private void setup(DialogDefinition dialogDefinition, boolean bl) {
        boolean bl2;
        this.createMainPanel();
        this.mDragPane = new DragPane();
        this.setGlassPane((Component)this.mDragPane);
        boolean bl3 = bl2 = dialogDefinition != null && dialogDefinition.isSubDialog();
        if (!bl2 && dialogDefinition == null) {
            this.mDialog = new DialogDefinition(null, BuilderUtil.getInstance().getAppType());
            this.mDialog.setIsCompatMode(this.mIsCompatibleMode);
        } else {
            this.mDialog = dialogDefinition;
        }
        this.mPropsPanel = new PropertiesPanel(this.mDialog, this);
        if (bl) {
            this.createTabbedCanvas(bl2, -1);
        } else {
            this.createPanelCanvas(bl2);
        }
        if (!bl2) {
            this.loadMRUMenuItems();
        }
        this.createMenubar(this.mDialog);
        this.createToolbar(this.mDialog);
        this.mSplitPane.setOneTouchExpandable(true);
        this.mSplitPane.setResizeWeight(0.667);
        this.mSplitPane.setDividerLocation(!bl2 ? sMainSplitPosition : sSubSplitPosition);
        if (!bl2) {
            this.mSplitPane.setPreferredSize(new Dimension(540, 500));
        } else {
            this.mSplitPane.setPreferredSize(new Dimension(500, 400));
        }
        this.mCanvasScrollPane = new JScrollPane(this.mSplitPane);
        this.mCanvasScrollPane.setMinimumSize(new Dimension(500, 400));
        this.mToolPalette = new ToolPalette(this);
        this.mToolPalettePanel = this.mToolPalette.getToolPanel();
        this.mToolPalettePane = new JScrollPane(this.mToolPalettePanel);
        this.mToolPalettePane.setPreferredSize(new Dimension(150, sToolPaletteHight));
        this.mToolPalettePane.setMinimumSize(new Dimension(150, 500));
        this.mLeftSplitPane = new JSplitPane(1, this.mToolPalettePane, this.mCanvasScrollPane);
        this.mLeftSplitPane.setOneTouchExpandable(true);
        this.mLeftSplitPane.setResizeWeight(0.0);
        this.mLeftSplitPane.setDividerLocation(150);
        this.mLeftSplitPane.setPreferredSize(new Dimension(680, sToolPaletteHight));
        this.mLeftSplitPane.setDividerSize(0);
        this.mLeftSplitPane.setContinuousLayout(true);
        String string = "";
        if (bl2) {
            this.getContentPane().add(this.mLeftSplitPane);
        } else {
            this.mSyntaxTemplateAction = null;
            String string2 = BuilderUtil.getInstance().getAppType() == AppType.STATS ? BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM") + " - " + this.getDialogTitle() : BuilderResUtil.getString("IDS_SCRIPT_DIAGRAM") + " - " + this.getDialogTitle();
            this.mSyntaxTemplateDlg = new SyntaxDiagramDlg(this, string2, string, new ArrayList<String>(), this.getSyntaxCommand(), new SyntaxDiagramDlgCallback());
            this.mSyntaxTemplatePanel = this.mSyntaxTemplateDlg.getTemplatePanel();
            this.mSyntaxTemplatePane = new JScrollPane(this.mSyntaxTemplatePanel);
            this.mSyntaxTemplatePane.setVerticalScrollBarPolicy(20);
            this.mSyntaxTemplatePane.setHorizontalScrollBarPolicy(30);
            this.mMainSplitPane = new JSplitPane(1, new JScrollPane(this.mLeftSplitPane), this.mSyntaxTemplatePane);
            this.mMainSplitPane.setOneTouchExpandable(true);
            this.mMainSplitPane.setResizeWeight(0.5);
            this.mMainSplitPane.setDividerLocation(710);
            this.mMainSplitPane.setPreferredSize(new Dimension(1240, sToolPaletteHight));
            this.mMainSplitPane.setContinuousLayout(true);
            this.getContentPane().add(this.mMainSplitPane);
        }
    }

    public String getDialogTitle() {
        String string = this.mDialog.getDialogTitle();
        if (string.length() == 0) {
            string = BuilderResUtil.getString("IDS_UNNAMED_CDB_DIALOG_TITLE");
        }
        return string;
    }

    private TabObject initTab(int n) {
        BuilderCanvas builderCanvas = new BuilderCanvas(this, this.mDialog, n, BuilderCanvas.CanvasType.Normal);
        builderCanvas.setPreferredSize(new Dimension(500, 400));
        builderCanvas.setMinimumSize(new Dimension(500, 100));
        this.mDialog.setCurrentPanel(0);
        builderCanvas.setFont(new Font("SansSerif", 0, 12));
        builderCanvas.addSelectionListener(this.mPropsPanel);
        this.mDragPane.addDropListener((IDropListener)builderCanvas);
        String string = BuilderResUtil.getString("IDS_DFLT_TAB_NAME");
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            string = BuilderResUtil.getString("IDS_DLG_TAB_TOOL");
        }
        this.mTabbedPane.addTab(string, builderCanvas);
        TabObject tabObject = new TabObject(builderCanvas.getTabPanelDefinition(), this);
        tabObject.addSelectionListener(this.mPropsPanel);
        this.mTabbedPane.setTabComponentAt(0, tabObject.getTabComponent());
        this.mDragPane.addDropListener((IDropListener)this.mTabbedPane);
        return tabObject;
    }

    private void createMenubar(DialogDefinition dialogDefinition) {
        Cloneable cloneable;
        boolean bl = dialogDefinition != null && dialogDefinition.isSubDialog();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(BuilderResUtil.getString("File"));
        jMenu.setMnemonic(BuilderResUtil.getAccessKey("File"));
        jMenuBar.add(jMenu);
        this.mEditMenu = new JMenu(BuilderResUtil.getString("Edit"));
        this.mEditMenu.setMnemonic(BuilderResUtil.getAccessKey("Edit"));
        if (dialogDefinition.getAppType() == AppType.STATS && !bl) {
            jMenuBar.add(this.mEditMenu);
        }
        JMenu jMenu2 = new JMenu(BuilderResUtil.getString("View"));
        jMenu2.setMnemonic(BuilderResUtil.getAccessKey("View"));
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = null;
        JMenu jMenu4 = null;
        if (!bl) {
            jMenu3 = new JMenu(BuilderResUtil.getString("Window"));
            jMenu3.setMnemonic(BuilderResUtil.getAccessKey("Window"));
            jMenuBar.add(jMenu3);
            jMenu4 = new JMenu(BuilderResUtil.getString("IDS_RECENTLY_USED"));
            jMenu4.setMnemonic(BuilderResUtil.getAccessKey("IDK_RECENTLY_USED"));
        }
        if (!bl) {
            this.mExtensionMenu = new JMenu(BuilderResUtil.getString("Extension"));
            this.mExtensionMenu.setMnemonic(BuilderResUtil.getAccessKey("Extension"));
            jMenuBar.add(this.mExtensionMenu);
            this.buildExtensionMenu();
            if (this.mIsCompatibleMode) {
                this.mExtensionMenu.setVisible(false);
            } else {
                this.mExtensionMenu.setVisible(true);
            }
        }
        JMenu jMenu5 = new JMenu(BuilderResUtil.getString("Help"));
        jMenu5.setMnemonic(BuilderResUtil.getAccessKey("Help"));
        jMenuBar.add(jMenu5);
        jMenu.add(new NewAction(false, true));
        if (!bl) {
            jMenu.add(new OpenAction(false));
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS && this.mIsCompatibleMode) {
                this.mConvertToItem = new JMenuItem(new ConvertAction(false));
                jMenu.add(this.mConvertToItem);
            } else if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
                jMenu.add(new ImportAction());
            }
            this.mMenuSaveItem = new JMenuItem(new SaveAction(false));
            jMenu.add(this.mMenuSaveItem);
            cloneable = new SaveAsAction(false);
            jMenu.add((Action)((Object)cloneable));
            jMenu.addSeparator();
            jMenu.add(new ReadDeployedAction(false));
            jMenu.add(new DeployAction(false));
            jMenu.addSeparator();
            jMenu.add(new UndeployAction(false));
            jMenu.addSeparator();
            jMenu.add(new TestDlgAction(false));
            jMenu.addSeparator();
            jMenu.add(jMenu4);
            jMenu.addSeparator();
        }
        jMenu.add(new CloseAction(false));
        if (!bl) {
            this.mEditMenu.add(new MenuLocationAction(false));
            this.mEditMenu.addSeparator();
            if (!this.mIsCompatibleMode) {
                // empty if block
            }
        }
        this.mViewToolboxMenuItem = new JCheckBoxMenuItem(new ViewToolboxAction(false));
        jMenu2.add(this.mViewToolboxMenuItem);
        if (!bl) {
            this.mViewToolbarMenuItem = new JCheckBoxMenuItem(new ViewToolbarAction(false));
            jMenu2.add(this.mViewToolbarMenuItem);
        }
        if (!bl) {
            jMenu3.add(new MinimizeWindowsAction());
            jMenu3.addSeparator();
        }
        this.buildHelpMenu(jMenu5);
        this.setJMenuBar(jMenuBar);
        cloneable = UIManager.getLookAndFeelDefaults();
        ThinMenuBarBorder thinMenuBarBorder = new ThinMenuBarBorder(((UIDefaults)cloneable).getColor("MenuBar.shadow"));
        jMenuBar.setBorder(thinMenuBarBorder);
        jMenu.addMenuListener(this);
        this.mEditMenu.addMenuListener(this);
        jMenu2.addMenuListener(this);
        if (!bl) {
            jMenu4.addMenuListener(this);
            jMenu3.addMenuListener(this);
        }
    }

    private void buildHelpMenu(JMenu jMenu) {
        jMenu.add(new JMenuItem(new HelpAction(false)));
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            jMenu.add(new JMenuItem(new HelpTutorialAction(false)));
        }
    }

    private void buildExtensionMenu() {
        this.mExtensionMenu.add(new JMenuItem(new ExtensionPropertyAction(false)));
        this.mExtensionMenu.add(new JMenuItem(new NewAction(false, false)));
    }

    private void addToExtEdit(String string, String string2) {
        if (this.mExtEditMenu == null) {
            this.mExtEditMenu = new JMenu(BuilderResUtil.getString("extension_edit"));
            this.mExtEditMenu.setMnemonic(BuilderResUtil.getAccessKey("extension_edit"));
            this.mExtensionMenu.add(this.mExtEditMenu);
        }
        this.mExtEditMenu.add(new JMenuItem(new OpenDialogFileAction(string, string2, false)));
    }

    public boolean isDlgIdExist(String string) {
        boolean bl = false;
        if (this.mEditCFEFiles != null && this.mEditCFEFiles.size() > 0 && this.mEditCFEFiles.contains(string + CFE_FILE_EXT)) {
            bl = true;
        }
        return bl;
    }

    public boolean isDlgMenuExist(String string, CommandLocation commandLocation, boolean bl) {
        boolean bl2 = false;
        if (this.IsCompatibleMode() || BuilderUtil.getInstance().getAppType() != AppType.STATS) {
            return bl2;
        }
        if (this.mExsitingMenuLoc == null) {
            this.mExsitingMenuLoc = new Hashtable();
        }
        if (bl) {
            Enumeration<String> enumeration = this.mExsitingMenuLoc.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                if (string2.equals(string) || !commandLocation.getUserCommandString((CommandLocation.ResLoader)this.mPropsPanel).equals(this.mExsitingMenuLoc.get(string2).getUserCommandString((CommandLocation.ResLoader)this.mPropsPanel))) continue;
                bl2 = true;
                break;
            }
        }
        if (this.mExsitingMenuLoc.get(string) == null && !bl2) {
            this.mExsitingMenuLoc.put(string, commandLocation);
        }
        return bl2;
    }

    public void updateDlgMenu(String string, String string2, CommandLocation commandLocation) {
        String string3;
        if (this.mExtensionContainer != null && this.mSPDPath != null) {
            string3 = this.mOpenSpecName;
            if (!string3.endsWith(CFE_FILE_EXT)) {
                string3 = string3 + CFE_FILE_EXT;
            }
            if (this.mExtensionContainer.isDialogExist(string3)) {
                this.mExtensionContainer.removeOneDialogSpec(string3);
                this.mExtensionContainer.removeOneDialogPath(this.mSPDPath.getAbsolutePath());
            }
            this.mOpenSpecName = string;
            this.mSPDPath = new File(this.mSPDPath.getParent() + File.separator + string + CFE_FILE_EXT);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(this.mSPDPath.getAbsolutePath());
            this.mExtensionContainer.addToAllFileWithPath(hashSet);
        }
        if (this.mExsitingMenuLoc != null && (string3 = this.mExsitingMenuLoc.get(string2)) != null) {
            this.mExsitingMenuLoc.remove(string2);
            this.mExsitingMenuLoc.put(string, commandLocation);
        }
    }

    private void updateExtensionMenu(String string, String string2) {
        Object object;
        Object object2;
        if (this.mExtEditMenu == null) {
            this.mExtEditMenu = new JMenu(BuilderResUtil.getString("extension_edit"));
            this.mExtEditMenu.setMnemonic(BuilderResUtil.getAccessKey("extension_edit"));
            this.mExtensionMenu.add(this.mExtEditMenu);
        } else {
            this.mExtEditMenu.removeAll();
        }
        if (this.mExtConvertMenu == null) {
            this.mExtConvertMenu = new JMenu(BuilderResUtil.getString("extension_convert"));
            this.mExtConvertMenu.setMnemonic(BuilderResUtil.getAccessKey("extension_convert"));
            this.mExtensionMenu.add(this.mExtConvertMenu);
            this.mExtensionMenu.repaint();
        } else {
            this.mExtConvertMenu.removeAll();
        }
        if (this.mEditCFEFiles == null) {
            this.mEditCFEFiles = new Vector();
        } else {
            this.mEditCFEFiles.removeAllElements();
        }
        Set<String> set = this.mExtensionContainer.getAllFileWithPath();
        Iterator<String> iterator = set.iterator();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String string3 = "";
        String string4 = "";
        while (iterator.hasNext()) {
            File file;
            object2 = iterator.next().toString();
            if (((String)object2).endsWith(CFE_FILE_EXT)) {
                file = new File((String)object2);
                String string5 = file.getName();
                object = file.getParent();
                treeMap.put(string5, (String)object);
                continue;
            }
            if (!((String)object2).endsWith(UIPKG_FILE_EXT)) continue;
            file = new File((String)object2);
            string3 = file.getName();
            string4 = file.getParent();
        }
        object2 = treeMap.keySet();
        int n = 2;
        boolean bl = false;
        if (string == null || string.length() == 0) {
            n = 1;
            bl = true;
        } else if (!string.endsWith(CFE_FILE_EXT)) {
            string = string + CFE_FILE_EXT;
        }
        if (object2.size() < n) {
            this.mExtEditMenu.setVisible(false);
        } else {
            this.mExtEditMenu.setVisible(true);
        }
        object = object2.iterator();
        Vector<String> vector = new Vector<String>();
        while (this.mExtEditMenu != null && object.hasNext() && object2.size() >= n) {
            String string6 = object.next().toString();
            vector.add(string6);
            String string7 = (String)treeMap.get(string6);
            if (!bl && string.equals(string6) && string2.indexOf(string7) >= 0) continue;
            this.mExtEditMenu.add(new JMenuItem(new OpenDialogFileAction(string6, string7, false)));
            this.mEditCFEFiles.add(string6);
        }
        if (string3.length() > 0 && string4.length() > 0) {
            this.mConvertMenuVisible = !this.sameSPDandCFE(string3, vector, string);
        }
        if (string3.length() > 0 && string4.length() > 0 && this.mConvertMenuVisible) {
            this.mExtConvertMenu.add(new JMenuItem(new OpenDialogFileAction(string3, string4, true)));
            this.mExtConvertMenu.setVisible(true);
        } else {
            this.mExtConvertMenu.setVisible(false);
        }
        this.mExtensionMenu.validate();
    }

    private boolean sameSPDandCFE(String string, Vector<String> vector, String string2) {
        Object object;
        boolean bl = false;
        String string3 = string;
        int n = string.indexOf(UIPKG_FILE_EXT);
        if (n >= 0) {
            string3 = string3.substring(0, n);
        }
        String string4 = "";
        if (this.mSpdNameDlgID != null && (object = this.mSpdNameDlgID.get(string3)) != null) {
            string4 = object.toString();
        }
        for (String string5 : vector) {
            if (!string5.equals(string3 + CFE_FILE_EXT) && (string4.length() <= 0 || !string5.equals(string4 + CFE_FILE_EXT))) continue;
            bl = true;
            break;
        }
        if (!bl && string2 != null && string2.length() > 0) {
            String string6;
            String string5;
            int n2 = string2.indexOf(CFE_FILE_EXT);
            string5 = string2;
            if (n2 >= 0) {
                string5 = string2.substring(0, n2);
            }
            if (!(bl = string3.equals(string5)) && this.mSpdNameDlgID != null && (string6 = this.mSpdNameDlgID.get(string3)) != null && string6.toString().equals(string5)) {
                bl = true;
            }
        }
        return bl;
    }

    private void loadMRUMenuItems() {
        this.mMRUSpecs.clear();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types").node("ui_builder").node("mru");
        for (int i = 0; i < this.getMaxMRUItems(); ++i) {
            boolean bl;
            String string = preferences2.get("mru_" + (i + 1), "");
            if (string.length() <= 1) continue;
            int n = string.lastIndexOf("+");
            if (n > -1) {
                bl = true;
                string = string.substring(0, n);
            } else {
                n = string.lastIndexOf("-");
                if (n <= -1) continue;
                bl = false;
                string = string.substring(0, n);
            }
            n = string.lastIndexOf(File.separator);
            String string2 = n > -1 ? string.substring(n + 1) : string;
            this.mMRUSpecs.add(new MRUSpec(string2, string, bl));
        }
    }

    private void updateMRUMenuItems(JMenu jMenu) {
        jMenu.removeAll();
        int n = 0;
        for (MRUSpec mRUSpec : this.mMRUSpecs) {
            jMenu.add(new BuilderMRUAction(mRUSpec.getName(), ++n, mRUSpec.isDeployed(), mRUSpec.getFullPath()));
        }
    }

    private void addMRUItem(String string, String string2, boolean bl) {
        this.removeMRUSpec(string);
        this.mMRUSpecs.add(0, new MRUSpec(string, string2, bl));
    }

    private void removeMRUSpec(String string) {
        int n = 0;
        for (MRUSpec mRUSpec : this.mMRUSpecs) {
            if (mRUSpec.getName().equals(string)) {
                this.mMRUSpecs.remove(n);
                break;
            }
            ++n;
        }
    }

    private void saveMRU() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types").node("ui_builder").node("mru");
        try {
            preferences2.clear();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        int n = 0;
        for (MRUSpec mRUSpec : this.mMRUSpecs) {
            String string;
            String string2 = "mru_" + (n + 1);
            if (mRUSpec.isDeployed()) {
                String string3 = mRUSpec.getFullPath();
                if (string3 == null || string3.length() == 0) {
                    if (mRUSpec.getName().endsWith(SPEPKG_FILE_EXT) || mRUSpec.getName().endsWith(MPEPKG_FILE_EXT)) {
                        String string4 = BuilderUtil.getInstance().getAppType() == AppType.STATS ? BuilderUtil.getInstance().getExtensionBundlePath().get(0) : BuilderUtil.getInstance().getExtensionPath().getAbsolutePath();
                        String string5 = mRUSpec.getName().substring(0, mRUSpec.getName().indexOf("."));
                        string3 = string4 + File.separator + string5 + File.separator + mRUSpec.getName();
                    } else {
                        string3 = BuilderUtil.getInstance().getExtensionPath() + File.separator + mRUSpec.getName();
                    }
                }
                string = string3 + "+";
            } else {
                string = mRUSpec.getFullPath() + "-";
            }
            preferences2.put(string2, string);
            ++n;
        }
    }

    private void createToolbar(DialogDefinition dialogDefinition) {
        boolean bl;
        this.mToolbar = new JToolBar();
        boolean bl2 = bl = dialogDefinition != null && dialogDefinition.isSubDialog();
        if (!bl) {
            JButton jButton = new JButton(new OpenAction(true));
            this.mToolbar.add(jButton);
            JButton jButton2 = new JButton(new ReadDeployedAction(true));
            this.mToolbar.add(jButton2);
            JButton jButton3 = new JButton(new TestDlgAction(true));
            this.mToolbar.add(jButton3);
            this.mToolbar.addSeparator();
            this.mSaveAction = new SaveAction(true);
            this.mToolBarSaveButton = new JButton(this.mSaveAction);
            this.mToolbar.add(this.mToolBarSaveButton);
            this.mToolbar.addSeparator();
            JButton jButton4 = new JButton(new DeployAction(true));
            this.mToolbar.add(jButton4);
            this.mToolbar.addSeparator();
        }
        if (!bl && BuilderUtil.getInstance().getAppType() == AppType.STATS && this.IsCompatibleMode()) {
            this.mConvertButton = new JButton(new ConvertAction(true));
            this.mConvertButton.setEnabled(true);
            this.mToolbar.add(this.mConvertButton);
            this.mToolbar.addSeparator();
        }
        this.mTBPanelNorth.add(this.mToolbar);
    }

    private void addWindowListener() {
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (BuilderFrame.this.doClose()) {
                    BuilderFrame.this.saveState();
                    BuilderFrame.this.dispose();
                }
                BuilderUtil.getInstance().cleanTempFolder(BuilderUtil.getInstance().getTempDir(), true);
            }
        };
        this.addWindowListener(windowAdapter);
    }

    private void saveState() {
        boolean bl;
        DialogDefinition dialogDefinition = this.mDialog;
        boolean bl2 = bl = dialogDefinition != null && dialogDefinition.isSubDialog();
        if (!bl) {
            sMainSplitPosition = this.mSplitPane.getDividerLocation();
            this.saveMRU();
        } else {
            sSubSplitPosition = this.mSplitPane.getDividerLocation();
        }
        sLastBounds = this.getBounds();
    }

    private boolean doClose() {
        boolean bl;
        boolean bl2 = bl = this.mDialog != null ? this.mDialog.isSubDialog() : this.mCanvas.getDialogDefinition().isSubDialog();
        if (!bl) {
            if (!this.checkModified(true)) {
                return false;
            }
            BuilderUtil.getInstance().removeFrame(this);
            if (this.mDlgExecutor != null) {
                this.mDlgExecutor.removeBuilderFrame(this);
            }
        }
        if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
            BuilderUtil.getInstance().cleanTempFolder(BuilderUtil.getInstance().getTempDir(), false);
        } else {
            BuilderUtil.getInstance().cleanTempFolder(BuilderUtil.getInstance().getTempDir(), true);
        }
        return true;
    }

    private void doReset() {
        PanelDefinition panelDefinition;
        this.mSpdNameDlgID = null;
        DialogDefinition dialogDefinition = this.mDialog;
        Vector<String> vector = new Vector<String>();
        if (dialogDefinition.isSubDialog()) {
            panelDefinition = dialogDefinition.getCurrentPanel();
            int n = panelDefinition.getElementCount();
            for (int i = 0; i < n; ++i) {
                vector.add(panelDefinition.getPanelElement(i).getControlId());
            }
        }
        if (this.mTabbedPane != null) {
            panelDefinition = new DialogDefinition(dialogDefinition.getParentDefinition(), BuilderUtil.getInstance().getAppType());
            if (dialogDefinition.isSubDialog()) {
                PanelDefinition panelDefinition2 = (PanelDefinition)dialogDefinition.getParentDefinition().getPanels().get(0);
                for (int i = 0; i < panelDefinition2.getElementCount(); ++i) {
                    SubDlgButtonDefinition subDlgButtonDefinition;
                    PanelElementDefinition panelElementDefinition = panelDefinition2.getPanelElement(i);
                    if (!(panelElementDefinition instanceof SubDlgButtonDefinition) || (subDlgButtonDefinition = (SubDlgButtonDefinition)panelElementDefinition).getDialogDefinition() != dialogDefinition) continue;
                    subDlgButtonDefinition.setDialogDefinition((DialogDefinition)panelDefinition);
                    break;
                }
            }
            this.mDialog = panelDefinition;
            if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
                this.mDialog.getRequiredAddOns().add(AddOnType.R);
            }
            this.mTabbedPane.removeAll();
            this.mDragPane.removeAllDropListener(BuilderCanvas.class);
            this.mDragPane.removeAllDropListener(DraggableTabbedPane.class);
            this.mPropsPanel.setDlgDef(this.mDialog);
            this.recreateTabbedCanvas();
            this.mSPEPath = null;
        } else {
            this.mDragPane.removeAllDropListener(BuilderCanvas.class);
            this.mCanvas.removeSelectionListener(this.mPropsPanel);
            this.mCanvas.removeAll();
            this.mDialog = new DialogDefinition(null, BuilderUtil.getInstance().getAppType());
            this.createPanelCanvas(dialogDefinition.isSubDialog());
            this.mPropsPanel.setDlgDef(this.mDialog);
            this.mCanvas.fireSelectionChange(null);
        }
        if (!dialogDefinition.isSubDialog()) {
            this.mOpenSpecName = "";
            this.mSPDPath = null;
            this.setModified(false);
        }
        if (this.mSyntaxTemplateDlg != null) {
            this.resetCurrentSyntaxDlg();
            if (!dialogDefinition.isSubDialog()) {
                this.setModified(false);
            }
        } else if (this.mModelerScriptTemplateDlg != null) {
            this.mModelerScriptTemplateDlg.mModelPanel.getMainSpssSyntaxTextPane().setText("");
            this.mModelerScriptTemplateDlg.mScorePanel.getMainSpssSyntaxTextPane().setText("");
        } else if (dialogDefinition.isSubDialog() && this.getDialogDefinition().getParentDefinition().getBuilderFrame() != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ((BuilderFrame)this.getDialogDefinition().getParentDefinition().getBuilderFrame()).removeCanvasObject((String)vector.get(i));
            }
        }
        if (this.getCanvas().getComponentCount() == 0) {
            this.getCanvas().createTextAreaObject();
            this.mIsModified = false;
        }
    }

    private void updateToolbarButtons() {
        if (this.mToolBarSaveButton != null) {
            boolean bl = !this.IsCompatibleMode() && this.mExtensionContainer != null && this.mExtensionContainer.isModified();
            this.mToolBarSaveButton.setEnabled(this.mIsModified || bl);
        }
    }

    private void createMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.mTBPanelNorth = new JPanel();
        this.mTBPanelNorth.setLayout(new FlowLayout(0, 2, 2));
        jPanel.add((Component)this.mTBPanelNorth, "North");
        this.setContentPane(jPanel);
    }

    private void updateTitle(DialogDefinition dialogDefinition) {
        String string;
        String string2 = BuilderResUtil.getString("IDS_EXTENSION_UIBUILDER_TITLE");
        if (this.mIsCompatibleMode) {
            string2 = BuilderResUtil.getString("IDS_UIBUILDER_TITLE");
        }
        String string3 = string = dialogDefinition != null ? dialogDefinition.getDialogId() : null;
        if (string == null || string.length() == 0) {
            string = BuilderResUtil.getString("IDS_UNTITLED");
        }
        if (string != null && string.length() > 0) {
            string2 = string2 + " - " + string;
        }
        if (this.isModified()) {
            string2 = "*" + string2;
        }
        if (this.mIsCompatibleMode) {
            string2 = string2 + BuilderResUtil.getString("IDS_COMPATIBILITY_MODE");
        }
        this.setTitle(string2);
    }

    public boolean checkModified(boolean bl) {
        if (this.isModified() || bl && !this.IsCompatibleMode() && this.mExtensionContainer != null && this.mExtensionContainer.isModified()) {
            int n;
            String string = BuilderResUtil.getString("IDS_CLOSE_CHANGES_QUERY");
            if (!this.IsCompatibleMode()) {
                string = BuilderResUtil.getString("IDS_CLOSE_EXTENSION_QUERY");
            }
            if ((n = BuilderAlertPane.showConfirmDialog(this, bl ? string : BuilderResUtil.getString("IDS_DISCARD_CHANGES_QUERY"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.OK_CANCEL_OPTION)) != 0) {
                return false;
            }
        }
        return true;
    }

    public boolean checkCurrentDlgModified(boolean bl) {
        if (this.isModified()) {
            int n = BuilderAlertPane.showConfirmDialog(this, BuilderResUtil.getString("IDS_CLOSE_DIALOG_QUERY"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_CANCEL_OPTION);
            if (n == 3) {
                return false;
            }
            if (n == 1) {
                if (this.validateCurrentDlg(true, false, true, false, "")) {
                    this.updateCurrentCfe(true);
                    if (bl) {
                        this.updateExtensionMenu("", "");
                    }
                    return true;
                }
                return false;
            }
        } else if (bl && this.mExtensionContainer != null) {
            this.updateExtensionMenu("", "");
        }
        return true;
    }

    private void openDeployedSpecification() {
        try {
            String string;
            String string2 = BuilderResUtil.getString("IDS_OPEN_DEPLOYED_DLG_TITLE");
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS && !this.mIsCompatibleMode || BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
                string2 = BuilderResUtil.getString("IDS_OPEN_DEPLOYED_BUNDLE_TITLE");
            }
            if ((string = OpenDeployedDlg.doOpenDeployedDlg(this, string2)) == null || string.length() == 0) {
                return;
            }
            File file = new File(string);
            if (this.mIsCompatibleMode) {
                if (!file.isDirectory()) {
                    return;
                }
                String[] stringArray = file.list(new XmlFilter());
                if (stringArray.length == 0) {
                    String string3 = BuilderResUtil.getString("IDS_ERROR_OPENING_DLG") + string;
                    BuilderAlertPane.showErrorMessageDialog(this, string3, BuilderUtil.getInstance().getAppVersionString());
                    return;
                }
                File file2 = new File(string + File.separator + stringArray[0]);
                this.setCurrentDefinition(file2);
                this.mOpenSpecName = file.getName();
                String string4 = string.startsWith(SpecificationBuilder.getUIExtensionsFolderPath()) ? "" : string;
                this.addMRUItem(this.mOpenSpecName, string4, true);
            } else {
                this.openSPEFile(file);
            }
            this.setModified(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BuilderAlertPane.showErrorMessageDialog(this, BuilderResUtil.getString("IDS_BAD_CLEF_FILE_MSG"), BuilderUtil.getInstance().getAppVersionString());
        }
    }

    private boolean deploySpecification(boolean bl) {
        this.mPropsPanel.commitEdits();
        DialogDefinition dialogDefinition = this.mDialog;
        if (bl && !this.checkForSyntaxTemplate(dialogDefinition)) {
            return false;
        }
        if (bl && !this.checkForMenuLocation(dialogDefinition)) {
            return false;
        }
        if (bl && !MissingAddOnsDlg.checkForMissingAddOns(this, dialogDefinition)) {
            return false;
        }
        try {
            String string;
            SpecificationWriter specificationWriter;
            String string2;
            int n;
            String string3 = SpecificationWriter.getDeploymentFolder();
            if (string3 == null) {
                Object[] objectArray = new String[]{BuilderResUtil.getString("IDS_OK"), BuilderResUtil.getString("IDS_HELP")};
                int n2 = BuilderAlertPane.showOptionDialog(this, BuilderResUtil.getString("IDS_INSTALL_SPEC_ERROR"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.IconType.eError, objectArray, (Object)objectArray[0]);
                if (n2 == 1) {
                    StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_IDD_UIBUILDER");
                }
                return false;
            }
            String string4 = string3 + File.separator + dialogDefinition.getDialogId();
            File file = new File(string4);
            if (!file.exists()) {
                if (!file.mkdirs()) {
                    throw new Exception("Error creating deployment directory");
                }
            } else if (!this.mOpenSpecName.equals(dialogDefinition.getDialogId()) && (n = BuilderAlertPane.showConfirmDialog(this, BuilderResUtil.getString("IDS_OVERWRITE_SPEC_QUERY"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION)) != 1) {
                return false;
            }
            if ((string2 = BuilderUtil.getInstance().hasMenuItem(dialogDefinition)) != null) {
                int n3 = BuilderAlertPane.showConfirmDialog(this, BuilderResUtil.getString("IDS_SAME_MENU_ITEM_WARNING"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION);
                if (n3 != 1) {
                    return false;
                }
                if (!BuilderUtil.getInstance().removeDeployed(string3 + File.separator + string2)) {
                    return false;
                }
                if (!file.exists() && !file.mkdirs()) {
                    throw new Exception("Error creating deployment directory");
                }
            }
            if (!(specificationWriter = new SpecificationWriter(dialogDefinition)).writeClefStream(string = string4 + File.separator + dialogDefinition.getDialogId() + XML_FILE_EXT)) {
                throw new Exception(this.makeErrorText(specificationWriter));
            }
            BuilderUtil.getInstance().updateFrames(dialogDefinition, string);
            this.mOpenSpecName = dialogDefinition.getDialogId();
            String string5 = string4.startsWith(SpecificationBuilder.getUIExtensionsFolderPath()) ? "" : string4;
            this.addMRUItem(this.mOpenSpecName, string5, true);
            if (string5.equals("")) {
                string5 = SpecificationBuilder.getUIExtensionsFolderPath() + File.separator + this.mOpenSpecName;
            }
            String string6 = dialogDefinition.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)this.mPropsPanel).replaceAll("/", ">");
            String string7 = String.format(BuilderResUtil.getString("IDS_DIALOG_INSTALLED"), string6);
            BuilderAlertPane.showInformationMessageDialog(this, string7, BuilderUtil.getInstance().getAppVersionString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BuilderAlertPane.showErrorMessageDialog(this, BuilderResUtil.getString("IDS_ERROR_SAVING_DLG") + "\n\n" + exception.getMessage(), BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        return true;
    }

    private boolean deployCFSpecification(boolean bl, boolean bl2) {
        DialogDefinition dialogDefinition = (DialogDefinition)this.mDialog.clone();
        if (!this.validateCurrentDlg(bl, false, false, true, "")) {
            return false;
        }
        String string = BuilderUtil.getInstance().getExtensionPath().getAbsolutePath();
        String string2 = string + File.separator + dialogDefinition.getDialogId() + CFE_FILE_EXT;
        File file = new File(string2);
        try {
            SpecificationWriter specificationWriter;
            String string3;
            int n;
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    throw new Exception("Error creating deployment file");
                }
            } else if (!this.mOpenSpecName.equals(dialogDefinition.getDialogId()) && (n = BuilderAlertPane.showConfirmDialog(this, BuilderResUtil.getString("IDS_OVERWRITE_SPEC_QUERY"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION)) != 1) {
                return false;
            }
            if ((string3 = BuilderUtil.getInstance().hasMenuItem(dialogDefinition)) != null) {
                int n2 = BuilderAlertPane.showConfirmDialog(this, BuilderResUtil.getString("IDS_SAME_MENU_ITEM_WARNING"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION);
                if (n2 != 1) {
                    return false;
                }
                if (!this.removeDeployedCFE(string + File.separator + string3)) {
                    return false;
                }
            }
            if (!this.writeCfeFile(string2, specificationWriter = new SpecificationWriter(dialogDefinition))) {
                throw new Exception(this.makeErrorText(specificationWriter));
            }
            String string4 = BuilderUtil.getInstance().loadExtension(file);
            this.mOpenSpecName = dialogDefinition.getDialogId();
            String string5 = BuilderUtil.getInstance().getUIExtensionsFolderPath() == null ? string : (string.startsWith(BuilderUtil.getInstance().getUIExtensionsFolderPath()) ? "" : string);
            BuilderUtil.getInstance().addCfeMenuToFrames(dialogDefinition.getCommandLocation().getCommandActionId(), dialogDefinition.getCommandLocation().getCommandPath());
            string5 = string5 + File.separator + this.mOpenSpecName;
            this.addMRUItem(this.mOpenSpecName, string5, true);
            if (string5.equals("")) {
                string5 = BuilderUtil.getInstance().getUIExtensionsFolderPath() + File.separator + this.mOpenSpecName;
            }
            if (!bl2) {
                String string6 = String.format(BuilderResUtil.getString("IDS_DIALOG_INSTALLED"), string5);
                BuilderAlertPane.showInformationMessageDialog(this, string6, BuilderUtil.getInstance().getAppVersionString());
            }
        }
        catch (PaswException paswException) {
            if (!file.delete()) {
                file.deleteOnExit();
            }
            BuilderAlertPane.showErrorMessageDialog(this, BuilderResUtil.getString("IDS_ERROR_SAVING_DLG") + "\n\n" + paswException.getMessage(), BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        catch (IOException iOException) {
            if (!file.delete()) {
                file.deleteOnExit();
            }
            BuilderAlertPane.showErrorMessageDialog(this, BuilderResUtil.getString("IDS_ERROR_SAVING_DLG") + "\n\n" + iOException.getMessage(), BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BuilderAlertPane.showErrorMessageDialog(this, BuilderResUtil.getString("IDS_ERROR_SAVING_DLG") + "\n\n" + exception.getMessage(), BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        return true;
    }

    private boolean deployExtensionBundle(boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (this.mDlgExecutor == null && BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            return bl3;
        }
        if (this.mExtensionContainer == null || this.mExtensionContainer.getName().length() == 0) {
            bl3 = this.showExtensionPropertyDlg();
        }
        if (!bl3) {
            return false;
        }
        File file = this.mExtensionContainer.getSPEfile();
        String string = this.mExtensionContainer.getTempNameDirectory().getAbsolutePath();
        String string2 = file == null ? this.mExtensionContainer.getName().replaceAll(" ", "_") : file.getName();
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            if (!string2.endsWith(SPEPKG_FILE_EXT)) {
                string2 = string2 + SPEPKG_FILE_EXT;
            }
        } else if (!string2.endsWith(MPEPKG_FILE_EXT)) {
            string2 = string2 + MPEPKG_FILE_EXT;
        }
        int n = this.mExtensionContainer.getDialogSpecsSet().size();
        String string3 = "";
        if (n == 1) {
            string3 = string2.substring(0, string2.length() - 4);
        }
        if (!this.validateCurrentDlg(bl, false, true, true, string3)) {
            return false;
        }
        if (this.isModified() && (bl3 = this.saveCurrentToCfe(true))) {
            String string4 = this.mOpenSpecName;
            if (!string4.endsWith(CFE_FILE_EXT)) {
                string4 = string4 + CFE_FILE_EXT;
            }
            if (!this.mExtensionContainer.isDialogExist(string4)) {
                this.mExtensionContainer.addCFEfileWithPath(this.mSPDPath.getAbsolutePath());
                this.mExtensionContainer.addOneCFEfileName(string4);
            }
        }
        if (!bl3) {
            return false;
        }
        boolean bl4 = this.validateDlgSpec();
        if (!bl4) {
            return false;
        }
        File file2 = new File(string + File.separator + string2);
        file2.deleteOnExit();
        this.mExtensionContainer.createExtensionPackage(file2, this, false);
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            this.mDlgExecutor.installExtensionBundle(file2, this);
        } else {
            bl3 = BuilderUtil.getInstance().installExtensionBundle(this, true, false, true, file2);
        }
        if (bl3) {
            this.addMRUItem(string2, null, true);
        }
        return bl3;
    }

    private boolean validateCurrentDlg(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) {
        if (!bl3 && BuilderUtil.getInstance().getExtensionPath() == null) {
            BuilderAlertPane.showErrorMessageDialog(this, BuilderResUtil.getString("IDS_ERROR_SAVING_DLG") + "\n", BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        if (this.getDialogDefinition().getDialogId().contains(" ")) {
            BuilderAlertPane.showWarningMessageDialog(this, BuilderResUtil.getString("IDS_IDS_CANT_HAVE_SPACES"), BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        this.mPropsPanel.commitEdits();
        DialogDefinition dialogDefinition = (DialogDefinition)this.mDialog.clone();
        if (dialogDefinition == null) {
            return false;
        }
        if (bl && bl4 && !this.checkForSyntaxTemplate(dialogDefinition)) {
            return false;
        }
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            if (bl && (!bl3 || bl2 ? !this.checkForMenuLocation(dialogDefinition) : !this.checkForMenuLocationSPEE(dialogDefinition, false, null, string))) {
                return false;
            }
        } else if (bl && !BuilderUtil.isValidTitle(this.mDialog.getDialogTitle())) {
            this.checkForNodeLocation(dialogDefinition);
            return false;
        }
        return bl3 || !bl || MissingAddOnsDlg.checkForMissingAddOns(this, dialogDefinition);
    }

    private boolean validateDlgSpec() {
        boolean bl = true;
        try {
            Object object;
            Object object2;
            Set<String> set = this.mExtensionContainer.getAllFileWithPath();
            Iterator<String> iterator = set.iterator();
            DialogDefinition dialogDefinition = null;
            String string = this.mDialog.getDialogId();
            Vector vector = new Vector();
            Vector vector2 = null;
            boolean bl2 = false;
            while (iterator.hasNext()) {
                object2 = iterator.next().toString();
                if (((String)object2).endsWith(CFE_FILE_EXT)) {
                    if (!bl2) {
                        object = new File((String)object2).getName();
                        if (((String)(object = ((String)object).substring(0, ((String)object).length() - 4))).equals(string)) {
                            bl2 = true;
                            continue;
                        }
                    }
                    vector.add(object2);
                    continue;
                }
                if (!((String)object2).endsWith(UIPKG_FILE_EXT)) continue;
                vector2 = object2;
            }
            object2 = new Vector();
            if (vector.size() > 0) {
                object2 = vector;
            } else if (!bl2 && vector2 != null) {
                ((Vector)object2).add(vector2);
            }
            object = ((Vector)object2).iterator();
            while (object.hasNext()) {
                boolean bl3;
                String string2 = (String)object.next();
                dialogDefinition = null;
                if (string2.endsWith(CFE_FILE_EXT)) {
                    dialogDefinition = BuilderUtil.getInstance().createDialogDefFromSpecFile(string2, false);
                    bl3 = false;
                } else {
                    dialogDefinition = BuilderUtil.getInstance().createDialogDefFromSpecFile(string2, true);
                    bl3 = true;
                }
                if (!this.checkForSyntaxTemplate(dialogDefinition)) {
                    bl = false;
                } else if (BuilderUtil.getInstance().getAppType() == AppType.STATS && !this.checkForMenuLocationSPEE(dialogDefinition, bl3, string2, "")) {
                    bl = false;
                } else {
                    if (BuilderUtil.getInstance().getAppType() != AppType.MODELER || this.checkForNodeLocation(dialogDefinition)) continue;
                    bl = false;
                }
                break;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean commitEdits(boolean bl) {
        if (this.mSyntaxTemplateDlg == null) {
            return true;
        }
        boolean bl2 = this.mSyntaxTemplateAction != null ? this.mSyntaxTemplateAction.commitEdits(bl) : this.mSyntaxTemplateDlg.commitEdits(bl);
        if (bl2) {
            LinkedList linkedList = this.mDialog.getPanels();
            for (int i = 0; i < linkedList.size(); ++i) {
                this.checkPanelEnableControl((PanelDefinition)linkedList.get(i));
            }
        }
        return bl2;
    }

    private void checkPanelEnableControl(PanelDefinition panelDefinition) {
        this.resetOneControlCondition((PanelElementDefinition)panelDefinition);
        for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
            PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
            if (panelElementDefinition instanceof PanelDefinition) {
                this.checkPanelEnableControl((PanelDefinition)panelElementDefinition);
                continue;
            }
            if (panelElementDefinition instanceof RadioGroupDefinition) {
                this.resetOneControlCondition(panelElementDefinition);
                RadioGroupDefinition radioGroupDefinition = (RadioGroupDefinition)panelElementDefinition;
                int n = radioGroupDefinition.radioItemCount();
                for (int j = 0; j < n; ++j) {
                    RadioItemDefinition radioItemDefinition = radioGroupDefinition.getRadioItem(j);
                    int n2 = radioItemDefinition.getElementCount();
                    for (int k = 0; k < n2; ++k) {
                        this.resetOneControlCondition(radioItemDefinition.getPanelElement(k));
                    }
                }
                continue;
            }
            if (panelElementDefinition instanceof SubDlgButtonDefinition) {
                this.resetOneControlCondition(panelElementDefinition);
                this.checkPanelEnableControl(((SubDlgButtonDefinition)panelElementDefinition).getDialogDefinition().getCurrentPanel());
                continue;
            }
            this.resetOneControlCondition(panelElementDefinition);
        }
    }

    private void resetOneControlCondition(PanelElementDefinition panelElementDefinition) {
        Vector vector = panelElementDefinition.getCtrlConditions();
        if (vector.size() == 1 && !this.hasControlElem(vector)) {
            panelElementDefinition.setControlConditions(new Vector());
        }
    }

    private boolean hasControlElem(Vector<ControlCondition> vector) {
        if (this.mTabbedPane == null) {
            return this.getCanvas().findCanvasObject(vector.get(0).getControlName()) != null;
        }
        boolean bl = false;
        for (BuilderCanvas builderCanvas : this.mTabbedPane.getAllCanvas()) {
            if (builderCanvas.findCanvasObject(vector.get(0).getControlName()) == null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private String makeErrorText(SpecificationWriter specificationWriter) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        Vector vector = specificationWriter.getErrors();
        for (String string : vector) {
            stringBuilder.append(n++).append(". ").append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    private boolean checkForMenuLocation(DialogDefinition dialogDefinition) {
        if (dialogDefinition.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)this.mPropsPanel).length() == 0) {
            String string = dialogDefinition.getDialogTitle();
            if (string.length() == 0) {
                string = dialogDefinition.getDialogId();
            }
            Object[] objectArray = new String[]{BuilderResUtil.getString("IDS_YES"), BuilderResUtil.getString("IDS_NO")};
            String string2 = String.format(BuilderResUtil.getString("IDS_CFE_NO_MENU_LOCATION_1"), new Object[0]);
            String string3 = String.format(BuilderResUtil.getString("IDS_CFE_NO_MENU_LOCATION_2"), string);
            String string4 = BuilderResUtil.getString("IDS_CFE_NO_MENU_LOCATION_3");
            int n = BuilderAlertPane.showOptionDialog(this, string2 + "\n" + string3 + "\n" + string4, BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.IconType.eWarning, objectArray, (Object)objectArray[1]);
            if (n == 1) {
                CommandLocation commandLocation = dialogDefinition.getCommandLocation();
                commandLocation.setCommandPath(BuilderResUtil.getString("IDS_EXTENSION_STATS_MENU"));
                commandLocation.setCommandTitle(string);
                commandLocation.setMenuItemOffset(0);
                return true;
            }
            this.runMenuLocationDialog(dialogDefinition);
            return false;
        }
        return true;
    }

    private boolean checkForMenuLocationSPEE(DialogDefinition dialogDefinition, boolean bl, String string, String string2) {
        if (dialogDefinition.getCommandLocation().getUserCommandString((CommandLocation.ResLoader)this.mPropsPanel).length() == 0) {
            boolean bl2 = false;
            boolean bl3 = false;
            String string3 = string2;
            if (string3.length() == 0) {
                string3 = dialogDefinition.getDialogTitle();
            }
            if (string3.length() == 0) {
                string3 = dialogDefinition.getDialogId();
            }
            Object[] objectArray = new String[2];
            if (bl) {
                objectArray[0] = BuilderResUtil.getString("IDS_CONTINUE");
                objectArray[1] = BuilderResUtil.getString("IDS_CANCEL");
            } else {
                objectArray[0] = BuilderResUtil.getString("IDS_YES");
                objectArray[1] = BuilderResUtil.getString("IDS_NO");
            }
            String string4 = String.format(BuilderResUtil.getString("IDS_CFE_NO_MENU_LOCATION_1"), new Object[0]);
            String string5 = String.format(BuilderResUtil.getString("IDS_CFE_NO_MENU_LOCATION_2"), string3);
            String string6 = "";
            if (!bl) {
                string6 = BuilderResUtil.getString("IDS_CFE_NO_MENU_LOCATION_3");
            }
            int n = BuilderAlertPane.showOptionDialog(this, string4 + "\n" + string5 + "\n" + string6, BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.IconType.eWarning, objectArray, (Object)objectArray[1]);
            if (!bl) {
                if (n == 1) {
                    bl3 = true;
                    bl2 = true;
                } else {
                    this.runMenuLocationDialog(dialogDefinition);
                    bl2 = false;
                }
            } else if (n == 1) {
                bl2 = false;
            } else {
                bl3 = true;
                bl2 = true;
            }
            if (bl3) {
                try {
                    CommandLocation commandLocation = dialogDefinition.getCommandLocation();
                    commandLocation.setCommandPath(BuilderResUtil.getString("IDS_EXTENSION_STATS_MENU"));
                    if (string2.length() > 0) {
                        commandLocation.setCommandTitle(string2);
                    } else {
                        commandLocation.setCommandTitle(string3);
                    }
                    commandLocation.setMenuItemOffset(sDefaultMenuOffset);
                    if (string != null) {
                        SpecificationWriter specificationWriter = new SpecificationWriter(dialogDefinition);
                        bl2 = bl ? specificationWriter.writeCFStream(string, false, false) : this.writeCfeFile(string, specificationWriter, dialogDefinition);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return bl2;
        }
        return true;
    }

    private boolean checkForNodeLocation(DialogDefinition dialogDefinition) {
        if (!BuilderUtil.isValidTitle(this.mDialog.getDialogTitle())) {
            Object[] objectArray = new String[]{BuilderResUtil.getString("IDS_EDIT_TITLE"), BuilderResUtil.getString("IDS_CANCEL")};
            int n = BuilderAlertPane.showOptionDialog(this, BuilderResUtil.getString("IDS_NO_TITLE_WARNING"), BuilderResUtil.getString("IDS_INSTALL_DIALOG"), BuilderAlertPane.IconType.eWarning, objectArray, (Object)objectArray[0]);
            if (n == 1) {
                return false;
            }
            this.runMenuLocationDialog(dialogDefinition);
            return false;
        }
        return true;
    }

    private boolean checkForSyntaxTemplate(DialogDefinition dialogDefinition) {
        int n;
        if (dialogDefinition.getDialogSyntax().length() == 0) {
            String string = dialogDefinition.getDialogTitle();
            if (string.length() == 0) {
                string = dialogDefinition.getDialogId();
            }
            String string2 = String.format(BuilderResUtil.getString("IDS_NO_TEMPLATE_WARNING_BUNDLE"), string);
            Object[] objectArray = new String[]{BuilderResUtil.getString("IDS_OK")};
            if (this.IsCompatibleMode()) {
                string2 = BuilderResUtil.getString("IDS_NO_TEMPLATE_WARNING");
            }
            int n2 = BuilderAlertPane.showOptionDialog(this, string2, BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.IconType.eWarning, objectArray, (Object)objectArray[0]);
            return false;
        }
        DialogDefinitionHelper dialogDefinitionHelper = new DialogDefinitionHelper();
        ArrayList<String> arrayList = dialogDefinitionHelper.getControlIds(dialogDefinition);
        String string = BuilderUtil.getInstance().getAppType() == AppType.STATS ? BuilderResUtil.getString("IDS_INVALID_SYNTAX_WARNING") : BuilderResUtil.getString("IDS_INVALID_SCRIPT_WARNING");
        if (!BuilderUtil.getInstance().validateScript(dialogDefinition.getDialogSyntax(), arrayList, dialogDefinition.getScriptType()) && (n = BuilderAlertPane.showConfirmDialog(this, string, BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION)) == 2) {
            return false;
        }
        return !dialogDefinition.canScore() || BuilderUtil.getInstance().validateScript(dialogDefinition.getRScoringScript(), arrayList, dialogDefinition.getScriptType()) || (n = BuilderAlertPane.showConfirmDialog(this, string, BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION)) != 2;
    }

    private boolean removeDeployed(String string, String string2) throws Exception {
        File file = new File(string);
        RemoveDeployedQueryDlg removeDeployedQueryDlg = new RemoveDeployedQueryDlg(this, file.getName(), string2);
        removeDeployedQueryDlg.setVisible(true);
        if (removeDeployedQueryDlg.getDoSave() && this.checkModified(false)) {
            this.setCurrentDefinition(new File(string + File.separator + file.getName() + XML_FILE_EXT), null, true);
            this.setModified(false);
            new SaveAsAction(false).actionPerformed(null);
        }
        if (removeDeployedQueryDlg.isContinue()) {
            return BuilderUtil.getInstance().removeDeployed(string);
        }
        return false;
    }

    private boolean removeDeployedCFE(String string) throws Exception {
        File file = new File(string);
        File file2 = new File(string + CFE_FILE_EXT);
        RemoveDeployedQueryDlg removeDeployedQueryDlg = new RemoveDeployedQueryDlg(this, file.getName(), BuilderResUtil.getString("IDS_REMOVE_DEPLOYED_BUNDLE_TITLE"));
        removeDeployedQueryDlg.setVisible(true);
        if (removeDeployedQueryDlg.getDoSave() && this.checkModified(false)) {
            this.readPackageFile(file2, false);
            this.setModified(false);
            this.mSPDPath = null;
            new SaveAsAction(false).actionPerformed(null);
        }
        if (removeDeployedQueryDlg.isContinue()) {
            try {
                if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                    boolean bl = BuilderUtil.getInstance().removeDeployed(string + CFE_FILE_EXT);
                    if (file2.exists()) {
                        file2.delete();
                    }
                    return true;
                }
                BuilderUtil.getInstance().unloadExtension(BuilderFrame.getExtensionId(file));
                return file2.delete();
            }
            catch (PaswException paswException) {
                BuilderAlertPane.showErrorMessageDialog(this, BuilderResUtil.getString("IDS_ERROR_SAVING_DLG") + "\n\n" + paswException.getMessage(), BuilderUtil.getInstance().getAppVersionString());
                return false;
            }
        }
        return false;
    }

    private boolean removeDeployedSPE(String string) throws Exception {
        File file = new File(string);
        RemoveDeployedQueryDlg removeDeployedQueryDlg = new RemoveDeployedQueryDlg(this, file.getName(), BuilderResUtil.getString("IDS_REMOVE_DEPLOYED_BUNDLE_TITLE"));
        removeDeployedQueryDlg.setVisible(true);
        if (removeDeployedQueryDlg.getDoSave() && this.checkModified(false)) {
            this.openSPEFile(file);
            this.setModified(false);
            this.mSPEPath = null;
            this.doSaveSPEfile(true);
        }
        if (removeDeployedQueryDlg.isContinue()) {
            boolean bl;
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                bl = BuilderUtil.getInstance().removeDeployedBundle(file);
            } else {
                String string2 = file.getName();
                if (string2.indexOf(".") > 0) {
                    string2 = string2.substring(0, string2.indexOf("."));
                }
                bl = BuilderUtil.getInstance().unInstallExtensionBundle(string2);
            }
            if (!bl) {
                BuilderAlertPane.showErrorMessageDialog(this, BuilderResUtil.getString("IDS_ERROR_SAVING_DLG"), BuilderUtil.getInstance().getAppVersionString());
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExtensionId(File file) {
        String string = null;
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            String string2 = file.getAbsolutePath();
            fileInputStream = !string2.endsWith(CFE_FILE_EXT) ? new FileInputStream(string2 + CFE_FILE_EXT) : new FileInputStream(string2);
            zipInputStream = new JarInputStream(fileInputStream);
            JarEntry jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry();
            while (jarEntry != null) {
                String string3 = jarEntry.getName();
                if (string3.equals(EXT_FILE_NAME)) {
                    ByteBuffer byteBuffer = BuilderFrame.readEntry((JarInputStream)zipInputStream);
                    String string4 = new String(byteBuffer.array(), "UTF-8");
                    string = BuilderUtil.getInstance().getExtensionId(string4);
                    break;
                }
                jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string == null ? "spss." + file.getName() : string;
    }

    private boolean writeToCFDFile(String string) {
        File file = new File(string);
        if (this.writePackageFile(file.getAbsolutePath(), false)) {
            this.mSPDPath = new File(file.getAbsolutePath());
            this.setModified(false);
        }
        return true;
    }

    private boolean writeToSPDFile(String string) {
        File file = new File(string);
        if (this.writePackageFile(file.getAbsolutePath(), true)) {
            this.mSPDPath = new File(file.getAbsolutePath());
            this.setModified(false);
        }
        return true;
    }

    private boolean writeCfeFile(String string, SpecificationWriter specificationWriter) throws IOException {
        return this.writeCfeFile(string, specificationWriter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeCfeFile(String string, SpecificationWriter specificationWriter, DialogDefinition dialogDefinition) throws IOException {
        DialogDefinition dialogDefinition2 = dialogDefinition;
        if (dialogDefinition2 == null) {
            dialogDefinition2 = this.mDialog;
        }
        boolean bl = true;
        DeflaterOutputStream deflaterOutputStream = null;
        File file = null;
        OutputStream outputStream = null;
        try {
            file = BuilderUtil.getInstance().createTempFolder();
            file.delete();
            if (!file.mkdir()) {
                boolean bl2 = false;
                return bl2;
            }
            file.deleteOnExit();
            String string2 = file.getPath() + File.separator + EXT_FILE_NAME;
            new File(string2).deleteOnExit();
            if (!specificationWriter.writeCFStream(string2, true, true)) {
                boolean bl3 = false;
                return bl3;
            }
            string2 = file.getPath() + File.separator + "app-extension" + XML_FILE_EXT;
            if (!specificationWriter.writeAppExtensionsStream(string2)) {
                boolean bl4 = false;
                return bl4;
            }
            string2 = file.getPath() + File.separator + "module" + XML_FILE_EXT;
            if (!specificationWriter.writeCFModuleStream(string2)) {
                boolean bl5 = false;
                return bl5;
            }
            BuilderUtil.getInstance().writeIconFiles(file, dialogDefinition2.getScriptType());
            BuilderUtil.getInstance().writePeerJar(file, dialogDefinition2.getScriptType());
            BuilderUtil.getInstance().writePropertiesFiles(file, dialogDefinition2.getDialogId(), dialogDefinition2.getScriptType());
            outputStream = new FileOutputStream(string, false);
            deflaterOutputStream = new JarOutputStream(outputStream);
            ((ZipOutputStream)deflaterOutputStream).setMethod(8);
            this.saveToJar((JarOutputStream)deflaterOutputStream, file, false);
            LinkedList linkedList = dialogDefinition2.getPanels();
            for (PanelDefinition panelDefinition : linkedList) {
                for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                    boolean bl6;
                    DialogDefinition dialogDefinition3;
                    String string3;
                    PanelElementDefinition panelElementDefinition = panelDefinition.getPanelElement(i);
                    if (!(panelElementDefinition instanceof SubDlgButtonDefinition) || (string3 = (dialogDefinition3 = ((SubDlgButtonDefinition)panelElementDefinition).getDialogDefinition()).getHelpFileName()) == null || string3.length() <= 0 || (bl6 = string3.contains(File.separator))) continue;
                    String string4 = dialogDefinition2.getHelpFileName();
                    File file2 = new File(string4);
                    string3 = file2.getParentFile().getCanonicalPath() + File.separator + string3;
                    dialogDefinition3.setHelpFileName(string3);
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        finally {
            BuilderUtil.getInstance().cleanTempFolder(file, false);
            if (deflaterOutputStream != null && outputStream != null) {
                try {
                    deflaterOutputStream.flush();
                    ((ZipOutputStream)deflaterOutputStream).close();
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writePackageFile(String string, boolean bl) {
        boolean bl2 = true;
        DeflaterOutputStream deflaterOutputStream = null;
        File file = null;
        OutputStream outputStream = null;
        try {
            file = BuilderUtil.getInstance().createTempFolder();
            file.delete();
            if (!file.mkdir()) {
                boolean bl3 = false;
                return bl3;
            }
            file.deleteOnExit();
            DialogDefinition dialogDefinition = this.mDialog;
            String string2 = bl ? file.getPath() + File.separator + dialogDefinition.getDialogId() + XML_FILE_EXT : file.getPath() + File.separator + EXT_FILE_NAME;
            new File(string2).deleteOnExit();
            SpecificationWriter specificationWriter = new SpecificationWriter(dialogDefinition);
            if (bl) {
                if (!specificationWriter.writeClefStream(string2, true, true)) {
                    boolean bl4 = false;
                    return bl4;
                }
            } else {
                if (!specificationWriter.writeCFStream(string2, true, true)) {
                    boolean bl5 = false;
                    return bl5;
                }
                string2 = file.getPath() + File.separator + "app-extension" + XML_FILE_EXT;
                if (!specificationWriter.writeAppExtensionsStream(string2)) {
                    boolean bl6 = false;
                    return bl6;
                }
                BuilderUtil.getInstance().writePropertiesFiles(file, this.mDialog.getDialogId(), this.mDialog.getScriptType());
            }
            outputStream = new FileOutputStream(string, false);
            deflaterOutputStream = new JarOutputStream(outputStream);
            ((ZipOutputStream)deflaterOutputStream).setMethod(8);
            this.saveToJar((JarOutputStream)deflaterOutputStream, file, false);
            this.readPackageFile(new File(string), bl);
            this.addMRUItem(new File(string).getName(), string, false);
        }
        catch (IOException iOException) {
            BuilderAlertPane.showInformationMessageDialog(this, iOException.getMessage(), BuilderUtil.getInstance().getAppVersionString());
            boolean bl7 = false;
            return bl7;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = false;
        }
        finally {
            BuilderUtil.getInstance().cleanTempFolder(file, false);
            if (deflaterOutputStream != null && outputStream != null) {
                try {
                    deflaterOutputStream.flush();
                    ((ZipOutputStream)deflaterOutputStream).close();
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return bl2;
    }

    private void saveToJar(JarOutputStream jarOutputStream, File file, boolean bl) throws Exception {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            Object object;
            if (file2.isFile()) {
                object = new FileInputStream(file2);
                int n = ((FileInputStream)object).available();
                byte[] byArray = new byte[n];
                int n2 = ((FileInputStream)object).read(byArray);
                ((FileInputStream)object).close();
                if (n2 != n) {
                    throw new Exception("Can't read input bytes");
                }
                CRC32 cRC32 = new CRC32();
                cRC32.update(byArray);
                String string = bl ? file.getName() + "/" + file2.getName() : file2.getName();
                JarEntry jarEntry = new JarEntry(string);
                jarEntry.setCompressedSize(n);
                jarEntry.setCrc(cRC32.getValue());
                jarOutputStream.putNextEntry(jarEntry);
                jarOutputStream.write(byArray);
                jarOutputStream.closeEntry();
                continue;
            }
            object = file2.getName();
            if (!((String)object).endsWith(File.separator)) {
                object = (String)object + "/";
            }
            JarEntry jarEntry = new JarEntry((String)object);
            jarOutputStream.putNextEntry(jarEntry);
            jarOutputStream.closeEntry();
            this.saveToJar(jarOutputStream, file2, true);
        }
    }

    private boolean checkDuplicateDialogName(File file) {
        boolean bl = true;
        File file2 = null;
        try {
            file2 = BuilderUtil.getInstance().createTempFolder();
            file2.delete();
            if (!file2.mkdir()) {
                throw new Exception("Cannot create temp folder");
            }
            file2.deleteOnExit();
            this.mExtensionFile = null;
            this.mAppExtFile = null;
            FileInputStream fileInputStream = new FileInputStream(file);
            JarInputStream jarInputStream = new JarInputStream(fileInputStream);
            this.mExtensionFile = this.readFromJar(file2, this.mExtensionFile, jarInputStream);
            jarInputStream.close();
            if (this.mExtensionFile == null || !this.mExtensionFile.exists()) {
                throw new Exception("CLEF file does not exist");
            }
            DialogDefinition dialogDefinition = BuilderUtil.getInstance().readClefFileSpec(this.mExtensionFile, null, true);
            if (dialogDefinition != null && (this.isDlgIdExist(dialogDefinition.getDialogId()) || dialogDefinition.getDialogId().equals(this.mDialog.getDialogId()))) {
                BuilderAlertPane.showWarningMessageDialog(this, BuilderResUtil.getString("IDS_DUPLICATE_DLG_ID_CONVERT_WARNING"), BuilderUtil.getInstance().getAppVersionString());
                bl = false;
            }
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)("Error reading package file: " + exception.getMessage()), (int)15);
        }
        return bl;
    }

    private void readPackageFile(File file, boolean bl) throws Exception {
        File file2 = null;
        try {
            file2 = BuilderUtil.getInstance().createTempFolder();
            file2.delete();
            if (!file2.mkdir()) {
                throw new Exception("Cannot create temp folder");
            }
            file2.deleteOnExit();
            this.mExtensionFile = null;
            this.mAppExtFile = null;
            FileInputStream fileInputStream = new FileInputStream(file);
            JarInputStream jarInputStream = new JarInputStream(fileInputStream);
            this.mExtensionFile = bl ? this.readFromJar(file2, this.mExtensionFile, jarInputStream) : this.readCFFromJar(file2, this.mExtensionFile, jarInputStream);
            jarInputStream.close();
            if (this.mExtensionFile == null || !this.mExtensionFile.exists()) {
                throw new Exception("CLEF file does not exist");
            }
            if (bl) {
                this.setCurrentDefinition(this.mExtensionFile, null, true);
            } else {
                this.setCurrentCFDefinition(this.mExtensionFile, this.mAppExtFile, true);
            }
            this.mOpenSpecName = file.getName();
            this.mSPDPath = file;
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)("Error reading package file: " + exception.getMessage()), (int)15);
            throw exception;
        }
    }

    private File readFromJar(File file, File file2, JarInputStream jarInputStream) throws IOException {
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string = jarEntry.getName();
            ByteBuffer byteBuffer = BuilderFrame.readEntry(jarInputStream);
            File file3 = new File(file.getPath() + File.separator + string);
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            fileOutputStream.write(byteBuffer.array());
            fileOutputStream.close();
            jarInputStream.closeEntry();
            if (XML_FILE_EXT.regionMatches(true, 0, string, string.length() - XML_FILE_EXT.length(), XML_FILE_EXT.length())) {
                file2 = file3;
            }
            file3.deleteOnExit();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return file2;
    }

    private File readCFFromJar(File file, File file2, JarInputStream jarInputStream) throws IOException {
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string = jarEntry.getName();
            File file3 = new File(file.getPath() + File.separator + string);
            if (!jarEntry.isDirectory()) {
                ByteBuffer byteBuffer = BuilderFrame.readEntry(jarInputStream);
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                fileOutputStream.write(byteBuffer.array());
                fileOutputStream.close();
                jarInputStream.closeEntry();
                if (EXT_FILE_NAME.regionMatches(true, 0, string, 0, EXT_FILE_NAME.length())) {
                    this.mExtensionFile = file3;
                    file2 = file3;
                } else if (APP_EXT_FILE_NAME.regionMatches(true, 0, string, 0, APP_EXT_FILE_NAME.length())) {
                    this.mAppExtFile = file3;
                }
            } else {
                file3.mkdir();
            }
            file3.deleteOnExit();
            jarEntry = jarInputStream.getNextJarEntry();
        }
        return this.mExtensionFile;
    }

    private void setCurrentDefinition(File file) throws Exception {
        this.setCurrentDefinition(file, null, false);
    }

    private void setCurrentDefinition(File file, File file2, boolean bl) throws Exception {
        DialogDefinition dialogDefinition = BuilderUtil.getInstance().readClefFileSpec(file, file2, true);
        if (dialogDefinition == null) {
            throw new Exception("Cannot read file specification");
        }
        if (bl) {
            String string;
            String string2;
            String string3;
            File file3 = file.getParentFile();
            String string4 = dialogDefinition.getHelpFileName();
            if (string4 != null && string4.length() > 0) {
                string3 = new File(string4).getName();
                string2 = file3.getCanonicalPath() + File.separator + string3;
                dialogDefinition.setHelpFileName(string2);
            }
            if ((string3 = dialogDefinition.getCustomPropertiesFile()) != null && string3.length() > 0) {
                string2 = new File(string3).getName();
                string = file3.getCanonicalPath() + File.separator + string2;
                dialogDefinition.setCustomPropertiesFile(string);
            }
            LinkedList linkedList = dialogDefinition.getPanels();
            for (PanelDefinition panelDefinition : linkedList) {
                for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                    string = panelDefinition.getPanelElement(i);
                    if (!(string instanceof SubDlgButtonDefinition) || (string4 = (string2 = ((SubDlgButtonDefinition)string).getDialogDefinition()).getHelpFileName()) == null || string4.length() <= 0) continue;
                    String string5 = new File(string4).getName();
                    String string6 = file3.getCanonicalPath() + File.separator + string5;
                    string2.setHelpFileName(string6);
                }
            }
        }
        this.editDialogDefinition(dialogDefinition);
    }

    private void setCurrentCFDefinition(File file, File file2, boolean bl) throws Exception {
        DialogDefinition dialogDefinition = BuilderUtil.getInstance().readClefFileSpec(file, file2, false);
        if (dialogDefinition == null) {
            throw new Exception("Cannot read file specification");
        }
        dialogDefinition.setAppType(BuilderUtil.getInstance().getAppType());
        if (bl) {
            Object object;
            String string;
            String string2;
            String string3;
            File file3 = file.getParentFile();
            String string4 = dialogDefinition.getHelpFileName();
            if (string4 != null && string4.length() > 0) {
                string3 = new File(string4).getName();
                string2 = file3.getCanonicalPath() + File.separator + "helps" + File.separator + string3;
                dialogDefinition.setHelpFileName(string2);
            }
            if ((string3 = dialogDefinition.getCustomPropertiesFile()) != null && string3.length() > 0) {
                string2 = new File(string3).getName();
                string = file3.getCanonicalPath() + File.separator + string2;
                dialogDefinition.setCustomPropertiesFile(string);
            }
            if ((string2 = dialogDefinition.getNodeIconFile()) != null && string2.length() > 0) {
                string = new File(string2).getName();
                object = file3.getCanonicalPath() + File.separator + "images" + File.separator + string;
                dialogDefinition.setNodeIconFile((String)object);
            }
            LinkedList linkedList = dialogDefinition.getPanels();
            for (PanelDefinition panelDefinition : linkedList) {
                for (int i = 0; i < panelDefinition.getElementCount(); ++i) {
                    object = panelDefinition.getPanelElement(i);
                    if (!(object instanceof SubDlgButtonDefinition) || (string4 = (string = ((SubDlgButtonDefinition)object).getDialogDefinition()).getHelpFileName()) == null || string4.length() <= 0) continue;
                    String string5 = new File(string4).getName();
                    String string6 = file3.getCanonicalPath() + File.separator + "helps" + File.separator + string5;
                    string.setHelpFileName(string6);
                }
            }
        }
        dialogDefinition.setBuilderFrame((JFrame)this);
        this.editCFDialogDefinition(dialogDefinition);
    }

    private static ByteBuffer readEntry(JarInputStream jarInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        try {
            int n = jarInputStream.read(byArray, 0, 4096);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = jarInputStream.read(byArray, 0, 4096);
            }
        }
        catch (IOException iOException) {
            byteArrayOutputStream.reset();
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    protected void updateWindowMenuDocuments(JMenu jMenu) {
        JMenuItem jMenuItem;
        int n = jMenu.getItemCount();
        for (int i = n - 1; i >= 0 && (jMenuItem = jMenu.getItem(i)) != null; --i) {
            jMenu.remove(jMenuItem);
        }
        this.refreshMenuCheckStatus(jMenu);
    }

    private void refreshMenuCheckStatus(JMenu jMenu) {
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (!(jMenuItem instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jMenuItem;
            Action action = jMenuItem.getAction();
            if (!(action instanceof WindowMenuAction)) continue;
            jCheckBoxMenuItem.setSelected(((WindowMenuAction)action).getMenuItemCheckStatus());
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        Object object = menuEvent.getSource();
        if (object instanceof JMenu) {
            DialogDefinition dialogDefinition = this.mDialog;
            boolean bl = dialogDefinition != null && dialogDefinition.isSubDialog();
            JMenu jMenu = (JMenu)object;
            String string = jMenu.getText();
            if (!bl && string.equals(BuilderResUtil.getString("File"))) {
                boolean bl2 = !this.mIsCompatibleMode && this.mExtensionContainer != null && this.mExtensionContainer.isModified();
                this.mMenuSaveItem.setEnabled(this.isModified() || bl2);
                if (BuilderUtil.getInstance().getAppType() == AppType.STATS && this.mIsCompatibleMode) {
                    this.mConvertToItem.setEnabled(!this.canvasIsEmpty());
                }
            } else if (!bl && string.equals(BuilderResUtil.getString("IDS_RECENTLY_USED"))) {
                this.updateMRUMenuItems(jMenu);
            } else if (string.equals(BuilderResUtil.getString("View"))) {
                this.mViewToolboxMenuItem.setState(this.mToolPalettePanel.isVisible());
                if (!bl) {
                    this.mViewToolbarMenuItem.setState(this.mToolbar.isVisible());
                }
            } else if (!bl && string.equals(BuilderResUtil.getString("Window"))) {
                this.updateWindowMenuDocuments(jMenu);
            }
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    public int getMaxMRUItems() {
        return 10;
    }

    public static File getCanonicalFileIfNotCanonical(File file) {
        File file2 = null;
        if (file != null) {
            try {
                File file3 = new File(file.getCanonicalPath());
                if (!file3.getPath().equals(file.getPath())) {
                    file2 = new File(file3.getPath());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public boolean canSaveTo(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file = file.getParentFile();
        }
        if (!file.canWrite()) {
            String string2 = BuilderResUtil.getString("ERR_READ_ONLY_NO_ACCESS");
            BuilderAlertPane.showInformationMessageDialog(this, string2, BuilderUtil.getInstance().getAppVersionString());
            return false;
        }
        return true;
    }

    public void updateDropListenerByTabIndex(int n) {
        this.mDragPane.removeAllDropListener(BuilderCanvas.class);
        this.mTabbedPane.setSelectedIndex(n);
        this.mDragPane.addDropListener((IDropListener)this.getCanvas());
    }

    public void updateScoreTabStatus() {
        this.mSyntaxTemplateDlg.mScoreMasterPanel.getSyntaxTextPane().setEnabled(this.mDialog.canScore());
    }

    @Override
    public void tabOrderChanged(int n, int n2, boolean bl) {
        if (n == -1) {
            n = this.mTabbedPane.getSelectedIndex();
        }
        if (n2 == n) {
            return;
        }
        Component component = this.mTabbedPane.getComponentAt(n);
        Component component2 = this.mTabbedPane.getTabComponentAt(n);
        String string = this.mTabbedPane.getTitleAt(n);
        this.mTabbedPane.removeTabAt(n);
        this.mTabbedPane.insertTab(string, null, component, null, n2);
        this.mTabbedPane.setTabComponentAt(n2, component2);
        this.updateDropListenerByTabIndex(n2);
        if (bl) {
            ((TabComponent)component2).fireSelectionChange(((TabComponent)component2).getTabObject());
        }
        this.reOrderDialogPanels();
        this.mDialog.setCurrentPanel(n2);
    }

    private void selectedTabIndex(int n) {
        this.mTabbedPane.setSelectedIndex(n);
        Component component = this.mTabbedPane.getTabComponentAt(n);
        ((TabComponent)component).fireSelectionChange(((TabComponent)component).getTabObject());
        this.reOrderDialogPanels();
        this.mDialog.setCurrentPanel(n);
    }

    private void reOrderDialogPanels() {
        LinkedList linkedList = this.mDialog.getPanels();
        linkedList.clear();
        for (BuilderCanvas builderCanvas : this.mTabbedPane.getAllCanvas()) {
            linkedList.addLast(builderCanvas.getTabPanelDefinition());
        }
    }

    public void openDialogFromPES(Map<String, InputStream> map) throws Exception {
        String string = map.keySet().iterator().next();
        InputStream inputStream = map.get(string);
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        String string3 = BuilderUtil.getInstance().getTempDir().getCanonicalPath() + File.separator + string2;
        FileOutputStream fileOutputStream = new FileOutputStream(string3);
        int n = 1024;
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray, 0, n);
        while (n2 != -1) {
            fileOutputStream.write(byArray, 0, n2);
            n2 = inputStream.read(byArray, 0, n);
        }
        fileOutputStream.close();
        inputStream.close();
        File file = new File(string3);
        this.openPESFile(file, string);
        this.mSPDPath = new File(string);
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    private void openPESFile(File file, String string) throws Exception {
        this.readPackageFile(file, false);
        this.addMRUItem(file.getName(), string, false);
        this.setModified(false);
    }

    public boolean showExtensionPropertyDlg() {
        Object object;
        String string = this.mOpenSpecName;
        boolean bl = false;
        if (string.length() == 0 || string.endsWith(CFPKG_FILE_EXT) && BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
            string = this.mDialog.getDialogId();
            bl = true;
        }
        if (!string.endsWith(CFE_FILE_EXT)) {
            string = string + CFE_FILE_EXT;
        }
        BuilderUtil.getInstance().setStandalone(false);
        if (this.mExtensionContainer == null) {
            this.mExtensionContainer = new ExtensionPropertyContainer();
            this.mExtensionContainer.setVersion(sExtensionVersion);
            if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
                this.mExtensionContainer.setStatsVersion(sMinModelerVersion);
                bl = true;
                this.setModified(true);
            } else {
                this.mExtensionContainer.setStatsVersion(sMinStatsVersion);
            }
        } else {
            if (BuilderUtil.getInstance().getAppType() == AppType.MODELER && this.mExtensionContainer.getSPEfile() != null && ((String)(object = this.mExtensionContainer.getSPEfile().getAbsolutePath())).length() > 0) {
                try {
                    this.mExtensionContainer = new ExtensionPropertyContainer((String)object);
                    this.mExtensionContainer.setTargetFilePath("");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (BuilderUtil.getInstance().getAppType() == AppType.MODELER && this.mExtensionContainer.getDialogSpecsSet().size() == 0) {
                bl = true;
            }
        }
        object = new ExtensionPropertyDlg(this, this.mExtensionContainer, string, bl);
        object.setVisible(true);
        if (((ExtensionPropertyDlg)object).continuePressed()) {
            String string2;
            if (!bl) {
                this.mExtensionContainer.addCFEfileWithPath(this.mSPDPath.getAbsolutePath());
                string2 = this.mOpenSpecName;
                if (!string2.endsWith(CFE_FILE_EXT)) {
                    string2 = string2 + CFE_FILE_EXT;
                }
                this.mExtensionContainer.addOneCFEfileName(string2);
            }
            string2 = "";
            if (this.mSPDPath != null) {
                string2 = this.mSPDPath.getAbsolutePath();
            }
            this.updateExtensionMenu(this.mOpenSpecName, string2);
            this.updateToolbarButtons();
            return true;
        }
        return false;
    }

    public void saveDialogToPES(JComponent jComponent) throws Exception {
        String string = BuilderUtil.getInstance().getTempDir().getCanonicalPath() + File.separator + this.mDialog.getDialogId() + CFPKG_FILE_EXT;
        this.mSPDPath = new File(string);
        this.mSaveAction.actionPerformed(null);
        FileInputStream fileInputStream = new FileInputStream(this.mSPDPath);
        fileInputStream.close();
        if (!this.mSPDPath.delete()) {
            this.mSPDPath.deleteOnExit();
        }
    }

    public String getMenuName(String string) {
        if (this.mDlgExecutor != null) {
            return this.mDlgExecutor.getMenuName(string);
        }
        return "";
    }

    public void saveConvertDontShow(boolean bl) {
        if (this.mDlgExecutor != null) {
            this.mDlgExecutor.setConvertDontShowSetting(bl);
        }
    }

    public boolean showConvertAlert() {
        if (this.mDlgExecutor != null) {
            return this.mDlgExecutor.showConvertAlert();
        }
        return false;
    }

    public void saveExtPropDontShow(boolean bl) {
        if (this.mDlgExecutor != null) {
            this.mDlgExecutor.setExtPropDontShow(bl);
        }
    }

    public boolean showExtPropAlert() {
        if (this.mDlgExecutor != null) {
            return this.mDlgExecutor.showExtPropAlert();
        }
        return false;
    }

    private void testSPDExecute() {
        DialogDefinition dialogDefinition = this.getDialogDefinition();
        if (!this.mDlgExecutor.testDialog(this, dialogDefinition)) {
            BuilderAlertPane.showWarningMessageDialog(this, BuilderResUtil.getString("IDS_ERROR_EXECUTING_DLG"), BuilderUtil.getInstance().getAppVersionString());
        }
    }

    private String getSavePath() {
        String string;
        FileFilter fileFilter;
        String string2 = "";
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, BuilderUtil.getInstance().getRecentFilesDirectoryPath(), false, false, true);
        String string3 = "";
        remoteFileChooser.setDialogTitle(BuilderResUtil.getString("IDS_SAVE_CLEF_DLG_TITLE"));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
            if (this.mIsCompatibleMode) {
                fileFilter = new UiPkgFilter();
                string3 = BuilderFrame.getBuilderSPDExpension();
                bl = true;
            } else {
                fileFilter = new SPDXFilter();
                string3 = BuilderFrame.getBuilderSPDXExpension();
                bl3 = true;
            }
        } else {
            fileFilter = new CfdFilter();
            string3 = "." + BuilderFrame.getBuilderPkgExtension();
            bl2 = true;
        }
        remoteFileChooser.addChoosableFileFilter(fileFilter);
        remoteFileChooser.setFileFilter(fileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        DialogDefinition dialogDefinition = this.mDialog;
        if (this.mSPDPath != null) {
            string = this.mSPDPath.getName();
            if (string.endsWith(UIPKG_FILE_EXT) && !bl) {
                string = string.substring(0, string.length() - UIPKG_FILE_EXT.length()) + SPDXPKG_FILE_EXT;
            }
        } else {
            string = dialogDefinition.getDialogId() + string3;
        }
        if (string.endsWith(CFE_FILE_EXT)) {
            string = string.substring(0, string.lastIndexOf(CFE_FILE_EXT)) + "." + BuilderFrame.getBuilderPkgExtension();
        }
        ((BasicFileChooserUI)remoteFileChooser.getUI()).setFileName(string);
        int n = remoteFileChooser.showSaveDialog(this);
        if (n == 0) {
            BuilderUtil.getInstance().setRecentFilesDirectoryPath(remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            string2 = remoteFileChooser.getSelectedFilePath();
        }
        return string2;
    }

    private String getMPESavePath() {
        String string;
        String string2 = "";
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, BuilderUtil.getInstance().getRecentFilesDirectoryPath(), false, false, true);
        remoteFileChooser.setDialogTitle(BuilderResUtil.getString("IDS_SAVE_SPE_DLG_TITLE"));
        MpeFilter mpeFilter = new MpeFilter();
        remoteFileChooser.addChoosableFileFilter(mpeFilter);
        remoteFileChooser.setFileFilter(mpeFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        DialogDefinition dialogDefinition = this.mDialog;
        if (this.mSPEPath != null) {
            string = this.mSPEPath.getName();
            if (string.endsWith(MPEPKG_FILE_EXT)) {
                string = string.substring(0, string.length() - MPEPKG_FILE_EXT.length()) + MPEPKG_FILE_EXT;
            }
        } else {
            string = this.mExtensionContainer != null && this.mExtensionContainer.getName() != null ? this.mExtensionContainer.getName() + MPEPKG_FILE_EXT : dialogDefinition.getDialogId() + MPEPKG_FILE_EXT;
        }
        ((BasicFileChooserUI)remoteFileChooser.getUI()).setFileName(string);
        int n = remoteFileChooser.showSaveDialog(this);
        if (n == 0) {
            BuilderUtil.getInstance().setRecentFilesDirectoryPath(remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            string2 = remoteFileChooser.getSelectedFilePath();
        }
        return string2;
    }

    private File getOpenFile() {
        File file = null;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, BuilderUtil.getInstance().getRecentFilesDirectoryPath(), false);
        remoteFileChooser.setDialogTitle(BuilderResUtil.getString("IDS_OPEN_SPE_DLG_TITLE"));
        FileFilter fileFilter = BuilderUtil.getInstance().getAppType() == AppType.STATS ? (this.mIsCompatibleMode ? new UiPkgFilter() : new SPDXFilter()) : new MpeFilter();
        remoteFileChooser.addChoosableFileFilter(fileFilter);
        remoteFileChooser.setFileFilter(fileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showOpenDialog(this);
        if (n == 0) {
            BuilderUtil.getInstance().setRecentFilesDirectoryPath(remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            file = remoteFileChooser.getSelectedFile();
        }
        return file;
    }

    private File importCfdFile() {
        File file = null;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, BuilderUtil.getInstance().getRecentFilesDirectoryPath(), false);
        remoteFileChooser.setDialogTitle(BuilderResUtil.getString("IDS_OPEN_CLEF_DLG_TITLE"));
        FileFilter fileFilter = BuilderUtil.getInstance().getAppType() == AppType.STATS ? (this.mIsCompatibleMode ? new UiPkgFilter() : new SPDXFilter()) : new CfdFilter();
        remoteFileChooser.addChoosableFileFilter(fileFilter);
        remoteFileChooser.setFileFilter(fileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showOpenDialog(this);
        if (n == 0) {
            BuilderUtil.getInstance().setRecentFilesDirectoryPath(remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            file = remoteFileChooser.getSelectedFile();
        }
        return file;
    }

    class SPDConvertToEnhancedAlertDlg
    extends BuilderAlertDialog {
        public SPDConvertToEnhancedAlertDlg(JFrame jFrame, String string, String string2) {
            super(jFrame, BuilderResUtil.getBundle(BuilderResBundle.getDefaultResourceBundleName(), BuilderUtil.getInstance().getAppLocale()), string, string2, BuilderAlertPane.IconType.eWarning, BuilderAlertPane.OptionType.YES_NO_OPTION, (Object[])new String[]{BuilderResUtil.getString("IDS_YES"), BuilderResUtil.getString("IDS_NO")}, (Object)BuilderResUtil.getString("IDS_YES"));
            this.setLocationRelativeTo(jFrame);
        }
    }

    class SyntaxDiagramDlgCallback
    implements SyntaxDiagramDlg.SyntaxDiagramDlgCallback {
        SyntaxDiagramDlgCallback() {
        }

        @Override
        public void syntaxModifiedNotification() {
            BuilderFrame.this.setDialogSyntax();
        }

        @Override
        public void showHelp() {
            BuilderUtil.getInstance().showHelp("clementine/idh_idd_uibuilder_syntemplate");
        }

        @Override
        public boolean showInvalidSyntaxWarning() {
            int n = BuilderAlertPane.showConfirmDialog(BuilderFrame.this, BuilderResUtil.getString("IDS_INVALID_SYNTAX_WARNING"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION);
            return n == 2;
        }
    }

    class MRUSpec {
        private String mName;
        private String mFullPath;
        private boolean mIsDeployed;

        MRUSpec(String string, String string2, boolean bl) {
            this.mIsDeployed = bl;
            this.mName = string;
            this.mFullPath = string2;
        }

        public boolean isDeployed() {
            return this.mIsDeployed;
        }

        public String getName() {
            return this.mName;
        }

        public String getFullPath() {
            return this.mFullPath;
        }
    }

    class BuilderMRUAction
    extends AbstractAction {
        private String mSpecName;
        private String mSpecPath;
        private boolean mDeployed;

        BuilderMRUAction(String string, int n, boolean bl, String string2) {
            super(n + " " + string + (bl ? " [" + BuilderResUtil.getString("IDS_DEPLOYED") + "]" : ""));
            if (n == 10) {
                this.putValue("MnemonicKey", 48);
            } else {
                this.putValue("MnemonicKey", 48 + n);
            }
            this.mSpecName = string;
            this.mSpecPath = string2;
            this.mDeployed = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            try {
                if (!BuilderFrame.this.checkModified(false)) {
                    return;
                }
                if (this.mDeployed) {
                    String string = this.mSpecPath;
                    if (string == null || string.length() == 0) {
                        string = BuilderUtil.getInstance().getAppType() == AppType.STATS ? BuilderUtil.getInstance().getExtensionBundlePath().get(0) : BuilderUtil.getInstance().getExtensionPath().getAbsolutePath();
                    }
                    if (this.mSpecName.endsWith(BuilderFrame.SPEPKG_FILE_EXT) || this.mSpecName.endsWith(BuilderFrame.MPEPKG_FILE_EXT)) {
                        File file = new File(string);
                        if (!file.isFile()) {
                            String string2 = this.mSpecName.substring(0, this.mSpecName.indexOf("."));
                            file = new File(string + File.separator + string2 + File.separator + this.mSpecName);
                        }
                        if (file.exists()) {
                            BuilderFrame.this.openSPEFile(file);
                            BuilderFrame.this.mSPEPath = file;
                            BuilderFrame.this.mIsModified = false;
                            bl = true;
                        } else {
                            bl = false;
                        }
                    } else {
                        File file = new File(string + File.separator + this.mSpecName + BuilderFrame.XML_FILE_EXT);
                        if (file.exists()) {
                            BuilderFrame.this.setCurrentDefinition(file);
                        } else {
                            file = new File(string + BuilderFrame.CFE_FILE_EXT);
                            if (BuilderUtil.getInstance().isCfeFile(file)) {
                                BuilderFrame.this.readPackageFile(file, false);
                            } else {
                                file = new File(string + File.separator + this.mSpecName + BuilderFrame.CFE_FILE_EXT);
                                if (BuilderUtil.getInstance().isCfeFile(file)) {
                                    BuilderFrame.this.readPackageFile(file, false);
                                } else {
                                    bl = false;
                                }
                            }
                        }
                    }
                } else {
                    File file = new File(this.mSpecPath);
                    if (file.exists()) {
                        if (file.getPath().endsWith(BuilderFrame.SPEPKG_FILE_EXT) || file.getPath().endsWith(BuilderFrame.MPEPKG_FILE_EXT)) {
                            BuilderFrame.this.openSPEFile(file);
                            BuilderFrame.this.mSPEPath = file;
                        } else if (file.getAbsolutePath().endsWith(BuilderFrame.CFPKG_FILE_EXT) || file.getAbsolutePath().endsWith(BuilderFrame.SPDXPKG_FILE_EXT)) {
                            BuilderFrame.this.readPackageFile(file, false);
                        } else {
                            BuilderFrame.this.readPackageFile(file, true);
                        }
                    } else {
                        bl = false;
                    }
                }
                if (bl) {
                    BuilderFrame.this.addMRUItem(this.mSpecName, this.mSpecPath, this.mDeployed);
                    BuilderFrame.this.mOpenSpecName = this.mSpecName;
                    BuilderFrame.this.setModified(false);
                    BuilderFrame.this.getCanvas().repaint(100L);
                }
            }
            catch (Exception exception) {
                bl = false;
                exception.printStackTrace();
            }
            if (!bl) {
                BuilderFrame.this.removeMRUSpec(this.mSpecName);
                BuilderAlertPane.showErrorMessageDialog(BuilderFrame.this, BuilderResUtil.getString("IDS_BAD_CLEF_FILE_MSG"), BuilderUtil.getInstance().getAppVersionString());
            }
        }
    }

    class XmlFilter
    implements FilenameFilter {
        XmlFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return BuilderFrame.XML_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.XML_FILE_EXT.length(), BuilderFrame.XML_FILE_EXT.length());
        }
    }

    class SPDXFilter
    extends FileFilter {
        SPDXFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return BuilderFrame.SPDXPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.SPDXPKG_FILE_EXT.length(), BuilderFrame.SPDXPKG_FILE_EXT.length());
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString("IDS_SPDX_FILE_DESC");
        }
    }

    class MpeFilter
    extends FileFilter {
        MpeFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return BuilderFrame.MPEPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.MPEPKG_FILE_EXT.length(), BuilderFrame.MPEPKG_FILE_EXT.length());
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString("IDS_SPE_FILE_DESC_MODELER");
        }
    }

    class CfdFilter
    extends FileFilter {
        CfdFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return BuilderFrame.CFPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.CFPKG_FILE_EXT.length(), BuilderFrame.CFPKG_FILE_EXT.length());
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString("IDS_CFD_FILE_DESC");
        }
    }

    class UiPkgFilter
    extends FileFilter {
        UiPkgFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return BuilderFrame.UIPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.UIPKG_FILE_EXT.length(), BuilderFrame.UIPKG_FILE_EXT.length());
        }

        @Override
        public String getDescription() {
            return BuilderResUtil.getString("IDS_PKG_FILE_DESC");
        }
    }

    class ExtensionPropertyAction
    extends AbstractAction {
        private boolean mFromEditMenu;

        public ExtensionPropertyAction(boolean bl) {
            this.mFromEditMenu = bl;
            this.putValue("Name", BuilderResUtil.getString("extension_property"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("extension_property"));
            KeyStroke keyStroke = BuilderResUtil.getShortcut("extension_property");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            BuilderFrame.this.showExtensionPropertyDlg();
        }
    }

    class HelpTutorialAction
    extends AbstractAction {
        public HelpTutorialAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("help_tutorial_TOOLTIP"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("help_tutorial"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("help_tutorial"));
                KeyStroke keyStroke = BuilderResUtil.getShortcut("help_tutorial");
                if (keyStroke != null) {
                    this.putValue("AcceleratorKey", keyStroke);
                }
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("HelpTutorial.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.TUTORIAL, "dialogbuilder_intro");
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("help_topics_TOOLTIP"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("help_topics"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("help_topics"));
                KeyStroke keyStroke = BuilderResUtil.getShortcut("help_topics");
                if (keyStroke != null) {
                    this.putValue("AcceleratorKey", keyStroke);
                }
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("HelpAbout.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuilderUtil.getInstance().showHelp("spss/base/idh_idd_uibuilder");
        }
    }

    class ViewHeaderFooterAction
    extends AbstractAction {
        public ViewHeaderFooterAction() {
            this.putValue("Name", BuilderResUtil.getString("IDS_VIEW_HADER_FOOTER"));
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_VIEW_HADER_FOOTER"));
            KeyStroke keyStroke = BuilderResUtil.getShortcut("IDS_VIEW_HADER_FOOTER");
            if (keyStroke != null) {
                this.putValue("AcceleratorKey", keyStroke);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BuilderFrame.this.mIsTabbedDlg) {
                BuilderFrame.this.mHeaderCanvas.setVisible(!BuilderFrame.this.mHeaderCanvas.isVisible());
                BuilderFrame.this.mFooterCanvas.setVisible(!BuilderFrame.this.mFooterCanvas.isVisible());
            } else {
                Component[] componentArray = BuilderFrame.this.mTabbedPane.getComponents();
                if (componentArray != null) {
                    for (Component component : componentArray) {
                        BuilderCanvas builderCanvas;
                        if (!(component instanceof JSplitPane)) continue;
                        JSplitPane jSplitPane = (JSplitPane)component;
                        JSplitPane jSplitPane2 = (JSplitPane)jSplitPane.getLeftComponent();
                        builderCanvas.setVisible(!(builderCanvas = (BuilderCanvas)jSplitPane2.getTopComponent()).isVisible());
                        BuilderCanvas builderCanvas2 = (BuilderCanvas)jSplitPane.getRightComponent();
                        builderCanvas2.setVisible(!builderCanvas2.isVisible());
                    }
                }
            }
        }
    }

    class ViewToolbarAction
    extends AbstractAction {
        public ViewToolbarAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_VIEW_TOOLBAR_DESC"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_VIEW_TOOLBAR"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_VIEW_TOOLBAR"));
                KeyStroke keyStroke = BuilderResUtil.getShortcut("IDS_VIEW_TOOLBAR");
                if (keyStroke != null) {
                    this.putValue("AcceleratorKey", keyStroke);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuilderFrame.this.mToolbar.setVisible(!BuilderFrame.this.mToolbar.isVisible());
        }
    }

    class ViewToolboxAction
    extends AbstractAction {
        public ViewToolboxAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_VIEW_TOOLBOX_DESC"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_VIEW_TOOLBOX"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_VIEW_TOOLBOX"));
                KeyStroke keyStroke = BuilderResUtil.getShortcut("IDS_VIEW_TOOLBOX");
                if (keyStroke != null) {
                    this.putValue("AcceleratorKey", keyStroke);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuilderFrame.this.mToolPalettePanel.setVisible(!BuilderFrame.this.mToolPalettePanel.isVisible());
            BuilderFrame.this.mToolPalettePane.setVisible(BuilderFrame.this.mToolPalettePanel.isVisible());
            if (!BuilderFrame.this.mToolPalettePanel.isVisible()) {
                BuilderFrame.this.mLeftSplitPane.setDividerLocation(((BuilderFrame)BuilderFrame.this).mLeftSplitPane.getLocation().x);
            } else {
                BuilderFrame.this.mLeftSplitPane.setDividerLocation(150);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction(boolean bl) {
            if (!bl) {
                this.putValue("Name", BuilderResUtil.getString("file_close"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("file_close"));
                KeyStroke keyStroke = BuilderResUtil.getShortcut("file_close");
                if (keyStroke != null) {
                    this.putValue("AcceleratorKey", keyStroke);
                }
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("FileClose.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BuilderFrame.this.doClose()) {
                BuilderFrame.this.saveState();
                BuilderFrame.this.dispose();
            }
        }
    }

    class UndeployAction
    extends AbstractAction {
        public UndeployAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_UNDEPLOY_SPEC_TIP"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_UNDEPLOY_SPEC"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_UNDEPLOY_SPEC"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string;
                String string2 = BuilderResUtil.getString("IDS_REMOVE_DEPLOYED_DLG_TITLE");
                if (BuilderUtil.getInstance().getAppType() == AppType.STATS && !BuilderFrame.this.mIsCompatibleMode || BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
                    string2 = BuilderResUtil.getString("IDS_REMOVE_DEPLOYED_BUNDLE_TITLE");
                }
                if ((string = OpenDeployedDlg.doRemoveDeployedDlg(BuilderFrame.this, string2)) == null || string.length() == 0) {
                    return;
                }
                if (BuilderFrame.this.mIsCompatibleMode) {
                    BuilderFrame.this.removeDeployed(string, string2);
                } else {
                    BuilderFrame.this.removeDeployedSPE(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class DeployAction
    extends AbstractAction {
        public DeployAction(boolean bl) {
            if (bl) {
                if (BuilderFrame.this.IsCompatibleMode()) {
                    this.putValue("ShortDescription", BuilderResUtil.getString("IDS_SAVE_DEPLOYED_SPEC_TIP"));
                } else {
                    this.putValue("ShortDescription", BuilderResUtil.getString("IDS_SAVE_DEPLOYED_EXTENSION_TIP"));
                }
                this.putValue("Name", BuilderResUtil.getString("IDS_SAVE_DEPLOYED_SPEC"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_SAVE_DEPLOYED_SPEC"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_SAVE_DEPLOYED_SPEC"));
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("export_spec.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BuilderFrame.this.isModified() && !BuilderFrame.this.commitEdits(true)) {
                return;
            }
            BuilderFrame.this.mSpdNameDlgID = null;
            if (BuilderFrame.this.mIsCompatibleMode) {
                BuilderFrame.this.deploySpecification(true);
            } else {
                BuilderFrame.this.deployExtensionBundle(true, false);
            }
        }
    }

    class ReadDeployedAction
    extends AbstractAction {
        public ReadDeployedAction(boolean bl) {
            if (bl) {
                if (BuilderFrame.this.IsCompatibleMode()) {
                    this.putValue("ShortDescription", BuilderResUtil.getString("IDS_OPEN_DEPLOYED_SPEC_TIP"));
                } else {
                    this.putValue("ShortDescription", BuilderResUtil.getString("IDS_OPEN_DEPLOYED_EXTENSION_TIP"));
                }
                this.putValue("Name", BuilderResUtil.getString("IDS_OPEN_DEPLOYED_SPEC"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_OPEN_DEPLOYED_SPEC") + "...");
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_OPEN_DEPLOYED_SPEC"));
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("import_spec.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BuilderFrame.this.checkModified(false)) {
                return;
            }
            BuilderFrame.this.openDeployedSpecification();
        }
    }

    class TestDlgAction
    extends AbstractAction {
        public TestDlgAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_TEST_DLG_TIP"));
                this.putValue("Name", BuilderResUtil.getString("IDS_TEST_DLG_TOOLBAR"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_TEST_DLG") + "...");
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_TEST_DLG"));
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("test_dlg.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BuilderFrame.this.getDialogDefinition().getDialogId().contains(" ")) {
                BuilderAlertPane.showWarningMessageDialog(BuilderFrame.this, BuilderResUtil.getString("IDS_IDS_CANT_HAVE_SPACES"), BuilderUtil.getInstance().getAppVersionString());
                return;
            }
            BuilderFrame.this.mPropsPanel.commitEdits();
            if (!BuilderFrame.this.commitEdits(false)) {
                return;
            }
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS && BuilderFrame.this.IsCompatibleMode()) {
                if (BuilderFrame.this.mDlgExecutor != null) {
                    BuilderFrame.this.testSPDExecute();
                }
            } else {
                PreviewDialog previewDialog = new PreviewDialog(BuilderFrame.this, true);
                if (BuilderFrame.this.mDlgExecutor != null && BuilderUtil.getInstance().getAppType() == AppType.STATS && previewDialog.getFeatureUI() != null) {
                    BuilderFrame.this.mDlgExecutor.testDialog(BuilderFrame.this, previewDialog.getTitle(), previewDialog.getFeature(), (FeatureUI)previewDialog.getFeatureUI(), false);
                } else {
                    previewDialog.setVisible(true);
                }
            }
        }
    }

    class NewAction
    extends AbstractAction {
        private boolean mIsNewBundle;

        public NewAction(boolean bl, boolean bl2) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getTooltip("file_new"));
                this.putValue("Name", BuilderResUtil.getString("file_new"));
            } else if (bl2) {
                this.putValue("Name", BuilderResUtil.getString("file_new"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("file_new"));
                KeyStroke keyStroke = BuilderResUtil.getShortcut("file_new");
                if (keyStroke != null) {
                    this.putValue("AcceleratorKey", keyStroke);
                }
            } else {
                this.putValue("Name", BuilderResUtil.getString("extension_new"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("extension_new"));
                KeyStroke keyStroke = BuilderResUtil.getShortcut("extension_new");
                if (keyStroke != null) {
                    this.putValue("AcceleratorKey", keyStroke);
                }
            }
            this.mIsNewBundle = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.mIsNewBundle) {
                BuilderFrame.this.mConvertMenuVisible = true;
                if (!BuilderFrame.this.checkModified(false)) {
                    return;
                }
            } else if (!BuilderFrame.this.checkCurrentDlgModified(true)) {
                return;
            }
            BuilderFrame.this.doReset();
            if (this.mIsNewBundle && !BuilderFrame.this.mIsCompatibleMode) {
                BuilderFrame.this.newPropertyContainer();
            }
        }
    }

    class MenuLocationAction
    extends AbstractAction {
        public MenuLocationAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_MENU_LOCATION_TIP"));
                this.putValue("Name", BuilderResUtil.getString("IDS_MENU_LOCATION"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_MENU_LOCATION"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_MENU_LOCATION"));
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("properties.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuilderFrame.this.runMenuLocationDlg();
        }
    }

    public static class DialogDefinitionHelper {
        ArrayList<String> mControlIds = new ArrayList();

        public ArrayList<String> getControlIds(DialogDefinition dialogDefinition) {
            this.mControlIds = new ArrayList();
            this.loadControlIds(dialogDefinition);
            return this.mControlIds;
        }

        private void loadControlIds(DialogDefinition dialogDefinition) {
            this.mControlIds = new ArrayList();
            this.loadMainPanelIds(dialogDefinition);
        }

        private void loadMainPanelIds(DialogDefinition dialogDefinition) {
            for (PanelDefinition panelDefinition : dialogDefinition.getPanels()) {
                this.loadSubPanelIds((PanelElementDefinition)panelDefinition);
            }
        }

        private void loadSubPanelIds(PanelElementDefinition panelElementDefinition) {
            int n;
            if (panelElementDefinition instanceof PanelDefinition) {
                n = ((PanelDefinition)panelElementDefinition).getElementCount();
            } else if (panelElementDefinition instanceof RadioItemDefinition) {
                n = ((RadioItemDefinition)panelElementDefinition).getElementCount();
            } else {
                return;
            }
            for (int i = 0; i < n; ++i) {
                DialogDefinition dialogDefinition;
                PanelElementDefinition panelElementDefinition2 = panelElementDefinition instanceof PanelDefinition ? ((PanelDefinition)panelElementDefinition).getPanelElement(i) : ((RadioItemDefinition)panelElementDefinition).getPanelElement(i);
                if (panelElementDefinition2 instanceof SrcListDefinition || panelElementDefinition2 instanceof StaticCtrlDefinition) continue;
                if (panelElementDefinition2 instanceof SubDlgButtonDefinition) {
                    dialogDefinition = ((SubDlgButtonDefinition)panelElementDefinition2).getDialogDefinition();
                    this.mControlIds.add(dialogDefinition.getDialogId());
                    this.loadMainPanelIds(dialogDefinition);
                    continue;
                }
                this.mControlIds.add(panelElementDefinition2.getControlId());
                if (panelElementDefinition2 instanceof PanelDefinition) {
                    this.loadSubPanelIds(panelElementDefinition2);
                    continue;
                }
                if (!(panelElementDefinition2 instanceof RadioGroupDefinition)) continue;
                dialogDefinition = (RadioGroupDefinition)panelElementDefinition2;
                for (int j = 0; j < dialogDefinition.radioItemCount(); ++j) {
                    this.loadSubPanelIds((PanelElementDefinition)dialogDefinition.getRadioItem(j));
                }
            }
        }
    }

    class SyntaxDiagramAction
    extends AbstractAction {
        BaseDialog mSyntaxDiagramDlg;

        public SyntaxDiagramAction(boolean bl) {
            if (bl) {
                if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                    this.putValue("ShortDescription", BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM_TIP"));
                    this.putValue("Name", BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM"));
                } else {
                    this.putValue("ShortDescription", BuilderResUtil.getString("IDS_SCRIPT_DIAGRAM_TIP"));
                }
            } else if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                this.putValue("Name", BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_SYNTAX_DIAGRAM"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_SCRIPT_DIAGRAM"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDS_SCRIPT_DIAGRAM"));
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("syntax_diagram.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getDialogSyntax();
            DialogDefinitionHelper dialogDefinitionHelper = new DialogDefinitionHelper();
            if (BuilderFrame.this.mDialog.getAppType() == AppType.STATS) {
                String string2 = BuilderResUtil.getString("IDS_SYNTAX_DIAGRAM") + " - " + BuilderFrame.this.getDialogTitle();
                this.mSyntaxDiagramDlg = new SyntaxDiagramDlg(BuilderFrame.this, string2, string, dialogDefinitionHelper.getControlIds(this.getMainDialogDefinition()), BuilderFrame.this.getSyntaxCommand(), new SyntaxDiagramDlgCallback());
            } else {
                String string3 = BuilderResUtil.getString("IDS_SCRIPT_DIAGRAM") + " - " + BuilderFrame.this.getDialogTitle();
                this.mSyntaxDiagramDlg = new SyntaxDiagramDlg(BuilderFrame.this, string3, string, dialogDefinitionHelper.getControlIds(this.getMainDialogDefinition()), BuilderFrame.this.getSyntaxCommand(), new SyntaxDiagramDlgCallback());
                ((SyntaxDiagramDlg)this.mSyntaxDiagramDlg).setScoreScript(BuilderFrame.this.mSyntaxTemplateDlg.getScoreScript());
            }
            ((SyntaxDiagramDlg)this.mSyntaxDiagramDlg).setAllCanvasObjects(BuilderFrame.this.mSyntaxTemplateDlg.getAllCanvasObjects());
            ((SyntaxDiagramDlg)this.mSyntaxDiagramDlg).setSyntax(BuilderFrame.this.mSyntaxTemplateDlg.getSyntax());
            this.mSyntaxDiagramDlg.setVisible(true);
            if (this.mSyntaxDiagramDlg instanceof ScriptDiagramDlg) {
                if (((ScriptDiagramDlg)this.mSyntaxDiagramDlg).getModalResult()) {
                    BuilderFrame.this.getCanvas().fireSelectionChange(BuilderFrame.this.getCanvas().getSelectedObject());
                    BuilderFrame.this.setModified(true);
                }
            } else if (((SyntaxDiagramDlg)this.mSyntaxDiagramDlg).getModalResult()) {
                BuilderFrame.this.getCanvas().fireSelectionChange(BuilderFrame.this.getCanvas().getSelectedObject());
                BuilderFrame.this.setModified(true);
            }
        }

        private String getDialogSyntax() {
            DialogDefinition dialogDefinition = this.getMainDialogDefinition();
            return dialogDefinition.getDialogSyntax();
        }

        private String getScoreScript() {
            DialogDefinition dialogDefinition = this.getMainDialogDefinition();
            return dialogDefinition.getRScoringScript();
        }

        private DialogDefinition getMainDialogDefinition() {
            DialogDefinition dialogDefinition = BuilderFrame.this.mDialog;
            if (dialogDefinition.isSubDialog()) {
                dialogDefinition = dialogDefinition.getParentDefinition();
            }
            return dialogDefinition;
        }

        public void addControlID(CanvasObject canvasObject) {
            if (this.mSyntaxDiagramDlg instanceof SyntaxDiagramDlg) {
                ((SyntaxDiagramDlg)this.mSyntaxDiagramDlg).addControlID(canvasObject);
            }
        }

        public void insertControlID(String string) {
            if (this.mSyntaxDiagramDlg instanceof SyntaxDiagramDlg) {
                ((SyntaxDiagramDlg)this.mSyntaxDiagramDlg).insertControlSyntax(string);
            }
        }

        public void removeControlID(CanvasObject canvasObject) {
            if (this.mSyntaxDiagramDlg instanceof SyntaxDiagramDlg) {
                ((SyntaxDiagramDlg)this.mSyntaxDiagramDlg).removeControlID(canvasObject);
            }
        }

        public void removeControlID(String string) {
            if (this.mSyntaxDiagramDlg instanceof SyntaxDiagramDlg) {
                ((SyntaxDiagramDlg)this.mSyntaxDiagramDlg).removeControlID(string);
            }
        }

        public void resetID() {
            if (this.mSyntaxDiagramDlg instanceof SyntaxDiagramDlg) {
                ((SyntaxDiagramDlg)this.mSyntaxDiagramDlg).resetID();
                BuilderFrame.this.mSyntaxTemplateDlg.setSyntax("");
            }
        }

        public boolean commitEdits(boolean bl) {
            if (this.mSyntaxDiagramDlg instanceof SyntaxDiagramDlg) {
                return ((SyntaxDiagramDlg)this.mSyntaxDiagramDlg).commitEdits(bl);
            }
            return true;
        }

        private class SyntaxDiagramDlgCallback
        implements SyntaxDiagramDlg.SyntaxDiagramDlgCallback {
            private SyntaxDiagramDlgCallback() {
            }

            @Override
            public void syntaxModifiedNotification() {
                SyntaxDiagramAction.this.getMainDialogDefinition().setDialogSyntax(((SyntaxDiagramDlg)SyntaxDiagramAction.this.mSyntaxDiagramDlg).getSyntax());
                if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
                    SyntaxDiagramAction.this.getMainDialogDefinition().setRScoringScript(((SyntaxDiagramDlg)SyntaxDiagramAction.this.mSyntaxDiagramDlg).getScoreScript());
                }
                BuilderFrame.this.setModified(true);
            }

            @Override
            public void showHelp() {
                BuilderUtil.getInstance().showHelp("clementine/idh_idd_uibuilder_syntemplate");
            }

            @Override
            public boolean showInvalidSyntaxWarning() {
                int n = BuilderAlertPane.showConfirmDialog(BuilderFrame.this, BuilderResUtil.getString("IDS_INVALID_SYNTAX_WARNING"), BuilderUtil.getInstance().getAppVersionString(), BuilderAlertPane.OptionType.YES_NO_OPTION);
                return n == 2;
            }
        }
    }

    class LayoutAction
    extends AbstractAction {
        public LayoutAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_DO_LAYOUT_TIP"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("IDS_DO_LAYOUT"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("IDK_DO_LAYOUT"));
            }
            this.putValue("SmallIcon", new ImageIcon(BuilderResUtil.getImageResource("do_layout.png")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = BuilderFrame.this.getCanvas().isLayoutOn();
            BuilderFrame.this.getCanvas().setLayoutOn(true);
            BuilderFrame.this.getCanvas().invalidate();
            BuilderFrame.this.validate();
            BuilderFrame.this.getCanvas().setLayoutOn(bl);
            if (!bl) {
                BuilderFrame.this.setModified(true);
            }
        }
    }

    class SaveAsAction
    extends AbstractAction {
        public SaveAsAction(boolean bl) {
            Serializable serializable;
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("file_save_as_TOOLTIP"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("file_save_as"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("file_save_as"));
                serializable = BuilderResUtil.getShortcut("file_save_as");
                if (serializable != null) {
                    this.putValue("AcceleratorKey", serializable);
                }
            }
            serializable = BuilderResUtil.getImageURL("file_save_as");
            if (serializable != null) {
                this.putValue("SmallIcon", new ImageIcon((URL)serializable));
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BuilderFrame.this.commitEdits(true)) {
                return;
            }
            if (BuilderFrame.this.getDialogDefinition().getDialogId().contains(" ")) {
                BuilderAlertPane.showWarningMessageDialog(BuilderFrame.this, BuilderResUtil.getString("IDS_IDS_CANT_HAVE_SPACES"), BuilderUtil.getInstance().getAppVersionString());
                return;
            }
            if (BuilderUtil.getInstance().getAppType() == AppType.MODELER && !BuilderUtil.isValidTitle(BuilderFrame.this.mDialog.getDialogTitle())) {
                BuilderFrame.this.checkForNodeLocation(BuilderFrame.this.mDialog);
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS && !BuilderFrame.this.mIsCompatibleMode) {
                BuilderFrame.this.doSaveSPEfile(true);
                return;
            }
            if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
                BuilderFrame.this.doSaveMPEfile(true);
                return;
            }
            String string = "";
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                if (BuilderFrame.this.mIsCompatibleMode) {
                    bl = true;
                } else {
                    bl3 = true;
                }
                string = BuilderFrame.this.mDlgExecutor != null ? BuilderFrame.this.mDlgExecutor.getSaveFilePath(bl, BuilderFrame.this.mSPDPath, BuilderFrame.this.mDialog, BuilderFrame.this) : BuilderFrame.this.getSavePath();
            } else {
                bl2 = true;
                string = BuilderFrame.this.getSavePath();
            }
            if (string.length() > 0) {
                if (bl2 && !BuilderFrame.CFPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.CFPKG_FILE_EXT.length(), BuilderFrame.CFPKG_FILE_EXT.length())) {
                    string = string + BuilderFrame.CFPKG_FILE_EXT;
                } else if (bl3 && !BuilderFrame.SPDXPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.SPDXPKG_FILE_EXT.length(), BuilderFrame.SPDXPKG_FILE_EXT.length())) {
                    string = string + BuilderFrame.SPDXPKG_FILE_EXT;
                } else if (bl) {
                    if (!BuilderFrame.UIPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.UIPKG_FILE_EXT.length(), BuilderFrame.UIPKG_FILE_EXT.length())) {
                        string = string + BuilderFrame.UIPKG_FILE_EXT;
                    }
                } else if (!BuilderFrame.SPDXPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.SPDXPKG_FILE_EXT.length(), BuilderFrame.SPDXPKG_FILE_EXT.length())) {
                    string = string + BuilderFrame.SPDXPKG_FILE_EXT;
                }
                if (!BuilderFrame.this.canSaveTo(string)) {
                    return;
                }
                if (string.endsWith(BuilderFrame.CFPKG_FILE_EXT) || string.endsWith(BuilderFrame.SPDXPKG_FILE_EXT)) {
                    BuilderFrame.this.writeToCFDFile(string);
                } else {
                    BuilderFrame.this.writeToSPDFile(string);
                }
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction(boolean bl) {
            Serializable serializable;
            if (bl) {
                if (BuilderFrame.this.IsCompatibleMode()) {
                    this.putValue("ShortDescription", BuilderResUtil.getString("IDS_SAVE_SPEC"));
                } else {
                    this.putValue("ShortDescription", BuilderResUtil.getString("IDS_SAVE_EXTENSION"));
                }
                this.putValue("Name", BuilderResUtil.getString("file_save"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("file_save"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("file_save"));
                serializable = BuilderResUtil.getShortcut("file_save");
                if (serializable != null) {
                    this.putValue("AcceleratorKey", serializable);
                }
            }
            serializable = BuilderResUtil.getImageResource("Save.png");
            if (serializable != null) {
                this.putValue("SmallIcon", new ImageIcon((URL)serializable));
            }
        }

        @Override
        public boolean isEnabled() {
            return BuilderFrame.this.isModified();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BuilderFrame.this.mDialog.getCurrentPanel().getPanelElement(0);
            BuilderFrame.this.mDialog.getPanels();
            BuilderFrame.this.mDialog.getDialogTitle();
            String string = null;
            if (!BuilderFrame.this.commitEdits(true)) {
                return;
            }
            if (BuilderFrame.this.getDialogDefinition().getDialogId().contains(" ")) {
                BuilderAlertPane.showWarningMessageDialog(BuilderFrame.this, BuilderResUtil.getString("IDS_IDS_CANT_HAVE_SPACES"), BuilderUtil.getInstance().getAppVersionString());
                return;
            }
            if (BuilderUtil.getInstance().getAppType() == AppType.MODELER && !BuilderUtil.isValidTitle(BuilderFrame.this.mDialog.getDialogTitle())) {
                BuilderFrame.this.checkForNodeLocation(BuilderFrame.this.mDialog);
                return;
            }
            if (BuilderUtil.getInstance().getAppType() == AppType.STATS && !BuilderFrame.this.mIsCompatibleMode) {
                boolean bl = BuilderFrame.this.mSPEPath == null;
                BuilderFrame.this.doSaveSPEfile(bl);
                return;
            }
            if (BuilderUtil.getInstance().getAppType() == AppType.MODELER) {
                BuilderFrame.this.doSaveMPEfile(BuilderFrame.this.mSPEPath == null);
                return;
            }
            if (BuilderFrame.this.mSPDPath == null) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                if (BuilderUtil.getInstance().getAppType() == AppType.STATS) {
                    if (BuilderFrame.this.mIsCompatibleMode) {
                        bl = true;
                    } else {
                        bl3 = true;
                    }
                    string = BuilderFrame.this.mDlgExecutor != null ? BuilderFrame.this.mDlgExecutor.getSaveFilePath(bl, BuilderFrame.this.mSPDPath, BuilderFrame.this.mDialog, BuilderFrame.this) : BuilderFrame.this.getSavePath();
                } else {
                    bl2 = true;
                    string = BuilderFrame.this.getSavePath();
                }
                if (string.length() > 0) {
                    if (bl2 && !BuilderFrame.CFPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.CFPKG_FILE_EXT.length(), BuilderFrame.CFPKG_FILE_EXT.length())) {
                        string = string + BuilderFrame.CFPKG_FILE_EXT;
                    } else if (bl3 && !BuilderFrame.SPDXPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.SPDXPKG_FILE_EXT.length(), BuilderFrame.SPDXPKG_FILE_EXT.length())) {
                        string = string + BuilderFrame.SPDXPKG_FILE_EXT;
                    } else if (bl && !BuilderFrame.UIPKG_FILE_EXT.regionMatches(true, 0, string, string.length() - BuilderFrame.UIPKG_FILE_EXT.length(), BuilderFrame.UIPKG_FILE_EXT.length())) {
                        string = string + BuilderFrame.UIPKG_FILE_EXT;
                    }
                }
            } else {
                string = BuilderFrame.this.mSPDPath.getAbsolutePath();
            }
            if (string != null && string.length() > 0) {
                if (!string.endsWith(BuilderFrame.CFE_FILE_EXT)) {
                    BuilderFrame.this.mSPDPath = null;
                    if (!BuilderFrame.this.canSaveTo(string)) {
                        return;
                    }
                    if (string.endsWith(BuilderFrame.CFPKG_FILE_EXT) || string.endsWith(BuilderFrame.SPDXPKG_FILE_EXT)) {
                        BuilderFrame.this.writeToCFDFile(string);
                    } else {
                        BuilderFrame.this.writeToSPDFile(string);
                    }
                } else {
                    BuilderFrame.this.deployCFSpecification(true, true);
                    BuilderFrame.this.setModified(false);
                }
            }
        }
    }

    class ConvertAction
    extends AbstractAction {
        public ConvertAction(boolean bl) {
            if (bl) {
                this.putValue("ShortDescription", BuilderResUtil.getString("IDS_CONVERT_TO_ENHANCED"));
                this.putValue("Name", BuilderResUtil.getString("IDS_CONVERT_TO_ENHANCED_TOOLBAR"));
            } else {
                URL uRL;
                this.putValue("Name", BuilderResUtil.getString("file_convert"));
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("file_convert"));
                KeyStroke keyStroke = BuilderResUtil.getShortcut("file_convert");
                if (keyStroke != null) {
                    this.putValue("AcceleratorKey", keyStroke);
                }
                if ((uRL = BuilderResUtil.getImageResource("convert_enhanced.png")) != null) {
                    this.putValue("SmallIcon", new ImageIcon(uRL));
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return BuilderFrame.this.mDialog.getCurrentPanel().getElementCount() > 0;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            if (BuilderFrame.this.showConvertAlert()) {
                ConvertToEnhancedAlertDlg convertToEnhancedAlertDlg = new ConvertToEnhancedAlertDlg(BuilderFrame.this, BuilderResUtil.getString("IDS_CONVERT_TO_ENHANCED_WARNING"), BuilderUtil.getInstance().getAppVersionString());
                convertToEnhancedAlertDlg.setVisible(true);
                int n = convertToEnhancedAlertDlg.getButtonPressedValue();
                if (n == 2) {
                    bl = false;
                }
            }
            if (bl) {
                BuilderFrame.this.mIsConverted = true;
                BuilderFrame.this.updateConvertedState();
            }
        }
    }

    class OpenAction
    extends AbstractAction {
        public OpenAction(boolean bl) {
            Serializable serializable;
            if (bl) {
                if (BuilderFrame.this.IsCompatibleMode()) {
                    this.putValue("ShortDescription", BuilderResUtil.getString("IDS_OPEN_SPEC"));
                } else {
                    this.putValue("ShortDescription", BuilderResUtil.getString("IDS_OPEN_EXTENSION"));
                }
                this.putValue("Name", BuilderResUtil.getString("file_open"));
            } else {
                this.putValue("Name", BuilderResUtil.getString("file_open") + "...");
                this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("file_open"));
                serializable = BuilderResUtil.getShortcut("file_open");
                if (serializable != null) {
                    this.putValue("AcceleratorKey", serializable);
                }
            }
            serializable = BuilderResUtil.getImageResource("OpenFile.png");
            if (serializable != null) {
                this.putValue("SmallIcon", new ImageIcon((URL)serializable));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BuilderFrame.this.checkModified(true)) {
                return;
            }
            BuilderFrame.this.mConvertMenuVisible = true;
            BuilderFrame.this.mSpdNameDlgID = null;
            File file = BuilderUtil.getInstance().getAppType() == AppType.STATS && BuilderFrame.this.mDlgExecutor != null ? BuilderFrame.this.mDlgExecutor.getOpenFilePath(BuilderFrame.this.mIsCompatibleMode, BuilderFrame.this) : BuilderFrame.this.getOpenFile();
            if (file != null) {
                try {
                    ExtensionPropertyContainer extensionPropertyContainer = BuilderFrame.this.mExtensionContainer;
                    boolean bl = BuilderFrame.this.mIsModified;
                    if (file.getPath().endsWith(BuilderFrame.SPEPKG_FILE_EXT) || file.getPath().endsWith(BuilderFrame.MPEPKG_FILE_EXT)) {
                        boolean bl2 = BuilderFrame.this.openSPEFile(file);
                        if (!bl2) {
                            BuilderFrame.this.mExtensionContainer = extensionPropertyContainer;
                            BuilderFrame.this.mIsModified = bl;
                        }
                        BuilderFrame.this.mSPEPath = file;
                    } else if (file.getPath().endsWith(BuilderFrame.CFPKG_FILE_EXT) || file.getPath().endsWith(BuilderFrame.SPDXPKG_FILE_EXT)) {
                        BuilderFrame.this.resetCurrentSyntaxDlg();
                        BuilderFrame.this.openCFDFile(file);
                    } else {
                        BuilderFrame.this.resetCurrentSyntaxDlg();
                        BuilderFrame.this.openSPDFile(file);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    BuilderAlertPane.showErrorMessageDialog(BuilderFrame.this, BuilderResUtil.getString("IDS_BAD_CLEF_FILE_MSG"), BuilderUtil.getInstance().getAppVersionString());
                }
            }
        }
    }

    class ImportAction
    extends AbstractAction {
        public ImportAction() {
            this.putValue("Name", BuilderResUtil.getString("file_import") + "...");
            this.putValue("MnemonicKey", BuilderResUtil.getAccessKey("file_import"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BuilderFrame.this.checkModified(true)) {
                return;
            }
            File file = BuilderFrame.this.importCfdFile();
            if (file != null) {
                try {
                    BuilderFrame.this.openCFDFile(file);
                    BuilderFrame.this.mOpenSpecName = BuilderFrame.this.mOpenSpecName.replace(BuilderFrame.CFPKG_FILE_EXT, BuilderFrame.CFE_FILE_EXT);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    BuilderAlertPane.showErrorMessageDialog(BuilderFrame.this, BuilderResUtil.getString("IDS_BAD_CLEF_FILE_MSG"), BuilderUtil.getInstance().getAppVersionString());
                }
            }
        }
    }

    class OpenDialogFileAction
    extends AbstractAction {
        private String mFilePath;
        private String mFileName;
        private File mDialogFile;
        private boolean mIsSpd;

        public OpenDialogFileAction(String string, String string2, boolean bl) {
            this.putValue("Name", string);
            this.mFileName = string;
            this.mFilePath = string2;
            this.mDialogFile = new File(this.mFilePath + File.separator + string);
            this.mIsSpd = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                boolean bl;
                if (!this.mIsSpd && this.mFileName.equals(BuilderFrame.this.mOpenSpecName + BuilderFrame.CFE_FILE_EXT) || this.mIsSpd && this.mFileName.equals(BuilderFrame.this.mOpenSpecName + BuilderFrame.UIPKG_FILE_EXT)) {
                    return;
                }
                if (!this.mIsSpd) {
                    if (!BuilderFrame.this.checkCurrentDlgModified(false)) {
                        return;
                    }
                } else {
                    bl = BuilderFrame.this.checkDuplicateDialogName(this.mDialogFile);
                    if (!bl) {
                        return;
                    }
                    if (!BuilderFrame.this.checkCurrentDlgModified(false)) {
                        return;
                    }
                }
                bl = false;
                BuilderFrame.this.mOpenSpecName = this.mFileName.substring(0, this.mFileName.lastIndexOf("."));
                BuilderFrame.this.mSPDPath = new File(this.mFilePath + File.separator + BuilderFrame.this.mOpenSpecName + BuilderFrame.CFE_FILE_EXT);
                String string = BuilderFrame.this.mSPDPath.getName();
                String string2 = BuilderFrame.this.mSPDPath.getParent();
                if (this.mIsSpd) {
                    BuilderFrame.this.mIsCompatibleMode = true;
                    BuilderFrame.this.mSpdNameDlgID = null;
                }
                BuilderFrame.this.resetCurrentSyntaxDlg();
                BuilderFrame.this.readPackageFile(this.mDialogFile, this.mIsSpd);
                if (this.mIsSpd) {
                    BuilderFrame.this.mIsConverted = true;
                    BuilderFrame.this.updateConvertedState();
                    BuilderFrame.this.mSpdNameDlgID = new Hashtable();
                    BuilderFrame.this.mOpenSpecName = string.substring(0, string.lastIndexOf("."));
                    if (!BuilderFrame.this.mOpenSpecName.equals(BuilderFrame.this.mDialog.getDialogId())) {
                        BuilderFrame.this.mSpdNameDlgID.put(BuilderFrame.this.mOpenSpecName, BuilderFrame.this.mDialog.getDialogId());
                        BuilderFrame.this.mOpenSpecName = BuilderFrame.this.mDialog.getDialogId();
                    }
                    BuilderFrame.this.mSPDPath = new File(string2 + File.separator + BuilderFrame.this.mOpenSpecName + BuilderFrame.CFE_FILE_EXT);
                    BuilderFrame.this.mExtensionContainer.setModified(true);
                    bl = true;
                }
                if (bl) {
                    if (BuilderFrame.this.mConvertButton == null) {
                        BuilderFrame.this.mSPDPath = new File(BuilderFrame.this.mExtensionContainer.getTempNameDirectory().getAbsolutePath() + File.separator + BuilderFrame.this.mOpenSpecName + BuilderFrame.CFE_FILE_EXT);
                        BuilderFrame.this.mExtensionContainer.addOneCFEfileName(BuilderFrame.this.mOpenSpecName + BuilderFrame.CFE_FILE_EXT);
                        BuilderFrame.this.mExtensionContainer.addCFEfileWithPath(BuilderFrame.this.mSPDPath.getAbsolutePath());
                        BuilderFrame.this.mConvertMenuVisible = false;
                        BuilderFrame.this.setModified(true);
                        BuilderFrame.this.updateExtensionMenu(BuilderFrame.this.mOpenSpecName, BuilderFrame.this.mSPDPath.getAbsolutePath());
                    } else {
                        BuilderFrame.this.mConvertMenuVisible = false;
                        BuilderFrame.this.updateExtensionMenu("", "");
                        BuilderFrame.this.mExtConvertMenu.setVisible(false);
                    }
                } else {
                    BuilderFrame.this.updateExtensionMenu(BuilderFrame.this.mOpenSpecName, BuilderFrame.this.mSPDPath.getAbsolutePath());
                }
                if (!this.mIsSpd) {
                    BuilderFrame.this.setModified(false);
                } else {
                    BuilderFrame.this.setModified(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

