/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.utilities;

import com.pasw.framework.common.PaswException;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.cf_integration.FrameworkMgr;
import com.spss.java_client.ui.cf_integration.action.CFCommandAction;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.command.CustomCommandAction;
import com.spss.java_client.ui.command.executor.CommandExecutor;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.custom_gui.ui_builder.Util.BuilderUtil;
import com.spss.shared.custom_gui.ui_builder.app.CDBAppInfo;
import com.spss.shared.custom_gui.ui_builder.app.LicenseOption;
import com.spss.shared.custom_gui.ui_builder.extension.SPEManifestHelper;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.ui_builder.SpecificationBuilder;
import com.spss.uitools.ui_builder.definition.AddOnType;
import com.spss.uitools.ui_builder.definition.AppType;
import com.spss.uitools.ui_builder.definition.CommandLocation;
import com.spss.uitools.ui_builder.definition.DialogDefinition;
import com.spss.uitools.util.IniHandler;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class StatsCDBAppInfo
implements CDBAppInfo {
    private boolean mIsCompatibleMode;
    private boolean mTabbedDlg;
    private boolean mExFirst;
    private static final String XML_FILE_EXT = ".xml";
    private static final String CFE_FILE_EXT = ".cfe";

    public StatsCDBAppInfo(boolean bl) {
        this.mIsCompatibleMode = bl;
        this.mTabbedDlg = !this.mIsCompatibleMode;
        this.mExFirst = false;
    }

    public void setExEnvPathsPriority(boolean bl) {
        this.mExFirst = bl;
    }

    public String getAppNameString() {
        return VersionInfo.getAppVersionString();
    }

    public Charset getCurrentCharset() {
        return Charset.defaultCharset();
    }

    public String getAppVersionString() {
        return VersionInfo.getVersionString();
    }

    public Locale getAppLocale() {
        return ComponentState.getILangLocale();
    }

    public String getAppMajorMinorVersionString() {
        return VersionInfo.getMajorMinorVersionString();
    }

    public LookAndFeel getLookAndFeel() {
        return UIManager.getLookAndFeel();
    }

    public AppType getAppType() {
        return AppType.STATS;
    }

    public boolean isInCompatibleMode() {
        return this.mIsCompatibleMode;
    }

    public void setCompabibleMode(boolean bl) {
        this.mIsCompatibleMode = bl;
    }

    public boolean isTabbed() {
        return this.mTabbedDlg;
    }

    public void setTabbed(boolean bl) {
        this.mTabbedDlg = bl;
    }

    public String getRecentFilesDirectoryPath() {
        return null;
    }

    public void setRecentFilesDirectoryPath(String string) {
    }

    public boolean hasCommand(String string, String string2, String string3) {
        return CommandExecutor.get().hasCommand(string, string2, string3);
    }

    public void removeFrame(JFrame jFrame) {
    }

    public LicenseOption getLicenseOption() {
        return null;
    }

    public JFrame[] getAllFrames() {
        return new JFrame[0];
    }

    public AddOnType[] getAddOnType() {
        ArrayList<AddOnType> arrayList = new ArrayList<AddOnType>();
        if (StatsCDBAppInfo.checkRInstalled()) {
            arrayList.add(AddOnType.R);
        }
        if (StatsCDBAppInfo.checkPythonInstalled("pythoncfg.jar")) {
            arrayList.add(AddOnType.Python);
        }
        AddOnType[] addOnTypeArray = new AddOnType[arrayList.size()];
        return arrayList.toArray(addOnTypeArray);
    }

    public String getUIExtensionsFolderPath() {
        return CommandExecutor.getUIExtensionsFolderPath();
    }

    public String[] getSecondaryExtensionFolders() {
        return CommandExecutor.getSecondaryExtensionFolders();
    }

    public String getAppdataCustomDialogDirectoryForAllUsers() {
        return SpecificationBuilder.getAppdataCustomDialogDirectoryForAllUsers();
    }

    public String getAppdataCustomDialogDirectory() {
        return CommandExecutor.getAppdataCustomDialogDirectory();
    }

    public boolean allowSyntax() {
        return true;
    }

    public int getBTD() {
        return 0;
    }

    public boolean isOptimizeRtoL() {
        return false;
    }

    public ArrayList<String> getSyntaxCommands() {
        return new ArrayList<String>();
    }

    public ArrayList<Object> getStatsSyntaxCommands() {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = SyntaxMgr.getStaticSyntaxCommands();
        return arrayList2;
    }

    public void showHelp(String string) {
        int n = string.lastIndexOf(47);
        String string2 = string;
        if (n >= 0) {
            string2 = string.substring(n + 1);
        }
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, string2);
    }

    public File getTempDir() {
        return new File(PrefsMgr.getPrefsMgr().getTempPath());
    }

    public File getExtensionPath() {
        String string = SpecificationBuilder.getAppDataCustomCFEFolderPath((boolean)this.mExFirst);
        return new File(string);
    }

    public ArrayList<String> getExtensionBundlePath() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector vector = FileLocationsUtil.getExtensionsPathes((boolean)this.mExFirst);
        for (String string : vector) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public String getMenuName(String string) {
        return ResUtil.getString(string);
    }

    public String loadExtension(File file) throws PaswException, IOException {
        return FrameworkMgr.get().loadExtension(file, true);
    }

    public void unloadExtension(String string) throws PaswException {
        String string2 = this.getExtensionPath() + File.separator + string;
        File file = new File(string2);
        if (file.exists()) {
            file.delete();
        }
    }

    public String hasMenuItem(DialogDefinition dialogDefinition) {
        String string = dialogDefinition.getCommandLocation().getCommandActionId();
        String string2 = dialogDefinition.getCommandLocation().getCommandPath();
        String string3 = dialogDefinition.getCommandLocation().getCommandTitle();
        String string4 = CommandExecutor.get().hasMenuItem(string, string2, string3);
        return string4;
    }

    public boolean isMenuItemExist(DialogDefinition dialogDefinition) {
        String string = dialogDefinition.getCommandLocation().getCommandActionId();
        String string2 = dialogDefinition.getCommandLocation().getCommandPath();
        String string3 = dialogDefinition.getCommandLocation().getCommandTitle();
        return CommandExecutor.get().isMenuItemExist(string, string2, string3);
    }

    public void updateFrames(DialogDefinition dialogDefinition, String string) {
        Object object;
        String string2;
        if (SpssFrameMgr.getSpssFrameMgr().getOpenDocuments().length <= 0) {
            return;
        }
        CommandLocation commandLocation = dialogDefinition.getCommandLocation();
        String string3 = dialogDefinition.getDialogId();
        File file = new File(string);
        CustomCommandAction customCommandAction = new CustomCommandAction(string3, file);
        customCommandAction.setName(commandLocation.getCommandTitle());
        String string4 = commandLocation.getIconName();
        if (string4 != null && string4.length() > 0) {
            try {
                File file2 = new File(string4);
                String string5 = file2.getName();
                string2 = file.getParent() + File.separator + string5;
                object = new ImageIcon(string2);
                customCommandAction.setIcon((Icon)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean bl = commandLocation.getSeparator() == CommandLocation.CommandSeparator.above || commandLocation.getSeparator() == CommandLocation.CommandSeparator.both;
        boolean bl2 = commandLocation.getSeparator() == CommandLocation.CommandSeparator.below || commandLocation.getSeparator() == CommandLocation.CommandSeparator.both;
        string2 = commandLocation.getPreviousItemActionId();
        CommandExecutor.get().replaceCommand(customCommandAction, commandLocation);
        object = this.getMenuItemContainer(string3);
        if (object == null) {
            object = new CommandExecutor.MenuItemContainer(customCommandAction, commandLocation);
        }
        this.removeFromFrames(string3, string);
        for (SpssFrame spssFrame : SpssFrameMgr.getSpssFrameMgr().getOpenDocuments()) {
            JMenuBar jMenuBar = spssFrame.getJMenuBar();
            CommandExecutor.get().addMenuItem(jMenuBar, (CommandExecutor.MenuItemContainer)object, spssFrame);
        }
        ActionCatalog.getActionCatalog().registerAction(customCommandAction);
    }

    public void addCfeMenuToFrames(String string, String string2) {
        CommandExecutor.MenuItemContainer menuItemContainer = this.getMenuItemContainer(string);
        if (menuItemContainer == null) {
            return;
        }
        this.removeFromFrames(string, string2);
        for (SpssFrame spssFrame : SpssFrameMgr.getSpssFrameMgr().getOpenDocuments()) {
            JMenuBar jMenuBar = spssFrame.getJMenuBar();
            CommandExecutor.get().addMenuItem(jMenuBar, menuItemContainer, spssFrame);
        }
    }

    public boolean removeDeployed(String string) throws Exception {
        int n = string.lastIndexOf(File.separator);
        String string2 = n > -1 ? string.substring(n + 1) : string;
        boolean bl = false;
        if (string.endsWith(CFE_FILE_EXT)) {
            bl = true;
            string2 = string2.substring(0, string2.length() - CFE_FILE_EXT.length());
        } else if (string.endsWith(".spd")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        CommandExecutor.MenuItemContainer menuItemContainer = this.getMenuItemContainer(string2);
        if (menuItemContainer != null) {
            CommandExecutor.get().removeCustomAction(menuItemContainer.getAction());
        }
        this.removeFromFrames(string2, string + File.separator + string2 + XML_FILE_EXT);
        File file = new File(string);
        if (!file.exists()) {
            return true;
        }
        boolean bl2 = file.isDirectory() ? BuilderUtil.getInstance().deleteFolder(file) : BuilderUtil.getInstance().deleteFile(file);
        if (!bl2) {
            file.deleteOnExit();
        }
        return true;
    }

    public boolean removeDeployedBundle(File file) {
        boolean bl = true;
        try {
            String string = file.getParent();
            File file2 = new File(string);
            if (!file.exists() && (file = this.searchSpeFrom(file2)) == null) {
                bl = false;
            }
            if (bl) {
                File file3;
                String string2;
                String string3;
                String string4;
                Iterator iterator3;
                Object object;
                SPEManifestHelper sPEManifestHelper = new SPEManifestHelper(file);
                Set set = sPEManifestHelper.getDialogSpecsSet();
                Iterator iterator2 = set.iterator();
                Vector vector = new Vector();
                Vector vector2 = new Vector();
                while (iterator2.hasNext()) {
                    object = iterator2.next().toString();
                    if (((String)object).endsWith(CFE_FILE_EXT)) {
                        vector2.add(object);
                        continue;
                    }
                    if (!((String)object).endsWith(".spd")) continue;
                    vector.add(object);
                }
                for (Iterator iterator3 : vector) {
                    string4 = file2 + File.separator + (String)((Object)iterator3);
                    this.removeDeployed(string4);
                }
                for (Iterator iterator3 : vector2) {
                    string4 = BuilderUtil.getInstance().getExtensionPath() + File.separator + (String)((Object)iterator3);
                    this.removeDeployed(string4);
                }
                object = sPEManifestHelper.getCommandSpecsSet();
                iterator3 = object.iterator();
                string4 = file2.getParent();
                while (iterator3.hasNext()) {
                    string3 = iterator3.next().toString();
                    string2 = string4 + File.separator + string3;
                    file3 = new File(string2);
                    if (!file3.exists()) continue;
                    BuilderUtil.getInstance().deleteFile(file3);
                }
                object = sPEManifestHelper.getCodeFilesSet();
                iterator3 = object.iterator();
                while (iterator3.hasNext()) {
                    string3 = iterator3.next().toString();
                    string2 = string4 + File.separator + string3;
                    file3 = new File(string2);
                    if (!file3.exists()) continue;
                    BuilderUtil.getInstance().deleteFile(file3);
                }
            }
            this.removeCustomDialogFolder(file2.getName());
            BuilderUtil.getInstance().deleteFolder(file2);
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean executeSyntax(String string) {
        return SyntaxMgr.getSyntaxMgr().executeSyntax(string);
    }

    private File searchSpeFrom(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string;
            File file2 = fileArray[i];
            if (!file2.isFile() || !file2.exists() || !(string = file2.getName()).endsWith(".spe")) continue;
            return file2;
        }
        return null;
    }

    private boolean removeCustomDialogFolder(String string) {
        boolean bl = true;
        Vector<String> vector = new Vector<String>();
        vector.addAll(Arrays.asList(FileLocationsUtil.getSecondaryExtensionDirectory((boolean)false)));
        if (System.getProperty("os.name", "Windows").toLowerCase().startsWith("win")) {
            vector.add(this.getAppdataCustomDialogDirectoryForAllUsers());
            vector.add(this.getAppdataCustomDialogDirectory());
            vector.add(this.getUIExtensionsFolderPath());
        } else {
            vector.add(this.getUIExtensionsFolderPath());
        }
        if (vector.size() > 0) {
            for (String string2 : vector) {
                File file = new File(string2 + File.separator + string);
                if (!file.exists() || !file.isDirectory()) continue;
                return BuilderUtil.getInstance().deleteFolder(file);
            }
        }
        return bl;
    }

    private CommandExecutor.MenuItemContainer getMenuItemContainer(String string) {
        CommandExecutor.MenuItemContainer menuItemContainer = null;
        Vector<CommandExecutor.MenuItemContainer> vector = CommandExecutor.get().getCustomMenuItems();
        for (CommandExecutor.MenuItemContainer menuItemContainer2 : vector) {
            if (!menuItemContainer2.getAction().getActionId().equals(string)) continue;
            menuItemContainer = menuItemContainer2;
            break;
        }
        return menuItemContainer;
    }

    private void removeFromFrames(String string, String string2) {
        for (SpssFrame spssFrame : SpssFrameMgr.getSpssFrameMgr().getOpenDocuments()) {
            JMenuBar jMenuBar = spssFrame.getJMenuBar();
            for (int i = 0; i < jMenuBar.getMenuCount() && !this.removeCommand(jMenuBar.getMenu(i), string, string2); ++i) {
            }
        }
    }

    private boolean removeCommand(JMenu jMenu, String string, String string2) {
        for (Component component : jMenu.getMenuComponents()) {
            CFCommandAction cFCommandAction;
            if (component instanceof JMenu) {
                if (!this.removeCommand((JMenu)component, string, string2)) continue;
                return true;
            }
            if (!(component instanceof JMenuItem)) continue;
            JMenuItem jMenuItem = (JMenuItem)component;
            if (jMenuItem.getAction() instanceof CustomCommandAction) {
                CustomCommandAction customCommandAction = (CustomCommandAction)jMenuItem.getAction();
                if (!customCommandAction.getActionId().equals(string) && !customCommandAction.getClefFileName().equalsIgnoreCase(string2)) continue;
                jMenu.remove(jMenuItem);
                return true;
            }
            if (!(jMenuItem.getAction() instanceof CFCommandAction) || !(cFCommandAction = (CFCommandAction)jMenuItem.getAction()).getActionId().equals(string)) continue;
            jMenu.remove(jMenuItem);
            return true;
        }
        return false;
    }

    private static boolean checkRInstalled() {
        String string = "";
        boolean bl = false;
        IniHandler iniHandler = StatsCDBAppInfo.getSpssReaderFromSpssHomeDir("spssdxcfg.ini");
        string = StatsCDBAppInfo.getProfileValue(iniHandler, AddOnType.R.toString(), "HOME");
        if (string.isEmpty()) {
            String string2 = VersionInfo.getMajorMinorVersionString();
            String string3 = "/com/ibm/SPSS/externalr/" + string2;
            try {
                if (Preferences.userRoot().nodeExists(string3)) {
                    Preferences preferences = Preferences.userRoot().node(string3);
                    string = preferences.get("r_path", string);
                    if (string.length() > 0) {
                        File file = new File(string);
                        if (!file.exists() || !file.isDirectory()) {
                            string = "";
                        }
                    } else {
                        string = "";
                    }
                }
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }
        if (!string.isEmpty()) {
            bl = true;
        }
        return bl;
    }

    private static boolean checkPythonInstalled(String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("application.home"));
        stringBuffer.append(File.separator).append(string);
        File file = new File(stringBuffer.toString());
        if (file.exists()) {
            bl = true;
        }
        return bl;
    }

    private static IniHandler getSpssReaderFromSpssHomeDir(String string) {
        IniHandler iniHandler = null;
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("application.home"));
        stringBuffer.append(File.separatorChar).append(string);
        File file = new File(stringBuffer.toString());
        if (file.exists()) {
            iniHandler = IniHandler.loadIniFile((String)stringBuffer.toString(), (boolean)true, (String)"UTF-8");
        }
        return iniHandler;
    }

    private static String getProfileValue(IniHandler iniHandler, String string, String string2) {
        LinkedList linkedList;
        String string3 = "";
        if (iniHandler != null && (linkedList = iniHandler.getPrivateProfileString(string, string2)) != null && !linkedList.isEmpty()) {
            string3 = (String)linkedList.getFirst();
        }
        return string3;
    }
}

