/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.utilities;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class SpssKeyboardMonitor {
    KeyboardMonitorAWTKeyEventListener mKeyboardMonitorAWTKeyEventListener = new KeyboardMonitorAWTKeyEventListener();
    File mKeyboardMonitorFile;
    StringBuffer mKeyboardMonitorBuffer;

    public void writeToKeyboardMonitor(String string) {
        if (this.mKeyboardMonitorBuffer != null) {
            this.mKeyboardMonitorBuffer.append("//-----------------");
            this.mKeyboardMonitorBuffer.append(string);
            this.mKeyboardMonitorBuffer.append("-----------------");
            this.mKeyboardMonitorBuffer.append("\r\n");
        }
    }

    public void activateKeyboardMonitor(File file) {
        this.mKeyboardMonitorFile = file;
        if (this.mKeyboardMonitorFile != null) {
            this.mKeyboardMonitorBuffer = new StringBuffer();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.mKeyboardMonitorAWTKeyEventListener, 8L);
            System.out.println("Keyboard Monitor Activated");
        }
    }

    private void writeKeyboardBufferToFile() {
        if (this.mKeyboardMonitorFile != null && this.mKeyboardMonitorBuffer != null) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.mKeyboardMonitorFile.getPath()), "utf-8"));
                bufferedWriter.write(this.mKeyboardMonitorBuffer.toString());
                bufferedWriter.close();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void stopKeyboardMonitorWriteToFile() {
        this.writeKeyboardBufferToFile();
        if (this.mKeyboardMonitorAWTKeyEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.mKeyboardMonitorAWTKeyEventListener);
        }
        this.mKeyboardMonitorBuffer = null;
        System.out.println("Keyboard Monitor Closed - File Written");
    }

    private class KeyboardMonitorAWTKeyEventListener
    implements AWTEventListener {
        public static final String NEWLINE = "\r\n";
        private StringBuffer mTrapStringBuffer;

        private KeyboardMonitorAWTKeyEventListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            if (object instanceof Component && aWTEvent instanceof KeyEvent && aWTEvent.getID() == 401) {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                int n = ((KeyEvent)aWTEvent).getKeyCode();
                if (this.mTrapStringBuffer != null) {
                    boolean bl = this.isKeyboardTrapCommentSequence(keyEvent);
                    boolean bl2 = this.isKeyboardTrapStringSequence(keyEvent);
                    if (bl2 || bl) {
                        String string = bl2 ? "STRING_ENTRY=" : "//";
                        SpssKeyboardMonitor.this.mKeyboardMonitorBuffer.append(string);
                        SpssKeyboardMonitor.this.mKeyboardMonitorBuffer.append(this.mTrapStringBuffer.toString() + NEWLINE);
                        this.parseMonitorTextTest(string + this.mTrapStringBuffer.toString() + NEWLINE);
                        this.mTrapStringBuffer = null;
                    } else if (n != 17 && n != 18 && n != 16) {
                        this.mTrapStringBuffer.append(keyEvent.getKeyChar());
                    }
                } else if (this.isKeyboardTrapStringSequence(keyEvent)) {
                    this.mTrapStringBuffer = new StringBuffer();
                    System.out.println("Start String Trap");
                } else if (this.isKeyboardMonitorCloseSequence(keyEvent)) {
                    SpssKeyboardMonitor.this.stopKeyboardMonitorWriteToFile();
                } else if (this.isDelaySequence(keyEvent)) {
                    SpssKeyboardMonitor.this.mKeyboardMonitorBuffer.append("~DELAY=1\r\n");
                    this.parseMonitorTextTest("~DELAY=1");
                } else {
                    String string = this.getKeystrokeText(keyEvent);
                    if (string != null && string.length() > 0) {
                        SpssKeyboardMonitor.this.mKeyboardMonitorBuffer.append(string);
                    }
                    this.parseMonitorTextTest(string);
                }
            }
        }

        private void parseMonitorTextTest(String string) {
            KeyMonitorInfo keyMonitorInfo = this.parseKeyMonitorLineText(string);
            if (keyMonitorInfo != null) {
                if (keyMonitorInfo.isComment()) {
                    System.out.println("Comment = " + keyMonitorInfo.getComment());
                } else if (keyMonitorInfo.isStringEntryText()) {
                    System.out.println("STRING_ENTRY = " + keyMonitorInfo.getStringEntryText());
                } else if (keyMonitorInfo.isDelay()) {
                    System.out.println("~Delay = " + keyMonitorInfo.getDelay());
                } else {
                    System.out.println("UserRepresentation = " + keyMonitorInfo.getUserRepresentation());
                    System.out.println("JavaRepresentation = " + keyMonitorInfo.getJavaRepresentation());
                    if (keyMonitorInfo.getModifier() != -1) {
                        System.out.println("getModifier = " + keyMonitorInfo.getModifier());
                    }
                    System.out.println("getKeyCode = " + keyMonitorInfo.getKeyCode());
                    System.out.println("--------------------------------------------");
                }
            }
        }

        private KeyMonitorInfo parseKeyMonitorLineText(String string) {
            KeyMonitorInfo keyMonitorInfo = null;
            if (string != null && string.length() > 0) {
                if (string.startsWith("~DELAY")) {
                    String[] stringArray = string.split("=");
                    if (stringArray[1] != null && stringArray[1].length() > 0) {
                        keyMonitorInfo = new KeyMonitorInfo();
                        keyMonitorInfo.setDelay(new Integer(stringArray[1]));
                    }
                } else if (string.startsWith("STRING_ENTRY=")) {
                    String[] stringArray = string.split("=");
                    if (stringArray[1] != null && stringArray[1].length() > 0) {
                        keyMonitorInfo = new KeyMonitorInfo();
                        keyMonitorInfo.setStringEntryText(string.trim());
                    }
                } else if (string.startsWith("//")) {
                    keyMonitorInfo = new KeyMonitorInfo();
                    keyMonitorInfo.setComment(string.trim());
                } else {
                    String[] stringArray = string.split("=");
                    String string2 = stringArray[0];
                    String string3 = stringArray[1].trim();
                    int n = -1;
                    int n2 = -1;
                    int n3 = string3.indexOf("[");
                    string3 = string3.substring(n3 + 1);
                    n3 = string3.indexOf("]");
                    if ((string3 = string3.substring(0, n3)).indexOf("+") >= 0) {
                        stringArray = string3.split("\\+");
                        n = new Integer(stringArray[0].trim());
                        n2 = new Integer(stringArray[1].trim());
                    } else {
                        n2 = new Integer(string3.trim());
                    }
                    keyMonitorInfo = new KeyMonitorInfo(string2, string3, n, n2);
                }
            }
            return keyMonitorInfo;
        }

        private String getKeystrokeText(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            StringBuffer stringBuffer = new StringBuffer();
            if (n != 17 && n != 18 && n != 16) {
                stringBuffer.append(this.getKeyCodeUserRepresentation(keyEvent));
                stringBuffer.append(this.getKeyCodeJavaRepresentation(keyEvent));
                stringBuffer.append(NEWLINE);
                System.out.println(stringBuffer.toString());
            }
            return stringBuffer.toString();
        }

        private String getModifierText(KeyEvent keyEvent, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            if (keyEvent.isControlDown()) {
                stringBuffer.append(bl ? "CTRL+" : "17+");
            }
            if (keyEvent.isAltDown()) {
                stringBuffer.append(bl ? "ALT+" : "18+");
            }
            if (keyEvent.isShiftDown()) {
                stringBuffer.append(bl ? "SHIFT+" : "16+");
            }
            return stringBuffer.toString();
        }

        private String getKeyCodeJavaRepresentation(KeyEvent keyEvent) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = keyEvent.getKeyCode();
            stringBuffer.append(" =[");
            stringBuffer.append(this.getModifierText(keyEvent, false));
            stringBuffer.append(n);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        private String getKeyCodeUserRepresentation(KeyEvent keyEvent) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = keyEvent.getKeyCode();
            stringBuffer.append(this.getModifierText(keyEvent, true));
            if (n == 48) {
                stringBuffer.append("0");
            } else if (n == 49) {
                stringBuffer.append("1");
            } else if (n == 50) {
                stringBuffer.append("2");
            } else if (n == 51) {
                stringBuffer.append("3");
            } else if (n == 52) {
                stringBuffer.append("4");
            } else if (n == 53) {
                stringBuffer.append("5");
            } else if (n == 54) {
                stringBuffer.append("6");
            } else if (n == 55) {
                stringBuffer.append("7");
            } else if (n == 56) {
                stringBuffer.append("K_8");
            } else if (n == 57) {
                stringBuffer.append("9");
            } else if (n == 65) {
                stringBuffer.append("A");
            } else if (n == 66) {
                stringBuffer.append("B");
            } else if (n == 67) {
                stringBuffer.append("C");
            } else if (n == 68) {
                stringBuffer.append("D");
            } else if (n == 69) {
                stringBuffer.append("E");
            } else if (n == 70) {
                stringBuffer.append("F");
            } else if (n == 71) {
                stringBuffer.append("G");
            } else if (n == 72) {
                stringBuffer.append("H");
            } else if (n == 73) {
                stringBuffer.append("I");
            } else if (n == 74) {
                stringBuffer.append("J");
            } else if (n == 75) {
                stringBuffer.append("K");
            } else if (n == 76) {
                stringBuffer.append("L");
            } else if (n == 77) {
                stringBuffer.append("M");
            } else if (n == 78) {
                stringBuffer.append("N");
            } else if (n == 79) {
                stringBuffer.append("O");
            } else if (n == 80) {
                stringBuffer.append("P");
            } else if (n == 81) {
                stringBuffer.append("Q");
            } else if (n == 82) {
                stringBuffer.append("R");
            } else if (n == 83) {
                stringBuffer.append("S");
            } else if (n == 84) {
                stringBuffer.append("T");
            } else if (n == 85) {
                stringBuffer.append("U");
            } else if (n == 86) {
                stringBuffer.append("V");
            } else if (n == 87) {
                stringBuffer.append("W");
            } else if (n == 88) {
                stringBuffer.append("X");
            } else if (n == 89) {
                stringBuffer.append("Y");
            } else if (n == 90) {
                stringBuffer.append("Z");
            } else if (n == 32) {
                stringBuffer.append("SPACE");
            } else if (n == 10) {
                stringBuffer.append("ENTER");
            } else if (n == 155) {
                stringBuffer.append("INSERT");
            } else if (n == 36) {
                stringBuffer.append("HOME");
            } else if (n == 27) {
                stringBuffer.append("VK_ESCAPE");
            } else if (n == 127) {
                stringBuffer.append("DELETE");
            } else if (n == 35) {
                stringBuffer.append("END");
            } else if (n == 33) {
                stringBuffer.append("PAGE_UP");
            } else if (n == 34) {
                stringBuffer.append("PAGE_DOWN");
            } else if (n == 38) {
                stringBuffer.append("UP");
            } else if (n == 40) {
                stringBuffer.append("DOWN");
            } else if (n == 39) {
                stringBuffer.append("RIGHT");
            } else if (n == 37) {
                stringBuffer.append("LEFT");
            } else if (n == 9) {
                stringBuffer.append("TAB");
            } else if (n == 515) {
                stringBuffer.append("DOLLAR");
            } else if (n == 150) {
                stringBuffer.append("AMPERSAND");
            } else if (n == 151) {
                stringBuffer.append("ASTERISK");
            } else if (n == 92) {
                stringBuffer.append("BACK_SLASH");
            } else if (n == 161) {
                stringBuffer.append("BRACELEFT");
            } else if (n == 162) {
                stringBuffer.append("BRACERIGHT");
            } else if (n == 522) {
                stringBuffer.append("RIGHT_PARENTHESIS");
            } else if (n == 519) {
                stringBuffer.append("LEFT_PARENTHESIS");
            }
            return stringBuffer.toString();
        }

        private boolean isDelaySequence(KeyEvent keyEvent) {
            boolean bl = false;
            int n = keyEvent.getKeyCode();
            if (n == 68 && keyEvent.isAltDown() && keyEvent.isControlDown() && keyEvent.isShiftDown()) {
                bl = true;
            }
            return bl;
        }

        private boolean isKeyboardMonitorCloseSequence(KeyEvent keyEvent) {
            boolean bl = false;
            int n = keyEvent.getKeyCode();
            if (n == 35 && keyEvent.isAltDown() && keyEvent.isControlDown() && keyEvent.isShiftDown()) {
                bl = true;
            }
            return bl;
        }

        private boolean isKeyboardTrapStringSequence(KeyEvent keyEvent) {
            return this.isKeyboardTrapStringSequence(keyEvent, 83);
        }

        private boolean isKeyboardTrapCommentSequence(KeyEvent keyEvent) {
            return this.isKeyboardTrapStringSequence(keyEvent, 67);
        }

        private boolean isKeyboardTrapStringSequence(KeyEvent keyEvent, int n) {
            boolean bl = false;
            int n2 = keyEvent.getKeyCode();
            int n3 = keyEvent.getModifiers();
            if (n2 == n && keyEvent.isAltDown() && keyEvent.isControlDown() && keyEvent.isShiftDown()) {
                bl = true;
            }
            return bl;
        }

        private class KeyMonitorInfo {
            String mUserRepresentation;
            String mJavaRepresentation;
            int mModifier;
            int mKeyCode;
            String mComment;
            String mStringEntryText;
            int mDelay = -1;

            private KeyMonitorInfo() {
            }

            public KeyMonitorInfo(String string, String string2, int n, int n2) {
                this.mUserRepresentation = string;
                this.mJavaRepresentation = string2;
                this.mModifier = n;
                this.mKeyCode = n2;
            }

            public String getUserRepresentation() {
                return this.mUserRepresentation;
            }

            public String getJavaRepresentation() {
                return this.mJavaRepresentation;
            }

            public int getModifier() {
                return this.mModifier;
            }

            public int getKeyCode() {
                return this.mKeyCode;
            }

            public String getComment() {
                return this.mComment;
            }

            public boolean isComment() {
                return this.mComment != null;
            }

            public void setComment(String string) {
                this.mComment = string;
            }

            public String getStringEntryText() {
                return this.mStringEntryText;
            }

            public void setStringEntryText(String string) {
                this.mStringEntryText = string;
            }

            public boolean isStringEntryText() {
                return this.mStringEntryText != null;
            }

            public boolean isDelay() {
                return this.mDelay > 0;
            }

            public int getDelay() {
                return this.mDelay;
            }

            public void setDelay(int n) {
                this.mDelay = n;
            }
        }
    }
}

