/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.utilities;

import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.util.ResourceBundle;

public enum SpssDateFormatHelper {
    eFORMAT_1("IDS_FORMAT_DATE_STRING1", FormatType.DATE, 11, 0, "DATE11", "dd-MMM-yyyy"),
    eFORMAT_2("IDS_FORMAT_DATE_STRING2", FormatType.DATE, 9, 0, "DATE9", "dd-MMM-yy"),
    eFORMAT_3("IDS_FORMAT_DATE_STRING3", FormatType.ADATE, 10, 0, "ADATE10", "MM/dd/yyyy"),
    eFORMAT_4("IDS_FORMAT_DATE_STRING4", FormatType.ADATE, 8, 0, "ADATE8", "MM/dd/yy"),
    eFORMAT_5("IDS_FORMAT_DATE_STRING5", FormatType.EDATE, 10, 0, "EDATE10", "dd.MM.yyyy"),
    eFORMAT_6("IDS_FORMAT_DATE_STRING6", FormatType.EDATE, 8, 0, "EDATE8", "dd.MM.yy"),
    eFORMAT_7("IDS_FORMAT_DATE_STRING7", FormatType.SDATE, 10, 0, "SDATE10", "yyyy/MM/dd"),
    eFORMAT_8("IDS_FORMAT_DATE_STRING8", FormatType.SDATE, 8, 0, "SDATE8", "yy/MM/dd"),
    eFORMAT_9("IDS_FORMAT_DATE_STRING9", FormatType.JDATE, 5, 0, "JDATE5", "yyddd"),
    eFORMAT_10("IDS_FORMAT_DATE_STRING10", FormatType.JDATE, 7, 0, "JDATE7", "yyyyddd"),
    eFORMAT_11("IDS_FORMAT_DATE_STRING11", FormatType.QYR, 8, 0, "QYR8", "q Q yyyy"),
    eFORMAT_12("IDS_FORMAT_DATE_STRING12", FormatType.QYR, 6, 0, "QYR6", "q Q yy"),
    eFORMAT_13("IDS_FORMAT_DATE_STRING13", FormatType.MOYR, 8, 0, "MOYR8", "MMM yyyy"),
    eFORMAT_14("IDS_FORMAT_DATE_STRING14", FormatType.MOYR, 6, 0, "MOYR6", "MMM yy"),
    eFORMAT_15("IDS_FORMAT_DATE_STRING15", FormatType.WKYR, 10, 0, "WKYR10", "ww WK yyyy"),
    eFORMAT_16("IDS_FORMAT_DATE_STRING16", FormatType.WKYR, 8, 0, "WKYR8", "ww WK yy"),
    eFORMAT_17("IDS_FORMAT_DATE_STRING17", FormatType.DATETIME, 17, 0, "DATETIME17", "dd-MMM-yyyy HH:mm"),
    eFORMAT_18("IDS_FORMAT_DATE_STRING18", FormatType.DATETIME, 20, 0, "DATETIME20", "dd-MMM-yyyy HH:mm:ss"),
    eFORMAT_19("IDS_FORMAT_DATE_STRING19", FormatType.DATETIME, 23, 2, "DATETIME23.2", "dd-MMM-yyyy HH:mm:ss.SS"),
    eFORMAT_20("IDS_FORMAT_DATE_STRING20", FormatType.TIME, 5, 0, "TIME5", "hh:mm"),
    eFORMAT_21("IDS_FORMAT_DATE_STRING21", FormatType.TIME, 8, 0, "TIME8", "hh:mm:ss"),
    eFORMAT_22("IDS_FORMAT_DATE_STRING22", FormatType.TIME, 11, 2, "TIME11.2", "hh:mm:ss.SS"),
    eFORMAT_23("IDS_FORMAT_DATE_STRING23", FormatType.DTIME, 9, 0, "DTIME9", "ddd hh:mm"),
    eFORMAT_24("IDS_FORMAT_DATE_STRING24", FormatType.DTIME, 12, 0, "DTIME12", "ddd hh:mm:ss"),
    eFORMAT_25("IDS_FORMAT_DATE_STRING25", FormatType.DTIME, 15, 2, "DTIME15.2", "ddd hh:mm:ss.SS"),
    eFORMAT_26("IDS_FORMAT_DATE_STRING26", FormatType.WKDAY, 9, 0, "WKDAY9", null),
    eFORMAT_27("IDS_FORMAT_DATE_STRING27", FormatType.WKDAY, 3, 0, "WKDAY3", null),
    eFORMAT_28("IDS_FORMAT_DATE_STRING28", FormatType.MONTH, 9, 0, "MONTH9", null),
    eFORMAT_29("IDS_FORMAT_DATE_STRING29", FormatType.MONTH, 3, 0, "MONTH3", null),
    eFORMAT_30("IDS_FORMAT_DATE_STRING30", FormatType.MTIME, 5, 0, "MTIME5", "mm:ss"),
    eFORMAT_31("IDS_FORMAT_DATE_STRING31", FormatType.MTIME, 8, 2, "MTIME8.2", "mm:ss.SS"),
    eFORMAT_32("IDS_FORMAT_DATE_STRING32", FormatType.YMDHMS, 16, 0, "YMDHMS16", "yyyy-MM-dd HH:mm"),
    eFORMAT_33("IDS_FORMAT_DATE_STRING33", FormatType.YMDHMS, 19, 0, "YMDHMS19", "yyyy-MM-dd HH:mm:ss"),
    eFORMAT_34("IDS_FORMAT_DATE_STRING34", FormatType.YMDHMS, 22, 2, "YMDHMS22.2", "yyyy-MM-dd HH:mm:ss.SS"),
    eDEFAULT_ISO_DATETIME("eDEFAULT_ISO_DATETIME", FormatType.DATETIME, 3, 0, "ISO_DATETIME", "yyyy-MM-dd HH:mm:ss"),
    eDEFAULT_ISO_DATE("eDEFAULT_ISO_DATE", FormatType.DATE, -1, -1, "ISO_DATE", "yyyy-MM-dd"),
    eDEFAULT_ISO_TIME("eDEFAULT_ISO_TIME", FormatType.TIME, -1, -1, "ISO_TIME", "HH:mm:ss");

    private byte mDecimals;
    private String mFormatKey;
    private String mSimpleDateFormatPattern;
    private String mKey;
    private FormatType mType;
    private short mWidth;
    static ResourceBundle mCommonResBundle;

    private SpssDateFormatHelper(String string2, FormatType formatType, int n2, int n3, String string3, String string4) {
        this.mKey = string2;
        this.mType = formatType;
        this.mWidth = (short)n2;
        this.mDecimals = (byte)n3;
        this.mFormatKey = string3;
        this.mSimpleDateFormatPattern = string4;
    }

    public String getFormat() {
        return this.mFormatKey;
    }

    public FormatType getType() {
        return this.mType;
    }

    public SimpleDateTimeType getSimpleDateTimeType() {
        SimpleDateTimeType simpleDateTimeType = this.mType == FormatType.DATETIME || this.mType == FormatType.YMDHMS ? SimpleDateTimeType.DATETIME : (this.mType == FormatType.TIME || this.mType == FormatType.MTIME ? SimpleDateTimeType.TIME : SimpleDateTimeType.DATE);
        return simpleDateTimeType;
    }

    public String getKey() {
        return this.mKey;
    }

    public SPSS_Format getSpssFormat() {
        return new SPSS_Format(this.mType, this.mWidth, this.mDecimals);
    }

    public static SpssDateFormatHelper fromInt(int n) {
        switch (n) {
            default: {
                return eFORMAT_1;
            }
            case 1: {
                return eFORMAT_2;
            }
            case 2: {
                return eFORMAT_3;
            }
            case 3: {
                return eFORMAT_4;
            }
            case 4: {
                return eFORMAT_5;
            }
            case 5: {
                return eFORMAT_6;
            }
            case 6: {
                return eFORMAT_7;
            }
            case 7: {
                return eFORMAT_8;
            }
            case 8: {
                return eFORMAT_9;
            }
            case 9: {
                return eFORMAT_10;
            }
            case 10: {
                return eFORMAT_11;
            }
            case 11: {
                return eFORMAT_12;
            }
            case 12: {
                return eFORMAT_13;
            }
            case 13: {
                return eFORMAT_14;
            }
            case 14: {
                return eFORMAT_15;
            }
            case 15: {
                return eFORMAT_16;
            }
            case 16: {
                return eFORMAT_17;
            }
            case 17: {
                return eFORMAT_18;
            }
            case 18: {
                return eFORMAT_19;
            }
            case 19: {
                return eFORMAT_20;
            }
            case 20: {
                return eFORMAT_21;
            }
            case 21: {
                return eFORMAT_22;
            }
            case 22: {
                return eFORMAT_23;
            }
            case 23: {
                return eFORMAT_24;
            }
            case 24: {
                return eFORMAT_25;
            }
            case 25: {
                return eFORMAT_26;
            }
            case 26: {
                return eFORMAT_27;
            }
            case 27: {
                return eFORMAT_28;
            }
            case 28: {
                return eFORMAT_29;
            }
            case 30: {
                return eFORMAT_30;
            }
            case 31: {
                return eFORMAT_31;
            }
            case 32: {
                return eFORMAT_32;
            }
            case 33: {
                return eFORMAT_33;
            }
            case 34: 
        }
        return eFORMAT_34;
    }

    public static SpssDateFormatHelper getSpssDateFormatForFormatKey(String string) {
        SpssDateFormatHelper spssDateFormatHelper = null;
        for (SpssDateFormatHelper spssDateFormatHelper2 : SpssDateFormatHelper.values()) {
            if (!spssDateFormatHelper2.getFormat().equals(string)) continue;
            spssDateFormatHelper = spssDateFormatHelper2;
            break;
        }
        return spssDateFormatHelper;
    }

    public static SpssDateFormatHelper getClosestSpssDateFormatForFormatKey(String string, int n) {
        SpssDateFormatHelper spssDateFormatHelper = null;
        if (string.startsWith("DATETIME")) {
            spssDateFormatHelper = n < 20 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("DATETIME17") : (n < 22 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("DATETIME20") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("DATETIME23.2"));
        } else if (string.startsWith("DATE")) {
            spssDateFormatHelper = n < 11 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("DATE9") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("DATE11");
        } else if (string.startsWith("ADATE")) {
            spssDateFormatHelper = n < 10 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("ADATE8") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("ADATE10");
        } else if (string.startsWith("EDATE")) {
            spssDateFormatHelper = n < 10 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("EDATE8") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("EDATE10");
        } else if (string.startsWith("JDATE")) {
            spssDateFormatHelper = n < 7 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("JDATE5") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("JDATE7");
        } else if (string.startsWith("SDATE")) {
            spssDateFormatHelper = n < 10 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("SDATE8") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("SDATE10");
        } else if (string.startsWith("QYR")) {
            spssDateFormatHelper = n < 8 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("QYR6") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("QYR8");
        } else if (string.startsWith("MOYR")) {
            spssDateFormatHelper = n < 8 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("MOYR6") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("MOYR8");
        } else if (string.startsWith("WKYR")) {
            spssDateFormatHelper = n < 10 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("WKYR8") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("WKYR10");
        } else if (string.startsWith("WKDAY")) {
            spssDateFormatHelper = n < 9 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("WKDAY3") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("WKDAY9");
        } else if (string.startsWith("MONTH")) {
            spssDateFormatHelper = n < 9 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("MONTH3") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("MONTH9");
        } else if (string.startsWith("TIME")) {
            spssDateFormatHelper = n < 8 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("TIME5") : (n < 10 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("TIME8") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("TIME11.2"));
        } else if (string.startsWith("MTIME")) {
            spssDateFormatHelper = n < 8 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("MTIME5") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("MTIME8.2");
        } else if (string.startsWith("DTIME")) {
            spssDateFormatHelper = n < 11 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("DTIME9") : (n < 13 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("DTIME12") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("DTIME15.2"));
        } else if (string.startsWith("YMDHMS")) {
            spssDateFormatHelper = n < 19 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("YMDHMS16") : (n < 22 ? SpssDateFormatHelper.getSpssDateFormatForFormatKey("YMDHMS19") : SpssDateFormatHelper.getSpssDateFormatForFormatKey("YMDHMS22.2"));
        }
        return spssDateFormatHelper;
    }

    public static SpssDateFormatHelper getClosestSpssDateFormatForFormatKey(String string) {
        String string2 = null;
        int n = -1;
        if (string != null) {
            if (string.startsWith("DATETIME")) {
                string2 = string.substring("DATETIME".length());
            } else if (string.startsWith("DATE")) {
                string2 = string.substring("DATE".length());
            } else if (string.startsWith("ADATE")) {
                string2 = string.substring("ADATE".length());
            } else if (string.startsWith("EDATE")) {
                string2 = string.substring("EDATE".length());
            } else if (string.startsWith("JDATE")) {
                string2 = string.substring("JDATE".length());
            } else if (string.startsWith("SDATE")) {
                string2 = string.substring("SDATE".length());
            } else if (string.startsWith("QYR")) {
                string2 = string.substring("QYR".length());
            } else if (string.startsWith("MOYR")) {
                string2 = string.substring("MOYR".length());
            } else if (string.startsWith("WKYR")) {
                string2 = string.substring("WKYR".length());
            } else if (string.startsWith("WKDAY")) {
                string2 = string.substring("WKDAY".length());
            } else if (string.startsWith("MONTH")) {
                string2 = string.substring("MONTH".length());
            } else if (string.startsWith("TIME")) {
                string2 = string.substring("TIME".length());
            } else if (string.startsWith("DTIME")) {
                string2 = string.substring("DTIME".length());
            } else if (string.startsWith("MTIME")) {
                string2 = string.substring("MTIME".length());
            } else if (string.startsWith("YMDHMS")) {
                string2 = string.substring("YMDHMS".length());
            }
            if (string2 != null) {
                n = new Integer(string2);
            }
        }
        return n != -1 ? SpssDateFormatHelper.getClosestSpssDateFormatForFormatKey(string, n) : null;
    }

    public String getLocalizedFormatString() {
        return mCommonResBundle.getString(this.mKey);
    }

    public String getSimpleDateFormatPattern() {
        return this.mSimpleDateFormatPattern;
    }

    static {
        mCommonResBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
    }

    public static enum SimpleDateTimeType {
        DATE,
        TIME,
        DATETIME,
        UNKOWN;

    }
}

