/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.undo;

import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.undo.TableValueUpdateEdit;
import java.lang.ref.WeakReference;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class SpssUndoManager
extends UndoManager {
    private WeakReference mSpssFrame;
    public static final int TABLEVALUE_EDIT = 1;
    public static final int ADD_ROWS_EDIT = 2;
    int mEditUndoLock = 0;
    int mEditNotificationLock = 0;

    public SpssUndoManager(ITopWindow iTopWindow) {
        this.mSpssFrame = new WeakReference<ITopWindow>(iTopWindow);
    }

    public SpssFrame getSpssFrame() {
        return (SpssFrame)this.mSpssFrame.get();
    }

    public ITopWindow getTopFrame() {
        return (ITopWindow)this.mSpssFrame.get();
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        boolean bl = true;
        if (this.isUndoLocked(this.getType(undoableEdit))) {
            bl = false;
        } else {
            super.addEdit(undoableEdit);
        }
        return bl;
    }

    private int getType(UndoableEdit undoableEdit) {
        int n = -1;
        if (undoableEdit instanceof TableValueUpdateEdit) {
            n = 1;
        }
        return n;
    }

    public void addUndoLock(int n) {
        this.mEditUndoLock |= n;
    }

    public boolean isUndoLocked(int n) {
        return (this.mEditUndoLock & n) > 0;
    }

    public void clearAllUndoLocks() {
        this.mEditUndoLock = 0;
    }

    public void addNotificationLock(int n) {
        this.mEditNotificationLock |= n;
    }

    public boolean isNotificationLocked(int n) {
        return (this.mEditNotificationLock & n) > 0;
    }

    public void clearAllNotificationLocks() {
        this.mEditNotificationLock = 0;
    }
}

