/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.texteditor.bars;

import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.texteditor.actions.BaseTextAction;
import com.spss.java_client.ui.texteditor.actions.TextActionMgr;
import com.spss.java_client.ui.texteditor.bars.BaseTextBar;
import com.spss.java_client.ui.texteditor.resources.TextEditorResBundle;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.toolbar.MultiDockToolBarUI;
import com.spss.uitools.toolbar.RaisedToolBarBorder;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ToolBarUI;

public class TextMainBar
extends BaseTextBar {
    public TextMainBar(TextActionMgr textActionMgr, boolean bl) {
        super(textActionMgr, UIToolResUtil.getString((ResourceBundle)UIToolResUtil.getBundle((String)TextEditorResBundle.getDefaultResourceBundleName(), (Locale)UIToolResUtil.getLocale()), (String)"EditToolbarTitle"), 0);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        RaisedToolBarBorder raisedToolBarBorder = new RaisedToolBarBorder(uIDefaults.getColor("ToolBar.shadow"), uIDefaults.getColor("ToolBar.highlight"));
        this.setBorder((Border)raisedToolBarBorder);
        this.setFloatable(true);
        this.setupEditToolbar(bl);
    }

    public void setupEditToolbar(boolean bl) {
        this.setRollover(true);
        this.setMargin(new Insets(0, 4, 0, 4));
        this.setUI((ToolBarUI)new MultiDockToolBarUI());
        this.add(this.createButton("ToolBarUndo", "Undo"));
        this.add(this.createButton("ToolBarRedo", "Redo"));
        String string = "ToolBarFind";
        if (bl) {
            this.add(this.createButton(string, "Find"));
        } else {
            JButton jButton = new JButton(ActionCatalog.getActionCatalog().getSpssAction("edit_find"));
            jButton.setText(null);
            jButton.setMnemonic('\u0000');
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setToolTipText(UIToolResUtil.getString((ResourceBundle)UIToolResUtil.getBundle((String)TextEditorResBundle.getDefaultResourceBundleName(), (Locale)UIToolResUtil.getLocale()), (String)(string + "_TOOLTIP")));
            jButton.setFocusable(false);
            URL uRL = UIToolResUtil.getImageURL((ResourceBundle)UIToolResUtil.getBundle((String)TextEditorResBundle.getDefaultResourceBundleName(), (Locale)UIToolResUtil.getLocale()), (String)string);
            if (uRL != null) {
                jButton.setIcon(new ImageIcon(uRL));
            }
            this.add(jButton);
        }
        this.add(this.createButton("ToolBarPageUp", "PageUp"));
        this.add(this.createButton("ToolBarPageDown", "PageDown"));
        this.addSeparator();
    }

    public void refreshControls() {
        BaseTextAction baseTextAction = this.mActionMgr.getAction("Undo");
        baseTextAction.setEnabled(baseTextAction.getMenuItemEnableStatus(null));
        baseTextAction = this.mActionMgr.getAction("Redo");
        baseTextAction.setEnabled(baseTextAction.getMenuItemEnableStatus(null));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }
}

