/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.texteditor.bars;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import com.spss.java_client.ui.texteditor.TextEditorFrame;
import com.spss.java_client.ui.texteditor.actions.BaseTextAction;
import com.spss.java_client.ui.texteditor.actions.TextActionMgr;
import com.spss.java_client.ui.texteditor.bars.BaseTextBar;
import com.spss.java_client.ui.texteditor.resources.TextEditorResBundle;
import com.spss.shared.core_tools.utils.FontUtil;
import com.spss.uitools.drop_menu_button.DropApplyEvent;
import com.spss.uitools.drop_menu_button.DropButton;
import com.spss.uitools.drop_menu_button.DropButtonDrawer;
import com.spss.uitools.drop_menu_button.TextButtonDrawer;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.toolbar.MultiDockToolBarUI;
import com.spss.uitools.toolbar.RaisedToolBarBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ToolBarUI;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class TextFormatBar
extends BaseTextBar {
    private final String TEXT_CHAR = UIToolResUtil.getString((ResourceBundle)UIToolResUtil.getBundle((String)TextEditorResBundle.getDefaultResourceBundleName(), (Locale)UIToolResUtil.getLocale()), (String)"ToolbarTextColorSampleChar");
    private JComboBox mFontFaceCombo;
    private JComboBox mFontSizeCombo;
    private JToggleButton mBoldButton;
    private JToggleButton mItalicButton;
    private JToggleButton mUnderlineButton;
    private TextButtonDrawer mTextColorDrawer = new TextButtonDrawer(this.TEXT_CHAR, 3);
    private DropButton mTextColorButton;
    private JToggleButton mLeftAlignButton;
    private JToggleButton mCenterAlignButton;
    private JToggleButton mRightAlignButton;
    private ComboItemListener comboItemListener = new ComboItemListener();
    private ColorHandler mColorHandler = new ColorHandler();

    public TextFormatBar(TextActionMgr textActionMgr) {
        super(textActionMgr, UIToolResUtil.getString((ResourceBundle)UIToolResUtil.getBundle((String)TextEditorResBundle.getDefaultResourceBundleName(), (Locale)UIToolResUtil.getLocale()), (String)"FormatToolBarTitle"), 0);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        RaisedToolBarBorder raisedToolBarBorder = new RaisedToolBarBorder(uIDefaults.getColor("ToolBar.shadow"), uIDefaults.getColor("ToolBar.highlight"));
        this.setBorder((Border)raisedToolBarBorder);
        this.setFloatable(true);
        this.setupToolbar();
        this.setTextColors();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void updateBar(TextEditorFrame textEditorFrame, TextViewerItem textViewerItem) {
        BaseTextAction baseTextAction = this.mActionMgr.getAction("AlignLeft");
        baseTextAction.setItem(textViewerItem);
        baseTextAction.setEnabled(baseTextAction.getMenuItemEnableStatus(textEditorFrame));
        baseTextAction = this.mActionMgr.getAction("AlignCenter");
        baseTextAction.setItem(textViewerItem);
        baseTextAction.setEnabled(baseTextAction.getMenuItemEnableStatus(textEditorFrame));
        baseTextAction = this.mActionMgr.getAction("AlignRight");
        baseTextAction.setItem(textViewerItem);
        baseTextAction.setEnabled(baseTextAction.getMenuItemEnableStatus(textEditorFrame));
    }

    private void setupToolbar() {
        this.setRollover(true);
        this.setMargin(new Insets(0, 4, 0, 4));
        if (!UIManager.getLookAndFeel().getName().contains("CobaltLookAndFeel")) {
            this.setUI((ToolBarUI)new MultiDockToolBarUI());
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames(UIToolResUtil.getLocale());
        this.mFontFaceCombo = this.createComboBox(stringArray, new Dimension(120, 18));
        this.mFontFaceCombo.setEditable(false);
        this.add(this.mFontFaceCombo);
        this.addSeparator();
        float[] fArray = SpssTextPane.getLogicalFontSizes();
        String[] stringArray2 = new String[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            stringArray2[i] = SpssTextPane.formatLogicalFontSize(fArray[i]);
        }
        this.mFontSizeCombo = this.createComboBox(stringArray2, new Dimension(50, 18));
        this.mFontSizeCombo.setEditable(false);
        this.add(this.mFontSizeCombo);
        this.addSeparator();
        this.mBoldButton = this.createToggleButton("ToolBarBold", "Bold");
        this.add(this.mBoldButton);
        this.mItalicButton = this.createToggleButton("ToolBarItalic", "Italic");
        this.add(this.mItalicButton);
        this.mUnderlineButton = this.createToggleButton("ToolBarUnderline", "Underline");
        this.add(this.mUnderlineButton);
        this.mTextColorButton = this.createDropButton((DropButtonDrawer)this.mTextColorDrawer, "ToolBarTextColor");
        this.add((Component)this.mTextColorButton);
        this.addSeparator();
        ButtonGroupEx buttonGroupEx = new ButtonGroupEx();
        this.mLeftAlignButton = this.createToggleButton("ToolBarAlignLeft", "AlignLeft");
        this.add(this.mLeftAlignButton);
        buttonGroupEx.add(this.mLeftAlignButton);
        this.mCenterAlignButton = this.createToggleButton("ToolBarAlignCenter", "AlignCenter");
        this.add(this.mCenterAlignButton);
        buttonGroupEx.add(this.mCenterAlignButton);
        this.mRightAlignButton = this.createToggleButton("ToolBarAlignRight", "AlignRight");
        this.add(this.mRightAlignButton);
        buttonGroupEx.add(this.mRightAlignButton);
        this.addSeparator();
        this.setFocusTraversalPolicy(null);
        this.addListeners();
    }

    private void setTextColors() {
        Color[] colorArray = new Color[]{new Color(225, 188, 29), new Color(92, 202, 136), new Color(0, 180, 160), new Color(227, 215, 16), new Color(236, 230, 208), new Color(254, 130, 180), new Color(204, 134, 63), new Color(63, 235, 124), new Color(28, 205, 205), new Color(207, 172, 227), new Color(208, 202, 140), new Color(237, 75, 75), new Color(225, 139, 14), new Color(95, 195, 56), new Color(85, 150, 230), new Color(204, 127, 228), new Color(150, 145, 145), new Color(215, 0, 51), new Color(208, 83, 52), new Color(41, 134, 38), new Color(63, 90, 168), new Color(171, 73, 243), new Color(90, 100, 94), new Color(155, 0, 0), new Color(243, 103, 42), new Color(92, 113, 72), new Color(9, 38, 114), new Color(119, 55, 143), new Color(69, 70, 71)};
        this.mTextColorButton.setColors(colorArray);
    }

    public void refreshControls() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n;
        int n2;
        Color color;
        String string;
        this.removeListeners();
        SpssTextPane spssTextPane = this.mActionMgr.getTextPane();
        int n3 = spssTextPane.getSelectionStart();
        int n4 = spssTextPane.getSelectionEnd();
        if (n3 == n4 && n3 > 1) {
            --n3;
        }
        if (spssTextPane.isHTMLDocument()) {
            Element element = ((StyledDocument)spssTextPane.getDocument()).getCharacterElement(n3);
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
            string = StyleConstants.getFontFamily(mutableAttributeSet);
            color = StyleConstants.getForeground(mutableAttributeSet);
            n2 = StyleConstants.getFontSize(mutableAttributeSet);
            n = StyleConstants.getAlignment(mutableAttributeSet);
            bl3 = StyleConstants.isBold(mutableAttributeSet);
            bl2 = StyleConstants.isItalic(mutableAttributeSet);
            bl = StyleConstants.isUnderline(mutableAttributeSet);
        } else {
            string = spssTextPane.getFont().getFamily();
            color = spssTextPane.getForeground();
            n2 = spssTextPane.getFont().getSize();
            n = 0;
            bl3 = spssTextPane.getFont().isBold();
            bl2 = spssTextPane.getFont().isItalic();
            bl = false;
            this.mUnderlineButton.setEnabled(false);
            this.mLeftAlignButton.setEnabled(false);
            this.mCenterAlignButton.setEnabled(false);
            this.mRightAlignButton.setEnabled(false);
        }
        this.mFontFaceCombo.setSelectedItem(string);
        this.scrollComboToStart(this.mFontFaceCombo);
        this.mFontSizeCombo.setSelectedItem(SpssTextPane.formatLogicalFontSize(FontUtil.physicalToLogicalSize((float)n2)));
        this.mBoldButton.setSelected(bl3);
        this.mItalicButton.setSelected(bl2);
        if (this.mUnderlineButton.isEnabled()) {
            this.mUnderlineButton.setSelected(bl);
        }
        if (this.mLeftAlignButton.isEnabled()) {
            this.mLeftAlignButton.setSelected(n == 0);
        }
        if (this.mCenterAlignButton.isEnabled()) {
            this.mCenterAlignButton.setSelected(n == 1);
        }
        if (this.mRightAlignButton.isEnabled()) {
            this.mRightAlignButton.setSelected(n == 2);
        }
        this.mTextColorButton.setSelectColor(color);
        this.addListeners();
    }

    protected void scrollComboToStart(JComboBox jComboBox) {
        Component component = jComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            ((JTextField)component).setCaretPosition(0);
        }
    }

    protected void faceComboChanged() {
        String string = (String)this.mFontFaceCombo.getSelectedItem();
        this.scrollComboToStart(this.mFontFaceCombo);
        SpssTextPane spssTextPane = this.mActionMgr.getTextPane();
        if (string != null && string.length() > 0) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setFontFamily(simpleAttributeSet, string);
            spssTextPane.setCharacterAttributes(simpleAttributeSet, false);
            spssTextPane.requestFocus();
        } else {
            UIManager.getLookAndFeel().provideErrorFeedback(spssTextPane);
        }
    }

    protected void sizeComboChanged() {
        String string = (String)this.mFontSizeCombo.getSelectedItem();
        this.scrollComboToStart(this.mFontSizeCombo);
        if (string != null && string.length() > 0) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(ComponentState.getSPSSLocale());
            float f = 0.0f;
            try {
                f = numberFormat.parse(string).floatValue();
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            SpssTextPane spssTextPane = this.mActionMgr.getTextPane();
            if (f != 0.0f) {
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setFontSize(simpleAttributeSet, (int)FontUtil.logicalToPhysicalSize((float)f));
                spssTextPane.setCharacterAttributes(simpleAttributeSet, false);
                spssTextPane.requestFocus();
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(spssTextPane);
            }
        }
    }

    private void addListeners() {
        this.mFontSizeCombo.addItemListener(this.comboItemListener);
        this.mFontFaceCombo.addItemListener(this.comboItemListener);
        this.mTextColorButton.addActionListener((ActionListener)this.mColorHandler);
    }

    private void removeListeners() {
        this.mFontSizeCombo.removeItemListener(this.comboItemListener);
        this.mFontFaceCombo.removeItemListener(this.comboItemListener);
        this.mTextColorButton.removeActionListener((ActionListener)this.mColorHandler);
    }

    class ColorHandler
    implements ActionListener {
        ColorHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent instanceof DropApplyEvent) {
                Color color = ((DropApplyEvent)actionEvent).getColor();
                SpssTextPane spssTextPane = TextFormatBar.this.mActionMgr.getTextPane();
                if (spssTextPane.isHTMLDocument()) {
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    StyleConstants.setForeground(simpleAttributeSet, color);
                    int n = spssTextPane.getSelectionStart();
                    Element element = ((StyledDocument)spssTextPane.getDocument()).getCharacterElement(n);
                    MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
                    String string = StyleConstants.getFontFamily(mutableAttributeSet);
                    StyleConstants.setFontFamily(simpleAttributeSet, string);
                    int n2 = StyleConstants.getFontSize(mutableAttributeSet);
                    StyleConstants.setFontSize(simpleAttributeSet, n2);
                    spssTextPane.setCharacterAttributes(simpleAttributeSet, false);
                } else {
                    spssTextPane.setForeground(color);
                }
            }
        }
    }

    class ComboItemListener
    implements ItemListener {
        ComboItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                Object object = itemEvent.getSource();
                if (object == TextFormatBar.this.mFontFaceCombo) {
                    TextFormatBar.this.faceComboChanged();
                } else if (object == TextFormatBar.this.mFontSizeCombo) {
                    TextFormatBar.this.sizeComboChanged();
                }
            }
        }
    }

    class ButtonGroupEx
    extends ButtonGroup {
        ButtonGroupEx() {
        }

        @Override
        public void setSelected(ButtonModel buttonModel, boolean bl) {
            if (buttonModel == null && !bl) {
                ButtonModel buttonModel2 = this.getSelection();
                if (buttonModel2 != null) {
                    buttonModel2.setGroup(null);
                    buttonModel2.setSelected(false);
                    buttonModel2.setGroup(this);
                }
            } else {
                super.setSelected(buttonModel, bl);
            }
        }
    }
}

