/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.texteditor.actions;

import com.spss.java_client.core.common.LicenseOption;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.doc_util.OptionLocator;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import com.spss.java_client.ui.texteditor.TextEditorFrame;
import com.spss.java_client.ui.texteditor.resources.TextEditorResBundle;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class BaseTextAction
extends AbstractAction {
    protected String mActionId = null;
    protected SpssTextPane mTextPane;
    protected TextViewerItem mItem;

    public BaseTextAction(String string, SpssTextPane spssTextPane) {
        this.mActionId = string;
        this.mTextPane = spssTextPane;
        this.mItem = null;
        this.configureAction(false);
    }

    public String getActionId() {
        return this.mActionId;
    }

    public LicenseOption getLicenseOption() {
        return OptionLocator.getOption(this.getActionId());
    }

    public JFrame getFrame(Component component) {
        JFrame jFrame = null;
        while (component != null && !(component instanceof JFrame)) {
            Component component2 = component;
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            component = component2.getParent();
        }
        if (component != null) {
            jFrame = (JFrame)component;
        }
        return jFrame;
    }

    public JMenuItem getMenuItem() {
        return new JMenuItem(this);
    }

    public boolean getMenuItemCheckStatus(TextEditorFrame textEditorFrame) {
        return false;
    }

    public boolean getMenuItemEnableStatus(TextEditorFrame textEditorFrame) {
        return true;
    }

    public void updateMenuText(JMenuItem jMenuItem) {
    }

    @Override
    public SpssAction clone() throws CloneNotSupportedException {
        return (SpssAction)super.clone();
    }

    public void setItem(TextViewerItem textViewerItem) {
        this.mItem = textViewerItem;
    }

    public TextViewerItem getItem() {
        return this.mItem;
    }

    protected void configureAction(boolean bl) {
        try {
            KeyStroke keyStroke;
            Integer n;
            Object object;
            if (bl && (object = UIToolResUtil.getImageURL((ResourceBundle)UIToolResUtil.getBundle((String)TextEditorResBundle.getDefaultResourceBundleName(), (Locale)UIToolResUtil.getLocale()), (String)this.mActionId)) != null) {
                this.putValue("SmallIcon", new ImageIcon((URL)object));
            }
            if ((object = UIToolResUtil.getString((ResourceBundle)UIToolResUtil.getBundle((String)TextEditorResBundle.getDefaultResourceBundleName(), (Locale)UIToolResUtil.getLocale()), (String)this.mActionId)) != null) {
                this.putValue("Name", object);
            }
            if ((n = UIToolResUtil.getAccessKey((ResourceBundle)UIToolResUtil.getBundle((String)TextEditorResBundle.getDefaultResourceBundleName(), (Locale)UIToolResUtil.getLocale()), (String)this.mActionId)) != null) {
                this.putValue("MnemonicKey", n);
            }
            if ((keyStroke = (KeyStroke)UIToolResUtil.getObject((String)(this.mActionId + "_SHORTCUT"), (ResourceBundle)UIToolResUtil.getBundle((String)TextEditorResBundle.getDefaultResourceBundleName(), (Locale)UIToolResUtil.getLocale()))) != null) {
                this.putValue("AcceleratorKey", keyStroke);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void enableToolTip() {
        String string = ResUtil.getTooltip(this.mActionId);
        if (string != null) {
            this.putValue("ShortDescription", string);
        }
    }

    public boolean showMenu() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }
}

