/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.texteditor.actions;

import com.spss.java_client.core.common.OutputItemAlignment;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import com.spss.java_client.ui.texteditor.TextEditorFrame;
import com.spss.java_client.ui.texteditor.actions.BaseTextAction;
import java.awt.event.ActionEvent;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class AlignCenterAction
extends BaseTextAction {
    public AlignCenterAction(SpssTextPane spssTextPane) {
        super("AlignCenter", spssTextPane);
    }

    @Override
    public boolean getMenuItemEnableStatus(TextEditorFrame textEditorFrame) {
        return this.mTextPane.isAlignmentEnabled() && this.mTextPane.isHTMLDocument();
    }

    @Override
    public boolean getMenuItemCheckStatus(TextEditorFrame textEditorFrame) {
        Element element;
        MutableAttributeSet mutableAttributeSet;
        if (!textEditorFrame.getTextPane().isHTMLDocument()) {
            return false;
        }
        int n = this.mTextPane.getSelectionStart();
        if (n < 0) {
            n = this.mTextPane.getCaretPosition();
        }
        return StyleConstants.getAlignment(mutableAttributeSet = (MutableAttributeSet)(element = ((StyledDocument)this.mTextPane.getDocument()).getCharacterElement(n)).getAttributes()) == 1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.mTextPane.setParagraphAlignment(1);
        if (this.mTextPane.isAlignmentEnabled() && this.mItem != null) {
            this.mItem.getCoreItem().setAlignment(OutputItemAlignment.Center);
            StyledDocument styledDocument = (StyledDocument)this.mTextPane.getDocument();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setAlignment(simpleAttributeSet, 1);
            styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
        }
    }
}

