/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.texteditor;

import com.spss.java_client.ui.print.PrintOptions;
import com.spss.java_client.ui.print.SpssPrintable;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.Icon;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class TextPrintable
extends SpssPrintable {
    private SpssTextPane mTextPane;
    protected PageFormat mPageFormat;
    private final Rectangle mMainClip = new Rectangle(0, 0, 0, 0);
    private int mLast = -1;
    private int mCharPos = 0;
    private boolean mIsPrevIcon = false;

    public TextPrintable(SpssTextPane spssTextPane, PrintOptions printOptions) {
        super(printOptions);
        this.mTextPane = spssTextPane;
    }

    @Override
    public void reset() {
        this.mLast = -1;
        this.mCharPos = 0;
        this.mMainClip.x = 0;
        this.mMainClip.y = 0;
        this.mMainClip.width = 0;
        this.mMainClip.height = 0;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n == 0) {
            this.mPrintOptions.setPageFormat((PageFormat)pageFormat.clone());
            this.mNumberOfPages = this.getTotalPageNumber(pageFormat);
        }
        if (n > this.mNumberOfPages) {
            return 1;
        }
        int n2 = (int)pageFormat.getImageableWidth();
        int n3 = (int)pageFormat.getImageableHeight();
        while (this.mLast < n) {
            this.findNextClip(n2, n3);
            ++this.mLast;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.disableDoubleBuffering(this.mTextPane);
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        graphics2D.translate(-this.mMainClip.x, -this.mMainClip.y);
        Rectangle rectangle = new Rectangle(this.mMainClip);
        if (n == this.mNumberOfPages - 1) {
            rectangle.height += 40;
        }
        graphics2D.clip(rectangle);
        this.mTextPane.print(graphics);
        graphics2D.setClip(shape);
        graphics2D.setTransform(affineTransform);
        this.enableDoubleBuffering(this.mTextPane);
        return 0;
    }

    private int getTotalPageNumber(PageFormat pageFormat) {
        int n = (int)pageFormat.getImageableHeight();
        int n2 = this.mTextPane.getDocument().getLength();
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        try {
            Rectangle rectangle = this.mTextPane.modelToView(n4);
            int n6 = rectangle.y;
            int n7 = rectangle.height;
            do {
                n5 += n7;
                n7 = 0;
                Element element = ((StyledDocument)this.mTextPane.getDocument()).getCharacterElement(n4);
                AttributeSet attributeSet = element.getAttributes();
                Icon icon = StyleConstants.getIcon(attributeSet);
                rectangle = this.mTextPane.modelToView(n4);
                if (n6 != rectangle.y) {
                    n6 = rectangle.y;
                    n7 = icon != null ? n * n3 - n5 + 1 : rectangle.height;
                }
                ++n4;
                if (n5 + n7 <= n * n3) continue;
                ++n3;
            } while (n4 < n2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n3;
    }

    private void findNextClip(int n, int n2) {
        this.mMainClip.x = 0;
        this.mMainClip.width = n;
        this.mMainClip.y += this.mMainClip.height;
        this.mMainClip.height = 0;
        try {
            Rectangle rectangle = this.mTextPane.modelToView(this.mCharPos);
            int n3 = rectangle.y;
            int n4 = rectangle.height;
            do {
                this.mMainClip.height += n4;
                n4 = 0;
                Element element = ((StyledDocument)this.mTextPane.getDocument()).getCharacterElement(this.mCharPos);
                AttributeSet attributeSet = element.getAttributes();
                Icon icon = StyleConstants.getIcon(attributeSet);
                rectangle = this.mTextPane.modelToView(this.mCharPos);
                ++this.mCharPos;
                if (n3 == rectangle.y) continue;
                n3 = rectangle.y;
                if (icon != null) {
                    this.mMainClip.height = n3 - this.mMainClip.y;
                    this.mIsPrevIcon = true;
                    break;
                }
                if (this.mIsPrevIcon) {
                    this.mIsPrevIcon = false;
                    this.mMainClip.y += rectangle.height;
                    continue;
                }
                n4 = rectangle.height;
            } while (this.mMainClip.height + n4 <= n2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

