/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.texteditor;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerSearchOptions;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import com.spss.java_client.ui.texteditor.TextEditorFocusTraversalPolicy;
import com.spss.java_client.ui.texteditor.actions.BaseTextAction;
import com.spss.java_client.ui.texteditor.actions.TextActionMgr;
import com.spss.java_client.ui.texteditor.bars.BaseTextBar;
import com.spss.java_client.ui.texteditor.bars.EditStatusBar;
import com.spss.java_client.ui.texteditor.bars.TextFormatBar;
import com.spss.java_client.ui.texteditor.bars.TextMainBar;
import com.spss.java_client.ui.texteditor.menus.EditMenu;
import com.spss.java_client.ui.texteditor.menus.FileMenu;
import com.spss.java_client.ui.texteditor.menus.FormatMenu;
import com.spss.java_client.ui.texteditor.menus.HelpMenu;
import com.spss.java_client.ui.texteditor.menus.InsertMenu;
import com.spss.java_client.ui.texteditor.menus.ViewMenu;
import com.spss.java_client.ui.texteditor.resources.TextEditorResBundle;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.toolbar.MultiDockToolBarUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CompoundEdit;

public class TextEditorFrame
extends JFrame
implements MenuListener,
MenuDragMouseListener,
ChangeListener,
ISearchProxy {
    public static final int MAIN_TOOLBAR = 0;
    public static final int FORMAT_TOOLBAR = 1;
    public static final String[] kToolBarPrefix = new String[]{"mainbar_", "formatbar_"};
    public static final String kToolBarFloating = "floating";
    public static final String kDockIndex = "index";
    public static final String kXLocation = "xlocation";
    public static final String kYLocation = "ylocation";
    public static final String kVisible = "visible";
    private SpssTextPane mTextPane;
    private TextActionMgr mActionMgr;
    private TextMainBar mMainToolbar;
    private TextFormatBar mFormatToolbar;
    private JPanel mTBPanelNorth = null;
    private EditStatusBar mStatusBar = null;
    protected ViewerFindDlg mFindReplaceDlg = null;
    private String mItemName = "";
    private boolean mWasSearchWindowOpen = false;

    public TextEditorFrame() {
        super(UIToolResUtil.getString((ResourceBundle)UIToolResUtil.getBundle((String)TextEditorResBundle.getDefaultResourceBundleName(), (Locale)UIToolResUtil.getLocale()), (String)"text_editor_title"));
        this.mTextPane = new SpssTextPane();
        this.init(this.getContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TextEditorFrame.this.exit();
            }
        });
        TextEditorFocusTraversalPolicy textEditorFocusTraversalPolicy = new TextEditorFocusTraversalPolicy(new Component[]{this.mTextPane});
        this.setFocusTraversalPolicy(textEditorFocusTraversalPolicy);
        this.mTextPane.requestFocus();
        this.setVisible(false);
    }

    public TextEditorFrame(SpssTextPane spssTextPane) {
        super(UIToolResUtil.getString((ResourceBundle)UIToolResUtil.getBundle((String)TextEditorResBundle.getDefaultResourceBundleName(), (Locale)UIToolResUtil.getLocale()), (String)"text_editor_title"));
        this.mTextPane = spssTextPane;
        this.init(this.getContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TextEditorFrame.this.exit();
            }
        });
        TextEditorFocusTraversalPolicy textEditorFocusTraversalPolicy = new TextEditorFocusTraversalPolicy(new Component[]{this.mTextPane});
        this.setFocusTraversalPolicy(textEditorFocusTraversalPolicy);
        this.mTextPane.requestFocus();
        this.setVisible(false);
    }

    @Override
    public boolean isFocusCycleRoot(Container container) {
        return true;
    }

    public void setItemName(String string) {
        this.mItemName = string;
    }

    public String getItemName() {
        return this.mItemName;
    }

    private void init(Container container) {
        this.mActionMgr = new TextActionMgr(this.mTextPane);
        container.add(new JScrollPane(this.mTextPane));
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(new FileMenu(this.mActionMgr));
        jMenuBar.add(new EditMenu(this.mActionMgr));
        jMenuBar.add(new ViewMenu(this.mActionMgr));
        jMenuBar.add(new InsertMenu(this.mActionMgr));
        jMenuBar.add(new FormatMenu(this.mActionMgr));
        jMenuBar.add(new HelpMenu(this.mActionMgr));
        this.mTBPanelNorth = new JPanel();
        MyFlowLayout myFlowLayout = new MyFlowLayout(0, 0, 0, true);
        myFlowLayout.setVgap(0);
        this.mTBPanelNorth.setLayout(myFlowLayout);
        this.mMainToolbar = new TextMainBar(this.mActionMgr, true);
        this.mTBPanelNorth.add(this.mMainToolbar);
        this.mFormatToolbar = new TextFormatBar(this.mActionMgr);
        this.mTBPanelNorth.add(this.mFormatToolbar);
        container.add((Component)this.mTBPanelNorth, "North");
        this.mStatusBar = new EditStatusBar();
        container.add((Component)this.mStatusBar, "South");
        this.mTextPane.setFormatToolBar(this.mFormatToolbar);
        this.mTextPane.setMainToolBar(this.mMainToolbar);
        this.addMenuBarListeners(jMenuBar);
        this.addToolBarListeners(this.mMainToolbar);
        this.addToolBarListeners(this.mFormatToolbar);
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("texteditor");
        this.applyPreferences(preferences2);
    }

    public void updateFormatBar(TextViewerItem textViewerItem) {
        this.mFormatToolbar.updateBar(this, textViewerItem);
    }

    public SpssTextPane getTextPane() {
        return this.mTextPane;
    }

    public TextActionMgr getActionMgr() {
        return this.mActionMgr;
    }

    public void addMenuBarListeners(JMenuBar jMenuBar) {
        if (jMenuBar == null) {
            return;
        }
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            this.addMenuListeners(jMenuBar.getMenu(i));
        }
    }

    public void addMenuListeners(JMenu jMenu) {
        if (jMenu == null) {
            return;
        }
        int n = jMenu.getMenuComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jMenu.getMenuComponent(i);
            if (component instanceof JMenu) {
                this.addMenuListeners((JMenu)component);
                continue;
            }
            if (!(component instanceof JMenuItem)) continue;
            ((JMenuItem)component).addMenuDragMouseListener(this);
            ((JMenuItem)component).addChangeListener(this);
        }
        jMenu.addMenuListener(this);
    }

    protected void addToolBarListeners(JToolBar jToolBar) {
        int n = jToolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jToolBar.getComponent(i);
            if (!(component instanceof AbstractButton)) continue;
            ((AbstractButton)component).addChangeListener(this);
        }
    }

    public void updateStatusBarHelpText(String string) {
        this.mStatusBar.updateStatusBarHelpText(string);
    }

    public void updateStatusBarHelpText(AbstractButton abstractButton) {
        this.mStatusBar.updateStatusBarHelpText(abstractButton);
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        String string;
        JMenu jMenu = (JMenu)menuEvent.getSource();
        this.updateStatusBarHelpText(jMenu);
        if (jMenu.getAction() instanceof BaseTextAction && ("View".equals(string = ((BaseTextAction)jMenu.getAction()).getActionId()) || "Format".equals(string))) {
            this.refreshMenuCheckStatus(jMenu);
        }
        this.updateMenuEnableStatus(jMenu);
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        this.updateStatusBarHelpText((String)null);
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        this.updateStatusBarHelpText((String)null);
    }

    @Override
    public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        JMenuItem jMenuItem = (JMenuItem)menuDragMouseEvent.getSource();
        this.updateStatusBarHelpText(jMenuItem);
    }

    @Override
    public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        this.updateStatusBarHelpText((String)null);
    }

    @Override
    public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
    }

    @Override
    public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        this.updateStatusBarHelpText((String)null);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Component component = (Component)changeEvent.getSource();
        if (component instanceof JMenuItem) {
            boolean bl = ((JMenuItem)component).isArmed();
            this.updateStatusBarHelpText(bl ? (JMenuItem)component : null);
        } else if (component instanceof AbstractButton) {
            boolean bl = ((AbstractButton)component).getModel().isRollover();
            this.updateStatusBarHelpText(bl ? (AbstractButton)component : null);
        } else {
            this.updateStatusBarHelpText((String)null);
        }
    }

    public void applyPreferences(Preferences preferences) {
        int n = 600;
        int n2 = 500;
        Dimension dimension = this.getToolkit().getScreenSize();
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        this.setLocation(preferences.getInt("text_mainframe_xlocation", n3), preferences.getInt("text_mainframe_ylocation", n4));
        this.applyToolBars(preferences);
        this.setSize(n, n2);
    }

    public void savePreferences(Preferences preferences) {
        preferences.putInt("text_mainframe_xlocation", this.getLocation().x);
        preferences.putInt("text_mainframe_ylocation", this.getLocation().y);
        for (int i = 0; i < 2; ++i) {
            this.saveToolBarPreference(preferences, this.getToolBarById(i), i, this.getDockingIndex(i));
        }
    }

    private int getDockingIndex(int n) {
        int n2 = -1;
        Component[] componentArray = this.mTBPanelNorth.getComponents();
        for (int i = 0; i < this.mTBPanelNorth.getComponentCount(); ++i) {
            JComponent jComponent = (JComponent)componentArray[i];
            if (jComponent != this.getToolBarById(n)) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public void exit() {
        if (this.isVisible()) {
            this.mWasSearchWindowOpen = this.getFindDlg().isVisible();
            if (this.mWasSearchWindowOpen) {
                this.getFindDlg().setVisible(false);
            }
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            Preferences preferences2 = preferences.node("texteditor");
            this.savePreferences(preferences2);
            this.setVisible(false);
        }
    }

    public void applyToolBars(Preferences preferences) {
        for (int i = 0; i < 2; ++i) {
            this.applyToolBarPreference(preferences, this.getToolBarById(i), i);
        }
    }

    public int applyToolBarPreference(Preferences preferences, JToolBar jToolBar, int n) {
        int n2 = -1;
        MultiDockToolBarUI multiDockToolBarUI = null;
        if (jToolBar.getUI() instanceof MultiDockToolBarUI) {
            multiDockToolBarUI = (MultiDockToolBarUI)jToolBar.getUI();
        }
        boolean bl = preferences.getBoolean(kToolBarPrefix[n] + kVisible, true);
        boolean bl2 = preferences.getBoolean(kToolBarPrefix[n] + kToolBarFloating, false);
        int n3 = preferences.getInt(kToolBarPrefix[n] + kXLocation, 0);
        int n4 = preferences.getInt(kToolBarPrefix[n] + kYLocation, 0);
        if (bl) {
            if (bl2 && multiDockToolBarUI != null) {
                multiDockToolBarUI.setFloatingLocation(n3, n4);
                multiDockToolBarUI.setFloating(bl2, null);
            } else {
                n2 = preferences.getInt(kToolBarPrefix[n] + kDockIndex, n);
            }
        } else {
            jToolBar.setVisible(false);
            n2 = -2;
        }
        return n2;
    }

    public boolean wasSearchWindowOpen() {
        return this.mWasSearchWindowOpen;
    }

    private void saveToolBarPreference(Preferences preferences, JToolBar jToolBar, int n, int n2) {
        if (!(jToolBar.getUI() instanceof MultiDockToolBarUI)) {
            return;
        }
        MultiDockToolBarUI multiDockToolBarUI = (MultiDockToolBarUI)jToolBar.getUI();
        boolean bl = jToolBar.isVisible();
        boolean bl2 = multiDockToolBarUI.isFloating();
        preferences.putBoolean(kToolBarPrefix[n] + kVisible, bl);
        preferences.putBoolean(kToolBarPrefix[n] + kToolBarFloating, bl2);
        if (!bl2) {
            preferences.putInt(kToolBarPrefix[n] + kDockIndex, n2);
        } else {
            Point point = multiDockToolBarUI.getFloatingWinLocation();
            preferences.putInt(kToolBarPrefix[n] + kXLocation, point.x);
            preferences.putInt(kToolBarPrefix[n] + kYLocation, point.y);
        }
    }

    private JToolBar getToolBarById(int n) {
        BaseTextBar baseTextBar = null;
        switch (n) {
            case 0: {
                baseTextBar = this.mTextPane.getMainToolBar();
                break;
            }
            case 1: {
                baseTextBar = this.mTextPane.getFormatToolBar();
                break;
            }
        }
        return baseTextBar;
    }

    protected void refreshMenuCheckStatus(JMenu jMenu) {
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            BaseTextAction baseTextAction;
            JMenuItem jMenuItem;
            JMenuItem jMenuItem2 = jMenu.getItem(i);
            if (jMenuItem2 instanceof JCheckBoxMenuItem) {
                jMenuItem = (JCheckBoxMenuItem)jMenuItem2;
                baseTextAction = (BaseTextAction)jMenuItem2.getAction();
                ((JCheckBoxMenuItem)jMenuItem).setState(baseTextAction.getMenuItemCheckStatus(this));
                continue;
            }
            if (!(jMenuItem2 instanceof JRadioButtonMenuItem)) continue;
            jMenuItem = (JRadioButtonMenuItem)jMenuItem2;
            baseTextAction = (BaseTextAction)jMenuItem2.getAction();
            jMenuItem.setSelected(baseTextAction.getMenuItemCheckStatus(this));
        }
    }

    protected void refreshMenuText(JMenu jMenu) {
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            BaseTextAction baseTextAction = (BaseTextAction)jMenuItem.getAction();
            baseTextAction.updateMenuText(jMenuItem);
            String string = (String)baseTextAction.getValue("ShortDescription");
            if (string == null) continue;
            jMenuItem.setToolTipText(string);
        }
    }

    public void updateMenuEnableStatus(JMenu jMenu) {
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            Action action;
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !((action = jMenuItem.getAction()) instanceof BaseTextAction)) continue;
            BaseTextAction baseTextAction = (BaseTextAction)action;
            baseTextAction.setEnabled(baseTextAction.getMenuItemEnableStatus(this));
        }
    }

    public void toggleToolBarViewState(int n) {
        BaseTextBar baseTextBar;
        switch (n) {
            case 0: {
                baseTextBar = this.mTextPane.getMainToolBar();
                break;
            }
            case 1: {
                baseTextBar = this.mTextPane.getFormatToolBar();
                break;
            }
            default: {
                return;
            }
        }
        boolean bl = baseTextBar.isVisible();
        Window window = SwingUtilities.getWindowAncestor(baseTextBar);
        if (window != null && window instanceof JDialog) {
            window.setVisible(!bl);
        }
        baseTextBar.setVisible(!bl);
    }

    public TextMainBar getExternMainToolbar() {
        return this.mMainToolbar;
    }

    public TextFormatBar getExternFormatingToolbar() {
        return this.mFormatToolbar;
    }

    public TextMainBar getCurrentMainToolbar() {
        return this.mTextPane.getMainToolBar();
    }

    public TextFormatBar getCurrentFormatingToolbar() {
        return this.mTextPane.getFormatToolBar();
    }

    public EditStatusBar getStatusBar() {
        return this.mStatusBar;
    }

    public void setToolBarPanel(JPanel jPanel) {
        this.remove(this.mTBPanelNorth);
        this.mTBPanelNorth = jPanel;
    }

    public JPanel getToolBarPanel() {
        return this.mTBPanelNorth;
    }

    public ViewerFindDlg getFindReplaceDlg() {
        if (this.mTextPane.getText() != null && this.mTextPane.getText().length() == 0) {
            return null;
        }
        return this.getFindDlg();
    }

    @Override
    public boolean findNext(String string, SearchOptions searchOptions) {
        boolean bl;
        ViewerSearchOptions viewerSearchOptions = (ViewerSearchOptions)searchOptions;
        viewerSearchOptions.setItemsSearched(1);
        boolean bl2 = false;
        boolean bl3 = viewerSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected;
        int n = this.mTextPane.getSelectionStart();
        int n2 = this.mTextPane.getSelectionEnd();
        if (!bl3) {
            this.mTextPane.selectAll();
        } else if (viewerSearchOptions.isFirstSearch()) {
            viewerSearchOptions.setStartSelection(n);
            viewerSearchOptions.setEndSelection(n2);
        } else {
            this.mTextPane.select(viewerSearchOptions.getStartSelection(), viewerSearchOptions.getEndSelection());
        }
        String string2 = this.mTextPane.getSelectedText();
        this.mTextPane.select(n, n2);
        boolean bl4 = bl = viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.up;
        if (viewerSearchOptions.isFirstSearch()) {
            viewerSearchOptions.setOffset(bl ? n : n2);
            viewerSearchOptions.setStartOffset(bl ? n : n2);
        }
        int n3 = string.length();
        string = string.replace("\\", "\\\\");
        string = string.replace(".", "\\x2E");
        string = string.replace("*", "\\x2A");
        string = string.replace("$", "\\x24");
        string = string.replace("^", "\\x5E");
        string = string.replace("(", "\\x28");
        string = string.replace(")", "\\x29");
        String string3 = !viewerSearchOptions.getMatchCase() ? "(?i)(?u)" + string : string;
        Pattern pattern = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(string2);
        if (bl) {
            bl2 = this.reverseFind(matcher, viewerSearchOptions, n3);
        } else {
            int n4;
            int n5;
            boolean bl5 = viewerSearchOptions.getIsWrapped();
            int n6 = viewerSearchOptions.getOffset();
            if (n6 < string2.length() && matcher.find(n6)) {
                n5 = matcher.start();
                if (bl5 && n5 < viewerSearchOptions.getStartOffset() || !bl5 && n5 > viewerSearchOptions.getStartOffset()) {
                    bl2 = true;
                    n4 = n5;
                    if (bl3) {
                        n4 += viewerSearchOptions.getStartSelection();
                    }
                    this.mTextPane.select(n4, n4 + n3);
                    viewerSearchOptions.setOffset(n5 + n3);
                }
            }
            if (!bl2 && !bl5) {
                n6 = 0;
                viewerSearchOptions.setIsWrapped(true);
                if (matcher.find(n6) && (n5 = matcher.start()) < viewerSearchOptions.getStartOffset()) {
                    bl2 = true;
                    n4 = n5;
                    if (bl3) {
                        n4 += viewerSearchOptions.getStartSelection();
                    }
                    this.mTextPane.select(n4, n4 + n3);
                    viewerSearchOptions.setOffset(n5 + n3);
                }
            }
            if (!bl2) {
                viewerSearchOptions.setItemDone(true);
            }
        }
        if (!bl2 && viewerSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected) {
            this.mTextPane.select(viewerSearchOptions.getStartSelection(), viewerSearchOptions.getEndSelection());
        }
        ViewerFindDlg viewerFindDlg = this.getFindDlg();
        if (bl2 && viewerFindDlg != null && viewerFindDlg.isVisible()) {
            try {
                Rectangle rectangle = this.mTextPane.modelToView(this.mTextPane.getSelectionStart());
                rectangle = rectangle.union(this.mTextPane.modelToView(this.mTextPane.getSelectionEnd()));
                Point point = new Point(rectangle.x, rectangle.y);
                SwingUtilities.convertPointToScreen(point, this.mTextPane);
                rectangle = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
                viewerFindDlg.adjustPosition(rectangle);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        if (viewerSearchOptions.isFirstSearch()) {
            viewerSearchOptions.setFirstSearch(false);
        }
        return bl2;
    }

    @Override
    public boolean replaceNext(String string, String string2, SearchOptions searchOptions) {
        if (this.selectionEquals(string, searchOptions.getMatchCase())) {
            this.mTextPane.replaceRange(string2, this.mTextPane.getSelectionStart(), this.mTextPane.getSelectionEnd());
        }
        return this.findNext(string, searchOptions);
    }

    @Override
    public int replaceAll(String string, String string2, SearchOptions searchOptions) {
        ViewerSearchOptions viewerSearchOptions = (ViewerSearchOptions)searchOptions;
        CompoundEdit compoundEdit = new CompoundEdit();
        this.mTextPane.getUndoManager().addEdit(compoundEdit);
        int n = 0;
        boolean bl = this.replaceNext(string, string2, viewerSearchOptions);
        while (bl) {
            ++n;
            viewerSearchOptions.setFirstSearch(false);
            bl = this.replaceNext(string, string2, viewerSearchOptions);
        }
        if (n > 0) {
            compoundEdit.end();
        } else {
            compoundEdit.die();
        }
        return n;
    }

    @Override
    public String getDocumentName() {
        return this.getItemName();
    }

    @Override
    public void stopSearch() {
    }

    public void doSelectAll() {
        this.mTextPane.selectAll();
    }

    public boolean selectionEquals(String string, boolean bl) {
        String string2 = this.getSelectedText();
        boolean bl2 = bl ? string2 != null && string2.equals(string) : string2 != null && string2.equalsIgnoreCase(string);
        return bl2;
    }

    public String getSelectedText() {
        int n;
        int n2;
        String string = null;
        if (this.mTextPane.getSelectedText() != null) {
            n2 = this.mTextPane.getSelectionStart();
            n = this.mTextPane.getSelectionEnd();
        } else {
            n2 = n = this.mTextPane.getCaretPosition();
        }
        try {
            string = this.mTextPane.getText(n2, n - n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return string;
    }

    public void reattachToolbar() {
        this.mTextPane.setFormatToolBar(this.mFormatToolbar);
        this.mTextPane.setMainToolBar(this.mMainToolbar);
    }

    public void close() {
        this.setVisible(false);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TextEditorFrame textEditorFrame = new TextEditorFrame();
        SpssTextPane spssTextPane = textEditorFrame.getTextPane();
        spssTextPane.setDefaultFont(null);
        spssTextPane.addCaretListener(spssTextPane);
        textEditorFrame.setVisible(true);
    }

    private ViewerFindDlg getFindDlg() {
        if (this.mFindReplaceDlg == null) {
            this.mFindReplaceDlg = new ViewerFindDlg(this, this, false);
        }
        return this.mFindReplaceDlg;
    }

    private boolean reverseFind(Matcher matcher, ViewerSearchOptions viewerSearchOptions, int n) {
        int n2;
        boolean bl = false;
        int n3 = 0;
        int n4 = viewerSearchOptions.getOffset();
        if (n4 > -1) {
            n2 = viewerSearchOptions.getIsWrapped();
            while (matcher.find(n3)) {
                int n5 = matcher.start();
                n3 = n5 + n;
                if (n2 == 0 && n5 < n4 || n2 != 0 && n5 != n4 && n5 > viewerSearchOptions.getStartOffset()) {
                    bl = true;
                    viewerSearchOptions.setOffset(n5);
                } else if (n2 != 0 && n5 == n4) break;
                if (bl || n2 != 0 || n5 < viewerSearchOptions.getStartOffset()) continue;
                bl = true;
                n2 = 1;
                viewerSearchOptions.setIsWrapped(true);
                viewerSearchOptions.setOffset(n5);
            }
        }
        if (bl) {
            n2 = viewerSearchOptions.getOffset();
            this.mTextPane.select(n2, n2 + n);
            viewerSearchOptions.setOffset(n2);
        } else {
            viewerSearchOptions.setItemDone(true);
        }
        return bl;
    }

    class MyFlowLayout
    extends FlowLayout {
        boolean mIsHorizontal;

        public MyFlowLayout(int n, int n2, int n3, boolean bl) {
            super(n, n2, n3);
            this.mIsHorizontal = true;
            this.mIsHorizontal = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = new Dimension(0, 0);
                int n = container.getComponentCount();
                boolean bl = true;
                Dimension dimension2 = TextEditorFrame.this.getSize();
                Dimension dimension3 = new Dimension(0, 0);
                boolean bl2 = false;
                if (dimension2.width == 0) {
                    dimension2.setSize(500, 500);
                }
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension dimension4 = component.getPreferredSize();
                    if (this.mIsHorizontal) {
                        if (i > 0 && dimension3.width + dimension4.width >= dimension2.width - 1) {
                            dimension3.height += dimension4.height;
                            bl2 = true;
                        } else {
                            dimension3.height = Math.max(dimension3.height, dimension4.height);
                            bl2 = false;
                        }
                    }
                    if (bl || bl2) {
                        bl = false;
                    } else {
                        dimension.width += this.getHgap();
                    }
                    dimension3.width = bl2 ? dimension4.width : (dimension3.width += dimension4.width);
                    dimension.height = Math.max(dimension3.height, dimension.height);
                    dimension.width = Math.max(dimension3.width, dimension.width);
                }
                Insets insets = container.getInsets();
                dimension.width += insets.left + insets.right + this.getHgap() * 2;
                dimension.height += insets.top + insets.bottom + this.getVgap() * 2;
                return dimension;
            }
        }
    }
}

