/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.texteditor;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.output.export.OutputExporter;
import com.spss.java_client.core.documents.output.text.DefaultTextFontInfo;
import com.spss.java_client.core.documents.output.text.TextItem;
import com.spss.java_client.ui.dialogs.common.SPSSFontChooser;
import com.spss.java_client.ui.texteditor.bars.TextFormatBar;
import com.spss.java_client.ui.texteditor.bars.TextMainBar;
import com.spss.java_client.ui.texteditor.menus.TextContextMenu;
import com.spss.java_client.ui.texteditor.resources.TextEditorResBundle;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.FontUtil;
import com.spss.shared.export.ExportCopyParams;
import com.spss.shared.export.IExportOptions;
import com.spss.shared.export.ISpssExportable;
import com.spss.shared.export.table_export.rtf.SpssRtfExporter;
import com.spss.uitools.clipboard.AppClipboard;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.im.InputContext;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.BreakIterator;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.CompositeView;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.rtf.RTFEditorKit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import sun.awt.AppContext;

public class SpssTextPane
extends JEditorPane
implements FocusListener,
CaretListener {
    private static PasteTransferHandler sPasteTransferHandler = new PasteTransferHandler();
    private static StyledEditorKit sHTMLEditorKit = new WrappingHTMLEditorKit();
    private static ImageIcon sPageBreakIcon = null;
    private static ViewFactory sViewFactory = new HTMLFactoryEx();
    private Hashtable<String, Action> mActionHash = new Hashtable();
    private TextFormatBar mFormatToolbar;
    private TextMainBar mEditToolbar;
    private PageFormat mPageFormat;
    private UndoManager mUndoMgr = new EditorUndoManager();
    private CompoundEdit mCompoundEdit;
    private boolean mIsInsertRemove;
    boolean mHTMLDocument;
    private boolean mSoftWrap = true;
    private int mXSpan = -1;
    private boolean mAlignmentEnabled = true;

    public SpssTextPane() {
        Insets insets = (Insets)this.getMargin().clone();
        insets.left = 4;
        this.setMargin(insets);
        this.setEditorKit(sHTMLEditorKit);
        this.mHTMLDocument = true;
        this.setHighlighter(new TextHighlighter());
        Action[] actionArray = sHTMLEditorKit.getActions();
        this.setPreferredSize(new Dimension(468, this.getPreferredSize().height));
        for (Action action : actionArray) {
            String string = (String)action.getValue("Name");
            this.mActionHash.put(string, action);
        }
        if (!UIManager.getLookAndFeel().getDescription().contains("Aqua")) {
            this.setSelectionColor(Color.black);
        }
        this.addMouseListener(new MouseHandler());
        this.addFocusListener(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 37 || n == 39 || n == 38 || n == 40 || n == 8) {
                    SpssTextPane.this.endCompoundEdit();
                } else if (n == 36) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int n = SpssTextPane.this.getCaretPosition();
                            if (n < 1) {
                                SpssTextPane.this.select(1, 1);
                            }
                        }
                    });
                }
            }
        });
        this.addUndoableEditListener();
        this.addDocumentListener();
    }

    public static float[] getLogicalFontSizes() {
        float[] fArray = new float[]{10.0f, 12.0f, 14.0f, 18.0f, 24.0f, 36.0f};
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = FontUtil.physicalToLogicalSize((float)fArray[i]);
        }
        return fArray2;
    }

    public static String formatLogicalFontSize(float f) {
        return SpssTextPane.trimZeros(String.format(ComponentState.getSPSSLocale(), "%.1f", Float.valueOf(f)));
    }

    public void useHTMLDocument(boolean bl) {
        if (this.mHTMLDocument != bl) {
            this.mHTMLDocument = bl;
            if (bl) {
                this.setEditorKit(sHTMLEditorKit);
            } else {
                this.setEditorKit(new WrappingPlainEditorKit());
            }
        }
    }

    public boolean isHTMLDocument() {
        return this.mHTMLDocument;
    }

    public boolean getSoftWrap() {
        return this.mSoftWrap;
    }

    public void setSoftWrap(boolean bl) {
        this.mSoftWrap = bl;
    }

    public void addUndoableEditListener() {
        this.getDocument().addUndoableEditListener(this.mUndoMgr);
    }

    public void removeUndoableEditListener() {
        this.getDocument().removeUndoableEditListener(this.mUndoMgr);
        this.mUndoMgr.discardAllEdits();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public void replaceRange(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("end before start");
        }
        Document document = this.getDocument();
        if (document != null) {
            try {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).replace(n, n2 - n, string, this.getInputAttributes());
                } else {
                    document.remove(n, n2 - n);
                    document.insertString(n, string, null);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException(badLocationException.getMessage());
            }
        }
    }

    public void setParagraphAlignment(int n) {
        this.endCompoundEdit();
        if (this.mHTMLDocument) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setAlignment(simpleAttributeSet, n);
            this.setParagraphAttributes(simpleAttributeSet, false);
        }
    }

    public void setBold(ActionEvent actionEvent) {
        this.endCompoundEdit();
        if (this.mHTMLDocument) {
            Action action = this.mActionHash.get("font-bold");
            action.actionPerformed(actionEvent);
        } else {
            Map<TextAttribute, ?> map = this.getFont().getAttributes();
            HashMap hashMap = new HashMap(map);
            Object obj = map.get(TextAttribute.WEIGHT);
            boolean bl = obj != null && obj.equals(TextAttribute.WEIGHT_BOLD);
            hashMap.put(TextAttribute.WEIGHT, bl ? TextAttribute.WEIGHT_REGULAR : TextAttribute.WEIGHT_BOLD);
            this.setFont(new Font(hashMap));
        }
    }

    public void setItalic(ActionEvent actionEvent) {
        this.endCompoundEdit();
        if (this.mHTMLDocument) {
            Action action = this.mActionHash.get("font-italic");
            action.actionPerformed(actionEvent);
        } else {
            Map<TextAttribute, ?> map = this.getFont().getAttributes();
            HashMap hashMap = new HashMap(map);
            Object obj = map.get(TextAttribute.POSTURE);
            boolean bl = obj != null && obj.equals(TextAttribute.POSTURE_OBLIQUE);
            hashMap.put(TextAttribute.POSTURE, bl ? TextAttribute.POSTURE_REGULAR : TextAttribute.POSTURE_OBLIQUE);
            this.setFont(new Font(hashMap));
        }
    }

    public void setUnderline(ActionEvent actionEvent) {
        this.endCompoundEdit();
        if (this.mHTMLDocument) {
            Action action = this.mActionHash.get("font-underline");
            action.actionPerformed(actionEvent);
        } else {
            boolean bl;
            Map<TextAttribute, ?> map = this.getFont().getAttributes();
            HashMap hashMap = new HashMap(map);
            Object obj = map.get(TextAttribute.UNDERLINE);
            boolean bl2 = bl = obj != null && obj.equals(TextAttribute.UNDERLINE_ON);
            if (bl) {
                hashMap.remove(TextAttribute.UNDERLINE);
            } else {
                hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            this.setFont(new Font(hashMap));
        }
    }

    public void setParagraphAttributes(AttributeSet attributeSet, boolean bl) {
        if (this.mHTMLDocument) {
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            StyledDocument styledDocument = (StyledDocument)this.getDocument();
            styledDocument.setParagraphAttributes(n, n2 - n, attributeSet, bl);
        }
    }

    public void setCharacterAttributes(AttributeSet attributeSet, boolean bl) {
        if (this.mHTMLDocument) {
            int n;
            int n2 = this.getSelectionStart();
            if (n2 != (n = this.getSelectionEnd())) {
                StyledDocument styledDocument = (StyledDocument)this.getDocument();
                styledDocument.setCharacterAttributes(n2, n - n2, attributeSet, bl);
            } else {
                MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
                if (bl) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
            }
        } else {
            HashMap hashMap;
            Map<TextAttribute, ?> map;
            Object object = attributeSet.getAttribute(StyleConstants.FontFamily);
            if (object != null) {
                map = this.getFont().getAttributes();
                hashMap = new HashMap(map);
                hashMap.put(TextAttribute.FAMILY, object.toString());
                this.setFont(new Font(hashMap));
            }
            if ((object = attributeSet.getAttribute(StyleConstants.Foreground)) instanceof Color) {
                this.setForeground((Color)object);
            }
            if ((object = attributeSet.getAttribute(StyleConstants.Size)) instanceof Integer) {
                map = this.getFont().getAttributes();
                hashMap = new HashMap(map);
                hashMap.put(TextAttribute.SIZE, Float.valueOf(((Integer)object).floatValue()));
                this.setFont(new Font(hashMap));
            }
        }
    }

    public MutableAttributeSet getInputAttributes() {
        if (this.mHTMLDocument) {
            return sHTMLEditorKit.getInputAttributes();
        }
        return null;
    }

    public void doFontChange() {
        Object object;
        Object object2;
        int n = 12;
        int n2 = 0;
        Color color = Color.BLACK;
        boolean bl = false;
        boolean bl2 = false;
        String string = "SansSerif";
        if (this.mHTMLDocument) {
            int n3 = this.getSelectionStart();
            if (n3 < 0) {
                n3 = this.getCaretPosition();
            }
            if ((object2 = ((StyledDocument)this.getDocument()).getCharacterElement(n3)) != null) {
                object = object2.getAttributes();
                string = StyleConstants.getFontFamily((AttributeSet)object);
                n = StyleConstants.getFontSize((AttributeSet)object);
                n2 = StyleConstants.isBold((AttributeSet)object) && StyleConstants.isItalic((AttributeSet)object) ? 3 : (StyleConstants.isBold((AttributeSet)object) ? 1 : (StyleConstants.isItalic((AttributeSet)object) ? 2 : 0));
                color = StyleConstants.getForeground((AttributeSet)object);
                bl = StyleConstants.isUnderline((AttributeSet)object);
                bl2 = StyleConstants.isStrikeThrough((AttributeSet)object);
            }
        } else {
            Font font = this.getFont();
            string = font.getFamily();
            n2 = font.getStyle();
            n = font.getSize();
            object2 = font.getAttributes();
            color = this.getForeground();
            object = object2.get(TextAttribute.UNDERLINE);
            bl = object != null && object.equals(TextAttribute.UNDERLINE_ON);
            object = object2.get(TextAttribute.STRIKETHROUGH);
            bl2 = object != null && object.equals(TextAttribute.STRIKETHROUGH_ON);
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("IDS_COLOR_VALUE", color);
        linkedHashMap.put("IDS_UNDERLINE_VALUE", bl);
        linkedHashMap.put("IDS_STRIKE_VALUE", bl2);
        object2 = new SPSSFontChooser((JFrame)this.getTopLevelAncestor(), true, string, n2, n, true, this.mHTMLDocument, linkedHashMap, false);
        object = ((SPSSFontChooser)object2).getSelectedFont();
        if (object != null && ((SPSSFontChooser)object2).getReturnValue() == 0) {
            Color color2;
            Color color3 = color2 = this.mHTMLDocument ? FontUtil.convertIndexToColor((int)((SPSSFontChooser)object2).getSelectedColorIndex()) : color;
            if (this.mHTMLDocument) {
                boolean bl3 = ((SPSSFontChooser)object2).isUnderLine();
                boolean bl4 = ((SPSSFontChooser)object2).isStrikeThrough();
                this.updateFont((Font)object, color2, bl3, bl4);
            } else {
                HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
                hashMap.put(TextAttribute.FAMILY, ((Font)object).getFamily());
                hashMap.put(TextAttribute.SIZE, Float.valueOf(((Font)object).getSize2D()));
                hashMap.put(TextAttribute.POSTURE, ((Font)object).isItalic() ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
                hashMap.put(TextAttribute.WEIGHT, ((Font)object).isBold() ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
                this.setFont(new Font(hashMap));
                this.setForeground(color2);
            }
        }
    }

    public void doPageUp(ActionEvent actionEvent) {
        this.endCompoundEdit();
        Action action = this.mActionHash.get("page-up");
        action.actionPerformed(actionEvent);
    }

    public void doPageDown(ActionEvent actionEvent) {
        this.endCompoundEdit();
        Action action = this.mActionHash.get("page-down");
        action.actionPerformed(actionEvent);
    }

    public boolean isAlignmentEnabled() {
        return this.mAlignmentEnabled;
    }

    public void setAlignmentEnabled(boolean bl) {
        this.mAlignmentEnabled = bl;
    }

    public void doInsertPageBreak() {
        try {
            int n = this.getCaretPosition();
            int n2 = Utilities.getRowStart(this, n);
            this.setCaretPosition(n2);
            if (this.mHTMLDocument) {
                URL uRL = UIToolResUtil.getImageResourceFullPath((String)(TextEditorResBundle.getImageResourceFullPath() + "pageBreak.png"));
                StyleConstants.setIcon(this.getInputAttributes(), this.getPageBreakIcon());
                String string = "<img alignment=\"left\" src=\"" + uRL + "\">";
                ((HTMLEditorKit)sHTMLEditorKit).insertHTML((HTMLDocument)this.getDocument(), n2, string, 0, 0, HTML.Tag.IMG);
                n2 = this.getCaretPosition();
                ((HTMLEditorKit)sHTMLEditorKit).insertHTML((HTMLDocument)this.getDocument(), n2, "<br>", 0, 0, HTML.Tag.BR);
            } else {
                this.getDocument().insertString(n2, "\u000f\n", null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getLineAtCaret() {
        int n = this.getCaretPosition();
        int n2 = 1;
        try {
            Rectangle rectangle = this.modelToView(n);
            if (rectangle == null) {
                return -1;
            }
            int n3 = rectangle.y;
            while (rectangle != null && n3 > 0) {
                --n;
                if (n3 != rectangle.y) {
                    ++n2;
                    n3 = rectangle.y;
                }
                rectangle = n >= 0 ? this.modelToView(n) : null;
            }
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        return n2;
    }

    public int getCaretColumnPosition() {
        int n;
        int n2 = this.getCaretPosition();
        try {
            n = n2 - Utilities.getRowStart(this, n2) + 1;
        }
        catch (BadLocationException badLocationException) {
            n = -1;
        }
        return n;
    }

    public void insertIcon(Icon icon) {
        if (this.mHTMLDocument) {
            StyleConstants.setIcon(this.getInputAttributes(), icon);
            this.replaceSelection(" ", false);
        }
    }

    public void setFormatToolBar(TextFormatBar textFormatBar) {
        this.mFormatToolbar = textFormatBar;
    }

    public TextFormatBar getFormatToolBar() {
        return this.mFormatToolbar;
    }

    public void setMainToolBar(TextMainBar textMainBar) {
        this.mEditToolbar = textMainBar;
    }

    public TextMainBar getMainToolBar() {
        return this.mEditToolbar;
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (this.mFormatToolbar != null) {
            this.mFormatToolbar.refreshControls();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.endCompoundEdit();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.endCompoundEdit();
        Caret caret = this.getCaret();
        if (caret != null) {
            caret.setSelectionVisible(true);
        }
    }

    public void setPageFormat(PageFormat pageFormat) {
        double d;
        this.mPageFormat = pageFormat;
        if (this.mPageFormat != null && (d = this.mPageFormat.getImageableWidth()) > 1.0) {
            this.setPreferredSize(new Dimension((int)d, this.getPreferredSize().height));
            this.revalidate();
        }
    }

    public PageFormat getPageFormat() {
        if (this.mPageFormat == null) {
            this.mPageFormat = PrinterJob.getPrinterJob().defaultPage();
        }
        return this.mPageFormat;
    }

    public UndoManager getUndoManager() {
        return this.mUndoMgr;
    }

    public void doUndo() {
        this.endCompoundEdit();
        if (this.mUndoMgr.canUndo()) {
            this.mUndoMgr.undo();
            this.updateToolbar();
        }
    }

    public void doRedo() {
        this.endCompoundEdit();
        if (this.mUndoMgr.canRedo()) {
            this.mUndoMgr.redo();
            this.updateToolbar();
        }
    }

    public void updateToolbar() {
        if (this.mEditToolbar != null) {
            this.mEditToolbar.refreshControls();
        }
    }

    public void endCompoundEdit() {
        if (this.mCompoundEdit != null) {
            this.mCompoundEdit.end();
        }
        this.mCompoundEdit = null;
    }

    @Override
    public void copy() {
        this.endCompoundEdit();
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        if (n2 - n <= 0) {
            return;
        }
        StringWriter stringWriter = new StringWriter(n2 - n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2 - n);
        try {
            HTMLDocument hTMLDocument;
            StringReader stringReader;
            this.getEditorKit().write(stringWriter, this.getDocument(), n, n2 - n);
            String string = stringWriter.toString();
            string = string.replace("<p style=\"margin-top: 0\">", "");
            string = string.replace("</p>", "");
            AppClipboard appClipboard = AppClipboard.getAppClipboard();
            string = this.massageText(string);
            ISpssExportable.TextStyle textStyle = OutputExporter.getPrefTextStyle();
            Paper paper = PrinterJob.getPrinterJob().defaultPage().getPaper();
            IExportOptions.WideTablesOptions wideTablesOptions = PrefsMgr.getPrefsMgr().getUserWideTableOptions();
            ExportCopyParams exportCopyParams = new ExportCopyParams(paper, wideTablesOptions, textStyle);
            SpssRtfExporter spssRtfExporter = new SpssRtfExporter((OutputStream)byteArrayOutputStream, exportCopyParams);
            if (spssRtfExporter.htmlToRtf(string)) {
                appClipboard.addClipboardData(new DataFlavor("text/rtf; class=java.nio.ByteBuffer", "rtf data"), (Object)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()), false);
            }
            if (OSCheck.getOSType() != OSInfo.OSType.WIN) {
                stringReader = new StringReader(string);
                hTMLDocument = new HTMLDocument();
                this.getEditorKit().read(stringReader, (Document)hTMLDocument, 0);
                appClipboard.addClipboardData(new DataFlavor("text/html; class=java.lang.String", "html data"), (Object)string.replace("&#8199;", " "), false);
            }
            stringReader = new StringReader(stringWriter.toString());
            hTMLDocument = new HTMLDocument();
            this.getEditorKit().read(stringReader, (Document)hTMLDocument, 0);
            String string2 = this.getSelectedText(hTMLDocument, this.getSelectedText()).replace("\u00a0", " ");
            appClipboard.addClipboardData(AppClipboard.STRING_FLAVOR, (Object)string2, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private String massageText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.indexOf("<body>");
        if (n == -1) {
            return string;
        }
        int n2 = n > -1 ? stringBuffer.indexOf("<font", n) : -1;
        int n3 = stringBuffer.indexOf("</body>", n2);
        if ((n2 = n2 == -1 ? n + 6 : stringBuffer.indexOf(">", n2)) > -1) {
            int n4;
            if (n2 < n3) {
                n4 = stringBuffer.indexOf("\n", n2);
                while (n4 > -1 && n4 < n3) {
                    stringBuffer.replace(n4, n4 + 1, "<br>");
                    n4 = stringBuffer.indexOf("\n", n2);
                    n3 += 3;
                }
            }
            n4 = stringBuffer.indexOf(" ", n2);
            while (n4 > -1 && n4 < n3) {
                stringBuffer.replace(n4, n4 + 1, "\u00a0");
                n4 = stringBuffer.indexOf(" ", n2);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public void copyAll(AppClipboard appClipboard, boolean bl) {
        String string = this.getText();
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        this.setSelectionStart(0);
        this.setSelectionEnd(string.length());
        int n3 = this.getSelectionStart();
        int n4 = this.getSelectionEnd();
        if (n4 - n3 <= 0) {
            return;
        }
        StringWriter stringWriter = new StringWriter(n4 - n3);
        try {
            this.getEditorKit().write(stringWriter, this.getDocument(), n3, n4 - n3);
            StringReader stringReader = new StringReader(stringWriter.toString().replace("&#8199;", " "));
            HTMLDocument hTMLDocument = new HTMLDocument();
            this.getEditorKit().read(stringReader, (Document)hTMLDocument, 0);
            if (bl) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n4 - n3);
                new RTFEditorKit().write(byteArrayOutputStream, (Document)hTMLDocument, n3, n4 - n3);
                appClipboard.addClipboardData(new DataFlavor("text/rtf; class=java.nio.ByteBuffer", "rtf data"), (Object)ByteBuffer.wrap(byteArrayOutputStream.toByteArray()), false);
            }
            appClipboard.addClipboardData(new DataFlavor("text/html; class=java.lang.String", "html data"), (Object)stringWriter.toString(), false);
            String string2 = this.getSelectedText(hTMLDocument, this.getSelectedText()).replace("\u00a0", " ");
            appClipboard.addClipboardData(AppClipboard.STRING_FLAVOR, (Object)string2, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.select(n, n2);
    }

    public String getSelectedText(HTMLDocument hTMLDocument, String string) throws BadLocationException {
        String string2;
        if (this.isHTMLDocument()) {
            String string3 = string.replace("\n", "");
            Vector<Integer> vector = this.getNewLineOffsets(string);
            StringBuffer stringBuffer = new StringBuffer(string3);
            Element element = hTMLDocument.getDefaultRootElement();
            int n = element.getElementCount();
            for (int i = n - 1; i >= 0; --i) {
                Element object = element.getElement(i);
                int n2 = object.getElementCount();
                for (int j = n2 - 1; j >= 0; --j) {
                    Element element2 = object.getElement(j);
                    if (!(element2.getAttributes() instanceof AbstractDocument.BranchElement)) continue;
                    AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element2.getAttributes();
                    int n3 = branchElement.getChildCount();
                    for (int k = n3 - 1; k >= 0; --k) {
                        Element element3 = (Element)((Object)branchElement.getChildAt(k));
                        AttributeSet attributeSet = element3.getAttributes();
                        Object object2 = attributeSet.getAttribute(StyleConstants.NameAttribute);
                        if (!HTML.Tag.BR.equals(object2)) continue;
                        int n4 = Math.min(element3.getStartOffset(), stringBuffer.length());
                        stringBuffer.insert(n4, "\n");
                        this.incrementNewlineOffsets(vector, n4);
                    }
                }
            }
            for (Integer n5 : vector) {
                stringBuffer.insert((int)n5, "\n");
            }
            string2 = stringBuffer.toString();
        } else {
            string2 = string;
        }
        if (string2.startsWith("\n")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith("\n")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        string2 = string2.replace("\u00a0", " ");
        return string2;
    }

    @Override
    public void cut() {
        this.endCompoundEdit();
        super.cut();
    }

    @Override
    public void paste() {
        this.endCompoundEdit();
        if (this.isEditable() && this.isEnabled()) {
            this.invokeAction(new TextTransferAction("paste"));
        }
    }

    public void setDefaultFont(DefaultTextFontInfo defaultTextFontInfo) {
        if (defaultTextFontInfo == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setFontSize(simpleAttributeSet, (int)FontUtil.logicalToPhysicalSize((float)10.0f));
            StyledDocument styledDocument = (StyledDocument)this.getDocument();
            styledDocument.setParagraphAttributes(0, this.getText().length(), simpleAttributeSet, false);
        } else {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setFontFamily(simpleAttributeSet, defaultTextFontInfo.getFontName());
            StyleConstants.setItalic(simpleAttributeSet, defaultTextFontInfo.isItalic());
            StyleConstants.setBold(simpleAttributeSet, defaultTextFontInfo.isBold());
            StyleConstants.setUnderline(simpleAttributeSet, defaultTextFontInfo.isUnderline());
            StyleConstants.setForeground(simpleAttributeSet, TextItem.getColor((int)defaultTextFontInfo.getFontColor()));
            StyleConstants.setFontSize(simpleAttributeSet, defaultTextFontInfo.getFontSize());
            StyledDocument styledDocument = (StyledDocument)this.getDocument();
            styledDocument.setParagraphAttributes(0, this.getText().length(), simpleAttributeSet, false);
        }
    }

    private static String trimZeros(String string) {
        int n;
        for (n = string.length(); n > 0 && string.charAt(n - 1) == '0'; --n) {
        }
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(ComponentState.getSPSSLocale());
        if (n > 0 && string.charAt(n - 1) == decimalFormatSymbols.getDecimalSeparator()) {
            --n;
        }
        return string.substring(0, n);
    }

    private void addDocumentListener() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SpssTextPane.this.mIsInsertRemove = true;
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SpssTextPane.this.mIsInsertRemove = true;
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SpssTextPane.this.mIsInsertRemove = false;
            }
        });
    }

    public void updateFont(Font font, Color color, boolean bl, boolean bl2) {
        String string = this.getSelectedText();
        if (string != null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setFontSize(simpleAttributeSet, font.getSize());
            StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
            int n = font.getStyle();
            if (n == 1) {
                StyleConstants.setBold(simpleAttributeSet, true);
                StyleConstants.setItalic(simpleAttributeSet, false);
            } else if (n == 2) {
                StyleConstants.setBold(simpleAttributeSet, false);
                StyleConstants.setItalic(simpleAttributeSet, true);
            } else if (n == 0) {
                StyleConstants.setBold(simpleAttributeSet, false);
                StyleConstants.setItalic(simpleAttributeSet, false);
            } else {
                StyleConstants.setBold(simpleAttributeSet, true);
                StyleConstants.setItalic(simpleAttributeSet, true);
            }
            StyleConstants.setForeground(simpleAttributeSet, color);
            StyleConstants.setStrikeThrough(simpleAttributeSet, bl2);
            StyleConstants.setUnderline(simpleAttributeSet, bl);
            this.setCharacterAttributes(simpleAttributeSet, false);
        }
    }

    private void replaceSelection(String string, boolean bl) {
        if (bl && !this.isEditable()) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
            return;
        }
        Document document = this.getDocument();
        if (document != null) {
            try {
                Caret caret = this.getCaret();
                int n = Math.min(caret.getDot(), caret.getMark());
                int n2 = Math.max(caret.getDot(), caret.getMark());
                AttributeSet attributeSet = this.getInputAttributes().copyAttributes();
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).replace(n, n2 - n, string, attributeSet);
                } else {
                    if (n != n2) {
                        document.remove(n, n2 - n);
                    }
                    if (string != null && string.length() > 0) {
                        document.insertString(n, string, attributeSet);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
        }
    }

    private void invokeAction(Action action) {
        action.actionPerformed(new ActionEvent(this, 1001, (String)action.getValue("Name"), EventQueue.getMostRecentEventTime(), this.getCurrentEventModifiers()));
    }

    private int getCurrentEventModifiers() {
        int n = 0;
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof InputEvent) {
            n = ((InputEvent)aWTEvent).getModifiers();
        } else if (aWTEvent instanceof ActionEvent) {
            n = ((ActionEvent)aWTEvent).getModifiers();
        }
        return n;
    }

    protected int getXSpan() {
        return this.mXSpan;
    }

    protected void setXSpan(int n) {
        this.mXSpan = n;
    }

    private Vector<Integer> getNewLineOffsets(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = string.indexOf(10, 0);
        while (n > -1) {
            vector.add(n);
            n = string.indexOf(10, n + 1);
        }
        return vector;
    }

    private void incrementNewlineOffsets(Vector<Integer> vector, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = vector.get(i);
            if (n2 < n) continue;
            vector.set(i, n2 + 1);
        }
    }

    private ImageIcon getPageBreakIcon() {
        if (sPageBreakIcon == null) {
            URL uRL = UIToolResUtil.getImageResourceFullPath((String)(TextEditorResBundle.getImageResourceFullPath() + "pageBreak.png"));
            sPageBreakIcon = new ImageIcon(uRL);
        }
        return sPageBreakIcon;
    }

    class TextHighlighter
    extends DefaultHighlighter {
        TextHighlighter() {
        }

        @Override
        public void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            Object object;
            int n3;
            int n4 = jTextComponent.getSelectionStart();
            if (n4 != (n3 = jTextComponent.getSelectionEnd()) && (n < n4 && n2 > n4 || n >= n4 && n < n3)) {
                if (SpssTextPane.this.getDocument() instanceof StyledDocument) {
                    Element element = ((StyledDocument)SpssTextPane.this.getDocument()).getCharacterElement(n);
                    MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
                    Color color = StyleConstants.getForeground(mutableAttributeSet);
                    color = color == null ? Color.black : color;
                    int n5 = color.getRed() ^ 0xFF;
                    int n6 = color.getGreen() ^ 0xFF;
                    int n7 = color.getBlue() ^ 0xFF;
                    object = new Color(n5, n6, n7);
                } else {
                    object = Color.WHITE;
                }
                SpssTextPane.this.setSelectedTextColor((Color)object);
            }
            if (!UIManager.getLookAndFeel().getDescription().contains("Aqua")) {
                object = UIManager.getLookAndFeel().getName();
                if (((String)object).contains("Cobalt")) {
                    SpssTextPane.this.setSelectionColor(Color.lightGray);
                } else {
                    SpssTextPane.this.setSelectionColor(Color.black);
                }
            }
            super.paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, view);
        }
    }

    class WrappingPlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        WrappingPlainEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return this;
        }

        @Override
        public View create(Element element) {
            Document document = element.getDocument();
            Object object = document.getProperty("i18n");
            if (object != null && object.equals(Boolean.TRUE)) {
                return this.createI18N(element);
            }
            return new WrappedPlainViewEx(element, true);
        }

        View createI18N(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new PlainParagraph(element);
                }
                if (string.equals("paragraph")) {
                    return new BoxView(element, 1);
                }
            }
            return null;
        }

        class PlainParagraph
        extends ParagraphView {
            PlainParagraph(Element element) {
                super(element);
                this.layoutPool = new LogicalView(element);
                this.layoutPool.setParent(this);
            }

            @Override
            protected void setPropertiesFromAttributes() {
                Container container = this.getContainer();
                if (container != null && !container.getComponentOrientation().isLeftToRight()) {
                    this.setJustification(2);
                } else {
                    this.setJustification(0);
                }
            }

            @Override
            public int getFlowSpan(int n) {
                return super.getFlowSpan(n);
            }

            @Override
            protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
                JTextArea jTextArea;
                SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n, sizeRequirements);
                Container container = this.getContainer();
                if (container instanceof JTextArea && !(jTextArea = (JTextArea)container).getLineWrap()) {
                    sizeRequirements2.minimum = sizeRequirements2.preferred;
                }
                return sizeRequirements2;
            }

            class LogicalView
            extends CompositeView {
                LogicalView(Element element) {
                    super(element);
                }

                @Override
                protected int getViewIndexAtPosition(int n) {
                    Element element = this.getElement();
                    if (element.getElementCount() > 0) {
                        return element.getElementIndex(n);
                    }
                    return 0;
                }

                @Override
                protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
                    return false;
                }

                @Override
                protected void loadChildren(ViewFactory viewFactory) {
                    Element element = this.getElement();
                    if (element.getElementCount() > 0) {
                        super.loadChildren(viewFactory);
                    } else {
                        GlyphView glyphView = new GlyphView(element);
                        this.append(glyphView);
                    }
                }

                @Override
                public float getPreferredSpan(int n) {
                    if (this.getViewCount() != 1) {
                        throw new Error("One child view is assumed.");
                    }
                    View view = this.getView(0);
                    return view.getPreferredSpan(n);
                }

                @Override
                protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
                    view.setParent(this);
                    super.forwardUpdateToView(view, documentEvent, shape, viewFactory);
                }

                @Override
                public void paint(Graphics graphics, Shape shape) {
                }

                @Override
                protected boolean isBefore(int n, int n2, Rectangle rectangle) {
                    return false;
                }

                @Override
                protected boolean isAfter(int n, int n2, Rectangle rectangle) {
                    return false;
                }

                @Override
                protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
                    return null;
                }

                @Override
                protected void childAllocation(int n, Rectangle rectangle) {
                }
            }
        }
    }

    static class ParagraphViewEx
    extends javax.swing.text.html.ParagraphView {
        public ParagraphViewEx(Element element) {
            super(element);
        }

        @Override
        protected void setLineSpacing(float f) {
            super.setLineSpacing(-0.1f);
        }
    }

    public static class HTMLFactoryEx
    extends HTMLEditorKit.HTMLFactory {
        @Override
        public View create(Element element) {
            View view = null;
            Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (object instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)object;
                if (tag == HTML.Tag.IMPLIED) {
                    String string = (String)element.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                    if (string == null || !string.equals("pre")) {
                        view = new ParagraphViewEx(element);
                    }
                } else if (tag == HTML.Tag.P || tag == HTML.Tag.H1 || tag == HTML.Tag.H2 || tag == HTML.Tag.H3 || tag == HTML.Tag.H4 || tag == HTML.Tag.H5 || tag == HTML.Tag.H6 || tag == HTML.Tag.DT) {
                    view = new ParagraphViewEx(element);
                }
            }
            if (view == null) {
                view = super.create(element);
            }
            return view;
        }
    }

    public static class WrappingHTMLEditorKit
    extends HTMLEditorKit {
        private SimpleAttributeSet contentAttributeSet = new SimpleAttributeSet();

        @Override
        public Document createDefaultDocument() {
            StyleSheet styleSheet = this.getStyleSheet();
            StyleSheet styleSheet2 = new StyleSheet();
            styleSheet2.addStyleSheet(styleSheet);
            HTMLDocument hTMLDocument = new HTMLDocument(styleSheet2){

                @Override
                public HTMLEditorKit.ParserCallback getReader(int n) {
                    WrappingHTMLEditorKit.this.contentAttributeSet.removeAttribute(StyleConstants.NameAttribute);
                    WrappingHTMLEditorKit.this.contentAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                    Object object = this.getProperty("stream");
                    if (object instanceof URL) {
                        this.setBase((URL)object);
                    }
                    return new HTMLDocument.HTMLReader(n){

                        @Override
                        protected void addContent(char[] cArray, int n, int n2, boolean bl) {
                            boolean bl2 = false;
                            BreakIterator breakIterator = BreakIterator.getWordInstance(ComponentState.getOLangLocale());
                            String string = new String(cArray);
                            breakIterator.setText(string);
                            int n3 = breakIterator.first();
                            int n4 = breakIterator.next();
                            while (n4 != -1) {
                                if (n4 - n3 > 50) {
                                    bl2 = true;
                                    break;
                                }
                                n3 = n4;
                                n4 = breakIterator.next();
                            }
                            breakIterator = bl2 ? BreakIterator.getCharacterInstance(ComponentState.getOLangLocale()) : BreakIterator.getWordInstance(ComponentState.getOLangLocale());
                            string = new String(cArray);
                            breakIterator.setText(string);
                            n3 = breakIterator.first();
                            n4 = breakIterator.next();
                            while (n4 != -1) {
                                String string2 = string.substring(n3, n4);
                                char[] cArray2 = new char[string2.length()];
                                string2.getChars(0, string2.length(), cArray2, 0);
                                super.addContent(cArray2, n, cArray2.length, bl);
                                n3 = n4;
                                n4 = breakIterator.next();
                            }
                        }
                    };
                }
            };
            hTMLDocument.setParser(this.getParser());
            hTMLDocument.setAsynchronousLoadPriority(4);
            hTMLDocument.setTokenThreshold(100);
            return hTMLDocument;
        }

        short createSpecsForInsertAfterNewline(Element element, Element element2, AttributeSet attributeSet, Vector<DefaultStyledDocument.ElementSpec> vector, int n, int n2) {
            if (element.getParentElement() == element2.getParentElement()) {
                DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 2);
                vector.addElement(elementSpec);
                elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 1);
                vector.addElement(elementSpec);
                if (element2.getEndOffset() != n2) {
                    return 7;
                }
                Element element3 = element2.getParentElement();
                if (element3.getElementIndex(n) + 1 < element3.getElementCount()) {
                    return 5;
                }
            } else {
                Element element4;
                Vector<Element> vector2 = new Vector<Element>();
                Vector<Element> vector3 = new Vector<Element>();
                for (element4 = element2; element4 != null; element4 = element4.getParentElement()) {
                    vector2.addElement(element4);
                }
                int n3 = -1;
                for (element4 = element; element4 != null && (n3 = vector2.indexOf(element4)) == -1; element4 = element4.getParentElement()) {
                    vector3.addElement(element4);
                }
                if (element4 != null) {
                    for (int i = 0; i < n3; ++i) {
                        vector.addElement(new DefaultStyledDocument.ElementSpec(null, 2));
                    }
                    for (int i = vector3.size() - 1; i >= 0; --i) {
                        DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(((Element)vector3.elementAt(i)).getAttributes(), 1);
                        if (i > 0) {
                            elementSpec.setDirection((short)5);
                        }
                        vector.addElement(elementSpec);
                    }
                    if (vector3.size() > 0) {
                        return 5;
                    }
                    return 7;
                }
            }
            return 6;
        }

        @Override
        public ViewFactory getViewFactory() {
            return sViewFactory;
        }
    }

    class EditorUndoManager
    extends UndoManager {
        EditorUndoManager() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (SpssTextPane.this.mIsInsertRemove && SpssTextPane.this.mCompoundEdit == null) {
                SpssTextPane.this.mCompoundEdit = new CompoundEdit();
                this.addEdit(SpssTextPane.this.mCompoundEdit);
            }
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            this.addEdit(undoableEdit);
            SpssTextPane.this.updateToolbar();
        }

        @Override
        public synchronized boolean canUndo() {
            return SpssTextPane.this.mCompoundEdit != null || super.canUndo();
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TextContextMenu textContextMenu = new TextContextMenu(SpssTextPane.this);
                textContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TextContextMenu textContextMenu = new TextContextMenu(SpssTextPane.this);
                textContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    static class TextTransferAction
    extends AbstractAction
    implements UIResource {
        private static Object SandboxClipboardKey = new Object();

        TextTransferAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                PasteTransferHandler pasteTransferHandler = sPasteTransferHandler;
                Clipboard clipboard = this.getClipboard(jComponent);
                String string = (String)this.getValue("Name");
                Transferable transferable = null;
                try {
                    if (clipboard != null && pasteTransferHandler != null && string != null) {
                        if ("cut".equals(string)) {
                            pasteTransferHandler.exportToClipboard(jComponent, clipboard, 2);
                        } else if ("copy".equals(string)) {
                            pasteTransferHandler.exportToClipboard(jComponent, clipboard, 1);
                        } else if ("paste".equals(string)) {
                            transferable = clipboard.getContents(null);
                        }
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jComponent);
                    return;
                }
                if (transferable != null) {
                    pasteTransferHandler.importData(jComponent, transferable);
                }
            }
        }

        private Clipboard getClipboard(JComponent jComponent) {
            if (AppClipboard.canAccessSystemClipboard()) {
                return jComponent.getToolkit().getSystemClipboard();
            }
            Clipboard clipboard = (Clipboard)AppContext.getAppContext().get(SandboxClipboardKey);
            if (clipboard == null) {
                clipboard = new Clipboard("Sandboxed Component Clipboard");
                AppContext.getAppContext().put(SandboxClipboardKey, clipboard);
            }
            return clipboard;
        }
    }

    static class PasteTransferHandler
    extends TransferHandler
    implements UIResource {
        PasteTransferHandler() {
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            SpssTextPane spssTextPane = (SpssTextPane)jComponent;
            boolean bl = false;
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            if (dataFlavorArray == null) {
                return bl;
            }
            try {
                if (this.isFromRTF(dataFlavorArray, transferable) && this.buildFromRtf(transferable, spssTextPane, dataFlavorArray)) {
                    bl = true;
                } else {
                    DataFlavor dataFlavor = this.getImportFlavor(dataFlavorArray, spssTextPane);
                    if (dataFlavor != null) {
                        Object object;
                        boolean bl2 = false;
                        if (jComponent instanceof JEditorPane && !((JEditorPane)(object = (JEditorPane)jComponent)).getContentType().startsWith("text/plain") && dataFlavor.getMimeType().startsWith(((JEditorPane)object).getContentType())) {
                            bl2 = true;
                        }
                        if ((object = spssTextPane.getInputContext()) != null) {
                            ((InputContext)object).endComposition();
                        }
                        Reader reader = dataFlavor.getReaderForText(transferable);
                        this.handleReaderImport(reader, spssTextPane, bl2);
                        bl = true;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return bl;
        }

        private boolean buildFromRtf(Transferable transferable, SpssTextPane spssTextPane, DataFlavor[] dataFlavorArray) throws UnsupportedFlavorException, IOException, BadLocationException {
            DataFlavor dataFlavor = this.getSpecifiedFlavor(dataFlavorArray, "text/rtf");
            Document document = spssTextPane.getDocument();
            if (!(document instanceof StyledDocument)) {
                return false;
            }
            StyledDocument styledDocument = (StyledDocument)document;
            DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
            Reader reader = dataFlavor.getReaderForText(transferable);
            new RTFEditorKit().read(reader, (Document)defaultStyledDocument, 0);
            if (defaultStyledDocument.getLength() == 0) {
                return false;
            }
            int n = spssTextPane.getSelectionStart();
            Element element = defaultStyledDocument.getDefaultRootElement();
            int n2 = element.getElementCount();
            for (int i = n2 - 1; i >= 0; --i) {
                Element element2 = element.getElement(i);
                int n3 = element2.getElementCount();
                for (int j = n3 - 1; j >= 0; --j) {
                    int n4;
                    Element element3 = element2.getElement(j);
                    int n5 = element3.getStartOffset();
                    int n6 = element3.getEndOffset();
                    AttributeSet attributeSet = element3.getAttributes();
                    String string = defaultStyledDocument.getText(n5, n6 - n5);
                    if (string.equals("\n") && i == n2 - 1) continue;
                    if (string.endsWith("\n") && i == 0 && (n4 = string.lastIndexOf("\n")) > 0) {
                        string = string.substring(0, n4);
                    }
                    styledDocument.insertString(n, string, null);
                    styledDocument.setCharacterAttributes(n, string.length(), attributeSet, false);
                }
            }
            return true;
        }

        protected boolean isFromRTF(DataFlavor[] dataFlavorArray, Transferable transferable) {
            boolean bl = false;
            if (this.getSpecifiedFlavor(dataFlavorArray, "text/rtf") != null) {
                DataFlavor dataFlavor = this.getSpecifiedFlavor(dataFlavorArray, "text/html");
                bl = dataFlavor == null || this.isMSWord(dataFlavor, transferable);
            }
            return bl;
        }

        protected boolean isMSWord(DataFlavor dataFlavor, Transferable transferable) {
            boolean bl = false;
            if (dataFlavor != null) {
                try {
                    Reader reader = dataFlavor.getReaderForText(transferable);
                    char[] cArray = new char[500];
                    reader.read(cArray);
                    String string = String.valueOf(cArray);
                    if (string.indexOf("urn:schemas-microsoft-com:office:word") != -1) {
                        bl = true;
                    }
                    reader.close();
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return bl;
        }

        protected void handleReaderImport(Reader reader, JTextComponent jTextComponent, boolean bl) throws BadLocationException, IOException {
            if (bl) {
                int n = jTextComponent.getSelectionStart();
                int n2 = jTextComponent.getSelectionEnd();
                int n3 = n2 - n;
                EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
                Document document = jTextComponent.getDocument();
                if (n3 > 0) {
                    document.remove(n, n3);
                }
                editorKit.read(reader, document, n);
            } else {
                int n;
                char[] cArray = new char[1024];
                boolean bl2 = false;
                StringBuffer stringBuffer = null;
                while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n);
                    }
                    int n4 = 0;
                    block5: for (int i = 0; i < n; ++i) {
                        switch (cArray[i]) {
                            case '\r': {
                                if (bl2) {
                                    if (i == 0) {
                                        stringBuffer.append('\n');
                                        continue block5;
                                    }
                                    cArray[i - 1] = 10;
                                    continue block5;
                                }
                                bl2 = true;
                                continue block5;
                            }
                            case '\n': {
                                if (!bl2) continue block5;
                                if (i > n4 + 1) {
                                    stringBuffer.append(cArray, n4, i - n4 - 1);
                                }
                                bl2 = false;
                                n4 = i;
                                continue block5;
                            }
                            default: {
                                if (!bl2) continue block5;
                                if (i == 0) {
                                    stringBuffer.append('\n');
                                } else {
                                    cArray[i - 1] = 10;
                                }
                                bl2 = false;
                            }
                        }
                    }
                    if (n4 >= n) continue;
                    if (bl2) {
                        if (n4 >= n - 1) continue;
                        stringBuffer.append(cArray, n4, n - n4 - 1);
                        continue;
                    }
                    stringBuffer.append(cArray, n4, n - n4);
                }
                if (bl2) {
                    stringBuffer.append('\n');
                }
                if (stringBuffer.toString() != null && stringBuffer.toString().indexOf(System.getProperty("file.separator")) != -1) {
                    String string = stringBuffer.toString();
                    int n5 = string.indexOf(58);
                    if (n5 != -1 && n5 > 0 && Character.isLetter(string.charAt(n5 - 1)) && (n5 - 1 == 0 || Character.isWhitespace(string.charAt(n5 - 2)) || ComponentState.isNonBreakingSpace((char)string.charAt(n5 - 2)))) {
                        --n5;
                    } else {
                        n5 = string.indexOf(File.pathSeparatorChar);
                        if (!(n5 != -1 && n5 + 1 < string.length() && string.charAt(n5 + 1) == File.pathSeparatorChar && (n5 == 0 || Character.isWhitespace(string.charAt(n5 - 1)) || ComponentState.isNonBreakingSpace((char)string.charAt(n5 - 1))))) {
                            n5 = -1;
                        }
                    }
                    if (n5 != -1) {
                        String string2 = string.substring(n5);
                        String string3 = ComponentState.preparePathForBidiDisplay((String)string2);
                        String string4 = string.substring(0, n5) + string3;
                        jTextComponent.replaceSelection(string4);
                    } else {
                        jTextComponent.replaceSelection(stringBuffer.toString());
                    }
                } else {
                    jTextComponent.replaceSelection(stringBuffer != null ? stringBuffer.toString() : "");
                }
            }
        }

        protected DataFlavor getSpecifiedFlavor(DataFlavor[] dataFlavorArray, String string) {
            for (DataFlavor dataFlavor : dataFlavorArray) {
                String string2 = dataFlavor.getMimeType();
                if (!string2.startsWith(string)) continue;
                return dataFlavor;
            }
            return null;
        }

        protected DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray, JTextComponent jTextComponent) {
            DataFlavor dataFlavor = null;
            DataFlavor dataFlavor2 = null;
            DataFlavor dataFlavor3 = null;
            if (jTextComponent instanceof JEditorPane) {
                for (DataFlavor dataFlavor4 : dataFlavorArray) {
                    String string = dataFlavor4.getMimeType();
                    if (string.startsWith(((JEditorPane)jTextComponent).getEditorKit().getContentType())) {
                        return dataFlavor4;
                    }
                    if (dataFlavor == null && string.startsWith("text/plain")) {
                        dataFlavor = dataFlavor4;
                        continue;
                    }
                    if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavor4.getRepresentationClass() == String.class) {
                        dataFlavor2 = dataFlavor4;
                        continue;
                    }
                    if (dataFlavor3 == null && dataFlavor4.equals(DataFlavor.stringFlavor)) {
                        dataFlavor3 = dataFlavor4;
                        continue;
                    }
                    if (!dataFlavor4.getHumanPresentableName().equals("Rich Text")) continue;
                    return dataFlavor4;
                }
                if (dataFlavor != null) {
                    return dataFlavor;
                }
                if (dataFlavor2 != null) {
                    return dataFlavor2;
                }
                if (dataFlavor3 != null) {
                    return dataFlavor3;
                }
                return null;
            }
            for (DataFlavor dataFlavor5 : dataFlavorArray) {
                String string = dataFlavor5.getMimeType();
                if (string.startsWith("text/plain")) {
                    return dataFlavor5;
                }
                if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavor5.getRepresentationClass() == String.class) {
                    dataFlavor2 = dataFlavor5;
                    continue;
                }
                if (dataFlavor3 != null || !dataFlavor5.equals(DataFlavor.stringFlavor)) continue;
                dataFlavor3 = dataFlavor5;
            }
            if (dataFlavor2 != null) {
                return dataFlavor2;
            }
            if (dataFlavor3 != null) {
                return dataFlavor3;
            }
            return null;
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            return jTextComponent.isEditable() && jTextComponent.isEnabled() && this.getFlavor(dataFlavorArray) != null;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 0;
        }

        private DataFlavor getFlavor(DataFlavor[] dataFlavorArray) {
            if (dataFlavorArray != null) {
                for (DataFlavor dataFlavor : dataFlavorArray) {
                    if (!dataFlavor.equals(DataFlavor.stringFlavor)) continue;
                    return dataFlavor;
                }
            }
            return null;
        }
    }

    class WrappedPlainViewEx
    extends WrappedPlainView {
        public WrappedPlainViewEx(Element element, boolean bl) {
            super(element, bl);
        }

        @Override
        protected int calculateBreakPosition(int n, int n2) {
            return super.calculateBreakPosition(n, n2);
        }

        @Override
        public float getPreferredSpan(int n) {
            boolean bl;
            Container container = this.getContainer();
            boolean bl2 = bl = !(container instanceof SpssTextPane) || ((SpssTextPane)container).getSoftWrap();
            if (0 == n && !bl) {
                int n2 = ((SpssTextPane)container).getXSpan();
                if (n2 == -1) {
                    n2 = this.calculateXSpan();
                    ((SpssTextPane)container).setXSpan(n2);
                }
                return n2;
            }
            return super.getPreferredSpan(n);
        }

        private int calculateXSpan() {
            int n = 0;
            try {
                Container container = this.getContainer();
                Font font = container.getFont();
                FontMetrics fontMetrics = container.getFontMetrics(font);
                Document document = ((SpssTextPane)container).getDocument();
                String string = document.getText(0, document.getLength());
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    int n2 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                    n = Math.max(n2, n);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            return n;
        }

        @Override
        protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            String string;
            Document document = this.getDocument();
            if (document instanceof PlainDocument && document.getLength() > 10000 && (string = SpssTextPane.this.getText(n3, n4 - n3)).contains("\u000f\n")) {
                ImageIcon imageIcon = SpssTextPane.this.getPageBreakIcon();
                graphics.drawImage(imageIcon.getImage(), n, n2, null);
            }
            return super.drawUnselectedText(graphics, n, n2, n3, n4);
        }
    }
}

