/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.resources;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.resources.ComponentResBundle;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.laf.LookAndFeelManager;
import com.spss.java_client.ui.resources.ClientResBundle;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.KeyStroke;

public class ResUtil {
    public static final String LABEL_SUFFIX = "_LABEL";
    public static final String KEY_SUFFIX = "_KEY";
    public static final String SHORTCUT_SUFFIX = "_SHORTCUT";
    public static final String TOOLTIP_SUFFIX = "_TOOLTIP";
    public static final String IMAGE_SUFFIX = "_IMAGE";
    public static final String LARGE_IMAGE_SUFFIX = "_LARGEIMAGE";
    public static final String ANLAF_LARGE_IMAGE_SUFFIX = "_ANLAFLARGEIMAGE";
    public static final String MENU_SUFFIX = "_MENU";
    public static final String SPEECH_SUFFIX = "_SPEECH";
    private static ResourceBundle sUiLabels = null;
    private static ResourceBundle sComponentLabels = null;
    private static ResourceBundle sCommonDlgBundle = null;

    public static void setLocale(Locale locale) {
        sUiLabels = ResUtil.getBundle(ClientResBundle.getDefaultResourceBundleName(), locale);
        sComponentLabels = ResUtil.getBundle(ComponentResBundle.getDefaultResourceBundleName(), locale);
        sCommonDlgBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), locale);
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static ResourceBundle getBundle(String string, Locale locale) {
        String string2 = string;
        if (string == null || string.equals("")) {
            string2 = ClientResBundle.getDefaultResourceBundleName();
        }
        ResourceBundle resourceBundle = null;
        Locale locale2 = locale == null ? Locale.getDefault() : locale;
        try {
            resourceBundle = ResourceBundle.getBundle(string2, locale2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return resourceBundle;
    }

    public static String getString(String string) {
        String string2;
        block2: {
            string2 = null;
            try {
                ResourceBundle resourceBundle = ResUtil.getLabels();
                string2 = resourceBundle.getString(string);
            }
            catch (Exception exception) {
                if (string.endsWith(IMAGE_SUFFIX)) break block2;
                ComponentState.trace1((String)exception.getMessage(), (int)15);
            }
        }
        return string2;
    }

    public static String getComponentString(String string) {
        String string2 = null;
        try {
            if (sComponentLabels == null) {
                sComponentLabels = ResUtil.getBundle(ComponentResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
            }
            if (sComponentLabels != null) {
                string2 = sComponentLabels.getString(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static String getCommonDlgString(String string) {
        String string2 = null;
        try {
            if (sCommonDlgBundle == null) {
                sCommonDlgBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
            }
            if (sCommonDlgBundle != null) {
                string2 = sCommonDlgBundle.getString(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static String[] getCommonStringArray(String string) {
        String[] stringArray = null;
        try {
            if (sCommonDlgBundle == null) {
                sCommonDlgBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
            }
            if (sCommonDlgBundle != null) {
                stringArray = sCommonDlgBundle.getStringArray(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray;
    }

    public static String getString(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static Object getObject(String string, ResourceBundle resourceBundle) {
        Object object;
        block2: {
            object = null;
            try {
                object = resourceBundle.getObject(string);
            }
            catch (Exception exception) {
                if (string.endsWith(SHORTCUT_SUFFIX)) break block2;
                ComponentState.trace1((String)exception.getMessage(), (int)15);
            }
        }
        return object;
    }

    protected static ResourceBundle getLabels() {
        if (sUiLabels == null) {
            sUiLabels = ResUtil.getBundle(null, null);
        }
        return sUiLabels;
    }

    public static String getSpeechLabel(String string) {
        return ResUtil.getString(string + SPEECH_SUFFIX);
    }

    public static Integer getAccessKey(String string) {
        return (Integer)ResUtil.getObject(string + KEY_SUFFIX, ResUtil.getLabels());
    }

    public static Integer getCommonDlgAccessKey(String string) {
        if (sCommonDlgBundle == null) {
            sCommonDlgBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        }
        if (sCommonDlgBundle != null) {
            return (Integer)ResUtil.getObject(string + KEY_SUFFIX, sCommonDlgBundle);
        }
        return null;
    }

    public static KeyStroke getShortcut(String string) {
        return (KeyStroke)ResUtil.getObject(string + SHORTCUT_SUFFIX, ResUtil.getLabels());
    }

    public static String getTooltip(String string) {
        return ResUtil.getString(string + TOOLTIP_SUFFIX);
    }

    public static String getActionLabel(String string) {
        return ResUtil.getString(string + LABEL_SUFFIX);
    }

    public static URL getImageURL(String string) {
        return ResUtil.getSystemURL(string + IMAGE_SUFFIX);
    }

    public static URL getLargeImageURL(String string) {
        LookAndFeelManager lookAndFeelManager = SpssMgr.getSpssMgr().getLookAndFeelManager();
        String string2 = lookAndFeelManager.getLookAndFeel().getName();
        if (string2.contains("AnalyticsLafLookAndFeel") && ResUtil.getSystemURL(string + ANLAF_LARGE_IMAGE_SUFFIX) != null) {
            return ResUtil.getSystemURL(string + ANLAF_LARGE_IMAGE_SUFFIX);
        }
        return ResUtil.getSystemURL(string + LARGE_IMAGE_SUFFIX);
    }

    public static String getMenu(String string) {
        return ResUtil.getString(string + MENU_SUFFIX);
    }

    public static URL getImageResource(String string) {
        return ResUtil.getImageResourceFullPath(ClientResBundle.getImageFolder() + string);
    }

    public static URL getImageResourceFullPath(String string) {
        URL uRL = null;
        if (string != null) {
            uRL = ResUtil.class.getClassLoader().getResource(string);
        }
        return uRL;
    }

    public static URL getCommonDlgImageResource(String string) {
        URL uRL = null;
        if (string != null) {
            uRL = ResUtil.class.getClassLoader().getResource(CommonDlgResBundle.getImageFolder() + string);
        }
        return uRL;
    }

    public static String wrapStringByWord(String string, int n) {
        if (string.length() < n) {
            return string;
        }
        String[] stringArray = string.split(" ");
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if ((n2 += stringArray[i].length()) < n) {
                stringBuilder.append(stringArray[i]).append(" ");
                continue;
            }
            n2 = 0;
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private static URL getSystemURL(String string) {
        String string2 = ResUtil.getString(string);
        if (string2 != null) {
            return ResUtil.class.getClassLoader().getResource(string2);
        }
        return null;
    }
}

