/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print.ppt_export;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.output.OutputDocument;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.output.export.ExportOutputMgr;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.script.ScriptingFrameworkException;
import com.spss.java_client.core.script.autoscripts.IAutoscriptEvent;
import com.spss.java_client.core.script.autoscripts.IScriptFile;
import com.spss.java_client.core.script.autoscripts.ScriptFile;
import com.spss.java_client.core.script.engine.IScriptCompletionListener;
import com.spss.java_client.core.script.engine.IScriptCompletionResult;
import com.spss.java_client.core.script.engine.IScriptLanguage;
import com.spss.java_client.core.script.engine.IScriptRunConfig;
import com.spss.java_client.core.script.engine.ScriptEngine;
import com.spss.java_client.core.script.engine.ScriptLanguageMgr;
import com.spss.java_client.core.script.engine.ScriptRunConfig;
import com.spss.java_client.core.script.res.ScriptingErrorCodes;
import com.spss.java_client.core.script.res.ScriptingResBundle;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.shared.core_tools.file.SpssFile;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.ConsumeStream;
import com.spss.shared.export.IExportOptions;
import com.spss.shared.export.PPTDocumentExportOptions;
import com.spss.shared.export.PageSetupExportOptions;
import com.spss.uitools.util.CharacterUtil;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;

public class PptExporter
implements IScriptCompletionListener {
    private final PPTDocumentExportOptions mDocOptions;
    private final String mFileName;
    private final IExportOptions.ObjectToExport mObjType;
    private final ViewerFrame mFrame;
    private IAutoscriptEvent mEvent = null;

    public PptExporter(PPTDocumentExportOptions pPTDocumentExportOptions, String string, IExportOptions.ObjectToExport objectToExport, ViewerFrame viewerFrame) {
        this.mDocOptions = pPTDocumentExportOptions;
        this.mFileName = string;
        this.mObjType = objectToExport;
        this.mFrame = viewerFrame;
    }

    public void export() {
        Object object;
        String string;
        StringBuffer stringBuffer;
        SpssFile spssFile = new SpssFile(this.mFileName);
        if (!spssFile.hasExtension(SpssFile.Extension.POWER_POINT)) {
            stringBuffer = new StringBuffer(spssFile.getParent());
            stringBuffer.append(SpssFile.separator).append(spssFile.getBasename());
            stringBuffer.append(".").append(SpssFile.Extension.POWER_POINT.getValue());
            string = CharacterUtil.smartQuote((String)stringBuffer.toString());
        } else {
            string = CharacterUtil.smartQuote((String)this.mFileName);
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (this.mObjType == IExportOptions.ObjectToExport.AllVisible) {
            stringBuffer.append(" 1");
        } else if (this.mObjType == IExportOptions.ObjectToExport.Selected) {
            stringBuffer.append(" 2");
        } else {
            stringBuffer.append(" 0");
        }
        stringBuffer.append(this.mDocOptions.getPPTUseViewerOutlines() ? " 1" : " 0");
        PageSetupExportOptions pageSetupExportOptions = this.mDocOptions.getPageSetup();
        if (pageSetupExportOptions == null) {
            pageSetupExportOptions = new PageSetupExportOptions();
            object = PrinterJob.getPrinterJob().defaultPage();
            pageSetupExportOptions.setPage((PageFormat)object, false);
        }
        if (pageSetupExportOptions.getUnits() == IExportOptions.MeasurementUnits.Millimeters) {
            stringBuffer.append(" 1");
        } else if (pageSetupExportOptions.getUnits() == IExportOptions.MeasurementUnits.Centimeters) {
            stringBuffer.append(" 2");
        } else {
            stringBuffer.append(" 0");
        }
        stringBuffer.append(this.mDocOptions.isIncludeFootnotesAndCaptions() ? " 1" : " 0");
        if (this.mDocOptions.getPivotTableOption() == IExportOptions.PivotTableOptions.PTExportAllLayers) {
            stringBuffer.append(" 1");
        } else if (this.mDocOptions.getPivotTableOption() == IExportOptions.PivotTableOptions.PTExportVisibleLayer) {
            stringBuffer.append(" 2");
        } else {
            stringBuffer.append(" 0");
        }
        if (this.mDocOptions.getWideTablesOption() == IExportOptions.WideTablesOptions.WT_Shrink) {
            stringBuffer.append(" 1");
        } else if (this.mDocOptions.getWideTablesOption() == IExportOptions.WideTablesOptions.WT_Extend) {
            stringBuffer.append(" 2");
        } else {
            stringBuffer.append(" 0");
        }
        if (pageSetupExportOptions.getUnits() == IExportOptions.MeasurementUnits.PrintPoints) {
            stringBuffer.append(" ").append(Double.toString(pageSetupExportOptions.getHeight() / 72.0));
            stringBuffer.append(" ").append(Double.toString(pageSetupExportOptions.getWidth() / 72.0));
            stringBuffer.append(" ").append(Double.toString(pageSetupExportOptions.getLeftMargin() / 72.0));
            stringBuffer.append(" ").append(Double.toString(pageSetupExportOptions.getRightMargin() / 72.0));
            stringBuffer.append(" ").append(Double.toString(pageSetupExportOptions.getTopMargin() / 72.0));
            stringBuffer.append(" ").append(Double.toString(pageSetupExportOptions.getBottomMargin() / 72.0));
        } else {
            stringBuffer.append(" ").append(Double.toString(pageSetupExportOptions.getHeight()));
            stringBuffer.append(" ").append(Double.toString(pageSetupExportOptions.getWidth()));
            stringBuffer.append(" ").append(Double.toString(pageSetupExportOptions.getLeftMargin()));
            stringBuffer.append(" ").append(Double.toString(pageSetupExportOptions.getRightMargin()));
            stringBuffer.append(" ").append(Double.toString(pageSetupExportOptions.getTopMargin()));
            stringBuffer.append(" ").append(Double.toString(pageSetupExportOptions.getBottomMargin()));
        }
        stringBuffer.append(" ").append(this.mDocOptions.getModelViewOption().toString());
        String string2 = this.mDocOptions.getViewerDocName();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(" ").append(CharacterUtil.smartQuote((String)string2));
        }
        AppMgr.setScriptParameter((String)stringBuffer.toString());
        try {
            IScriptLanguage iScriptLanguage;
            int n;
            String string3;
            object = System.getProperty("application.home");
            if (!((String)object).endsWith(File.separator)) {
                object = (String)object + File.separator;
            }
            if ((string3 = ((String)(object = (String)object + "PptExport.wwd")).substring((n = ((String)object).lastIndexOf(46)) + 1)) != null && !string3.equals("")) {
                iScriptLanguage = ScriptLanguageMgr.getInstance().getLanguageByExtention(string3);
                if (iScriptLanguage == null) {
                    iScriptLanguage = ScriptLanguageMgr.getInstance().getDefaultLanguage();
                }
            } else {
                ComponentState.trace1((String)("Invalid script file name : " + (String)object), (int)32768);
                ResourceBundle resourceBundle = CoreResUtil.getBundle((String)ScriptingResBundle.getDefaultResourceBundleName(), (Locale)CoreResUtil.getLocale());
                int n2 = ScriptingErrorCodes.ERR_AFW_InvalidScriptFile.getIntValue();
                String string4 = CoreResUtil.getString((ResourceBundle)resourceBundle, (String)ScriptingErrorCodes.ERR_AFW_InvalidScriptFile.toString());
                throw new ScriptingFrameworkException(n2, string4);
            }
            ScriptFile scriptFile = new ScriptFile(new File((String)object), iScriptLanguage);
            ScriptRunConfig scriptRunConfig = new ScriptRunConfig((IScriptFile)scriptFile);
            scriptRunConfig.setScriptSessionID(Integer.toString(ComponentState.P()));
            scriptRunConfig.setScriptContextID("" + System.nanoTime());
            if (this.mEvent == null) {
                ScriptEngine.getScriptEngine().runScript((IScriptRunConfig)scriptRunConfig, true, false, (IScriptCompletionListener)this);
            } else {
                scriptRunConfig.setEventInfo(this.mEvent);
                ScriptEngine.getScriptEngine().runScript((IScriptRunConfig)scriptRunConfig, true, false, (IScriptCompletionListener)this);
            }
        }
        catch (ScriptingFrameworkException scriptingFrameworkException) {
            SpssAlertOptionPane.showErrorMessageDialog(this.mFrame, "ERROR " + scriptingFrameworkException.getErrorCode() + " " + scriptingFrameworkException.getMessage(), VersionInfo.getAppVersionString());
        }
    }

    public void SetEventInfo(IAutoscriptEvent iAutoscriptEvent) {
        this.mEvent = iAutoscriptEvent;
    }

    static Process runPowerPointExport(String string, IScriptRunConfig iScriptRunConfig) throws ScriptingFrameworkException, IOException {
        File file = iScriptRunConfig.getScriptFile();
        IScriptLanguage iScriptLanguage = iScriptRunConfig.getLanguage();
        assert (file != null);
        assert (iScriptLanguage != null);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Vector<String> vector = new Vector<String>();
        File file2 = new File(string);
        if (!file2.isFile() || !file2.exists()) {
            ResourceBundle resourceBundle = CoreResUtil.getBundle((String)ScriptingResBundle.getDefaultResourceBundleName(), (Locale)CoreResUtil.getLocale());
            int n = ScriptingErrorCodes.ERR_AFW_InvalidLanguageEditor.getIntValue();
            String string2 = CoreResUtil.getString((ResourceBundle)resourceBundle, (String)ScriptingErrorCodes.ERR_AFW_InvalidLanguageEditor.toString());
            throw new ScriptingFrameworkException(n, string2);
        }
        if (OSCheck.getOSType() == OSInfo.OSType.WIN) {
            vector.add(PptExporter.quoteThePath(file2.getAbsolutePath()));
        } else {
            vector.add(file2.getAbsolutePath());
        }
        Vector vector2 = iScriptLanguage.getEditorArguments();
        vector.addAll(vector2);
        if (OSCheck.getOSType() == OSInfo.OSType.WIN) {
            vector.add(PptExporter.quoteThePath(file.getAbsolutePath()));
        } else {
            vector.add(file.getAbsolutePath());
        }
        processBuilder.command(vector);
        Map map = iScriptRunConfig.getEnvironment();
        Map<String, String> map2 = processBuilder.environment();
        map2.putAll(map);
        Process process = processBuilder.start();
        ComponentState.trace1((String)("Editor process started for script = " + file), (int)32768);
        PrintStream printStream = new PrintStream(new ByteArrayOutputStream());
        PrintStream printStream2 = new PrintStream(new ByteArrayOutputStream());
        new ConsumeStream(process.getInputStream(), printStream).start();
        new ConsumeStream(process.getErrorStream(), printStream2).start();
        return process;
    }

    private static String quoteThePath(String string) {
        return "\"" + string + "\"";
    }

    public void notifyScriptCompletion(IScriptCompletionResult iScriptCompletionResult) {
        if (ExportOutputMgr.isPptExportInvoked()) {
            ExportOutputMgr exportOutputMgr = OutputManager.getOutputManager().getExportOutputMgr();
            if (exportOutputMgr != null) {
                exportOutputMgr.processScriptCompletion(iScriptCompletionResult);
            } else if (ExportOutputMgr.isExportFromGui()) {
                if (((OutputDocument)this.mFrame.getDocument().getCoreDocument()).getProgressUIAgent() != null) {
                    ((OutputDocument)this.mFrame.getDocument().getCoreDocument()).removeProgressWindow();
                }
                if (iScriptCompletionResult.isErrorOccured()) {
                    ExportOutputMgr.setResultCode((short)1);
                }
                this.displayAlert();
            }
            return;
        }
        if (iScriptCompletionResult.isErrorOccured()) {
            SpssAlertOptionPane.showErrorMessageDialog(this.mFrame, "ERROR " + iScriptCompletionResult.getErrorCode() + " " + iScriptCompletionResult.getErrorMessage(), VersionInfo.getAppVersionString());
        }
    }

    private void displayAlert() {
        String string = null;
        short s = ExportOutputMgr.getResultCode();
        if (s == 0) {
            return;
        }
        ResourceBundle resourceBundle = CoreResUtil.getBundle((String)CommonDlgResBundle.getDefaultResourceBundleName(), (Locale)CoreResUtil.getLocale());
        if (s == 1) {
            string = CoreResUtil.getString((ResourceBundle)resourceBundle, (String)"ERR_EXPORTOUTPUT_GENERAL_FALURE");
        } else if (s == 9) {
            string = CoreResUtil.getString((ResourceBundle)resourceBundle, (String)"ERR_EXPORTOUTPUT_PPT_NOT_INSTALLED");
        }
        if (string != null) {
            SpssAlertOptionPane.showErrorMessageDialog(this.mFrame, string, VersionInfo.getAppVersionString());
        }
    }
}

