/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print.pdf_export;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.spss.java_client.core.common.ComponentState;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.FontUtil;
import java.awt.Font;
import java.util.Locale;

public class PdfExporterFontMapper
extends DefaultFontMapper {
    private boolean mEmbedFont;

    public PdfExporterFontMapper(boolean bl) {
        this.mEmbedFont = bl;
    }

    public void insertNames(Object[] objectArray, String string) {
        DefaultFontMapper.BaseFontParameters baseFontParameters = (DefaultFontMapper.BaseFontParameters)objectArray[2];
        String string2 = null;
        for (DefaultFontMapper.BaseFontParameters baseFontParameters2 : baseFontParameters) {
            if (!baseFontParameters2[2].equals("1033")) continue;
            string2 = baseFontParameters2[3];
            break;
        }
        if (string2 == null) {
            string2 = baseFontParameters[0][3];
        }
        if (this.getMapper().get(string2) == null) {
            DefaultFontMapper.BaseFontParameters baseFontParameters3 = new DefaultFontMapper.BaseFontParameters(string);
            baseFontParameters3.embedded = this.mEmbedFont;
            this.putName(string2, baseFontParameters3);
        }
        for (DefaultFontMapper.BaseFontParameters baseFontParameters2 : baseFontParameters) {
            this.putAlias((String)baseFontParameters2[3], string2);
        }
        this.putAlias(objectArray[0].toString(), string2);
    }

    public BaseFont awtToPdf(Font font) {
        try {
            Locale locale = this.getFontLocale();
            String string = locale.getLanguage();
            if (this.isNonWesternSpssLocale() || this.isNonWesternOLang()) {
                String string2 = FontUtil.logicalToPhysicalFontFamily((String)font.getFamily(), (int)font.getStyle(), (Locale)locale);
                DefaultFontMapper.BaseFontParameters baseFontParameters = this.getBaseFontParameters(string2);
                if (baseFontParameters != null) {
                    return BaseFont.createFont((String)baseFontParameters.fontName, (String)"Identity-H", (boolean)baseFontParameters.embedded, (boolean)baseFontParameters.cached, (byte[])baseFontParameters.ttfAfm, (byte[])baseFontParameters.pfb);
                }
                if (OSInfo.getOSType() != OSInfo.OSType.WIN) {
                    if (string.equalsIgnoreCase("zh")) {
                        if (locale.toString().equalsIgnoreCase("zh_CN")) {
                            return BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)this.mEmbedFont);
                        }
                        if (locale.toString().equalsIgnoreCase("zh_TW")) {
                            return BaseFont.createFont((String)"MHei-Medium", (String)"UniCNS-UCS2-H", (boolean)this.mEmbedFont);
                        }
                    } else {
                        if (string.equalsIgnoreCase("ja")) {
                            return BaseFont.createFont((String)"KozMinPro-Regular", (String)"UniJIS-UCS2-H", (boolean)this.mEmbedFont);
                        }
                        if (string.equalsIgnoreCase("ko")) {
                            return BaseFont.createFont((String)"HYGoThic-Medium", (String)"UniKS-UCS2-H", (boolean)this.mEmbedFont);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return super.awtToPdf(font);
    }

    private Locale getFontLocale() {
        Locale locale = ComponentState.getPdfLangLocale();
        Locale locale2 = ComponentState.getSPSSLocale();
        String string = locale.getLanguage();
        String string2 = locale2.getLanguage();
        if (string.equalsIgnoreCase("ja") || string.equalsIgnoreCase("ko") || string.equalsIgnoreCase("zh") || string.equalsIgnoreCase("cs")) {
            return locale;
        }
        if (string2.equalsIgnoreCase("ja") || string2.equalsIgnoreCase("ko") || string2.equalsIgnoreCase("zh") || string2.equalsIgnoreCase("cs")) {
            return locale2;
        }
        if (ComponentState.isBidiSPSSLocale()) {
            return locale2;
        }
        return locale;
    }

    public boolean isBidiFontLocale() {
        String string = this.getFontLocale().getLanguage();
        for (int i = 0; i < ComponentState.BIDI_LANGS_ENCODINGS.length; ++i) {
            if (!ComponentState.BIDI_LANGS_ENCODINGS[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isNonWesternSpssLocale() {
        String string = ComponentState.getCodepageCharsetName();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC && string.lastIndexOf(45) >= 0) {
            string = string.substring(0, string.lastIndexOf(45));
        }
        return !string.equalsIgnoreCase("windows-1252") && !string.equalsIgnoreCase("ISO-8859-1") && !string.equalsIgnoreCase("ISO-8859") && !string.equalsIgnoreCase("ISO_8859");
    }

    private boolean isNonWesternOLang() {
        Locale locale = this.getFontLocale();
        String string = locale.getLanguage();
        return !string.equalsIgnoreCase("en") && !string.equalsIgnoreCase("fr") && !string.equalsIgnoreCase("de") && !string.equalsIgnoreCase("it") && !string.equalsIgnoreCase("es");
    }
}

