/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print.pdf_export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.doc_types.output.ChartViewerItem;
import com.spss.java_client.ui.doc_types.output.HeaderViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.print.OutputViewPrintable;
import com.spss.java_client.ui.print.output.ViewerNode;
import com.spss.java_client.ui.print.pdf_export.PdfExporterFontMapper;
import com.spss.shared.core_tools.file.SpssFile;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.export.IExportOptions;
import com.spss.shared.export.PDFDocumentExportOptions;
import com.spss.uitools.dialogs.IProgressUIAgent;
import com.spss.uitools.util.DrawUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.text.html.HTMLEditorKit;

public class PdfExporter {
    private final PDFDocumentExportOptions mDocOptions;
    private final String mFileName;
    private final IExportOptions.ObjectToExport mObjType;
    private final ViewerFrame mFrame;
    boolean mExportGraphOnly;

    public PdfExporter(PDFDocumentExportOptions pDFDocumentExportOptions, String string, IExportOptions.ObjectToExport objectToExport, ViewerFrame viewerFrame, boolean bl) {
        this.mDocOptions = pDFDocumentExportOptions;
        this.mFileName = string;
        this.mObjType = objectToExport;
        this.mFrame = viewerFrame;
        this.mExportGraphOnly = bl;
    }

    public void export(IProgressUIAgent iProgressUIAgent) {
        ViewerNode viewerNode3;
        PageFormat pageFormat = this.mFrame.getPrintable().getPrintOPtions().getPageFormat();
        if (pageFormat == null) {
            pageFormat = PrinterJob.getPrinterJob().defaultPage();
        }
        OutputViewPrintable outputViewPrintable = new OutputViewPrintable(this.mFrame, this.mFrame.getPrintOptions(), this.getPrintObjectRange(), this.getTableLayerPrintSetting());
        outputViewPrintable.printInit();
        outputViewPrintable.setITextPdfFix(true);
        outputViewPrintable.setIsPrinting(false);
        outputViewPrintable.setModelViewsPrintOption(this.mDocOptions.getModelViewOption());
        outputViewPrintable.setProgessDlg((SpssProgressDlg)iProgressUIAgent);
        ViewerNode viewerNode2 = outputViewPrintable.getViewerRoot();
        double d = pageFormat.getWidth();
        double d2 = pageFormat.getHeight();
        if (this.mExportGraphOnly) {
            for (ViewerNode viewerNode3 : viewerNode2.getChildNodes()) {
                if (!(viewerNode3.getViewerItem() instanceof HeaderViewerItem)) continue;
                d2 = this.getChartHeight(viewerNode3, d, d2);
                d = this.getChartWidth(viewerNode3, d, d2);
            }
        }
        Rectangle rectangle = new Rectangle((float)d, (float)d2);
        viewerNode3 = new Document(rectangle);
        try {
            Graphics2D graphics2D;
            String string = this.mFileName;
            SpssFile spssFile = new SpssFile(string);
            if (!spssFile.hasExtension(SpssFile.Extension.PORTABLE_DOCUMENT_FORMAT)) {
                string = string + "." + SpssFile.Extension.PORTABLE_DOCUMENT_FORMAT.getValue();
            }
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)viewerNode3, (OutputStream)new FileOutputStream(string));
            viewerNode3.open();
            PdfExporterFontMapper pdfExporterFontMapper = new PdfExporterFontMapper(this.mDocOptions.embedFontsPDF());
            if (pdfExporterFontMapper.isBidiFontLocale()) {
                outputViewPrintable.setITextPdfFix_bidi(true);
            }
            FontFactory.registerDirectories();
            this.insertFontDirectories(pdfExporterFontMapper);
            Color color = new Color(0, 0, 0, 0);
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            int n = 1;
            while (true) {
                if (n > 1) {
                    viewerNode3.newPage();
                }
                PdfTemplate pdfTemplate = pdfContentByte.createTemplate(rectangle.getWidth(), rectangle.getHeight());
                graphics2D = pdfTemplate.createGraphics(rectangle.getWidth(), rectangle.getHeight(), (FontMapper)pdfExporterFontMapper);
                graphics2D.setBackground(color);
                graphics2D.setColor(color);
                graphics2D.clearRect(0, 0, (int)rectangle.getWidth(), (int)rectangle.getHeight());
                int n2 = outputViewPrintable.print(graphics2D, pageFormat, n - 1, this.mExportGraphOnly);
                if (n2 == 1) break;
                ColumnText.showTextAligned((PdfContentByte)pdfContentByte, (int)2, null, (float)viewerNode3.right(), (float)(viewerNode3.bottom() - 10.0f), (float)0.0f);
                graphics2D.dispose();
                pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
                ++n;
            }
            int n3 = outputViewPrintable.getTotalNumberOfPages();
            if (n3 > 0) {
                if (this.mDocOptions.embedBookmarksPDF()) {
                    graphics2D = pdfContentByte.getRootOutline();
                    ViewerNode viewerNode4 = outputViewPrintable.getViewerRoot();
                    this.markBookMarkNodes(viewerNode4);
                    this.setXYForHeaderNodes(viewerNode4);
                    this.createBookMark(viewerNode4, pdfWriter, (PdfOutline)graphics2D);
                }
            } else {
                viewerNode3.add((Element)new Paragraph(" "));
            }
            outputViewPrintable.showLongTableRowLableMessage();
            outputViewPrintable.dispose();
            viewerNode3.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, fileNotFoundException.getMessage());
            ComponentState.trace1((String)fileNotFoundException.getMessage(), (int)15);
            fileNotFoundException.printStackTrace();
        }
        catch (DocumentException documentException) {
            ComponentState.trace1((String)documentException.getMessage(), (int)15);
            documentException.printStackTrace();
        }
        catch (PrinterException printerException) {
            ComponentState.trace1((String)printerException.getMessage(), (int)15);
            printerException.printStackTrace();
        }
        catch (Throwable throwable) {
            ComponentState.trace1((String)throwable.getMessage(), (int)15);
            throwable.printStackTrace();
        }
    }

    double getChartHeight(ViewerNode viewerNode, double d, double d2) {
        for (ViewerNode viewerNode2 : viewerNode.getChildNodes()) {
            ViewerItem viewerItem = viewerNode2.getViewerItem();
            if (viewerNode2.getViewerItem() instanceof ChartViewerItem && viewerItem.isSelected()) {
                d2 = DrawUtil.convertToUserValue((float)viewerItem.getHeight(), (int)3, (int)0);
                d = DrawUtil.convertToUserValue((float)viewerItem.getWidth(), (int)3, (int)0);
                break;
            }
            if (!(viewerNode2.getViewerItem() instanceof HeaderViewerItem)) continue;
            d2 = this.getChartHeight(viewerNode2, d, d2);
        }
        return d2;
    }

    double getChartWidth(ViewerNode viewerNode, double d, double d2) {
        for (ViewerNode viewerNode2 : viewerNode.getChildNodes()) {
            ViewerItem viewerItem = viewerNode2.getViewerItem();
            if (viewerNode2.getViewerItem() instanceof ChartViewerItem && viewerItem.isSelected()) {
                d2 = DrawUtil.convertToUserValue((float)viewerItem.getHeight(), (int)3, (int)0);
                d = DrawUtil.convertToUserValue((float)viewerItem.getWidth(), (int)3, (int)0);
                break;
            }
            if (!(viewerNode2.getViewerItem() instanceof HeaderViewerItem)) continue;
            d = this.getChartWidth(viewerNode2, d, d2);
        }
        return d;
    }

    private void markBookMarkNodes(ViewerNode viewerNode) {
        for (ViewerNode viewerNode2 : viewerNode.getChildNodes()) {
            if (viewerNode2.getViewerItem() instanceof HeaderViewerItem) {
                this.markBookMarkNodes(viewerNode2);
            }
            if (!viewerNode2.isPrintable() && !viewerNode2.isBookmarkNode()) continue;
            viewerNode2.setBookmarkNode(true);
            viewerNode.setBookmarkNode(true);
        }
    }

    private void createBookMark(ViewerNode viewerNode, PdfWriter pdfWriter, PdfOutline pdfOutline) {
        for (ViewerNode viewerNode2 : viewerNode.getChildNodes()) {
            PdfDestination pdfDestination = new PdfDestination(0, 0.0f, (float)viewerNode2.getY(), 0.0f);
            String string = this.stripHtmlTags(viewerNode2.getText());
            if (!viewerNode2.isBookmarkNode() || viewerNode2.getPageNumber() <= 0) continue;
            PdfOutline pdfOutline2 = new PdfOutline(pdfOutline, PdfAction.gotoLocalPage((int)viewerNode2.getPageNumber(), (PdfDestination)pdfDestination, (PdfWriter)pdfWriter), string);
            this.createBookMark(viewerNode2, pdfWriter, pdfOutline2);
        }
    }

    private void setXYForHeaderNodes(ViewerNode viewerNode) {
        Object object;
        ArrayList<ViewerNode> arrayList = viewerNode.getChildNodes();
        int n = arrayList.size();
        int n2 = 0;
        if (arrayList.size() > 0) {
            for (n2 = 0; n2 < n; ++n2) {
                ViewerNode viewerNode2 = arrayList.get(n2);
                if (!viewerNode2.isBookmarkNode()) continue;
                object = viewerNode2.getViewerItem();
                if (object instanceof HeaderViewerItem) {
                    this.setXYForHeaderNodes(viewerNode2);
                }
                viewerNode.setX(viewerNode2.getX());
                viewerNode.setY(viewerNode2.getY());
                viewerNode.setPageNumber(viewerNode2.getPageNumber());
                ++n2;
                break;
            }
        }
        for (int i = n2; i < n; ++i) {
            object = arrayList.get(i);
            if (!(((ViewerNode)object).getViewerItem() instanceof HeaderViewerItem)) continue;
            this.setXYForHeaderNodes((ViewerNode)object);
        }
    }

    private void insertFontDirectories(DefaultFontMapper defaultFontMapper) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (OSCheck.getOSType() == OSInfo.OSType.WIN) {
            object = "C:\\Windows\\Fonts";
            arrayList.add(object);
        } else if (OSCheck.getOSType() == OSInfo.OSType.LINUX) {
            File[] object2;
            object = new File("/usr/share/fonts");
            if (((File)object).isDirectory() && (object2 = ((File)object).listFiles()) != null) {
                for (File file : object2) {
                    if (!file.isDirectory()) continue;
                    arrayList.add(file.getPath());
                }
            }
        } else if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            object = "/Library/Fonts";
            arrayList.add(object);
        }
        for (String string : arrayList) {
            defaultFontMapper.insertDirectory(string);
        }
    }

    private OutputViewPrintable.PrintRange getPrintObjectRange() {
        if (this.mObjType == IExportOptions.ObjectToExport.All) {
            return OutputViewPrintable.PrintRange.eALL;
        }
        if (this.mObjType == IExportOptions.ObjectToExport.AllVisible) {
            return OutputViewPrintable.PrintRange.eVISIBLE;
        }
        if (this.mObjType == IExportOptions.ObjectToExport.Selected) {
            return OutputViewPrintable.PrintRange.eSELECTED;
        }
        return null;
    }

    private OutputViewPrintable.TableLayerPrintSetting getTableLayerPrintSetting() {
        if (this.mDocOptions.getPivotTableOption() == IExportOptions.PivotTableOptions.PTUsePrintLayerSetting) {
            return OutputViewPrintable.TableLayerPrintSetting.eHONOR_TABLE_SETTING;
        }
        if (this.mDocOptions.getPivotTableOption() == IExportOptions.PivotTableOptions.PTExportAllLayers) {
            return OutputViewPrintable.TableLayerPrintSetting.eALL_LAYERS;
        }
        if (this.mDocOptions.getPivotTableOption() == IExportOptions.PivotTableOptions.PTExportVisibleLayer) {
            return OutputViewPrintable.TableLayerPrintSetting.eVISIBLE_LAYER_ONLY;
        }
        return null;
    }

    private String stripHtmlTags(String string) {
        if (string == null || !string.contains("<html")) {
            return string;
        }
        StringReader stringReader = new StringReader(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HTMLEditorKit.Parser parser = new HTMLEditorKit(){

            @Override
            public HTMLEditorKit.Parser getParser() {
                return super.getParser();
            }
        }.getParser();
        String string2 = "";
        try {
            HtmlParserCallback htmlParserCallback = new HtmlParserCallback(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"));
            parser.parse(stringReader, htmlParserCallback, false);
            string2 = byteArrayOutputStream.toString("UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private class HtmlParserCallback
    extends HTMLEditorKit.ParserCallback {
        private Writer out;

        public HtmlParserCallback(Writer writer) {
            this.out = writer;
        }

        @Override
        public void handleText(char[] cArray, int n) {
            try {
                this.out.write(cArray);
                this.out.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

