/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print.output;

import com.spss.java_client.core.common.ComponentState;
import com.spss.uitools.util.SpssDomWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XHTMLSplitter {
    private boolean mFlag = false;
    private boolean mParsingDone = false;
    private List<Node> mClosedNodes = new ArrayList<Node>();
    private final List<String> mHeadnodes = new ArrayList<String>();
    private List<String> mSplittedHtmls = new ArrayList<String>();
    private String mXHtmlContent;

    public XHTMLSplitter(String string) {
        this.mXHtmlContent = this.validateXHTML(string);
        this.parse();
    }

    public void parse() {
        try {
            Object object;
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            try {
                document = documentBuilder.parse(new InputSource(new StringReader(this.mXHtmlContent)));
            }
            catch (SAXException sAXException) {
                object2 = this.mXHtmlContent.replace("\\\"", "\"");
                object2 = ((String)object2).replace("<br>", "<br/>");
                document = documentBuilder.parse(new InputSource(new StringReader((String)object2)));
            }
            NodeList nodeList = document.getElementsByTagName("head");
            object2 = nodeList.item(0);
            if (object2 != null) {
                object = object2.getChildNodes();
                this.mHeadnodes.add(object2.getNodeName());
                for (int i = 0; i < object.getLength(); ++i) {
                    if (object.item(i).getNodeType() == 3) continue;
                    this.mHeadnodes.add(object.item(i).getNodeName());
                }
            }
            do {
                this.mFlag = false;
                object = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder2 = ((DocumentBuilderFactory)object).newDocumentBuilder();
                Document document2 = documentBuilder2.newDocument();
                this.print(document, document2);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                SpssDomWriter spssDomWriter = new SpssDomWriter();
                spssDomWriter.setCanonical(true);
                spssDomWriter.setOutput((OutputStream)byteArrayOutputStream, null);
                spssDomWriter.write((Node)document2);
                byteArrayOutputStream.close();
                String string = this.restoreSpace(byteArrayOutputStream.toString("UTF8"));
                this.mSplittedHtmls.add(string);
            } while (!this.mParsingDone);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ComponentState.trace1((String)parserConfigurationException.getMessage(), (int)15);
        }
        catch (SAXException sAXException) {
            ComponentState.trace1((String)sAXException.getMessage(), (int)15);
        }
        catch (IOException iOException) {
            ComponentState.trace1((String)iOException.getMessage(), (int)15);
        }
    }

    public void print(Node node, Node node2) {
        Document document = !(node2 instanceof Document) ? node2.getOwnerDocument() : (Document)node2;
        switch (node.getNodeType()) {
            case 9: {
                if (node.hasChildNodes()) {
                    NodeList nodeList = node.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        if (this.mFlag) continue;
                        this.print(nodeList.item(i), node2);
                    }
                    break;
                }
            }
            case 1: {
                if (this.mClosedNodes.contains(node)) break;
                if (node.getNodeName().equalsIgnoreCase("br") && node.hasAttributes()) {
                    for (int i = 0; i < node.getAttributes().getLength(); ++i) {
                        Node node3 = node.getAttributes().item(i);
                        if (!node3.getNodeName().equalsIgnoreCase("style") || !node3.getNodeValue().equalsIgnoreCase("page-break-before:always;")) continue;
                        this.mClosedNodes.add(node);
                        this.mFlag = true;
                        return;
                    }
                }
                Node node4 = document.importNode(node, false);
                node2.appendChild(node4);
                if (node.hasChildNodes()) {
                    NodeList nodeList = node.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        if (this.mFlag) continue;
                        this.print(nodeList.item(i), node4);
                    }
                }
                if (this.mFlag || this.mHeadnodes.contains(node.getNodeName())) break;
                this.mClosedNodes.add(node);
                if (!node.getNodeName().equalsIgnoreCase("html")) break;
                this.mParsingDone = true;
                break;
            }
            case 2: {
                Node node5 = document.importNode(node, false);
                node2.appendChild(node5);
                if (node.hasChildNodes()) {
                    NodeList nodeList = node.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        if (this.mFlag) continue;
                        this.print(nodeList.item(i), node5);
                    }
                }
                if (this.mFlag) break;
                this.mClosedNodes.add(node);
                if (!node.getNodeName().equalsIgnoreCase("html")) break;
                this.mParsingDone = true;
                break;
            }
            case 3: {
                if (node.getNodeValue() != null && !this.mClosedNodes.contains(node)) {
                    node2.appendChild(document.createTextNode(node.getNodeValue()));
                }
                if (this.mFlag || this.mHeadnodes.contains(node.getParentNode().getNodeName())) break;
                this.mClosedNodes.add(node);
            }
        }
    }

    public List<String> getSplittedHtmls() {
        return this.mSplittedHtmls;
    }

    private String validateXHTML(String string) {
        string = string.replace("&nbsp;", "&amp;nbsp;");
        string = string.replace("&#160;", "&amp;nbsp;");
        string = string.replace("&#8199;", "&amp;nbsp;");
        string = string.replace('\u00a0', ' ');
        return string.replace("&&", "&");
    }

    private String restoreSpace(String string) {
        return string.replaceAll("&amp;nbsp;", "&nbsp;");
    }
}

