/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print.output;

import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.print.output.TextRenderer;
import java.util.ArrayList;
import java.util.Vector;

public class ViewerNode {
    private ViewerItem mViewerItem;
    private ArrayList<ViewerNode> mChildNodes = new ArrayList();
    private double mX = 0.0;
    private double mY = 0.0;
    private int mPageNumber = 0;
    private String mText;
    private ViewerNode mParent;
    private boolean mPrintable = false;
    private boolean mBookmarkNode = false;
    private ArrayList<TextRenderer> mTextRendererList;

    public ViewerNode(ViewerNode viewerNode, ViewerItem viewerItem) {
        this.mViewerItem = viewerItem;
        if (viewerItem != null) {
            IOutputItem iOutputItem = viewerItem.getCoreItem();
            this.mText = iOutputItem.getDescription();
        }
        this.mParent = viewerNode;
    }

    public ViewerItem getViewerItem() {
        return this.mViewerItem;
    }

    public void addChild(ViewerNode viewerNode) {
        this.mChildNodes.add(viewerNode);
    }

    public ArrayList<ViewerNode> getChildNodes() {
        return this.mChildNodes;
    }

    public void setViewerItem(ViewerItem viewerItem) {
        this.mViewerItem = viewerItem;
    }

    public double getX() {
        return this.mX;
    }

    public void setX(double d) {
        this.mX = d;
    }

    public double getY() {
        return this.mY;
    }

    public void setY(double d) {
        this.mY = d;
    }

    public int getPageNumber() {
        return this.mPageNumber;
    }

    public void setPageNumber(int n) {
        this.mPageNumber = n;
    }

    public String getText() {
        return this.mText;
    }

    public void removeChildNode(ViewerNode viewerNode) {
        this.mChildNodes.remove(viewerNode);
    }

    public ViewerNode getParent() {
        return this.mParent;
    }

    public Vector<ViewerItem> getHeaders() {
        ViewerNode viewerNode;
        Vector<ViewerItem> vector = new Vector<ViewerItem>();
        ViewerNode viewerNode2 = this;
        while (viewerNode2 != null && (viewerNode = viewerNode2.getParent()).getViewerItem() != null) {
            vector.add(0, viewerNode.getViewerItem());
            viewerNode2 = viewerNode;
        }
        return vector;
    }

    public boolean isPrintable() {
        return this.mPrintable;
    }

    public void setPrintable(boolean bl) {
        this.mPrintable = bl;
    }

    public boolean isBookmarkNode() {
        return this.mBookmarkNode;
    }

    public void setBookmarkNode(boolean bl) {
        this.mBookmarkNode = bl;
    }

    public ArrayList<TextRenderer> getTextRendererList() {
        return this.mTextRendererList;
    }

    public void setTextRendererList(ArrayList<TextRenderer> arrayList) {
        this.mTextRendererList = arrayList;
    }
}

