/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print.output;

import com.spss.java_client.core.documents.output.treemodel.TreeModelItem;
import com.spss.java_client.ui.doc_types.output.TreeModelViewerItem;
import com.spss.modelviewer.treeviewer.core.external.ATreeRendererFactory;
import com.spss.modelviewer.treeviewer.core.external.ATreeStateInfoFactory;
import com.spss.modelviewer.treeviewer.core.external.ITreeDisplaySettings;
import com.spss.modelviewer.treeviewer.core.external.ITreeRenderer;
import com.spss.modelviewer.treeviewer.core.external.ITreeStateInfo;
import com.spss.shared.core_tools.utils.ZipUtil;
import com.spss.tree.treemodel.ATreeModelFactory;
import com.spss.tree.treemodel.ITreeModel;
import com.spss.treemodeleditor.display.TreeDisplay;
import com.spss.vis.processors.Graphics2DProcessor;
import com.spss.vis.processors.GraphicsProcessor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class TreeRenderer {
    private TreeModelViewerItem mItem;
    private int mMaxWidth;
    private int mWidth;
    private int mMaxHeight;
    private int mHeight;

    public TreeRenderer(TreeModelViewerItem treeModelViewerItem, int n, int n2) {
        TreeModelItem treeModelItem = (TreeModelItem)treeModelViewerItem.getCoreItem();
        this.mItem = treeModelViewerItem;
        this.mWidth = n;
        this.mHeight = n2;
        this.mMaxWidth = treeModelItem.getWidth();
        this.mMaxHeight = treeModelItem.getHeight();
    }

    public void render(Graphics2D graphics2D, Dimension dimension) {
        ITreeModel iTreeModel;
        TreeModelItem treeModelItem = (TreeModelItem)this.mItem.getCoreItem();
        byte[] byArray = treeModelItem.getCompressedXML().array();
        byte[] byArray2 = treeModelItem.getDisplayData();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ZipUtil.decompressBytes((byte[])byArray));
        TreeDisplay treeDisplay = new TreeDisplay(System.getProperty("application.home"));
        String string = "";
        if (byArray2 != null && byArray2.length > 0) {
            try {
                string = new String(ZipUtil.decompressBytes((byte[])byArray2), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return;
            }
        }
        if (string.length() > 0) {
            treeDisplay.setModel(string);
        }
        if ((iTreeModel = ATreeModelFactory.createTreeModel((InputStream)byteArrayInputStream, (int)0, null, (Locale)treeDisplay.getOutputLocale())) == null) {
            return;
        }
        ITreeRenderer iTreeRenderer = ATreeRendererFactory.createTreeRenderer(null, (Locale)treeDisplay.getOutputLocale(), (Locale)treeDisplay.getNumericLocale());
        ITreeStateInfo iTreeStateInfo = ATreeStateInfoFactory.createTreeStateInfo((ITreeModel)iTreeModel, (ITreeDisplaySettings)iTreeRenderer.getTreeDisplaySettings());
        iTreeRenderer.setTreeStateInfo(iTreeStateInfo);
        iTreeRenderer.setTreeModel(iTreeModel);
        treeDisplay.setHighlightOverride(true);
        treeDisplay.applySettings(iTreeModel, iTreeRenderer.getTreeDisplaySettings(), iTreeStateInfo);
        treeDisplay.setHighlightOverride(false);
        Dimension dimension2 = iTreeRenderer.calculateTreeSize();
        double d = dimension.width * this.mWidth;
        double d2 = dimension.height * this.mHeight;
        graphics2D.translate(-d, -d2);
        if ((int)d + this.mWidth > this.mMaxWidth) {
            this.mWidth = this.mMaxWidth - (int)d;
        }
        if ((int)d2 + this.mHeight > this.mMaxHeight) {
            this.mHeight = this.mMaxHeight - (int)d2;
        }
        Rectangle rectangle = new Rectangle((int)d, (int)d2, this.mWidth, this.mHeight);
        graphics2D.setClip(rectangle);
        graphics2D.clearRect((int)d, (int)d2, this.mWidth, this.mHeight);
        double d3 = (double)this.mMaxWidth * 1.0 / dimension2.getWidth();
        double d4 = (double)this.mMaxHeight * 1.0 / dimension2.getHeight();
        double d5 = Math.min(d3, d4);
        iTreeRenderer.getTreeDisplaySettings().setZoomFactor((int)(d5 * 100.0));
        int n = iTreeStateInfo.getActiveNode();
        iTreeStateInfo.setActiveNode(-1);
        int[] nArray = iTreeStateInfo.getSelectedNodeIds();
        iTreeStateInfo.unselectAllNodes();
        Graphics2DProcessor graphics2DProcessor = new Graphics2DProcessor(graphics2D);
        iTreeRenderer.redraw((GraphicsProcessor)graphics2DProcessor, true);
        iTreeStateInfo.setActiveNode(n);
        iTreeStateInfo.setNodeListSelected(nArray, true);
    }
}

