/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print.output;

import com.spss.java_client.core.common.OutputItemAlignment;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.RepaintManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class TextRenderer {
    private JEditorPane mEditorPane;
    private final double mFullPageWidth;
    private final double mFullPageHeight;
    private double mMeasureStartY;
    private double mMeasureCurrentEndY;
    private List<Double> mPageStartYLoc = new ArrayList<Double>();
    private List<Double> mPageEndYLoc = new ArrayList<Double>();
    Rectangle mAllocation = null;
    View mRootView = null;
    private OutputItemAlignment mAlignment;
    private boolean mIsHeaderFooter;
    private boolean mIsPrintPreView;
    private Color mTextColor;

    public TextRenderer(String string, double d, double d2) {
        this(string, d, d2, OutputItemAlignment.Left);
        this.mIsHeaderFooter = false;
    }

    public TextRenderer(String string, double d, double d2, OutputItemAlignment outputItemAlignment) {
        this.mFullPageWidth = d;
        this.mFullPageHeight = d2;
        this.mAlignment = outputItemAlignment;
        this.mIsHeaderFooter = false;
        this.mEditorPane = new JEditorPane();
        this.mEditorPane.setFont(this.mEditorPane.getFont().deriveFont(14.0f));
        this.mEditorPane.setContentType("text/html; charset=UTF-8");
        string = string.replace("<br/>", "<br>");
        string = string.replace("<br />", "<br>");
        string = string.replace("<BR/>", "<br>");
        string = string.replace("<BR />", "<br>");
        string = string.replace("</head>", "</head><p>");
        string = string.replace("</html>", "</p></html>");
        string = string.replaceAll("\u00a0", " ");
        this.mEditorPane.setDocument(this.getHtmlDocument(string));
        this.initialize();
    }

    public TextRenderer(String string, Map<TextAttribute, ?> map, double d, double d2, Color color) {
        this.mFullPageWidth = d;
        this.mFullPageHeight = d2;
        this.mAlignment = OutputItemAlignment.Left;
        this.mIsHeaderFooter = false;
        this.mEditorPane = new JEditorPane();
        this.mEditorPane.setContentType("text/plain; charset=UTF-8");
        this.mEditorPane.setFont(new Font(map));
        this.mTextColor = color;
        PlainDocument plainDocument = new PlainDocument();
        try {
            plainDocument.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.mEditorPane.setDocument(plainDocument);
        this.initialize();
    }

    public TextRenderer(String string, double d, double d2, boolean bl, Color color) {
        this(string, d, d2, OutputItemAlignment.Left);
        this.mIsHeaderFooter = bl;
        this.mTextColor = color;
    }

    public void print(Graphics2D graphics2D, int n) {
        Color color = graphics2D.getColor();
        if (this.mTextColor != null) {
            graphics2D.setColor(this.mTextColor);
            this.mEditorPane.setForeground(this.mTextColor);
        }
        if (n < this.getNumberOfPages()) {
            Cloneable cloneable;
            Object object;
            Object object2;
            boolean bl;
            boolean bl2 = bl = this.mEditorPane.getContentType().indexOf("text/plain") > -1;
            if (bl) {
                if (this.mIsPrintPreView) {
                    object2 = this.mEditorPane.getFont();
                    graphics2D.setFont(new Font(((Font)object2).getFamily(), ((Font)object2).getStyle(), ((Font)object2).getSize() - 1));
                } else {
                    graphics2D.setFont(this.mEditorPane.getFont());
                }
            } else if (!this.mIsHeaderFooter) {
                int n2 = this.mAlignment == OutputItemAlignment.Right ? 2 : (this.mAlignment == OutputItemAlignment.Center ? 1 : 0);
                object = (StyledDocument)this.mEditorPane.getDocument();
                cloneable = new SimpleAttributeSet();
                StyleConstants.setAlignment(cloneable, n2);
                object.setParagraphAttributes(0, object.getLength(), (AttributeSet)((Object)cloneable), false);
            }
            this.disableDoubleBuffering(this.mEditorPane);
            this.mEditorPane.setSize((int)this.mFullPageWidth, Integer.MAX_VALUE);
            this.mEditorPane.validate();
            object2 = this.mEditorPane.getUI().getRootView(this.mEditorPane);
            graphics2D.setClip(0, 0, (int)this.mFullPageWidth + 60, (int)this.getPageHeight(n));
            object = this.mPageStartYLoc.get(n);
            cloneable = new Rectangle(0, -((Double)object).intValue(), (int)this.mFullPageWidth, (int)this.mEditorPane.getPreferredSize().getHeight());
            this.printView(graphics2D, (Shape)((Object)cloneable), (View)object2);
            this.enableDoubleBuffering(this.mEditorPane);
        }
        graphics2D.setColor(color);
    }

    public void doPaging(double d) {
        this.mMeasureCurrentEndY = d;
        while (this.measureView(this.mAllocation, this.mRootView)) {
            this.mPageStartYLoc.add(this.mMeasureStartY);
            this.mPageEndYLoc.add(this.mMeasureCurrentEndY);
            this.mMeasureStartY = this.mMeasureCurrentEndY;
            this.mMeasureCurrentEndY += this.mFullPageHeight;
        }
        if (this.mPageEndYLoc.size() == 0) {
            return;
        }
        this.mPageEndYLoc.remove(this.mPageEndYLoc.size() - 1);
        this.mPageEndYLoc.add(this.mAllocation.getBounds().getHeight());
        if (Math.abs(this.mPageEndYLoc.get(0) - this.mPageStartYLoc.get(0)) == 0.0) {
            this.mPageStartYLoc.remove(0);
            this.mPageEndYLoc.remove(0);
        }
    }

    public int getNumberOfPages() {
        return this.mPageStartYLoc.size();
    }

    public double getPageHeight(int n) {
        return this.mPageEndYLoc.get(n) - this.mPageStartYLoc.get(n);
    }

    private void printView(Graphics2D graphics2D, Shape shape, View view) {
        Rectangle rectangle = graphics2D.getClipBounds();
        if (view.getViewCount() > 0 && !view.getElement().getName().equalsIgnoreCase("td")) {
            for (int i = 0; i < view.getViewCount(); ++i) {
                Shape shape2 = view.getChildAllocation(i, shape);
                if (shape2 == null) continue;
                View view2 = view.getView(i);
                this.printView(graphics2D, shape2, view2);
            }
        } else if (shape.getBounds().getMaxY() >= rectangle.getY()) {
            if (shape.getBounds().getHeight() > rectangle.getHeight() && shape.intersects(rectangle)) {
                view.paint(graphics2D, shape);
            } else if (shape.getBounds().getY() >= rectangle.getY() && shape.getBounds().getMaxY() <= rectangle.getMaxY()) {
                view.paint(graphics2D, shape);
            }
        }
    }

    private void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    private void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }

    private HTMLDocument getHtmlDocument(String string) {
        SpssTextPane.WrappingHTMLEditorKit wrappingHTMLEditorKit = new SpssTextPane.WrappingHTMLEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)((HTMLEditorKit)wrappingHTMLEditorKit).createDefaultDocument();
        try {
            wrappingHTMLEditorKit.read(new StringReader(string), (Document)hTMLDocument, 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return hTMLDocument;
    }

    private boolean measureView(Shape shape, View view) {
        boolean bl = false;
        if (view.getViewCount() > 0 && !view.getElement().getName().equalsIgnoreCase("td")) {
            for (int i = 0; i < view.getViewCount(); ++i) {
                View view2;
                Shape shape2 = view.getChildAllocation(i, shape);
                if (shape2 == null || !this.measureView(shape2, view2 = view.getView(i))) continue;
                bl = true;
            }
        } else if (shape.getBounds().getMaxY() >= this.mMeasureStartY) {
            bl = true;
            if (!(shape.getBounds().getHeight() > this.mFullPageHeight) && shape.getBounds().getY() >= this.mMeasureStartY && !(shape.getBounds().getMaxY() <= this.mMeasureCurrentEndY) && shape.getBounds().getY() < this.mMeasureCurrentEndY) {
                this.mMeasureCurrentEndY = shape.getBounds().getY();
            }
        }
        return bl;
    }

    private void initialize() {
        this.mEditorPane.setSize((int)this.mFullPageWidth, Integer.MAX_VALUE);
        this.mEditorPane.validate();
        this.mRootView = this.mEditorPane.getUI().getRootView(this.mEditorPane);
        int n = (int)this.mEditorPane.getPreferredSize().getHeight();
        this.mAllocation = new Rectangle(0, 0, (int)this.mFullPageWidth, n);
    }

    public void setPrintPreView(boolean bl) {
        this.mIsPrintPreView = bl;
    }
}

