/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print.output;

import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.output.VizCache;
import com.spss.java_client.core.documents.output.chart.ChartItem;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.vis.ResultsProcessor;
import com.spss.vis.Visualization;
import com.spss.vis.processors.Graphics2DProcessor;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.print.PageFormat;
import java.util.HashMap;
import java.util.Map;

public class ChartRenderer {
    private final ViewerItem mChartItem;
    private int mMaxWidth;
    private int mMaxHeight;
    private boolean mCanPrintShadow = true;

    public ChartRenderer(ViewerItem viewerItem, int n, int n2) {
        this.mChartItem = viewerItem;
        this.mMaxWidth = n;
        this.mMaxHeight = n2;
    }

    public void render(Graphics2D graphics2D, PageFormat pageFormat) {
        try {
            Visualization visualization = VizCache.getCache().getVisualization((ChartItem)this.mChartItem.getCoreItem());
            if (visualization != null) {
                FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
                int n = visualization.getOutputWidth(fontRenderContext);
                int n2 = visualization.getOutputHeight(fontRenderContext);
                double d = (double)this.mMaxWidth * 1.0 / (double)n;
                double d2 = (double)this.mMaxHeight * 1.0 / (double)n2;
                double d3 = Math.min(d, d2);
                graphics2D.scale(d3, d3);
                graphics2D.setClip(0, 0, n, n2);
                graphics2D.setRenderingHints(this.makeHints());
                Graphics2DProcessor graphics2DProcessor = new Graphics2DProcessor(graphics2D);
                if (!this.mCanPrintShadow) {
                    graphics2DProcessor.setNoShadowPrint(true);
                }
                visualization.runProcessor((ResultsProcessor)graphics2DProcessor);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            AppMgr.getAppMgr().handleOutOfMemoryCondition();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void renderWithoutScaling(Graphics2D graphics2D, PageFormat pageFormat) {
        try {
            Visualization visualization = VizCache.getCache().getVisualization((ChartItem)this.mChartItem.getCoreItem());
            if (visualization != null) {
                FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
                int n = visualization.getOutputWidth(fontRenderContext);
                int n2 = visualization.getOutputHeight(fontRenderContext);
                double d = (double)this.mMaxWidth * 1.0 / (double)n;
                double d2 = (double)this.mMaxHeight * 1.0 / (double)n2;
                double d3 = Math.min(d, d2);
                graphics2D.setClip(0, 0, n, n2);
                graphics2D.setRenderingHints(this.makeHints());
                Graphics2DProcessor graphics2DProcessor = new Graphics2DProcessor(graphics2D);
                if (!this.mCanPrintShadow) {
                    graphics2DProcessor.setNoShadowPrint(true);
                }
                visualization.runProcessor((ResultsProcessor)graphics2DProcessor);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            AppMgr.getAppMgr().handleOutOfMemoryCondition();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void render(Graphics2D graphics2D, PageFormat pageFormat, boolean bl) {
        try {
            Visualization visualization = VizCache.getCache().getVisualization((ChartItem)this.mChartItem.getCoreItem());
            if (visualization != null) {
                FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
                int n = visualization.getOutputWidth(fontRenderContext);
                int n2 = visualization.getOutputHeight(fontRenderContext);
                double d = (double)this.mMaxWidth * 1.0 / (double)n;
                double d2 = (double)this.mMaxHeight * 1.0 / (double)n2;
                double d3 = Math.min(d, d2);
                graphics2D.scale(d3, d3);
                graphics2D.setClip(0, 0, n, n2);
                graphics2D.setRenderingHints(this.makeHints());
                Graphics2DProcessor graphics2DProcessor = new Graphics2DProcessor(graphics2D);
                graphics2DProcessor.setParameter("iTextPdfBug3", (Object)Boolean.TRUE);
                if (!this.mCanPrintShadow) {
                    graphics2DProcessor.setNoShadowPrint(true);
                }
                visualization.runProcessor((ResultsProcessor)graphics2DProcessor);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            AppMgr.getAppMgr().handleOutOfMemoryCondition();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void renderWithoutScaling(Graphics2D graphics2D, PageFormat pageFormat, boolean bl) {
        try {
            Visualization visualization = VizCache.getCache().getVisualization((ChartItem)this.mChartItem.getCoreItem());
            if (visualization != null) {
                FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
                int n = visualization.getOutputWidth(fontRenderContext);
                int n2 = visualization.getOutputHeight(fontRenderContext);
                double d = (double)this.mMaxWidth * 1.0 / (double)n;
                double d2 = (double)this.mMaxHeight * 1.0 / (double)n2;
                double d3 = Math.min(d, d2);
                graphics2D.scale(d3, d3);
                graphics2D.setClip(0, 0, n, n2);
                graphics2D.setRenderingHints(this.makeHints());
                Graphics2DProcessor graphics2DProcessor = new Graphics2DProcessor(graphics2D);
                graphics2DProcessor.setParameter("iTextPdfBug3", (Object)Boolean.TRUE);
                if (!this.mCanPrintShadow) {
                    graphics2DProcessor.setNoShadowPrint(true);
                }
                visualization.runProcessor((ResultsProcessor)graphics2DProcessor);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            AppMgr.getAppMgr().handleOutOfMemoryCondition();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setCanPrintShadow(boolean bl) {
        this.mCanPrintShadow = bl;
    }

    private Map<RenderingHints.Key, Object> makeHints() {
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hashMap.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hashMap.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hashMap.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        hashMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hashMap.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        hashMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return hashMap;
    }
}

