/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.print;

import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.print.PrintOptions;
import com.spss.java_client.ui.print.SpssPrintable;
import com.spss.shared.core_tools.utils.FontUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.prefs.Preferences;

public class SyntaxViewPrintable
extends SpssPrintable {
    private String mSyntaxString;
    private SyntaxFrame mSyntaxFrame;
    private ArrayList<String> mSingleLineContents;
    private PageFormat mFormat;
    private ArrayList<Integer> mLineNo;
    private int mPageNo = -1;
    private Font mFont;

    public SyntaxViewPrintable(SyntaxFrame syntaxFrame, PrintOptions printOptions) {
        super(printOptions);
        this.mSyntaxFrame = syntaxFrame;
        this.mFormat = printOptions.getPageFormat();
        if (this.mFormat == null) {
            this.mFormat = this.createPageFormat();
        }
        printOptions.setPageFormat(this.mFormat);
    }

    @Override
    public void printInit() {
        this.mSyntaxString = this.mPrintSelection ? this.mSyntaxFrame.getSyntaxView().getSelectedText() : this.mSyntaxFrame.getSyntaxView().getSyntaxMasterPanel().getSyntaxTextPane().getText();
        if (this.mSyntaxString.equals("")) {
            this.mSyntaxString = this.mSyntaxFrame.getSyntax(SyntaxFrame.SyntaxSegment.ALL);
        }
        this.mSingleLineContents = new ArrayList();
        this.mLineNo = new ArrayList();
        this.mLineNo.add(0);
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/syntax");
        String string = preferences2.get("font_family", PrefDefaults.DEF_SYNTAX_FONT_FAMILY);
        int n = preferences2.getInt("font_style", 0);
        int n2 = preferences2.getInt("font_size", PrefDefaults.DEF_SYNTAX_FONT_SIZE);
        this.mFont = FontUtil.makeFont((String)string, (int)n, (float)n2);
        Graphics2D graphics2D = (Graphics2D)this.mSyntaxFrame.getGraphics();
        graphics2D.setFont(this.mFont);
        this.wrapSyntax(graphics2D);
        graphics2D.dispose();
    }

    public void wrapSyntax(Graphics2D graphics2D) {
        this.mSingleLineContents.clear();
        String string = this.mSyntaxString;
        int n = 0;
        boolean bl = false;
        block0: do {
            int n2;
            if ((n2 = this.mSyntaxString.indexOf("\n", n)) == -1) {
                bl = true;
                string = this.mSyntaxString.substring(n);
            } else {
                string = this.mSyntaxString.substring(n, n2);
            }
            n = n2 + 1;
            while (true) {
                String string2 = this.getWordsJustifiedInLine(graphics2D, string);
                this.mSingleLineContents.add(string2);
                if (string.equals(string2)) continue block0;
                string = string.substring(string2.length());
            }
        } while (!bl);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        PageFormat pageFormat2 = this.getPrintOPtions().getPageFormat();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.scale(this.mZoomFactor, this.mZoomFactor);
        graphics2D.setFont(this.mFont);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
        int n2 = fontMetrics.getHeight();
        float f = (float)this.mFormat.getImageableX();
        float f2 = (float)this.mFormat.getImageableY();
        f2 += (float)n2;
        int n3 = 0;
        if (n >= this.mLineNo.size()) {
            return 1;
        }
        n3 = this.mLineNo.get(n);
        int n4 = 0;
        while (n3 < this.mSingleLineContents.size()) {
            if ((double)(n4 * n2 + n2) < this.mFormat.getImageableHeight()) {
                graphics2D.drawString(this.mSingleLineContents.get(n3), f, f2);
                f2 += (float)n2;
            } else {
                if (this.mPageNo == n) break;
                this.mPageNo = n;
                if (this.mLineNo.size() - 1 > n) break;
                ++this.mNumberOfPages;
                this.mLineNo.add(n3);
                break;
            }
            ++n3;
            ++n4;
        }
        return 0;
    }

    @Override
    public void reset() {
        this.mPageNo = -1;
    }

    @Override
    public boolean hasAnySelected() {
        return this.mSyntaxFrame.getSyntaxView().isAnySelected();
    }

    private String getWordsJustifiedInLine(Graphics2D graphics2D, String string) {
        char[] cArray = string.toCharArray();
        graphics2D.setFont(this.mFont);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            stringBuffer.append(cArray[i]);
            if (this.isValidWidth(fontMetrics, stringBuffer.toString())) continue;
            if (stringBuffer.charAt(i) == ' ') {
                stringBuffer.deleteCharAt(i);
                break;
            }
            if (stringBuffer.indexOf(" ") <= 0) break;
            int n = i;
            while (stringBuffer.charAt(n) != ' ') {
                stringBuffer.deleteCharAt(n);
                --n;
            }
            break;
        }
        return stringBuffer.toString();
    }

    private boolean isValidWidth(FontMetrics fontMetrics, String string) {
        int n = fontMetrics.stringWidth(string);
        return (double)n <= this.mFormat.getImageableWidth();
    }
}

